/************************************************************
* This file is part of BxPPS Project
* Copyright (C) 2007 Produmex. All Rights Reserved.
*************************************************************/
BEGIN
	declare @cName varchar(200)
	declare @sql nvarchar(2000)
	declare @tName varchar(200)
	-- Drop BX constraints
	DECLARE c1 CURSOR FOR 
		select c.name,t.name from sysobjects  c join sysobjects t on c.parent_obj = t.id
		where (c.name like 'BxFK_%' and c.xtype = 'F')
		or (c.name like 'BxCC_%'and c.xtype = 'C')
	OPEN c1 
	FETCH NEXT FROM c1 INTO @cName, @tName
	WHILE @@FETCH_STATUS = 0 BEGIN
		set @sql = 'alter table [' + @tName + '] drop constraint [' + @cName + ']'
		print @sql
		EXEC sp_executesql @sql		
		FETCH NEXT FROM c1 INTO @cName, @tName
	END
	CLOSE c1
	DEALLOCATE c1
	-- Drop BX Triggers
	DECLARE c1 CURSOR FOR 
		select c.name,t.name from sysobjects  c join sysobjects t on c.parent_obj = t.id
		where (c.name like 'BX%') and c.xtype = 'TR' 
	OPEN c1 
	FETCH NEXT FROM c1 INTO @cName, @tName
	WHILE @@FETCH_STATUS = 0 BEGIN
		set @sql = 'drop trigger [' + @cName + ']'
		print @sql
		EXEC sp_executesql @sql		
		FETCH NEXT FROM c1 INTO @cName, @tName
	END
	CLOSE c1
	DEALLOCATE c1
	-- Drop BX Views
	DECLARE c1 CURSOR FOR 
		select [name] from sysobjects
		where ([name] like 'BX%') and xtype = 'V' 
	OPEN c1 
	FETCH NEXT FROM c1 INTO @cName
	WHILE @@FETCH_STATUS = 0 BEGIN
		set @sql = 'drop view [' + @cName + ']'
		print @sql
		EXEC sp_executesql @sql		
		FETCH NEXT FROM c1 INTO @cName
	END
	CLOSE c1
	DEALLOCATE c1
	-- Drop BX Procedures
	DECLARE c1 CURSOR FOR 
		select [name] from sysobjects
		where ([name] like 'BX%') and xtype = 'P' 
	OPEN c1 
	FETCH NEXT FROM c1 INTO @cName
	WHILE @@FETCH_STATUS = 0 BEGIN
		set @sql = 'drop procedure [' + @cName + ']'
		print @sql
		EXEC sp_executesql @sql		
		FETCH NEXT FROM c1 INTO @cName
	END
	CLOSE c1
	DEALLOCATE c1
END
