﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Transactions;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Collections;
using Produmex.Foundation.Convertors;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.GS1;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.DataObjects;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Utilities;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo;
using Produmex.Foundation.Wwf.Sbo.DataObjects;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Devices;
using Produmex.Sbo.Logex.Data.Generators.BatchNumberGenerators;
using Produmex.Sbo.Logex.Data.Generators.PackingController;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.KSTools.Providers;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace Produmex.Sbo.Logex.WorkflowScripts
{
    /// <summary>
    /// Sub-flow : Adjust sscc
    /// </summary>
    public class WorkflowScript_AfterLogisticUnitFullHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<int> LUID;


        private struct Defs
        {
            //public const string PickListTypeNotInNormalOrParcelZone = "EXPORT";
            public const double weightTresholdForNormalShipping = 40;
            public const string NormalShipZoneCode = "EXPEPALETTE";
            public const string ParcelShipZoneCode = "EXPECOLIS";
            public const string ExportShipZoneCode = "EXPEEXPORT";
            public const string SpecialOperationsShipZoneCode = "EXPEOPSPECIALE";

        }

        // Sub-flows
        // <none>


        public WorkflowScript_AfterLogisticUnitFullHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {

        }


        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {

            //Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;
            string initialErrorKey = null;
            Message msg;

            s_log.WarnFormat("AfterLogisticUnitFullHookScript called for LUID '{0}' on device '{1}'", LUID.Get().ToString(), session.DeviceInstanceId);


            string deviceID = session.DeviceInstanceId;
            PmxOseWarehouseInfo whsInfo = sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), deviceID);
            PmxOseWarehouseInfo whsInfoDevice = sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), deviceID);
            BuildQuery.LocationFilter selectLocationFilter = BuildQuery.LocationFilter.Default;

            DataSet dsProductsOnSSCC = null;
            Collection<string> itemCodes = null;
            Collection<MoveItemInfo> moveItemInfoList = new Collection<MoveItemInfo>();
            int? fullLUID = null;
            Collection<DocumentRef> list = null;

            string enteredDestinationLocationCode = null;
            string destinationLocationCode = null;
            string destinationPmxWhsCode = null;
            string destinationZoneType = null;
            DataSet dsLocations = null;

            Random rand = new Random();
            DataSet ds = null;

            Collection<string> listOfPickListTypesForExport = new Collection<string>();
            Collection<string> listOfPickListTypesForSpecialOperations = new Collection<string>();

            sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                    delegate(PmxDbConnection conn, object[] parameters)
                    {
                        PmxGeneralProviderKST prov = new PmxGeneralProviderKST(conn);

                        listOfPickListTypesForExport = prov.GetListOfPickListTypesForExport();
                        listOfPickListTypesForSpecialOperations = prov.GetListOfPickListTypesForSpecialOperations();

						s_log.InfoFormat("Number of special operations pick list types: {0}", listOfPickListTypesForSpecialOperations.Count);

                        return null;
                    });



            goto Step_GetInfoFromPicklistForLuid;

        Step_GetInfoFromPicklistForLuid:

            #region GET INFO FROM PICKLIST/WAVE FOR LUID AND SET LOCATION LIST

            string query = null;
            DataSet dsDestinationStorLocs;

            //Get pick object type for picking
            query = BuildQuery.GetPickObjectTypeFromLUID(LUID.Get());
            ds = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(ds) == 0 ||
                Convert.ToString(ds.Tables[0].Rows[0][PmxPickListTable.Columns.PickObjType.NAME]) == PmxPickObjectTypeColumnValues.Production.VALUE)
            {
                //Nothing to do
                return;
            }

            //Get current location of LUID, for WHS info
            query = BuildQuery.GetProductOnSSCC(LUID.Get());
            dsProductsOnSSCC = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsProductsOnSSCC) == 0)
            {
                //Nothing to do
                return;
            }

            if (this.GetNumberOfRows(dsProductsOnSSCC) > 0)
            {
                //Get correct warehouse info
                whsInfo = sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null,
                    new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), dsProductsOnSSCC.Tables[0].Rows[0][PmxInventoryTotalTable.Columns.StorLocCode.NAME] as string);
            }


            // get info from picklistdocentry where other stock is
            // we do not look for the location of the LUID because it will be the dock
			query = BuildQuery.GetStorLocCodeForOtherLuidsFromPicklist(LUID.Get());
            dsDestinationStorLocs = sboProviderService.RunView(false, null, null, query);
            List<string> tempLocationList = new List<string>();
            int pickListDocEntry = 0;

            if (this.GetNumberOfRows(dsDestinationStorLocs) > 0)
            {
				s_log.InfoFormat("Found locations for other LUID for current LUID {0}", LUID.Get());
                foreach (DataRow row in dsDestinationStorLocs.Tables[0].Rows)
                {
                    string storLocCode = row[PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME].ToString();

                    if (!tempLocationList.Contains(storLocCode))
                    {
                        tempLocationList.Add(storLocCode);
                    }
                }

                goto Step_PrepareMove;
            }
            else
            {
                destinationZoneType = null;

                query = BuildQuery.GetPickListTypeAndDocEntryForSSCC(LUID.Get());
                DataSet dsPicklistTypeAndDocEntry = sboProviderService.RunView(false, null, null, query);

                if (this.GetNumberOfRows(dsPicklistTypeAndDocEntry) > 0)
                {
                    //picklistType found
                    string plType = dsPicklistTypeAndDocEntry.Tables[0].Rows[0][PmxPickListTable.Columns.PickListType.NAME].ToString();
                    pickListDocEntry = int.Parse(dsPicklistTypeAndDocEntry.Tables[0].Rows[0][PmxPickListTable.Columns.DocEntry.NAME].ToString());

                    //if ( plType == Defs.PickListTypeNotInNormalOrParcelZone)
                    if (listOfPickListTypesForExport != null && listOfPickListTypesForExport.Contains(plType))
                    {
						s_log.InfoFormat("Found locations for EXPORT for current LUID {0}", LUID.Get());

                        // if type = EXPORT(def) -> propose 1 empty location in EXPORT ZONE(def)
                        query = BuildQuery.GetFirstEmptyLocationForZone(Defs.ExportShipZoneCode, whsInfo.PmxWarehouseCode);
                        DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                        if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                        {
                            // error no locations found, lookup 'not empty' location in zone
                            query = BuildQuery.GetLocationsForZone(Defs.ExportShipZoneCode, whsInfo.PmxWarehouseCode);
                            dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                        }

                        int rowNumber = rand.Next(0, dsAllowedLocation.Tables[0].Rows.Count);

                        string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[rowNumber][LocationDataSet.Columns.CODE.Name].ToString();
                        if (!tempLocationList.Contains(allowedLocationCode))
                        {
                            tempLocationList.Add(allowedLocationCode);
                        }


                        destinationZoneType = Defs.ExportShipZoneCode;

                        goto Step_PrepareMove;

                    }

                    if (listOfPickListTypesForSpecialOperations != null && listOfPickListTypesForSpecialOperations.Contains(plType))
                    {
						s_log.InfoFormat("Found locations for SPECIAL for current LUID {0}", LUID.Get());

                        query = BuildQuery.GetFirstEmptyLocationForZone(Defs.SpecialOperationsShipZoneCode, whsInfo.PmxWarehouseCode);
                        DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                        if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                        {
                            // error no locations found, lookup 'not empty' location in zone
                            query = BuildQuery.GetLocationsForZone(Defs.SpecialOperationsShipZoneCode, whsInfo.PmxWarehouseCode);
                            dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                        }

                        int rowNumber = rand.Next(0, dsAllowedLocation.Tables[0].Rows.Count);

                        string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[rowNumber][LocationDataSet.Columns.CODE.Name].ToString();
                        if (!tempLocationList.Contains(allowedLocationCode))
                        {
                            tempLocationList.Add(allowedLocationCode);
                        }


                        destinationZoneType = Defs.SpecialOperationsShipZoneCode;

                        goto Step_PrepareMove;

                    }

                    // picklist type is NOT EXPORT OR SPECIAL OPERATIONS -> check for item UDF (AllowedParcel)
                    // query all items on picklist
                    query = BuildQuery.GetAllItemsFromPicklistWave(pickListDocEntry);
                    DataSet dsItems = sboProviderService.RunView(false, null, null, query);

                    // foreach item , check UDF , all=Y -> Parcel, 1=N -> Normal
                    foreach (DataRow row in dsItems.Tables[0].Rows)
                    {
                        string allowedOnParcel = row[PmxItemTableKST.Columns.AllowedOnParcel.NAME].ToString();

                        // IF 1 item UDF = N -> Normal Zone 
                        // ELSE (so all item UDF = Y) -> Parcel Zone
                        if (allowedOnParcel == SboBooleanColumnValues.N.VALUE)
                        {
							s_log.InfoFormat("Found locations for NOT ALLOWED ON PARCEL for current LUID {0}", LUID.Get());

                            query = BuildQuery.GetFirstEmptyLocationForZone(Defs.NormalShipZoneCode, whsInfo.PmxWarehouseCode);
                            DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                            if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                            {
                                // error no locations found, lookup 'not empty' location in zone
                                query = BuildQuery.GetLocationsForZone(Defs.NormalShipZoneCode, whsInfo.PmxWarehouseCode);
                                dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                            }

                            int rowNumber = rand.Next(0, dsAllowedLocation.Tables[0].Rows.Count);

                            string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[rowNumber][LocationDataSet.Columns.CODE.Name].ToString();
                            if (!tempLocationList.Contains(allowedLocationCode))
                            {
                                tempLocationList.Add(allowedLocationCode);
                            }

                            destinationZoneType = Defs.NormalShipZoneCode;

                            goto Step_PrepareMove;

                        }

                    } // end foreach

                    // we can presume all items are allowed on Parcel because we are here in the code

                    double totalWeightOnPickListInKg = 0;

                    // add weight of every item to total
                    foreach (DataRow row in dsItems.Tables[0].Rows)
                    {
                        double lineWeight = GetLineTotalWeightInKg(Convert.ToDouble(row[PmxPickListLineTable.Columns.Quantity.NAME].ToString())
                            , Convert.ToDouble(row[PmxItemTableKST.Columns.SalesWeight1.NAME].ToString()), Convert.ToDouble(row[SboWeightUnitTable.Columns.WeightInMG.NAME].ToString()));

                        totalWeightOnPickListInKg = totalWeightOnPickListInKg + lineWeight;
                    }

                    //check if TotalWeight if picklist is below or equal to 40KG (def)
                    //TRUE ->> PARCEL zone , FALSE ->> NORMAL ZONE
                    if (totalWeightOnPickListInKg <= Defs.weightTresholdForNormalShipping)
                    {
						s_log.InfoFormat("Found locations for PARCEL (Low weight) for current LUID {0}", LUID.Get());

                        // PARCEL ZONE TYPE
                        query = BuildQuery.GetFirstEmptyLocationForZone(Defs.ParcelShipZoneCode, whsInfo.PmxWarehouseCode);
                        DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                        if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                        {
                            // error no locations found, lookup 'not empty' location in zone
                            query = BuildQuery.GetLocationsForZone(Defs.ParcelShipZoneCode, whsInfo.PmxWarehouseCode);
                            dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                        }

                        foreach (DataRow row in dsAllowedLocation.Tables[0].Rows)
                        {
                            string allowedLocationCode = row[LocationDataSet.Columns.CODE.Name].ToString();
                            if (!tempLocationList.Contains(allowedLocationCode))
                            {
                                tempLocationList.Add(allowedLocationCode);
                            }
                        }

                        destinationZoneType = Defs.ParcelShipZoneCode;
                        goto Step_PrepareMove;
                    }
                    else
                    {
						s_log.InfoFormat("Found locations for NORMAL SHIP ZONE for current LUID {0}", LUID.Get());

                        // NORMAL ZONE TYPE
                        query = BuildQuery.GetFirstEmptyLocationForZone(Defs.NormalShipZoneCode, whsInfo.PmxWarehouseCode);
                        DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                        if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                        {
                            // error no locations found, lookup 'not empty' location in zone
                            query = BuildQuery.GetLocationsForZone(Defs.NormalShipZoneCode, whsInfo.PmxWarehouseCode);
                            dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                        }

                        int rowNumber = rand.Next(0, dsAllowedLocation.Tables[0].Rows.Count);

                        string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[rowNumber][LocationDataSet.Columns.CODE.Name].ToString();
                        if (!tempLocationList.Contains(allowedLocationCode))
                        {
                            tempLocationList.Add(allowedLocationCode);
                        }

                        destinationZoneType = Defs.NormalShipZoneCode;
                        goto Step_PrepareMove;

                    }
                }


            }

            #endregion


        Step_PrepareMove:

            #region PREPARE MOVE

            query = BuildQuery.GetProductOnSSCC(LUID.Get());
            dsProductsOnSSCC = sboProviderService.RunView(false, null, null, query);

            moveItemInfoList = new Collection<MoveItemInfo>();
            fullLUID = null;
            if (this.GetNumberOfRows(dsProductsOnSSCC) > 0)
            {
                itemCodes = new Collection<string>();
                foreach (DataRow row in dsProductsOnSSCC.Tables[0].Rows)
                {
                    string itemCode = row[PmxItemTable.Columns.ItemCode.NAME] as string;
                    if (!itemCodes.Contains(itemCode))
                    {
                        itemCodes.Add(itemCode);
                    }
                }

                Dictionary<string, PmxItemInfo> itemInfos = sboProviderService.InvokeMethodWithDbConnection<Dictionary<string, PmxItemInfo>>(false, false, null, null,
                    delegate(PmxDbConnection conn, object[] parameters)
                    {
                        PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
                        return prov.GetCachedItemInfoInDictionary(itemCodes);
                    });


                foreach (DataRow row in dsProductsOnSSCC.Tables[0].Rows)
                {
                    MoveItemInfo newItemInfo = new MoveItemInfo();

                    newItemInfo.ItemTransactionalInfoKey = Convertor.ConvertToInt32Nullable(row[PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME]);

                    newItemInfo.DestinationLogisticUnitIdentKey = Convertor.ConvertToInt32Nullable(row[PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME]);
                    newItemInfo.SourceLogisticUnitIdentKey = newItemInfo.DestinationLogisticUnitIdentKey;
                    fullLUID = newItemInfo.DestinationLogisticUnitIdentKey;

                    newItemInfo.DestinationQualityStatusCode = row[PmxInventoryTotalTable.Columns.QualityStatusCode.NAME] as string;
                    newItemInfo.ItemCode = row[PmxItemTable.Columns.ItemCode.NAME] as string;
                    newItemInfo.ItemDescription = row[PmxItemTable.Columns.ItemName.NAME] as string;
                    newItemInfo.Quantity = Convert.ToDouble(row[PmxInventoryTotalTable.Columns.Quantity.NAME]);
                    newItemInfo.SourceLocationCode = row[PmxInventoryTotalTable.Columns.StorLocCode.NAME] as string;
                    newItemInfo.SourcePmxWhsCode = row[PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME] as string;
                    newItemInfo.SourceQualityStatusCode = row[PmxInventoryTotalTable.Columns.QualityStatusCode.NAME] as string;
                    newItemInfo.Uom = row[PmxItemTable.Columns.InventoryUom.NAME] as string;
                    newItemInfo.QuantityPerUom = 1;

                    //Add to list

                    moveItemInfoList.Add(newItemInfo);

                }
            }
            goto Step_ScanDestinationLocation;
            
            #endregion


        Step_ScanDestinationLocation:

            #region SCAN DESTINATION LOCATION

            string proposedLocationCode = null;

            if (tempLocationList != null &&
                tempLocationList.Count > 0)
            {
                proposedLocationCode = tempLocationList[0];
            }

            selectLocationFilter = BuildQuery.LocationFilter.All;

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "TitleKey", "MSG_TITLE_SCAN_DESTINATION_LOCATION",
                                "DefaultLocation", proposedLocationCode,
                                "AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION", "MSG_BUTTON_SELECT_EMPTY_LOCATION"/*, "MSG_BUTTON_SELECT_NOT_FULL_LOCATION"*/ }
                                ));

            msg = WaitForMessage();

            
            initialErrorKey = null;

            if (msg.Name.EndsWith(".LocationEntered") || msg.Name.EndsWith(".ButtonClicked"))
            {
                switch (ExtractParameter<string>(msg.Parameters, "buttonKey"))
                {
                    case "MSG_BUTTON_SELECT_EMPTY_LOCATION": selectLocationFilter = BuildQuery.LocationFilter.Empty; break;
                    case "MSG_BUTTON_SELECT_NOT_FULL_LOCATION": selectLocationFilter = BuildQuery.LocationFilter.NotFull; break;
                    default: selectLocationFilter = BuildQuery.LocationFilter.Default; break;
                }

                // check if templocation has been overruled
                if (tempLocationList.Count > 0)
                {
                    // now we need to lookup the zone code for the other stock
                    query = BuildQuery.GetZoneCodeForLocation(tempLocationList[0]);
                    DataSet dsZoneCode = sboProviderService.RunView(false, null, null, query);

                    destinationZoneType = dsZoneCode.Tables[0].Rows[0][PmxOseGeneralTable.Columns.PmxZoneCode.NAME].ToString();
                }

                enteredDestinationLocationCode = null;
                if (msg.Name.EndsWith(".LocationEntered"))
                {
                    enteredDestinationLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");
                }

                query = BuildQuery.GetStorageLocationForZoneCode(enteredDestinationLocationCode, whsInfo.PmxWarehouseCode, destinationZoneType, selectLocationFilter);
                dsLocations = sboProviderService.RunView(false, null, null, query);

                if (GetNumberOfRows(dsLocations) < 1)
                {
                    initialErrorKey = "MSG_ERROR_NO_LOCATION_FOUND";
                    enteredDestinationLocationCode = null;
                    goto Step_ScanDestinationLocation;
                }
                if (!String.IsNullOrEmpty(enteredDestinationLocationCode)
                    && SystemInt32Convertor.ObjectToInt(dsLocations.Tables[0].Rows[0][LocationDataSet.Columns.FREE_SPACE_FOR_LOG_UNITS.Name], 1, 1) < 1)
                {
                    initialErrorKey = "MSG_ERROR_LOCATION_NOT_AVAILABLE";
                    enteredDestinationLocationCode = null;
                    goto Step_ScanDestinationLocation;
                }

                goto Step_SelectDestinationLocation;

            }

            // back requested
            goto Step_ScanDestinationLocation;

            #endregion


        Step_SelectDestinationLocation:

            #region SELECT DESTINATION LOCATION

            destinationLocationCode = null;
            destinationPmxWhsCode = null;

            //get list of items/quantities
            PmxDictionary<string, PmxStorageLocationCanItemBeStoredInfo> canItemBeStoredInfoPerItemCode = new PmxDictionary<string, PmxStorageLocationCanItemBeStoredInfo>();
            foreach (MoveItemInfo info in moveItemInfoList)
            {
                PmxStorageLocationCanItemBeStoredInfo entry;
                if (canItemBeStoredInfoPerItemCode.TryGetValue(info.ItemCode, out entry))
                {
                    entry.Quantity += info.Quantity;
                }
                else
                {
                    entry = new PmxStorageLocationCanItemBeStoredInfo(info.Quantity, null, null);
                    canItemBeStoredInfoPerItemCode.Add(info.ItemCode, entry);
                }
                if (info.ItemTransactionalInfoKey.HasValue)
                {
                    if (entry.ItriKeys == null) entry.ItriKeys = new List<int>();
                    entry.ItriKeys.Add(info.ItemTransactionalInfoKey.Value);
                }
            }

            //query = BuildQuery.GetLocations(tempLocationList, whsInfo.PmxWarehouseCode, deviceID);
            //DataSet dsDestinationLocations = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsLocations) == 0)
            {
                // Inform the user with the error
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "MessageKey", "MSG_ERROR_NO_LOCATION_FOUND",
                        "NoTranslationOfMessageKey", false,
                        "ShowButton", true));
                WaitForMessage();

                goto Step_SelectDestinationLocation;
            }
            

            //locations found
            if (!string.IsNullOrEmpty(enteredDestinationLocationCode) &&
                this.GetNumberOfRows(dsLocations) == 1)
            {
                destinationLocationCode = Convert.ToString(dsLocations.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name]);
                destinationPmxWhsCode = Convert.ToString(dsLocations.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name]);
                goto Step_CheckLocation;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_SELECT_DESTINATION_LOCATION",
                "LocationDS", dsLocations,
                "ShowStopButton", false));

            msg = WaitForMessage();
            // Reset latest error
            initialErrorKey = null;

            if (msg.Name.EndsWith(".LocationSelected"))
            {
                destinationLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");
                destinationPmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");

                goto Step_CheckLocation;
            }

            //go back
            goto Step_ScanDestinationLocation;

            #endregion


        Step_CheckLocation:

            #region CHECK LOCATION

            try
            {
                if (sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, new DelegateWithPmxDbConnection<bool>(ExecuteIsLocationLocked), destinationLocationCode))
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", "MSG_ERROR_DESTINATION_LOCATION_LOCKED",
                            "NoTranslationOfMessageKey", false,
                            "ShowButton", true));
                    WaitForMessage();

                    goto Step_SelectDestinationLocation;
                }

                //set location in list
                foreach (MoveItemInfo moveInfo in moveItemInfoList)
                {
                    moveInfo.DestinationLocationCode = destinationLocationCode;
                    moveInfo.DestinationPmxWhsCode = destinationPmxWhsCode;
                }//foreach

                //check if items can be stored on location
                bool canBeStored = sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, delegate(PmxDbConnection conn, object[] parameters)
                {
                    PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
                    return prov.CanItemsBeStoredOnStorageLocation(destinationLocationCode, canItemBeStoredInfoPerItemCode);
                });
                if (!canBeStored)
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", "MSG_ERROR_STORAGE_LOCATION_NOT_ALLOWED_FOR_ITEM",
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();

                    goto Step_SelectDestinationLocation;

                }
                foreach (KeyValuePair<string, PmxStorageLocationCanItemBeStoredInfo> kv in canItemBeStoredInfoPerItemCode)
                {
                    if (kv.Value.Status != PmxStorageLocationCanItemBeStored.Yes)
                    {
                        // Warn user and ask to continue
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "TitleKey", "MSG_TITLE_CONFIRM_MOVE",
                                "MessageKey", "MSG_CONFIRM_ADDING_DIFFERENT_ITEM_OR_BATCH"));
                        msg = WaitForMessage();

                        if (!msg.Name.EndsWith("IDecisionScreenReply.Yes"))
                        {
                            goto Step_SelectDestinationLocation;
                        }
                        break;
                    }
                }

                goto Step_MakeMove;
            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
                if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ExceptionHelper.Format(ExceptionHelper.Content.InnerExceptions, ex, DefaultCultureInfo.Get()),
                            "NoTranslationOfMessageKey", true,
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();

                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();
                }
                goto Step_SelectDestinationLocation;
            }

            #endregion


        Step_MakeMove:

            #region STEP MAKE MOVE

            list = null;

            try
            {
                list = sboProviderService.InvokeMethodWithDbConnection<Collection<DocumentRef>>(false, false, null, null, new DelegateWithPmxDbConnection<Collection<DocumentRef>>(ExecuteMakeAdHocMove), moveItemInfoList, fullLUID, destinationLocationCode);

            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
                if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ExceptionHelper.Format(ex, this.DefaultCultureInfo),
                            "NoTranslationOfMessageKey", true,
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();

                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();
                }

                //retry?
                //ask user if he wants to retry
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_RETRY_UPDATE",
                        "MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_WANT_RETRY"));
                msg = WaitForMessage();

                if (msg.Name.ToLower().EndsWith(".yes"))
                {
                    goto Step_MakeMove;
                }


                goto Step_SelectDestinationLocation;
            }

            //inform user
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "MessageKey", "MSG_ITEMS_MOVED",
                    "NoTranslationOfMessageKey", false,
                    "ShowButton", true));
            WaitForMessage();


            object obj = sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                    delegate(PmxDbConnection conn, object[] parameters)
                    {
                        PmxPickOperationProvider pickOpProv = new PmxPickOperationProvider(conn);
                        pickOpProv.AddPackOperation(list[0].DocEntry, conn.InternalKeySboUser );

                        return null;
                    });



            #endregion


        }
        #endregion


        #region HELPERS

        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }
            return 0;
        }


        private static Collection<DocumentRef> ExecuteMakeAdHocMove(PmxDbConnection conn, object[] parameters)
        {
            PmxMoveProvider prov = new PmxMoveProvider(conn);
            return prov.MakeAdHocMove((Collection<MoveItemInfo>)parameters[0], (int?)parameters[1], (string)parameters[2]);
        }


        /// <summary>
        /// Executes the get PMX warehouse code.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static PmxOseWarehouseInfo ExecuteGetPmxWarehouseCode(PmxDbConnection conn, object[] parameters)
        {
            PmxOseProvider oseProv = new PmxOseProvider(conn);
            return oseProv.GetPmxWarehouseInfo((string)parameters[0]);
        }


        private static bool ExecuteIsLocationLocked(PmxDbConnection conn, object[] parameters)
        {
            PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
            return prov.IsLocationLocked((string)parameters[0]);
        }


        private double GetLineTotalWeightInKg(double quantityOnLine, double weight, double UomInMG)
        {
            double totalWeightInMG = 0;
            totalWeightInMG = quantityOnLine * (weight * UomInMG);
            return (totalWeightInMG / 1000000);
        }

        #endregion


        #region BUILD QUERY

        /// <summary>
        /// Static class grouping our native queries
        /// </summary>
        private class BuildQuery
        {


            /// <summary>
            /// Gets the pick object type from luid.
            /// </summary>
            /// <param name="luid">The luid.</param>
            /// <returns></returns>
            public static string GetPickObjectTypeFromLUID(int luid)
            {

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT DISTINCT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PickObjType.NAME);

                strBuilder.Append(" FROM ");

                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME);


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocStatus.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture));


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME);

                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid, CultureInfo.InvariantCulture));



                return strBuilder.ToString();
            }

            /// <summary>
            /// Gets the stor loc code for other luids from picklist.
            /// </summary>
            /// <param name="pickListDocEntry">The pick list doc entry.</param>
            /// <returns></returns>
            public static string GetStorLocCodeForOtherLuidsFromPicklist(int luid)
            {

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT DISTINCT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME);

                strBuilder.Append(" FROM ");

                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME);


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME);

                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
                strBuilder.Append(" IN ( ");

                {
                    strBuilder.Append("SELECT DISTINCT ");

                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);

                    strBuilder.Append(" FROM ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME));

                    strBuilder.Append(" INNER JOIN ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                    strBuilder.Append(" ON ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME);
                    strBuilder.Append(" = ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
                    strBuilder.Append(" AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME);
                    strBuilder.Append(" = ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME);

                    strBuilder.Append(" INNER JOIN ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                    strBuilder.Append(" ON ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME);
                    strBuilder.Append(" = ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                    strBuilder.Append(" AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocStatus.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture));

                    strBuilder.Append(" WHERE ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid, CultureInfo.InvariantCulture));
                    strBuilder.Append(" ) ");

                }

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME);
                strBuilder.Append(" <> ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME);
                strBuilder.Append(" IN ( ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(Defs.NormalShipZoneCode, CultureInfo.InvariantCulture));
                strBuilder.Append(" , ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(Defs.ParcelShipZoneCode, CultureInfo.InvariantCulture));
                strBuilder.Append(" , ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(Defs.ExportShipZoneCode, CultureInfo.InvariantCulture));
                strBuilder.Append(" ) ");

                return strBuilder.ToString();
            }


            /// <summary>
            /// Gets the first empty location for zone.
            /// </summary>
            /// <param name="zoneCode">The zone code.</param>
            /// <returns></returns>
            public static string GetFirstEmptyLocationForZone(string zoneCode, string warehouseCode)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT   ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

                strBuilder.AppendFormat("\r\n LEFT JOIN {0}", SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME));


                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

                strBuilder.AppendFormat(" AND {0} IS NULL",
                            SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(zoneCode, CultureInfo.InvariantCulture));

                strBuilder.AppendFormat("\r\n ORDER BY {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

                return strBuilder.ToString();

            }


            /// <summary>
            /// Gets all items from picklist.
            /// </summary>
            /// <param name="pickListDocEntry">The pick list doc entry.</param>
            /// <returns></returns>
            public static string GetAllItemsFromPicklistWave(int pickListDocEntry)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.ItemCode.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTableKST.NAME, PmxItemTableKST.Columns.AllowedOnParcel.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.Quantity.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTableKST.NAME, PmxItemTableKST.Columns.SalesWeight1.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboWeightUnitTable.NAME, SboWeightUnitTable.Columns.WeightInMG.NAME);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListLineTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTableKST.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.ItemCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTableKST.NAME, PmxItemTableKST.Columns.ItemCode.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(SboWeightUnitTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTableKST.NAME, PmxItemTableKST.Columns.SalesWeight1Unit.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboWeightUnitTable.NAME, SboWeightUnitTable.Columns.UnitCode.NAME);


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME);


                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
                strBuilder.Append(" IN ( ");

                {

                    strBuilder.Append("SELECT DISTINCT ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);

                    strBuilder.Append(" FROM ");

                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListLineTable.NAME));

                    strBuilder.Append(" INNER JOIN ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                    strBuilder.Append(" ON ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                    strBuilder.Append(" = ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME);

                    strBuilder.Append(" WHERE ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pickListDocEntry, CultureInfo.InvariantCulture));

                }
                strBuilder.Append(" ) ");


                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineStatus.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture));


                return strBuilder.ToString();

            }


            public static string GetPickListTypeAndDocEntryForSSCC(int luid)
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.Append("SELECT DISTINCT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PickListType.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListLineTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME);
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineNum.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListLineNum.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);

                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid, CultureInfo.InvariantCulture));
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineStatus.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture));

                return strBuilder.ToString();
            }


            public static string GetProductOnSSCC(int luid)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemName.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemWarehouseDefaultLocationTable.NAME, PmxItemWarehouseDefaultLocationTable.Columns.DefaultLocationZone.NAME, PmxItemWarehouseDefaultLocationTable.Columns.DefaultLocationZone.NAME));


                strBuilder.Append(", ");
                strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.IsLogisticCarrier.NAME, PmxItemTable.Columns.IsLogisticCarrier.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME);

                strBuilder.Append(", SUM( ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME);
                strBuilder.Append(" ) AS ");
                strBuilder.Append(PmxInventoryTotalTable.Columns.Quantity.NAME);

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
                strBuilder.Append(" ON ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.Columns.ItemCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.Columns.ItemCode.NAME));

                strBuilder.Append(" LEFT JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME);

                strBuilder.Append(" LEFT JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);


                strBuilder.Append(" LEFT JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemWarehouseDefaultLocationTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemWarehouseDefaultLocationTable.NAME, PmxItemWarehouseDefaultLocationTable.Columns.ItemCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME);
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemWarehouseDefaultLocationTable.NAME, PmxItemWarehouseDefaultLocationTable.Columns.PmxWhsCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);

                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid, CultureInfo.InvariantCulture));

                strBuilder.Append(" GROUP BY ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemName.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemWarehouseDefaultLocationTable.NAME, PmxItemWarehouseDefaultLocationTable.Columns.DefaultLocationZone.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.IsLogisticCarrier.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);


                strBuilder.Append(" ORDER BY ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemName.NAME));
                return strBuilder.ToString();
            }


            public static string GetLocations(List<string> locationCodes, string pmxWarehouseCode, string deviceID)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME, LocationDataSet.Columns.DESCRIPTION.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, LocationDataSet.Columns.WAREHOUSECODE.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

                strBuilder.Append(" LEFT JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxUserTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.InternalKey.NAME);

                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


                if (locationCodes.Count > 0)
                {
                    strBuilder.Append(" AND ");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                    strBuilder.Append(".");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                    strBuilder.Append(" IN ( ");

                    string operand = null;

                    foreach (string locationCode in locationCodes)
                    {
                        strBuilder.Append(operand);
                        strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
                        operand = " , ";
                    }
                    strBuilder.Append(" ) ");
                }



                if (!String.IsNullOrEmpty(pmxWarehouseCode) || !String.IsNullOrEmpty(deviceID))
                {
                    strBuilder.Append(" AND ( ");
                    if (!String.IsNullOrEmpty(pmxWarehouseCode))
                    {
                        SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                        strBuilder.Append(" = ");
                        strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pmxWarehouseCode, CultureInfo.InvariantCulture));
                    }
                    if (!String.IsNullOrEmpty(deviceID))
                    {
                        if (!String.IsNullOrEmpty(pmxWarehouseCode)) strBuilder.Append(" OR ");

                        strBuilder.AppendFormat("{0} IN ( SELECT {1} FROM {2} WHERE {3} = {4} )",
                            SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME),
                            SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.PmxWarehouseCode.NAME),
                            SqlCommandHelper.EscapeTableName(PmxThinClientWarehouseTable.NAME),
                            SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.ParentCode.NAME),
                            SqlCommandHelper.FormatAndEscapeColumnValue(deviceID, CultureInfo.InvariantCulture));
                    }
                    strBuilder.Append(" )");
                }

                strBuilder.Append(" ORDER BY ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

                return strBuilder.ToString();
            }


            /// <summary>
            /// Gets the name and the code of the  location, ordered by name.
            /// </summary>
            /// <param name="locationCode">The location code.</param>
            /// <param name="warehouseCode">The warehouse code.</param>
            /// <param name="zoneTypeCodes">The zone type codes.</param>
            /// <param name="locationFilter">The location filter.</param>
            /// <returns>The sql statement to get the location</returns>
            public static string GetStorageLocationForZoneCode(string locationCode, string warehouseCode, string zoneCode, LocationFilter locationFilter)
            {
                bool isLookup = !String.IsNullOrEmpty(locationCode);
                if (isLookup)
                {
                    // This is a lookup, extra info will be returned instead of filtering
                    locationFilter = LocationFilter.All;
                }

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                strBuilder.Append(" AS ");
                strBuilder.Append(LocationDataSet.Columns.CODE.Name);

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));
                strBuilder.Append(" AS ");
                strBuilder.Append(LocationDataSet.Columns.DESCRIPTION.Name);

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                strBuilder.Append(" AS ");
                strBuilder.Append(LocationDataSet.Columns.WAREHOUSECODE.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);

                if (isLookup)
                {
                    // locationCode is provided, this is a lookup, return some info about the location

                    strBuilder.AppendFormat(", CASE COUNT( {0} ) WHEN 0 THEN 1 ELSE 0 END AS {1}",
                        SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.InternalKey.NAME),
                        SqlCommandHelper.EscapeColumnName(LocationDataSet.Columns.IS_EMPTY.Name));
                    strBuilder.AppendFormat(", {0} - COUNT( DISTINCT IFNULL( {1}, 0 ) ) AS {2}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.MaximumLogisticUnits.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME),
                        SqlCommandHelper.EscapeColumnName(LocationDataSet.Columns.FREE_SPACE_FOR_LOG_UNITS.Name));
                }

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);


                if (isLookup || locationFilter != LocationFilter.All)
                {
                    strBuilder.Append(" LEFT JOIN ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
                    strBuilder.Append(" ON ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
                    strBuilder.Append(" = ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

                    if (locationFilter == LocationFilter.NotFullAndIgnoreNonLuidStock)
                    {
                        strBuilder.AppendFormat(" AND {0} IS NOT NULL",
                            SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
                    }
                }

                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

                if (isLookup)
                {
                    strBuilder.Append(" AND ");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                    strBuilder.Append(".");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
                }

                if (warehouseCode != null &&
                    warehouseCode.Trim() != "")
                {
                    strBuilder.Append(" AND ");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
                    strBuilder.Append(".");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

                }

                if (!string.IsNullOrEmpty(zoneCode))
                {

                    strBuilder.Append(" AND ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME));
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(zoneCode, CultureInfo.InvariantCulture));

                }


                if (locationFilter == LocationFilter.Empty)
                {
                    //If there is no link to the inventory, the location is empty
                    strBuilder.Append(" AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
                    strBuilder.Append(" IS NULL ");
                }

                if (isLookup
                    || locationFilter == LocationFilter.NotFull
                    || locationFilter == LocationFilter.NotFullAndIgnoreNonLuidStock)
                {
                    strBuilder.AppendFormat("\r\n GROUP BY {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                    strBuilder.AppendFormat(", {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME));
                    strBuilder.AppendFormat(", {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                    strBuilder.AppendFormat(", {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME));
                    strBuilder.AppendFormat(", {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.MaximumLogisticUnits.NAME));
                }

                if (locationFilter == LocationFilter.NotFull)
                {
                    strBuilder.AppendFormat("\r\n HAVING ( COUNT( DISTINCT IFNULL( {0}, 0 ) ) < {1} OR {1} IS NULL )",
                        SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.MaximumLogisticUnits.NAME));
                }

                if (!isLookup)
                {
                    strBuilder.AppendFormat("\r\n ORDER BY {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME));
                }

                return strBuilder.ToString();
            }



            public static string GetZoneCodeForLocation(string locationCode)
            {

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));

                strBuilder.Append(" WHERE ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));


                return strBuilder.ToString();
            }



            /// <summary>
            /// Gets the first empty location for zone.
            /// </summary>
            /// <param name="zoneCode">The zone code.</param>
            /// <returns></returns>
            public static string GetLocationsForZone(string zoneCode, string warehouseCode)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT   ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(zoneCode, CultureInfo.InvariantCulture));

                strBuilder.AppendFormat("\r\n ORDER BY {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

                return strBuilder.ToString();

            }



            internal enum LocationFilter
            {
                All = 0,
                Empty = 1,
                NotFull = 2,
                NotFullAndIgnoreNonLuidStock = 3,

                Default = NotFull
            }

        }

        #endregion


    }


}
