﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.Tables;
using System;
using Produmex.Foundation.Collections;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_AfterLogisticUnitPackedHookScript
{
	/// <summary>
	/// This is a hook script, meant to be customized on a "per project" basis
	/// </summary>
	public class WorkflowScript_AfterLogisticUnitPackedHookScript : WorkflowInstanceScriptBase
	{
		private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

		// Input parameters * do not change *
		public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
		public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
		public ReadOnlyBinder<List<int>> LUIDs;
		public ReadOnlyBinder<Collection<int>> ListOfPickListEntries;
		public ReadOnlyBinder<int?> WaveKey;
		public ReadOnlyBinder<int?> RouteKey;

		// Output parameters * do not change *
		public ReadWriteBinder<PmxDictionary<string, object>> DeliveryData;


		// Sub-flows
		// <none>

		/// <summary>
		/// Gets the current list of pick list entries.
		/// </summary>
		/// <value>The current list of pick list entries.</value>
		private Collection<int> currentListOfPickListEntries
		{
			get
			{
				return ListOfPickListEntries == null ? null : ListOfPickListEntries.Get();
			}
		}

		/// <summary>
		/// Gets the current wave key.
		/// </summary>
		/// <value>The current wave key.</value>
		private int? currentWaveKey
		{
			get
			{
				return WaveKey == null ? null : WaveKey.Get();
			}
		}

		/// <summary>
		/// Gets the current route key.
		/// </summary>
		/// <value>The current route key.</value>
		private int? currentRouteKey
		{
			get
			{
				return RouteKey == null ? null : RouteKey.Get();
			}
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="WorkflowScript_AfterLogisticUnitPackedHookScript"/> class.
		/// </summary>
		/// <param name="parent">The parent.</param>
		/// <param name="factory">The factory.</param>
		public WorkflowScript_AfterLogisticUnitPackedHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
			: base(parent, factory)
		{
		}

		#region WorkflowInstanceScriptBase Members

		protected override void Execute()
		{
			// Parameters in scope
			Session session = GetScopeParameter("Session") as Session;
			ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

			Message msg = null;

			string query = null;
			DataSet dsSSCC = null;
			int luid = LUIDs.Get()[0];

			ToolBarButtons toolBarButtons = ToolBarButtons.None;
			string buttonKey = null;
			string initialErrorKey = null;


			bool isColli = false;
			double weight = 0;
			double? height = null;
			double? length = null;
			double? width = null;
			string transporter = null;


			DataSet ds = null;

			//Get pick object type for picking
			query = BuildQuery.GetPickObjectTypeFromLUID(luid);
			ds = sboProviderService.RunView(false, null, null, query);

			if (this.GetNumberOfRows(ds) == 0 ||
				Convert.ToString(ds.Tables[0].Rows[0][PmxPickListTable.Columns.PickObjType.NAME]) == PmxPickObjectTypeColumnValues.Production.VALUE)
			{
				//Nothing to do
				return;
			}




		Step_SelectLogisticUnitType:

			#region SELECT LOGISTIC UNIT TYPE

			isColli = false;

			// Show screen to select type of SSCC
			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"InitialErrorKey", initialErrorKey,
					"TitleKey", "MSG_KST_TITLE_SELECT_TYPE_OF_LOGISTIC_UNIT",
					"AllowedButtons", new string[] { "MSG_KST_BUTTON_COLLI", "MSG_KST_BUTTON_PALLET" },
					"EnabledToolBarButtons", toolBarButtons
					));
			msg = WaitForMessage();

			initialErrorKey = null;

			if (msg.Name.EndsWith(".BackRequested"))
			{
				goto Step_SelectLogisticUnitType;
			}
			if (msg.Name.EndsWith(".ButtonClicked"))
			{
				buttonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");

				if (buttonKey == "MSG_KST_BUTTON_COLLI")
				{
					isColli = true;
				}

			}

			goto Step_EnterWeight;

		#endregion

		Step_EnterWeight:

			#region ENTER WEIGHT

			weight = 0;
			height = null;
			length = null;
			width = null;

			//ask for quantity
			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"InitialErrorKey", initialErrorKey,
					"TitleKey", "MSG_TITLE_ENTER_WEIGHT_IN_KG",
					"InitialQuantity", 0,
					"NumberOfDigitsAfterDecimal", 2,
					"MaximumQuantity", -1,
					"UOM", "kg"
				   ));
			msg = WaitForMessage();

			//clear data
			initialErrorKey = null;

			if (msg.Name.EndsWith(".QuantityEntered"))
			{
				weight = ExtractParameter<double>(msg.Parameters, "quantity");

				if (weight == 0)
				{
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					   this.DefaultCultureInfo,
					   BuildParamCollection(
					   "MessageKey", "Cette donnée ne peut pas être nulle",
					   "NoTranslationOfMessageKey", true,
					   "ShowButton", true));
					msg = WaitForMessage();

					goto Step_EnterWeight;
				}

				if (isColli)
				{
					goto Step_AskTransporter;
				}

				goto Step_EnterHeight;
			}

			if (msg.Name.EndsWith(".BackRequested"))
			{
				goto Step_SelectLogisticUnitType;
			}

		#endregion

		Step_EnterHeight:

			#region ENTER HEIGHT



			//ask for quantity
			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"InitialErrorKey", initialErrorKey,
					"TitleKey", "MSG_TITLE_ENTER_HEIGHT_IN_CM",
					"InitialQuantity", 0,
					"NumberOfDigitsAfterDecimal", 0,
					"MaximumQuantity", -1,
					"UOM", "cm"
				   ));
			msg = WaitForMessage();

			//clear data
			initialErrorKey = null;

			if (msg.Name.EndsWith(".QuantityEntered"))
			{
				height = ExtractParameter<double>(msg.Parameters, "quantity");

				if (height == 0)
				{
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					   this.DefaultCultureInfo,
					   BuildParamCollection(
					   "MessageKey", "Cette donnée ne peut pas être nulle",
					   "NoTranslationOfMessageKey", true,
					   "ShowButton", true));
					msg = WaitForMessage();

					goto Step_EnterHeight;
				}

				goto Step_EnterWidth;
			}

			if (msg.Name.EndsWith(".BackRequested"))
			{
				goto Step_SelectLogisticUnitType;
			}

		#endregion

		Step_EnterWidth:

			#region ENTER WIDTH


			//ask for quantity
			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"InitialErrorKey", initialErrorKey,
					"TitleKey", "MSG_TITLE_ENTER_WIDTH_IN_CM",
					"InitialQuantity", 0,
					"NumberOfDigitsAfterDecimal", 0,
					"MaximumQuantity", -1,
					"UOM", "cm"
				   ));
			msg = WaitForMessage();

			//clear data
			initialErrorKey = null;

			if (msg.Name.EndsWith(".QuantityEntered"))
			{
				width = ExtractParameter<double>(msg.Parameters, "quantity");

				if (width == 0)
				{
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					   this.DefaultCultureInfo,
					   BuildParamCollection(
					   "MessageKey", "Cette donnée ne peut pas être nulle",
					   "NoTranslationOfMessageKey", true,
					   "ShowButton", true));
					msg = WaitForMessage();

					goto Step_EnterWidth;
				}

				goto Step_EnterLength;
			}

			if (msg.Name.EndsWith(".BackRequested"))
			{
				goto Step_SelectLogisticUnitType;
			}

		#endregion

		Step_EnterLength:

			#region ENTER LENGTH

			//ask for quantity
			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"InitialErrorKey", initialErrorKey,
					"TitleKey", "MSG_TITLE_ENTER_LENGTH_IN_CM",
					"InitialQuantity", 0,
					"NumberOfDigitsAfterDecimal", 0,
					"MaximumQuantity", -1,
					"UOM", "cm"
				   ));
			msg = WaitForMessage();

			//clear data
			initialErrorKey = null;

			if (msg.Name.EndsWith(".QuantityEntered"))
			{
				length = ExtractParameter<double>(msg.Parameters, "quantity");

				if (length == 0)
				{
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					   this.DefaultCultureInfo,
					   BuildParamCollection(
					   "MessageKey", "Cette donnée ne peut pas être nulle",
					   "NoTranslationOfMessageKey", true,
					   "ShowButton", true));
					msg = WaitForMessage();

					goto Step_EnterLength;
				}

				goto Step_AskTransporter;
			}

			if (msg.Name.EndsWith(".BackRequested"))
			{
				goto Step_SelectLogisticUnitType;
			}

		#endregion

		Step_AskTransporter:

			#region ASK TRANSPORTER


			//check if it is the first SSCC or not
			query = BuildQuery.GetAllLoadedSSCCOnWaveForLUID(luid, currentWaveKey, currentRouteKey, currentListOfPickListEntries);
			dsSSCC = sboProviderService.RunView(false, null, null, query);

			bool isFirstSSCC = this.GetNumberOfRows(dsSSCC) == 0;

			if (!isFirstSSCC)
			{
				foreach (DataRow row in dsSSCC.Tables[0].Rows)
				{
					if (!string.IsNullOrEmpty(row[PmxLogisticUnitIDTableKST.Columns.Transporter.NAME] as string))
					{
						transporter = row[PmxLogisticUnitIDTableKST.Columns.Transporter.NAME] as string;
						break;
					}
				}
			}


			if (string.IsNullOrEmpty(transporter) || isFirstSSCC)
			{
				query = BuildQuery.GetAllTransporters();
				DataSet dsTransporter = sboProviderService.RunView(false, null, null, query);

				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectEnterStringValueScreen),
				   DefaultCultureInfo.Get(), BuildParamCollection(
				   "InitialErrorKey", initialErrorKey,
				   "TitleKey", "MSG_TITLE_SELECT_TRANSPORTER",
				   "StringValueDS", dsTransporter,
				   "OnlySelectStringValue", true,
				   "AllowEmptyStringValue", false));
				initialErrorKey = null;

				msg = WaitForMessage();

				if (msg.Name.EndsWith(".StringValueSelected"))
				{
					transporter = ExtractParameter<string>(msg.Parameters, "stringValue");
					goto Step_UpdateData;
				}
				else
				{
					goto Step_SelectLogisticUnitType;
				}

			}

			goto Step_UpdateData;

		#endregion

		Step_UpdateData:

			#region UPDATE DATA


			sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null, new DelegateWithPmxDbConnection<object>(
					 delegate (PmxDbConnection conn, object[] parameters)
					 {
						 query = BuildQuery.UpdatePmxLUID(luid, weight, length, width, height, transporter);
						 SboRecordsetHelper.RunQueryNoReturn(s_log, query, conn);

						 return null;
					 }));


			#endregion



		}

		#endregion

		#region HELPERS

		/// <summary>
		/// Gets the number of rows.
		/// </summary>
		/// <param name="ds">The ds.</param>
		/// <returns></returns>
		private int GetNumberOfRows(DataSet ds)
		{
			if (ds != null && ds.Tables.Count > 0)
			{
				return ds.Tables[0].Rows.Count;
			}
			return 0;
		}

		#endregion

		#region QUERY

		/// <summary>
		/// Static class grouping our native queries
		/// </summary>
		private class BuildQuery
		{
			/// <summary>
			/// Gets the pick object type from luid.
			/// </summary>
			/// <param name="luid">The luid.</param>
			/// <returns></returns>
			public static string GetPickObjectTypeFromLUID(int luid)
			{

				StringBuilder strBuilder = new StringBuilder();
				strBuilder.Append("SELECT DISTINCT ");

				SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PickObjType.NAME);

				strBuilder.Append(" FROM ");

				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME));

				strBuilder.Append(" INNER JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
				strBuilder.Append(" ON ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME);


				strBuilder.Append(" INNER JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
				strBuilder.Append(" ON ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);


				strBuilder.Append(" INNER JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
				strBuilder.Append(" ON ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME);

				strBuilder.Append(" WHERE ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid, CultureInfo.InvariantCulture));



				return strBuilder.ToString();
			}

			/// <summary>
			/// Gets all loaded SSCC on wave for LUID.
			/// </summary>
			/// <param name="luid">The luid.</param>
			/// <param name="waveKey">The wave key.</param>
			/// <param name="routeKey">The route key.</param>
			/// <param name="pickListDocEntries">The pick list doc entries.</param>
			/// <returns></returns>
			public static string GetAllLoadedSSCCOnWaveForLUID(int luid, int? waveKey, int? routeKey, Collection<int> pickListDocEntries)
			{

				StringBuilder strBuilder = new StringBuilder();
				strBuilder.Append("SELECT DISTINCT ");

				SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME, SSCCDataSet.Columns.LUID.Name);
				strBuilder.Append(", ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME);

				strBuilder.Append(" FROM ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME));

				strBuilder.Append(" INNER JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
				strBuilder.Append(" ON ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME);

				strBuilder.Append(" INNER JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
				strBuilder.Append(" ON ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME);
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME);

				strBuilder.Append(" INNER JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTableKST.NAME));
				strBuilder.Append(" ON ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);


				string operand = " WHERE ";

				if (routeKey.HasValue)
				{
					strBuilder.Append(operand);
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.RouteKey.NAME);
					strBuilder.Append(" = ");
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(routeKey.Value, CultureInfo.InvariantCulture));

					operand = " AND ";
				}

				if (waveKey.HasValue)
				{
					strBuilder.Append(operand);
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
					strBuilder.Append(" = ");
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(waveKey.Value, CultureInfo.InvariantCulture));

					operand = " AND ";
				}

				if (pickListDocEntries != null &&
					pickListDocEntries.Count > 0)
				{
					strBuilder.Append(operand);
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
					strBuilder.AppendFormat(" IN ( {0} )",
						SqlCommandHelper.FormatAndEscapeColumnValue(pickListDocEntries, CultureInfo.InvariantCulture));

					operand = " AND ";
				}


				strBuilder.Append(operand);
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME);
				strBuilder.Append(" IS NOT NULL ");



				//strBuilder.Append(" WHERE ");
				//SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
				//strBuilder.Append(" IN ( ");
				//{

				//    strBuilder.Append("SELECT DISTINCT ");

				//    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);


				//    strBuilder.Append(" FROM ");
				//    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxAddSalesDeliveryNoteViewDefinition.NAME));
				//    strBuilder.Append(" INNER JOIN ");
				//    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
				//    strBuilder.Append(" ON ");
				//    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
				//    strBuilder.Append(" = ");
				//    SqlCommandHelper.AddTableColumnName(strBuilder, PmxAddSalesDeliveryNoteViewDefinition.NAME, PmxAddSalesDeliveryNoteViewDefinition.Columns.PickListLineDocEntry.NAME);
				//    strBuilder.Append(" WHERE ");
				//    SqlCommandHelper.AddTableColumnName(strBuilder, PmxAddSalesDeliveryNoteViewDefinition.NAME, PmxAddSalesDeliveryNoteViewDefinition.Columns.LogUnitIdentKey.NAME);
				//    strBuilder.Append(" = ");
				//    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid, CultureInfo.InvariantCulture));



				//}

				//strBuilder.Append(" ) ");

				return strBuilder.ToString();
			}


			/// <summary>
			/// Gets all transporters.
			/// </summary>
			/// <returns></returns>
			public static string GetAllTransporters()
			{

				StringBuilder strBuilder = new StringBuilder();
				strBuilder.Append("SELECT DISTINCT ");

				SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxTransporterTable.NAME, PmxTransporterTable.Columns.Code.NAME, StringValueDataSet.Columns.STRING_VALUE.Name);


				strBuilder.Append(" FROM ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxTransporterTable.NAME));

				strBuilder.Append(" WHERE ");
				strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxTransporterTable.NAME, PmxTransporterTable.Columns.Active.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

				return strBuilder.ToString();
			}


			/// <summary>
			/// Updates the PMX LUID.
			/// </summary>
			/// <param name="luid">The luid.</param>
			/// <param name="weight">The weight.</param>
			/// <param name="length">The length.</param>
			/// <param name="width">The width.</param>
			/// <param name="height">The height.</param>
			/// <param name="transporter">The transporter.</param>
			/// <returns></returns>
			public static string UpdatePmxLUID(int luid, double weight, double? length, double? width, double? height, string transporter)
			{

				StringBuilder strBuilder = new StringBuilder();
				strBuilder.Append("UPDATE ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));

				strBuilder.Append(" SET ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(weight, CultureInfo.InvariantCulture));

				if (length.HasValue)
				{
					strBuilder.Append(", ");
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Length.NAME);
					strBuilder.Append(" = ");
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(length.Value, CultureInfo.InvariantCulture));
				}

				if (width.HasValue)
				{
					strBuilder.Append(", ");
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Width.NAME);
					strBuilder.Append(" = ");
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(width.Value, CultureInfo.InvariantCulture));
				}

				if (height.HasValue)
				{
					strBuilder.Append(", ");
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Height.NAME);
					strBuilder.Append(" = ");
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(height.Value, CultureInfo.InvariantCulture));
				}

				if (!string.IsNullOrEmpty(transporter))
				{
					strBuilder.Append(", ");
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME);
					strBuilder.Append(" = ");
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(transporter, CultureInfo.InvariantCulture));
				}

				strBuilder.Append(" WHERE ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid, CultureInfo.InvariantCulture));



				return strBuilder.ToString();
			}
		}

		#endregion
	}
}
