﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Providers;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_BeforePickingWaveHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_BeforePickingWaveHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<int> WaveKey;

        // Output parameters * do not change *
        public ReadWriteBinder<bool> BackRequested;

        /// <summary>
        /// Definitions
        /// </summary>
        public static class Definitions
        {
            /// <summary>
            /// 
            /// </summary>
            public const string REPORT_PATH = "WaveReportKsTools.rpt";

            /// <summary>
            /// 
            /// </summary>
            public const int NUMBER_OF_COPIES = 1;
        }

        // Sub-flows
        // <none>

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_BeforePickingWaveHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_BeforePickingWaveHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;
            //Message msg = null;


            string query = null;
            DataSet ds;            
            

        Step_PrintReport:

            #region PRINT REPORT

            //Check if report needs to be printed


            //Get current location of LUID, for WHS info
            query = BuildQuery.GetUnprintedWave(WaveKey.Get());
            ds = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(ds) > 0)
            {


                sboProviderService.InvokeMethodWithDbConnection<PmxOsePrinter>(false, false, null, null,
                    delegate(PmxDbConnection conn, object[] parameters)
                    {
                        PmxPrintReportProvider prov = new PmxPrintReportProvider(conn);

                        Collection<ReportParameter> reportParameters = new Collection<ReportParameter>();
                        reportParameters.Add(new ReportParameter("@waveKey", WaveKey.Get()));

                        return prov.PrintReport(reportParameters, Definitions.REPORT_PATH, Definitions.NUMBER_OF_COPIES, session.DeviceInstanceId, null, false);

                    });
            }

            //session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
            //DefaultCultureInfo.Get(), BuildParamCollection(
            //    "MessageKey", "MSG_QUESTION_REPRINT_DOCUMENT",
            //    "TitleKey", "MSG_TITLE_REPRINT_DOCUMENT"));

            //msg = WaitForMessage();

            //if (msg.Name.EndsWith(".Yes"))
            //{
            //    goto Step_PrintReport;
            //}

            #endregion


        }

        #endregion

        #region HELPERS


        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }
            return 0;
        }


        #endregion

        #region QUERY

               /// <summary>
        /// Static class grouping our native queries
        /// </summary>
        private class BuildQuery
        {


            /// <summary>
            /// Gets the unprinted wave.
            /// </summary>
            /// <param name="waveKey">The wave key.</param>
            /// <returns></returns>
            public static string GetUnprintedWave(int waveKey)
            {

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxWaveTable.NAME, PmxWaveTable.Columns.InternalKey.NAME);

                strBuilder.Append(" FROM ");

                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxWaveTable.NAME));

                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxWaveTable.NAME, PmxWaveTable.Columns.ItemLabelsPrinted.NAME);
               
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxWaveTable.NAME, PmxWaveTable.Columns.InternalKey.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(waveKey, CultureInfo.InvariantCulture));

              

                return strBuilder.ToString();
            }

        }

        #endregion
    }
}
