﻿using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.Tables;
using System;
using Produmex.Sbo.Logex.KSTools.Providers;
using Produmex.Sbo.Logex.KSTools.BusinessObjects;
using Produmex.Foundation;
using Produmex.Sbo.Logex.Data.Extensions.Interfacing.Definitions;
using Produmex.Foundation.Barcode;
using Produmex.Sbo.Logex.Data.Providers;

// PmxWorkflowExecutionTypes.SUB_FLOW
namespace WorkflowScript_CheckBoxTypeScript
{
    /// <summary>
    /// Script to check box type
    /// </summary>
    public class WorkflowScript_CheckBoxTypeScript : WorkflowInstanceScriptBase
    {
        ISboProviderService m_sboProviderService;

        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;

        public ReadOnlyBinder<List<string>> MenuPath;


        // Sub-flows
        // <none>

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_DoubleCheckSSCCScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_CheckBoxTypeScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            m_sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;


            Message msg = null;

            string query = null;
            DataSet dsSSCC = null;
            string initialErrorKey = null;

            string buttonKeyShipLoadedSSCC = null;

            int? salesDeliveryDocEntry = null;
            DataSet dsDelivery = null;
            string docNum = null;
            string srcSSCC = null;

            ProdumexError pmxError = null;

            string boxCode = null;
            int? luid = null;

        Step_EnterBox:

            #region ENTER BOX

            boxCode = null;
            luid = null;

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IIdentifyGS1DataScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_WA_SCAN_BOX",
                "AllowedButtons", null,
                "ForceGS1_128", false
                ));

            msg = WaitForMessage();

            //clear data
            initialErrorKey = null;

            if (msg.Name.EndsWith(".DataEntered"))
            {
                BarcodeContainer barcodeContainerLUID = ExtractParameter<BarcodeContainer>(msg.Parameters, "data");

                //check what has been scanned
                if (barcodeContainerLUID.GS1DataObject != null && !string.IsNullOrEmpty(barcodeContainerLUID.GS1DataObject.Sscc))
                {
                    //user scanned an SSCC, take this as box code
                    boxCode = barcodeContainerLUID.GS1DataObject.Sscc;
                }
                else
                {
                    //take scanned data
                    boxCode = BarcodeHelper.GetProductIdentification(barcodeContainerLUID);
                }

                m_sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
               delegate(PmxDbConnection conn, object[] parameters)
               {
                   PmxLogisticUnitIDProvider luidProv = new PmxLogisticUnitIDProvider(conn);

                   if (PmxSSCCProvider.IsValidChecksumSSCC(boxCode))
                   {
                       int tempLUID = luidProv.GetCreateLUID(boxCode, null);

                       if (tempLUID > 0)
                       {
                           luid = tempLUID;
                       }
                   }


                   return null;
               });

                goto Step_CheckBoxType;

            }
            else if (msg.Name.EndsWith(".ButtonClicked"))
            {
                initialErrorKey = "MSG_ERROR_OPERATION_NOT_SUPPORTED";
                goto Step_EnterBox;
            }

            return;

        Step_CheckBoxType:




            query = BuildQuery.GetBoxType(boxCode);
            DataSet ds = m_sboProviderService.RunView(true, null, null, query);

            if (this.GetNumberOfRows(ds) == 0)
            {
                //BoxCodeNot Found
                initialErrorKey = "MSG_ERROR_WA_BOX_CODE_NOT_FOUND";
                goto Step_EnterBox;
            }

            string boxType = Convert.ToString(ds.Tables[0].Rows[0][PmxBoxTypeWarehouseAutomationTable.Columns.Code.NAME]);

            string text = string.Format("Le box '{1}' est du type '{0}' ", boxType, boxCode);

            // Inform the user with the error
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "MessageKey", text,
                    "NoTranslationOfMessageKey", true,
                    "IsError", false,
                    "ShowButton", true));
            WaitForMessage();

            goto Step_EnterBox;



            #endregion

        }

        #endregion

        #region HELPERS

        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }
            return 0;
        }



        #endregion

        #region BUILD QUERY

        /// <summary>
        /// Static class grouping our native queries
        /// </summary>
        private class BuildQuery
        {




            /// <summary>
            /// Gets the type of the box.
            /// </summary>
            /// <param name="boxCode">The box code.</param>
            /// <returns></returns>
            public static string GetBoxType(string boxCode)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxBoxTypeWarehouseAutomationTable.NAME, PmxBoxTypeWarehouseAutomationTable.Columns.NumberOfCompartments.NAME));

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxBoxTypeWarehouseAutomationTable.NAME, PmxBoxTypeWarehouseAutomationTable.Columns.Code.NAME));

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxBoxesForWarehouseAutomationTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxBoxTypeWarehouseAutomationTable.NAME));
                strBuilder.Append(" ON ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxBoxTypeWarehouseAutomationTable.NAME, PmxBoxTypeWarehouseAutomationTable.Columns.Code.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxBoxesForWarehouseAutomationTable.NAME, PmxBoxesForWarehouseAutomationTable.Columns.BoxType.NAME));


                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxBoxesForWarehouseAutomationTable.NAME, PmxBoxesForWarehouseAutomationTable.Columns.Code.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(boxCode, CultureInfo.InvariantCulture));


                return strBuilder.ToString();
            }



        }

        #endregion
    }
}
