﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Transactions;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.GS1;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.DataObjects;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo;
using Produmex.Foundation.Wwf.Sbo.DataObjects;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Devices;
using Produmex.Sbo.Logex.Data.Generators.BatchNumberGenerators;
using Produmex.Sbo.Logex.Data.Generators.PackingController;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Utilities;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using System.Data.Common;
using Produmex.Foundation.Data.DbClient;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace Produmex.Sbo.Logex.WorkflowScripts
{
    public class WorkflowScript_EnterPickListsForPackingHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);


        /// <summary>
        /// The default culture info
        /// </summary>
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;

        /// <summary>
        /// The PMX ose company
        /// </summary>
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;


        private CultureInfo current_DefaultCultureInfo
        {
            get { return DefaultCultureInfo.Get(); }
        }

        private PmxOseCompany currentPmxOseCompany
        {
            get { return PmxOseCompany.Get(); }
        }


        private string currentPackLine
        {
            get { return PackLineLocationCode.Get(); }

        }

        private CustomerDeliveryInfo currentCustomerDeliveryInfo
        {
            get { return CustomerDeliveryInfo.Get(); }
            set { CustomerDeliveryInfo.Set(value); }
           
        }


        /// <summary>
        /// The back requested
        /// </summary>
        public ReadWriteBinder<bool> BackRequested;

        /// <summary>
        /// The pack line location code
        /// </summary>
        public ReadOnlyBinder<string> PackLineLocationCode;


  

        /// <summary>
        /// The pick list entries
        /// </summary>
        public ReadWriteBinder<Collection<int>> PickListEntries;


        /// <summary>
        /// The customer delivery info
        /// </summary>
        public ReadWriteBinder<CustomerDeliveryInfo> CustomerDeliveryInfo;

        private string userName;
        private int userID;

        // Sub-flows
        // <none>

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_EnterPickListsForPackingHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_EnterPickListsForPackingHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        /// <summary>
        /// Executes this instance.
        /// </summary>
        protected override void Execute()
        {
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;
            string initialErrorKey = null;
            Produmex.Foundation.Messages.Message msg = null;
            //  ProdumexError pmxError = null;
            string query;
            bool luidFilledInPackingFlow = false;
            DataSet dsWaves = null;
            DataSet dsPickLists = null;
            DataSet dsUserID = null;
            int waveKey = 0;
            Collection<int> pickListEntries = null;      
            //CustomerDeliveryInfo customerDeliveryInfo = new CustomerDeliveryInfo();
            BackRequested.Set(false);
            userName = sboProviderService.GetCurrentUser().Username;
            query = BuildQuery.GetUserID(userName);
            dsUserID = sboProviderService.RunView(false, null, null, query);
            //userID = dsUserID.Tables[0].Rows[0];
            foreach (DataRow row in dsUserID.Tables[0].Rows)
            {
                userID = Convert.ToInt32(row[SboUserTable.Columns.InternalKey.NAME]);
            }

        //session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
        //    this.DefaultCultureInfo, BuildParamCollection(
        //    "InitialErrorKey", initialErrorKey,
        //    "Title", "titlescreen",
        //    "MessageKey", "message",
        //    "ShowButton", true));
        //msg = WaitForMessage();


        Step_SelectWave:

            #region SELECT WAVE:

            if (currentCustomerDeliveryInfo == null)
            {
                currentCustomerDeliveryInfo = new CustomerDeliveryInfo();
                
            }
            

            luidFilledInPackingFlow = !StringHelper.IsNullOrEmptyOrWhitespace(Whitespace.Space, string.Concat(currentCustomerDeliveryInfo.CardCode, currentCustomerDeliveryInfo.CardName, currentCustomerDeliveryInfo.ShipToAddress, currentCustomerDeliveryInfo.ShipToAddressCode));


            query = BuildQuery.GetWavesLinkedToZoneOfLocation(currentPackLine, currentCustomerDeliveryInfo.CardCode, currentCustomerDeliveryInfo.CardName, currentCustomerDeliveryInfo.ShipToAddressCode, currentCustomerDeliveryInfo.ShipToAddress, sboProviderService.GetCurrentUser().Username, luidFilledInPackingFlow);
            dsWaves = sboProviderService.RunView(false, null, null, query);

            if (dsWaves.Tables[0].Rows.Count == 0)
            {
                pickListEntries = new Collection<int>();
                
                //CustomerDeliveryInfo.Set(currentCustomerDeliveryInfo);
                PickListEntries.Set(pickListEntries);

                // Inform the user with the error
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "MessageKey", "MSG_ERROR_NO_PICKLISTS_FOUND_FOR_PACKING_LINE",
                        "IsError", true,
                        "ShowButton", true));
                WaitForMessage();

                //Go back instead of going forward and selecting pick lists in main flow
                BackRequested.Set(true);

                return;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Picking.ISelectWaveScreen),
                this.DefaultCultureInfo, BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_SELECT_PICKLIST",
                "WaveDS", dsWaves));
            msg = WaitForMessage();
            initialErrorKey = null;

            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.Picking.ISelectWaveScreenReply.BackRequested")
            {
                BackRequested.Set(true);
                return;
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.Picking.ISelectWaveScreenReply.RefreshRequested")
            {
                goto Step_SelectWave;
            }
            if (msg.Name != "Produmex.Foundation.SlimScreen.Interfaces.Picking.ISelectWaveScreenReply.WaveSelected")
            {
                initialErrorKey = KnownMessageKeys.MSG_ERROR_OPERATION_NOT_SUPPORTED;
                goto Step_SelectWave;
            }

            waveKey = ExtractParameter<int>(msg.Parameters, "waveKey");

     

            query = BuildQuery.CheckPackingStarted(waveKey, userID);
            DataSet dsCheckPackingStarted = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsCheckPackingStarted) < 1)
            {
                // Inform the user with the error
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "MessageKey", "MSG_ERROR_SELECTED_PICKLIST_HAS_STARTED_PACKING",
                        "IsError", true,
                        "ShowButton", true));
                WaitForMessage();

                goto Step_SelectWave;
            }

            query = BuildQuery.GetPickListsFromWave(waveKey);
            dsPickLists = sboProviderService.RunView(false, null, null, query);

            pickListEntries = new Collection<int>();
            foreach (DataRow row in dsPickLists.Tables[0].Rows)
            {
                pickListEntries.Add(Convert.ToInt32(row[PmxPickListTable.Columns.DocEntry.NAME]));
            }



			Step_SelectCustomer:


            if (string.IsNullOrEmpty(currentCustomerDeliveryInfo.CardCode) ||
                string.IsNullOrEmpty(currentCustomerDeliveryInfo.CardName) ||
                string.IsNullOrEmpty(currentCustomerDeliveryInfo.ShipToAddressCode) ||
                string.IsNullOrEmpty(currentCustomerDeliveryInfo.ShipToAddress))
            {

                currentCustomerDeliveryInfo = new CustomerDeliveryInfo();

                //Check if there are multiple clients

                query = BuildQuery.GetCustomersForWave(waveKey);
                DataSet dsCustomersOnWave = sboProviderService.RunView(false, null, null, query);

                if (this.GetNumberOfRows(dsCustomersOnWave) == 0)
                {
                    //This should not happen
                    goto Step_SelectWave;
                }

                if (this.GetNumberOfRows(dsCustomersOnWave) == 1)
                {


                    if (this.GetNumberOfRows(dsCustomersOnWave) > 0)
                    {
                        DataRow row = dsCustomersOnWave.Tables[0].Rows[0];

                        currentCustomerDeliveryInfo.CardName = row[CustomerAddressDataSet.Columns.CUSTOMER_NAME.Name] as string;
                        currentCustomerDeliveryInfo.CardCode = row[CustomerAddressDataSet.Columns.CUSTOMER_CODE.Name] as string;
                        currentCustomerDeliveryInfo.ShipToAddress = row[CustomerAddressDataSet.Columns.ADDRESS.Name] as string;
                        currentCustomerDeliveryInfo.ShipToAddressCode = row[CustomerAddressDataSet.Columns.ADDRESS_CODE.Name] as string;
                        currentCustomerDeliveryInfo.MoveToWarehouse = row[CustomerAddressDataSet.Columns.MOVE_TO_WAREHOUSE.Name] as string;

                    }

                }
                else
                {
                    //select one

                    // Show screen with list
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectCustomerAddressScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "InitialErrorKey", initialErrorKey,
                            "TitleKey", "MSG_TITLE_SELECT_CUSTOMER_ADDRESS",
                            "CustomerAddressDS", dsCustomersOnWave
                            ));
                    msg = WaitForMessage();

                    initialErrorKey = null;


                    if (msg.Name.EndsWith(".CustomerAddressSelected"))
                    {

                        currentCustomerDeliveryInfo.CardCode = ExtractParameter<string>(msg.Parameters, "customerCode");
                        currentCustomerDeliveryInfo.CardName = ExtractParameter<string>(msg.Parameters, "customerName");
                        currentCustomerDeliveryInfo.ShipToAddress = ExtractParameter<string>(msg.Parameters, "address");
                        currentCustomerDeliveryInfo.ShipToAddressCode = ExtractParameter<string>(msg.Parameters, "addressCode");
                        currentCustomerDeliveryInfo.MoveToWarehouse = ExtractParameter<string>(msg.Parameters, "moveToWarehouse");


                    }
                    else
                    {
                        //go back
                        goto Step_SelectWave;
                    }
                }

            }

            CustomerDeliveryInfo.Set(currentCustomerDeliveryInfo);
            PickListEntries.Set(pickListEntries);



			//lock the wave!!
			try
			{
				sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
				delegate (PmxDbConnection conn, object[] parameters)
				{
					PmxPickListProvider prov = new PmxPickListProvider(conn);

					prov.LockPickListsForPacking(pickListEntries);

					return null;
				});
			}
			catch (Exception ex)
			{
				//Just log
				s_log.Error(ex);
			}


			#endregion

			return;

        }

        #endregion

        #region Helpers


        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null &&
                ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }

            return 0;
        }




        #endregion
        #region BuildQuery

        /// <summary>
        /// BuildQuery 
        /// </summary>
        private static class BuildQuery
        {


            /// <summary>
            /// Gets the packing data.
            /// </summary>
            /// <param name="moveableLocation">The moveable location.</param>
            /// <returns></returns>
            public static string GetCustomersForWave(int waveKey)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT DISTINCT ");

                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.CardCode.NAME, CustomerAddressDataSet.Columns.CUSTOMER_CODE.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.CardName.NAME, CustomerAddressDataSet.Columns.CUSTOMER_NAME.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToAddress.NAME, CustomerAddressDataSet.Columns.ADDRESS.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToCode.NAME, CustomerAddressDataSet.Columns.ADDRESS_CODE.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.MoveToWarehouse.NAME, CustomerAddressDataSet.Columns.MOVE_TO_WAREHOUSE.Name);


                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));


                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocStatus.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(PmxDocumentStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture));


                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(waveKey, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PickListStatus.NAME);
                strBuilder.AppendFormat(" IN ( {0}, {1}  )",
                    SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.Picked.VALUE, CultureInfo.CurrentCulture),
                    SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.PartiallyPacked.VALUE, CultureInfo.CurrentCulture));


                strBuilder.Append(" ORDER BY ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.CardName.NAME);


                return strBuilder.ToString();
            }



            /// <summary>
            /// Gets the waves linked to zone of location.
            /// </summary>
            /// <param name="packLineLocationCode">The pack line location code.</param>
            /// <param name="cardCode">The card code.</param>
            /// <param name="cardName">Name of the card.</param>
            /// <param name="shipToAddressCode">The ship to address code.</param>
            /// <param name="shipToAddress">The ship to address.</param>
            /// <returns></returns>
            public static string GetWavesLinkedToZoneOfLocation(string packLineLocationCode, string cardCode, string cardName, string shipToAddressCode, string shipToAddress, string userName, bool luidFilledInPackingFlow)
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat("SELECT TOP 1 {0}, CAST ( {1} AS NVARCHAR ) AS \"{2}\", {3}, {4} ",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxWaveTable.NAME, PmxWaveTable.Columns.InternalKey.NAME, WaveDataSet.Columns.INTERNAL_KEY.Name),
                    SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.InternalKey.NAME),
                    SqlCommandHelper.EscapeColumnValue(WaveDataSet.Columns.INTERNAL_KEY_AS_STRING.Name),
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxWaveTable.NAME, PmxWaveTable.Columns.Description.NAME, WaveDataSet.Columns.DESCRIPTION.Name),
                    SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.DueDate.NAME)
                           );

                /*
                 *   strBuilder.Append(", CAST(");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxWaveTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxWaveTable.Columns.InternalKey.NAME));
                strBuilder.Append(" AS NVARCHAR) AS ");
                strBuilder.Append(WaveDataSet.Columns.INTERNAL_KEY_AS_STRING.Name);

                 */

                strBuilder.AppendFormat("\r\n FROM {0}",
                    SqlCommandHelper.EscapeTableName(PmxWaveTable.NAME)
                    );

                strBuilder.AppendFormat("\r\n INNER JOIN {0} on {1} = {2} AND {3} IN ( {4}, {5}",
                    SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME),
                     SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.InternalKey.NAME),
                      SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.PickListStatus.NAME),
                        SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.Picked.VALUE, CultureInfo.CurrentCulture),
                        SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.PartiallyPacked.VALUE, CultureInfo.CurrentCulture)
                    );

                if (luidFilledInPackingFlow)
                {
                    strBuilder.AppendFormat(", {0} )",
                         SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.Packed.VALUE, CultureInfo.CurrentCulture)
                         );
                }
                else
                {
                    strBuilder.Append(" ) ");
                }

                strBuilder.AppendFormat("\r\n INNER JOIN {0} on {1} = {2}",
                    SqlCommandHelper.EscapeTableName(PmxPickListLineTable.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME)
                   );

                strBuilder.AppendFormat("\r\n INNER JOIN {0} on {1} = {2} AND {3} = {4}",
                    SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineNum.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListLineNum.NAME)
                   );

                strBuilder.AppendFormat("\r\n INNER JOIN {0} on {1} = {2} AND {3} = {4}",
                    SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME)
                   );

                strBuilder.Append("\r\n LEFT JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxUserTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PackedLockedBy.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.InternalKey.NAME);

                strBuilder.AppendFormat("\r\n WHERE {0} IN {1}",
                  SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME),
                  string.Format(
                   "( SELECT {0} FROM {1} WHERE {2} IN {3} ) ",
                      SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
                      SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME),
                      SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME),
                      string.Format(
                          "( SELECT {0} FROM {1} WHERE {2} = {3} ) ",
                          SqlCommandHelper.EscapeTableColumnName(PmxLinkPackLineZoneTable.NAME, PmxLinkPackLineZoneTable.Columns.ZoneCode.NAME),
                          SqlCommandHelper.EscapeTableName(PmxLinkPackLineZoneTable.NAME),
                          SqlCommandHelper.EscapeTableColumnName(PmxLinkPackLineZoneTable.NAME, PmxLinkPackLineZoneTable.Columns.PackLineCode.NAME),
                          SqlCommandHelper.FormatAndEscapeColumnValue(packLineLocationCode, CultureInfo.CurrentCulture)
                           )
                       )
                   );

                //strBuilder.Append("\r\n AND (");
                //SqlCommandHelper.AddTableColumnName(strBuilder, PmxWaveTable.NAME, PmxWaveTable.Columns.LockedBy.NAME);
                //strBuilder.Append(" IS NULL ");
                //strBuilder.Append(" OR ");
                //SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.UserCode.NAME);
                //strBuilder.Append(" = ");
                //strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(userName, CultureInfo.InvariantCulture));
                //strBuilder.Append(") ");

                strBuilder.Append("\r\n AND (");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PackedLockedBy.NAME);
                strBuilder.Append(" IS NULL ");
                strBuilder.Append(" OR ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.UserCode.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(userName, CultureInfo.InvariantCulture));
                strBuilder.Append(") ");

                //strBuilder.Append("\r\n AND (");
                //SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.LockedBy.NAME);
                //strBuilder.Append(" IS NULL ");
                //strBuilder.Append(" OR ");
                //SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.UserCode.NAME);
                //strBuilder.Append(" = ");
                //strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(userName, CultureInfo.InvariantCulture));
                //strBuilder.Append(") ");

                strBuilder.Append("\r\n AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
                strBuilder.Append(" NOT IN ( SELECT ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PickListStatus.NAME);
                strBuilder.AppendFormat(" IN ( {0}, {1} ,{2} ,{3} ) )",
                        SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.NotReady.VALUE, CultureInfo.CurrentCulture),
                        SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.Ready.VALUE, CultureInfo.CurrentCulture),
                        SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.PartiallyReady.VALUE, CultureInfo.CurrentCulture),
                        SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.PartiallyPicked.VALUE, CultureInfo.CurrentCulture)
                    );

                

                if (!string.IsNullOrEmpty(cardCode))
                {
                    strBuilder.Append("\r\n AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.CardCode.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(cardCode, CultureInfo.InvariantCulture));
                }

                if (!string.IsNullOrEmpty(cardName))
                {
                    strBuilder.Append("\r\n AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.CardName.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(cardName, CultureInfo.InvariantCulture));
                }

                //Can also be empty string!
                if (shipToAddressCode != null)
                {
                    strBuilder.Append("\r\n AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToCode.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(shipToAddressCode, CultureInfo.InvariantCulture));
                }

                //Can also be empty string!
                if (shipToAddress != null)
                {
                    strBuilder.Append("\r\n AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToAddress.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(shipToAddress, CultureInfo.InvariantCulture));
                }


                strBuilder.AppendFormat("\r\n GROUP BY {0}, {1}, {2}, {3} ",
                    SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.InternalKey.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.Description.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.DueDate.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.Priority.NAME)
                );

                strBuilder.AppendFormat("\r\n ORDER BY MAX({0}) DESC, {1}, {2}, {3} ",
                   SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.PackedLockedBy.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.Priority.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.InternalKey.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxWaveTable.NAME, PmxWaveTable.Columns.DueDate.NAME));

                return strBuilder.ToString();


                #region with DbQueryBuilder

                //DbQueryBuilder qb = dbConn.DbTool.GetQueryBuilder();

                ////packLineLocationCode = parameters[0].ToString();

                //qb.Append("SELECT ",
                //          qb.AsIdentifier(PmxWaveTable.NAME, PmxPickListTable.Columns.WaveKey.NAME, WaveDataSet.Columns.INTERNAL_KEY.Name),
                //    ", ", qb.AsIdentifier(PmxWaveTable.NAME, PmxPickListTable.Columns.WaveKey.NAME, WaveDataSet.Columns.DESCRIPTION.Name),
                //    ", ", qb.AsIdentifier(PmxWaveTable.NAME, PmxPickListTable.Columns.WaveKey.NAME, WaveDataSet.Columns.CUSTOM_DESCR.Name),
                //    ", ", qb.AsIdentifier(PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME),
                //    ", ", qb.AsIdentifier(PmxPickListTable.NAME, PmxPickListTable.Columns.PickListStatus.NAME),
                //    //", ", qb.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME),
                //    //", ", qb.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.SSCC.NAME),

                //     "\r\n FROM ", qb.AsIdentifier(PmxWaveTable.NAME),

                //     "\r\n INNER JOIN ", qb.AsIdentifier(PmxPickListTable.NAME),
                //     " ON ", qb.AsIdentifier(PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME),
                //     " = ", qb.AsIdentifier(PmxWaveTable.NAME, PmxWaveTable.Columns.InternalKey.NAME),

                //      "\r\n INNER JOIN ", qb.AsIdentifier(PmxPickListLineTable.NAME),
                //     " ON ", qb.AsIdentifier(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME),
                //     " = ", qb.AsIdentifier(PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME),

                //     "\r\n LEFT OUTER JOIN ", qb.AsIdentifier(PmxOseGeneralTable.NAME),
                //     " ON ", qb.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
                //     " = ", qb.AsIdentifier(PmxPickListTable.NAME, PmxPickListTable.Columns.DestStorLocCode.NAME),

                //     //"\r\n LEFT OUTER JOIN ", qb.AsIdentifier(PmxInventoryTotalTable.NAME),
                //     //" ON ", qb.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME),
                //     //" = ", qb.AsIdentifier(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LogUnitIdentKey.NAME),


                //     "\r\n WHERE ", qb.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
                //     " IN ",string.Format(
                //     "( SELECT {0} FROM {1} WHERE {2} IN {3} ) ",
                //        qb.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
                //        qb.AsIdentifier(PmxOseGeneralTable.NAME),
                //        qb.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME),
                //        string.Format(
                //            "( SELECT {0} FROM {1} WHERE {2} = {3} ) ",
                //            qb.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME),
                //            qb.AsIdentifier(PmxOseGeneralTable.NAME),
                //            qb.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
                //            qb.AsString(packLineLocationCode)
                //         )                 
                //     ),
                //        "\r\n AND ", qb.AsIdentifier(PmxPickListTable.NAME, PmxPickListTable.Columns.PickListStatus.NAME),
                //     " = ", qb.AsString(PmxPickListStatusColumnValues.Picked.VALUE)
                //     );


                //DbCommand dbCmd = dbConn.CreateCommand(qb);
                //DataTable tbl = new DataTable();
                //using (DbDataReader rdr = dbCmd.ExecuteReader())
                //{
                //    tbl.Load(rdr);
                //}
                //return tbl; 
                #endregion
            }

            /// <summary>
            /// Gets the picklist on customer info.
            /// </summary>
            /// <param name="cardCode">The card code.</param>
            /// <param name="cardName">Name of the card.</param>
            /// <param name="shipToAddressCode">The ship to address code.</param>
            /// <param name="shipToAddress">The ship to address.</param>
            /// <returns></returns>
            internal static string GetPicklistOnCustomerInfo(string packLine, string cardCode, string cardName, string shipToAddressCode, string shipToAddress)
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat("SELECT {0} ",
                    SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxWaveTable.Columns.InternalKey.NAME)                  
                           );

                strBuilder.AppendFormat("\r\n FROM {0}",
                  SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME)
                  );


                strBuilder.AppendFormat("\r\n INNER JOIN {0} on {1} = {2}",
                    SqlCommandHelper.EscapeTableName(PmxPickListLineTable.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME)
                   );

                strBuilder.AppendFormat("\r\n INNER JOIN {0} on {1} = {2} AND {3} = {4}",
                    SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineNum.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListLineNum.NAME)
                   );

                strBuilder.AppendFormat("\r\n INNER JOIN {0} on {1} = {2} AND {3} = {4}",
                    SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME),
                   SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME)
                   );

                strBuilder.AppendFormat("\r\n WHERE {0} IN {1}",
            SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME),
            string.Format(
             "( SELECT {0} FROM {1} WHERE {2} IN {3} ) ",
                SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
                SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME),
                SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME),
                string.Format(
                    "( SELECT {0} FROM {1} WHERE {2} = {3} ) ",
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkPackLineZoneTable.NAME, PmxLinkPackLineZoneTable.Columns.ZoneCode.NAME),
                    SqlCommandHelper.EscapeTableName(PmxLinkPackLineZoneTable.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkPackLineZoneTable.NAME, PmxLinkPackLineZoneTable.Columns.PackLineCode.NAME),
                    SqlCommandHelper.FormatAndEscapeColumnValue(packLine, CultureInfo.CurrentCulture)
                     )
                 )
             );

                if (!string.IsNullOrEmpty(cardCode))
                {
                    strBuilder.Append("\r\n AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.CardCode.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(cardCode, CultureInfo.InvariantCulture));
                }

                if (!string.IsNullOrEmpty(cardName))
                {
                    strBuilder.Append("\r\n AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.CardName.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(cardName, CultureInfo.InvariantCulture));
                }

                //Can also be empty string!
                if (shipToAddressCode != null)
                {
                    strBuilder.Append("\r\n AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToCode.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(shipToAddressCode, CultureInfo.InvariantCulture));
                }

                //Can also be empty string!
                if (shipToAddress != null)
                {
                    strBuilder.Append("\r\n AND ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToAddress.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(shipToAddress, CultureInfo.InvariantCulture));
                }


                return strBuilder.ToString();

            }

            /// <summary>
            /// Gets the pick lists from wave.
            /// </summary>
            /// <param name="waveKey">The wave key.</param>
            /// <returns></returns>
            internal static string GetPickListsFromWave(int waveKey)
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat("SELECT {0}, {1}, {2}, {3}, {4}",
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.CardCode.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.CardName.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToAddress.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToCode.NAME)
                         );

                strBuilder.AppendFormat("\r\n FROM {0}",
                    SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME)
                    );

                strBuilder.AppendFormat("\r\n WHERE {0} = {1}",
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME),
                  SqlCommandHelper.FormatAndEscapeColumnValue(waveKey, CultureInfo.InvariantCulture)
                  );

                strBuilder.AppendFormat("\r\n AND {0} = {1}",
                 SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DocStatus.NAME),
                 SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture)
                 );

                return strBuilder.ToString();

            }

            internal static string GetUserID(string name)
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat("SELECT {0} FROM {1} WHERE {2} = {3}",
                  SqlCommandHelper.EscapeTableColumnName(SboUserTable.NAME, SboUserTable.Columns.InternalKey.NAME),
                  SqlCommandHelper.EscapeTableName(SboUserTable.NAME),
                  SqlCommandHelper.EscapeTableColumnName(SboUserTable.NAME, SboUserTable.Columns.UserCode.NAME),
                  SqlCommandHelper.FormatAndEscapeColumnValue(name, CultureInfo.InvariantCulture)
                         );

                return strBuilder.ToString();
            }

            internal static string CheckPackingStarted(int waveKey, int userID)
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat("SELECT TOP 1 {0}, {1}, {2}, {3}, {4}",
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.CardCode.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.CardName.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToAddress.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.ShipToCode.NAME),
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.PackedLockedBy.NAME)
                         );

                strBuilder.AppendFormat("\r\n FROM {0}",
                    SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME)
                    );

                strBuilder.AppendFormat("\r\n WHERE {0} = {1}",
                  SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME),
                  SqlCommandHelper.FormatAndEscapeColumnValue(waveKey, CultureInfo.InvariantCulture)
                  );

                strBuilder.AppendFormat("\r\n AND {0} = {1}",
                 SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DocStatus.NAME),
                 SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture)
                 );

                strBuilder.AppendFormat("\r\n AND ({0} = {1} OR {2} IS NULL)",
                 SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.PackedLockedBy.NAME),
                 SqlCommandHelper.FormatAndEscapeColumnValue(userID, CultureInfo.InvariantCulture),
                 SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.PackedLockedBy.NAME)
                 );

                return strBuilder.ToString();
            }
        }

        #endregion
    }
}
