﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Transactions;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.GS1;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.DataObjects;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Utilities;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo;
using Produmex.Foundation.Wwf.Sbo.DataObjects;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Devices;
using Produmex.Sbo.Logex.Data.Generators.BatchNumberGenerators;
using Produmex.Sbo.Logex.Data.Generators.PackingController;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.KSTools.Providers;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace Produmex.Sbo.Logex.WorkflowScripts
{
    public class WorkflowScript_GetLocationsForWalMoveHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<int> PickListDocEntry;
        
        // Output parameters * do not change *
        public ReadWriteBinder<List<string>> AllowedLocations;


        private struct Defs
        {
            //public const string PickListTypeNotInNormalOrParcelZone = "EXPORT";
            public const double weightTresholdForNormalShipping = 40;
            public const string NormalShipZoneCode = "EXPEPALETTE";
            public const string ParcelShipZoneCode = "EXPECOLIS";
            public const string ExportShipZoneCode = "EXPEEXPORT";
            public const string SpecialOperationsShipZoneCode = "EXPEOPSPECIALE";

        }

        /// <summary>
        /// Gets or sets the allowed locations.
        /// </summary>
        /// <value>
        /// The allowed locations.
        /// </value>
        private List<string> allowedLocations
        {
            get { return AllowedLocations.Get(); }
            set { AllowedLocations.Set(value); }
        }


        public WorkflowScript_GetLocationsForWalMoveHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            //Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

            string deviceID = session.DeviceInstanceId;
            PmxOseWarehouseInfo whsInfo = sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), deviceID);
            PmxOseWarehouseInfo whsInfoDevice = sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), deviceID);
            allowedLocations = new List<string>();

            string query = null;
            DataSet dsDestinationStorLocs;
            DataSet ds = null;
            Random rand = new Random();

            Collection<string> listOfPickListTypesForExport = new Collection<string>();
            Collection<string> listOfPickListTypesForSpecialOperations = new Collection<string>();

            sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                    delegate(PmxDbConnection conn, object[] parameters)
                    {
                        PmxGeneralProviderKST prov = new PmxGeneralProviderKST(conn);

                        listOfPickListTypesForExport = prov.GetListOfPickListTypesForExport();
                        listOfPickListTypesForSpecialOperations = prov.GetListOfPickListTypesForSpecialOperations();

                        return null;
                    });



            //Get pick object type for picking
            query = BuildQuery.GetPickObjectType(PickListDocEntry.Get());
            ds = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(ds) == 0 ||
                Convert.ToString(ds.Tables[0].Rows[0][PmxPickListTable.Columns.PickObjType.NAME]) == PmxPickObjectTypeColumnValues.Production.VALUE)
            {
                //Nothing to do
                return;
            }

            whsInfo = sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), Convert.ToString(ds.Tables[0].Rows[0][PmxPickListTable.Columns.DestStorLocCode.NAME]));


            // get info from picklistdocentry where other stock is
            query = BuildQuery.GetStorLocCodeForOtherLuidsFromPicklist(PickListDocEntry);
            dsDestinationStorLocs = sboProviderService.RunView(false, null, null, query);
            List<string> tempLocationList = new List<string>();

            if (this.GetNumberOfRows(dsDestinationStorLocs) > 0)
            {
				s_log.InfoFormat("Found locations for other LUID for pick list {0}", PickListDocEntry.Get());

                // LUIDS found on other location(s)
                foreach (DataRow row in dsDestinationStorLocs.Tables[0].Rows)
                {
                    string storLocCode = row[PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME].ToString();

                    if (!tempLocationList.Contains(storLocCode))
                    {
                        tempLocationList.Add(storLocCode);
                    }
                }

                goto Step_SendList;
            }
            else
            {
                // query to get picklist type for picklist docentry
                query = BuildQuery.GetPicklistTypeForDocEntry(PickListDocEntry);
                DataSet dsPicklistType = sboProviderService.RunView(false, null, null, query);

                if (this.GetNumberOfRows(dsPicklistType) > 0)
                {
                    //picklistType found
                    string plType = dsPicklistType.Tables[0].Rows[0][PmxPickListTable.Columns.PickListType.NAME].ToString();

                    //if (plType == Defs.PickListTypeNotInNormalOrParcelZone)
                    if (listOfPickListTypesForExport != null && listOfPickListTypesForExport.Contains(plType))
                    {
						s_log.InfoFormat("Found locations for EXPORT for pick list {0}", PickListDocEntry.Get());

                        // if type = EXPORT(def) -> propose 1 empty location in EXPORT ZONE(def)
                        query = BuildQuery.GetFirstEmptyLocationForZone(Defs.ExportShipZoneCode, whsInfo.PmxWarehouseCode);
                        DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                        if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                        {
                            // error no locations found, just give all locations
                            query = BuildQuery.GetLocationsForZone(Defs.ExportShipZoneCode, whsInfo.PmxWarehouseCode);
                            dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                        }

                        string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name].ToString();
                        tempLocationList.Add(allowedLocationCode);
                        goto Step_SendList;
                    }
                    else if (listOfPickListTypesForSpecialOperations != null && listOfPickListTypesForSpecialOperations.Contains(plType))
                    {
						s_log.InfoFormat("Found locations for SPECIAL OPERATIONS for pick list {0}", PickListDocEntry.Get());

                        // if type = EXPORT(def) -> propose 1 empty location in EXPORT ZONE(def)
                        query = BuildQuery.GetFirstEmptyLocationForZone(Defs.SpecialOperationsShipZoneCode, whsInfo.PmxWarehouseCode);
                        DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                        if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                        {
                            // error no locations found, just give all locations
                            query = BuildQuery.GetLocationsForZone(Defs.SpecialOperationsShipZoneCode, whsInfo.PmxWarehouseCode);
                            dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                        }

                        string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name].ToString();
                        tempLocationList.Add(allowedLocationCode);
                        goto Step_SendList;
                    }
                    else
                    {
                        // picklist type is NOT EXPORT -> check for item UDF (AllowedParcel)
                        // query all items on picklist
                        query = BuildQuery.GetAllItemsFromPicklist(PickListDocEntry);
                        DataSet dsItems = sboProviderService.RunView(false, null, null, query);

                        // foreach item , check UDF , all=Y -> Parcel, 1=N -> Normal
                        foreach (DataRow row in dsItems.Tables[0].Rows)
                        {
                            string allowedOnParcel = row[PmxItemTableKST.Columns.AllowedOnParcel.NAME].ToString();

                            // IF 1 item UDF = N -> Normal Zone 
                            // ELSE (so all item UDF = Y) -> Parcel Zone
                            if (allowedOnParcel == SboBooleanColumnValues.N.VALUE)
                            {
								s_log.InfoFormat("Found locations for NOT ALLOWED ON PARCEL for pick list {0}", PickListDocEntry.Get());

                                query = BuildQuery.GetFirstEmptyLocationForZone(Defs.NormalShipZoneCode, whsInfo.PmxWarehouseCode);
                                DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                                if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                                {
                                    // error no locations found, just give all locations
                                    query = BuildQuery.GetLocationsForZone(Defs.NormalShipZoneCode, whsInfo.PmxWarehouseCode);
                                    dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                                }

                                int rowNumber = rand.Next(0, dsAllowedLocation.Tables[0].Rows.Count);

                                string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[rowNumber][LocationDataSet.Columns.CODE.Name].ToString();
                                if (!tempLocationList.Contains(allowedLocationCode))
                                {
                                    tempLocationList.Add(allowedLocationCode);
                                }

                               
                                goto Step_SendList;

                            }

                        } // end foreach

                        // we can presume all items are allowed on Parcel because we are here in the code

                        double totalWeightOnPickListInKg = 0;

                        // add weight of every item to total
                        foreach (DataRow row in dsItems.Tables[0].Rows)
                        {
                            double lineWeight = GetLineTotalWeightInKg(Convert.ToDouble(row[PmxPickListLineTable.Columns.Quantity.NAME].ToString())
                                , Convert.ToDouble(row[PmxItemTableKST.Columns.SalesWeight1.NAME].ToString()), Convert.ToDouble(row[SboWeightUnitTable.Columns.WeightInMG.NAME].ToString()));

                            totalWeightOnPickListInKg = totalWeightOnPickListInKg + lineWeight;
                        }

                        //check if TotalWeight if picklist is below or equal to 40KG (def)
                        //TRUE ->> PARCEL zone , FALSE ->> NORMAL ZONE
                        if (totalWeightOnPickListInKg <= Defs.weightTresholdForNormalShipping)
                        {
							s_log.InfoFormat("Found locations for PARCEL (Low weight) for pick list {0}", PickListDocEntry.Get());

                            // PARCEL ZONE TYPE
                            query = BuildQuery.GetFirstEmptyLocationForZone(Defs.ParcelShipZoneCode, whsInfo.PmxWarehouseCode);
                            DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                            if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                            {
                                // error no locations found, just give all locations
                                query = BuildQuery.GetLocationsForZone(Defs.ParcelShipZoneCode, whsInfo.PmxWarehouseCode);
                                dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                            }

                            int rowNumber = rand.Next(0, dsAllowedLocation.Tables[0].Rows.Count);

                            string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[rowNumber][LocationDataSet.Columns.CODE.Name].ToString();
                            if (!tempLocationList.Contains(allowedLocationCode))
                            {
                                tempLocationList.Add(allowedLocationCode);
                            }

                            goto Step_SendList;
                        }
                        else
                        {
							s_log.InfoFormat("Found locations for NORMAL ZONE for pick list {0}", PickListDocEntry.Get());

                            // NORMAL ZONE TYPE
                            query = BuildQuery.GetFirstEmptyLocationForZone(Defs.NormalShipZoneCode, whsInfo.PmxWarehouseCode);
                            DataSet dsAllowedLocation = sboProviderService.RunView(false, null, null, query);

                            if (this.GetNumberOfRows(dsAllowedLocation) < 1)
                            {
                                // error no locations found, just give all locations
                                query = BuildQuery.GetLocationsForZone(Defs.NormalShipZoneCode, whsInfo.PmxWarehouseCode);
                                dsAllowedLocation = sboProviderService.RunView(false, null, null, query);
                            }

                            int rowNumber = rand.Next(0, dsAllowedLocation.Tables[0].Rows.Count);

                            string allowedLocationCode = dsAllowedLocation.Tables[0].Rows[rowNumber][LocationDataSet.Columns.CODE.Name].ToString();
                            if (!tempLocationList.Contains(allowedLocationCode))
                            {
                                tempLocationList.Add(allowedLocationCode);
                            }

                            goto Step_SendList;
                        }
                    }
                }
            }


        Step_SendList:

            if (tempLocationList != null &&
                tempLocationList.Count > 0)
            {

                query = BuildQuery.GetAllLocationsOfSameZoneFromLocation(tempLocationList);
                ds = sboProviderService.RunView(false, null, null, query);
                foreach (DataRow row in ds.Tables[0].Rows)
                {
                    string storLocCode = row[LocationDataSet.Columns.CODE.Name].ToString();

                    if (!tempLocationList.Contains(storLocCode))
                    {
                        tempLocationList.Add(storLocCode);
                    }
                }

                allowedLocations = tempLocationList;
            }


        }

        #endregion


        #region HELPERS

        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }
            return 0;
        }


        /// <summary>
        /// Executes the get PMX warehouse code.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static PmxOseWarehouseInfo ExecuteGetPmxWarehouseCode(PmxDbConnection conn, object[] parameters)
        {
            PmxOseProvider oseProv = new PmxOseProvider(conn);
            return oseProv.GetPmxWarehouseInfo((string)parameters[0]);
        }


        private static bool ExecuteIsLocationLocked(PmxDbConnection conn, object[] parameters)
        {
            PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
            return prov.IsLocationLocked((string)parameters[0]);
        }


        private double GetLineTotalWeightInKg(double quantityOnLine, double weight, double UomInMG)
        {
            double totalWeightInMG = 0;
            totalWeightInMG = quantityOnLine * (weight * UomInMG);
            return (totalWeightInMG / 1000000);
        }


        #endregion


        #region BUILD QUERY

        /// <summary>
        /// Static class grouping our native queries
        /// </summary>
        private class BuildQuery
        {


            /// <summary>
            /// Gets the first empty location for zone.
            /// </summary>
            /// <param name="zoneCode">The zone code.</param>
            /// <returns></returns>
            public static string GetLocationsForZone(string zoneCode, string warehouseCode)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT   ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(zoneCode, CultureInfo.InvariantCulture));

                strBuilder.AppendFormat("\r\n ORDER BY {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

                return strBuilder.ToString();

            }



            /// <summary>
            /// Gets the type of the pick object.
            /// </summary>
            /// <param name="pickListDocEntry">The pick list document entry.</param>
            /// <returns></returns>
            public static string GetPickObjectType(int pickListDocEntry)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PickObjType.NAME);

                strBuilder.Append(", ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DestStorLocCode.NAME);


                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));

                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pickListDocEntry, CultureInfo.InvariantCulture));


                return strBuilder.ToString();
            }


            /// <summary>
            /// Gets the stor loc code for other luids from picklist.
            /// </summary>
            /// <param name="pickListDocEntry">The pick list doc entry.</param>
            /// <returns></returns>
            public static string GetStorLocCodeForOtherLuidsFromPicklist(int pickListDocEntry)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME);

                strBuilder.Append(" FROM ");

                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListLineTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkPickListLastMoveTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME);
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineNum.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListLineNum.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME);
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME);


                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
                strBuilder.Append(" IN ( ");
                {

                    strBuilder.Append("SELECT DISTINCT ");

                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);

                    strBuilder.Append(" FROM ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));

                    strBuilder.Append(" WHERE ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pickListDocEntry, CultureInfo.InvariantCulture));
                  
                }

                strBuilder.Append(" ) ");


                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.PickListLineStatus.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(PmxPickListStatusColumnValues.Picked.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineStatus.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME);
                strBuilder.Append(" IN ( ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(Defs.NormalShipZoneCode, CultureInfo.InvariantCulture));
                strBuilder.Append(" , ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(Defs.ParcelShipZoneCode, CultureInfo.InvariantCulture));
                strBuilder.Append(" , ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(Defs.ExportShipZoneCode, CultureInfo.InvariantCulture));
                strBuilder.Append(" ) ");

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationStorageLocationCode.NAME);
                strBuilder.Append(" NOT IN ( ");

                // SUBQUERY TO GET WA OUTPUT LOCATIONS

                strBuilder.Append("SELECT DISTINCT");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);


                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseAutomationTable.NAME));

                //inner join PmxOseWarehouseAutomation - PmxOseGeneral
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseAutomationTable.NAME, PmxOseWarehouseAutomationTable.Columns.OutputLocationCode.NAME);

                //inner join PmxOseWarehouseAutomation - PmxOseStorageLocation
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseAutomationTable.NAME, PmxOseWarehouseAutomationTable.Columns.OutputLocationCode.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

                strBuilder.Append(" WHERE ");
                //Warehouse Automation location must be active
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" ) ");


                return strBuilder.ToString();
            }


            /// <summary>
            /// Gets the picklist type for doc entry.
            /// </summary>
            /// <param name="pickListDocEntry">The pick list doc entry.</param>
            /// <returns></returns>
            public static string GetPicklistTypeForDocEntry(int pickListDocEntry)
            {

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PickListType.NAME);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));

                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pickListDocEntry, CultureInfo.InvariantCulture));

                return strBuilder.ToString();
            }


            /// <summary>
            /// Gets the first empty location for zone.
            /// </summary>
            /// <param name="zoneCode">The zone code.</param>
            /// <returns></returns>
            public static string GetFirstEmptyLocationForZone(string zoneCode, string warehouseCode)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

                strBuilder.AppendFormat("\r\n LEFT JOIN {0}", SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME));


                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

                strBuilder.AppendFormat(" AND {0} IS NULL",
                            SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(zoneCode, CultureInfo.InvariantCulture));

                strBuilder.AppendFormat("\r\n ORDER BY {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

                return strBuilder.ToString();

            }

            /// <summary>
            /// Gets the first empty location for zone.
            /// </summary>
            /// <param name="locationCode">The location code.</param>
            /// <returns></returns>
            public static string GetAllLocationsOfSameZoneFromLocation(IList<string> locationCodes)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT  ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append("\r\n INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);


                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME));

                {
                    strBuilder.Append(" IN ( SELECT ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME);

                    strBuilder.Append(" FROM ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));


                    strBuilder.Append(" WHERE ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME));
                    strBuilder.Append(" IN ( ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCodes, CultureInfo.InvariantCulture));
                    strBuilder.Append(" ) ) ");
                }







                strBuilder.AppendFormat("\r\n ORDER BY {0}",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

                return strBuilder.ToString();

            }


            /// <summary>
            /// Gets all items from picklist.
            /// </summary>
            /// <param name="pickListDocEntry">The pick list doc entry.</param>
            /// <returns></returns>
            public static string GetAllItemsFromPicklist(int pickListDocEntry)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.ItemCode.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTableKST.NAME, PmxItemTableKST.Columns.AllowedOnParcel.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.Quantity.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTableKST.NAME, PmxItemTableKST.Columns.SalesWeight1.NAME);
                strBuilder.Append(" , ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboWeightUnitTable.NAME, SboWeightUnitTable.Columns.WeightInMG.NAME);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListLineTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTableKST.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.ItemCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTableKST.NAME, PmxItemTableKST.Columns.ItemCode.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(SboWeightUnitTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTableKST.NAME, PmxItemTableKST.Columns.SalesWeight1Unit.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboWeightUnitTable.NAME, SboWeightUnitTable.Columns.UnitCode.NAME);

				strBuilder.Append(" INNER JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
				strBuilder.Append(" ON ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME);


                //strBuilder.Append(" WHERE ");
                //SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME);
                //strBuilder.Append(" = ");
                //strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pickListDocEntry, CultureInfo.InvariantCulture));


                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);
                strBuilder.Append(" IN ( ");
                {

                    strBuilder.Append("SELECT DISTINCT ");

                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME);

                    strBuilder.Append(" FROM ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));

                    strBuilder.Append(" WHERE ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pickListDocEntry, CultureInfo.InvariantCulture));


                }

                strBuilder.Append(" ) ");

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineStatus.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture));

                return strBuilder.ToString();

            }

        }

        #endregion

       
    }


}
