﻿

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Threading;
using Produmex.Foundation;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.Reflection;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Foundation.Utilities;

// PmxWorkflowExecutionTypes.SUB_FLOW
namespace Produmex.Sbo.Logex.WorkflowScripts
{
    public class WorkflowScript_MoveMainFlowKSToolsScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Private fields
        private CultureInfo m_defaultCultureInfo;
        private PmxOseCompany m_pmxOseCompany;


        // Input parameters
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;

        public ReadOnlyBinder<List<string>> MenuPath;


        private CultureInfo current_DefaultCultureInfo
        {
            get { return DefaultCultureInfo.Get(); }
        }

        private PmxOseCompany currentPmxOseCompany
        {
            get { return PmxOseCompany.Get(); }
        }

        // Input parameters
        // <none>

        // Output parameters
        // <none>

        // Sub-flows
        private WorkflowInstanceBase m_logOnFlow;

        // Menu options
        private class MenuOption
        {
            public string ButtonKey;
            public WorkflowInstanceBase Flow;

            public MenuOption( string buttonKey, WorkflowInstanceBase flow )
            {
                ButtonKey = buttonKey;
                Flow = flow;
            }
        };
        private List<MenuOption> m_MenuOptions = new List<MenuOption>();

        public WorkflowScript_MoveMainFlowKSToolsScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
           


        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            m_MenuOptions.Clear();
            m_MenuOptions.Add(new MenuOption("MSG_BUTTON_AD_HOC_MOVE", Create("AdHocMoveScript")));
            m_MenuOptions.Add(new MenuOption("MSG_BUTTON_MOVE_ORDER", Create("MoveOrderScript")));           
            m_MenuOptions.Add(new MenuOption("MSG_BUTTON_REPLENISH", Create("ReplenishScript")));
            m_MenuOptions.Add(new MenuOption("MSG_BUTTON_MOVE_FROM_WA_LOCATION", Create("MoveFromWALocationScript")));

            foreach (MenuOption menuOption in m_MenuOptions)
            {
                menuOption.Flow.BindParameters(
                    new ReadOnlyBinder<CultureInfo>("DefaultCultureInfo", DefaultCultureInfo),
                    new ReadOnlyBinder<PmxOseCompany>("PmxOseCompany", PmxOseCompany)
                );
            }


            // Store menu options indexed by button key
            Dictionary<string, MenuOption> menuOptionsByButtonKey = new Dictionary<string, MenuOption>();
            foreach ( MenuOption menuOption in m_MenuOptions)
            {
                menuOptionsByButtonKey[menuOption.ButtonKey] = menuOption;
            }

            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;

            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

            while ( true )
            {

                string initialErrorKey = null;

                int topMenuOptionIndex = 0;

            Step_SelectFunction:

                string[] buttonKeys = new string[ 6 ];
                int btnIdx = 0;
                for ( int i = topMenuOptionIndex; i < m_MenuOptions.Count; i++ )
                {
                    buttonKeys[ btnIdx ] = m_MenuOptions[ i ].ButtonKey;

                    if ( ++btnIdx >= 4 ) break;
                }

                ToolBarButtons toolBarButtons = ToolBarButtons.Back;
                if ( topMenuOptionIndex > 0 ) toolBarButtons |= ToolBarButtons.Back;
                if ( topMenuOptionIndex + 4 < m_MenuOptions.Count ) toolBarButtons |= ToolBarButtons.Forward;

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
                    m_defaultCultureInfo, BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_TITLE_SELECT_FUNCTION" + ( topMenuOptionIndex / 4 + 1 ).ToString(),
                    "AllowedButtons", buttonKeys,
                    "EnabledToolBarButtons", toolBarButtons,
                    "ScreenType", ScreenType.Menu,
                    "PrefixTitleKey", MenuPath.Get().ToArray()

                    ));
                Message msg = WaitForMessage();
                initialErrorKey = null;
                if ( msg.Name.EndsWith(".ButtonClicked") )
                {
                    string buttonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");
                    MenuOption menuOption;
                    if ( menuOptionsByButtonKey.TryGetValue(buttonKey, out menuOption) )
                    {
                        try
                        {
                            base.StartSubFlowAndWait(menuOption.Flow, true);
                        }
                        catch ( Exception ex )
                        {
                            s_log.Error(String.Format("Exception in workflow behind button {0}", menuOption.ButtonKey), ex);

                            ProdumexError pmxError;
                            ex = ExtractExceptionAndPmxErrorForDisplay(ex, out pmxError);

                            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                                m_defaultCultureInfo, BuildParamCollection(
                                "MessageKey", ExceptionHelper.Format( ExceptionHelper.Content.InnerExceptions, ex, DefaultCultureInfo.Get()),
                                "NoTranslationOfMessageKey", true,
                                "PmxError", pmxError,
                                "MessageAddendum", ReflectionHelper.CompactStackTrace( ex.StackTrace ),
                                "ShowButton", true,
                                "IsError", true
                                ));
                            msg = WaitForMessage();
                        }

                        goto Step_SelectFunction;
                    }
                }
                if ( msg.Name.EndsWith(".BackRequested") )
                {
                    if(topMenuOptionIndex == 0)
                    {
                        break;
                    }
                    topMenuOptionIndex = Math.Max(0, topMenuOptionIndex - 4);
                    goto Step_SelectFunction;
                }
                if ( msg.Name.EndsWith(".ForwardRequested") )
                {
                    topMenuOptionIndex += 4;
                    goto Step_SelectFunction;
                }
                if ( msg.Name.EndsWith(".StopRequested") )
                {
                    break;
                }

                initialErrorKey = "MSG_ERROR_OPERATION_NOT_SUPPORTED";
                goto Step_SelectFunction;
            }
        }

        #endregion
    }
}
