//css_ref Produmex.Foundation.SlimScreen.Interfaces;
//css_ref Produmex.Foundation.Wwf.Sbo;
//css_ref Produmex.Foundation.Data.dll;
//css_ref Produmex.Foundation.Data.Sbo.dll;
//css_ref Produmex.Foundation.dll;
//css_ref Produmex.Foundation.Sbo.dll;
//css_ref Produmex.Sbo.Logex.Data.dll;
//css_ref Produmex.Sbo.Logex.KSTools.dll;


using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Text;
using Produmex.Foundation;
using Produmex.Foundation.Convertors;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Utilities;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.KSTools.BusinessObjects;
using Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.KSTools.Providers;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_SalesDeliveryCreatedHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_SalesDeliveryCreatedHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        private struct Defs
        {
            public const string SboCountryCodeFrance = "FR";

            public const string ExapaqCode = "EXAPAQ";
            public const string ExapaqDateFormat = "dd/MM/yyyy";
            public static CultureInfo ExapaqNumberFormat = CultureInfo.InvariantCulture;
            public const string DpdCode = "DPD";


            public const string GEFCOCode = "GEFCO";
            public const string GEFCOPalCode = "GEFCOPAL";

			public const string ZIEGLERCode = "ZIEGLER";



            public const string MoryRegularCode = "MORY";
            public const string MoryGoldCode = "MORYGOLD";
            public const string MoryRegularCodeDepot2 = "MORYD2";
            public const string MoryGoldCodeDepot2 = "MORYGOLDD2";
            public const string MoryDateFormat = "yyMMdd";
            public const string GEFCODateFormat = "yyyyMMdd";
            public static CultureInfo MoryNumberFormat = CultureInfo.InvariantCulture;
            public static NumberFormatInfo GEFCONumberFormat = new NumberFormatInfo();

            public static Encoding ExportFileEncoding = Encoding.GetEncoding(1252);

            public const string MaxSalesOrderDocNum = "MAX_" + PmxSalesOrderTable.NAME + "_" + PmxSalesOrderTable.Columns.DocNum.NAME;
            public const string MinSalesDeliveryDocNum = "MIN_" + PmxSalesDeliveryNoteTable.NAME + "_" + PmxSalesDeliveryNoteTable.Columns.DocNum.NAME;

            public const string EuroPalletItemCode = "E-PAL";

            public const string IsODLNDropShipping_ColumnAlias = "IsODLNDropShipping";
            public const string IsODLNDropShipping_FunctionName = "OPT1_fnIsODLNDropShipping";
        }


        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<DocumentRef[]> DocumentRefs;

        // Output parameters
        // <none>

        // Sub-flows
        // <none>


        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_SalesDeliveryCreatedHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_SalesDeliveryCreatedHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        private ISboProviderService m_sboProviderService;

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

            //Set decimal separator.
            //Always needs to be ','
            Defs.GEFCONumberFormat.NumberDecimalSeparator = ",";

            DocumentRef[] documentRefs = DocumentRefs.Get();

            List<int> listOfSalesDeliveries = new List<int>();
            List<int> listOfStockTransfers = new List<int>();

            foreach (DocumentRef docRef in documentRefs)
            {
                if (docRef.DocType == SboObjectTypes.SalesDelivery)
                {
                    listOfSalesDeliveries.Add(docRef.DocEntry);
                }

                if (docRef.DocType == SboObjectTypes.StockTransfer)
                {
                    listOfStockTransfers.Add(docRef.DocEntry);
                }
            }

            if (listOfSalesDeliveries.Count > 0)
            {
                s_log.InfoFormat("Start sales delivery export: {0}", SqlCommandHelper.FormatAndEscapeColumnValue(listOfStockTransfers, CultureInfo.InvariantCulture));
                //Export sales deliveries
                ExportOfSalesDeliveries(listOfSalesDeliveries);
            }


            if (listOfStockTransfers.Count > 0)
            {
                s_log.InfoFormat("Start stock transfer export: {0}", SqlCommandHelper.FormatAndEscapeColumnValue(listOfStockTransfers, CultureInfo.InvariantCulture));
                //Export stock transfers
                ExportOfStockTransfers(listOfStockTransfers);
            }
        }

        #endregion

        void ExportOfSalesDeliveries(List<int> listOfSalesDeliveries)
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

            Message msg = null;

            string query = null;
            DataSet dsSSCC = null;

            //We need to add the delivered SSCC to a table to be able to later on do a double check on delivered SSCC's
            //The SSCC's only need to be double checked when this is set on the pick list type.



            DocumentRef[] documentRefs = DocumentRefs.Get();



        Step_ReEntryCheck:

            //First check if the weight for all items have been entered.
            query = BuildQuery.GetAllSSCCWithoutWeight(listOfSalesDeliveries);
            dsSSCC = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsSSCC) > 0)
            {
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                  this.DefaultCultureInfo,
                  BuildParamCollection(
                  "MessageKey", "Attention il manque des informations pour l’impression. Re-vérifier que ces informations ont été saisies maintenant?",
                  "NoTranslationOfMessageKey", true,
                  "ShowButton", true));
                msg = WaitForMessage();

                //recheck
                query = BuildQuery.GetAllSSCCWithoutWeight(listOfSalesDeliveries);
                dsSSCC = sboProviderService.RunView(false, null, null, query);

                if (this.GetNumberOfRows(dsSSCC) > 0)
                {
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "Imprimer sans toutes les informations",
                        "MessageKey", "Voulez-vous imprimer sans toutes les informations?"));
                    msg = WaitForMessage();

                    if (!msg.Name.ToLower().EndsWith(".yes"))
                    {
                        goto Step_ReEntryCheck;
                    }

                }

            }



            //get SSCC's to double check
            query = BuildQuery.GetAllSSCCToDoubleCheck(listOfSalesDeliveries);
            dsSSCC = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsSSCC) > 0)
            {
                sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                      delegate (PmxDbConnection conn, object[] parameters)
                      {
                          PmxDoubleCheckSSCCProvider checkProv = new PmxDoubleCheckSSCCProvider(conn);

                          foreach (DataRow row in dsSSCC.Tables[0].Rows)
                          {
                              using (PmxDoubleCheckSSCC check = checkProv.GetNewBO())
                              {
                                  check.BaseType = ((int)SboObjectType.SalesDeliveryNote).ToString();
                                  check.BaseEntry = Convert.ToInt32(row[PmxSalesDeliveryNoteTable.Columns.DocEntry.NAME]);
                                  check.BaseDocNum = Convert.ToInt32(row[SboSalesDeliveryNoteTable.Columns.DocNum.NAME]);
                                  check.LUID = Convert.ToInt32(row[PmxLogisticUnitIDTable.Columns.InternalKey.NAME]);
                                  check.SSCC = Convert.ToString(row[PmxLogisticUnitIDTable.Columns.SSCC.NAME]);
                                  check.IsShipped = false;


                                  checkProv.AddBO(check);
                              }
                          }
                          return null;

                      });
            }
        Step_Export:

            try
            {

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    this.DefaultCultureInfo,
                    BuildParamCollection(
                        "MessageKey", "MSG_KST_TITLE_PROCESSING_BUSY"));

                sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                    delegate (PmxDbConnection conn, object[] parameters)
                    {
                        // Get configuration
                        PmxConfigProvider cfgProv = new PmxConfigProvider(conn);
                        PmxConfig cfg = cfgProv.GetBO(PmxConfigCodes.INTERFACE_MONITOR_OUT_PATH);

                        PmxConvertorProvider cnvProv = new PmxConvertorProvider(conn);
                        IConvertor convertor = cnvProv.GetConvertor(cfg.ConvertorCode);
                        string outputPath = Convert.ToString(convertor.ConvertStringToObject(cfg.ConfigValue));

                        // Make sure directory exists
                        Directory.CreateDirectory(outputPath);

                        DataTable tbl = new DataTable();

                        query = BuildQuery.GetSalesDeliveriesForExport(listOfSalesDeliveries, conn.DbCultureInfo);
                        s_log.Error("GetSalesDeliveriesForExport: " + query);

                        DbCommand dbCmd = conn.CreateCommand(query);
                        using (DbDataReader rdr = dbCmd.ExecuteReader())
                        {
                            tbl.Load(rdr);
                        }

                        List<List<DataRow>> listOfGroupedDataRows = new List<List<DataRow>>();

                        string curFileKey = null;
                        List<DataRow> curDataRows = null;
                        foreach (DataRow row in tbl.Rows)
                        {
                            string fileKey = String.Format("{0}|{1}|{2}|{3}|{4}|{5}|{6}",
                                //row[ PmxSalesDeliveryNoteTable.Columns.CardName.NAME ],
                                row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME],
                                row[PmxCountryTableKST.Columns.ExapaqCountryCode.NAME],
                                row[SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME],
                                row[SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME],
                                row[SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME],
                                row[SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME],
                                row[PmxLogisticUnitIDTableKST.Columns.Transporter.NAME]);

                            if (curFileKey != fileKey)
                            {
                                curFileKey = fileKey;

                                curDataRows = new List<DataRow>();
                                listOfGroupedDataRows.Add(curDataRows);
                            }
                            curDataRows.Add(row);
                        }

                        ExportDataRows(listOfGroupedDataRows, outputPath, session.DeviceInstanceId);


                        return null;
                    });

            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
                if (!(ex is ProdumexException))
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ExceptionHelper.Format(ExceptionHelper.Content.InnerExceptions, ex, DefaultCultureInfo.Get()),
                            "NoTranslationOfMessageKey", true,
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();
                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();

                }

                //ask user if he wants to add another item to the list
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_RETRY_UPDATE",
                        "MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_WANT_RETRY"));
                msg = WaitForMessage();

                if (msg.Name.ToLower().EndsWith(".yes"))
                {
                    goto Step_Export;
                }
            }

        }

        void ExportOfStockTransfers(List<int> listOfStockTransfers)
        {

            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;
            string query = null;
            Message msg = null;

        Step_Export:
            try
            {

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    this.DefaultCultureInfo,
                    BuildParamCollection(
                        "MessageKey", "MSG_KST_TITLE_PROCESSING_BUSY"));

                sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                    delegate (PmxDbConnection conn, object[] parameters)
                    {
                        // Get configuration
                        PmxConfigProvider cfgProv = new PmxConfigProvider(conn);
                        PmxConfig cfg = cfgProv.GetBO(PmxConfigCodes.INTERFACE_MONITOR_OUT_PATH);

                        PmxConvertorProvider cnvProv = new PmxConvertorProvider(conn);
                        IConvertor convertor = cnvProv.GetConvertor(cfg.ConvertorCode);
                        string outputPath = Convert.ToString(convertor.ConvertStringToObject(cfg.ConfigValue));

                        // Make sure directory exists
                        Directory.CreateDirectory(outputPath);

                        DataTable tbl = new DataTable();

                        query = BuildQuery.GetStockTransfersForExport(listOfStockTransfers, conn.DbCultureInfo);
                        DbCommand dbCmd = conn.CreateCommand(query);
                        using (DbDataReader rdr = dbCmd.ExecuteReader())
                        {
                            tbl.Load(rdr);
                        }

                        List<List<DataRow>> listOfGroupedDataRows = new List<List<DataRow>>();

                        string curFileKey = null;
                        List<DataRow> curDataRows = null;
                        foreach (DataRow row in tbl.Rows)
                        {
                            string fileKey = String.Format("{0}|{1}|{2}|{3}|{4}|{5}|{6}",
                                //row[ PmxSalesDeliveryNoteTable.Columns.CardName.NAME ],
                                row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME],
                                row[PmxCountryTableKST.Columns.ExapaqCountryCode.NAME],
                                row[SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME],
                                row[SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME],
                                row[SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME],
                                row[SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME],
                                row[PmxLogisticUnitIDTableKST.Columns.Transporter.NAME]);

                            if (curFileKey != fileKey)
                            {
                                curFileKey = fileKey;

                                curDataRows = new List<DataRow>();
                                listOfGroupedDataRows.Add(curDataRows);
                            }
                            curDataRows.Add(row);
                        }

                        ExportDataRows(listOfGroupedDataRows, outputPath, session.DeviceInstanceId);
                        return null;
                    });

            }
            catch (Exception ex)
            {
                if (!(ex is ProdumexException))
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ExceptionHelper.Format(ExceptionHelper.Content.InnerExceptions, ex, DefaultCultureInfo.Get()),
                            "NoTranslationOfMessageKey", true,
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();
                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();

                }

                //ask user if he wants to add another item to the list
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_RETRY_UPDATE",
                        "MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_WANT_RETRY"));
                msg = WaitForMessage();

                if (msg.Name.ToLower().EndsWith(".yes"))
                {
                    goto Step_Export;
                }
            }

        }

        void ExportDataRows(List<List<DataRow>> listOfGroupedDataRows, string outputPath, string deviceID)

        {

            foreach (List<DataRow> dataRows in listOfGroupedDataRows)
            {
                string transporter = Convert.ToString(dataRows[0][PmxLogisticUnitIDTableKST.Columns.Transporter.NAME]);
                switch (transporter)
                {
                    case Defs.ExapaqCode:
                        ExportExapaqOrDPD(dataRows, outputPath, deviceID, "Exapaq");
                        break;
                    case Defs.DpdCode:
                        //Exapaq became DPD
                        ExportExapaqOrDPD(dataRows, outputPath, deviceID, "DPD");
                        break;
                    case Defs.MoryRegularCode:
                        ExportMory(dataRows, false, outputPath, "209134", deviceID);
                        break;
                    case Defs.MoryGoldCode:
                        ExportMory(dataRows, true, outputPath, "209134", deviceID);
                        break;
                    case Defs.MoryRegularCodeDepot2:
                        ExportMory(dataRows, false, outputPath, "654321", deviceID);
                        break;
                    case Defs.MoryGoldCodeDepot2:
                        ExportMory(dataRows, true, outputPath, "654321", deviceID);
                        break;
                    case Defs.GEFCOCode:
                        ExportGEFCO(dataRows, outputPath, "", deviceID);
                        break;
                    case Defs.GEFCOPalCode:
                        ExportGEFCO(dataRows, outputPath, "", deviceID);
                        break;
                    default:
                        if (!string.IsNullOrEmpty(transporter) && transporter.ToLower().StartsWith(Defs.ZIEGLERCode.ToLower()))
                        {
                            ExportZiegler(dataRows, outputPath, "", deviceID);
                        }
                        break;

                }
            }

        }

        void ExportGEFCO(IList<DataRow> dataRows, string outputPath, string ksToolsCustomerCode, string deviceID)
        {
            if (deviceID == "TCM4")
            {
                outputPath = Path.Combine(outputPath, "GEFCO2");
            }
            else
            {
                outputPath = Path.Combine(outputPath, "GEFCO1");
            }

            //Make sure path exists
            Directory.CreateDirectory(outputPath);

            string tmpFilePath = Path.Combine(outputPath, String.Format("{0:yyyyMMddhhmmssfff}.new", DateTime.Now));
            string outFileName;

            using (StreamWriter sw = new StreamWriter(tmpFilePath, false, Defs.ExportFileEncoding))
            {
                sw.NewLine = "\n";
                FixedWidthTextWriter writer = new FixedWidthTextWriter(sw, FixedWidthSettings.OffsetIsOneBased);

                int countColli = 0;
                double grossColliWeight = 0.0;
                int countEuroPallets = 0;
                int countLostPallets = 0;
                double grossWeight = 0.0;
                foreach (DataRow row in dataRows)
                {
                    if (Tester.IsNullOrEmpty(row[PmxLogisticUnitIDTableKST.Columns.KST_Length.NAME]))  // If Length is not filled in -> it's a collo
                    {
                        countColli++;
                        grossColliWeight += Tester.IsNullOrEmpty(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]) ? 0 : Convert.ToDouble(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]);
                    }
                    else if (String.Compare(Convert.ToString(row[PmxLogisticUnitIDTableKST.Columns.LogisticCarrierCode.NAME]), Defs.EuroPalletItemCode, true) == 0)
                    {
                        countEuroPallets++;
                    }
                    else
                    {
                        countLostPallets++;
                    }
                    grossWeight += Tester.IsNullOrEmpty(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]) ? 0 : Convert.ToDouble(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]);
                }

                //DateTime tsNow = DateTime.Now;
                //DateTime? dueDate = Convert.ToDateTime(dataRows[0][PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME]);
                //switch (tsNow.Date.DayOfWeek)
                //{
                //    case DayOfWeek.Friday:
                //    case DayOfWeek.Saturday:
                //        if ((dueDate.Value.Date - tsNow.Date).TotalDays >= 3.0)
                //        {
                //            dueDate = null;
                //        }
                //        break;
                //    default:
                //        if ((dueDate.Value.Date - tsNow.Date).TotalDays >= 2.0)
                //        {
                //            dueDate = null;
                //        }
                //        break;
                //}

                writer.WriteText(1, 1, "B");
                writer.WriteText(2, 35, Convert.ToString(dataRows[0][Defs.MinSalesDeliveryDocNum]));//Votre référence
                writer.WriteSpaces(37, 17);  //Code destinaire




                string firstAddressLine = Convert.ToString(dataRows[0][PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME]);
                string suffix = String.Format("  {0}", dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME]);
                string secondAddressLine = StringHelper.Truncate(Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME]), 35 - suffix.Length) + suffix;
                string thirdAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME]);
                if (string.IsNullOrEmpty(firstAddressLine))
                {
                    firstAddressLine = secondAddressLine;
                    secondAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME]);
                    thirdAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME]);
                }


                writer.WriteText(54, 35, firstAddressLine);//Raison sociale
                writer.WriteText(89, 35, secondAddressLine);
                writer.WriteTruncatedText(124, 35, thirdAddressLine);  // Address 2
                writer.WriteText(159, 9, Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME]));
                writer.WriteText(168, 35, Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME]));
                writer.WriteText(203, 2, Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME]));

                writer.WriteSpaces(205, 81);

                writer.WriteSpaces(286, 20);//Téléphone contact
                writer.WriteSpaces(306, 26);//Libellé marchandise

                writer.WriteSpaces(332, 7);

                writer.WriteText(339, 6, "000000");//# de colis sur support emballage de Type1
                writer.WriteText(345, 6, (countColli + countEuroPallets + countLostPallets).ToString("D6"));//Nbre Unités de Manutention (UM)
                writer.WriteText(351, 15, grossWeight.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Poids total du BL
                writer.WriteText(366, 6, countEuroPallets.ToString("D6"));//Nbre de support  emballage de Type 1
                writer.WriteText(372, 6, countLostPallets.ToString("D6"));//Nbre de support  emballage de Type 2
                writer.WriteText(378, 6, countColli.ToString("D6"));//Nbre de support  emballage de Type 3
                writer.WriteText(384, 15, 0.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Quantité taxable
                writer.WriteText(399, 15, 0.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Volume
                writer.WriteText(414, 15, 0.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Montant Contre remboursement
                writer.WriteText(429, 3, "EUR");///Devise Contre remboursement
                writer.WriteText(432, 15, 0.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Valeur à assurer
                writer.WriteText(447, 3, "EUR");//Devise Valeur à assurer
                writer.WriteText(450, 4, ksToolsCustomerCode);//Code Expéditeur

                writer.WriteSpaces(454, 35);

                writer.WriteText(489, 4, "GEFC");//Code transporteur
                writer.WriteText(493, 2, "3 ");//Code trafic
                writer.WriteSpaces(495, 70);//Instructions de livraison
                writer.WriteSpaces(565, 4);//Port/Incoterm
                writer.WriteText(569, 8, Convert.ToDateTime(dataRows[0][PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME]).ToString(Defs.GEFCODateFormat));//Date expédition
                writer.WriteSpaces(577, 8);//Date impérative de livraison
                writer.WriteSpaces(585, 8);//Date de livraison au plus tôt
                writer.WriteSpaces(593, 8);//Date de livraison au plus tard

                writer.WriteSpaces(601, 102);

                writer.WriteSpaces(703, 35);//Ville Incoterm
                writer.WriteSpaces(738, 2);//Pays Incoterm
                writer.WriteSpaces(740, 1);//Something is not correct in the desription file!! So adding additional white space
                writer.WriteSpaces(741, 3);//Code du mode d'encaissement du Contre remboursement
                writer.WriteSpaces(744, 6);//Nbre de colis sur support  emballage de Type 2
                writer.WriteSpaces(750, 6);//Nbre de colis sur support  emballage de Type 3
                writer.WriteText(756, 3, "EP ");//Type de support emballage de Type 1: We use Euro
                writer.WriteText(759, 3, "PX ");//Type de support emballage de Type 2: We use Lost
                writer.WriteText(762, 3, "CR ");//Type de support emballage de Type 3: We use Colli
                writer.WriteSpaces(765, 17);//Code Imputation
                writer.WriteSpaces(782, 3);//Type unité taxation
                writer.WriteSpaces(785, 50);//Adresse e-mail destinataire



            }

            outFileName = String.Format("GEFCO_{1}_{0:yyyyMMddhhmmssfff}.txt", DateTime.Now, deviceID);
            s_log.InfoFormat("File created: {0}", outFileName);
            File.Move(tmpFilePath, Path.Combine(outputPath, outFileName));
        }

        void ExportZiegler(IList<DataRow> dataRows, string outputPath, string ksToolsCustomerCode, string deviceID)
        {

            outputPath = Path.Combine(outputPath, "ZIEGLER");


            //Make sure path exists
            Directory.CreateDirectory(outputPath);

            string tmpFilePath = Path.Combine(outputPath, String.Format("{0:yyyyMMddhhmmssfff}.new", DateTime.Now));
            string outFileName;

            using (StreamWriter sw = new StreamWriter(tmpFilePath, false, Defs.ExportFileEncoding))
            {
                sw.NewLine = "\n";
                FixedWidthTextWriter writer = new FixedWidthTextWriter(sw, FixedWidthSettings.OffsetIsOneBased);

                int countColli = 0;
                double grossColliWeight = 0.0;
                int countEuroPallets = 0;
                int countLostPallets = 0;
                double grossWeight = 0.0;
                foreach (DataRow row in dataRows)
                {
                    if (Tester.IsNullOrEmpty(row[PmxLogisticUnitIDTableKST.Columns.KST_Length.NAME]))  // If Length is not filled in -> it's a collo
                    {
                        countColli++;
                        grossColliWeight += Tester.IsNullOrEmpty(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]) ? 0 : Convert.ToDouble(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]);
                    }
                    else if (String.Compare(Convert.ToString(row[PmxLogisticUnitIDTableKST.Columns.LogisticCarrierCode.NAME]), Defs.EuroPalletItemCode, true) == 0)
                    {
                        countEuroPallets++;
                    }
                    else
                    {
                        countLostPallets++;
                    }
                    grossWeight += Tester.IsNullOrEmpty(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]) ? 0 : Convert.ToDouble(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]);
                }



                writer.WriteText(1, 1, "B");
                writer.WriteText(2, 35, Convert.ToString(dataRows[0][Defs.MinSalesDeliveryDocNum]));//Votre référence
                writer.WriteSpaces(37, 17);  //Code destinaire




                string firstAddressLine = Convert.ToString(dataRows[0][PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME]);
                string suffix = String.Format("  {0}", dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME]);
                string secondAddressLine = StringHelper.Truncate(Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME]), 35 - suffix.Length) + suffix;
                string thirdAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME]);
                if (string.IsNullOrEmpty(firstAddressLine))
                {
                    firstAddressLine = secondAddressLine;
                    secondAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME]);
                    thirdAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME]);
                }


                writer.WriteText(54, 35, firstAddressLine);//Raison sociale
                writer.WriteText(89, 35, secondAddressLine);
                writer.WriteTruncatedText(124, 35, thirdAddressLine);  // Address 2
                writer.WriteText(159, 9, Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME]));
                writer.WriteText(168, 35, Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME]));
                writer.WriteText(203, 2, Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME]));

                writer.WriteSpaces(205, 81);

                writer.WriteSpaces(286, 20);//Téléphone contact
                writer.WriteSpaces(306, 26);//Libellé marchandise

                writer.WriteSpaces(332, 7);

                writer.WriteText(339, 6, "000000");//# de colis sur support emballage de Type1
                writer.WriteText(345, 6, (countColli + countEuroPallets + countLostPallets).ToString("D6"));//Nbre Unités de Manutention (UM)
                writer.WriteText(351, 15, grossWeight.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Poids total du BL
                writer.WriteText(366, 6, countEuroPallets.ToString("D6"));//Nbre de support  emballage de Type 1
                writer.WriteText(372, 6, countLostPallets.ToString("D6"));//Nbre de support  emballage de Type 2
                writer.WriteText(378, 6, countColli.ToString("D6"));//Nbre de support  emballage de Type 3
                writer.WriteText(384, 15, 0.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Quantité taxable
                writer.WriteText(399, 15, 0.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Volume
                writer.WriteText(414, 15, 0.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Montant Contre remboursement
                writer.WriteText(429, 3, "EUR");///Devise Contre remboursement
				writer.WriteText(432, 15, 0.ToString("0.###", Defs.GEFCONumberFormat).PadLeft(15, ' '));//Valeur à assurer
                writer.WriteText(447, 3, "EUR");//Devise Valeur à assurer
                writer.WriteText(450, 4, ksToolsCustomerCode);//Code Expéditeur

                writer.WriteSpaces(454, 35);

                writer.WriteText(489, 4, "GEFC");//Code transporteur
                writer.WriteText(493, 2, "3 ");//Code trafic
                writer.WriteSpaces(495, 70);//Instructions de livraison
                writer.WriteSpaces(565, 4);//Port/Incoterm
                writer.WriteText(569, 8, Convert.ToDateTime(dataRows[0][PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME]).ToString(Defs.GEFCODateFormat));//Date expédition
                writer.WriteSpaces(577, 8);//Date impérative de livraison
                writer.WriteSpaces(585, 8);//Date de livraison au plus tôt
                writer.WriteSpaces(593, 8);//Date de livraison au plus tard

                writer.WriteSpaces(601, 102);

                writer.WriteSpaces(703, 35);//Ville Incoterm
                writer.WriteSpaces(738, 2);//Pays Incoterm
                writer.WriteSpaces(740, 1);//Something is not correct in the desription file!! So adding additional white space
                writer.WriteSpaces(741, 3);//Code du mode d'encaissement du Contre remboursement
                writer.WriteSpaces(744, 6);//Nbre de colis sur support  emballage de Type 2
                writer.WriteSpaces(750, 6);//Nbre de colis sur support  emballage de Type 3
                writer.WriteText(756, 3, "EP ");//Type de support emballage de Type 1: We use Euro
                writer.WriteText(759, 3, "PX ");//Type de support emballage de Type 2: We use Lost
                writer.WriteText(762, 3, "CR ");//Type de support emballage de Type 3: We use Colli
                writer.WriteSpaces(765, 17);//Code Imputation
                writer.WriteSpaces(782, 3);//Type unité taxation
                writer.WriteSpaces(785, 50);//Adresse e-mail destinataire



            }

            outFileName = String.Format("ZIEGLER_{1}_{0:yyyyMMddhhmmssfff}.txt", DateTime.Now, deviceID);
            s_log.InfoFormat("File created: {0}", outFileName);
            File.Move(tmpFilePath, Path.Combine(outputPath, outFileName));
        }

        void ExportExapaqOrDPD(IList<DataRow> dataRows, string outputPath, string deviceID, string fileNamePart)
        {
            string tmpFilePath = Path.Combine(outputPath, String.Format("{0:yyyyMMddhhmmssfff}.new", DateTime.Now));
            string outFileName;

            using (StreamWriter sw = new StreamWriter(tmpFilePath, false, Defs.ExportFileEncoding))
            {
                sw.NewLine = "\r\n";
                FixedWidthTextWriter writer = new FixedWidthTextWriter(sw, FixedWidthSettings.OffsetIsOneBased);

                writer.WriteText(1, 12, "$VERSION=110");
                writer.StartNewLine();

                foreach (DataRow row in dataRows)
                {
                    string isODLNDropShippingString = Convert.ToString(row[Defs.IsODLNDropShipping_ColumnAlias]);
                    //This method is used for SalesDelivery (Sales Order) and Stock Transfer also. So we need to make sure that the OPT1_fnIsODLNDropShipping function is only considered in case of Sales Delivery (Sales Order).
                    bool useIsODLNDropShipping = !string.IsNullOrEmpty(isODLNDropShippingString);
                    bool isODLNDropShipping = useIsODLNDropShipping && isODLNDropShippingString == "Y";

                    writer.WriteText(1, 35, Convert.ToString(row[Defs.MinSalesDeliveryDocNum]));  // What does this need to be?
                    writer.WriteSpaces(36, 2);
                    writer.WriteText(38, 8, (Convert.ToDouble(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]) * 100.0).ToString("F0", Defs.ExapaqNumberFormat).PadLeft(8, '0'));

                    // * Destination address *
                    writer.WriteSpaces(46, 15);
                    //writer.WriteTruncatedText( 61, 35, Convert.ToString( row[ PmxSalesDeliveryNoteTable.Columns.CardName.NAME ] ) );


                    string firstAddressLine = Convert.ToString(row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME]);
                    if (string.IsNullOrEmpty(firstAddressLine))
                    {
                        firstAddressLine = Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME]);
                    }
                    string secondAddressLine = Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME]);
                    string thirdAddressLine = Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.CountyS.NAME]);


// Change: 08/05/2024	
//                    writer.WriteTruncatedText(61, 35, firstAddressLine);

                    if (isODLNDropShipping) {
                        if (Convert.ToString(row["U_MG2S_EDI_CPCtcDesN"]).Length > 0) writer.WriteTruncatedText(61, 35, Convert.ToString(row["U_MG2S_EDI_CPCtcDesN"]));
                        else { 
                            if (string.IsNullOrEmpty(Convert.ToString(row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME])))  
                                { writer.WriteTruncatedText(61, 35, "-"); }
                            else
                                { writer.WriteTruncatedText(61, 35, Convert.ToString(row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME])); }
                        }
                           
                    } 
                    else
                    {
                        if (Convert.ToString(row["ORDR_OwnerCode"]) != "72")
                        {
                            if (Convert.ToString(row["U_MG2S_EDI_CPCtcDesN"]).Length > 0) writer.WriteTruncatedText(61, 35, Convert.ToString(row["U_MG2S_EDI_CPCtcDesN"]));
                            else
                            {
                                if (string.IsNullOrEmpty(Convert.ToString(row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME])))
                                { writer.WriteTruncatedText(61, 35, "-"); }
                                else
                                    { writer.WriteTruncatedText(61, 35, Convert.ToString(row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME])); }
                            }
                        }
                        else
                        {
                            if (Convert.ToString(row["U_MG2S_EDI_CPCtcDesN"]).Length > 0) writer.WriteTruncatedText(61, 35, Convert.ToString(row["U_MG2S_EDI_CPCtcDesN"]));
                            else
                            {
                                if (string.IsNullOrEmpty(Convert.ToString(row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME])))
                                { writer.WriteTruncatedText(61, 35, "-"); }
                                else
                                    { writer.WriteTruncatedText(61, 35, Convert.ToString(row[PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME])); }
                            }
                        }
                    }



                    //                    if (isODLNDropShipping) writer.WriteTruncatedText(96, 35, Convert.ToString(row["U_MG2S_EDI_CPCtcDesN"]));  // Comp address 1
                    //                    else writer.WriteTruncatedText(96, 35, secondAddressLine);  // Comp address 1
                    // Change: 08/05/2024	 				

                    // Change: 11/08/2024	 				

                    if (isODLNDropShipping)
                    {
                        writer.WriteTruncatedText(96, 35, Convert.ToString(row["RDR12_StreetS"]));
                    }
                    else
                    {
                        writer.WriteTruncatedText(96, 35, Convert.ToString(row["RDR12_BlockS"]));
                    }

// Change: 11/08/2024	 				
                    writer.WriteTruncatedText(131, 35, thirdAddressLine);
                    writer.WriteSpaces(166, 35);
                    writer.WriteSpaces(201, 35);
                    writer.WriteSpaces(236, 35);  // Comp address 5
                    writer.WriteText(271, 10, Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME]));
                    writer.WriteText(281, 35, Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME]));
                    writer.WriteSpaces(316, 10);
                    string suffix = String.Format("  {0}", row[SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME]);

                    // Change: 06/28/2023	 				
                    //                    if (isODLNDropShipping) writer.WriteText(326, 35, StringHelper.Truncate(Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME]), 35 - suffix.Length) + suffix);  // Street
                    //                    else writer.WriteTruncatedText(326, 35, Convert.ToString(row["ADM1Street"]));  // CompanyStreet
                    // Change: 11/23/2023	 									


                    // Change: 11/08/2024                    
                    if (isODLNDropShipping)
                    {
                        writer.WriteTruncatedText(326, 35, Convert.ToString(row["RDR12_BlockS"]));
                    }
                    else
                    {
                        writer.WriteTruncatedText(326, 35, Convert.ToString(row["RDR12_StreetS"]));
                    }

// Change: 11/08/2024

                    writer.WriteSpaces(361, 10);
                    writer.WriteText(371, 3, Convert.ToString(row[PmxCountryTableKST.Columns.ExapaqCountryCode.NAME]));
                    if (isODLNDropShipping) writer.WriteText(374, 20, Convert.ToString(row["U_MG2S_EDI_CPTelDes"])); // Telephone					
                    else writer.WriteText(374, 20, Convert.ToString(row[PmxBusinessPartnerTable.Columns.Phone1.NAME])); // Telephone					

                    // * Expediter address *
                    writer.WriteSpaces(394, 25);

// Change 05/31/2023
                    //19
                    if (isODLNDropShipping) writer.WriteTruncatedText(419, 35, Convert.ToString(row[PmxSalesDeliveryNoteTable.Columns.CardName.NAME]));  // Nom
                    else writer.WriteTruncatedText(419, 35, Convert.ToString(row[Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables.SboAdminInfoTable.Columns.CompanyName.NAME]));  // CompanyName
// Change 05/31/2023
                    // 20
//                    if (isODLNDropShipping) writer.WriteTruncatedText(454, 35, Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.StreetB.NAME]));  // Comp address 1
//                    else writer.WriteTruncatedText(454, 35, Convert.ToString(row["Block"]));  // Block
// Change 11/23/2023
					if (isODLNDropShipping) writer.WriteTruncatedText(454, 35, Convert.ToString(row["RDR12_BlockB"]));
					else writer.WriteTruncatedText(454, 35, Convert.ToString(row["ADM1Street"]));

                    // 21
                    writer.WriteSpaces(489, 35);
                    // 22
                    writer.WriteSpaces(524, 35);
                    // 23
                    writer.WriteSpaces(559, 35);
                    // 24
                    writer.WriteSpaces(594, 35);
// Change 05/31/2023
                    //25
                    if (isODLNDropShipping) writer.WriteText(629, 10, Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeB.NAME]));  // CP
                    else writer.WriteTruncatedText(629, 10, Convert.ToString(row["ZipCode"]));  // ZipCode
// Change 05/31/2023
                    //26
                    if (isODLNDropShipping) writer.WriteText(639, 35, Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.CityB.NAME])); // Ville
                    else writer.WriteTruncatedText(639, 35, Convert.ToString(row["City"]));  // City

                    writer.WriteSpaces(674, 10);
                    string suffixB = String.Format("  {0}", row[SboSalesDeliveryTaxExtensionTable.Columns.StreetNoB.NAME]);

// Change 06/08/2023                    
//                    if (isODLNDropShipping) writer.WriteText(684, 35, StringHelper.Truncate(Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.StreetB.NAME]), 35 - suffixB.Length) + suffixB);  // Street
//                    else writer.WriteTruncatedText(684, 35, Convert.ToString(row["ADM1Street"]));  // CompanyStreet
// Change 11/23/2023                    
//					writer.WriteTruncatedText(684, 35, Convert.ToString(row["Block"]));
// Change 01/02/2024                   
                    if (isODLNDropShipping) writer.WriteTruncatedText(684, 35, Convert.ToString(row["StreetB"]));  // Street
                    else writer.WriteTruncatedText(684, 35, Convert.ToString(row["Block"]));  // CompanyStreet

                    writer.WriteSpaces(719, 10);
					
// Change 11/23/2023
//                    writer.WriteText(729, 3, Convert.ToString(row[SboSalesDeliveryTaxExtensionTable.Columns.CountryB.NAME]));
					if (isODLNDropShipping) writer.WriteText(729, 3, Convert.ToString(row["729_Country_Cust"]));
					else writer.WriteText(729, 3, Convert.ToString(row["729_Country_Company"]));
								
								
                    writer.WriteSpaces(732, 20);  // Tél
                    // *  *
                    writer.WriteSpaces(752, 10);
                    writer.WriteSpaces(762, 35);  // Comment 1
                    writer.WriteSpaces(797, 35);  // Comment 2
                    writer.WriteSpaces(832, 35);  // Comment 3
                    writer.WriteSpaces(867, 35);  // Comment 4
                    writer.WriteText(902, 10, Convert.ToDateTime(row[PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME]).ToString(Defs.ExapaqDateFormat));
                    if (isODLNDropShipping) writer.WriteText(912, 8, "12838");  // Account number chargeur Exapaq
                    else writer.WriteText(912, 8, "9091");  // Account number chargeur Exapaq
                    writer.WriteSpaces(920, 35);  // Barcode
                    writer.WriteSpaces(955, 35);  // Order number (exaprint 3)
                    writer.WriteSpaces(990, 29);  //  __
                    writer.WriteSpaces(1019, 9);  // Montant de la valeur déclarée
                    writer.WriteSpaces(1028, 8);  //  __
                    writer.WriteSpaces(1036, 35);  // Ref. client N° 2 (future usage)
                    writer.WriteSpaces(1071, 1);  //  __
                    writer.WriteSpaces(1072, 35);  // nr exapluri (exaprint 3)
                    writer.WriteSpaces(1107, 10);  // __ 
                    writer.WriteSpaces(1117, 80);  // e-mail expediter
                    writer.WriteSpaces(1197, 35);  // gsm expediter
                    if (isODLNDropShipping) writer.WriteText(1232, 80, Convert.ToString(row["U_MG2S_EDI_CPMelDes"])); // e-mail destination					
                    else writer.WriteText(1232, 80, Convert.ToString(row[PmxBusinessPartnerTableKST.Columns.Email.NAME])); // e-mail destination					
                    writer.WriteSpaces(1312, 35);  // gsm destination
                    writer.WriteSpaces(1347, 80);  // __
                    writer.StartNewLine();
                }
            }

            outFileName = String.Format("{2}_{1}_{0:yyyyMMddhhmmssfff}.txt", DateTime.Now, deviceID, fileNamePart);

            s_log.InfoFormat("File created: {0}", outFileName);

            File.Move(tmpFilePath, Path.Combine(outputPath, outFileName));
        }

        void ExportMory(IList<DataRow> dataRows, bool express, string outputPath, string ksToolsCustomerCode, string deviceID)
        {
            string tmpFilePath = Path.Combine(outputPath, String.Format("{0:yyyyMMddhhmmssfff}.new", DateTime.Now));
            string outFileName;

            using (StreamWriter sw = new StreamWriter(tmpFilePath, false, Defs.ExportFileEncoding))
            {
                sw.NewLine = "\n";
                FixedWidthTextWriter writer = new FixedWidthTextWriter(sw, FixedWidthSettings.OffsetIsOneBased);

                int countColli = 0;
                double grossColliWeight = 0.0;
                int countEuroPallets = 0;
                int countLostPallets = 0;
                double grossWeight = 0.0;
                foreach (DataRow row in dataRows)
                {
                    if (Tester.IsNullOrEmpty(row[PmxLogisticUnitIDTableKST.Columns.KST_Length.NAME]))  // If Length is not filled in -> it's a collo
                    {
                        countColli++;
                        grossColliWeight += Convert.ToDouble(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]);
                    }
                    else if (String.Compare(Convert.ToString(row[PmxLogisticUnitIDTableKST.Columns.LogisticCarrierCode.NAME]), Defs.EuroPalletItemCode, true) == 0)
                    {
                        countEuroPallets++;
                    }
                    else
                    {
                        countLostPallets++;
                    }
                    grossWeight += Convert.ToDouble(row[PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME]);
                }

                DateTime tsNow = DateTime.Now;
                DateTime? dueDate = Convert.ToDateTime(dataRows[0][PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME]);
                switch (tsNow.Date.DayOfWeek)
                {
                    case DayOfWeek.Friday:
                    case DayOfWeek.Saturday:
                        if ((dueDate.Value.Date - tsNow.Date).TotalDays >= 3.0)
                        {
                            dueDate = null;
                        }
                        break;
                    default:
                        if ((dueDate.Value.Date - tsNow.Date).TotalDays >= 2.0)
                        {
                            dueDate = null;
                        }
                        break;
                }

                writer.WriteText(1, 2, "P0");
                writer.WriteText(3, 8, "00000000");
                writer.WriteText(11, 6, "000000");  // Date expédition  //writer.WriteText( 11, 6, DateTime.Now.ToString( Defs.MoryDateFormat ) );
                writer.WriteText(17, 6, countColli.ToString("D6"));
                writer.WriteText(23, 6, "000000");  // Do not use when supplying L0 entry  //writer.WriteText( 23, 6, countEuroPallets.ToString( "D6" ) );
                writer.WriteText(29, 15, grossWeight.ToString("0.00", Defs.MoryNumberFormat).PadLeft(15, '0'));
                //writer.WriteTruncatedText(44, 35, Convert.ToString(dataRows[0][PmxSalesDeliveryNoteTable.Columns.CardName.NAME]));


                string firstAddressLine = Convert.ToString(dataRows[0][PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME]);
                string suffix = String.Format("  {0}", dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME]);
                string secondAddressLine = StringHelper.Truncate(Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME]), 35 - suffix.Length) + suffix;
                string thirdAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME]);
                if (string.IsNullOrEmpty(firstAddressLine))
                {
                    firstAddressLine = secondAddressLine;
                    secondAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME]);
                    thirdAddressLine = Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME]);
                }



                writer.WriteTruncatedText(44, 35, firstAddressLine);

                writer.WriteText(79, 35, secondAddressLine);
                writer.WriteTruncatedText(114, 35, thirdAddressLine);  // Address 2
                writer.WriteText(149, 5, Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME]));
                writer.WriteText(154, 35, Convert.ToString(dataRows[0][SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME]));
                writer.WriteText(189, 6, dueDate.HasValue ? dueDate.Value.ToString(Defs.MoryDateFormat) : "000000");
                writer.WriteText(195, 1, "P");
                writer.WriteText(196, 15, new string('0', 15));
                writer.WriteText(211, 15, new string('0', 15));
                writer.WriteText(226, 1, Defs.SboCountryCodeFrance.Equals(dataRows[0][PmxCountryTableKST.Columns.Code.NAME]) ? "V" : "E");  // TVA
                writer.WriteTruncatedText(227, 70, Convert.ToString(dataRows[0][PmxBusinessPartnerTableKST.Columns.TransportInformation.NAME]));
                writer.WriteSpaces(297, 26);
                writer.WriteText(323, 1, express ? "1" : "3");
                writer.WriteSpaces(324, 3);
                writer.WriteText(327, 6, ksToolsCustomerCode);  // Matricule du chargeur
                writer.WriteText(333, 35, Convert.ToString(dataRows[0][Defs.MinSalesDeliveryDocNum]));
                writer.WriteSpaces(368, 17);
                writer.WriteText(385, 2, express ? "31" : "10");
                writer.WriteSpaces(387, 1);
                writer.WriteText(388, 4, "6760");  // Code agence
                writer.WriteText(392, 6, (countColli + countEuroPallets + countLostPallets).ToString("D6"));  // Unité de Manutention
                writer.WriteText(398, 9, grossWeight.ToString("0.00", Defs.MoryNumberFormat).PadLeft(9, '0'));
                writer.WriteSpaces(407, 15);
                writer.WriteText(422, 15, new string('0', 15));  // Volume
                writer.WriteText(437, 3, "EUR");
                writer.WriteText(440, 3, "EUR");
                writer.WriteSpaces(443, 35);
                writer.WriteSpaces(478, 35);
                writer.WriteSpaces(513, 110);
                writer.WriteSpaces(623, 1);
                writer.WriteText(624, 15, Convert.ToString(dataRows[0][PmxBusinessPartnerTable.Columns.Phone1.NAME]));
                writer.WriteSpaces(639, 8);
                writer.WriteText(647, 35, Convert.ToString(dataRows[0][Defs.MaxSalesOrderDocNum]));
                writer.WriteSpaces(682, 15);
                writer.WriteSpaces(697, 20);
                writer.WriteSpaces(717, 6);
                writer.WriteSpaces(723, 4);
                writer.WriteSpaces(727, 2);
                writer.WriteSpaces(729, 2);
                writer.WriteSpaces(731, 35);
                writer.WriteSpaces(766, 3);
                writer.WriteSpaces(769, 100);
                writer.WriteSpaces(869, 110);
                writer.WriteSpaces(979, 4);
                writer.WriteSpaces(983, 15);
                writer.WriteText(998, 15, new string('0', 15));  // Poids LQ
                writer.StartNewLine();

                if (countColli > 0)
                {
                    writer.WriteText(1, 2, "C0");
                    writer.WriteSpaces(3, 35);
                    writer.WriteText(38, 15, grossColliWeight.ToString("0.00", Defs.MoryNumberFormat).PadLeft(15, '0'));
                    writer.WriteSpaces(53, 5);  // Reserved
                    writer.WriteSpaces(58, 6);  // Reserved
                    writer.WriteSpaces(64, 6);  // Reserved
                    writer.WriteSpaces(70, 26);  // Reserved
                    writer.WriteSpaces(96, 70);  // Reserved
                    writer.WriteSpaces(166, 35);
                    writer.WriteSpaces(201, 1);
                    writer.WriteSpaces(202, 35);
                    writer.WriteSpaces(237, 35);
                    writer.WriteSpaces(272, 20);
                    writer.StartNewLine();
                }
                if (countEuroPallets > 0 || countLostPallets > 0)
                {
                    writer.WriteText(1, 2, "L0");
                    writer.WriteText(3, 3, countEuroPallets.ToString("D3"));
                    writer.WriteText(6, 3, new string('0', 3));
                    writer.WriteText(9, 3, new string('0', 3));
                    writer.WriteText(12, 3, new string('0', 3));
                    writer.WriteText(15, 3, countLostPallets.ToString("D3"));
                    writer.StartNewLine();
                }
            }

            outFileName = String.Format("Mory_{1}_{0:yyyyMMddhhmmssfff}.txt", DateTime.Now, deviceID);
            s_log.InfoFormat("File created: {0}", outFileName);
            File.Move(tmpFilePath, Path.Combine(outputPath, outFileName));
        }

        #region HELPERS

        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }
            return 0;
        }

        #endregion

        #region QUERY

        private class BuildQuery
        {
            /// <summary>
            /// Gets all SSCC to double check.
            /// </summary>
            /// <param name="listOfSalesDeliveries">The list of sales deliveries.</param>
            /// <returns></returns>
            public static string GetAllSSCCToDoubleCheck(IList<int> listOfSalesDeliveries)
            {

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT DISTINCT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocEntry.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocNum.NAME);


                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME));
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.MoveLineDocEntry.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.PickListLineDocEntry.NAME);


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxPickListTypeTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTable.NAME, PmxPickListTable.Columns.PickListType.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTypeTable.NAME, PmxPickListTypeTable.Columns.Code.NAME);


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(SboSalesDeliveryNoteTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.SalesDeliveryNoteLineDocEntry.NAME);


                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.SalesDeliveryNoteLineDocEntry.NAME);
                strBuilder.Append(" IN ( ");

                string comma = "";
                foreach (int docEntry in listOfSalesDeliveries)
                {

                    strBuilder.Append(comma);
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(docEntry, CultureInfo.InvariantCulture));

                    comma = ", ";

                }

                strBuilder.Append(" ) ");

                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxPickListTypeTable.NAME, PmxPickListTypeTableKST.Columns.DoubleCheckSSCC.NAME);
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


                return strBuilder.ToString();
            }


            /// <summary>
            /// Gets all SSCC without weight.
            /// </summary>
            /// <param name="listOfSalesDeliveries">The list of sales deliveries.</param>
            /// <returns></returns>
            public static string GetAllSSCCWithoutWeight(IList<int> listOfSalesDeliveries)
            {

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT DISTINCT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocEntry.NAME);
                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocNum.NAME);


                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME));
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.MoveLineDocEntry.NAME);

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(SboSalesDeliveryNoteTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.SalesDeliveryNoteLineDocEntry.NAME);


                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.SalesDeliveryNoteLineDocEntry.NAME);
                strBuilder.Append(" IN ( ");

                string comma = "";
                foreach (int docEntry in listOfSalesDeliveries)
                {

                    strBuilder.Append(comma);
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(docEntry, CultureInfo.InvariantCulture));

                    comma = ", ";

                }

                strBuilder.Append(" ) ");

                strBuilder.AppendFormat(" AND IFNULL({0},0) = 0",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME));


                return strBuilder.ToString();
            }



            internal static string GetSalesDeliveriesForExport(IList<int> listOfSalesDeliveries, CultureInfo cultureInfo)
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat("SELECT {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.CardName.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.Code.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.ExapaqCountryCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountyS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME));
                strBuilder.AppendFormat(", {0}",
                SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CityB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetNoB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.BlockB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, "CountyB"));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountryB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTable.NAME, PmxBusinessPartnerTable.Columns.Phone1.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTableKST.NAME, PmxBusinessPartnerTableKST.Columns.Email.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTableKST.NAME, PmxBusinessPartnerTableKST.Columns.TransportInformation.NAME));

                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.SSCC.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Width.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Height.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Length.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.LogisticCarrierCode.NAME));

                strBuilder.AppendFormat(", MAX({0}) AS {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesOrderTable.NAME, "U_MG2S_EDI_CPCtcDesN"), SqlCommandHelper.EscapeColumnName("U_MG2S_EDI_CPCtcDesN"));

                strBuilder.AppendFormat(", MAX({0}) AS {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesOrderTable.NAME, "U_MG2S_EDI_CPTelDes"), SqlCommandHelper.EscapeColumnName("U_MG2S_EDI_CPTelDes"));

                strBuilder.AppendFormat(", MAX({0}) AS {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesOrderTable.NAME, "U_MG2S_EDI_CPMelDes"), SqlCommandHelper.EscapeColumnName("U_MG2S_EDI_CPMelDes"));

                strBuilder.AppendFormat(", MAX(\"{0}\"({1})) AS \"{2}\"",
                    Defs.IsODLNDropShipping_FunctionName,
                    $"{SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocEntry.NAME)}",
                    Defs.IsODLNDropShipping_ColumnAlias);

                strBuilder.AppendFormat(", MAX( {0} ) AS {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesOrderTable.NAME, PmxSalesOrderTable.Columns.DocNum.NAME),
                    SqlCommandHelper.EscapeColumnName(Defs.MaxSalesOrderDocNum));
                strBuilder.AppendFormat(", MIN( {0} ) AS {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocNum.NAME),
                    SqlCommandHelper.EscapeColumnName(Defs.MinSalesDeliveryDocNum));

// Change 05/31/2023				
                strBuilder.AppendFormat(", (select \"CompnyName\" from \"OADM\") as \"CompnyName\" ");
                strBuilder.AppendFormat(", (select \"Block\" from \"ADM1\") as \"Block\" ");
                strBuilder.AppendFormat(", (select \"ZipCode\" from \"ADM1\") as \"ZipCode\" ");
                strBuilder.AppendFormat(", (select \"City\" from \"ADM1\") as \"City\" ");
// Change 06/28/2023				
                strBuilder.AppendFormat(", (select \"Street\" from \"ADM1\") as \"ADM1Street\" ");

// Change 11/23/2023				
                strBuilder.AppendFormat(", \"RDR12\".\"StreetS\" AS \"RDR12_StreetS\" ");
                strBuilder.AppendFormat(", \"RDR12\".\"StreetB\" AS \"RDR12_StreetB\" ");
                strBuilder.AppendFormat(", \"RDR12\".\"BlockB\" AS \"RDR12_BlockB\" ");
                strBuilder.AppendFormat(", \"RDR12\".\"BlockS\" AS \"RDR12_BlockS\" ");
                strBuilder.AppendFormat(", \"RDR12\".\"CountryB\" AS \"RDR12_CountryB\" ");
                strBuilder.AppendFormat(", (SELECT \"U_PMX_EXAPAQ_CODE\" FROM \"OCRY\" WHERE \"OCRY\".\"Code\" in ( select \"Country\" from \"OADM\")) AS \"729_Country_Company\" ");
                strBuilder.AppendFormat(", (SELECT \"U_PMX_EXAPAQ_CODE\" FROM \"OCRY\" WHERE \"OCRY\".\"Code\" = \"RDR12\".\"CountryB\") AS \"729_Country_Cust\" ");

// Change 11/23/2023				
                strBuilder.AppendFormat(", \"ORDR\".\"OwnerCode\" AS \"ORDR_OwnerCode\" ");

                strBuilder.AppendFormat("\r\n FROM {0}",
                    SqlCommandHelper.EscapeTableName(PmxSalesDeliveryNoteTable.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxBusinessPartnerTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTable.NAME, PmxBusinessPartnerTable.Columns.CardCode.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.CardCode.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(SboSalesDeliveryTaxExtensionTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocEntry.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxCountryTableKST.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.Code.NAME),
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxSalesDeliveryNoteLineTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteLineTable.NAME, PmxSalesDeliveryNoteLineTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocEntry.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.SalesDeliveryNoteLineDocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteLineTable.NAME, PmxSalesDeliveryNoteLineTable.Columns.DocEntry.NAME));
                strBuilder.AppendFormat(" AND {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.SalesDeliveryNoteLineLineNum.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteLineTable.NAME, PmxSalesDeliveryNoteLineTable.Columns.LineNum.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.MoveLineDocEntry.NAME));
                strBuilder.AppendFormat(" AND {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.MoveLineLineNum.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTableKST.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.InternalKey.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME));


                strBuilder.AppendFormat("\r\n LEFT JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxSalesOrderTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesOrderTable.NAME, PmxSalesOrderTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteLineTable.NAME, PmxSalesDeliveryNoteLineTable.Columns.BaseEntry.NAME));
                strBuilder.AppendFormat(" AND {0} = {1}",
                    SqlCommandHelper.FormatAndEscapeColumnValue(SboObjectTypes.SalesOrder, cultureInfo),
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteLineTable.NAME, PmxSalesDeliveryNoteLineTable.Columns.BaseType.NAME));

//Change 11/23/2023
                strBuilder.AppendFormat("\r\n LEFT JOIN \"RDR12\" ON \"ORDR\".\"DocEntry\" = \"RDR12\".\"DocEntry\" ");

                strBuilder.AppendFormat("\r\n WHERE {0} IN ( {1} )",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.FormatAndEscapeColumnValue(listOfSalesDeliveries, cultureInfo));

                strBuilder.AppendFormat(" AND ({0} IN ( {1} )",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME),
                    SqlCommandHelper.FormatAndEscapeColumnValue(new string[] { Defs.ExapaqCode, Defs.MoryRegularCode, Defs.MoryGoldCode, Defs.MoryGoldCodeDepot2, Defs.MoryRegularCodeDepot2, Defs.GEFCOCode, Defs.GEFCOPalCode, Defs.DpdCode }, cultureInfo));

                strBuilder.AppendFormat(" OR {0} LIKE '{1}%' )",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME),
                        Defs.ZIEGLERCode);



                strBuilder.AppendFormat("\r\n GROUP BY {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.CardName.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.Code.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.ExapaqCountryCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountyS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME));
                strBuilder.AppendFormat(", {0}",
              SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CityB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetNoB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.BlockB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, "CountyB"));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountryB.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTable.NAME, PmxBusinessPartnerTable.Columns.Phone1.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTableKST.NAME, PmxBusinessPartnerTableKST.Columns.Email.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTableKST.NAME, PmxBusinessPartnerTableKST.Columns.TransportInformation.NAME));

                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.SSCC.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.LogisticCarrierCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Width.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Height.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Length.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME));

//Change 11/23/2023
                strBuilder.AppendFormat(", \"RDR12\".\"StreetS\", \"RDR12\".\"BlockS\", \"RDR12\".\"CountryB\" ");
                strBuilder.AppendFormat(", \"RDR12\".\"StreetB\", \"RDR12\".\"BlockB\", \"RDR12\".\"CountryB\" ");

//Change 08/05/2024
                strBuilder.AppendFormat(", \"ORDR\".\"OwnerCode\" ");


                strBuilder.AppendFormat("\r\n ORDER BY {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.ExapaqCountryCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(SboSalesDeliveryTaxExtensionTable.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME));

                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.SSCC.NAME));

                return strBuilder.ToString();
            }

            internal static string GetStockTransfersForExport(IList<int> listOfStockTransfers, CultureInfo cultureInfo)
            {
                StringBuilder strBuilder = new StringBuilder();


                strBuilder.AppendFormat("SELECT {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.CardName.NAME, PmxSalesDeliveryNoteTable.Columns.CardName.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.ShipToCode.NAME, PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.DocDueDate.NAME, PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.Code.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.ExapaqCountryCode.NAME, PmxCountryTableKST.Columns.ExapaqCountryCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.ZipCode.NAME, SboSalesDeliveryTaxExtensionTable.Columns.ZipCodeS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.City.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CityS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.Street.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.StreetNo.NAME, SboSalesDeliveryTaxExtensionTable.Columns.StreetNoS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.Country.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountryS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.County.NAME, SboSalesDeliveryTaxExtensionTable.Columns.CountyS.NAME));
                strBuilder.AppendFormat(", null as {0}",
                      SqlCommandHelper.EscapeColumnName(SboSalesDeliveryTaxExtensionTable.Columns.BlockS.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTable.NAME, PmxBusinessPartnerTable.Columns.Phone1.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTableKST.NAME, PmxBusinessPartnerTableKST.Columns.TransportInformation.NAME));

                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.SSCC.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Width.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Height.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Length.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.LogisticCarrierCode.NAME));

                //The file export works with SalesDelivery (Sales Order) and Stock Transfer also. So we need to make sure that the OPT1_fnIsODLNDropShipping function is only considered in case of Sales Delivery (Sales Order).
                //That's why in case of Stock Transfer we return '' instead of some actual value.
                strBuilder.AppendFormat(", '') AS \"{0}\"", Defs.IsODLNDropShipping_ColumnAlias);

                strBuilder.AppendFormat(", MAX( {0} ) AS {1}",
                     SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.DocNum.NAME),
                     SqlCommandHelper.EscapeColumnName(Defs.MaxSalesOrderDocNum));
                strBuilder.AppendFormat(", MIN( {0} ) AS {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.DocNum.NAME),
                    SqlCommandHelper.EscapeColumnName(Defs.MinSalesDeliveryDocNum));



                strBuilder.AppendFormat("\r\n FROM {0}",
                    SqlCommandHelper.EscapeTableName(PmxStockTransferTable.NAME));


                strBuilder.AppendFormat("\r\n LEFT JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxBusinessPartnerTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTable.NAME, PmxBusinessPartnerTable.Columns.CardCode.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.CardCode.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxWarehouseTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.WarehouseCode.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.ToWarehouse.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxCountryTableKST.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.Code.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.Country.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxStockTransferLineTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferLineTable.NAME, PmxStockTransferLineTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.DocEntry.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.StockTransferDocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferLineTable.NAME, PmxStockTransferLineTable.Columns.DocEntry.NAME));
                strBuilder.AppendFormat(" AND {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.StockTransferLineNum.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferLineTable.NAME, PmxStockTransferLineTable.Columns.LineNum.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxMoveLineTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.MoveLineDocEntry.NAME));
                strBuilder.AppendFormat(" AND {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxLinkSalesDeliveryNoteLinePickListLineTable.NAME, PmxLinkSalesDeliveryNoteLinePickListLineTable.Columns.MoveLineLineNum.NAME));


                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTableKST.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.InternalKey.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME));


                //strBuilder.AppendFormat("\r\n LEFT JOIN {0}",
                //    SqlCommandHelper.EscapeTableName(PmxSalesOrderTable.NAME));
                //strBuilder.AppendFormat(" ON {0} = {1}",
                //    SqlCommandHelper.EscapeTableColumnName(PmxSalesOrderTable.NAME, PmxSalesOrderTable.Columns.DocEntry.NAME),
                //    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteLineTable.NAME, PmxSalesDeliveryNoteLineTable.Columns.BaseEntry.NAME));
                //strBuilder.AppendFormat(" AND {0} = {1}",
                //    SqlCommandHelper.FormatAndEscapeColumnValue(SboObjectTypes.SalesOrder, cultureInfo),
                //    SqlCommandHelper.EscapeTableColumnName(PmxSalesDeliveryNoteLineTable.NAME, PmxSalesDeliveryNoteLineTable.Columns.BaseType.NAME));


                strBuilder.AppendFormat("\r\n WHERE {0} IN ( {1} )",
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.FormatAndEscapeColumnValue(listOfStockTransfers, cultureInfo));


                strBuilder.AppendFormat(" AND ({0} IN ( {1} )",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME),
                    SqlCommandHelper.FormatAndEscapeColumnValue(new string[] { Defs.ExapaqCode, Defs.MoryRegularCode, Defs.MoryGoldCode, Defs.MoryGoldCodeDepot2, Defs.MoryRegularCodeDepot2, Defs.GEFCOCode, Defs.GEFCOPalCode, Defs.DpdCode }, cultureInfo));

                strBuilder.AppendFormat(" OR {0} LIKE '{1}%' )",
                SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME),
                    Defs.ZIEGLERCode);


                strBuilder.AppendFormat(" AND {0} IN ( {1} )",
                SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTableKST.NAME, PmxWarehouseTableKST.Columns.InternalWhs.NAME),
                SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, cultureInfo));



                strBuilder.AppendFormat("\r\n GROUP BY {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxSalesDeliveryNoteTable.Columns.CardName.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxSalesDeliveryNoteTable.Columns.ShipToCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxSalesDeliveryNoteTable.Columns.DocDueDate.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.Code.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.ExapaqCountryCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.ZipCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.City.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.Street.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.StreetNo.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.County.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.Country.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTable.NAME, PmxBusinessPartnerTable.Columns.Phone1.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxBusinessPartnerTableKST.NAME, PmxBusinessPartnerTableKST.Columns.TransportInformation.NAME));

                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.SSCC.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.LogisticCarrierCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Width.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Height.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Length.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.KST_Weight.NAME));


                strBuilder.AppendFormat("\r\n ORDER BY {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.ShipToCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxStockTransferTable.NAME, PmxStockTransferTable.Columns.DocDueDate.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxCountryTableKST.NAME, PmxCountryTableKST.Columns.ExapaqCountryCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.ZipCode.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.City.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.Street.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.StreetNo.NAME));

                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.Transporter.NAME));
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTableKST.NAME, PmxLogisticUnitIDTableKST.Columns.SSCC.NAME));

                return strBuilder.ToString();
            }
        }

        #endregion
    }
}