﻿//css_ref System.Data;
//css_ref System.Transactions;
//css_ref System.Xml;
//css_ref Interop.SAPbobsCOM.dll;
//css_ref log4net.dll;
//css_ref Produmex.Foundation.dll;
//using Produmex.Foundation.Data.dll;
//css_ref Produmex.Foundation.Data.Sbo.dll;
//using Produmex.Foundation.Sbo.dll;
//css_ref Produmex.Sbo.Logex.Data.dll;
//css_ref Produmex.Sbo.Logex.KSTools.dll;

using System;
using System.Reflection;
using System.Transactions;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.Attributes;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Reflection;
using Produmex.Foundation.Resources;
using Produmex.Foundation.SboGui;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.KSTools.BusinessObjects;
using Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.KSTools.Extensions.Interfacing;
using Produmex.Sbo.Logex.KSTools.Generators.PickListRobot;
using Produmex.Sbo.Logex.KSTools.Generators.WarehouseAutomationController;
using System.Diagnostics;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.DbClient;
using System.Globalization;
using Produmex.Foundation.Data.SqlClient;
using System.Text;
using System.Collections.Generic;
using Produmex.Foundation.Data;
using Produmex.Sbo.Logex.KSTools.ViewObjects.Definitions.Views;

namespace AddUpdateData
{
    class Program
    {
        public static string CONNECTION_STRING = "Server=imdbhdb:30015;ServerType=HANA;CompanyDB=TEST_20170215;ExtraDB=PMX_TEST_20170215;UseTrusted=False;DbUserName=SYSTEM;DbPassword=B1HAdmin;UserName=manager;Password=1234;LicenseServer=imdbhdb:40000;DBCultureInfo=en-US;Pooling=True;MinPoolSize=2;MaxPoolSize=10";

        //Server=IMDBHDB:30015;ServerType=HANA;CompanyDB=TEST_20170215;ExtraDb=PMX_TEST_20170215;UseTrusted=False;DbUserName=SYSTEM;DbPassword=B1HAdmin;UserName=manager;Password=1234;Pooling=True;MinPoolSize=2;MaxPoolSize=10;DBCultureInfo=en-US;LicenseServer=localhost:30000";
        //private static string CONNECTION_STRING = "Server=DEV_SAP9_FR;ServerType=MSSQL2008;CompanyDB=KSTools;ExtraDb=PMX_KSTools;UseTrusted=False;DbUserName=sa;DbPassword=B1Admin;UserName=manager;Password=produmex;Pooling=True;MinPoolSize=2;MaxPoolSize=10;DBCultureInfo=en-US;LicenseServer=localhost:30000";

        //static string SCRIPT_ROOT = @"..\WorkflowScripts";

        /// <summary>
        /// Used for logging
        /// </summary>
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        static void Main(string[] args)
        {

            try
            {
                QueryTester.GenerateTests();
                Produmex.Foundation.Diagnostics.LogProvider.SetConsoleAppender("WARN");
                Execute();
            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
            }
            if (Debugger.IsAttached)
            {
                Console.WriteLine("Press <Enter>");
                Console.ReadLine();
            }
        }

        static void Execute()
        {
            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                {

                    conn.Open(); //Open connection to SAP
                    Console.WriteLine("Connection is open to database");

                    PmxDbVersionUpdaterProvider updateProv = new PmxDbVersionUpdaterProvider(conn);

                    //Pick list type
                    updateProv.AddUpdateUserDefinedTable(typeof(PmxPickListTypeKST));
                    updateProv.AddUpdateUserDefinedObject(typeof(PmxPickListTypeKST));

                    //Priority
                    updateProv.AddUpdateUserDefinedTable(typeof(PmxPriorityKST));
                    updateProv.AddUpdateUserDefinedObject(typeof(PmxPriorityKST));

                    //Transporter
                    updateProv.AddUpdateUserDefinedTable(typeof(PmxTransporter));
                    updateProv.AddUpdateUserDefinedObject(typeof(PmxTransporter));

                    updateProv.AddUpdateUserDefinedTable(typeof(PmxBoxTypeByItem));
                    updateProv.AddUpdateUserDefinedObject(typeof(PmxBoxTypeByItem));

                }

                //Complete transaction
                scope.Complete();
            }

            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (PmxDbConnection conn = PmxDbConnectionMgr.GetDirectConnection(SboConnectionString.ParseStringToObject(CONNECTION_STRING)))
                {
                    conn.Open();

                    AddUpdateExtension(PmxItemMasterDataInterfaceKSTools.IDs.ExtCode, "KS Tools item master data interface",
                        typeof(PmxItemMasterDataInterfaceKSTools), Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IINTERFACING_SBOITEMMASTERDATA, conn);

                    AddUpdateExtension(PickListRobot.IDs.ExtCode, "KS Tools Pick List robot",
                        typeof(Produmex.Sbo.Logex.KSTools.Generators.PickListRobot.PickListRobot), Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IPICKLISTROBOT, conn);

                    AddUpdateExtensionParameter(PickListRobot.IDs.ExtParamOpenProductionOrders,
                        "Open production orders view",
                        PickListRobot.IDs.ExtCode,
                        Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
                        PmxOpenProductionOrdersViewDefinitionKST.NAME,
                        Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.PmxExtensionParameterCodesKST.OPEN_PRODUCTION_ORDERS,
                        conn,
                        "Views"
                        );

                    AddUpdateExtensionParameter(PickListRobot.IDs.ExtParamOpenPicklistsToGroup,
                    "Open picklists to group view",
                    PickListRobot.IDs.ExtCode,
                    Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
                    PmxOpenPicklistsToGroupViewDefinitonKST.NAME,
                    Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.PmxExtensionParameterCodesKST.OPEN_PICK_LISTS_TO_GROUP,
                    conn,
                    "Views"
                    );

                    AddUpdateExtension(WarehouseAutomationController.IDs.ExtCode, "KS Tools WAC (Warehouse Automation Controller",
                        typeof(WarehouseAutomationController), Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IWAREHOUSEAUTOMATIONCONTROLLER, conn);

                    AddUpdateExtensionParameter(Produmex.Sbo.Logex.Data.Generators.PickingForProductionController.PickingForProductionController.IDs.ExtParamCreateProposalForPicking,
                    "Create proposal for picking?",
                    Produmex.Sbo.Logex.Data.Generators.PickingForProductionController.PickingForProductionController.IDs.ExtCode,
                    Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                    "false",
                    PmxExtensionParameterCodes.PICK_FOR_PRODUCTION_CONTROLLER_CREATE_PROPOSAL_FOR_PICKING,
                    conn
                    );

                    //Complete transaction
                    scope.Complete();
                }
            }

            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                {
                    conn.Open();

                    PmxDbVersionUpdaterProvider updateProv = new PmxDbVersionUpdaterProvider(conn);

                    PmxPickListType plType = new PmxPickListType();
                    plType.Code = PmxPickListTypeColumnValues.StandardProduction.VALUE;
                    plType.Name = PmxPickListTypeColumnValues.StandardProduction.DESCR;
                    plType.UseForProduction = true;
                    //AddUpdateUserDefinedObjectData( plType, new string[] { PmxPickListTypeTable.Columns.Code.NAME }, new object[] { plType.Code } );
                    updateProv.AddUpdateUserDefinedObjectData(plType, null, null);

                    SboUserFieldMDProvider udfProv = new SboUserFieldMDProvider(conn);

                    // * UDF's *
                }

                //Complete transaction
                scope.Complete();
            }
            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                {
                    conn.Open();
                    AddUpdateUserFieldsNotInTransaction(conn, typeof(PmxItemKST));
                }

                //Complete transaction
                scope.Complete();
            }
            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                {
                    conn.Open();
                    SboColumnDefinitionAttribute colDef = new SboColumnDefinitionAttribute(PmxSalesOrderTableKST.Columns.AutoCreatePickList.NAME,
                        PmxSalesOrderTableKST.Columns.AutoCreatePickList.DESCR,
                        PmxSalesOrderTableKST.Columns.AutoCreatePickList.TYPE,
                        PmxSalesOrderTableKST.Columns.AutoCreatePickList.SIZE,
                        PmxSalesOrderTableKST.Columns.AutoCreatePickList.SUB_TYPE);
                    colDef.SboBOColumnConverterType = typeof(SboBooleanConvertor);
                    colDef.DefaultValue = SboBooleanColumnValues.Y.VALUE;
                    SboUserFieldMDProvider udfProv = new SboUserFieldMDProvider(conn);
                    udfProv.AddUpdateUserfield(PmxSalesOrderTableKST.NAME, colDef);
                }

                //Complete transaction
                scope.Complete();
            }
            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                {
                    conn.Open();
                    SboColumnDefinitionAttribute colDef = new SboColumnDefinitionAttribute(
                        PmxCountryTableKST.Columns.ExapaqCountryCode.NAME,
                        PmxCountryTableKST.Columns.ExapaqCountryCode.DESCR,
                        PmxCountryTableKST.Columns.ExapaqCountryCode.TYPE,
                        PmxCountryTableKST.Columns.ExapaqCountryCode.SIZE,
                        PmxCountryTableKST.Columns.ExapaqCountryCode.SUB_TYPE);
                    SboUserFieldMDProvider udfProv = new SboUserFieldMDProvider(conn);
                    udfProv.AddUpdateUserfield(PmxCountryTableKST.NAME, colDef);
                }

                //Complete transaction
                scope.Complete();
            }
            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                {
                    conn.Open();
                    SboColumnDefinitionAttribute colDef = new SboColumnDefinitionAttribute(
                        PmxBusinessPartnerTableKST.Columns.TransportInformation.NAME,
                        PmxBusinessPartnerTableKST.Columns.TransportInformation.DESCR,
                        PmxBusinessPartnerTableKST.Columns.TransportInformation.TYPE,
                        PmxBusinessPartnerTableKST.Columns.TransportInformation.SIZE,
                        PmxBusinessPartnerTableKST.Columns.TransportInformation.SUB_TYPE);
                    SboUserFieldMDProvider udfProv = new SboUserFieldMDProvider(conn);
                    udfProv.AddUpdateUserfield(PmxBusinessPartnerTableKST.NAME, colDef);
                }

                //Complete transaction
                scope.Complete();
            }
            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                {
                    conn.Open();

                    SboColumnDefinitionAttribute colDef = new SboColumnDefinitionAttribute(PmxWarehouseTableKST.Columns.InternalWhs.NAME,
                        PmxWarehouseTableKST.Columns.InternalWhs.DESCR,
                        PmxWarehouseTableKST.Columns.InternalWhs.TYPE,
                        PmxWarehouseTableKST.Columns.InternalWhs.SIZE,
                        PmxWarehouseTableKST.Columns.InternalWhs.SUB_TYPE);
                    colDef.SboBOColumnConverterType = typeof(SboBooleanConvertor);
                    colDef.DefaultValue = SboBooleanColumnValues.N.VALUE;
                    SboUserFieldMDProvider udfProv = new SboUserFieldMDProvider(conn);
                    udfProv.AddUpdateUserfield(PmxWarehouseTableKST.NAME, colDef);

                }

                //Complete transaction
                scope.Complete();
            }

            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                {
                    conn.Open();
                    AddUpdateFormattedSearches(conn);
                }

                //Complete transaction
                scope.Complete();
            }

            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (PmxDbConnectionHana dbConn = new PmxDbConnectionHana(CONNECTION_STRING))
                {
                    dbConn.Open();
                    // Views
                    Assembly assembly = Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.KSTools.SboCommands));
                    string viewName = Produmex.Sbo.Logex.KSTools.ViewObjects.Definitions.Views.PmxPicklistForProductionViewDefinitionKST.NAME;
                    //string resourceName = ReflectionHelper.GetAssemblyName(MethodInfo.GetCurrentMethod()) + ".Scripts.Views." + viewName + ".sql";
                    string resourceName = "Produmex.Sbo.Logex.KSTools" + ".Scripts.Views." + viewName + ".sql";
                    dbConn.DbTool.CreateUpdateView(viewName, PreprocessSqlScript(ResourceHelper.ReadResourceContentAsString(assembly, resourceName), dbConn));

                    viewName = Produmex.Sbo.Logex.KSTools.ViewObjects.Definitions.Views.PmxComponentSalesItemViewDefinitionKST.NAME;
                    resourceName = "Produmex.Sbo.Logex.KSTools" + ".Scripts.Views." + viewName + ".sql";
                    dbConn.DbTool.CreateUpdateView(viewName, PreprocessSqlScript(ResourceHelper.ReadResourceContentAsString(assembly, resourceName), dbConn));

                    viewName = Produmex.Sbo.Logex.KSTools.ViewObjects.Definitions.Views.PmxOpenProductionOrdersViewDefinitionKST.NAME;
                    resourceName = "Produmex.Sbo.Logex.KSTools" + ".Scripts.Views." + viewName + ".sql";
                    dbConn.DbTool.CreateUpdateView(viewName, PreprocessSqlScript(ResourceHelper.ReadResourceContentAsString(assembly, resourceName), dbConn)); 
                    
                    viewName = Produmex.Sbo.Logex.KSTools.ViewObjects.Definitions.Views.PmxOpenPicklistsToGroupViewDefinitonKST.NAME;
                    resourceName = "Produmex.Sbo.Logex.KSTools" + ".Scripts.Views." + viewName + ".sql";
                    dbConn.DbTool.CreateUpdateView(viewName, PreprocessSqlScript(ResourceHelper.ReadResourceContentAsString(assembly, resourceName), dbConn));

                    dbConn.DbTool.ExecuteStoredProc(false, "PMX_SP_Create_TMP_Tables");
                    viewName = "PMX_OPEN_DOCUMENT_REPORT_PICKLIST_KST";
					resourceName = "Produmex.Sbo.Logex.KSTools.Scripts.Views.PMX_OPEN_DOCUMENT_REPORT_PICKLIST_KST.sql";
                    dbConn.DbTool.CreateUpdateView(viewName, PreprocessSqlScript(ResourceHelper.ReadResourceContentAsString(assembly, resourceName), dbConn));
                }

                //Complete transaction
                scope.Complete();
            }



            #region "Updating UDF's on OCRY not possible from code! Must be done through SAP B1 screens"

            //string[][] mapSboCountryCodeToExapasCountryCode = new string[][] {
            //    new string[] { "DE", "D" }, 
            //    new string[] { "AD", "AND" } 
            //};

            //using ( TransactionScope scope = PmxDbConnection.GetNewTransactionScope() )
            //{
            //    using ( SboConnection conn = new SboConnection( CONNECTION_STRING ) )
            //    {
            //        conn.Open(); //Open connection to SAP

            //        using ( CollectionWithCOMRelease comReleaser = new CollectionWithCOMRelease() )
            //        {
            //            SAPbobsCOM.CountriesService svc = (SAPbobsCOM.CountriesService)conn.Company.GetCompanyService().GetBusinessService( SAPbobsCOM.ServiceTypes.CountriesService );
            //            comReleaser.Push( svc );

            //            SAPbobsCOM.CountryParams cpc = (SAPbobsCOM.CountryParams)svc.GetDataInterface( SAPbobsCOM.CountriesServiceDataInterfaces.csCountryParams );
            //            comReleaser.Push( cpc );

            //            foreach ( string[] mapping in mapSboCountryCodeToExapasCountryCode )
            //            {
            //                cpc.Code = mapping[ 0 ];
            //                Country country = svc.GetCountry( cpc );

            //                string xml = country.ToXMLString();
            //                XmlDocument xmlDoc = new XmlDocument();
            //                xmlDoc.LoadXml( xml );
            //                XmlNode countryNode = xmlDoc.GetElementsByTagName( "Country" )[0];
            //                XmlElement a = xmlDoc.CreateElement( "U_PMX_EXAPAQ_CODE" );
            //                XmlText at = xmlDoc.CreateTextNode(mapping[ 1 ] );
            //                a.AppendChild( at );
            //                countryNode.AppendChild( a );
            //                StringWriter sw = new StringWriter();
            //                xmlDoc.Save( sw );
            //                country.FromXMLString( sw.ToString() );

            //                svc.UpdateCountry( country );
            //            }
            //        }
            //    }

            //    scope.Complete();
            //}

            #endregion

            //PMX connection
            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (PmxDbConnectionHana dbConn = new PmxDbConnectionHana(CONNECTION_STRING))
                {
                    dbConn.Open(); //Open connection to SAP
                                   //Console.WriteLine("Workflows");

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "AfterSSCCLoadedHookScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_AfterSSCCLoadedHookScript\WorkflowScript_AfterSSCCLoadedHookScript.cs", dbConn);
                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.SUB_FLOW, "DoubleCheckSSCCScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_DoubleCheckSSCCScript\WorkflowScript_DoubleCheckSSCCScript.cs", dbConn);
                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "SalesDeliveryCreatedHookScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_SalesDeliveryCreatedHookScript\WorkflowScript_SalesDeliveryCreatedHookScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "MovePartialSSCCKSToolsScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_MovePartialSSCCScript\WorkflowScript_MovePartialSSCCKSToolsScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "AdHocMoveKSToolsScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_AdHocMoveScript\WorkflowScript_AdHocMoveKSToolsScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "BeforePickingWaveHookScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_BeforePickingWaveHookScript\WorkflowScript_BeforePickingWaveHookScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "AfterLogisticUnitFullHookScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_AfterLogisticUnitFullHookScript\WorkflowScript_AfterLogisticUnitFullHookScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "MoveMainFlowKSToolsScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_MoveMainFlowScript\WorkflowScript_MoveMainFlowKSToolsScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "MoveMainFlowKSToolsScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_MoveMainFlowScript\WorkflowScript_MoveMainFlowKSToolsScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "AfterLogisticUnitPackedHookScript",
                    //    SCRIPT_ROOT + @"\WorkflowScript_AfterLogisticUnitPackedHookScript\WorkflowScript_AfterLogisticUnitPackedHookScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "EnterPickListsForPackingHookScript",
                    //   SCRIPT_ROOT + @"\WorkflowScript_EnterPickListsForPackingHookScript\WorkflowScript_EnterPickListsForPackingHookScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.HOOK_FLOW, "GetLocationsForWalMoveHookScript",
                    //   SCRIPT_ROOT + @"\WorkflowScript_GetLocationsForWalMoveHookScript\WorkflowScript_GetLocationsForWalMoveHookScript.cs", dbConn);

                    //AddUpdateWorkflowScript(PmxWorkflowExecutionTypes.SUB_FLOW, "CheckBoxTypeScript",
                    //   SCRIPT_ROOT + @"\WorkflowScript_CheckBoxType\WorkflowScript_CheckBoxTypeScript.cs", dbConn);


                    //Console.WriteLine("Tables");

                    //RunTableSqlScript("PMX_LUID.sql", dbConn);
                    //RunTableSqlScript("PMX_KST_DCSS.sql", dbConn);
                    //RunTableSqlScript( "PMX_KST_WAIS.sql", dbConn );
                    //   }

                    //    //Complete transaction
                    //    scope.Complete();
                    //}

                    //using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
                    //{
                    //    using (SboConnection conn = new SboConnection(CONNECTION_STRING))
                    //    {
                    Console.WriteLine("Connection is open to database");

                    Console.WriteLine("Add Functions ");

                    Console.WriteLine("Add SP PMX_SP_KSToolsCreateTables");
                    dbConn.DbTool.CreateUpdateStoredProc("PMX_SP_KSToolsCreateTables", PreprocessSqlScript(dbConn, GetStoredProcedureContent("PMX_SP_KSToolsCreateTables.sql")));

                    dbConn.CreateCommand("CALL \"PMX_SP_KSToolsCreateTables\"()").ExecuteNonQuery();

                    dbConn.DbTool.CreateUpdateStoredProc("PMX_SP_GetOpenSalesOrdersWithStockStatus_KSTRobot", GetStoredProcedureContent("PMX_SP_GetOpenSalesOrdersWithStockStatus_KSTRobot.sql"));

                    //RunFunctionSqlScript("PMX_FN_GetOpenSalesOrdersWithStockStatus_KSTRobot.sql", conn);

                    Console.WriteLine("Add SP PMX_SP_KSToolsTransactionNotification");
                    dbConn.DbTool.CreateUpdateStoredProc("PMX_SP_KSToolsTransactionNotification", PreprocessSqlScript(dbConn, GetStoredProcedureContent("PMX_SP_KSToolsTransactionNotification.sql")));

                    //   RunStoredProcedureSqlScript("PMX_SP_KSToolsTransactionNotification.sql", conn);

                }

                //Complete transaction
                scope.Complete();
            }


        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="conn">The DB connection</param>
        /// <param name="grouping"></param>
        public static void AddUpdateExtensionParameter(string code, string name, string extensionCode, string convertorCode, string defaultValue, PmxDbConnection conn, string grouping = null)
        {
            AddUpdateExtensionParameter(code, name, extensionCode, convertorCode, defaultValue, code, conn, grouping);
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="generalParameterCode">The general parameter code.</param>
        /// <param name="conn">The DB connection</param>
        /// <param name="grouping"></param>
        public static void AddUpdateExtensionParameter(string code, string name, string extensionCode, string convertorCode, string defaultValue, string generalParameterCode, PmxDbConnection conn, string grouping = null)
        {
            AddUpdateExtensionParameter(code, name, extensionCode, convertorCode, defaultValue, generalParameterCode, 0, grouping, conn);
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="generalParameterCode">The general parameter code.</param>
        /// <param name="sequence">The sequence.</param>
        /// <param name="grouping"></param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionParameter(string code, string name, string extensionCode, string convertorCode, string defaultValue, string generalParameterCode, int sequence, string grouping, PmxDbConnection conn)
        {
            PmxExtensionParameterProvider prov = new PmxExtensionParameterProvider(conn);
            PmxExtensionParameter extParam = null;
            try
            {
                bool newBO = false;
                extParam = prov.GetBO(code);
                if (extParam == null)
                {
                    newBO = true;
                    extParam = prov.GetNewBO();
                    extParam.Code = code;
                }
                extParam.Name = name;
                extParam.ExtensionCode = extensionCode;
                extParam.ConvertorCode = convertorCode;
                extParam.GeneralParameterCode = generalParameterCode;
                extParam.DefaultValue = defaultValue;
                extParam.Sequence = sequence;
                extParam.Grouping = grouping;
                if (newBO)
                {
                    prov.AddBO(extParam);
                }
                else
                {
                    prov.UpdateBO(extParam, false, false);
                }
            }
            finally
            {
                if (extParam != null) extParam.Dispose();
            }
        }

        /// <summary>
        /// Add/update <see cref="PmxExtensionType"/>
        /// </summary>
        /// <param name="code">The code of the extension type.</param>
        /// <param name="name">The name of the extension type.</param>
        /// <param name="interfaceType">The interface type of the extension type.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionType(string code, string name, Type interfaceType, PmxDbConnection conn)
        {
            PmxExtensionTypeProvider prov = new PmxExtensionTypeProvider(conn);
            PmxExtensionType exType = null;
            try
            {
                bool newBO = false;
                exType = prov.GetBO(code);
                if (exType == null)
                {
                    newBO = true;
                    exType = prov.GetNewBO();
                    exType.Code = code;
                }
                exType.Name = name;
                exType.InterfaceType = ReflectionHelper.GetTypeAndAssemblyName(interfaceType);
                if (newBO)
                {
                    prov.AddBO(exType);
                }
                else
                {
                    prov.UpdateBO(exType, false, false);
                }
            }
            finally
            {
                if (exType != null) exType.Dispose();
            }
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtension"/>
        /// </summary>
        /// <param name="code">The code of the extension.</param>
        /// <param name="name">The name of the extension.</param>
        /// <param name="type">The type of the extension.</param>
        /// <param name="extensionTypeCode">The extension type code.</param>
        /// <param name="conn">The DB connection</param>
        private static void AddUpdateExtension(string code, string name, Type type, string extensionTypeCode, PmxDbConnection conn)
        {
            PmxExtensionProvider prov = new PmxExtensionProvider(conn);
            PmxExtension extension = null;
            try
            {
                bool newBO = false;
                extension = prov.GetBO(code);
                if (extension == null)
                {
                    newBO = true;
                    extension = prov.GetNewBO();
                    extension.Code = code;
                }
                extension.Name = name;
                extension.ExtensionTypeCode = extensionTypeCode;
                extension.Type = ReflectionHelper.GetTypeAndAssemblyName(type);
                if (newBO)
                {
                    prov.AddBO(extension);
                }
                else
                {
                    prov.UpdateBO(extension, false, false);
                }
            }
            finally
            {
                if (extension != null) extension.Dispose();
            }
        }

        /// <summary>
        /// Preprocesses the SQL script.
        /// </summary>
        /// <param name="conn">The connection.</param>
        /// <param name="query">The query.</param>
        /// <returns></returns>
        public static string PreprocessSqlScript(PmxDbConnectionHana conn, string query)
        {
            query = query.Replace("{DB-SCHEMA}", "\"" + conn.ConnectionStringObject.CompanyDBSchema.SchemaName + "\"");
            return query;
        }

        /// <summary>
        /// Runs the function SQL script.
        /// </summary>
        /// <param name="script">The script.</param>
        /// <param name="conn">The conn.</param>
        private static void RunFunctionSqlScript(string script, PmxDbConnection conn)
        {
            string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.KSTools.SboCommands)), "Produmex.Sbo.Logex.KSTools.Scripts.Functions." + script);
            SboRecordsetHelper.RunSqlScript(s_log, content, conn);
        }
        /// <summary>
        /// Gets the content of the function.
        /// </summary>
        /// <param name="script">The script.</param>
        /// <returns></returns>
        private static string GetFunctionContent(string script)
        {
            string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.KSTools.SboCommands)), "Produmex.Sbo.Logex.KSTools.Scripts.Functions." + script);
            return content;
        }

        /// <summary>
        /// Runs the stored procedure SQL script.
        /// </summary>
        /// <param name="spScript">The sp script.</param>
        /// <param name="conn">The conn.</param>
        private static void RunStoredProcedureSqlScript(string spScript, PmxDbConnection conn)
        {
            string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.KSTools.SboCommands)), "Produmex.Sbo.Logex.KSTools.Scripts.StoredProcedures." + spScript);
            SboRecordsetHelper.RunSqlScript(s_log, content, conn);
        }

        /// <summary>
        /// Gets the content of the stored procedure.
        /// </summary>
        /// <param name="spScript">The sp script.</param>
        private static string GetStoredProcedureContent(string spScript)
        {
            string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.KSTools.SboCommands)), "Produmex.Sbo.Logex.KSTools.Scripts.StoredProcedures." + spScript);
            return content;
        }


        /// <summary>
        /// Add/Update script workflow
        /// </summary>
        /// <param name="executionType">Type of the execution.</param>
        /// <param name="name">The name of the flow.</param>
        /// <param name="sourceFilePath">Name of the file.</param>
        /// <param name="sqlConn">The SQL conn.</param>
        private static void AddUpdateWorkflowScript(string executionType, string name, string sourceFilePath, PmxDbConnectionSql sqlConn)
        {
            PmxWorkflowProvider wfProvider = new PmxWorkflowProvider(sqlConn);
            PmxWorkflow workflow = wfProvider.GetWorkflowByName(name);
            PmxWorkflowScriptProvider wfscProvider = new PmxWorkflowScriptProvider(sqlConn);
            PmxWorkflowScript bo = null;
            if (workflow == null)
            {
                //add the workflow
                bo = wfscProvider.GetNewBO();
                bo.Name = name;
                wfscProvider.AddBO(bo);
            }
            else
            {
                if (workflow.ObjType == Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxWorkflowScript)
                {
                    bo = wfscProvider.GetBO(workflow.InternalKey);

                }
            }

            if (bo != null)
            {
                bo.ExecutionType = executionType;

                wfscProvider.UpdateSourceFromFileAndCompile(bo, sourceFilePath, sqlConn);
            }
        }



        /// <summary>
        /// Runs the table SQL script.
        /// </summary>
        /// <param name="tableScript">The table script.</param>
        /// <param name="conn">The conn.</param>
        private static void RunTableSqlScript(string tableScript, PmxDbConnection conn)
        {
            string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.KSTools.SboCommands)), "Produmex.Sbo.Logex.KSTools.Scripts.Tables." + tableScript);
            SboRecordsetHelper.RunSqlScript(s_log, content, conn);
        }

        private static void AddUpdateFormattedSearches(SboConnection conn)
        {
            SboUserQueryCategoryProvider uqcProvider = new SboUserQueryCategoryProvider(conn);

            int categoryCode;
            using (SboUserQueryCategory category = uqcProvider.GetUserQueryCategoryByName(PmxUserQueryCategoryName.PMX_ADDON))
            {
                categoryCode = category.Code;
            }

            PmxDbVersionUpdaterProvider dbProv = new PmxDbVersionUpdaterProvider(conn);

            int userQueryID = dbProv.AddUpdateUserQuery("PMX_KST_GET_AUTO_CREATE_PL", categoryCode,
@"select ISNULL(NULLIF(U_PMX_KST_APLC,''),'N') from [@PMX_PLTY]
where code = $[ORDR.U_PMX_PLTY]");


            dbProv.AddUpdateFormattedSearch(
                SboFormType.SALES_ORDER,
                PmxSalesOrderTableKST.Columns.AutoCreatePickList.NAME,
                PmxSalesOrderTableKST.Columns.AutoCreatePickList.NAME,
                userQueryID,
                PmxSalesOrderTableKST.Columns.PickListType.NAME,
                false);

        }

        /// <summary>
        /// Add/Update <see cref="PmxExtension"/>
        /// </summary>
        /// <param name="code">The code of the extension.</param>
        /// <param name="name">The name of the extension.</param>
        /// <param name="type">The type of the extension.</param>
        /// <param name="extensionTypeCode">The extension type code.</param>
        /// <param name="conn">The SBO connection</param>
        private static void AddUpdateExtension(string code, string name, Type type, string extensionTypeCode, SboConnection conn)
        {
            PmxExtensionProvider prov = new PmxExtensionProvider(conn);
            PmxExtension extension = null;
            try
            {
                bool newBO = false;
                extension = prov.GetBO(code);
                if (extension == null)
                {
                    newBO = true;
                    extension = prov.GetNewBO();
                    extension.Code = code;
                }
                extension.Name = name;
                extension.ExtensionTypeCode = extensionTypeCode;
                extension.Type = ReflectionHelper.GetTypeAndAssemblyName(type);
                if (newBO)
                {
                    prov.AddBO(extension);
                }
                else
                {
                    prov.UpdateBO(extension, false, false);
                }
            }
            finally
            {
                if (extension != null) extension.Dispose();
            }
        }


        /// <summary>
        /// Adds the update user fields not in transaction.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="types">The types.</param>
        private static void AddUpdateUserFieldsNotInTransaction(SboConnection conn, params Type[] types)
        {
            SboUserFieldMDProvider userFieldMDProv = new SboUserFieldMDProvider(conn);
            //System.Data.Common.DbTransaction transaction = null;
            try
            {
                //transaction = this.Connection.BeginTransaction();
                userFieldMDProv.AddUpdateUserFields(types);

                //Commit transaction
                //transaction.Commit();
            }
            catch (Exception)
            {
                //if (transaction != null) transaction.Rollback();
                throw;
            }
        }

        /// <summary>
        /// Preprocesses the SQL script.
        /// </summary>
        /// <param name="query">The query.</param>
        /// <param name="conn">The connection.</param>
        /// <returns></returns>
        private static string PreprocessSqlScript(string query, PmxDbConnection conn)
        {
            string serverType;
            switch (conn.ConnectionStringObject.ServerType)
            {
                case SboServerType.HANA:
                    serverType = "HANA";
                    query = query.Replace("{DB-SCHEMA}", "\"" + conn.ConnectionStringObject.CompanyDBSchema.SchemaName + "\"");
                    break;
                default:
                    serverType = "MSSQL";
                    break;
            }

            int mssqlBlockBegin = query.IndexOf("--<?DB:");
            while (mssqlBlockBegin >= 0)
            {
                int mssqlBlockEnd = query.IndexOf("--?>", mssqlBlockBegin);
                if (mssqlBlockEnd < 0)
                {
                    break;
                }

                if (query.Substring(mssqlBlockBegin + "--<?DB:".Length, serverType.Length) == serverType)
                {
                    query = query.Substring(0, mssqlBlockBegin)
                          + query.Substring(mssqlBlockBegin + "--<?DB:".Length + serverType.Length, mssqlBlockEnd - mssqlBlockBegin - "--<?DB:".Length - serverType.Length)
                          + query.Substring(mssqlBlockEnd + "--?>".Length);
                    mssqlBlockEnd -= "--<?DB:".Length + serverType.Length + "--?>".Length;
                }
                else
                {
                    query = query.Substring(0, mssqlBlockBegin) + query.Substring(mssqlBlockEnd + "--?>".Length);
                    mssqlBlockEnd = mssqlBlockBegin;
                }
                mssqlBlockBegin = query.IndexOf("--<?DB:", mssqlBlockEnd);
            }

            if (conn.ConnectionStringObject.ServerType == SboServerType.HANA)
            {
                int tokenPos = query.IndexOf("ISNULL(", StringComparison.OrdinalIgnoreCase);
                while (tokenPos >= 0)
                {
                    int endPos = tokenPos + "ISNULL(".Length;
                    query = query.Substring(0, tokenPos) + "IFNULL(" + query.Substring(endPos);
                    tokenPos = query.IndexOf("ISNULL(", endPos, StringComparison.OrdinalIgnoreCase);
                }

                tokenPos = query.IndexOf("@");
                while (tokenPos >= 0)
                {
                    if (query[tokenPos - 1] != '"' && Char.IsLetter(query[tokenPos + 1]))
                    {
                        query = query.Substring(0, tokenPos) + "p_" + query.Substring(tokenPos + 1);
                    }
                    tokenPos = query.IndexOf("@", tokenPos + 2);
                }
            }

            return query;
        }
    }

    static class QueryTester
    {

        public static void GenerateTests()
        {
    //        using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
             //   using (SboConnection conn = new SboConnection(Program.CONNECTION_STRING))
                {

                    QueryTester.GenerateQueries(new Produmex.Foundation.Data.HanaClient.HanaTool(null, null), null);
                }
            }
        }

        private static void GenerateQueries(DbTool dbTool, CultureInfo cultureInfo)
        {
            string query;

             query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllOpenProductionOrders(PmxOpenProductionOrdersViewDefinitionKST.NAME, dbTool, cultureInfo); //check

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllOpenSalesOrders(12, 2, "Vendor1", new List<string>() { "TEST" }, dbTool); //check

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllOpenSalesOrdersThatNeedToBeClosed("Vendor1", cultureInfo); //check

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllOpenStockTransfers(12, 2, cultureInfo); //check

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllPickListFromStockTransfersToGroup(cultureInfo); //check

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllPickListToGroup(PmxOpenPicklistsToGroupViewDefinitonKST.NAME, "Vendor1", cultureInfo); //check

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllProposalsForProductionNotLinkedToPickListForAutoCreationOfPickList(cultureInfo); //check

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllProposalsForStockTransfersNotLinkedToPickListForAutoCreationOfPickList(1, true, cultureInfo); //check


            string columnNameDocEntrySalesOrder = PmxSalesOrderTable.NAME + "_" + PmxSalesOrderTable.Columns.DocEntry.NAME;
            string columnNameQuantitySalesOrderLine = PmxSalesOrderLineTable.NAME + "_" + PmxSalesOrderLineTable.Columns.Quantity.NAME;
            string prefix = "Prefix_";

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllProposalsNotLinkedToPickListForAutoCreationOfPickList(0, "Vendor1", false, columnNameDocEntrySalesOrder, columnNameQuantitySalesOrderLine, prefix, cultureInfo); // checked


            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetAllProposalsWithNoBackOrderAndNoTotalPrice(cultureInfo);   //checked

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetOpenProposalsWithFreeItems("Vendor1", cultureInfo);

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetOtherPickListsInWave(5, new System.Collections.ObjectModel.Collection<int>() { 5, 6 }, cultureInfo); //checked

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetPickListTypes(cultureInfo); //checked

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetPickListTypesForExportZone(cultureInfo); //checked

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetPickListTypesForSpecialOperationsZone(cultureInfo); //checked

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetPriorityForBackOrder(cultureInfo);  //checked


            prefix = "SalesItem_";
            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetSalesOrderInfoFromPickList(12, prefix, dbTool);  //checked

            query = Produmex.Sbo.Logex.KSTools.SboCommands.GetSSCCDoubleCheckInternalKeyForSsccAndDocNum("123", 12, cultureInfo);  //checked


            DbQueryBuilder qb = dbTool.GetQueryBuilder();

            qb.Append("SELECT ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME),
                            ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.CodeBars.NAME),
                            ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTableKST.Columns.GenCod.NAME),
                            ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.BarcodeType.NAME),
                            ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.UseInWarehouseAutomationFunctionality.NAME),
                            ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME),
                            ", ", qb.AsIdentifier(PmxItemTableKST.Columns.RotabilityCode.NAME),
                            ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.NAME, PmxBoxTypeByItemTable.Columns.Code.NAME), " AS ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.Columns.PMX_BTIT_Code.NAME),
                            ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.NAME, PmxBoxTypeByItemTable.Columns.BoxType.NAME),
                            ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.NAME, PmxBoxTypeByItemTable.Columns.DividerType.NAME),
                            ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.NAME, PmxBoxTypeByItemTable.Columns.CompartmentNr.NAME),
                            ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.NAME, PmxBoxTypeByItemTable.Columns.Quantity.NAME),
                            ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.NAME, PmxBoxTypeByItemTable.Columns.UpdateDate.NAME),
                            ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.NAME, PmxBoxTypeByItemTable.Columns.UpdateTime.NAME),
                            ", '-' AS ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.Columns.Action.NAME),
                            ", +1 AS ", qb.AsIdentifier("condition"),
                "\r\n FROM ", qb.AsIdentifier(PmxItemTable.VIEW_NAME),
                "\r\n LEFT JOIN ", qb.AsIdentifier(PmxBoxTypeByItemTable.NAME),
                           " ON ", qb.AsIdentifier(PmxBoxTypeByItemTable.Columns.ItemCode.NAME), " = ", qb.AsIdentifier(PmxItemTable.Columns.ItemCode.NAME));
            if (String.IsNullOrEmpty(""))
            {
                string filterTable = "wais";
                qb.Append("\r\n INNER JOIN ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME), " AS ", qb.AsIdentifier(filterTable),
                                       " ON ", qb.AsIdentifier(filterTable, PmxWAItemInterfacingStatusTableKST.Columns.ItemCode.NAME), " = ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME),
                           "\r\n WHERE ", qb.AsIdentifier(filterTable, PmxWAItemInterfacingStatusTableKST.Columns.Action.NAME), " <> ' '");
            }
            else
            {
                qb.Append("\r\n WHERE ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME), " = ", qb.AsString("test"));
            }

            qb.Append("\r\n UNION SELECT ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME),
                                       ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.CodeBars.NAME),
                                       ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTableKST.Columns.GenCod.NAME),
                                       ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.BarcodeType.NAME),
                                       ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.UseInWarehouseAutomationFunctionality.NAME),
                                       ", ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME),
                                       ", ", qb.AsIdentifier(PmxItemTableKST.Columns.RotabilityCode.NAME),
                                       ", ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME, PmxWAItemInterfacingStatusTableKST.Columns.PMX_BTIT_Code.NAME),
                                       ", ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME, PmxWAItemInterfacingStatusTableKST.Columns.ContainerType.NAME),
                                       ", ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME, PmxWAItemInterfacingStatusTableKST.Columns.DividerType.NAME),
                                       ", NULL", // qb.AsIdentifier( PmxWAItemInterfacingStatusTableKST.NAME, PmxWAItemInterfacingStatusTableKST.Columns.CompartmentNr.NAME ),
                                       ", NULL",
                                       ", ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME, PmxWAItemInterfacingStatusTableKST.Columns.LastTxTime.NAME),
                                       ", NULL",
                                       ", ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME, PmxWAItemInterfacingStatusTableKST.Columns.Action.NAME),
                                       ", -1 AS ", qb.AsIdentifier("condition"),
                "\r\n FROM ", qb.AsIdentifier(PmxItemTable.VIEW_NAME),
                "\r\n LEFT JOIN ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME),
                           " ON ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME, PmxWAItemInterfacingStatusTableKST.Columns.ItemCode.NAME), " = ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME));
            if (String.IsNullOrEmpty(""))
            {
                string filterTable = "wais";
                qb.Append("\r\n INNER JOIN ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.NAME), " AS ", qb.AsIdentifier(filterTable),
                                       " ON ", qb.AsIdentifier(filterTable, PmxWAItemInterfacingStatusTableKST.Columns.ItemCode.NAME), " = ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME),
                           "\r\n WHERE ", qb.AsIdentifier(filterTable, PmxWAItemInterfacingStatusTableKST.Columns.Action.NAME), " <> ' '");
            }
            else
            {
                qb.Append("\r\n WHERE ", qb.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME), " = ", qb.AsString("test17"));
            }

            qb.Append("\r\n ORDER BY ", qb.AsIdentifier(PmxItemTable.Columns.ItemCode.NAME),
                                   ", ", qb.AsIdentifier(PmxItemTable.Columns.UseInWarehouseAutomationFunctionality.NAME),
                                   ", ", qb.AsIdentifier(PmxWAItemInterfacingStatusTableKST.Columns.PMX_BTIT_Code.NAME),
                                   ",", qb.AsIdentifier("condition"),
                                   ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.Columns.BoxType.NAME),
                                   ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.Columns.DividerType.NAME),
                                   ", ", qb.AsIdentifier(PmxBoxTypeByItemTable.Columns.CompartmentNr.NAME)
                                   );

            string result = qb.ToString();

        }

    }
}