using System;
using System.Reflection;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Diagnostics;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.Utilities;

namespace Produmex.Sbo.Logex.KSTools.Extensions
{
    /// <summary>
    /// script
    /// </summary>
    public class Script
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        /// <summary>
        /// Prints the report.
        /// </summary>
        /// <param name="eventType">Type of the event.</param>
        /// <param name="key">The key.</param>
        /// <param name="dbConn">The db conn.</param>
        /// <returns></returns>
        public static bool PrintReport(PmxPrintReportEventType eventType, int key, PmxDbConnection dbConn)
        {
            // *** Your script goes here ***
            string query = @" SELECT PMX_PLLI.PickListLineStatus 
            FROM PMX_LPLM INNER JOIN PMX_MVLI ON PMX_LPLM.MoveDocEntry = PMX_MVLI.DocEntry
            INNER JOIN PMX_PLLI ON PMX_LPLM.PickListDocEntry = PMX_PLLI.DocEntry
            WHERE PickListLineStatus = 'P' AND PMX_MVLI.DestLogUnitIdentKey = " + key.ToString();

            using (ISboRecordset rs = SboRecordsetHelper.RunQuery(s_log, query, dbConn))
            {
                if (rs.RecordCount > 0)
                {
                    return false;
                }
                else
                {
                    return true;
                }
            }
        }

    }
}
