﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Transactions;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.DataObjects;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.DataObjects;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Functions.Definitions;
using Produmex.Sbo.Logex.Data.Generators.PackingController;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Sbo.Logex.Data.Generators.SerialNumberController;
using Produmex.Foundation.Collections;
using Produmex.Sbo.Logex.WorkFlowSteps;

// PmxWorkflowExecutionTypes.SUB_FLOW
namespace Produmex.Sbo.Logex.WorkflowScripts
{
    /// <summary>
    /// Ad hoc move flow
    /// </summary>
    public class WorkflowScript_AdHocMoveKSToolsScript : WorkflowInstanceScriptBase
    {


        // Private fields
        ISboProviderService m_sboProviderService;


        // Input parameters
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;

        public ReadWriteBinder<string> NeededDestinationLocationCode;
        public ReadWriteBinder<string> NeededPickLocationCode;


        private CultureInfo current_DefaultCultureInfo
        {
            get { return DefaultCultureInfo.Get(); }
            //set { DefaultCultureInfo.Set(value); }
        }

        private PmxOseCompany currentPmxOseCompany
        {
            get { return PmxOseCompany.Get(); }
            //set { PmxOseCompany.Set(value); }
        }

        private string currentNeededDestinationLocationCode
        {
            get { return NeededDestinationLocationCode == null ? null : NeededDestinationLocationCode.Get(); }
            set { NeededDestinationLocationCode.Set(value); }
        }

        private string currentNeededPickLocationCode
        {
            get { return NeededPickLocationCode == null ? null : NeededPickLocationCode.Get(); }
            set { NeededPickLocationCode.Set(value); }
        }

        //Subflows

        //move partial SSCC flow
        private WorkflowInstanceBase m_adHocMovePartialSSCCScript;

        //move multiple SSCC flow
        private WorkflowInstanceBase m_adHocMoveMultipleSSCCScript;

        WorkflowInstanceBase m_enterQuantitySubFlow;

        // Sub control
        protected bool SubBackRequested;

        //// Sub values
        protected double SubQuantity;
        protected Collection<string> m_subFlowListOfSerialNumbers;
        protected string m_subFlowWarehouseTransferDestinationPmxWhsCode;




        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);


        #region Constructors

        public WorkflowScript_AdHocMoveKSToolsScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
            m_enterQuantitySubFlow = this.Create("EnterQuantityScript");
        }

        #endregion

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;
            m_sboProviderService = (ISboProviderService)GetScopeParameter("<WwfService>ISboService");

            StepHelper stepHelper = new StepHelper
            {
                DefaultCultureInfo = this.DefaultCultureInfo,
                ShowCustomizedScreen = session.ShowCustomizedScreen,
                WaitForMessage = this.WaitForMessage,
                SboProviderService = m_sboProviderService,
                DeviceId = session.DeviceInstanceId
            };

            string initialErrorKey = null;
            string deviceID = session.DeviceInstanceId;
            SboUserInfo userInfo = sboProviderService.GetCurrentUser();
            Message msg = null;
            string query = null;
            ToolBarButtons toolBarButtons = ToolBarButtons.Back;
            string buttonKeyTask = null;

            string enteredSSCC = null;
            int? fullLUID = null;
            DataSet dsProductsOnSSCC = null;
            Collection<MoveItemInfo> moveItemInfoList = new Collection<MoveItemInfo>();
            string defaultLocationCode = null;
            string destinationLocationCode = null;
            string destinationPmxWhsCode = null;
            string enteredDestinationLocationCode = null;
            string buttonKeyIdentifyDestinationLocationScreen = null;
            DataSet dsZoneTypes = null;
            Collection<string> listOfZoneTypes = new Collection<string>();
            DataSet dsDestinationLocations = null;
            DataSet dsDestinationWarehouses = null;

            bool isWarehouseTransfer = false;
            bool askForSerialNumbers = false;
            bool forceSerial = false;
            bool useRange = false;
            Collection<string> itemCodes = null;
            bool goBack = false;
            int numberOfReports = 0;

            PmxOseWarehouseInfo whsInfo = null;
            bool askReprint = false;
            PmxOseWarehouseInfo whsInfoDevice = sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), deviceID);

            string intermediateDestinationLocation = null;
            string intermediateDestinationPmxWhsCode = null;

            string enteredSourceSiloTank = null;
            string enteredDestinationSiloTank = null;
            string sourceSiloTankCode = null;
            string sourcePmxWhsCode = null;
            string destinationSiloTankCode = null;

            DataSet dsSourceLocations = null;

            string whsCodeToUse = null;
            bool isLocked = false;
            Collection<DocumentRef> list = null;

            #region SUBFLOWS

            m_adHocMovePartialSSCCScript = Create("MovePartialSSCCKSToolsScript");
            m_adHocMovePartialSSCCScript.BindParameters(
                new ReadOnlyBinder<CultureInfo>("DefaultCultureInfo", this, "current_DefaultCultureInfo"),
                new ReadOnlyBinder<PmxOseCompany>("PmxOseCompany", this, "currentPmxOseCompany"),
                new ReadOnlyBinder<string>("DstLocationCode", this, "currentNeededDestinationLocationCode"),
                new ReadOnlyBinder<string>("SrcLocationCode", this, "currentNeededPickLocationCode"),
                new ReadOnlyBinder<string>("WarehouseTransferDestinationPmxWhsCode", this, "m_subFlowWarehouseTransferDestinationPmxWhsCode")
                );

            m_adHocMoveMultipleSSCCScript = Create("MoveMultipleSSCCScript");
            m_adHocMoveMultipleSSCCScript.BindParameters(
                new ReadOnlyBinder<CultureInfo>("DefaultCultureInfo", this, "current_DefaultCultureInfo"),
                new ReadOnlyBinder<PmxOseCompany>("PmxOseCompany", this, "currentPmxOseCompany"),
                new ReadWriteBinder<string>("NeededDestinationLocationCode", this, "currentNeededDestinationLocationCode"),
                new ReadOnlyBinder<string>("WarehouseTransferDestinationPmxWhsCode", this, "m_subFlowWarehouseTransferDestinationPmxWhsCode"));


            #endregion

        Step_SelectWhsMove:

            #region SELECT WAREHOUSE MOVE

            toolBarButtons = ToolBarButtons.Back;
            buttonKeyTask = null;
            m_subFlowWarehouseTransferDestinationPmxWhsCode = null;
            isWarehouseTransfer = false;

            if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
            {
                query = BuildQuery.GetStorageLocationForZoneTypes(enteredDestinationLocationCode, null, null, false);
                DataSet ds = sboProviderService.RunView(false, null, null, query);

                if (this.GetNumberOfRows(ds) > 0)
                {
                    if (goBack)
                    {
                        return;
                    }
                    m_subFlowWarehouseTransferDestinationPmxWhsCode = ds.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name] as string;
                    goto Step_SelectMoveTask;
                }

            }

            query = BuildQuery.GetWarehouses(whsInfoDevice.PmxWarehouseCode, deviceID);
            dsDestinationWarehouses = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsDestinationWarehouses) == 1)
            {
                if (goBack)
                {
                    return;
                }
                //only one warehouse, so warehouse transfers are not possible
                m_subFlowWarehouseTransferDestinationPmxWhsCode = dsDestinationWarehouses.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name] as string;
                goto Step_SelectMoveTask;
            }


            goBack = false;

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_TITLE_SELECT_TYPE_TO_MOVE",
                    "AllowedButtons", new string[2] { "MSG_BUTTON_LOCAL_MOVE",
                    "MSG_BUTTON_WAREHOUSE_TRANSFER"},
                    "EnabledToolBarButtons", toolBarButtons
                    ));
            msg = WaitForMessage();
            initialErrorKey = null;
            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                buttonKeyTask = ExtractParameter<string>(msg.Parameters, "buttonKey");

                if (buttonKeyTask == "MSG_BUTTON_WAREHOUSE_TRANSFER")
                {
                    isWarehouseTransfer = true;
                    goto Step_SelectDestinationWarehouse;
                }
                else
                {
                    //local move so we de not need to select warehouse
                    goto Step_SelectMoveTask;
                }
            }

            if (msg.Name.EndsWith(".BackRequested"))
            {
                return;
            }


            #endregion

        Step_SelectDestinationWarehouse:

            #region SELECT DESTINATION WAREHOUSE

            m_subFlowWarehouseTransferDestinationPmxWhsCode = null;

            query = BuildQuery.GetWarehouses(whsInfoDevice.PmxWarehouseCode, deviceID);
            dsDestinationWarehouses = sboProviderService.RunView(false, null, null, query);

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_SELECT_DESTINATION_WAREHOUSE",
                "LocationDS", dsDestinationWarehouses,
                "ShowStopButton", false));

            msg = WaitForMessage();
            // Reset latest error
            initialErrorKey = null;

            if (msg.Name.EndsWith(".LocationSelected"))
            {
                m_subFlowWarehouseTransferDestinationPmxWhsCode = ExtractParameter<string>(msg.Parameters, "locationCode");
                goto Step_SelectMoveTask;
            }


            //go back
            goto Step_SelectWhsMove;


            #endregion

        Step_SelectMoveTask:

            #region SELECT MOVE TASK

            toolBarButtons = ToolBarButtons.Back;
            buttonKeyTask = null;

            string[] buttonList = new string[4] { "MSG_BUTTON_FULL_LUID",
                    "MSG_BUTTON_PARTIAL_LUID",
                    "MSG_BUTTON_MULTIPLE_LUID",
                    "MSG_BUTTON_BULK_MOVE"};

            if (isWarehouseTransfer)
            {
                buttonList = new string[3] { "MSG_BUTTON_FULL_LUID",
                    "MSG_BUTTON_PARTIAL_LUID",
                    "MSG_BUTTON_MULTIPLE_LUID"};
            }
            
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_TITLE_SELECT_TASK_TO_MOVE",
                    "AllowedButtons", buttonList,
                    "EnabledToolBarButtons", toolBarButtons
                    ));
            msg = WaitForMessage();
            initialErrorKey = null;
            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                buttonKeyTask = ExtractParameter<string>(msg.Parameters, "buttonKey");

                if (buttonKeyTask == "MSG_BUTTON_MULTIPLE_LUID")
                {
                    base.StartSubFlowAndWait(m_adHocMoveMultipleSSCCScript, true);

                    goto Step_SelectWhsMove;
                }
                else if (buttonKeyTask == "MSG_BUTTON_PARTIAL_LUID")
                {
                    base.StartSubFlowAndWait(m_adHocMovePartialSSCCScript, true);

                    goto Step_SelectWhsMove;
                }
                if (buttonKeyTask == "MSG_BUTTON_BULK_MOVE")
                {
                    goto Step_IdentifySourceSiloTank;
                }

                goto Step_IdentifySSCC;
            }

            if (msg.Name.EndsWith(".BackRequested"))
            {
                goBack = true;
                goto Step_SelectWhsMove;
            }


            #endregion

        Step_IdentifySSCC:

            #region IDENTIFY SSCC

            enteredSSCC = null;
            fullLUID = null;
            dsProductsOnSSCC = null;


            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Reception.IIdentifySSCCScreen),
                this.DefaultCultureInfo, BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_IDENTIFY_SSCC",
                "ButtonNoSSCC", false));
            initialErrorKey = null;
            msg = WaitForMessage();

            initialErrorKey = null;
            if (msg.Name.EndsWith(".SSCCEntered"))
            {
                enteredSSCC = ExtractParameter<string>(msg.Parameters, "sscc");

                //check if SSCC exists
                query = BuildQuery.GetProductOnSSCC(enteredSSCC, currentNeededPickLocationCode);
                dsProductsOnSSCC = sboProviderService.RunView(false, null, null, query);

                if (this.GetNumberOfRows(dsProductsOnSSCC) == 0)
                {
                    //SSCC not valid
                    initialErrorKey = "MSG_ERROR_INVALID_SSCC";
                    goto Step_IdentifySSCC;
                }


                //get warehouse
                whsInfo = sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), dsProductsOnSSCC.Tables[0].Rows[0][PmxInventoryTotalTable.Columns.StorLocCode.NAME] as string);


                goto Step_AddItemsToList;

            }

            //go back 
            goto Step_SelectMoveTask;



            #endregion

        Step_AddItemsToList:

            #region ADD ITEMS TO LIST

            intermediateDestinationLocation = null;
            intermediateDestinationPmxWhsCode = null;

            string tempDefaultLocationCode = null;
            moveItemInfoList = new Collection<MoveItemInfo>();
            fullLUID = null;
            if (this.GetNumberOfRows(dsProductsOnSSCC) > 0)
            {
                itemCodes = new Collection<string>();
                foreach (DataRow row in dsProductsOnSSCC.Tables[0].Rows)
                {
                    string itemCode = row[PmxItemTable.Columns.ItemCode.NAME] as string;
                    if (!itemCodes.Contains(itemCode))
                    {
                        itemCodes.Add(itemCode);
                    }
                }

                Dictionary<string, PmxItemInfo> itemInfos = m_sboProviderService.InvokeMethodWithDbConnection<Dictionary<string, PmxItemInfo>>(false, false, null, null,
                    delegate(PmxDbConnection conn, object[] parameters)
                    {
                        PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
                        return prov.GetCachedItemInfoInDictionary(itemCodes);
                    });


                foreach (DataRow row in dsProductsOnSSCC.Tables[0].Rows)
                {
                    MoveItemInfo newItemInfo = new MoveItemInfo();

                    newItemInfo.ItemTransactionalInfoKey = Convertor.ConvertToInt32Nullable(row[PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME]);

                    newItemInfo.DestinationLogisticUnitIdentKey = Convertor.ConvertToInt32Nullable(row[PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME]);
                    newItemInfo.SourceLogisticUnitIdentKey = newItemInfo.DestinationLogisticUnitIdentKey;
                    fullLUID = newItemInfo.DestinationLogisticUnitIdentKey;

                    newItemInfo.DestinationQualityStatusCode = row[PmxInventoryTotalTable.Columns.QualityStatusCode.NAME] as string;
                    newItemInfo.ItemCode = row[PmxItemTable.Columns.ItemCode.NAME] as string;
                    newItemInfo.ItemDescription = row[PmxItemTable.Columns.ItemName.NAME] as string;
                    newItemInfo.Quantity = Convert.ToDouble(row[PmxInventoryTotalTable.Columns.Quantity.NAME]);
                    newItemInfo.SourceLocationCode = row[PmxInventoryTotalTable.Columns.StorLocCode.NAME] as string;
                    newItemInfo.SourcePmxWhsCode = row[PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME] as string;
                    newItemInfo.SourceQualityStatusCode = row[PmxInventoryTotalTable.Columns.QualityStatusCode.NAME] as string;
                    newItemInfo.Uom = row[PmxItemTable.Columns.InventoryUom.NAME] as string;
                    newItemInfo.QuantityPerUom = 1;

                    if (itemInfos[newItemInfo.ItemCode].HasSerialNumber)
                    {

                        //check if serial numbers need to be asked
                        askForSerialNumbers = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null,
                        delegate(PmxDbConnection conn, object[] parameters)
                        {
                            PmxSerialNumberProvider prov = new PmxSerialNumberProvider(conn);
                            return prov.MoveNeedsSerialNumbers(newItemInfo.SourcePmxWhsCode, m_subFlowWarehouseTransferDestinationPmxWhsCode);
                        });

                        forceSerial = false;
                        useRange = false;

                        string[] buttonKeys = new string[2] { "MSG_BUTTON_SERIAL_NUMBER", "MSG_BUTTON_SERIAL_NUMBER_RANGE" };


                        if (newItemInfo.SourcePmxWhsCode == m_subFlowWarehouseTransferDestinationPmxWhsCode ||
                            string.IsNullOrEmpty(m_subFlowWarehouseTransferDestinationPmxWhsCode))
                        {
                            bool askForDestinationLocation = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null,
                                delegate(PmxDbConnection conn, object[] parameters)
                                {
                                    PmxSerialNumberProvider prov = new PmxSerialNumberProvider(conn);
                                    return prov.AskDestLocBeforeEnteringSerial();
                                });

                            if (askForDestinationLocation && string.IsNullOrEmpty(intermediateDestinationLocation))
                            {
                                //ask for destination location first

                            Step_EnterDestinationLocationSerial:

                                #region ENTER DESTINATION LOCATION SERIAL

                                destinationLocationCode = null;
                                destinationPmxWhsCode = null;
                                enteredDestinationLocationCode = null;
                                buttonKeyIdentifyDestinationLocationScreen = null;

                                if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
                                {
                                    enteredDestinationLocationCode = currentNeededDestinationLocationCode;
                                    goto Step_SelectDestinationLocationSerial;
                                }


                                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreen),
                                DefaultCultureInfo.Get(), BuildParamCollection(
                                    "InitialErrorKey", initialErrorKey,
                                    "TitleKey", "MSG_TITLE_SCAN_DESTINATION_LOCATION",
                                    "HideDefaultLocation", false,
                                    "DefaultLocation", defaultLocationCode,
                                    "AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION", "MSG_BUTTON_SELECT_EMPTY_LOCATION" }));
                                msg = WaitForMessage();

                                if (msg.Name.EndsWith(".ButtonClicked"))
                                {
                                    buttonKeyIdentifyDestinationLocationScreen = ExtractParameter<string>(msg.Parameters, "buttonKey");
                                    goto Step_SelectDestinationLocationSerial;
                                }

                                if (msg.Name.EndsWith(".LocationEntered"))
                                {
                                    enteredDestinationLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");

                                    goto Step_SelectDestinationLocationSerial;
                                }

                                //go back is not allowed
                                goto Step_EnterDestinationLocationSerial;



                                #endregion

                            Step_SelectDestinationLocationSerial:

                                #region SELECT DESTINATION LOCATION SERIAL

                                destinationLocationCode = null;
                                destinationPmxWhsCode = null;

                                //get list of items/quantities
                                Dictionary<string, PmxStorageLocationCanItemBeStoredInfo> canItemBeStoredInfoPerItemCodeSerial = new Dictionary<string, PmxStorageLocationCanItemBeStoredInfo>();
                                foreach (DataRow rowSerial2 in dsProductsOnSSCC.Tables[0].Rows)
                                {
                                    string itemCodeSerial = rowSerial2[PmxItemTable.Columns.ItemCode.NAME] as string;
                                    double quantitySerial = Convert.ToDouble(rowSerial2[PmxInventoryTotalTable.Columns.Quantity.NAME]);
                                    int? itriSerial = Convertor.ConvertToInt32Nullable(rowSerial2[PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME]);

                                    PmxStorageLocationCanItemBeStoredInfo entry;
                                    if (canItemBeStoredInfoPerItemCodeSerial.TryGetValue(itemCodeSerial, out entry))
                                    {
                                        entry.Quantity += quantitySerial;
                                    }
                                    else
                                    {
                                        entry = new PmxStorageLocationCanItemBeStoredInfo(quantitySerial, null, null);
                                        canItemBeStoredInfoPerItemCodeSerial.Add(itemCodeSerial, entry);
                                    }
                                    if (itriSerial.HasValue)
                                    {
                                        if (entry.ItriKeys == null) entry.ItriKeys = new List<int>();
                                        entry.ItriKeys.Add(itriSerial.Value);
                                    }
                                }

                                //get zonetypes
                                Collection<string> itemCodesSerial = new Collection<string>();
                                foreach (string itemCode in canItemBeStoredInfoPerItemCodeSerial.Keys)
                                {
                                    itemCodesSerial.Add(itemCode);
                                }
                                query = BuildQuery.GetZoneTypesForItems(itemCodesSerial);
                                dsZoneTypes = sboProviderService.RunView(false, null, null, query);

                                listOfZoneTypes = new Collection<string>();
                                if (this.GetNumberOfRows(dsZoneTypes) > 0)
                                {
                                    foreach (DataRow row2 in dsZoneTypes.Tables[0].Rows)
                                    {
                                        listOfZoneTypes.Add(row2[PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME] as string);
                                    }
                                }

                                string whsCodeToUseSerial = m_subFlowWarehouseTransferDestinationPmxWhsCode;

                                if (string.IsNullOrEmpty(whsCodeToUseSerial))
                                {
                                    whsCodeToUseSerial = whsInfo.PmxWarehouseCode;
                                }

                                query = BuildQuery.GetStorageLocationForZoneTypes(enteredDestinationLocationCode, whsCodeToUseSerial, listOfZoneTypes,
                                buttonKeyIdentifyDestinationLocationScreen == "MSG_BUTTON_SELECT_EMPTY_LOCATION");

                                dsDestinationLocations = sboProviderService.RunView(false, null, null, query);

                                if (this.GetNumberOfRows(dsDestinationLocations) == 0)
                                {
                                    // Inform the user with the error
                                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                                        DefaultCultureInfo.Get(), BuildParamCollection(
                                            "MessageKey", "MSG_ERROR_NO_LOCATION_FOUND",
                                            "NoTranslationOfMessageKey", false,
                                            "ShowButton", true));
                                    WaitForMessage();
                                    if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
                                    {
                                        return;
                                    }
                                    else
                                    {
                                        goto Step_EnterDestinationLocationSerial;
                                    }

                                }

                                //locations found
                                if (!string.IsNullOrEmpty(enteredDestinationLocationCode) &&
                                    this.GetNumberOfRows(dsDestinationLocations) == 1)
                                {
                                    intermediateDestinationLocation = Convert.ToString(dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name]);
                                    intermediateDestinationPmxWhsCode = Convert.ToString(dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name]);
                                    goto Step_ProceedSerial;
                                }

                                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                                    DefaultCultureInfo.Get(), BuildParamCollection(
                                    "InitialErrorKey", initialErrorKey,
                                    "TitleKey", "MSG_TITLE_SELECT_DESTINATION_LOCATION",
                                    "LocationDS", dsDestinationLocations,
                                    "ShowStopButton", false));

                                msg = WaitForMessage();
                                // Reset latest error
                                initialErrorKey = null;

                                if (msg.Name.EndsWith(".LocationSelected"))
                                {
                                    intermediateDestinationLocation = ExtractParameter<string>(msg.Parameters, "locationCode");
                                    intermediateDestinationPmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");

                                    goto Step_ProceedSerial;
                                }


                                //go back
                                goto Step_EnterDestinationLocationSerial;


                                #endregion
                            }

                        Step_ProceedSerial:


                            EnterSerialNumbers enterSerialNumber = m_sboProviderService.InvokeMethodWithDbConnection<EnterSerialNumbers>(false, false, null, null,
                                delegate(PmxDbConnection conn, object[] parameters)
                                {
                                    PmxSerialNumberProvider prov = new PmxSerialNumberProvider(conn);
                                    return prov.NeedToEnterSerialNumbers(newItemInfo.SourcePmxWhsCode, intermediateDestinationPmxWhsCode, newItemInfo.SourceLocationCode, intermediateDestinationLocation, new Collection<string>() { newItemInfo.ItemCode });
                                });

                            if (enterSerialNumber == EnterSerialNumbers.MustEnter)
                            {
                                askForSerialNumbers = true;
                            }
                            if (enterSerialNumber == EnterSerialNumbers.CanEnter)
                            {
                                askForSerialNumbers = true;
                                buttonKeys = new string[3] { "MSG_BUTTON_SERIAL_NUMBER", "MSG_BUTTON_SERIAL_NUMBER_RANGE", "MSG_BUTTON_NO_SERIAL_NUMBER" };
                            }
                        }

                        forceSerial = false;
                        useRange = false;

                        if (askForSerialNumbers)
                        {
                            forceSerial = true;
                            //show screen to ask user what to do.

                            toolBarButtons = ToolBarButtons.Back;

                            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
                                    DefaultCultureInfo.Get(), BuildParamCollection(
                                    "InitialErrorKey", initialErrorKey,
                                    "TitleKey", "MSG_TITLE_ENTER_QUANTITY_SERIAL_NUMBER_TASK",
                                    "AllowedButtons", buttonKeys,
                                    "EnabledToolBarButtons", toolBarButtons
                                    ));
                            msg = WaitForMessage();
                            initialErrorKey = null;
                            if (msg.Name.EndsWith(".BackRequested"))
                            {
                                goto Step_IdentifySSCC;
                            }

                            bool proceed = true;

                            if (msg.Name.EndsWith(".ButtonClicked"))
                            {
                                useRange = ExtractParameter<string>(msg.Parameters, "buttonKey") == "MSG_BUTTON_SERIAL_NUMBER_RANGE";

                                if (ExtractParameter<string>(msg.Parameters, "buttonKey") == "MSG_BUTTON_NO_SERIAL_NUMBER")
                                {
                                    proceed = false;
                                }
                            }

                            if (proceed)
                            {

                                SubBackRequested = false;
                                m_enterQuantitySubFlow.BindParameters(
                                    this.DefaultCultureInfo,
                                    this.PmxOseCompany,
                                    new ReadOnlyBinder<string>("TitleKey", "MSG_TITLE_ENTER_QUANTITY"),
                                    new ReadOnlyBinder<PmxItemInfo>("ItemInfo", itemInfos[newItemInfo.ItemCode]),
                                    new ReadOnlyBinder<int?>("ItriKey", newItemInfo.ItemTransactionalInfoKey),
                                    new ReadOnlyBinder<string>("BatchNumber", row[PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME] as string),
                                    new ReadOnlyBinder<DateTime?>("BestBeforeDate", Convertor.ConvertToDateTimeNullable(row[PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME])),
                                    new ReadOnlyBinder<string>("SSCC", enteredSSCC),

                                    new ReadOnlyBinder<bool>("AllowZero", false),
                                    new ReadOnlyBinder<double>("InitialQuantity", 0.0),
                                    new ReadOnlyBinder<double>("MaximumQuantity", newItemInfo.Quantity),
                                    new ReadOnlyBinder<string>("UOM", itemInfos[newItemInfo.ItemCode].InventoryUom),
                                    new ReadOnlyBinder<int>("NumberOfDigitsAfterDecimal", (itemInfos[newItemInfo.ItemCode] == null) ? 0 : itemInfos[newItemInfo.ItemCode].UomDecimals),
                                    new ReadOnlyBinder<double>("InnerQuantity", 0.0),
                                    new ReadOnlyBinder<string>("InnerUOM", null),

                                    new ReadOnlyBinder<string>("DocNum", null),
                                    new ReadOnlyBinder<double>("StillToQuantity", newItemInfo.Quantity),
                                    new ReadOnlyBinder<string>("MessageKeyStillQuantity", "MSG_LBL_MAXIMUM_QUANTITY"),

                                    new ReadOnlyBinder<bool>("ForceInputSerialNumbers", forceSerial),
                                    new ReadOnlyBinder<double>("MinimumQuantity", newItemInfo.Quantity),
                                    new ReadOnlyBinder<string>("ObjectType", Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxMove),
                                    new ReadOnlyBinder<int?>("DocEntry", null),
                                    new ReadOnlyBinder<bool>("UseSerialNumberRange", useRange),
                                    new ReadOnlyBinder<string>("LocationCode", newItemInfo.SourceLocationCode),
                                    new ReadOnlyBinder<string>("DestinationLocationCode", intermediateDestinationLocation),


                                    new ReadWriteBinder<bool>("BackRequested", this, "SubBackRequested"),
                                    new ReadWriteBinder<double>("QuantityEntered", this, "SubQuantity"),
                                    new ReadWriteBinder<Collection<string>>("ListOfSerialNumbers", this, "m_subFlowListOfSerialNumbers")
                                );

                                this.StartSubFlowAndWait(m_enterQuantitySubFlow, true);


                                if (SubBackRequested)
                                {
                                    goto Step_IdentifySSCC;
                                }

                                newItemInfo.ListOfSerialNumbers = m_subFlowListOfSerialNumbers;
                            }
                        }

                    }

                    //Add to list
                    moveItemInfoList.Add(newItemInfo);

                    //Check default location code on items
                    if ((string.Compare(row[PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME] as string,
                       row[PmxInventoryTotalTable.Columns.ItemCode.NAME] as string) != 0 ||
                        (string.Compare(row[PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME] as string,
                       row[PmxInventoryTotalTable.Columns.ItemCode.NAME] as string) == 0 &&
                        Convert.ToDouble(row[PmxInventoryTotalTable.Columns.Quantity.NAME]) != 1)))
                    {
                        string whsCode = m_subFlowWarehouseTransferDestinationPmxWhsCode;
                        if (string.IsNullOrEmpty(whsCode)) {
                            whsCode = whsInfo.PmxWarehouseCode;
                        }

                        string defaultLocationOrZoneCode = sboProviderService.InvokeMethodWithDbConnection<string>(false, false, null, null, new DelegateWithPmxDbConnection<string>(ExecuteGetItemWarehouseDefaultLocationOrZone), newItemInfo.ItemCode, whsCode);

                        if (!string.IsNullOrWhiteSpace(defaultLocationOrZoneCode)) {
                            tempDefaultLocationCode = defaultLocationOrZoneCode;
                        }
                        else {
                            tempDefaultLocationCode = row[PmxItemWarehouseDefaultLocationTable.Columns.DefaultLocationZone.NAME] as string;
                        }
                    }
                    else if (string.Compare(defaultLocationCode, row[PmxItemWarehouseDefaultLocationTable.Columns.DefaultLocationZone.NAME] as string) != 0 &&
                        string.Compare(row[PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME] as string,
                       row[PmxInventoryTotalTable.Columns.ItemCode.NAME] as string) != 0) {
                        //different locations, so no default location
                        tempDefaultLocationCode = null;
                    }
                }
            }

            
            defaultLocationCode = tempDefaultLocationCode;

            goto Step_EnterDestinationLocation;
        

            #endregion

        Step_EnterDestinationLocation:

            #region ENTER DESTINATION LOCATION

            destinationLocationCode = null;
            destinationPmxWhsCode = null;
            enteredDestinationLocationCode = null;
            buttonKeyIdentifyDestinationLocationScreen = null;

            if(!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
            {
                enteredDestinationLocationCode = currentNeededDestinationLocationCode;
                goto Step_SelectDestinationLocation;
            }

            if (!string.IsNullOrEmpty(intermediateDestinationLocation))
            {
                enteredDestinationLocationCode = intermediateDestinationLocation;
                goto Step_SelectDestinationLocation;
            }


            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreen),
            DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_DST_LOCATION_OR_SSCC",
                "HideDefaultLocation", false,
                "DefaultLocation", defaultLocationCode,
                "AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION", "MSG_BUTTON_SELECT_EMPTY_LOCATION" }));
            msg = WaitForMessage();

            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                buttonKeyIdentifyDestinationLocationScreen = ExtractParameter<string>(msg.Parameters, "buttonKey");
                goto Step_SelectDestinationLocation;
            }

            if (msg.Name.EndsWith(".LocationEntered"))
            {
                enteredDestinationLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");

                goto Step_SelectDestinationLocation;
            }

            //go back
            goto Step_IdentifySSCC;



            #endregion

        Step_SelectDestinationLocation:

            #region SELECT DESTINATION LOCATION

            destinationLocationCode = null;
            destinationPmxWhsCode = null;

            //get list of items/quantities
            PmxDictionary<string, PmxStorageLocationCanItemBeStoredInfo> canItemBeStoredInfoPerItemCode = new PmxDictionary<string, PmxStorageLocationCanItemBeStoredInfo>();
            foreach (MoveItemInfo info in moveItemInfoList)
            {
                PmxStorageLocationCanItemBeStoredInfo entry;
                if ( canItemBeStoredInfoPerItemCode.TryGetValue( info.ItemCode, out entry ) )
                {
                    entry.Quantity += info.Quantity;
                }
                else
                {
                    entry = new PmxStorageLocationCanItemBeStoredInfo( info.Quantity, null, null );
                    canItemBeStoredInfoPerItemCode.Add( info.ItemCode, entry );
                }
                if ( info.ItemTransactionalInfoKey.HasValue )
                {
                    if ( entry.ItriKeys == null ) entry.ItriKeys = new List<int>();
                    entry.ItriKeys.Add( info.ItemTransactionalInfoKey.Value );
                }
            }

            //get zonetypes
            itemCodes = new Collection<string>();
            foreach ( string itemCode in canItemBeStoredInfoPerItemCode.Keys )
            {
                itemCodes.Add(itemCode);
            }

            query = BuildQuery.GetZoneTypesForItems(itemCodes);
            dsZoneTypes = sboProviderService.RunView(false, null, null, query);

            listOfZoneTypes = new Collection<string>();
            if (this.GetNumberOfRows(dsZoneTypes) > 0)
            {
                foreach (DataRow row in dsZoneTypes.Tables[0].Rows)
                {
                    listOfZoneTypes.Add(row[PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME] as string);
                }
            }

            whsCodeToUse = m_subFlowWarehouseTransferDestinationPmxWhsCode;

            if(string.IsNullOrEmpty(whsCodeToUse))
            {
                whsCodeToUse = whsInfo.PmxWarehouseCode;
            }

            query = BuildQuery.GetStorageLocationForZoneTypes(enteredDestinationLocationCode, whsCodeToUse, listOfZoneTypes,
            buttonKeyIdentifyDestinationLocationScreen == "MSG_BUTTON_SELECT_EMPTY_LOCATION");

            dsDestinationLocations = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsDestinationLocations) == 0)
            {
                // Inform the user with the error
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "MessageKey", "MSG_ERROR_NO_LOCATION_FOUND",
                        "NoTranslationOfMessageKey", false,
                        "ShowButton", true));
                WaitForMessage();
                if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
                {
                    return;
                }
                else
                {
                    intermediateDestinationLocation = null;
                    goto Step_EnterDestinationLocation;
                }

            }

            //locations found
            if (!string.IsNullOrEmpty(enteredDestinationLocationCode) &&
                this.GetNumberOfRows(dsDestinationLocations) == 1)
            {
                destinationLocationCode = Convert.ToString(dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name]);
                destinationPmxWhsCode = Convert.ToString(dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name]);
               goto Step_CheckLocation;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_SELECT_DESTINATION_LOCATION",
                "LocationDS", dsDestinationLocations,
                "ShowStopButton", false));

            msg = WaitForMessage();
            // Reset latest error
            initialErrorKey = null;

            if (msg.Name.EndsWith(".LocationSelected"))
            {
                destinationLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");
                destinationPmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");

                goto Step_CheckLocation;
            }


            //go back
            goto Step_EnterDestinationLocation;


            #endregion

        Step_CheckLocation:

            #region CHECK LOCATION

            try
            {
                if (sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, new DelegateWithPmxDbConnection<bool>(ExecuteIsLocationLocked), destinationLocationCode))
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", "MSG_ERROR_DESTINATION_LOCATION_LOCKED",
                            "NoTranslationOfMessageKey", false,
                            "ShowButton", true));
                    WaitForMessage();
                    if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
                    {
                        return;
                    }
                    else
                    {
                        goto Step_EnterDestinationLocation;
                    }
                }

                //set location in list
                foreach (MoveItemInfo moveInfo in moveItemInfoList)
                {
                    moveInfo.DestinationLocationCode = destinationLocationCode;
                    moveInfo.DestinationPmxWhsCode = destinationPmxWhsCode;
                }//foreach

                //check if items can be stored on location
                bool canBeStored = sboProviderService.InvokeMethodWithDbConnection<bool>( false, false, null, null, delegate( PmxDbConnection conn, object[] parameters )
                {
                    PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
                    return prov.CanItemsBeStoredOnStorageLocation( destinationLocationCode, canItemBeStoredInfoPerItemCode );
                });
                if ( !canBeStored )
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", "MSG_ERROR_STORAGE_LOCATION_NOT_ALLOWED_FOR_ITEM",
                            "IsError", true, 
                            "ShowButton", true));
                    WaitForMessage();

                    if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
                    {
                        return;
                    }
                    else
                    {
                        goto Step_EnterDestinationLocation;
                    }
                }
                foreach ( KeyValuePair<string, PmxStorageLocationCanItemBeStoredInfo> kv in canItemBeStoredInfoPerItemCode )
                {
                    if ( kv.Value.Status != PmxStorageLocationCanItemBeStored.Yes )
                    {
                        // Warn user and ask to continue
                        session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen ),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "TitleKey", "MSG_TITLE_CONFIRM_MOVE",
                                "MessageKey", "MSG_CONFIRM_ADDING_DIFFERENT_ITEM_OR_BATCH" ) );
                        msg = WaitForMessage();

                        if ( !msg.Name.EndsWith( "IDecisionScreenReply.Yes" ) )
                        {
                            goto Step_EnterDestinationLocation;
                        }
                        break;
                    }
                }

                goto Step_MakeMove;
            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
                if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ex.Message,
                            "NoTranslationOfMessageKey", true,
                            "IsError", true, 
                            "ShowButton", true));
                    WaitForMessage();

                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();
                }
                goto Step_EnterDestinationLocation;
            }

            #endregion

        Step_MakeMove:

            #region MAKE MOVE

            list = null;

            try
            {
                bool useSboConnection = false;

                foreach (MoveItemInfo move in moveItemInfoList)
                {
                    if (move.DestinationPmxWhsCode != move.SourcePmxWhsCode)
                    {
                        //warehouse changes, so we need SBO connection
                        useSboConnection = true;
                        break;
                    }
                }

                list = sboProviderService.InvokeMethodWithDbConnection<Collection<DocumentRef>>(useSboConnection, false, null, null, new DelegateWithPmxDbConnection<Collection<DocumentRef>>(ExecuteMakeAdHocMove), moveItemInfoList, fullLUID, destinationLocationCode);

            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
                if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ex.Message,
                            "NoTranslationOfMessageKey", true,
                            "IsError", true, 
                            "ShowButton", true));
                    WaitForMessage();

                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();
                }

                //retry?
                //ask user if he wants to retry
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_RETRY_UPDATE",
                        "MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_WANT_RETRY"));
                msg = WaitForMessage();

                if (msg.Name.ToLower().EndsWith(".yes"))
                {
                    goto Step_MakeMove;
                }


                goto Step_EnterDestinationLocation;
            }


            // Print move document
            if (!string.IsNullOrEmpty(m_subFlowWarehouseTransferDestinationPmxWhsCode))
            {
                bool proceed = false;
                while (!proceed)
                {
                    numberOfReports = 0;

                    try
                    {

                        foreach (DocumentRef docRef in list)
                        {

                            //trigger event
                            numberOfReports += sboProviderService.InvokeMethodWithDbConnection<int>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
                            {
                                PmxDictionary<string, object> paramList = new PmxDictionary<string, object>();

                                if (docRef.DocType == ((int)SboObjectType.StockTransfer).ToString())
                                {
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.StockTransferDocEntry.NAME, docRef.DocEntry);
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.MoveDocentry.NAME, (int?)null);
                                }
                                else
                                {
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.StockTransferDocEntry.NAME, (int?)null);
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.MoveDocentry.NAME, docRef.DocEntry);
                                }

                                PmxPrintReportProvider printProv = new PmxPrintReportProvider(conn);
                                return printProv.PrintReportsForEventWithParameters(PmxPrintReportEventType.WarehouseMoveAdded, null, session.DeviceInstanceId, paramList, false, out askReprint, stepHelper.GetPrinterFromSelectPrinterScreen);
                            });
                        }//foreach
                    }
                    catch (Produmex.Foundation.ProdumexException ex)
                    {
                        s_log.Error(ex.ToString());
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                                "MessageAddendum", ex.Message,
                                "PmxError", ex.Error,
                                "ShowButton", true));

                        msg = WaitForMessage();
                    }
                    catch (Exception ex)
                    {
                        s_log.Error(ex.ToString());
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                                "MessageAddendum", ex.Message,
                                "PmxError", Produmex.Sbo.Logex.Data.ProdumexErrors.UnexpectedError(s_log, ex),
                                "ShowButton", true));

                        msg = WaitForMessage();
                    }

                    if (numberOfReports > 0 )
                    {
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "MessageKey", "MSG_QUESTION_REPRINT_DOCUMENT",
                                "TitleKey", "MSG_TITLE_REPRINT_DOCUMENT"
                                ));

                        msg = WaitForMessage();

                        if (msg.Name.EndsWith(".No"))
                        {
                            proceed = true;
                        }

                    }
                    else
                    {
                        proceed = true;
                    }

                }


            }




            //inform user
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "MessageKey", "MSG_ITEMS_MOVED",
                    "NoTranslationOfMessageKey", false,
                    "ShowButton", true));
            WaitForMessage();

            if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
            {
                return;
            }
            else
            {
                goto Step_SelectWhsMove;
            }

            #endregion

        Step_IdentifySourceSiloTank:

            #region IDENTIFY SOURCE SILO/TANK

            enteredSourceSiloTank = null;
            enteredDestinationSiloTank = null;
            sourceSiloTankCode = null;
            destinationSiloTankCode = null;
            destinationPmxWhsCode = null;
            sourcePmxWhsCode = null;

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreen),
                  DefaultCultureInfo.Get(), BuildParamCollection(
                  "InitialErrorKey", initialErrorKey,
                  "TitleKey", "MSG_TITLE_IDENTIFY_PICK_LOCATION",
                  "HideDefaultLocation", true,
                  "AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION" }));
            initialErrorKey = null;
            msg = WaitForMessage();

            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.LocationEntered")
            {
                enteredSourceSiloTank = ExtractParameter<string>(msg.Parameters, "locationCode");

                goto Step_SelectSourceSiloTank;
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.ButtonClicked")
            {
                goto Step_SelectSourceSiloTank;
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.BackRequested")
            {
                goto Step_SelectMoveTask;
            }

            #endregion

        Step_SelectSourceSiloTank:

            #region SELECT SOURCE SILO/TANK

            // Get locations
            //query = BuildQuery.GetLocations(enteredSourceSiloTank, true);
            query = BuildQuery.GetStorageLocation(enteredSourceSiloTank, whsInfoDevice.PmxWarehouseCode, session.DeviceInstanceId, true);
            dsSourceLocations = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsSourceLocations) == 0)
            {
                initialErrorKey = "MSG_ERROR_INCORRECT_LOCATION";
                goto Step_IdentifySourceSiloTank;
            }

            //we come from identify location, and location was entered
            if (this.GetNumberOfRows(dsSourceLocations) == 1 &&
                !string.IsNullOrEmpty(enteredSourceSiloTank))
            {
                //autoselect location
                sourceSiloTankCode = dsSourceLocations.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name] as string;
                sourcePmxWhsCode = dsSourceLocations.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name] as string;

                goto Step_CheckSourceLocation;
            }


            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_SELECT_SILOTANK",
                "LocationDS", dsSourceLocations,
                "ShowStopButton", false));

            msg = WaitForMessage();
            // Reset latest error
            initialErrorKey = null;
            sourceSiloTankCode = null;
            sourcePmxWhsCode = null;

            if (msg.Name.EndsWith(".LocationSelected"))
            {
                sourceSiloTankCode = ExtractParameter<string>(msg.Parameters, "locationCode");
                sourcePmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");
                goto Step_CheckSourceLocation;
            }
            else if (msg.Name.EndsWith(".BackRequested"))
            {
                goto Step_IdentifySourceSiloTank;
            }

            //refresh
            goto Step_SelectSourceSiloTank;




            #endregion

        Step_CheckSourceLocation:

            #region CHECK SOURCE LOCATION

            isLocked = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, delegate(PmxDbConnection conn, object[] parameters)
            {
                PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
                return prov.IsLocationLocked(sourceSiloTankCode);
            });

            if (isLocked)
            {
                initialErrorKey = "MSG_ERROR_LOCATION_LOCKED";
                goto Step_IdentifySourceSiloTank;
            }

            goto Step_IdentifyDestinationSiloTank;

            #endregion

        Step_IdentifyDestinationSiloTank:

            #region IDENTIFY DESTINATION SILO/TANK
            enteredDestinationSiloTank = null;
            destinationSiloTankCode = null;
            destinationPmxWhsCode = null;

            if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode) && !string.IsNullOrEmpty(initialErrorKey))
            {
                enteredDestinationSiloTank = currentNeededDestinationLocationCode;
                goto Step_SelectDestinationSiloTank;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreen),
                  DefaultCultureInfo.Get(), BuildParamCollection(
                  "InitialErrorKey", initialErrorKey,
                  "TitleKey", "MSG_TITLE_SCAN_DESTINATION_LOCATION",
                  "HideDefaultLocation", true,
                  "AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION" }));
            initialErrorKey = null;
            msg = WaitForMessage();

            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.LocationEntered")
            {
                enteredDestinationSiloTank = ExtractParameter<string>(msg.Parameters, "locationCode");

                goto Step_SelectDestinationSiloTank;
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.ButtonClicked")
            {
                goto Step_SelectDestinationSiloTank;
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.BackRequested")
            {
                goto Step_IdentifySourceSiloTank;
            }

            #endregion

        Step_SelectDestinationSiloTank:

            #region SELECT DESTINATION SILO/TANK

            whsCodeToUse = m_subFlowWarehouseTransferDestinationPmxWhsCode;

            if (string.IsNullOrEmpty(whsCodeToUse))
            {
                whsCodeToUse = sourcePmxWhsCode;
            }

            // Get locations
            //query = BuildQuery.GetLocations(enteredDestinationSiloTank, true);
            query = BuildQuery.GetStorageLocationForZoneTypes(enteredDestinationSiloTank, whsCodeToUse, null, false, true);
            dsDestinationLocations = sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsDestinationLocations) == 0)
            {
                initialErrorKey = "MSG_ERROR_INCORRECT_LOCATION";
                goto Step_IdentifyDestinationSiloTank;
            }

            //we come from identify location, and location was entered
            if (this.GetNumberOfRows(dsDestinationLocations) == 1 &&
                !string.IsNullOrEmpty(enteredDestinationSiloTank))
            {
                //autoselect location
                destinationSiloTankCode = dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name] as string;
                destinationPmxWhsCode = dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name] as string;
                goto Step_CheckDestinationLocation;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_SELECT_SILOTANK",
                "LocationDS", dsDestinationLocations,
                "ShowStopButton", false));

            msg = WaitForMessage();
            // Reset latest error
            initialErrorKey = null;
            destinationSiloTankCode = null;
            destinationPmxWhsCode = null;

            if (msg.Name.EndsWith(".LocationSelected"))
            {
                destinationSiloTankCode = ExtractParameter<string>(msg.Parameters, "locationCode");
                destinationPmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");
                goto Step_CheckDestinationLocation;
            }
            else if (msg.Name.EndsWith(".BackRequested"))
            {
                goto Step_IdentifyDestinationSiloTank;
            }

            //refresh
            goto Step_SelectDestinationSiloTank;




            #endregion

        Step_CheckDestinationLocation:

            #region CHECK DESTINATION LOCATION

            //location is not same location
            if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode) &&
                currentNeededDestinationLocationCode != destinationLocationCode)
            {
                initialErrorKey = "MSG_ERROR_INCORRECT_LOCATION";
                goto Step_IdentifyDestinationSiloTank;
            }


            isLocked = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, delegate(PmxDbConnection conn, object[] parameters)
            {
                PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
                return prov.IsLocationLocked(destinationSiloTankCode);
            });

            if (isLocked)
            {
                initialErrorKey = "MSG_ERROR_LOCATION_LOCKED";
                goto Step_IdentifyDestinationSiloTank;
            }

            //locations cannot be the same
            if (destinationSiloTankCode == sourceSiloTankCode)
            {
                initialErrorKey = "MSG_ERROR_SRC_SILOTANK_SAME_AS_DST";
                goto Step_IdentifyDestinationSiloTank;
            }

            goto Step_EnterQuantity;

            #endregion

            Step_EnterQuantity:

            #region ENTER QUANTITY

            //get maximum quantity

            double maxQuantity = m_sboProviderService.InvokeMethodWithDbConnection<double>(false, false, null, null, delegate(PmxDbConnection conn, object[] parameters)
            {
                PmxInventoryProvider prov = new PmxInventoryProvider(conn);
                double? dummy;
                return prov.GetCurrentQuantityForLocation(sourceSiloTankCode, out dummy);
            });

            maxQuantity = Math.Min(maxQuantity, m_sboProviderService.InvokeMethodWithDbConnection<double>(false, false, null, null, delegate(PmxDbConnection conn, object[] parameters)
            {
                PmxInventoryProvider prov = new PmxInventoryProvider(conn);
                double? qty;
                prov.GetCurrentQuantityForLocation(destinationLocationCode, out qty);

                return qty.HasValue? qty.Value: double.MaxValue;

            }));

            //check if there is only 1 product on the location
            query = BuildQuery.GetItemCodesOnLocation(sourceSiloTankCode);
            DataSet dsItems = sboProviderService.RunView(false, null, null, query);

            PmxItemInfo itemInfo = null;

            if (this.GetNumberOfRows(dsItems) == 1)
            {
                string itemCode = dsItems.Tables[0].Rows[0][PmxInventoryTotalTable.Columns.ItemCode.NAME] as string;
                itemInfo = m_sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>(false, false, null, null, delegate(PmxDbConnection conn, object[] parameters)
                {
                    PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
                    return prov.GetItemInfo(itemCode);
                });
            }

            


            WorkflowInstanceBase subEnterQuantityFlow = this.Create("EnterQuantityScript");
            SubBackRequested = false;
            subEnterQuantityFlow.BindParameters(
                this.DefaultCultureInfo,
                this.PmxOseCompany,
                new ReadOnlyBinder<string>("TitleKey", "MSG_TITLE_ENTER_QUANTITY"),
                new ReadOnlyBinder<PmxItemInfo>("ItemInfo", itemInfo),
                new ReadOnlyBinder<int?>("ItriKey", null),
                new ReadOnlyBinder<string>("BatchNumber", null),
                new ReadOnlyBinder<DateTime?>("BestBeforeDate", null),
                new ReadOnlyBinder<string>("SSCC", null),

                new ReadOnlyBinder<bool>("AllowZero", false),
                new ReadOnlyBinder<double>("InitialQuantity", 0.0),
                new ReadOnlyBinder<double>("MaximumQuantity", maxQuantity),
                new ReadOnlyBinder<string>("UOM", itemInfo != null ? itemInfo.InventoryUom : null),
                new ReadOnlyBinder<int>("NumberOfDigitsAfterDecimal", itemInfo != null? itemInfo.UomDecimals : 0),
                new ReadOnlyBinder<double>("InnerQuantity", 0.0),
                new ReadOnlyBinder<string>("InnerUOM", null),

                new ReadOnlyBinder<string>("DocNum", null),
                new ReadOnlyBinder<double>("StillToQuantity", maxQuantity),
                new ReadOnlyBinder<string>("MessageKeyStillQuantity", "MSG_LBL_MAXIMUM_QUANTITY"),

              

                new ReadWriteBinder<bool>("BackRequested", this, "SubBackRequested"),
                new ReadWriteBinder<double>("QuantityEntered", this, "SubQuantity")
                );

            base.StartSubFlowAndWait(subEnterQuantityFlow, true);


            if (SubBackRequested)
            {
                goto Step_IdentifyDestinationSiloTank;
            }


            #endregion

        Step_MakeBulkMove:

            #region MAKE BULK MOVE

            list = null;

            try
            {
                bool useSboConnection = destinationPmxWhsCode != sourcePmxWhsCode;

                list = m_sboProviderService.InvokeMethodWithDbConnection<Collection<DocumentRef>>(useSboConnection, false, null, null, delegate(PmxDbConnection conn, object[] parameters)
                {
                    bool isFullQuantity;
                    PmxOseStorageLocationProvider locProv = new PmxOseStorageLocationProvider(conn);
                    Collection<InventoryItemInfo> listOfItems = locProv.GetItemsToConsume(sourceSiloTankCode, null, null, null, null, null, null, SubQuantity, false, out isFullQuantity);

                    if (!isFullQuantity)
                    {
                        //not enough quantity, so throw error
                        throw new ProdumexException(Produmex.Sbo.Logex.Data.ProdumexErrors.NotEnoughStockForConsummation(s_log, sourceSiloTankCode, itemInfo == null ? "-" : itemInfo.ItemCode, SubQuantity));
                    }

                    Collection<MoveItemInfo> listOfMoveItems = new Collection<MoveItemInfo>();

                    foreach (InventoryItemInfo invItemInfo in listOfItems)
                    {
                        MoveItemInfo newItem = new MoveItemInfo();

                        newItem.DestinationQualityStatusCode = invItemInfo.QualityStatusCode;
                        newItem.ItemCode = invItemInfo.ItemCode;
                        newItem.ItemDescription = invItemInfo.ItemDescription;
                        newItem.ItemTransactionalInfoKey = invItemInfo.ItemTransactionalInfoKey;
                        newItem.Quantity = invItemInfo.Quantity;
                        newItem.QuantityPerUom = 1;
                        newItem.SourceLocationCode = invItemInfo.LocationCode;
                        newItem.SourceLogisticUnitIdentKey = invItemInfo.LogisticUnitIdentKey;
                        newItem.SourcePmxWhsCode = sourcePmxWhsCode;
                        newItem.SourceQualityStatusCode = invItemInfo.QualityStatusCode;
                        newItem.Uom = invItemInfo.Uom;

                        newItem.DestinationLocationCode = destinationSiloTankCode;
                        newItem.DestinationLogisticUnitIdentKey = null;
                        newItem.DestinationPmxWhsCode = destinationPmxWhsCode;

                        listOfMoveItems.Add(newItem);
                    }


                    PmxMoveProvider moveProv = new PmxMoveProvider(conn);
                    return moveProv.MakeAdHocMove(listOfMoveItems, null, destinationSiloTankCode);

                });
            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
                if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ex.Message,
                            "NoTranslationOfMessageKey", true,
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();

                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();
                }

                //retry?
                //ask user if he wants to retry
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_RETRY_UPDATE",
                        "MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_WANT_RETRY"));
                msg = WaitForMessage();

                if (msg.Name.ToLower().EndsWith(".yes"))
                {
                    goto Step_MakeBulkMove;
                }


                goto Step_EnterQuantity;
            }


            // Print move document
            if (!string.IsNullOrEmpty(m_subFlowWarehouseTransferDestinationPmxWhsCode))
            {
                bool proceed = false;
                while (!proceed)
                {
                    numberOfReports = 0;

                    try
                    {

                        foreach (DocumentRef docRef in list)
                        {

                            //trigger event
                            numberOfReports += sboProviderService.InvokeMethodWithDbConnection<int>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
                            {
                                PmxDictionary<string, object> paramList = new PmxDictionary<string, object>();

                                if (docRef.DocType == ((int)SboObjectType.StockTransfer).ToString())
                                {
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.StockTransferDocEntry.NAME, docRef.DocEntry);
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.MoveDocentry.NAME, (int?)null);
                                }
                                else
                                {
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.StockTransferDocEntry.NAME, (int?)null);
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.MoveDocentry.NAME, docRef.DocEntry);
                                }

                                PmxPrintReportProvider printProv = new PmxPrintReportProvider(conn);
                                return printProv.PrintReportsForEventWithParameters(PmxPrintReportEventType.WarehouseMoveAdded, null, session.DeviceInstanceId, paramList, false, out askReprint, stepHelper.GetPrinterFromSelectPrinterScreen);
                            });
                        }//foreach
                    }
                    catch (Produmex.Foundation.ProdumexException ex)
                    {
                        s_log.Error(ex.ToString());
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                                "MessageAddendum", ex.Message,
                                "PmxError", ex.Error,
                                "ShowButton", true));

                        msg = WaitForMessage();
                    }
                    catch (Exception ex)
                    {
                        s_log.Error(ex.ToString());
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                                "MessageAddendum", ex.Message,
                                "PmxError", Produmex.Sbo.Logex.Data.ProdumexErrors.UnexpectedError(s_log, ex),
                                "ShowButton", true));

                        msg = WaitForMessage();
                    }

                    if (numberOfReports > 0)
                    {
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "MessageKey", "MSG_QUESTION_REPRINT_DOCUMENT",
                                "TitleKey", "MSG_TITLE_REPRINT_DOCUMENT"
                                ));

                        msg = WaitForMessage();

                        if (msg.Name.EndsWith(".No"))
                        {
                            proceed = true;
                        }

                    }
                    else
                    {
                        proceed = true;
                    }

                }


            }




            //inform user
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "MessageKey", "MSG_ITEMS_MOVED",
                    "NoTranslationOfMessageKey", false,
                    "ShowButton", true));
            WaitForMessage();

            if (!string.IsNullOrEmpty(currentNeededDestinationLocationCode))
            {
                return;
            }
            else
            {
                goto Step_SelectWhsMove;
            }


            #endregion


            return;

        }

        #endregion

        #region HELPERS


        private T ExecuteMethodWithDbConnection<T>(out ProdumexError pmxError, bool useSboConnection, bool useUserNameOfConnectionString, DelegateWithPmxDbConnection<T> methodDelegate, params object[] parameters)
        {
            T result = default(T);
            pmxError = null;

            try
            {
                result = m_sboProviderService.InvokeMethodWithDbConnection<T>(useSboConnection, useUserNameOfConnectionString, null, null,
                    methodDelegate, parameters);
            }
            catch (TargetInvocationException ex)
            {
                MethodInfo methodInfo = methodDelegate.Method;
                if (ex.InnerException is ProdumexException)
                {
                    s_log.Warn("Execute -- The invoked method threw a produmex exception: ", ex.InnerException);
                    pmxError = ((ProdumexException)ex.InnerException).Error;
                }
                else if (ex.InnerException == null)
                {
                    s_log.Warn("Execute -- The invoked method threw an exception: ", ex);
                    pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.Message);
                }
                else
                {
                    s_log.Warn("Execute -- The invoked method threw a TargetInvocationException with inner exception: ", ex.InnerException);
                    pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.InnerException.Message);
                }
            }
            catch (TransactionAbortedException ex)
            {
                MethodInfo methodInfo = methodDelegate.Method;
                pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.InnerException == null ? ex.Message : ex.InnerException.Message);
            }
            catch (ProdumexException ex)
            {
                if (ex.Error != null)
                {
                    pmxError = ex.Error;
                }
                else
                {
                    MethodInfo methodInfo = methodDelegate.Method;
                    pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.Message);
                }
            }
            catch (Exception ex)
            {
                MethodInfo methodInfo = methodDelegate.Method;
                pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.Message);
            }

            return result;
        }

        ///// <summary>
        ///// Executes the print reports for event collection.
        ///// </summary>
        ///// <param name="conn">The conn.</param>
        ///// <param name="parameters">The parameters.</param>
        ///// <returns></returns>
        //private static int ExecutePrintReportsForEventWithParametersCollection(PmxDbConnection conn, object[] parameters)
        //{
        //    PmxPrintReportProvider prov = new PmxPrintReportProvider(conn);

        //    return prov.PrintReportsForEventWithParametersCollection((PmxPrintReportEventType)parameters[0], (string)parameters[1], (string)parameters[2], (Collection<Dictionary<string, object>>)parameters[3], (bool)parameters[4]);
        //}

        ///// <summary>
        ///// Executes the print reports for event.
        ///// </summary>
        ///// <param name="conn">The conn.</param>
        ///// <param name="parameters">The parameters.</param>
        ///// <returns></returns>
        //private static int ExecutePrintReportsForEvent(PmxDbConnection conn, object[] parameters)
        //{
        //    PmxPrintReportProvider prov = new PmxPrintReportProvider(conn);

        //    return prov.PrintReportsForEvent((PmxPrintReportEventType)parameters[0], (string)parameters[1], (string)parameters[2], (int)parameters[3], (bool)parameters[4]);
        //}




        /// <summary>
        /// Executes the get PMX warehouse code.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static PmxOseWarehouseInfo ExecuteGetPmxWarehouseCode(PmxDbConnection conn, object[] parameters)
        {
            PmxOseProvider oseProv = new PmxOseProvider(conn);
            return oseProv.GetPmxWarehouseInfo((string)parameters[0]);
        }

        private static bool ExecuteIsLocationLocked(PmxDbConnection conn, object[] parameters)
        {
            PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
            return prov.IsLocationLocked((string)parameters[0]);
        }

        private static Collection<DocumentRef> ExecuteMakeAdHocMove(PmxDbConnection conn, object[] parameters)
        {
            PmxMoveProvider prov = new PmxMoveProvider(conn);
            return prov.MakeAdHocMove((Collection<MoveItemInfo>)parameters[0], (int?) parameters[1], (string)parameters[2]);
        }

        private static string ExecuteGetItemWarehouseDefaultLocationOrZone(PmxDbConnection conn, object[] parameters) {
            PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
            return prov.GetWarehouseDefaultLocationOrZone((string)parameters[0], (string)parameters[1]);
        }

        /// <summary>
        /// Executes the name of the get extra db.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static string ExecuteGetExtraDbName(PmxDbConnection conn, object[] parameters)
        {
            PmxExtraDbProvider prov = new PmxExtraDbProvider(conn);
            return prov.GetFirstBO().ExtraDb;
        }



        /// <summary>
        /// Executes the get culture info from language code.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static CultureInfo ExecuteGetCultureInfoFromLanguageCode(PmxDbConnection conn, object[] parameters)
        {
            PmxUserLanguageProvider prov = new PmxUserLanguageProvider((SboConnection)conn);
            return prov.GetCultureInfo((int)parameters[0]);
        }




        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null &&
                ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }

            return 0;
        }



        /// <summary>
        /// Executes the get item info.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static PmxItemInfo ExecuteGetItemInfo(PmxDbConnection conn, object[] parameters)
        {
            PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
            return prov.GetItemInfo((string)parameters[0]);
        }


        ///// <summary>
        ///// Executes the get item infos.
        ///// </summary>
        ///// <param name="conn">The conn.</param>
        ///// <param name="parameters">The parameters.</param>
        ///// <returns></returns>
        //private static Dictionary<string, PmxItemInfo> ExecuteGetItemInfos(PmxDbConnection conn, object[] parameters)
        //{
        //    PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
        //    return prov.GetItemInfosInDictionary((IList<string>)parameters[0]);
        //}



        #endregion

    }

    #region BUILD QUERY

    /// <summary>
    /// Static class grouping our native queries
    /// </summary>
    internal static class BuildQuery
    {


        /// <summary>
        /// Gets the name and the code of the  location, ordered by name.
        /// </summary>
        /// <param name="locationCode">The location code.</param>
        /// <param name="pmxWarehouseCode">The PMX warehouse code.</param>
        /// <param name="deviceID">The device ID.</param>
        /// <param name="onlySiloTank">if set to <c>true</c> [only silo tank].</param>
        /// <returns>The sql statement to get the location</returns>
        public static string GetStorageLocation(string locationCode, string pmxWarehouseCode, string deviceID, bool onlySiloTank)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.CODE.Name);

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.DESCRIPTION.Name);

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.WAREHOUSECODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));

            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);


            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);


            if (onlySiloTank)
            {
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseSiloTankTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseSiloTankTable.NAME, PmxOseSiloTankTable.Columns.Code.NAME);

            }


            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


            if (!string.IsNullOrEmpty(locationCode))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
            }



            if (!String.IsNullOrEmpty(pmxWarehouseCode) || !String.IsNullOrEmpty(deviceID))
            {
                strBuilder.Append(" AND ( ");
                if (!String.IsNullOrEmpty(pmxWarehouseCode))
                {
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pmxWarehouseCode, CultureInfo.InvariantCulture));
                }
                if (!String.IsNullOrEmpty(deviceID))
                {
                    if (!String.IsNullOrEmpty(pmxWarehouseCode)) strBuilder.Append(" OR ");

                    strBuilder.AppendFormat("{0} IN ( SELECT {1} FROM {2} WHERE {3} = {4} )",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.PmxWarehouseCode.NAME),
                        SqlCommandHelper.EscapeTableName(PmxThinClientWarehouseTable.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.ParentCode.NAME),
                        SqlCommandHelper.FormatAndEscapeColumnValue(deviceID, CultureInfo.InvariantCulture));
                }
                strBuilder.Append(" )");
            }


            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));


            return strBuilder.ToString();
        }


        /// <summary>
        /// Gets active locations.
        /// </summary>
        /// <param name="locationCode">The location code.</param>
        /// <param name="onlySiloTank">if set to <c>true</c> [only silo tank].</param>
        /// <returns>
        /// The sql statement to get all the active location
        /// </returns>
        public static string GetLocations(string locationCode, bool onlySiloTank)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME, LocationDataSet.Columns.DESCRIPTION.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, LocationDataSet.Columns.WAREHOUSECODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);

            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

            if (onlySiloTank)
            {
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseSiloTankTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseSiloTankTable.NAME, PmxOseSiloTankTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);
            }


            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);


            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxUserTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.InternalKey.NAME);

            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


            if (!string.IsNullOrEmpty(locationCode))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));

            }


            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

            return strBuilder.ToString();
        }



        /// <summary>
        /// Command for getting all products order by name
        /// </summary>
        /// <param name="sscc">The SSCC.</param>
        /// <param name="locationCode">The location code.</param>
        /// <returns>
        /// Command for getting all products order by name
        /// </returns>
        public static string GetProductOnSSCC(string sscc, string locationCode)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemName.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemWarehouseDefaultLocationTable.NAME, PmxItemWarehouseDefaultLocationTable.Columns.DefaultLocationZone.NAME, PmxItemWarehouseDefaultLocationTable.Columns.DefaultLocationZone.NAME));


            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.IsLogisticCarrier.NAME, PmxItemTable.Columns.IsLogisticCarrier.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME);

            strBuilder.Append(", SUM( ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME);
            strBuilder.Append(" ) AS ");
            strBuilder.Append(PmxInventoryTotalTable.Columns.Quantity.NAME);

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));

            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);


            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(" ON ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.Columns.ItemCode.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.Columns.ItemCode.NAME));

            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME);

            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);

            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemWarehouseDefaultLocationTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemWarehouseDefaultLocationTable.NAME, PmxItemWarehouseDefaultLocationTable.Columns.ItemCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME);
            strBuilder.Append(" AND ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemWarehouseDefaultLocationTable.NAME, PmxItemWarehouseDefaultLocationTable.Columns.PmxWhsCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);

            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));

            if (!string.IsNullOrEmpty(locationCode))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
            }


            strBuilder.Append(" GROUP BY ");

            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemName.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemWarehouseDefaultLocationTable.NAME, PmxItemWarehouseDefaultLocationTable.Columns.DefaultLocationZone.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.IsLogisticCarrier.NAME);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);


            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemName.NAME));
            return strBuilder.ToString();
        }




        /// <summary>
        /// Gets the item codes on location.
        /// </summary>
        /// <param name="locationCode">The location code.</param>
        /// <returns></returns>
        public static string GetItemCodesOnLocation(string locationCode)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT DISTINCT ");

            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));

        
            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);


            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(" ON ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.Columns.ItemCode.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.Columns.ItemCode.NAME));


            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));

            strBuilder.Append(" AND ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));
            


            return strBuilder.ToString();
        }


        /// <summary>
        /// Gets the zone types for items.
        /// </summary>
        /// <param name="itemCodes">The item codes.</param>
        /// <returns></returns>
        public static string GetZoneTypesForItems(Collection<string> itemCodes)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT DISTINCT");

            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemZoneTypeTable.NAME, PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME, PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME);

            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemZoneTypeTable.NAME));


            string operand = "";
            strBuilder.Append(" WHERE ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemZoneTypeTable.NAME, PmxItemZoneTypeTable.Columns.ItemCode.NAME);
            strBuilder.Append(" IN ( ");

            foreach (string itemCode in itemCodes)
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
                operand = ", ";
            }
            strBuilder.Append(") ");


            return strBuilder.ToString();
        }

        /// <summary>
        /// Gets the name and the code of the  location, ordered by name.
        /// </summary>
        /// <param name="locationCode">The location code.</param>
        /// <param name="warehouseCode">The warehouse code.</param>
        /// <param name="zoneTypeCodes">The zone type codes.</param>
        /// <param name="emptyLocations">if set to <c>true</c> [empty locations].</param>
        /// <returns>The sql statement to get the location</returns>
        public static string GetStorageLocationForZoneTypes(string locationCode, string warehouseCode, Collection<string> zoneTypeCodes, bool emptyLocations)
        {
            return GetStorageLocationForZoneTypes(locationCode, warehouseCode, zoneTypeCodes, emptyLocations, false);
        }

        /// <summary>
        /// Gets the name and the code of the  location, ordered by name.
        /// </summary>
        /// <param name="locationCode">The location code.</param>
        /// <param name="warehouseCode">The warehouse code.</param>
        /// <param name="zoneTypeCodes">The zone type codes.</param>
        /// <param name="emptyLocations">if set to <c>true</c> [empty locations].</param>
        /// <param name="onlySiloTank">if set to <c>true</c> [only silo tank].</param>
        /// <returns>The sql statement to get the location</returns>
        public static string GetStorageLocationForZoneTypes(string locationCode, string warehouseCode, Collection<string> zoneTypeCodes, bool emptyLocations, bool onlySiloTank)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.CODE.Name);

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.DESCRIPTION.Name);

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.WAREHOUSECODE.Name);


            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

            if (onlySiloTank)
            {
                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseSiloTankTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseSiloTankTable.NAME, PmxOseSiloTankTable.Columns.Code.NAME);

            }

            if (emptyLocations)
            {
                strBuilder.Append(" LEFT JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

            }

            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


            if (!string.IsNullOrEmpty(locationCode))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
            }

            if (warehouseCode != null &&
                warehouseCode.Trim() != "")
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

            }

            if (zoneTypeCodes != null &&
                zoneTypeCodes.Count > 0)
            {
                foreach (string zoneTypeCode in zoneTypeCodes)
                {
                    strBuilder.Append(" AND ");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                    strBuilder.Append(".");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                    strBuilder.Append(" IN ( ");

                    strBuilder.Append("SELECT ");

                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                    strBuilder.Append(".");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));


                    strBuilder.Append(" FROM ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
                    strBuilder.Append(" INNER JOIN ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
                    strBuilder.Append(" ON ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
                    strBuilder.Append(" = ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);
                    strBuilder.Append(" RIGHT OUTER JOIN ");
                    strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkZoneZoneTypeTable.NAME));
                    strBuilder.Append(" ON ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME);
                    strBuilder.Append(" = ");
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkZoneZoneTypeTable.NAME, PmxLinkZoneZoneTypeTable.Columns.ParentCode.NAME);


                    strBuilder.Append(" WHERE ");


                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxLinkZoneZoneTypeTable.NAME));
                    strBuilder.Append(".");
                    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxLinkZoneZoneTypeTable.Columns.ZoneTypeCode.NAME));
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(zoneTypeCode, CultureInfo.InvariantCulture));


                    strBuilder.Append(") ");

                }
            }

            if (emptyLocations)
            {
                //If there is no link to the inventory, the location is empty
                strBuilder.Append(" AND ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
                strBuilder.Append(" IS NULL ");

            }

            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));


            return strBuilder.ToString();
        }


        /// <summary>
        /// Gets the warehouses.
        /// </summary>
        /// <param name="warehouseCode">The warehouse code.</param>
        /// <param name="deviceID">The device ID.</param>
        /// <returns></returns>
        public static string GetWarehouses(string warehouseCode, string deviceID)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.Columns.Code.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.CODE.Name);

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.Columns.Name.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.DESCRIPTION.Name);

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.Columns.Code.NAME));
            strBuilder.Append(" AS ");
            strBuilder.Append(LocationDataSet.Columns.WAREHOUSECODE.Name);


            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
           
            //if (!string.IsNullOrEmpty(warehouseCode))
            //{
            //    strBuilder.Append(" AND ");
            //    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.NAME));
            //    strBuilder.Append(".");
            //    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.Columns.Code.NAME));
            //    strBuilder.Append(" = ");
            //    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

            //}

            string operand = " WHERE ";


            if (!String.IsNullOrEmpty(warehouseCode) || !String.IsNullOrEmpty(deviceID))
            {
                strBuilder.AppendFormat(" {0} ( ", operand);
                if (!String.IsNullOrEmpty(warehouseCode))
                {
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));
                }
                if (!String.IsNullOrEmpty(deviceID))
                {
                    if (!String.IsNullOrEmpty(warehouseCode)) strBuilder.Append(" OR ");

                    strBuilder.AppendFormat("{0} IN ( SELECT {1} FROM {2} WHERE {3} = {4} )",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.PmxWarehouseCode.NAME),
                        SqlCommandHelper.EscapeTableName(PmxThinClientWarehouseTable.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.ParentCode.NAME),
                        SqlCommandHelper.FormatAndEscapeColumnValue(deviceID, CultureInfo.InvariantCulture));
                }
                strBuilder.Append(" )");

                operand = " AND ";
            }

            

            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseWarehouseTable.Columns.Name.NAME));


            return strBuilder.ToString();
        }
    }

    #endregion

}
