﻿using System.Globalization;
using System.Reflection;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using System.Collections.ObjectModel;
using Produmex.Sbo.Logex.Data.DataObjects;
using System.Collections.Generic;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Foundation.Messages;
using Produmex.Foundation.Collections;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_BeforeSalesReturnAddedHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_BeforeSalesReturnAddedHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
		public ReadOnlyBinder<Collection<SalesReturnItemInfo>> SalesReturnItemInfoList;
		public ReadOnlyBinder<string> CustomerCardCode;

		// Output parameters * do not change *
		public ReadWriteBinder<bool> BackRequested;
		public ReadWriteBinder<PmxDictionary<string, object>> UDFValues;

		// Sub-flows
		// <none>

		/// <summary>
		/// Initializes a new instance of the <see cref="WorkflowScript_BeforeSalesReturnAddedHookScript"/> class.
		/// </summary>
		/// <param name="parent">The parent.</param>
		/// <param name="factory">The factory.</param>
		public WorkflowScript_BeforeSalesReturnAddedHookScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base(parent, factory)
        {
        }

		#region WorkflowInstanceScriptBase Members

		protected override void Execute()
		{
			// Parameters in scope
			Session session = GetScopeParameter("Session") as Session;
			ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterStringValueScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
				"TitleKey", "MSG_APPEL_TITLE",
				"AllowToGoBack", true
				));
			Message msg = WaitForMessage();

			if (msg.Name.EndsWith(".StringEntered"))
			{
				string udfValue = ExtractParameter<string>(msg.Parameters, "stringValue");
				if (!string.IsNullOrEmpty(udfValue))
				{
					PmxDictionary<string, object> dic = UDFValues.Get();
					if (dic == null)
					{
						dic = new PmxDictionary<string, object>();
					}
					dic.Add("U_N_APPEL", udfValue);
					UDFValues.Set(dic);
				}

			}
			else if (msg.Name.EndsWith(".BackRequested"))
			{
				BackRequested.Set(true);
			}
		}
        #endregion
    }
}
