﻿using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Sbo.Logex.KSTools.BusinessObjects.Definitions.Tables;
using System;
using Produmex.Sbo.Logex.KSTools.Providers;
using Produmex.Sbo.Logex.KSTools.BusinessObjects;
using Produmex.Foundation;
using Produmex.Sbo.Logex.Data.Extensions.Interfacing.Definitions;

// PmxWorkflowExecutionTypes.SUB_FLOW
namespace WorkflowScript_DoubleCheckSSCCScript
{
    /// <summary>
    /// Script to double check SSCC's
    /// </summary>
    public class WorkflowScript_DoubleCheckSSCCScript : WorkflowInstanceScriptBase
    {
        ISboProviderService m_sboProviderService;

        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;


        // Sub-flows
        // <none>

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_DoubleCheckSSCCScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_DoubleCheckSSCCScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            m_sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;


            Message msg = null;

            string query = null;
            DataSet dsSSCC = null;
            string initialErrorKey = null;

            string buttonKeyShipLoadedSSCC = null;

            int? salesDeliveryDocEntry = null;
            DataSet dsDelivery = null;
            string docNum = null;
            string srcSSCC = null;

            ProdumexError pmxError = null;

        Step_SelectDelivery:

            #region SELECT DELIVERY

            query = BuildQuery.GetNotShippedSalesDeliveryNotesOrderByDate();
            dsDelivery = m_sboProviderService.RunView(false, null, null, query);

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Retour.ISelectSalesDeliveryNoteScreen),
                   DefaultCultureInfo.Get(), BuildParamCollection(
                   "InitialErrorKey", initialErrorKey,
                   "TitleKey", "MSG_TITLE_SELECT_SALES_DELIVERY_NOTE",
                   "SalesDeliveryNoteDS", dsDelivery
                   ));
            msg = WaitForMessage();
            initialErrorKey = null;
            if (msg.Name.EndsWith(".SalesDeliveryNoteSelected"))
            {

                salesDeliveryDocEntry = ExtractParameter<int?>(msg.Parameters, "docEntry");

                DataRow[] rows = dsDelivery.Tables[0].Select(string.Format("{0}={1}", SalesDeliveryNoteDataSet.Columns.DOC_ENTRY.Name, salesDeliveryDocEntry.Value));

                if (rows.Length > 0)
                {
                    docNum = Convert.ToString(rows[0][SalesDeliveryNoteDataSet.Columns.DOC_NUM.Name]);
                }

                goto Step_GetShowAndScanSSCC;
            }


            //BACK or STOP
            return;

            #endregion


        Step_GetShowAndScanSSCC:

            #region GET, SHOW & SCAN SSCC


            query = BuildQuery.GetSSCCsLinkedToSalesDeliveryNote(int.Parse(docNum));
            dsSSCC = m_sboProviderService.RunView(false, null, null, query);

            if (GetNumberOfRows(dsSSCC) > 0)
            {

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Shipping.IIdentifySSCCScreen),
                    DefaultCultureInfo, BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_TITLE_IDENTIFY_SSCC",
                    "SSCCDS", dsSSCC,
                    "ButtonNoSSCC",true,
                    "ButtonKey", buttonKeyShipLoadedSSCC));

                initialErrorKey = null;
                msg = WaitForMessage();

                if (msg.Name.EndsWith(".SSCCEntered"))
                {
                    srcSSCC = ExtractParameter<string>(msg.Parameters, "sscc");



                    goto Step_UpdateIsShippedStatus;
                }

                if (msg.Name.EndsWith(".ShipLoadedSSCC"))
                {
                    goto Step_UpdateIsShippedStatus;
                }

                if (msg.Name.EndsWith(".BackRequested"))
                {
                    srcSSCC = null;
                    docNum = null;

                    goto Step_SelectDelivery;
                }
            }
            else
            {

                return;

            }

            #endregion



        Step_UpdateIsShippedStatus:

            #region UPDATE ISSHIPPED STATUS

            try
            {

                m_sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                    delegate(PmxDbConnection conn, object[] parameters)
                    {
                        PmxDoubleCheckSSCCProvider checkProv = new PmxDoubleCheckSSCCProvider(conn);

                        PmxDoubleCheckSSCC check = checkProv.GetBOForSSCCAndDocEntry(srcSSCC, salesDeliveryDocEntry.Value);
                        check.IsShipped = true;
                        checkProv.UpdateBO(check, false, false );

                        return null;
                    });



                //m_sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                //            delegate(PmxDbConnection conn, object[] parameters)
                //            {
                //                PmxDoubleCheckSSCCProvider checkProv = new PmxDoubleCheckSSCCProvider(conn);

                //                PmxDoubleCheckSSCC check = checkProv.GetBO(salesDeliveryDocEntry.Value);
                //                check.IsShipped = true;
                //                checkProv.UpdateBO(check, false, false );

                //                return null;
                //            });



                goto Step_GetShowAndScanSSCC;

            }
            catch (ProdumexException ex)
            {
                s_log.Error("", ex);
                pmxError = ((ProdumexException)ex).Error;

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    this.DefaultCultureInfo, BuildParamCollection(
                    "PmxError", pmxError,
                    "ShowButton", true));
                msg = WaitForMessage();

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "TitleKey", "MSG_TITLE_ERROR_TRY_AGAIN",
                "MessageKey", "MSG_QUESTION_ERROR_TRY_AGAIN"));
                msg = WaitForMessage();

                if (msg.Name.EndsWith(".Yes"))
                {
                    goto Step_UpdateIsShippedStatus;
                }
                goto Step_SelectDelivery;
            }

            #endregion

        }

        #endregion

        #region HELPERS

        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }
            return 0;
        }



        #endregion

        #region BUILD QUERY

        /// <summary>
        /// Static class grouping our native queries
        /// </summary>
        private class BuildQuery
        {


            /// <summary>
            /// Gets the not shipped sales delivery notes order by date.
            /// </summary>
            /// <returns></returns>
            public static string GetNotShippedSalesDeliveryNotesOrderByDate()
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT DISTINCT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxDoubleCheckSSCCTable.NAME, PmxDoubleCheckSSCCTable.Columns.BaseDocNum.NAME);
                strBuilder.Append(" AS ");
                strBuilder.Append(SalesDeliveryNoteDataSet.Columns.DOC_NUM.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.CardCode.NAME);
                strBuilder.Append(" AS ");
                strBuilder.Append(SalesDeliveryNoteDataSet.Columns.CUSTOMER_CODE.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.CardName.NAME);
                strBuilder.Append(" AS ");
                strBuilder.Append(SalesDeliveryNoteDataSet.Columns.CUSTOMER_NAME.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocDueDate.NAME);
                strBuilder.Append(" AS ");
                strBuilder.Append(SalesDeliveryNoteDataSet.Columns.DOC_DUE_DATE.Name);

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocEntry.NAME);
                strBuilder.Append(" AS ");
                strBuilder.Append(SalesDeliveryNoteDataSet.Columns.DOC_ENTRY.Name);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxDoubleCheckSSCCTable.NAME));

                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(SboSalesDeliveryNoteTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxDoubleCheckSSCCTable.NAME, PmxDoubleCheckSSCCTable.Columns.BaseEntry.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, SboSalesDeliveryNoteTable.NAME, SboSalesDeliveryNoteTable.Columns.DocEntry.NAME);

                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxDoubleCheckSSCCTable.Columns.IsShipped.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));


                strBuilder.Append(" ORDER BY ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboSalesDeliveryNoteTable.Columns.DocDueDate.NAME));
                strBuilder.Append(" DESC ");
                return strBuilder.ToString();
            }



            /// <summary>
            /// Gets the SSC cs linked to sales delivery note.
            /// </summary>
            /// <param name="docNum">The doc num.</param>
            /// <returns></returns>
            public static string GetSSCCsLinkedToSalesDeliveryNote(int docNum)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT ");

                SqlCommandHelper.AddTableColumnName(strBuilder, PmxDoubleCheckSSCCTable.NAME, PmxDoubleCheckSSCCTable.Columns.SSCC.NAME);
                strBuilder.Append(" , ");

                //SqlCommandHelper.AddNullColumnWithName(strBuilder, DefaultPmxDocumentLine.Columns.StorageLocationCode.NAME);
                //strBuilder.Append(" , ");

                strBuilder.Append(" '' as ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(DefaultPmxDocumentLine.Columns.StorageLocationCode.NAME));
                strBuilder.Append(" , ");

                SqlCommandHelper.AddNullColumnWithName(strBuilder, PmxShippingLUIDViewDefinition.Columns.LUID.NAME);
                strBuilder.Append(" , ");

                //strBuilder.Append(" '' as ");
                //strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxShippingLUIDViewDefinition.Columns.LUID.NAME));
                //strBuilder.Append(" , ");

                strBuilder.Append(" '' as ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxShippingLUIDViewDefinition.Columns.CardCode.NAME));
                strBuilder.Append(" , ");

                strBuilder.Append(" '' as ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxShippingLUIDViewDefinition.Columns.CardName.NAME));
                strBuilder.Append(" , ");

                strBuilder.Append(" '' as ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxShippingLUIDViewDefinition.Columns.Sequence.NAME));

                //SqlCommandHelper.AddNullColumnWithName(strBuilder, PmxShippingLUIDViewDefinition.Columns.LUID.NAME);
                //strBuilder.Append(" , ");

                //SqlCommandHelper.AddNullColumnWithName(strBuilder, PmxShippingLUIDViewDefinition.Columns.CardCode.NAME);
                //strBuilder.Append(" , ");

                //SqlCommandHelper.AddNullColumnWithName(strBuilder, PmxShippingLUIDViewDefinition.Columns.CardName.NAME);
                //strBuilder.Append(" , ");

                //SqlCommandHelper.AddNullColumnWithName(strBuilder, PmxShippingLUIDViewDefinition.Columns.Sequence.NAME);
  
                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxDoubleCheckSSCCTable.NAME));

                strBuilder.Append(" WHERE ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxDoubleCheckSSCCTable.Columns.BaseDocNum.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(docNum, CultureInfo.InvariantCulture));

                strBuilder.Append("AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxDoubleCheckSSCCTable.NAME, PmxDoubleCheckSSCCTable.Columns.IsShipped.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));

                return strBuilder.ToString();
            }

        }

        #endregion
    }
}
