using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Transactions;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.DataObjects;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.DataObjects;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Convertors;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Collections;
using Produmex.Sbo.Logex.WorkFlowSteps;

// PmxWorkflowExecutionTypes.SUB_FLOW
namespace Produmex.Sbo.Logex.WorkflowScripts
{
	/// <summary>
	/// Move order flow
	/// </summary>
	public class WorkflowScript_MoveOrderKSTScript : WorkflowInstanceScriptBase
	{
		/// <summary>
		/// Definitions
		/// </summary>
		private static class Definitions
		{
			/// <summary>
			/// The separator for separating strings values
			/// </summary>
			public const string SEPARATOR = ", ";

			/// <summary>
			/// Maximum time a message needs to be shown
			/// </summary>
			public const int MAX_TIME_FOR_MESSAGE = 5;
		}

		// Private fields
		ISboProviderService m_sboProviderService;


		// Input parameters
		public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
		public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;


		private CultureInfo current_DefaultCultureInfo {
			get { return DefaultCultureInfo.Get(); }
			//set { DefaultCultureInfo.Set(value); }
		}

		private PmxOseCompany currentPmxOseCompany {
			get { return PmxOseCompany.Get(); }
			//set { PmxOseCompany.Set(value); }
		}


		private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

		private static PmxMoveOrderStockLevelConvertor moStockLevelConvertor = new PmxMoveOrderStockLevelConvertor();


		/// <summary>
		/// 
		/// </summary>
		WorkflowInstanceBase m_enterQuantitySubFlow;

		// Sub control
		protected bool SubBackRequested;

		//// Sub values
		//protected PmxItemInfo SubItemInfo;
		//protected string SubItemCode;
		//protected int? SubItriKey;
		//protected string SubBatchNumber;
		//protected DateTime? SubBestBeforeDate;
		//protected string SubQualityStatusCode;
		//protected string SubSSCC;
		//protected double SubMaximumQuantity;
		protected double SubQuantity;
		protected Collection<string> m_subFlowListOfSerialNumbers;

		//protected string SubItemInventoryUom;
		//protected bool SubForceSpecificSSCC;

		#region Constructors

		public WorkflowScript_MoveOrderKSTScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
			: base(parent, factory)
		{
			m_enterQuantitySubFlow = this.Create("EnterQuantityScript");
		}

		#endregion

		#region WorkflowInstanceScriptBase Members

		protected override void Execute()
		{
			// Parameters in scope
			Session session = GetScopeParameter("Session") as Session;
			ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;
			m_sboProviderService = (ISboProviderService)GetScopeParameter("<WwfService>ISboService");

			StepHelper stepHelper = new StepHelper {
				DefaultCultureInfo = this.DefaultCultureInfo,
				ShowCustomizedScreen = session.ShowCustomizedScreen,
				WaitForMessage = this.WaitForMessage,
				SboProviderService = m_sboProviderService,
				DeviceId = session.DeviceInstanceId
			};

			string initialErrorKey = null;
			string deviceID = session.DeviceInstanceId;
			SboUserInfo userInfo = sboProviderService.GetCurrentUser();
			Message msg = null;
			string query = null;
			ToolBarButtons toolBarButtons = ToolBarButtons.Back;
			DataSet dsMoveOrders = null;
			DataSet dsMoveOrderLines = null;
			int? moveOrderDocEntry = null;
			int? moveOrderLineNum = null;
			string remarks = null;
			Collection<MoveItemInfo> moveItemInfoList = new Collection<MoveItemInfo>();
			Dictionary<string, PmxStorageLocationCanItemBeStoredInfo> canItemBeStoredInfoPerItemCode = null;
			PmxItemInfo itemInfo = null;
			string destinationLocationCode = null;
			string pickLocationCode = null;
			string pickWhsCode = null;
			int? luidToPick = null;
			string ssccToPick = null;
			int? itriToPick = null;
			PickingItemInfo pickItemInfo = null;
			DataRow[] rows = null;
			PmxMoveOrderStockLevel stockLevel = PmxMoveOrderStockLevel.Detail;
			DataSet dsSSCC = null;
			string enteredPickLocationCode = null;
			string buttonKeyIdentifyPickLocation = null;
			//string buttonKeyIdentifyProduct = null;  // Never used
			string buttonKeyIdentifySSCC = null;
			DataSet dsPickLocation = null;

			bool moveFullLogisticUnit = false;
			DataSet dsAllItemsOnSSCC = null;
			Dictionary<string, PmxItemInfo> listOfItemInfos = new Dictionary<string, PmxItemInfo>();
			DataSet dsMoveItemsFullLUID = null;
			string destinationPmxWhsCode = null;
			string enteredDestinationLocationCode = null;
			string buttonKeyIdentifyDestinationLocationScreen = null;
			DataSet dsDestinationLocations = null;
			DataSet dsZoneTypes = null;
			Collection<string> listOfZoneTypes = new Collection<string>();
			int? destinationLUID = null;
			bool newSSCC = false;
			bool emptyLocations = false;
			DataSet ds = null;
			string batchNumber = null;
			string batchNumber2 = null;
			DateTime? bestBeforeDate = null;
			double maximumQty = 0;

			string GTIN = null;
			BarcodeContainer barcodeContainer = null;
			bool isSelectProduct = false;
			DataSet dsItems = null;
			DataSet dsPackagingTypes = null;
			Collection<PackagingTypeInfo> listOfTransactionalPackagingTypes = new Collection<PackagingTypeInfo>();
			string packagingTypesStillToMove = null;
			string batchNumberTemp = null;
			DateTime? bbdTemp = null;
			string itemSSCC = null;
			string qualityStatusCode = null;
			double batchQuantity = 0;
			DataSet dsBatchNumbers = null;
			bool backToMoveLines = false;
			int? moveToDestinationLUID = null;
			string targetLogCarrierCode = null;

			string sourcePmxWhsCode = null;
			string serialDestinationPmxWhsCode = null;
			string[] buttonKeys = null;
			Collection<string> listOfSerialNumbers = null;
			bool askForSerialNumbers = false;
			bool forceSerial = false;
			bool useRange = false;
			string filterButtonKey = null;
			int numberOfReports = 0;
			bool isWhsTransfer = false;

			string srcPmxWhsCodeOnMO = null;
			string destPmxWhsCodeOnMO = null;
			bool luidIsSelected = false;
			bool askReprint = false;

			string pickLocationsForScreen = null;

			Step_SelectMoveOrder:

			#region SELECT MOVE ORDER

			remarks = null;
			isWhsTransfer = false;

			query = BuildQuery.GetMoveOrders(null);
			dsMoveOrders = m_sboProviderService.RunView(false, null, null, query);

			if (this.GetNumberOfRows(dsMoveOrders) == 0)
			{
				//show message
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
						this.DefaultCultureInfo, BuildParamCollection(
						"MessageKey", "MSG_ERROR_NO_MOVE_ORDER_FOUND",
						"ShowButton", true));
				WaitForMessage();

				return;
			}

			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.ISelectMOHeaderScreen),
				this.DefaultCultureInfo, BuildParamCollection(
				"InitialErrorKey", initialErrorKey,
				"TitleKey", "MSG_TITLE_SELECT_MOVE_ORDER",
				"MODS", dsMoveOrders));
			msg = WaitForMessage();
			initialErrorKey = null;

			if (msg.Name.EndsWith(".RefreshRequested"))
			{
				goto Step_SelectMoveOrder;
			}

			if (msg.Name.EndsWith(".MOSelected"))
			{
				moveOrderDocEntry = ExtractParameter<int?>(msg.Parameters, "moDocEntry");
				goto Step_ShowRemarks;
			}


			//Go back
			return;


			#endregion

			Step_ShowRemarks:

			#region SHOW REMARKS

			if (this.GetNumberOfRows(dsMoveOrders) > 0)
			{
				rows = dsMoveOrders.Tables[0].Select(string.Format("{0} = {1}", MoveOrderHeaderDataSet.Columns.MO_DOC_ENTRY.Name, moveOrderDocEntry.Value));

				if (rows.Length > 0)
				{
					remarks = Convert.ToString(rows[0][MoveOrderHeaderDataSet.Columns.REMARKS.Name]);
					isWhsTransfer = Convert.ToString(rows[0][MoveOrderHeaderDataSet.Columns.SOURCE_WAREHOUSE_CODE.Name]) != Convert.ToString(rows[0][MoveOrderHeaderDataSet.Columns.DESTINATION_WAREHOUSE_CODE.Name]);

					srcPmxWhsCodeOnMO = Convert.ToString(rows[0][MoveOrderHeaderDataSet.Columns.SOURCE_WAREHOUSE_CODE.Name]);
					destPmxWhsCodeOnMO = Convert.ToString(rows[0][MoveOrderHeaderDataSet.Columns.DESTINATION_WAREHOUSE_CODE.Name]);
				}
			}

			if (!string.IsNullOrEmpty(remarks))
			{
				//show message
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
						this.DefaultCultureInfo, BuildParamCollection(
						"MessageKey", remarks,
						"ShowButton", true,
						"NoTranslationOfMessageKey", true
						));

				WaitForMessage();

			}

			goto Step_InitializeMoveList;

			#endregion

			Step_InitializeMoveList:

			#region INITIALIZE MOVE LIST

			moveItemInfoList = new Collection<MoveItemInfo>();

			goto Step_SelectMoveOrderLine;

			#endregion

			Step_SelectMoveOrderLine:

			#region SELECT MOVE ORDER LINE

			sourcePmxWhsCode = null;
			serialDestinationPmxWhsCode = null;
			askForSerialNumbers = false;

			query = BuildQuery.GetMoveOrdersOrderLinesByPriorityDueDate(null, null, null, null, true, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, moveOrderDocEntry, m_sboProviderService.GetDbTool());
			dsMoveOrderLines = m_sboProviderService.RunView(false, null, null, query);

			//reduce quantity already moved.
			RemoveInMemoryMoves(moveItemInfoList, dsMoveOrderLines);

			if (moveItemInfoList.Count > 0)
			{
				toolBarButtons = ToolBarButtons.Back | ToolBarButtons.Forward | ToolBarButtons.Stop;
			}
			else
			{
				toolBarButtons = ToolBarButtons.Back | ToolBarButtons.Forward;
			}


			if (this.GetNumberOfRows(dsMoveOrderLines) == 0 &&
				moveItemInfoList.Count > 0)
			{
				//no more items to move for order, and we have items to move in the list, so we can enter the destination location
				goto Step_StartDestiationLocation;
			}

			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.ISelectMOScreen),
				this.DefaultCultureInfo, BuildParamCollection(
				"InitialErrorKey", initialErrorKey,
				"TitleKey", "MSG_TITLE_SELECT_MOVE_ORDER_LINE",
				"MODS", dsMoveOrderLines,
				"EnabledToolBarButtons", (int)toolBarButtons));
			msg = WaitForMessage();
			initialErrorKey = null;

			if (msg.Name.EndsWith(".BackRequested"))
			{
				if (moveItemInfoList.Count == 0)
				{
					goto Step_SelectMoveOrder;
				}
				else
				{
					//items in list, so ask user if he wants to move
					backToMoveLines = true;
					goto Step_CheckGoBack;
				}
			}

			if (msg.Name.EndsWith(".MOSelected"))
			{
				moveOrderDocEntry = ExtractParameter<int?>(msg.Parameters, "moDocEntry");
				moveOrderLineNum = ExtractParameter<int?>(msg.Parameters, "lineID");
				goto Step_SetMoveOrderLineData;
			}

			if (msg.Name.EndsWith(".StopRequested"))
			{
				if (moveItemInfoList.Count == 0)
				{
					goto Step_SelectMoveOrder;
				}

				goto Step_StartDestiationLocation;
			}

			goto Step_SelectMoveOrderLine;

			#endregion

			Step_SetMoveOrderLineData:

			#region SET MOVE ORDER LINE DATA

			moveToDestinationLUID = null;

			pickItemInfo = new PickingItemInfo();
			luidIsSelected = false;

			rows = dsMoveOrderLines.Tables[0].Select(string.Format(" {0} = {1} AND {2} = {3} ", MoveOrderDataSet.Columns.MO_DOC_ENTRY.Name, moveOrderDocEntry.Value,
																											MoveOrderDataSet.Columns.LINEID.Name, moveOrderLineNum.Value));
			if (rows.Length > 0)
			{
				pickItemInfo.ItemCode = Convert.ToString(rows[0][MoveOrderDataSet.Columns.ITEMCODE.Name]);
				pickItemInfo.BatchNumber = Convert.ToString(rows[0][MoveOrderDataSet.Columns.BATCHNUMBER.Name]);
				pickItemInfo.BatchNumber2 = Convert.ToString(rows[0][MoveOrderDataSet.Columns.BATCHNUMBER2.Name]);
				pickItemInfo.BestBeforeDate = Convertor.ConvertToDateTimeNullable(rows[0][MoveOrderDataSet.Columns.BESTBEFOREDATE.Name]);
				pickItemInfo.ItemTransactionalInfoKey = Convertor.ConvertToInt32Nullable(rows[0][MoveOrderDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name]);
				pickItemInfo.LogisticUnitIdentKey = Convertor.ConvertToInt32Nullable(rows[0][MoveOrderDataSet.Columns.LUID.Name]);
				pickItemInfo.QualityStatusCode = Convert.ToString(rows[0][MoveOrderDataSet.Columns.SOURCE_QUALITY_STATUS_CODE.Name]);
				pickItemInfo.LocationCode = Convert.ToString(rows[0][MoveOrderDataSet.Columns.SOURCE_STORAGE_LOCATION.Name]);
				pickItemInfo.SSCC = Convert.ToString(rows[0][MoveOrderDataSet.Columns.SSCC.Name]);
				pickItemInfo.QuantityPerUom = 1;

				pickItemInfo.DestinationStorLocCode = Convert.ToString(rows[0][MoveOrderDataSet.Columns.DESTINATION_STORAGE_LOCATION.Name]);

				pickItemInfo.Quantity = Convert.ToDouble(rows[0][MoveOrderDataSet.Columns.OPENQTY.Name]);


				stockLevel = (PmxMoveOrderStockLevel)moStockLevelConvertor.ConvertColumnToBOProperty(Convert.ToString(rows[0][MoveOrderDataSet.Columns.STOCKLEVEL.Name]));

				moveToDestinationLUID = Convertor.ConvertToInt32Nullable(rows[0][MoveOrderDataSet.Columns.DESTINATION_LUID.Name]);
				//get the iteminfo
				itemInfo = sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>(ExecuteGetItemInfo), pickItemInfo.ItemCode);

				sourcePmxWhsCode = Convert.ToString(rows[0][MoveOrderDataSet.Columns.SOURCE_WHS.Name]);
				serialDestinationPmxWhsCode = Convert.ToString(rows[0][MoveOrderDataSet.Columns.DESTINATION_WHS.Name]);

				//check if serial numbers need to be asked
				askForSerialNumbers = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null,
				delegate (PmxDbConnection conn, object[] parameters)
				{
					PmxSerialNumberProvider prov = new PmxSerialNumberProvider(conn);
					return prov.MoveNeedsSerialNumbers(sourcePmxWhsCode, serialDestinationPmxWhsCode);
				});
			}


			dsPackagingTypes = null;
			if (pickItemInfo.ItemTransactionalInfoKey.HasValue)
			{
				query = BuildQuery.GetTransactionalPackagingTypes(null, pickItemInfo.ItemTransactionalInfoKey.Value, pickItemInfo.ItemCode);
				dsPackagingTypes = sboProviderService.RunView(false, null, null, query);
			}

			listOfTransactionalPackagingTypes = new Collection<PackagingTypeInfo>();

			if (!pickItemInfo.MasterLUID.HasValue)
			{

				if (pickItemInfo.ItemTransactionalInfoKey.HasValue)
				{

					m_sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
						delegate (PmxDbConnection conn, object[] parameters)
						{
							PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);

							listOfTransactionalPackagingTypes = prov.GetTransactionalPackagingTypes(pickItemInfo.ItemTransactionalInfoKey.Value, null, pickItemInfo.ItemCode);

							return null;
						});

				}

				if ((listOfTransactionalPackagingTypes == null ||
					listOfTransactionalPackagingTypes.Count == 0) &&
					itemInfo.ListOfPackagingTypes.Count > 0)
				{

					//there is no batch, but the item has a list of packaging types.
					//we need to build the list backwards, because we need last packaging type first
					for (int iLoop = (itemInfo.ListOfPackagingTypes.Count - 1); iLoop >= 0; iLoop--)
					{
						PackagingTypeInfo info = new PackagingTypeInfo();

						info.Barcode = itemInfo.ListOfPackagingTypes[iLoop].Barcodes;
						info.PackagingTypeCode = itemInfo.ListOfPackagingTypes[iLoop].PackagingTypeCode;
						info.PackagingTypeName = itemInfo.ListOfPackagingTypes[iLoop].PackagingTypeName;
						info.QuantityPerPack = itemInfo.ListOfPackagingTypes[iLoop].Quantity;

						listOfTransactionalPackagingTypes.Add(info);
					}
				}

				//add one last packaging type for the uom
				PackagingTypeInfo uomInfo = new PackagingTypeInfo();

				if (!string.IsNullOrEmpty(itemInfo.CodeBars))
				{
					uomInfo.Barcode.Add(itemInfo.CodeBars);
				}
				uomInfo.PackagingTypeCode = itemInfo.InventoryUom;
				uomInfo.PackagingTypeName = itemInfo.InventoryUom;
				uomInfo.QuantityPerPack = 1;
				uomInfo.NumberOfDecimals = itemInfo.UomDecimals;

				listOfTransactionalPackagingTypes.Add(uomInfo);


				packagingTypesStillToMove = GetPackagingTypesStillToMove(pickItemInfo.Quantity, itemInfo.InventoryUom, listOfTransactionalPackagingTypes);
			}

			//check if the stock still exists
			query = BuildQuery.GetProductsFromStockOrderByFEFO(null, pickItemInfo.ItemCode, pickItemInfo.LocationCode, null, false, pickItemInfo.LogisticUnitIdentKey, null, pickItemInfo.ItemTransactionalInfoKey, pickItemInfo.QualityStatusCode, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, sourcePmxWhsCode, pickItemInfo.MasterLUID, m_sboProviderService.GetDbTool());
			DataSet dsTempItems = sboProviderService.RunView(false, null, null, query);

			if (this.GetNumberOfRows(dsTempItems) == 0)
			{
				//Item not on location
				initialErrorKey = "MSG_ERROR_MO_ITEM_NOT_ON_LOCATION";
				goto Step_SelectMoveOrderLine;
			}


			if (!string.IsNullOrEmpty(pickItemInfo.LocationCode))
			{
				pickLocationsForScreen = pickItemInfo.LocationCode;
			}
			else
			{
				StringBuilder sbLoc = new StringBuilder();
				Collection<string> listOfLocations = new Collection<string>();
				string comma = "";
				foreach (DataRow row in dsTempItems.Tables[0].Rows)
				{
					string location = row[PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME] as string;

					if (!listOfLocations.Contains(location))
					{
						sbLoc.Append(comma);
						sbLoc.Append(location);
						listOfLocations.Add(location);
						comma = ", ";
					}

				}

				pickLocationsForScreen = sbLoc.ToString();
			}



			goto Step_SSCC;

			#endregion

			Step_SSCC:

			#region SSCC

			buttonKeyIdentifySSCC = null;
			moveFullLogisticUnit = false;

			if (!string.IsNullOrEmpty(pickItemInfo.SSCC) ||
				stockLevel == PmxMoveOrderStockLevel.Item)
			{
				//get SSCC
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Picking.IIdentifyFullPalletPickingScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"InitialErrorKey", initialErrorKey,
					"TitleKey", "MSG_TITLE_IDENTIFY_SSCC_TO_MOVE",
					"LocationCode", pickLocationsForScreen,
					"SSCC", pickItemInfo.SSCC,
					"AllowedButtons", !string.IsNullOrEmpty(pickItemInfo.SSCC) ? null : new string[] { "MSG_BUTTON_NO_SSCC" }
					));
				msg = WaitForMessage();

				initialErrorKey = null;

				if (msg.Name.EndsWith(".SSCCEntered"))
				{
					string tempScannedSSCC = ExtractParameter<string>(msg.Parameters, "sscc");

					pickLocationCode = pickItemInfo.LocationCode;
					if (!string.IsNullOrEmpty(pickItemInfo.SSCC))
					{
						//we have an sscc, so we need to check if SSCC is the same
						if (tempScannedSSCC != pickItemInfo.SSCC)
						{
							initialErrorKey = "MSG_ERROR_INCORRECT_SSCC_TO_MOVE";
							goto Step_SSCC;
						}

						ssccToPick = tempScannedSSCC;
						luidToPick = pickItemInfo.LogisticUnitIdentKey;
					}
					else
					{
						//no sscc was provided, and stock level == item, so user can scan an SSCC
						//Now we need to check if the SSCC exists on the source location, and if it contains the needed properties
						query = BuildQuery.GetProductsFromStockOrderByName(null, pickItemInfo.ItemCode, pickItemInfo.LocationCode, tempScannedSSCC, true, null, false, pickItemInfo.ItemTransactionalInfoKey, null, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, null, m_sboProviderService.GetDbTool());
						dsSSCC = m_sboProviderService.RunView(false, null, null, query);

						if (this.GetNumberOfRows(dsSSCC) == 0)
						{
							initialErrorKey = "MSG_ERROR_INVALID_SSCC";
							goto Step_SSCC;
						}
						else
						{
							//is SSCC on correct location?
							if (!string.IsNullOrEmpty(pickItemInfo.LocationCode) &&
								pickItemInfo.LocationCode != Convert.ToString(dsSSCC.Tables[0].Rows[0][PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME]))
							{
								initialErrorKey = "MSG_ERROR_SSCC_NOT_ON_CORRECT_LOCATION";
								goto Step_SSCC;
							}

							//get luid
							ssccToPick = tempScannedSSCC;
							luidToPick = Convertor.ConvertToInt32(dsSSCC.Tables[0].Select(string.Format("{0} = '{1}'", PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME, tempScannedSSCC))[0][PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME]);
						}

					}

					//check if we can move full luid
					//moveFullLogisticUnit = sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, new DelegateWithPmxDbConnection<bool>(ExecuteIsFullMonoPallet), luidToPick, pickItemInfo.ItemCode, pickItemInfo.Quantity);

					//When all items on luid need to be moved, we can move full luid
					//get all items on SSCC
					query = BuildQuery.GetProductsFromStockOrderByName(null, null, null, ssccToPick, false, null, null, null, null, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, null, m_sboProviderService.GetDbTool());
					dsAllItemsOnSSCC = sboProviderService.RunView(false, null, null, query);

					if (!moveFullLogisticUnit)
					{
						//get all move order lines
						query = BuildQuery.GetMoveOrdersOrderLinesByPriorityDueDate(null, null, null, null, true, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, moveOrderDocEntry, m_sboProviderService.GetDbTool());
						dsMoveItemsFullLUID = sboProviderService.RunView(false, null, null, query);

						//remove moved items
						RemoveInMemoryMoves(moveItemInfoList, dsMoveItemsFullLUID);

						if (this.GetNumberOfRows(dsAllItemsOnSSCC) > 0)
						{
							bool canMoveMixedPallet = true;
							foreach (DataRow rowStock in dsAllItemsOnSSCC.Tables[0].Rows)
							{
								string itemCodeForItem = Convert.ToString(rowStock[PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME]);
								string itemCodeForLogisticCarrier = Convert.ToString(rowStock[PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME]);
								double quantityOnPalletForItem = Convert.ToDouble(rowStock[PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME]);

								int? itriForItem = Convertor.ConvertToInt32Nullable(rowStock[PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME]);


								PmxItemInfo itemInfoForItem = null;

								if (!listOfItemInfos.ContainsKey(itemCodeForItem))
								{
									listOfItemInfos.Add(itemCodeForItem, sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>(ExecuteGetItemInfo), itemCodeForItem));
								}

								itemInfoForItem = listOfItemInfos[itemCodeForItem];

								//logistic carrier are not checked
								if (!(itemInfoForItem.ItemCode == itemCodeForLogisticCarrier && quantityOnPalletForItem == 1))
								{
									double stillToMoveForStock = quantityOnPalletForItem;


									DataRow[] rowsMove = dsMoveItemsFullLUID.Tables[0].Select(string.Format(" {0} = '{1}'", MoveOrderDataSet.Columns.ITEMCODE.Name, itemCodeForItem));

									if (rows.Length == 0)
									{
										canMoveMixedPallet = false;
										break;
									}

									//double stockToMove = quantityOnPalletForItem;

									//remove the stock already used
									double stockToMove = GetUnusedQuantity(moveItemInfoList, rowStock);

									if (stockToMove <= 0)
									{
										//Stock already used!
										initialErrorKey = "MSG_ERROR_CANNOT_PICK_THIS_ITEM";
										goto Step_SSCC;
									}

									foreach (DataRow rowMove in rowsMove)
									{
										//we need to remove quantity in memory already moved
										double stillToMoveForMoveLine = GetMoveQuantity(moveItemInfoList, rowMove, rowStock);

										stockToMove -= stillToMoveForMoveLine;

										if (stockToMove <= 0)
										{
											break;
										}

									}//foreach

									if (stockToMove > 0)
									{
										canMoveMixedPallet = false;
										break;
									}
								}

							}

							moveFullLogisticUnit = canMoveMixedPallet;
						}
					}

					if (!moveFullLogisticUnit)
					{
						goto Step_IdentifyProduct;
					}
					else
					{
						goto Step_MoveFullPallet;
					}

				}
				if (msg.Name.EndsWith(".ButtonClicked"))
				{
					buttonKeyIdentifySSCC = ExtractParameter<string>(msg.Parameters, "buttonKey");
					if (buttonKeyIdentifySSCC == "MSG_BUTTON_NO_SSCC")
					{
						//No SSCC clicked
						ssccToPick = null;
						luidToPick = null;
						goto Step_IdentifyPickLocation;
					}

					initialErrorKey = "MSG_ERROR_OPERATION_NOT_SUPPORTED";
					goto Step_SSCC;

				}
				if (msg.Name.EndsWith(".BackRequested"))
				{
					goto Step_SelectMoveOrderLine;
				}
			}
			else
			{
				//no SSCC
				goto Step_IdentifyPickLocation;
			}


			#endregion

			Step_IdentifyPickLocation:

			#region IDENTIFY PICK LOCATION

			//session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Picking.IIdentifyLocationScreen),
			//DefaultCultureInfo.Get(), BuildParamCollection(
			//    "InitialErrorKey", initialErrorKey,
			//    "TitleKey", "MSG_TITLE_IDENTIFY_PICK_LOCATION",
			//    "ButtonKeys", new string[] { "MSG_BUTTON_SELECT_LOCATION"},
			//    "UOM", itemInfo.InventoryUom,
			//    "ItemDescription", itemInfo.Description,
			//    "ItemCode", itemInfo.ItemCode,
			//    "ItemBarcode", itemInfo.CodeBars,
			//    "BatchNumber", pickItemInfo.BatchNumber,
			//    "BestBeforeDate", pickItemInfo.BestBeforeDate,
			//    "SSCC", pickItemInfo.SSCC,
			//    "StillToPick", pickItemInfo.Quantity,
			//    "TotalQuantityToPick", pickItemInfo.TotalQuantityToPick,
			//    "LocationCode", pickItemInfo.LocationCode
			//    ));
			//msg = WaitForMessage();


			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Picking.IIdentifyLocationAdHocPickingScreen),
			DefaultCultureInfo.Get(), BuildParamCollection(
				"InitialErrorKey", initialErrorKey,
				"TitleKey", "MSG_TITLE_IDENTIFY_PICK_LOCATION",
				"AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION" },
				"UOM", itemInfo.InventoryUom,
				"ItemCode", pickItemInfo.ItemCode,
				"ItemDescription", itemInfo.CustomItemDescription,
				"ItemPackagingTypes", packagingTypesStillToMove,
				"BatchNumber", pickItemInfo.BatchNumber,
				"BestBeforeDate", pickItemInfo.BestBeforeDate,
				"LocationCodes", pickLocationsForScreen,
				"ImagePath", itemInfo.PictureName));
			msg = WaitForMessage();

			initialErrorKey = null;
			pickLocationCode = null;
			pickWhsCode = null;
			enteredPickLocationCode = null;
			buttonKeyIdentifyPickLocation = null;
			//buttonKeyIdentifyProduct = null;

			if (msg.Name.EndsWith(".ButtonClicked"))
			{
				buttonKeyIdentifyPickLocation = ExtractParameter<string>(msg.Parameters, "buttonKey");
				if (buttonKeyIdentifyPickLocation == "MSG_BUTTON_SELECT_LOCATION")
				{
					goto Step_SelectPickLocation;
				}
				else
				{
					initialErrorKey = "MSG_ERROR_OPERATION_NOT_SUPPORTED";
					goto Step_IdentifyPickLocation;
				}
			}

			if (msg.Name.EndsWith(".LocationEntered"))
			{
				enteredPickLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");

				goto Step_SelectPickLocation;
			}

			if (!string.IsNullOrEmpty(pickItemInfo.SSCC) ||
				stockLevel == PmxMoveOrderStockLevel.Item)
			{
				goto Step_SSCC;
			}
			else
			{
				goto Step_SelectMoveOrderLine;
			}

			#endregion

			Step_SelectPickLocation:

			#region SELECT PICK LOCATION

			if (string.IsNullOrEmpty(pickItemInfo.LocationCode))
			{
				//no location was entered in MO, so get all locations linked to needed stock
				query = BuildQuery.GetStorageLocationFromStock(enteredPickLocationCode, srcPmxWhsCodeOnMO, true, itemInfo.ItemCode, luidToPick);
			}
			else
			{
				query = BuildQuery.GetStorageLocation(enteredPickLocationCode, srcPmxWhsCodeOnMO, true);
			}
			dsPickLocation = sboProviderService.RunView(false, null, null, query);

			if (GetNumberOfRows(dsPickLocation) > 0)
			{
				//we got a location
				if (GetNumberOfRows(dsPickLocation) == 1 &&
					!string.IsNullOrEmpty(pickItemInfo.LocationCode))
				{
					if (!string.IsNullOrEmpty(Convert.ToString(dsPickLocation.Tables[0].Rows[0][PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME])))
					{
						//the location is locked
						initialErrorKey = "MSG_ERROR_LOCATION_LOCKED";
						goto Step_IdentifyPickLocation;
					}
					//only one location, so we can take this one
					enteredPickLocationCode = dsPickLocation.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name] as string;
					pickWhsCode = dsPickLocation.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name] as string;


				}
				else
				{
					//rerun query, but leave out the locked location
					if (string.IsNullOrEmpty(pickItemInfo.LocationCode))
					{
						//no location was entered in MO, so get all locations linked to needed stock
						query = BuildQuery.GetStorageLocationFromStock(enteredPickLocationCode, srcPmxWhsCodeOnMO, false, itemInfo.ItemCode, luidToPick);
					}
					else
					{
						query = BuildQuery.GetStorageLocation(enteredPickLocationCode, srcPmxWhsCodeOnMO, false);
					}
					dsPickLocation = sboProviderService.RunView(false, null, null, query);

					//we got a location
					if (GetNumberOfRows(dsPickLocation) == 1 &&
						!string.IsNullOrEmpty(enteredPickLocationCode))
					{

						//only one location, so we can take this one
						enteredPickLocationCode = dsPickLocation.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name] as string;
						pickWhsCode = dsPickLocation.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name] as string;


					}
					else
					{
						//more than one location, so the user can select the location
						session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
						DefaultCultureInfo.Get(), BuildParamCollection(
							"InitialErrorKey", initialErrorKey,
							"TitleKey", "MSG_TITLE_SELECT_PICK_LOCATION",
							"LocationDS", dsPickLocation));
						msg = WaitForMessage();

						if (msg.Name.EndsWith(".LocationSelected"))
						{
							enteredPickLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");
							pickWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");
						}

						if (msg.Name.EndsWith(".BackRequested"))
						{
							goto Step_IdentifyPickLocation;
						}
					}
				}
			}
			else
			{
				//show message screen
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					DefaultCultureInfo.Get(),
					BuildParamCollection(
						"MessageKey", "MSG_ERROR_NO_LOCATION_FOUND",
						"ShowButton", true));
				msg = WaitForMessage();

				goto Step_IdentifyPickLocation;
			}


			if (string.IsNullOrEmpty(pickItemInfo.LocationCode) ||
				enteredPickLocationCode == pickItemInfo.LocationCode)
			{
				pickLocationCode = enteredPickLocationCode;
				goto Step_IdentifyProduct;
			}
			else
			{
				initialErrorKey = "MSG_ERROR_INCORRECT_PICK_LOCATION";
				goto Step_IdentifyPickLocation;
			}

			#endregion

			Step_IdentifyProduct:

			#region IDENTIFY PRODUCT

			barcodeContainer = null;
			GTIN = null;
			isSelectProduct = false;

			if (luidIsSelected)
			{
				luidToPick = null;
			}

			//check if we find items on the location
			query = BuildQuery.GetProductsFromStockOrderByName(null, pickItemInfo.ItemCode, pickLocationCode, null, false, luidToPick, null, pickItemInfo.ItemTransactionalInfoKey, pickItemInfo.QualityStatusCode, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, null, m_sboProviderService.GetDbTool());
			dsItems = sboProviderService.RunView(false, null, null, query);

			if (this.GetNumberOfRows(dsItems) == 0)
			{
				//Item not on location
				initialErrorKey = "MSG_ERROR_MO_ITEM_NOT_ON_LOCATION";
				goto Step_SelectMoveOrderLine;
			}

			//now get all items on location/luid
			query = BuildQuery.GetProductList(GTIN, null, pickLocationCode, null, false, luidToPick, null, null, null, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, false, m_sboProviderService.GetDbTool());
			dsItems = sboProviderService.RunView(false, null, null, query);


			if (this.GetNumberOfRows(dsItems) == 1 &&
				string.IsNullOrEmpty(initialErrorKey))
			{
				//Only one item found, check for correctness
				if (pickItemInfo.ItemCode != dsItems.Tables[0].Rows[0][ProductDataSet.Columns.PRODUCT_CODE.Name] as string)
				{
					initialErrorKey = "MSG_ERROR_CANNOT_PICK_THIS_ITEM";
					//go back
					if (luidToPick.HasValue)
					{
						goto Step_SSCC;
					}
					else
					{
						goto Step_IdentifyPickLocation;
					}
				}
				goto Step_SelectProduct;
			}


			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Picking.IIdentifyGS1DataAdHocPickingScreen),
			DefaultCultureInfo.Get(), BuildParamCollection(
				"InitialErrorKey", initialErrorKey,
				"TitleKey", "MSG_TITLE_IDENTIFY_PRODUCT",
				"AllowedButtons", PmxOseCompany.Get().DisableItemSelectionInFlows ? null : new string[1] { "MSG_BUTTON_SELECT_PRODUCT" },
				"ImageType", GS1ImageType.BoxImage,
				"ItemCode", pickItemInfo.ItemCode,
				"ItemDescription", itemInfo.CustomItemDescription,
				"ItemPackagingTypes", packagingTypesStillToMove,
				"BatchNumber", pickItemInfo.BatchNumber,
				"BestBeforeDate", pickItemInfo.BestBeforeDate,
				"LocationCodes", pickLocationCode,
				"ImagePath", itemInfo.PictureName
				));
			msg = WaitForMessage();

			//clear data
			initialErrorKey = null;

			if (msg.Name.EndsWith(".DataEntered"))
			{
				barcodeContainer = ExtractParameter<BarcodeContainer>(msg.Parameters, "data");

				//check if there is a product present
				if (barcodeContainer != null &&
				!string.IsNullOrEmpty(BarcodeHelper.GetProductIdentification(barcodeContainer)))
				{
					GTIN = BarcodeHelper.GetProductIdentification(barcodeContainer);
					goto Step_SelectProduct;
				}
				else
				{
					initialErrorKey = "MSG_ERROR_NO_PRODUCT_ON_BARCODE";
					goto Step_IdentifyProduct;
				}

			}

			if (msg.Name.EndsWith(".ButtonClicked"))
			{
				//select the product
				isSelectProduct = true;
				goto Step_SelectProduct;
			}

			//go back
			if (luidToPick.HasValue)
			{
				goto Step_SSCC;
			}
			else
			{
				goto Step_IdentifyPickLocation;
			}


			#endregion

			Step_SelectProduct:

			#region SELECT PRODUCT

			//query = BuildQuery.GetProductList(GTIN, null, pickLocationCode, null, false, luidToPick, null, pickItemInfo.ItemTransactionalInfoKey, pickItemInfo.QualityStatusCode, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory);
			query = BuildQuery.GetProductList(GTIN, null, pickLocationCode, null, false, luidToPick, null, null, null, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, true, m_sboProviderService.GetDbTool());
			dsItems = sboProviderService.RunView(false, null, null, query);

			if (this.GetNumberOfRows(dsItems) == 0)
			{
				initialErrorKey = "MSG_ERROR_PRODUCT_NOT_FOUND";
				goto Step_IdentifyProduct;
			}

			if (this.GetNumberOfRows(dsItems) == 1 &&
				!isSelectProduct)
			{
				//there is only one item, so auto select it!
				DataRow row = dsItems.Tables[0].Rows[0];
				if (pickItemInfo.ItemCode != row[ProductDataSet.Columns.PRODUCT_CODE.Name] as string)
				{
					initialErrorKey = "MSG_ERROR_CANNOT_PICK_THIS_ITEM";
					goto Step_IdentifyProduct;
				}
				//select the batch
				goto Step_SelectSSCC;
			}

			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"InitialErrorKey", initialErrorKey,
					"TitleKey", "MSG_TITLE_SELECT_PRODUCT",
					"ProductDS", dsItems
					));
			msg = WaitForMessage();

			//clear data
			initialErrorKey = null;

			if (msg.Name.EndsWith(".ProductSelected"))
			{
				if (pickItemInfo.ItemCode != ExtractParameter<string>(msg.Parameters, "itemCode"))
				{
					initialErrorKey = "MSG_ERROR_CANNOT_PICK_THIS_ITEM";
					goto Step_IdentifyProduct;
				}

				//select the batch
				goto Step_SelectSSCC;
			}

			if (!luidToPick.HasValue)
			{
				goto Step_IdentifyProduct;
			}
			else
			{
				goto Step_SSCC;
			}

			#endregion

			Step_SelectSSCC:

			#region SELECT SSCC

			luidIsSelected = false;

			//user did not enter an SSCC yet
			if (!luidToPick.HasValue)
			{
				luidIsSelected = true;
				batchNumberTemp = null;
				bbdTemp = null;
				itemSSCC = null;
				if (barcodeContainer != null &&
					barcodeContainer.GS1DataObject != null)
				{
					batchNumberTemp = barcodeContainer.GS1DataObject.LotNumber;
					bbdTemp = barcodeContainer.GS1DataObject.BestBeforeDate;

					itemSSCC = barcodeContainer.GS1DataObject.Sscc;
				}

				//get the list of SSCC for the current item
				query = BuildQuery.GetSSCCFromStock(itemSSCC, pickLocationCode, pickItemInfo.ItemCode, batchNumberTemp, bbdTemp, pickItemInfo.QualityStatusCode, false, luidToPick, pickItemInfo.ItemTransactionalInfoKey);
				DataSet dsSelectSSCC = sboProviderService.RunView(false, null, null, query);

				//did we find any sscc's?
				if (this.GetNumberOfRows(dsSelectSSCC) == 1)
				{
					//there is only one item, so auto select it!
					DataRow row = dsSelectSSCC.Tables[0].Rows[0];
					//copy the data
					luidToPick = Convertor.ConvertToInt32Nullable(row[SSCCDataSet.Columns.LUID.Name]);
					ssccToPick = Convert.ToString(row[SSCCDataSet.Columns.SSCC.Name]);
					//select the batch
					goto Step_SelectBatchNumber;
				}

				//is the a null sscc in the list
				bool showButtonNoSSCC = false;

				if (this.GetNumberOfRows(dsSelectSSCC) > 0)
				{
					foreach (DataRow ssccRow in dsSelectSSCC.Tables[0].Rows)
					{
						if (string.IsNullOrEmpty(ssccRow[SSCCDataSet.Columns.SSCC.Name] as string))
						{
							showButtonNoSSCC = true;
							//remove current row
							dsSelectSSCC.Tables[0].Rows.Remove(ssccRow);
							dsSelectSSCC.AcceptChanges();

							break;
						}
					}
				}

				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectSSCCScreen),
					DefaultCultureInfo.Get(), BuildParamCollection(
						"InitialErrorKey", initialErrorKey,
						"TitleKey", "MSG_TITLE_SELECT_SSCC",
						"SSCCDS", dsSelectSSCC,
						"ShowButtonNoSSCC", showButtonNoSSCC
						));
				msg = WaitForMessage();

				//clear data
				initialErrorKey = null;

				if (msg.Name.EndsWith(".SSCCSelected"))
				{
					luidToPick = ExtractParameter<int>(msg.Parameters, "luid");
					ssccToPick = ExtractParameter<string>(msg.Parameters, "sscc");

					goto Step_SelectBatchNumber;
				}

				if (msg.Name.EndsWith(".NoSSCC"))
				{
					luidToPick = null;
					ssccToPick = null;

					goto Step_SelectBatchNumber;
				}


				goto Step_IdentifyProduct;

			}



			#endregion

			Step_SelectBatchNumber:

			#region SELECT BATCH NUMBER

			batchNumber = null;
			bestBeforeDate = null;
			itriToPick = null;
			qualityStatusCode = null;
			batchQuantity = 0;


			//query = BuildQuery.GetBatchNumbersFromStock(luidToPick, pickLocationCode, pickItemInfo.ItemCode, batchNumberTemp, bbdTemp, pickItemInfo.QualityStatusCode, false, true, pickItemInfo.ItemTransactionalInfoKey);
			query = BuildQuery.GetBatchNumbersFromStock(luidToPick, pickLocationCode, pickItemInfo.ItemCode, batchNumberTemp, bbdTemp, null, false, true, null);
			dsBatchNumbers = sboProviderService.RunView(false, null, null, query);

			//remove the already in memory items
			RemoveInMemoryStock(moveItemInfoList, dsBatchNumbers, pickItemInfo.ItemCode, pickLocationCode, luidToPick);

			if (this.GetNumberOfRows(dsBatchNumbers) == 0)
			{
				initialErrorKey = "MSG_ERROR_PRODUCT_BATCHNUMBER_NOT_FOUND";
				goto Step_IdentifyProduct;
			}

			if (this.GetNumberOfRows(dsBatchNumbers) == 1)
			{
				DataRow row = dsBatchNumbers.Tables[0].Rows[0];


				//check if batch number/quality status is correct

				if ((stockLevel == PmxMoveOrderStockLevel.Detail || pickItemInfo.ItemTransactionalInfoKey.HasValue) &&
					Convertor.ConvertToInt32Nullable(row[BatchNumberDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name]) != pickItemInfo.ItemTransactionalInfoKey)
				{

					initialErrorKey = "MSG_ERROR_PRODUCT_BATCHNUMBER_NOT_FOUND";
					goto Step_IdentifyProduct;
				}
				if ((stockLevel == PmxMoveOrderStockLevel.Detail || !string.IsNullOrEmpty(pickItemInfo.QualityStatusCode)) &&
					Convert.ToString(row[BatchNumberDataSet.Columns.QUALITY_STATUS_CODE.Name]) != pickItemInfo.QualityStatusCode)
				{
					initialErrorKey = "MSG_ERROR_PRODUCT_QUALITY_STATUS_NOT_FOUND";
					goto Step_IdentifyProduct;
				}


				batchNumber = row[BatchNumberDataSet.Columns.BATCH_NUMBER.Name] as string;
				batchQuantity = Convert.ToDouble(row[BatchNumberDataSet.Columns.QUANTITY.Name]);
				qualityStatusCode = row[BatchNumberDataSet.Columns.QUALITY_STATUS_CODE.Name] as string;
				if (row[BatchNumberDataSet.Columns.BEST_BEFORE_DATE.Name] is DateTime)
				{
					bestBeforeDate = Convert.ToDateTime(row[BatchNumberDataSet.Columns.BEST_BEFORE_DATE.Name]);
				}
				else
				{
					bestBeforeDate = null;
				}
				itriToPick = Convertor.ConvertToInt32Nullable(row[BatchNumberDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name]);

				goto Step_EnterQuantity;
			}


			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectBatchNumberScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"InitialErrorKey", initialErrorKey,
					"TitleKey", "MSG_TITLE_SELECT_BATCH_NUMBER",
					"BatchNumberDS", dsBatchNumbers
					));
			msg = WaitForMessage();

			//clear data
			initialErrorKey = null;

			if (msg.Name.EndsWith(".BatchNumberSelected"))
			{
				//check if batch number/quality status is correct
				if (ExtractParameter<int?>(msg.Parameters, "itemTransactionalInfoKey") != pickItemInfo.ItemTransactionalInfoKey)
				{
					initialErrorKey = "MSG_ERROR_PRODUCT_BATCHNUMBER_NOT_FOUND";
					goto Step_SelectBatchNumber;
				}
				if (ExtractParameter<string>(msg.Parameters, "qualityStatusCode") != pickItemInfo.QualityStatusCode)
				{
					initialErrorKey = "MSG_ERROR_PRODUCT_QUALITY_STATUS_NOT_FOUND";
					goto Step_SelectBatchNumber;
				}

				batchNumber = ExtractParameter<string>(msg.Parameters, "batchNumber");
				bestBeforeDate = ExtractParameter<DateTime?>(msg.Parameters, "bestBeforeDate");
				batchQuantity = ExtractParameter<double>(msg.Parameters, "quantity");
				qualityStatusCode = ExtractParameter<string>(msg.Parameters, "qualityStatusCode");
				itriToPick = ExtractParameter<int?>(msg.Parameters, "itemTransactionalInfoKey");

				goto Step_EnterQuantity;
			}



			goto Step_IdentifyProduct;


			#endregion

			Step_EnterQuantity:

			#region ENTER QUANTITY

			maximumQty = Math.Min(pickItemInfo.Quantity, batchQuantity);

			forceSerial = false;
			useRange = false;
			listOfSerialNumbers = null;

			if (itemInfo.HasSerialNumber || itemInfo.HasSAPSerialNumber)
			{
				if (!askForSerialNumbers)
				{
					if (itemInfo.TrackLocationSerialNumber ||
						(itemInfo.HasSAPSerialNumber && destinationPmxWhsCode != sourcePmxWhsCode))
					{
						askForSerialNumbers = true;
					}
				}

				if (askForSerialNumbers)
				{
					forceSerial = true;
					//show screen to ask user what to do.
					buttonKeys = new string[2] { "MSG_BUTTON_SERIAL_NUMBER", "MSG_BUTTON_SERIAL_NUMBER_RANGE" };

					toolBarButtons = ToolBarButtons.Back;

					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
							DefaultCultureInfo.Get(), BuildParamCollection(
							"InitialErrorKey", initialErrorKey,
							"TitleKey", "MSG_TITLE_ENTER_QUANTITY_SERIAL_NUMBER_TASK",
							"AllowedButtons", buttonKeys,
							"EnabledToolBarButtons", toolBarButtons
							));
					msg = WaitForMessage();
					initialErrorKey = null;
					if (msg.Name.EndsWith(".ButtonClicked"))
					{
						filterButtonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");

						useRange = filterButtonKey == "MSG_BUTTON_SERIAL_NUMBER_RANGE";
					}

					if (msg.Name.EndsWith(".BackRequested"))
					{
						if (luidToPick.HasValue)
						{
							goto Step_SSCC;
						}
						else
						{
							goto Step_IdentifyPickLocation;
						}
					}
				}

			}



			WorkflowInstanceBase subEnterQuantityFlow = this.Create("EnterQuantityScript");
			SubBackRequested = false;
			subEnterQuantityFlow.BindParameters(
				this.DefaultCultureInfo,
				this.PmxOseCompany,
				new ReadOnlyBinder<string>("TitleKey", "MSG_TITLE_ENTER_QUANTITY"),
				new ReadOnlyBinder<PmxItemInfo>("ItemInfo", itemInfo),
				new ReadOnlyBinder<int?>("ItriKey", itriToPick),
				new ReadOnlyBinder<string>("BatchNumber", batchNumber),
				new ReadOnlyBinder<DateTime?>("BestBeforeDate", bestBeforeDate),
				new ReadOnlyBinder<string>("SSCC", ssccToPick),

				new ReadOnlyBinder<bool>("AllowZero", false),
				new ReadOnlyBinder<double>("InitialQuantity", 0.0),
				new ReadOnlyBinder<double>("MaximumQuantity", maximumQty),
				new ReadOnlyBinder<string>("UOM", itemInfo.InventoryUom),
				new ReadOnlyBinder<int>("NumberOfDigitsAfterDecimal", (itemInfo == null) ? 0 : itemInfo.UomDecimals),
				new ReadOnlyBinder<double>("InnerQuantity", 0.0),
				new ReadOnlyBinder<string>("InnerUOM", null),

				new ReadOnlyBinder<string>("DocNum", moveOrderDocEntry.Value.ToString()),
				new ReadOnlyBinder<double>("StillToQuantity", maximumQty),
				new ReadOnlyBinder<string>("MessageKeyStillQuantity", "MSG_LBL_MAXIMUM_QUANTITY"),

				new ReadOnlyBinder<bool>("ForceInputSerialNumbers", forceSerial),
				new ReadOnlyBinder<string>("ObjectType", (Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxMoveOrder).ToString()),
				new ReadOnlyBinder<int?>("DocEntry", moveOrderDocEntry),
				new ReadOnlyBinder<bool>("UseSerialNumberRange", useRange),
				new ReadOnlyBinder<string>("LocationCode", pickLocationCode),

				new ReadOnlyBinder<int?>("LUID", luidToPick),

				new ReadWriteBinder<bool>("BackRequested", this, "SubBackRequested"),
				new ReadWriteBinder<double>("QuantityEntered", this, "SubQuantity"),
				new ReadWriteBinder<Collection<string>>("ListOfSerialNumbers", this, "m_subFlowListOfSerialNumbers")
			);

			base.StartSubFlowAndWait(subEnterQuantityFlow, true);


			if (SubBackRequested)
			{
				if (luidToPick.HasValue)
				{
					goto Step_SSCC;
				}
				else
				{
					goto Step_IdentifyPickLocation;
				}
			}

			listOfSerialNumbers = m_subFlowListOfSerialNumbers;


			goto Step_AddToMoveList;

			#endregion

			Step_AddToMoveList:

			#region ADD TO MOVE LIST

			query = BuildQuery.GetProductBatchLUIDFromStock(ssccToPick, pickItemInfo.ItemCode, batchNumber, bestBeforeDate, pickLocationCode, pickItemInfo.QualityStatusCode, true);
			ds = sboProviderService.RunView(false, null, null, query);

			// Build list with MoveItemInfo's up to request quantity to move
			double quantityToMove = SubQuantity;

			foreach (DataRow row in ds.Tables[0].Rows)
			{
				MoveItemInfo moveInfo = new MoveItemInfo();
				moveInfo.ItemCode = Convert.ToString(row[PmxItemTable.Columns.ItemCode.NAME]);
				moveInfo.ItemDescription = Convert.ToString(row[PmxItemTable.Columns.ItemName.NAME]);
				moveInfo.ItemTransactionalInfoKey = Convertor.ConvertToInt32Nullable(row[PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME]);
				moveInfo.SourceQualityStatusCode = Convert.ToString(row[PmxInventoryTotalTable.Columns.QualityStatusCode.NAME]);
				moveInfo.DestinationQualityStatusCode = moveInfo.SourceQualityStatusCode;
				moveInfo.SourceLocationCode = Convert.ToString(row[PmxInventoryTotalTable.Columns.StorLocCode.NAME]);

				moveInfo.SourcePmxWhsCode = pickWhsCode;

				moveInfo.SourceLogisticUnitIdentKey = Convertor.ConvertToInt32Nullable(row[PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME]);
				moveInfo.Uom = Convert.ToString(row[PmxItemTable.Columns.InventoryUom.NAME]);
				moveInfo.QuantityPerUom = 1;
				moveInfo.Quantity = Math.Min(Convert.ToDouble(row[PmxInventoryTotalTable.Columns.Quantity.NAME]), quantityToMove);

				moveInfo.ListOfSerialNumbers = listOfSerialNumbers;

				moveItemInfoList.Add(moveInfo);

				//set the moveorder link
				moveInfo.BaseEntry = moveOrderDocEntry;
				moveInfo.BaseLine = moveOrderLineNum;
				moveInfo.BaseType = Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxMoveOrder;

				//reduce the quantity to move
				quantityToMove -= moveInfo.Quantity;

				//no more quantity to move, so we break
				if (quantityToMove <= 0) break;
			}

			goto Step_SelectMoveOrderLine;

			#endregion

			Step_MoveFullPallet:

			#region MOVE FULL PALLET


			if (this.GetNumberOfRows(dsAllItemsOnSSCC) > 0)
			{
				//show message to user that full pallet will be moved
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					DefaultCultureInfo.Get(), BuildParamCollection(
						"MessageKey", "MSG_MOVING_FULL_PALLET",
						"NoTranslationOfMessageKey", false,
						"ShowButton", true,
						"MaxTimeForMessage", Definitions.MAX_TIME_FOR_MESSAGE));

				msg = WaitForMessage();

				foreach (DataRow stockRow in dsAllItemsOnSSCC.Tables[0].Rows)
				{
					string currentItemCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME] as string;

					PmxItemInfo currentItemInfo = null;

					if (!listOfItemInfos.ContainsKey(currentItemCode))
					{
						listOfItemInfos.Add(currentItemCode, sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>(ExecuteGetItemInfo), currentItemCode));
					}

					currentItemInfo = listOfItemInfos[currentItemCode];

					DataRow[] rowsMove = dsMoveItemsFullLUID.Tables[0].Select(string.Format(" {0} = '{1}'", MoveOrderDataSet.Columns.ITEMCODE.Name, currentItemCode));

					double quantityOnStock = Convert.ToDouble(stockRow[PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME]);

					if (rowsMove.Length > 0)
					{

						foreach (DataRow rowMove in rowsMove)
						{
							//we need to remove quantity in memory already moved
							double stillToMoveForMoveLine = GetMoveQuantity(moveItemInfoList, rowMove, stockRow);

							if (stillToMoveForMoveLine > 0)
							{
								MoveItemInfo moveInfo = new MoveItemInfo();

								moveInfo.ItemTransactionalInfoKey = Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME]);

								moveInfo.SourceLogisticUnitIdentKey = Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME]);

								//moving full pallet, so luid can be the same
								moveInfo.DestinationLogisticUnitIdentKey = moveToDestinationLUID.HasValue ? moveToDestinationLUID : moveInfo.SourceLogisticUnitIdentKey;


								moveInfo.DestinationQualityStatusCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string;
								moveInfo.ItemCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME] as string;
								moveInfo.ItemDescription = stockRow[PmxStockOverviewOnLocationDefinition.Columns.ProductDescription.NAME] as string;
								moveInfo.SourceLocationCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME] as string;
								moveInfo.SourcePmxWhsCode = stockRow[PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME] as string;
								moveInfo.SourceQualityStatusCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string;
								moveInfo.Uom = stockRow[PmxStockOverviewOnLocationDefinition.Columns.InventoryUom.NAME] as string;
								moveInfo.QuantityPerUom = 1;

								moveInfo.Quantity = (currentItemInfo.IsLogisticCarrier && quantityOnStock == 1) ? quantityOnStock : Math.Min(quantityOnStock, stillToMoveForMoveLine);

								quantityOnStock -= moveInfo.Quantity;

								//set the moveorder link
								moveInfo.BaseEntry = moveOrderDocEntry;
								moveInfo.BaseLine = Convert.ToInt32(rowMove[MoveOrderDataSet.Columns.LINEID.Name]);
								moveInfo.BaseType = Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxMoveOrder;

								//serial number
								if (!currentItemInfo.TrackLocationSerialNumber &&
									(currentItemInfo.HasSerialNumber || currentItemInfo.HasSAPSerialNumber))
								{
									forceSerial = false;
									useRange = false;

									if (askForSerialNumbers)
									{
										forceSerial = true;
										//show screen to ask user what to do.
										buttonKeys = new string[2] { "MSG_BUTTON_SERIAL_NUMBER", "MSG_BUTTON_SERIAL_NUMBER_RANGE" };

										toolBarButtons = ToolBarButtons.Back;

										session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
												DefaultCultureInfo.Get(), BuildParamCollection(
												"InitialErrorKey", initialErrorKey,
												"TitleKey", "MSG_TITLE_ENTER_QUANTITY_SERIAL_NUMBER_TASK",
												"AllowedButtons", buttonKeys,
												"EnabledToolBarButtons", toolBarButtons
												));
										msg = WaitForMessage();
										initialErrorKey = null;
										if (msg.Name.EndsWith(".BackRequested"))
										{
											goto Step_SelectMoveOrderLine;
										}

										if (msg.Name.EndsWith(".ButtonClicked"))
										{
											filterButtonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");

											useRange = filterButtonKey == "MSG_BUTTON_SERIAL_NUMBER_RANGE";
										}


										SubBackRequested = false;
										m_enterQuantitySubFlow.BindParameters(
											this.DefaultCultureInfo,
											this.PmxOseCompany,
											new ReadOnlyBinder<string>("TitleKey", "MSG_TITLE_ENTER_QUANTITY"),
											new ReadOnlyBinder<PmxItemInfo>("ItemInfo", currentItemInfo),
											new ReadOnlyBinder<int?>("ItriKey", moveInfo.ItemTransactionalInfoKey),
											new ReadOnlyBinder<string>("BatchNumber", stockRow[PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME] as string),
											new ReadOnlyBinder<DateTime?>("BestBeforeDate", Convertor.ConvertToDateTimeNullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME])),
											new ReadOnlyBinder<string>("SSCC", stockRow[PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME] as string),

											new ReadOnlyBinder<bool>("AllowZero", false),
											new ReadOnlyBinder<double>("InitialQuantity", 0.0),
											new ReadOnlyBinder<double>("MaximumQuantity", moveInfo.Quantity),
											new ReadOnlyBinder<string>("UOM", currentItemInfo.InventoryUom),
											new ReadOnlyBinder<int>("NumberOfDigitsAfterDecimal", (currentItemInfo == null) ? 0 : currentItemInfo.UomDecimals),
											new ReadOnlyBinder<double>("InnerQuantity", 0.0),
											new ReadOnlyBinder<string>("InnerUOM", null),

											new ReadOnlyBinder<string>("DocNum", moveOrderDocEntry.Value.ToString()),
											new ReadOnlyBinder<double>("StillToQuantity", moveInfo.Quantity),
											new ReadOnlyBinder<string>("MessageKeyStillQuantity", "MSG_LBL_MAXIMUM_QUANTITY"),

											new ReadOnlyBinder<bool>("ForceInputSerialNumbers", forceSerial),
											new ReadOnlyBinder<double>("MinimumQuantity", moveInfo.Quantity),
											new ReadOnlyBinder<string>("ObjectType", (Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxMoveOrder).ToString()),
											new ReadOnlyBinder<int?>("DocEntry", moveOrderDocEntry),
											new ReadOnlyBinder<bool>("UseSerialNumberRange", useRange),
											new ReadOnlyBinder<string>("LocationCode", moveInfo.SourceLocationCode),

											new ReadOnlyBinder<int?>("LUID", moveInfo.SourceLogisticUnitIdentKey),

											new ReadWriteBinder<bool>("BackRequested", this, "SubBackRequested"),
											new ReadWriteBinder<double>("QuantityEntered", this, "SubQuantity"),
											new ReadWriteBinder<Collection<string>>("ListOfSerialNumbers", this, "m_subFlowListOfSerialNumbers")
										);

										this.StartSubFlowAndWait(m_enterQuantitySubFlow, true);


										if (SubBackRequested)
										{
											goto Step_SelectMoveOrderLine;
										}

										moveInfo.ListOfSerialNumbers = m_subFlowListOfSerialNumbers;
									}
								}

								//Add to list
								moveItemInfoList.Add(moveInfo);

							}

							if (quantityOnStock == 0)
							{
								break;
							}

						}//foreach


					}
					else if (currentItemInfo.ItemCode == stockRow[PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME] as string &&
						quantityOnStock == 1)
					{
						//we also move logistic carrier
						MoveItemInfo moveInfo = new MoveItemInfo();

						moveInfo.ItemTransactionalInfoKey = Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME]);

						moveInfo.SourceLogisticUnitIdentKey = Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME]);

						//moving full pallet, so luid can be the same
						moveInfo.DestinationLogisticUnitIdentKey = moveInfo.SourceLogisticUnitIdentKey;


						moveInfo.DestinationQualityStatusCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string;
						moveInfo.ItemCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME] as string;
						moveInfo.ItemDescription = stockRow[PmxStockOverviewOnLocationDefinition.Columns.ProductDescription.NAME] as string;
						moveInfo.SourceLocationCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME] as string;
						moveInfo.SourcePmxWhsCode = stockRow[PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME] as string;
						moveInfo.SourceQualityStatusCode = stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string;
						moveInfo.Uom = stockRow[PmxStockOverviewOnLocationDefinition.Columns.InventoryUom.NAME] as string;
						moveInfo.QuantityPerUom = 1;

						moveInfo.Quantity = quantityOnStock;

						moveInfo.IsLogisticCarrier = true;


						//set the moveorder link
						//no link to move order line, because the logistic carrier is not on move order
						moveInfo.BaseEntry = moveOrderDocEntry;
						moveInfo.BaseType = Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxMoveOrder;
						moveInfo.BaseLine = -1;

						//Add to list
						moveItemInfoList.Add(moveInfo);
					}
				}//foreach


			}



			goto Step_SelectMoveOrderLine;


			#endregion

			Step_StartDestiationLocation:

			#region START DESTINATION LOCATION

			newSSCC = false;
			emptyLocations = false;
			destinationLUID = moveToDestinationLUID;
			targetLogCarrierCode = null;
			destinationPmxWhsCode = null;


			//get list of items/quantities
			canItemBeStoredInfoPerItemCode = new Dictionary<string, PmxStorageLocationCanItemBeStoredInfo>();
			foreach (MoveItemInfo info in moveItemInfoList)
			{
				PmxStorageLocationCanItemBeStoredInfo entry;
				if (canItemBeStoredInfoPerItemCode.TryGetValue(info.ItemCode, out entry))
				{
					entry.Quantity += info.Quantity;
				}
				else
				{
					entry = new PmxStorageLocationCanItemBeStoredInfo(info.Quantity, null, null);
					canItemBeStoredInfoPerItemCode.Add(info.ItemCode, entry);
				}
				if (info.ItemTransactionalInfoKey.HasValue)
				{
					if (entry.ItriKeys == null) entry.ItriKeys = new List<int>();
					entry.ItriKeys.Add(info.ItemTransactionalInfoKey.Value);
				}
			}

			//get zonetypes
			Collection<string> itemCodes = new Collection<string>();
			foreach (string tempItemCode in canItemBeStoredInfoPerItemCode.Keys)
			{
				itemCodes.Add(tempItemCode);
			}
			query = BuildQuery.GetZoneTypesForItems(itemCodes);
			dsZoneTypes = sboProviderService.RunView(false, null, null, query);

			listOfZoneTypes = new Collection<string>();
			if (this.GetNumberOfRows(dsZoneTypes) > 0)
			{
				foreach (DataRow row in dsZoneTypes.Tables[0].Rows)
				{
					listOfZoneTypes.Add(row[PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME] as string);
				}
			}

			goto Step_EnterDestinationLocation;

			#endregion

			Step_EnterDestinationLocation:

			#region ENTER DESTINATION LOCATION

			destinationLocationCode = null;
			enteredDestinationLocationCode = null;
			buttonKeyIdentifyDestinationLocationScreen = null;

			if (destinationLUID.HasValue)
			{
				//we need to enter SSCC
				goto Step_DestinationSSCC;
			}


			string[] buttons = null;

			if (newSSCC)
			{
				buttons = new string[] { "MSG_BUTTON_SELECT_LOCATION", "MSG_BUTTON_SELECT_EMPTY_LOCATION" };
			}
			else
			{
				buttons = new string[] { "MSG_BUTTON_NEW_SSCC" };
			}


			session.ShowScreen(typeof(IScanStringValueScreen),
			   this.DefaultCultureInfo, BuildParamCollection(
				   "InitialErrorKey", initialErrorKey,
				   "TitleKey", newSSCC ? "MSG_TITLE_SCAN_DESTINATION_LOCATION" : "MSG_TITLE_DST_LOCATION_OR_SSCC",
				   "ForceDataEntry", true,
				   "AllowedButtonKeys", buttons,
				   "AllowToGoBack", true,
				   "Information", "MSG_LABEL_DESTINATION_LOCATION",
				   "MessageAddendum", pickItemInfo.DestinationStorLocCode

				   ));
			initialErrorKey = null;
			msg = WaitForMessage();

			if (msg.Name.EndsWith(".StringScanned"))
			{
				BarcodeContainer barcode = new BarcodeContainer();
				ProdumexError pmxError = null;
				try
				{
					pmxError = BarcodeHelper.ParseElementString(ExtractParameter<string>(msg.Parameters, "stringValue"), true, barcode);
				}
				catch
				{
					// Do nothing
				}
				if (!String.IsNullOrEmpty(barcode.GS1DataObject.Sscc))
				{
					query = BuildQuery.GetSSCCInfo(barcode.GS1DataObject.Sscc);
					ds = sboProviderService.RunView(false, null, null, query);
					if (GetNumberOfRows(ds) > 0)
					{
						newSSCC = false;

						destinationLUID = Convert.ToInt32(ds.Tables[0].Rows[0][SSCCDataSet.Columns.LUID.Name]);
						enteredDestinationLocationCode = Convert.ToString(ds.Tables[0].Rows[0][SSCCDataSet.Columns.STORAGE_LOCATION_CODE.Name]);
						destinationPmxWhsCode = Convert.ToString(ds.Tables[0].Rows[0][SSCCDataSet.Columns.PMX_WAREHOUSE_CODE.Name]);
					}
					if (String.IsNullOrEmpty(enteredDestinationLocationCode) ||
						enteredDestinationLocationCode != pickItemInfo.DestinationStorLocCode)
					{
						initialErrorKey = "MSG_ERROR_INCORRECT_DESTINATION_SSCC_MOVE_ORDER";
						goto Step_EnterDestinationLocation;
					}

					goto Step_SelectDestinationLocation;
				}
				else
				{
					enteredDestinationLocationCode = ExtractParameter<string>(msg.Parameters, "stringValue");
					goto Step_SelectDestinationLocation;
				}
			}
			if (msg.Name.EndsWith(".ButtonClicked"))
			{
				string buttonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");
				if (buttonKey == "MSG_BUTTON_SELECT_LOCATION")
				{
					goto Step_SelectDestinationLocation;
				}
				if (buttonKey == "MSG_BUTTON_SELECT_EMPTY_LOCATION")
				{
					emptyLocations = true;
					goto Step_SelectDestinationLocation;
				}
				if (buttonKey == "MSG_BUTTON_NEW_SSCC")
				{
					#region Step_IdentifyLogisticCarrier

					query = BuildQuery.GetLogisticCarriersOrderByName(true, true, m_sboProviderService.GetDbTool());
					DataSet dsLogisticCarriers = sboProviderService.RunView(false, null, null, query);
					if (this.GetNumberOfRows(dsLogisticCarriers) > 0)
					{
						session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreen),
							this.DefaultCultureInfo, BuildParamCollection(
							"InitialErrorKey", initialErrorKey,
							"TitleKey", "MSG_TITLE_SELECT_LOGISTIC_CARRIER",
							"ProductDS", dsLogisticCarriers,
							"AllowNoSelection", false,
							"ButtonKey", "MSG_BUTTON_NO_LOGISTIC_CARRIER"));
						msg = WaitForMessage();
						initialErrorKey = null;

						if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreenReply.ProductSelected")
						{
							targetLogCarrierCode = ExtractParameter<string>(msg.Parameters, "itemCode");
						}
						else if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreenReply.ButtonClicked")
						{
							targetLogCarrierCode = "";  // Remember we chose MSG_BUTTON_NO_LOGISTIC_CARRIER
						}
						else if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreenReply.BackRequested")
						{
							goto Step_StartDestiationLocation;
						}
						else
						{
							initialErrorKey = KnownMessageKeys.MSG_ERROR_OPERATION_NOT_SUPPORTED;
							goto Step_StartDestiationLocation;
						}
					}

					#endregion


					newSSCC = true;
					goto Step_EnterDestinationLocation;
				}
			}

			if (this.GetNumberOfRows(dsMoveOrderLines) > 0)
			{
				//go back
				goto Step_SelectMoveOrderLine;
			}
			else
			{
				if (newSSCC)
				{
					//new sscc was selected, so previous screen is the current screen
					newSSCC = false;
					goto Step_StartDestiationLocation;
				}

				backToMoveLines = false;
				goto Step_CheckGoBack;
			}



			#endregion

			Step_SelectDestinationLocation:

			#region SELECT DESTINATION LOCATION

			destinationLocationCode = null;
			destinationPmxWhsCode = null;

			query = BuildQuery.GetStorageLocationForZoneTypes(enteredDestinationLocationCode, destPmxWhsCodeOnMO, listOfZoneTypes,
			emptyLocations);

			dsDestinationLocations = sboProviderService.RunView(false, null, null, query);

			if (this.GetNumberOfRows(dsDestinationLocations) == 0)
			{
				// Inform the user with the error
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					DefaultCultureInfo.Get(), BuildParamCollection(
						"MessageKey", "MSG_ERROR_NO_LOCATION_FOUND",
						"NoTranslationOfMessageKey", false,
						"ShowButton", true));
				WaitForMessage();

				goto Step_EnterDestinationLocation;
			}
			//if ( !String.IsNullOrEmpty( enteredDestinationLocationCode )
			//    && SystemInt32Convertor.ObjectToInt( dsDestinationLocations.Tables[ 0 ].Rows[ 0 ][ LocationDataSet.Columns.FREE_SPACE_FOR_LOG_UNITS.Name ], 1, 1 ) < 1 )
			//{
			//    // Inform the user with the error
			//    session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen ),
			//        DefaultCultureInfo.Get(), BuildParamCollection(
			//            "MessageKey", "MSG_ERROR_LOCATION_NOT_AVAILABLE",
			//            "NoTranslationOfMessageKey", false,
			//            "ShowButton", true ) );
			//    WaitForMessage();

			//    goto Step_EnterDestinationLocation;
			//}

			//locations found
			if (!string.IsNullOrEmpty(enteredDestinationLocationCode) &&
				this.GetNumberOfRows(dsDestinationLocations) == 1)
			{
				destinationLocationCode = Convert.ToString(dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name]);
				destinationPmxWhsCode = Convert.ToString(dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name]);
				goto Step_CheckLocation;
			}

			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
				"InitialErrorKey", initialErrorKey,
				"TitleKey", "MSG_TITLE_SELECT_DESTINATION_LOCATION",
				"LocationDS", dsDestinationLocations,
				"ShowStopButton", false));

			msg = WaitForMessage();
			// Reset latest error
			initialErrorKey = null;

			if (msg.Name.EndsWith(".LocationSelected"))
			{
				destinationLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");
				destinationPmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");

				goto Step_CheckLocation;
			}


			//go back
			goto Step_EnterDestinationLocation;


			#endregion

			Step_DestinationSSCC:

			#region DESTINATION SSCC

			query = BuildQuery.GetProductsFromStockOrderByName(null, null, null, null, false, moveToDestinationLUID, false, null, null, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, null, m_sboProviderService.GetDbTool());
			DataSet dsDestinationSSCC = m_sboProviderService.RunView(false, null, null, query);

			//get the SSCC data
			string destinationSSCC = null;
			string ssccLocationCode = null;
			string ssccPmxWhsCode = null;

			if (this.GetNumberOfRows(dsDestinationSSCC) > 0)
			{
				destinationSSCC = dsDestinationSSCC.Tables[0].Rows[0][PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME] as string;
				ssccLocationCode = dsDestinationSSCC.Tables[0].Rows[0][PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME] as string;
				ssccPmxWhsCode = dsDestinationSSCC.Tables[0].Rows[0][PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME] as string;
			}

			//get SSCC
			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Picking.IIdentifyFullPalletPickingScreen),
			DefaultCultureInfo.Get(), BuildParamCollection(
				"InitialErrorKey", initialErrorKey,
				"TitleKey", "MSG_TITLE_IDENTIFY_DESTINATION_SSCC",
				"LocationCode", ssccLocationCode,
				"SSCC", destinationSSCC
				));
			msg = WaitForMessage();

			initialErrorKey = null;

			if (msg.Name.EndsWith(".SSCCEntered"))
			{
				string tempScannedSSCC = ExtractParameter<string>(msg.Parameters, "sscc");

				//we have an sscc, so we need to check if SSCC is the same
				if (tempScannedSSCC != destinationSSCC)
				{
					initialErrorKey = "MSG_ERROR_INCORRECT_DESTINATION_SSCC";
					goto Step_DestinationSSCC;
				}

				//correct SSCC
				destinationLocationCode = ssccLocationCode;
				destinationPmxWhsCode = ssccPmxWhsCode;
				goto Step_CheckLocation;
			}

			if (msg.Name.EndsWith(".BackRequested"))
			{
				if (this.GetNumberOfRows(dsMoveOrderLines) > 0)
				{
					//go back
					goto Step_SelectMoveOrderLine;
				}
				else
				{
					backToMoveLines = false;
					goto Step_CheckGoBack;
				}
			}



			#endregion

			Step_CheckLocation:

			#region CHECK LOCATION



			if (!moveToDestinationLUID.HasValue &&
				!string.IsNullOrEmpty(pickItemInfo.DestinationStorLocCode) &&
				destinationLocationCode != pickItemInfo.DestinationStorLocCode)
			{
				initialErrorKey = "MSG_ERROR_INCORRECT_DESTINATION_LOCATION";
				goto Step_EnterDestinationLocation;
			}

			//check if we have new SSCC when moving serial number with location tracking
			foreach (MoveItemInfo moveInfo in moveItemInfoList)
			{

				if (!listOfItemInfos.ContainsKey(moveInfo.ItemCode))
				{
					listOfItemInfos.Add(moveInfo.ItemCode, sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>(ExecuteGetItemInfo), moveInfo.ItemCode));
				}

				PmxItemInfo itemInfoForItem = listOfItemInfos[moveInfo.ItemCode];
				if (!newSSCC && !destinationLUID.HasValue && itemInfoForItem.TrackLocationSerialNumber)
				{
					initialErrorKey = "MSG_ERROR_SERIAL_NUMMER_WITH_TRACKING_LOCATION_NEEDS_LUID";
					goto Step_StartDestiationLocation;
				}
			}






			try
			{
				if (sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, new DelegateWithPmxDbConnection<bool>(ExecuteIsLocationLocked), destinationLocationCode))
				{
					// Inform the user with the error
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
						DefaultCultureInfo.Get(), BuildParamCollection(
							"MessageKey", "MSG_ERROR_DESTINATION_LOCATION_LOCKED",
							"NoTranslationOfMessageKey", false,
							"ShowButton", true));
					WaitForMessage();

					goto Step_EnterDestinationLocation;
				}

				//set location in list
				foreach (MoveItemInfo moveInfo in moveItemInfoList)
				{
					moveInfo.DestinationLocationCode = destinationLocationCode;
					moveInfo.DestinationPmxWhsCode = destinationPmxWhsCode;
				}//foreach

				//check if items can be stored on location
				if (!sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null,
					new DelegateWithPmxDbConnection<bool>(ExecuteCanItemsBeStoredOnStorageLocation),
					destinationLocationCode, canItemBeStoredInfoPerItemCode))
				{
					// Inform the user with the error
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
						DefaultCultureInfo.Get(), BuildParamCollection(
							"MessageKey", "MSG_ERROR_STORAGE_LOCATION_NOT_ALLOWED_FOR_ITEM",
							"NoTranslationOfMessageKey", false,
							"IsError", true,
							"ShowButton", true));
					WaitForMessage();


					goto Step_EnterDestinationLocation;

				}

				goto Step_MakeMove;
			}
			catch (Exception ex)
			{
				s_log.Error("", ex);
				if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
				{
					// Inform the user with the error
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
						DefaultCultureInfo.Get(), BuildParamCollection(
							"MessageKey", ex.Message,
							"NoTranslationOfMessageKey", true,
							"IsError", true,
							"ShowButton", true));
					WaitForMessage();

				}
				else
				{
					// Inform the user with the error
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
						DefaultCultureInfo.Get(), BuildParamCollection(
							"PmxError", ((ProdumexException)ex).Error,
							"ShowButton", true));
					WaitForMessage();
				}
				goto Step_EnterDestinationLocation;
			}

			#endregion

			Step_MakeMove:

			#region MAKE MOVE

			bool removeLogCarrierFromList = false;

			Collection<DocumentRef> list = null;

			try
			{
				bool useSboConnection = false;

				foreach (MoveItemInfo move in moveItemInfoList)
				{
					if (move.DestinationPmxWhsCode != move.SourcePmxWhsCode)
					{
						//warehouse changes, so we need SBO connection
						useSboConnection = true;
						break;
					}
				}


				// Execute MOVE
				list = sboProviderService.InvokeMethodWithDbConnection<Collection<DocumentRef>>(useSboConnection, false, null, null, delegate (PmxDbConnection conn, object[] parameters)
				{
					if (newSSCC)
					{
						//Generate new SSCC
						PmxLogisticUnitIDProvider luidProv = new PmxLogisticUnitIDProvider(conn);
						destinationLUID = luidProv.GenerateNewLogisticUnit(null);
						// Also move log.carrier
						if (!String.IsNullOrEmpty(targetLogCarrierCode))
						{
							PmxInventoryProvider invProv = new PmxInventoryProvider(conn);

							MoveItemInfo logCarInfo = invProv.GetMoveItemInfoForFreeLogisticCarrier(destinationLocationCode, targetLogCarrierCode);
							logCarInfo.DestinationLocationCode = destinationLocationCode;
							logCarInfo.DestinationPmxWhsCode = destinationPmxWhsCode;

							moveItemInfoList.Add(logCarInfo);


							removeLogCarrierFromList = true;
						}

					}

					foreach (MoveItemInfo moveInfo in moveItemInfoList)
					{
						if (destinationLUID.HasValue)
						{
							moveInfo.DestinationLogisticUnitIdentKey = destinationLUID;
						}
						if (!newSSCC)
						{
							//no new sscc, so we need to remove the is logistic carrier setting
							moveInfo.IsLogisticCarrier = false;
						}

					}

					PmxMoveProvider moveProv = new PmxMoveProvider(conn);
					return moveProv.MakeAdHocMove(moveItemInfoList, null, destinationLocationCode);
				});


				//inform user
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					DefaultCultureInfo.Get(), BuildParamCollection(
						"MessageKey", "MSG_ITEMS_MOVED",
						"NoTranslationOfMessageKey", false,
						"ShowButton", true,
						"MaxTimeForMessage", Definitions.MAX_TIME_FOR_MESSAGE
						));
				WaitForMessage();

			}
			catch (Exception ex)
			{
				s_log.Error("", ex);
				if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
				{
					// Inform the user with the error
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
						DefaultCultureInfo.Get(), BuildParamCollection(
							"MessageKey", ex.Message,
							"NoTranslationOfMessageKey", true,
							"ShowButton", true,
							"IsError", true
							));
					WaitForMessage();

				}
				else
				{
					// Inform the user with the error
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
						DefaultCultureInfo.Get(), BuildParamCollection(
							"PmxError", ((ProdumexException)ex).Error,
							"ShowButton", true));
					WaitForMessage();
				}

				//retry?
				//ask user if he wants to retry
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
					DefaultCultureInfo.Get(), BuildParamCollection(
						"TitleKey", "MSG_TITLE_RETRY_UPDATE",
						"MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_WANT_RETRY"));
				msg = WaitForMessage();

				if (msg.Name.ToLower().EndsWith(".yes"))
				{
					if (removeLogCarrierFromList)
					{
						// In case transaction fails we again have the original list
						moveItemInfoList.RemoveAt(moveItemInfoList.Count - 1);
					}

					goto Step_MakeMove;
				}


				goto Step_EnterDestinationLocation;
			}


			// Print LABEL
			if (newSSCC)
			{
				bool proceed = false;
				while (!proceed)
				{
					numberOfReports = 0;

					try
					{
						//trigger event
						numberOfReports += sboProviderService.InvokeMethodWithDbConnection<int>(false, true, null, null, delegate (PmxDbConnection conn, object[] parameters)
						{
							PmxPrintReportProvider printProv = new PmxPrintReportProvider(conn);
							return printProv.PrintReportsForEvent(PmxPrintReportEventType.WarehouseCreatedLogisticUnit, destinationLocationCode, session.DeviceInstanceId, destinationLUID.Value, out askReprint, stepHelper.GetPrinterFromSelectPrinterScreen);
						});
					}
					catch (Produmex.Foundation.ProdumexException ex)
					{
						s_log.Error(ex.ToString());
						session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
							DefaultCultureInfo.Get(), BuildParamCollection(
								"InitialErrorKey", initialErrorKey,
								"MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
								"MessageAddendum", ex.Message,
								"PmxError", ex.Error,
								"ShowButton", true));

						msg = WaitForMessage();
					}
					catch (Exception ex)
					{
						s_log.Error(ex.ToString());
						session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
							DefaultCultureInfo.Get(), BuildParamCollection(
								"InitialErrorKey", initialErrorKey,
								"MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
								"MessageAddendum", ex.Message,
								"PmxError", Produmex.Sbo.Logex.Data.ProdumexErrors.UnexpectedError(s_log, ex),
								"ShowButton", true));

						msg = WaitForMessage();
					}

					if (numberOfReports > 0 && askReprint)
					{
						session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
							DefaultCultureInfo.Get(), BuildParamCollection(
								"MessageKey", "MSG_QUESTION_REPRINT_LABEL",
								"TitleKey", "MSG_TITLE_REPRINT_LABEL"
								));

						msg = WaitForMessage();

						if (msg.Name.EndsWith(".No"))
						{
							proceed = true;
						}

					}
					else
					{
						proceed = true;
					}

				}


			}


			// Print move document
			if (isWhsTransfer)
			{
				bool proceed = false;
				while (!proceed)
				{
					numberOfReports = 0;

					try
					{

						foreach (DocumentRef docRef in list)
						{

							//trigger event
							numberOfReports += sboProviderService.InvokeMethodWithDbConnection<int>(false, true, null, null, delegate (PmxDbConnection conn, object[] parameters)
							{
								PmxDictionary<string, object> paramList = new PmxDictionary<string, object>();

								if (docRef.DocType == ((int)SboObjectType.StockTransfer).ToString())
								{
									paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.StockTransferDocEntry.NAME, docRef.DocEntry);
									paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.MoveDocentry.NAME, (int?)null);
								}
								else
								{
									paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.StockTransferDocEntry.NAME, (int?)null);
									paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.MoveDocentry.NAME, docRef.DocEntry);
								}

								PmxPrintReportProvider printProv = new PmxPrintReportProvider(conn);
								return printProv.PrintReportsForEventWithParameters(PmxPrintReportEventType.WarehouseMoveAdded, null, session.DeviceInstanceId, paramList, false, out askReprint, stepHelper.GetPrinterFromSelectPrinterScreen);
							});
						}//foreach
					}
					catch (Produmex.Foundation.ProdumexException ex)
					{
						s_log.Error(ex.ToString());
						session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
							DefaultCultureInfo.Get(), BuildParamCollection(
								"InitialErrorKey", initialErrorKey,
								"MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
								"MessageAddendum", ex.Message,
								"PmxError", ex.Error,
								"ShowButton", true));

						msg = WaitForMessage();
					}
					catch (Exception ex)
					{
						s_log.Error(ex.ToString());
						session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
							DefaultCultureInfo.Get(), BuildParamCollection(
								"InitialErrorKey", initialErrorKey,
								"MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
								"MessageAddendum", ex.Message,
								"PmxError", Produmex.Sbo.Logex.Data.ProdumexErrors.UnexpectedError(s_log, ex),
								"ShowButton", true));

						msg = WaitForMessage();
					}

					if (numberOfReports > 0 && askReprint)
					{
						session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
							DefaultCultureInfo.Get(), BuildParamCollection(
								"MessageKey", "MSG_QUESTION_REPRINT_DOCUMENT",
								"TitleKey", "MSG_TITLE_REPRINT_DOCUMENT"
								));

						msg = WaitForMessage();

						if (msg.Name.EndsWith(".No"))
						{
							proceed = true;
						}

					}
					else
					{
						proceed = true;
					}

				}


			}






			goto Step_SelectMoveOrder;

			#endregion

			Step_CheckGoBack:

			#region CHECK GO BACK

			//There are no more items to move, so going back wil clear in memory move items
			//So we need to ask the user what to do
			session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
				DefaultCultureInfo.Get(), BuildParamCollection(
					"TitleKey", "MSG_TITLE_MOVE_ITEMS_IN_LIST",
					"MessageKey", "MSG_QUESTION_MOVE_ITEMS_IN_LIST"));
			msg = WaitForMessage();

			if (msg.Name.ToLower().EndsWith(".yes"))
			{
				moveItemInfoList.Clear();
				goto Step_SelectMoveOrder;
			}

			if (backToMoveLines)
			{
				goto Step_SelectMoveOrderLine;
			}
			else
			{
				goto Step_EnterDestinationLocation;
			}
			goto Step_SelectMoveOrder;
			#endregion

		}

		#endregion

		#region HELPERS

		/// <summary>
		/// Removes the in memory moves.
		/// </summary>
		/// <param name="moveList">The move list.</param>
		/// <param name="dsMoveOrders">The ds move orders.</param>
		private void RemoveInMemoryMoves(Collection<MoveItemInfo> moveList, DataSet dsMoveOrders)
		{
			foreach (MoveItemInfo move in moveList)
			{
				if (move.BaseEntry.HasValue &&
					move.BaseLine.HasValue)
				{

					DataRow[] rows = dsMoveOrders.Tables[0].Select(String.Format("{0} = {1} AND {2} = {3}", MoveOrderDataSet.Columns.MO_DOC_ENTRY.Name,
						move.BaseEntry.Value, MoveOrderDataSet.Columns.LINEID.Name, move.BaseLine.Value));
					double alreadyMoved = move.Quantity;
					for (int iLoop = 0; iLoop < rows.Length; iLoop++)
					{
						double stillToMove = Convert.ToDouble(rows[iLoop][MoveOrderDataSet.Columns.OPENQTY.Name]);
						if (stillToMove <= alreadyMoved)
						{
							//no more quantity to Move, so delete the entry
							rows[iLoop].Delete();
						}
						else
						{
							//reduce the quantity
							rows[iLoop][MoveOrderDataSet.Columns.OPENQTY.Name] = stillToMove - alreadyMoved;
						}
					}
					dsMoveOrders.AcceptChanges();
				}

			}

		}

		private void RemoveInMemoryStock(Collection<MoveItemInfo> moveList, DataSet dsBatchNumbers, string itemCode, string pickLocationCode, int? luid)
		{
			foreach (MoveItemInfo move in moveList)
			{
				if (move.ItemCode == itemCode &&
					move.SourceLogisticUnitIdentKey == luid &&
					move.SourceLocationCode == pickLocationCode)
				{

					DataRow[] rows;
					if (move.ItemTransactionalInfoKey.HasValue)
					{
						rows = dsBatchNumbers.Tables[0].Select(String.Format("{0} = {1} AND {2} = '{3}'", BatchNumberDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name,
								move.ItemTransactionalInfoKey.Value, BatchNumberDataSet.Columns.QUALITY_STATUS_CODE.Name, move.SourceQualityStatusCode));
					}
					else
					{
						rows = dsBatchNumbers.Tables[0].Select(String.Format("{0} IS NULL AND {1} = '{2}'", BatchNumberDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name,
							BatchNumberDataSet.Columns.QUALITY_STATUS_CODE.Name, move.SourceQualityStatusCode));
					}

					double stillToRemove = move.Quantity;
					for (int iLoop = 0; iLoop < rows.Length; iLoop++)
					{
						double batchQty = Convert.ToDouble(rows[iLoop][BatchNumberDataSet.Columns.QUANTITY.Name]);
						if (batchQty <= stillToRemove)
						{
							//no more quantity to Move, so delete the entry
							rows[iLoop].Delete();
						}
						else
						{
							//reduce the quantity
							rows[iLoop][BatchNumberDataSet.Columns.QUANTITY.Name] = batchQty - stillToRemove;
						}

						stillToRemove -= batchQty;
						dsBatchNumbers.AcceptChanges();
						if (stillToRemove <= 0)
						{
							break;
						}

					}
				}

			}

		}

		/// <summary>
		/// Gets the packaging types still to move.
		/// </summary>
		/// <param name="stillToMove">The still to move.</param>
		/// <param name="uom">The uom.</param>
		/// <param name="listOfTransactionalPackagingTypes">The list of transactional packaging types.</param>
		/// <returns></returns>
		private string GetPackagingTypesStillToMove(double stillToMove, string uom, Collection<PackagingTypeInfo> listOfTransactionalPackagingTypes)
		{

			if (listOfTransactionalPackagingTypes == null ||
				listOfTransactionalPackagingTypes.Count == 0)
			{
				return string.Format("# {0} {1}", stillToMove.ToString(), uom);
			}

			//we found packagingTypes
			double currentQty = stillToMove;
			StringBuilder sb = new StringBuilder();
			string separator = "";
			//loop from end
			for (int iLoop = 0; iLoop < listOfTransactionalPackagingTypes.Count; iLoop++)
			{
				double qty = currentQty / listOfTransactionalPackagingTypes[iLoop].QuantityPerPack;

				qty = Produmex.Foundation.Utilities.FormattingHelper.FloorForDecimals(qty, ((iLoop + 1) == listOfTransactionalPackagingTypes.Count) ? listOfTransactionalPackagingTypes[iLoop].NumberOfDecimals : 0);


				sb.AppendFormat("{0}{1} {2}",
					separator, qty.ToString(), listOfTransactionalPackagingTypes[iLoop].PackagingTypeName);

				currentQty -= qty * listOfTransactionalPackagingTypes[iLoop].QuantityPerPack;

				separator = Definitions.SEPARATOR;

			}

			return sb.ToString();


		}




		/// <summary>
		/// Gets the unused quantity.
		/// </summary>
		/// <param name="moveItemInfoList">The move item info list.</param>
		/// <param name="stockRow">The stock row.</param>
		/// <returns></returns>
		private static double GetUnusedQuantity(Collection<MoveItemInfo> moveItemInfoList, DataRow stockRow)
		{
			double qty = Convert.ToDouble(stockRow[PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME]);

			//remove already moved qty
			if (moveItemInfoList != null &&
				stockRow != null)
			{
				foreach (MoveItemInfo mi in moveItemInfoList)
				{
					//only check for filled in data
					if (mi.ItemTransactionalInfoKey == Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME]) &&
						mi.SourceLogisticUnitIdentKey == Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME]) &&
						mi.SourceQualityStatusCode == stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string &&
						mi.ItemCode == stockRow[PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME] as string &&
						mi.SourceLocationCode == stockRow[PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME] as string
						)
					{
						qty -= mi.Quantity;
					}
				}
			}


			return qty;
		}

		/// <summary>
		/// Gets the move quantity.
		/// </summary>
		/// <param name="moveItemInfoList">The move item info list.</param>
		/// <param name="moveLineRow">The move line row.</param>
		/// <param name="stockRow">The stock row.</param>
		/// <returns></returns>
		private static double GetMoveQuantity(Collection<MoveItemInfo> moveItemInfoList, DataRow moveLineRow, DataRow stockRow)
		{
			double qty = Convert.ToDouble(moveLineRow[MoveOrderDataSet.Columns.OPENQTY.Name]);
			int lineNum = Convert.ToInt32(moveLineRow[MoveOrderDataSet.Columns.LINEID.Name]);

			//remove already moved qty
			//if (moveItemInfoList != null)
			//{
			//    foreach (MoveItemInfo mi in moveItemInfoList)
			//    {
			//        if (mi.BaseLine == lineNum)
			//        {
			//            qty -= mi.Quantity;
			//        }
			//    }
			//}

			if (stockRow != null)
			{

				//check if the stock is allowed
				PmxMoveOrderStockLevel stockLevelForMove = (PmxMoveOrderStockLevel)moStockLevelConvertor.ConvertColumnToBOProperty(Convert.ToString(moveLineRow[MoveOrderDataSet.Columns.STOCKLEVEL.Name]));
				int? itriForMove = Convertor.ConvertToInt32Nullable(moveLineRow[MoveOrderDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name]);

				string srcLocMO = moveLineRow[MoveOrderDataSet.Columns.SOURCE_QUALITY_STATUS_CODE.Name] as string;
				string srcLocStock = stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string;

				bool isEqual = moveLineRow[MoveOrderDataSet.Columns.SOURCE_QUALITY_STATUS_CODE.Name] as string == stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string;


				if (stockLevelForMove == PmxMoveOrderStockLevel.Detail)
				{
					//all data should correspond
					if (Convertor.ConvertToInt32Nullable(moveLineRow[MoveOrderDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name]) != Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME]) ||
						Convertor.ConvertToInt32Nullable(moveLineRow[MoveOrderDataSet.Columns.LUID.Name]) != Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME]) ||
						moveLineRow[MoveOrderDataSet.Columns.SOURCE_STORAGE_LOCATION.Name] as string != stockRow[PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME] as string ||
					moveLineRow[MoveOrderDataSet.Columns.SOURCE_QUALITY_STATUS_CODE.Name] as string != stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string)
					{
						qty = 0;
					}
				}
				else
				{
					//only check for filled in data
					if ((!string.IsNullOrEmpty(moveLineRow[MoveOrderDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name] as string) && Convertor.ConvertToInt32Nullable(moveLineRow[MoveOrderDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name]) != Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME])) ||
						(Convertor.ConvertToInt32Nullable(moveLineRow[MoveOrderDataSet.Columns.LUID.Name]).HasValue && Convertor.ConvertToInt32Nullable(moveLineRow[MoveOrderDataSet.Columns.LUID.Name]) != Convertor.ConvertToInt32Nullable(stockRow[PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME])) ||
						(!string.IsNullOrEmpty(moveLineRow[MoveOrderDataSet.Columns.SOURCE_STORAGE_LOCATION.Name] as string) && moveLineRow[MoveOrderDataSet.Columns.SOURCE_STORAGE_LOCATION.Name] as string != stockRow[PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME] as string) ||
						  (!string.IsNullOrEmpty(moveLineRow[MoveOrderDataSet.Columns.SOURCE_QUALITY_STATUS_CODE.Name] as string) && moveLineRow[MoveOrderDataSet.Columns.SOURCE_QUALITY_STATUS_CODE.Name] as string != stockRow[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME] as string)
						)
					{
						qty = 0;
					}
				}

			}


			return qty;
		}


		private T ExecuteMethodWithDbConnection<T>(out ProdumexError pmxError, bool useSboConnection, bool useUserNameOfConnectionString, DelegateWithPmxDbConnection<T> methodDelegate, params object[] parameters)
		{
			T result = default(T);
			pmxError = null;

			try
			{
				result = m_sboProviderService.InvokeMethodWithDbConnection<T>(useSboConnection, useUserNameOfConnectionString, null, null,
					methodDelegate, parameters);
			}
			catch (TargetInvocationException ex)
			{
				MethodInfo methodInfo = methodDelegate.Method;
				if (ex.InnerException is ProdumexException)
				{
					s_log.Warn("Execute -- The invoked method threw a produmex exception: ", ex.InnerException);
					pmxError = ((ProdumexException)ex.InnerException).Error;
				}
				else if (ex.InnerException == null)
				{
					s_log.Warn("Execute -- The invoked method threw an exception: ", ex);
					pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.Message);
				}
				else
				{
					s_log.Warn("Execute -- The invoked method threw a TargetInvocationException with inner exception: ", ex.InnerException);
					pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.InnerException.Message);
				}
			}
			catch (TransactionAbortedException ex)
			{
				MethodInfo methodInfo = methodDelegate.Method;
				pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.InnerException == null ? ex.Message : ex.InnerException.Message);
			}
			catch (ProdumexException ex)
			{
				if (ex.Error != null)
				{
					pmxError = ex.Error;
				}
				else
				{
					MethodInfo methodInfo = methodDelegate.Method;
					pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.Message);
				}
			}
			catch (Exception ex)
			{
				MethodInfo methodInfo = methodDelegate.Method;
				pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod(s_log, methodInfo, ex.Message);
			}

			return result;
		}

		///// <summary>
		///// Executes the print reports for event collection.
		///// </summary>
		///// <param name="conn">The conn.</param>
		///// <param name="parameters">The parameters.</param>
		///// <returns></returns>
		//private static int ExecutePrintReportsForEventWithParametersCollection(PmxDbConnection conn, object[] parameters)
		//{
		//    PmxPrintReportProvider prov = new PmxPrintReportProvider(conn);

		//    return prov.PrintReportsForEventWithParametersCollection((PmxPrintReportEventType)parameters[0], (string)parameters[1], (string)parameters[2], (Collection<Dictionary<string, object>>)parameters[3], (bool)parameters[4]);
		//}

		///// <summary>
		///// Executes the print reports for event.
		///// </summary>
		///// <param name="conn">The conn.</param>
		///// <param name="parameters">The parameters.</param>
		///// <returns></returns>
		//private static int ExecutePrintReportsForEvent(PmxDbConnection conn, object[] parameters)
		//{
		//    PmxPrintReportProvider prov = new PmxPrintReportProvider(conn);

		//    return prov.PrintReportsForEvent((PmxPrintReportEventType)parameters[0], (string)parameters[1], (string)parameters[2], (int)parameters[3], (bool)parameters[4]);
		//}




		/// <summary>
		/// Executes the get PMX warehouse code.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="parameters">The parameters.</param>
		/// <returns></returns>
		private static PmxOseWarehouseInfo ExecuteGetPmxWarehouseCode(PmxDbConnection conn, object[] parameters)
		{
			PmxOseProvider oseProv = new PmxOseProvider(conn);
			return oseProv.GetPmxWarehouseInfo((string)parameters[0]);
		}

		/// <summary>
		/// Executes the is full mono pallet.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="parameters">The parameters.</param>
		/// <returns></returns>
		private static bool ExecuteIsFullMonoPallet(PmxDbConnection conn, object[] parameters)
		{
			PmxInventoryProvider prov = new PmxInventoryProvider(conn);
			return prov.IsFullMonoPallet((int)parameters[0], (string)parameters[1], (double)parameters[2]);
		}

		private static bool ExecuteIsLocationLocked(PmxDbConnection conn, object[] parameters)
		{
			PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
			return prov.IsLocationLocked((string)parameters[0]);
		}

		private static bool ExecuteCanItemsBeStoredOnStorageLocation(PmxDbConnection conn, object[] parameters)
		{
			PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
			return prov.CanItemsBeStoredOnStorageLocation((string)parameters[0], (PmxDictionary<string, PmxStorageLocationCanItemBeStoredInfo>)parameters[1]);
		}

		/// <summary>
		/// Executes the name of the get extra db.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="parameters">The parameters.</param>
		/// <returns></returns>
		private static string ExecuteGetExtraDbName(PmxDbConnection conn, object[] parameters)
		{
			PmxExtraDbProvider prov = new PmxExtraDbProvider(conn);
			return prov.GetFirstBO().ExtraDb;
		}



		/// <summary>
		/// Executes the get culture info from language code.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="parameters">The parameters.</param>
		/// <returns></returns>
		private static CultureInfo ExecuteGetCultureInfoFromLanguageCode(PmxDbConnection conn, object[] parameters)
		{
			PmxUserLanguageProvider prov = new PmxUserLanguageProvider((SboConnection)conn);
			return prov.GetCultureInfo((int)parameters[0]);
		}




		/// <summary>
		/// Gets the number of rows.
		/// </summary>
		/// <param name="ds">The ds.</param>
		/// <returns></returns>
		private int GetNumberOfRows(DataSet ds)
		{
			if (ds != null &&
				ds.Tables.Count > 0)
			{
				return ds.Tables[0].Rows.Count;
			}

			return 0;
		}



		/// <summary>
		/// Executes the get item info.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="parameters">The parameters.</param>
		/// <returns></returns>
		private static PmxItemInfo ExecuteGetItemInfo(PmxDbConnection conn, object[] parameters)
		{
			PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
			return prov.GetItemInfo((string)parameters[0]);
		}


		/// <summary>
		/// Executes the get item infos.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="parameters">The parameters.</param>
		/// <returns></returns>
		private static Dictionary<string, PmxItemInfo> ExecuteGetItemInfos(PmxDbConnection conn, object[] parameters)
		{
			PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
			return prov.GetItemInfosInDictionary((Collection<string>)parameters[0]);
		}



		#endregion

	}

	#region BUILD QUERY



	/// <summary>
	/// Static class grouping our native queries
	/// </summary>
	internal static class BuildQuery
	{

		private static PmxMoveOrderTypeConvertor s_moveOrderTypeConvertor = new PmxMoveOrderTypeConvertor();


		internal static string GetSSCCInfo(string sscc)
		{
			StringBuilder strBuilder = new StringBuilder();

			strBuilder.AppendFormat("SELECT DISTINCT {0}",
				SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME, SSCCDataSet.Columns.LUID.Name));
			strBuilder.AppendFormat(", {0}",
				SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME, SSCCDataSet.Columns.SSCC.Name));
			strBuilder.AppendFormat(", {0}",
				SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME, SSCCDataSet.Columns.STORAGE_LOCATION_CODE.Name));
			strBuilder.AppendFormat(", {0}",
				SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, SSCCDataSet.Columns.PMX_WAREHOUSE_CODE.Name));

			strBuilder.AppendFormat(", {0}",
				SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, SSCCDataSet.Columns.PMX_WAREHOUSE_NAME.Name));


			strBuilder.AppendFormat("\r\n FROM {0}",
				SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

			strBuilder.AppendFormat("\r\n INNER JOIN {0}",
				SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));

			strBuilder.AppendFormat(" ON {0} = {1}",
				SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME),
				SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));

			strBuilder.AppendFormat("\r\n INNER JOIN {0}",
			SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));

			strBuilder.AppendFormat(" ON {0} = {1}",
				SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
				SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));

			strBuilder.AppendFormat("\r\n INNER JOIN {0}",
				SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
			strBuilder.AppendFormat(" ON {0} = {1}",
				SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME),
				SqlCommandHelper.EscapeTableColumnName(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME));




			strBuilder.AppendFormat("\r\n WHERE {0} = {1}",
				SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME),
				SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));

			return strBuilder.ToString();
		}

		/// <summary>
		/// Gets the move orders order lines by priority due date.
		/// </summary>
		/// <param name="sscc">The SSCC.</param>
		/// <param name="sourceStorageLocationCode">The source storage location code.</param>
		/// <param name="itemCode">The item code.</param>
		/// <param name="batchNumber">The batch number.</param>
		/// <param name="moType">Type of the mo.</param>
		/// <param name="noLogisticCarriers">if set to <c>true</c> [no logistic carriers].</param>
		/// <param name="packagingUnit">The packaging unit.</param>
		/// <returns>Sql statement to get the data</returns>
		public static string GetMoveOrdersOrderLinesByPriorityDueDate(string sscc, string sourceStorageLocationCode, string itemCode, string batchNumber, bool noLogisticCarriers, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit packagingUnit, int? moveOrderDocEntry, DbTool dbTool)
		{
			DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();
			strBuilder.Append("SELECT ");

			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DocEntry.NAME, MoveOrderDataSet.Columns.MO_DOC_ENTRY.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.SourceStorageLocationCode.NAME, MoveOrderDataSet.Columns.SOURCE_STORAGE_LOCATION.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.DestinationStorageLocationCode.NAME, MoveOrderDataSet.Columns.DESTINATION_STORAGE_LOCATION.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.ItemCode.NAME, MoveOrderDataSet.Columns.ITEMCODE.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.CustomItemDescr.NAME, MoveOrderDataSet.Columns.ITEMDESCRIPTION.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.OpenQty.NAME, MoveOrderDataSet.Columns.OPENQTY.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.LineNum.NAME, MoveOrderDataSet.Columns.LINEID.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.QualityStatusCode.NAME, MoveOrderDataSet.Columns.SOURCE_QUALITY_STATUS_CODE.Name);
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, MoveOrderDataSet.Columns.BATCHNUMBER.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME, MoveOrderDataSet.Columns.BATCHNUMBER2.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME, MoveOrderDataSet.Columns.SSCC.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.SourceLogisticUnitIdentificationKey.NAME, MoveOrderDataSet.Columns.LUID.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, MoveOrderDataSet.Columns.BESTBEFOREDATE.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.ItemTransactionalInfoKey.NAME, MoveOrderDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name));
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.StockLevel.NAME, MoveOrderDataSet.Columns.STOCKLEVEL.Name);
			strBuilder.Append(", ");
			Produmex.Sbo.Logex.Data.SboCommands.AddBarcodeUsingPackagingUnit(strBuilder, packagingUnit, MoveOrderDataSet.Columns.GTIN.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.Uom.NAME, MoveOrderDataSet.Columns.UOM.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.QuantityPerUom.NAME, MoveOrderDataSet.Columns.QUANTITY_PER_UOM.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME, MoveOrderDataSet.Columns.INVENTORY_UOM.Name);
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.OpenQtyUom2.NAME, MoveOrderDataSet.Columns.OPENQTYUOM2.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME, MoveOrderDataSet.Columns.DESTINATION_LUID.Name));

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.FromPmxWhsCode.NAME, MoveOrderDataSet.Columns.SOURCE_WHS.Name);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.ToPmxWhsCode.NAME, MoveOrderDataSet.Columns.DESTINATION_WHS.Name);


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveOrderTable.NAME));

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveOrderLineTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DocEntry.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.DocEntry.NAME);

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.ItemCode.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME);

			strBuilder.Append(" LEFT OUTER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.SourceLogisticUnitIdentificationKey.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.ItemTransactionalInfoKey.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME);



			strBuilder.Append(" WHERE ");

			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DocStatus.NAME);
			strBuilder.Append(" <> ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(PmxMoveOrderStatusColumnValues.Closed.VALUE, CultureInfo.InvariantCulture));

			strBuilder.Append(" AND ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.MoveOrderType.NAME);
			strBuilder.AppendFormat(" IN ( {0}, {1}) ", SqlCommandHelper.FormatAndEscapeColumnValue(s_moveOrderTypeConvertor.ConvertBOPropertyToColumn(PmxMoveOrderType.WarehouseTransfer), CultureInfo.InvariantCulture),
				SqlCommandHelper.FormatAndEscapeColumnValue(s_moveOrderTypeConvertor.ConvertBOPropertyToColumn(PmxMoveOrderType.Move), CultureInfo.InvariantCulture));

			strBuilder.Append(" AND ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.LineStatus.NAME);
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboDocStatusColumnValues.Open.VALUE, CultureInfo.InvariantCulture));

			if (!String.IsNullOrEmpty(sscc))
			{
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));
			}

			if (!String.IsNullOrEmpty(sourceStorageLocationCode))
			{
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.SourceStorageLocationCode.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sourceStorageLocationCode, CultureInfo.InvariantCulture));
			}

			if (!String.IsNullOrEmpty(itemCode))
			{
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.ItemCode.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
			}

			if (!String.IsNullOrEmpty(batchNumber))
			{
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(batchNumber, CultureInfo.InvariantCulture));
			}

			if (noLogisticCarriers)
			{
				strBuilder.Append(" AND (");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.IsLogisticCarrier.NAME);
				strBuilder.Append(" <> ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));
				strBuilder.Append(" OR ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.IsLogisticCarrier.NAME);
				strBuilder.Append(" IS NULL ) ");

			}

			if (moveOrderDocEntry.HasValue)
			{
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderLineTable.NAME, PmxMoveOrderLineTable.Columns.DocEntry.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(moveOrderDocEntry.Value, CultureInfo.InvariantCulture));
			}

			strBuilder.Append(" ORDER BY ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.Priority.NAME);
			strBuilder.Append(" , ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DueDate.NAME);
			return strBuilder.ToString();
		}




		/// <summary>
		/// Gets the move orders.
		/// </summary>
		/// <param name="moveOrderDocEntry">The move order doc entry.</param>
		/// <returns></returns>
		public static string GetMoveOrders(int? moveOrderDocEntry)
		{
			string tableNameSourceWhs = PmxOseWarehouseTable.NAME + "_SOURCE";
			string tableNameDestinationWhs = PmxOseWarehouseTable.NAME + "_DESTINATION";

			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT ");

			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DocEntry.NAME, MoveOrderHeaderDataSet.Columns.MO_DOC_ENTRY.Name);

			strBuilder.Append(", CAST(");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DocEntry.NAME);
			strBuilder.Append(" AS NVARCHAR) AS ");
			strBuilder.Append(MoveOrderHeaderDataSet.Columns.MO_DOC_ENTRY_AS_STRING.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.FromPmxWhsCode.NAME, MoveOrderHeaderDataSet.Columns.SOURCE_WAREHOUSE_CODE.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, tableNameSourceWhs, PmxOseWarehouseTable.Columns.Name.NAME, MoveOrderHeaderDataSet.Columns.SOURCE_WAREHOUSE_NAME.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.ToPmxWhsCode.NAME, MoveOrderHeaderDataSet.Columns.DESTINATION_WAREHOUSE_CODE.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, tableNameDestinationWhs, PmxOseWarehouseTable.Columns.Name.NAME, MoveOrderHeaderDataSet.Columns.DESTINATION_WAREHOUSE_NAME.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DueDate.NAME, MoveOrderHeaderDataSet.Columns.DUE_DATE.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.Remarks.NAME, MoveOrderHeaderDataSet.Columns.REMARKS.Name);


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxMoveOrderTable.NAME));

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(tableNameSourceWhs));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.FromPmxWhsCode.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, tableNameSourceWhs, PmxOseWarehouseTable.Columns.Code.NAME);

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(tableNameDestinationWhs));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.ToPmxWhsCode.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, tableNameDestinationWhs, PmxOseWarehouseTable.Columns.Code.NAME);




			strBuilder.Append(" WHERE ");

			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DocStatus.NAME);
			strBuilder.Append(" <> ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(PmxMoveOrderStatusColumnValues.Closed.VALUE, CultureInfo.InvariantCulture));

			strBuilder.Append(" AND ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.MoveOrderType.NAME);
			strBuilder.AppendFormat(" IN ( {0}, {1}) ", SqlCommandHelper.FormatAndEscapeColumnValue(s_moveOrderTypeConvertor.ConvertBOPropertyToColumn(PmxMoveOrderType.WarehouseTransfer), CultureInfo.InvariantCulture),
				SqlCommandHelper.FormatAndEscapeColumnValue(s_moveOrderTypeConvertor.ConvertBOPropertyToColumn(PmxMoveOrderType.Move), CultureInfo.InvariantCulture));



			if (moveOrderDocEntry.HasValue)
			{
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DocEntry.NAME);
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(moveOrderDocEntry.Value, CultureInfo.InvariantCulture));
			}

			strBuilder.Append(" ORDER BY ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.Priority.NAME);
			strBuilder.Append(" , ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxMoveOrderTable.NAME, PmxMoveOrderTable.Columns.DueDate.NAME);
			return strBuilder.ToString();
		}
		/// <summary>
		/// Gets the name of the products from stock order by.
		/// </summary>
		/// <param name="gtin">The gtin.</param>
		/// <param name="itemCode">The item code.</param>
		/// <param name="locationCode">The location code.</param>
		/// <param name="sscc">The SSCC.</param>
		/// <param name="forceSpecificSSCC">if set to <c>true</c> [force specific SSCC].</param>
		/// <param name="luid">The luid.</param>
		/// <param name="isLogisticCarrier">The is logistic carrier.</param>
		/// <param name="itriKey">The itri key.</param>
		/// <param name="qualityStatusCode">The quality status code.</param>
		/// <param name="packagingUnit">The packaging unit.</param>
		/// <param name="masterLuid">The master luid.</param>
		/// <param name="dbTool">The db tool.</param>
		/// <returns></returns>
		public static string GetProductsFromStockOrderByName(string gtin, string itemCode, string locationCode, string sscc, bool forceSpecificSSCC, int? luid, bool? isLogisticCarrier, int? itriKey, string qualityStatusCode, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit packagingUnit, int? masterLuid, DbTool dbTool)
		{
			string tableNameMasterLUID = PmxLogisticUnitIDTable.NAME + "_MASTER";


			DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();
			strBuilder.Append("SELECT ");

			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemName.NAME, PmxStockOverviewOnLocationDefinition.Columns.ProductDescription.NAME);

			strBuilder.Append(", ");
			Produmex.Sbo.Logex.Data.SboCommands.AddBarcodeUsingPackagingUnit(strBuilder, packagingUnit, PmxStockOverviewOnLocationDefinition.Columns.GTIN.NAME);

			strBuilder.AppendFormat(", " + strBuilder.IFNULL + "({0}, {1}) AS {2} ",
			  SqlCommandHelper.EscapeTableColumnName(SboUomTable.NAME, SboUomTable.Columns.UomCode.NAME),
			  SqlCommandHelper.EscapeTableColumnName(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME),
			  SqlCommandHelper.EscapeColumnName(PmxStockOverviewOnLocationDefinition.Columns.InventoryUom.NAME));



			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME, PmxStockOverviewOnLocationDefinition.Columns.BatchNumber2.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.SSCC.NAME, PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.InternalKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.InternalKey.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME));
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME, PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QuantityUom2.NAME, PmxStockOverviewOnLocationDefinition.Columns.QuantityUom2.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);


			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME));


			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxLinkMasterLUIDTable.NAME, PmxLinkMasterLUIDTable.Columns.MasterLUID.NAME, PmxStockOverviewOnLocationDefinition.Columns.MasterLUID.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(tableNameMasterLUID, PmxLogisticUnitIDTable.Columns.SSCC.NAME, PmxStockOverviewOnLocationDefinition.Columns.MasterSSCC.NAME));


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(strBuilder.WITH_NOLOCK);
			//inner join Product - inventory
			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(" ON ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.Columns.ItemCode.NAME));

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(SboUomTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(SboUomTable.NAME, SboUomTable.Columns.UomEntry.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUoMEntry.NAME));
			strBuilder.Append(" AND ", strBuilder.AsIdentifier(SboUomTable.NAME, SboUomTable.Columns.UomEntry.NAME));
			strBuilder.Append(" <> -1 ");




			//left join for transaction info
			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME));

			Produmex.Sbo.Logex.Data.SboCommands.GetLinkedMasterLUIDSubSelect("\r\n LEFT JOIN ", PmxLinkMasterLUIDTable.NAME, strBuilder);
			//strBuilder.Append(" LEFT JOIN ");
			//strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkMasterLUIDTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxLinkMasterLUIDTable.NAME, PmxLinkMasterLUIDTable.Columns.LUID.NAME));

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
			strBuilder.Append(" AS ", strBuilder.AsIdentifier(tableNameMasterLUID));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxLinkMasterLUIDTable.NAME, PmxLinkMasterLUIDTable.Columns.MasterLUID.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(tableNameMasterLUID, PmxLogisticUnitIDTable.Columns.InternalKey.NAME));



			string operand = " WHERE ";
			if (!string.IsNullOrEmpty(gtin))
			{
				strBuilder.Append(operand);
				Produmex.Sbo.Logex.Data.SboCommands.AddWhereClauseSearchForBarcode(strBuilder, gtin);
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(itemCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(qualityStatusCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(qualityStatusCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(sscc))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (forceSpecificSSCC)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";

			}

			if (itriKey.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itriKey.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}


			if (!string.IsNullOrEmpty(locationCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (luid.HasValue)
			{
				strBuilder.AppendFormat(" {0} {1}.{2}  = {3} ", operand, SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME), SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME), SqlCommandHelper.FormatAndEscapeColumnValue(luid.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (masterLuid.HasValue)
			{
				strBuilder.AppendFormat(" {0} {1}.{2}  = {3} ", operand, SqlCommandHelper.EscapeTableName(PmxLinkMasterLUIDTable.NAME), SqlCommandHelper.EscapeColumnName(PmxLinkMasterLUIDTable.Columns.MasterLUID.NAME), SqlCommandHelper.FormatAndEscapeColumnValue(masterLuid.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (isLogisticCarrier.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));
				strBuilder.Append(" = ");
				if (isLogisticCarrier.Value)
				{
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));
				}
				else
				{
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));
				}
				operand = " AND ";
			}

			//strBuilder.Append(operand);
			//strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			//strBuilder.Append(".");
			//strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.InventoryItem.NAME));
			//strBuilder.Append(" = ");
			//strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

			strBuilder.Append(" ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemName.NAME));
			return strBuilder.ToString();
		}




		/// <summary>
		/// Gets the products from stock order by FEFO.
		/// </summary>
		/// <param name="gtin">The gtin.</param>
		/// <param name="itemCode">The item code.</param>
		/// <param name="locationCode">The location code.</param>
		/// <param name="sscc">The SSCC.</param>
		/// <param name="forceSpecificSSCC">if set to <c>true</c> [force specific SSCC].</param>
		/// <param name="luid">The luid.</param>
		/// <param name="isLogisticCarrier">The is logistic carrier.</param>
		/// <param name="itriKey">The itri key.</param>
		/// <param name="qualityStatusCode">The quality status code.</param>
		/// <param name="packagingUnit">The packaging unit.</param>
		/// <param name="pmxWhsCode">The PMX WHS code.</param>
		/// <returns></returns>
		public static string GetProductsFromStockOrderByFEFO(string gtin, string itemCode, string locationCode, string sscc, bool forceSpecificSSCC, int? luid, bool? isLogisticCarrier, int? itriKey, string qualityStatusCode, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit packagingUnit, string pmxWhsCode, int? masterLUID, DbTool dbTool)
		{
			DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();
			strBuilder.Append("SELECT ");

			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemName.NAME, PmxStockOverviewOnLocationDefinition.Columns.ProductDescription.NAME);

			strBuilder.Append(", ");
			Produmex.Sbo.Logex.Data.SboCommands.AddBarcodeUsingPackagingUnit(strBuilder, packagingUnit, PmxStockOverviewOnLocationDefinition.Columns.GTIN.NAME);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME, PmxStockOverviewOnLocationDefinition.Columns.InventoryUom.NAME);

			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME, PmxStockOverviewOnLocationDefinition.Columns.BatchNumber2.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.SSCC.NAME, PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.InternalKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.InternalKey.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME));
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME, PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QuantityUom2.NAME, PmxStockOverviewOnLocationDefinition.Columns.QuantityUom2.NAME);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);


			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME, PmxLogisticUnitIDTable.Columns.LogisticCarrierCode.NAME));


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(strBuilder.WITH_NOLOCK);
			//inner join Product - inventory
			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(" ON ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.Columns.ItemCode.NAME));

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));


			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME));

			//left join for transaction info
			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME));


			Produmex.Sbo.Logex.Data.SboCommands.GetLinkedMasterLUIDSubSelect("\r\n LEFT JOIN ", PmxLinkMasterLUIDTable.NAME, strBuilder);
			//strBuilder.Append(" LEFT JOIN ");
			//strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkMasterLUIDTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxLinkMasterLUIDTable.NAME, PmxLinkMasterLUIDTable.Columns.LUID.NAME));


			string operand = " WHERE ";
			if (!string.IsNullOrEmpty(gtin))
			{
				strBuilder.Append(operand);
				Produmex.Sbo.Logex.Data.SboCommands.AddWhereClauseSearchForBarcode(strBuilder, gtin);
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(itemCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(pmxWhsCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pmxWhsCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(qualityStatusCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(qualityStatusCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(sscc))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (forceSpecificSSCC)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";

			}

			if (itriKey.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itriKey.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}


			if (!string.IsNullOrEmpty(locationCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (luid.HasValue)
			{
				strBuilder.AppendFormat(" {0} {1}.{2}  = {3} ", operand, SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME), SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME), SqlCommandHelper.FormatAndEscapeColumnValue(luid.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (masterLUID.HasValue)
			{
				strBuilder.AppendFormat(" {0} {1}.{2}  = {3} ", operand, SqlCommandHelper.EscapeTableName(PmxLinkMasterLUIDTable.NAME), SqlCommandHelper.EscapeColumnName(PmxLinkMasterLUIDTable.Columns.MasterLUID.NAME), SqlCommandHelper.FormatAndEscapeColumnValue(masterLUID.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (isLogisticCarrier.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));
				strBuilder.Append(" = ");
				if (isLogisticCarrier.Value)
				{
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));
				}
				else
				{
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));
				}
				operand = " AND ";
			}

			//strBuilder.Append(operand);
			//strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			//strBuilder.Append(".");
			//strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.InventoryItem.NAME));
			//strBuilder.Append(" = ");
			//strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

			strBuilder.Append(" ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));


			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Sequence.NAME));


			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));



			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemName.NAME));
			return strBuilder.ToString();
		}

		/// <summary>
		/// Gets the name of the products from stock order by.
		/// </summary>
		/// <param name="gtin">The gtin.</param>
		/// <param name="itemCode">The item code.</param>
		/// <param name="locationCode">The location code.</param>
		/// <param name="sscc">The SSCC.</param>
		/// <param name="forceSpecificSSCC">if set to <c>true</c> [force specific SSCC].</param>
		/// <param name="luid">The luid.</param>
		/// <param name="isLogisticCarrier">The is logistic carrier.</param>
		/// <param name="itriKey">The itri key.</param>
		/// <param name="qualityStatusCode">The quality status code.</param>
		/// <param name="packagingUnit">The packaging unit.</param>
		/// <returns></returns>
		public static string GetProductList(string gtin, string itemCode, string locationCode, string sscc, bool forceSpecificSSCC, int? luid, bool? isLogisticCarrier, int? itriKey, string qualityStatusCode, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit packagingUnit, bool filterOutFrozenItems, DbTool dbTool)
		{
			DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();
			strBuilder.Append("SELECT DISTINCT ");

			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME, ProductDataSet.Columns.PRODUCT_CODE.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.CustomItemDescr.NAME, ProductDataSet.Columns.PRODUCT_DESCRIPTION.Name);

			strBuilder.Append(", ");
			Produmex.Sbo.Logex.Data.SboCommands.AddBarcodeUsingPackagingUnit(strBuilder, packagingUnit, ProductDataSet.Columns.GTIN.Name);

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.HasBestBeforeDate.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ManBtchNum.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticUnit.NAME));

			strBuilder.Append(", ", strBuilder.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME));

			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(strBuilder.WITH_NOLOCK);
			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemPackagingTypeTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxItemPackagingTypeTable.NAME, PmxItemPackagingTypeTable.Columns.ItemCode.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME));


			//inner join Product - inventory
			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(" ON ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.Columns.ItemCode.NAME));

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));

			//left join for transaction info
			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
			strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
			strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME));


			string operand = " WHERE ";
			if (!string.IsNullOrEmpty(gtin))
			{
				strBuilder.Append(operand);
				Produmex.Sbo.Logex.Data.SboCommands.AddWhereClauseSearchForBarcode(strBuilder, gtin);
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(itemCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(qualityStatusCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(qualityStatusCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(sscc))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (forceSpecificSSCC)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";

			}

			if (itriKey.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itriKey.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}


			if (!string.IsNullOrEmpty(locationCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (luid.HasValue)
			{
				strBuilder.AppendFormat(" {0} {1}.{2}  = {3} ", operand, SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME), SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME), SqlCommandHelper.FormatAndEscapeColumnValue(luid.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (isLogisticCarrier.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));
				strBuilder.Append(" = ");
				if (isLogisticCarrier.Value)
				{
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));
				}
				else
				{
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));
				}
				operand = " AND ";
			}

			//strBuilder.Append(operand);
			//strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			//strBuilder.Append(".");
			//strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.InventoryItem.NAME));
			//strBuilder.Append(" = ");
			//strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

			if (filterOutFrozenItems)
			{
				Produmex.Sbo.Logex.Data.SboCommands.GetFrozenItemFilterSQLWherePart(strBuilder, " AND ");
			}

			strBuilder.Append(" ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.CustomItemDescr.NAME));
			return strBuilder.ToString();
		}
		/// <summary>
		/// Gets the name and the code of the  location, ordered by name.
		/// </summary>
		/// <param name="locationCode">The location code.</param>
		/// <param name="warehouseCode">The warehouse code.</param>
		/// <param name="getLockedLocations">if set to <c>true</c> [get locked locations].</param>
		/// <returns>The sql statement to get the location</returns>
		public static string GetStorageLocation(string locationCode, string warehouseCode, bool getLockedLocations)
		{
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT ");

			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.CODE.Name);

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.DESCRIPTION.Name);

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.WAREHOUSECODE.Name);


			strBuilder.Append(", ");
			SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);



			strBuilder.Append(" WHERE ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


			if (!string.IsNullOrEmpty(locationCode))
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
			}

			if (warehouseCode != null &&
				warehouseCode.Trim() != "")
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

			}

			if (!getLockedLocations)
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME));
				strBuilder.Append(" IS NULL ");

			}

			strBuilder.Append(" ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));


			return strBuilder.ToString();
		}

		/// <summary>
		/// Gets the name and the code of the  location linked to stock.
		/// </summary>
		/// <param name="locationCode">The location code.</param>
		/// <param name="warehouseCode">The warehouse code.</param>
		/// <param name="getLockedLocations">if set to <c>true</c> [get locked locations].</param>
		/// <returns>The sql statement to get the location</returns>
		public static string GetStorageLocationFromStock(string locationCode, string warehouseCode, bool getLockedLocations, string itemCode, int? luid)
		{
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT DISTINCT ");

			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.CODE.Name);

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.DESCRIPTION.Name);

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.WAREHOUSECODE.Name);


			strBuilder.Append(", ");
			SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);




			strBuilder.Append(" WHERE ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


			if (!string.IsNullOrEmpty(locationCode))
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
			}

			if (!string.IsNullOrEmpty(itemCode))
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
			}

			if (luid.HasValue)
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid.Value, CultureInfo.InvariantCulture));
			}

			if (warehouseCode != null &&
				warehouseCode.Trim() != "")
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

			}

			if (!getLockedLocations)
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME));
				strBuilder.Append(" IS NULL ");

			}

			strBuilder.Append(" ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));


			return strBuilder.ToString();
		}



		/// <summary>
		/// Gets the zone types for items.
		/// </summary>
		/// <param name="itemCodes">The item codes.</param>
		/// <returns></returns>
		public static string GetZoneTypesForItems(Collection<string> itemCodes)
		{
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT DISTINCT");

			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemZoneTypeTable.NAME, PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME, PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME);

			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemZoneTypeTable.NAME));


			string operand = "";
			strBuilder.Append(" WHERE ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemZoneTypeTable.NAME, PmxItemZoneTypeTable.Columns.ItemCode.NAME);
			strBuilder.Append(" IN ( ");

			foreach (string itemCode in itemCodes)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
				operand = ", ";
			}
			strBuilder.Append(") ");


			return strBuilder.ToString();
		}

		/// <summary>
		/// Gets the name and the code of the  location, ordered by name.
		/// </summary>
		/// <param name="locationCode">The location code.</param>
		/// <param name="warehouseCode">The warehouse code.</param>
		/// <param name="zoneTypeCodes">The zone type codes.</param>
		/// <param name="emptyLocations">if set to <c>true</c> [empty locations].</param>
		/// <returns>The sql statement to get the location</returns>
		public static string GetStorageLocationForZoneTypes(string locationCode, string warehouseCode, Collection<string> zoneTypeCodes, bool emptyLocations)
		{
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT ");

			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.CODE.Name);

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.DESCRIPTION.Name);

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
			strBuilder.Append(" AS ");
			strBuilder.Append(LocationDataSet.Columns.WAREHOUSECODE.Name);


			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);

			if (emptyLocations)
			{
				strBuilder.Append(" LEFT JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(" ON ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
				strBuilder.Append(" = ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

			}

			strBuilder.Append(" WHERE ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


			if (!string.IsNullOrEmpty(locationCode))
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
			}

			if (warehouseCode != null &&
				warehouseCode.Trim() != "")
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));

			}

			if (zoneTypeCodes != null &&
				zoneTypeCodes.Count > 0)
			{
				foreach (string zoneTypeCode in zoneTypeCodes)
				{
					strBuilder.Append(" AND ");
					strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
					strBuilder.Append(".");
					strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
					strBuilder.Append(" IN ( ");

					strBuilder.Append("SELECT ");

					strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
					strBuilder.Append(".");
					strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));


					strBuilder.Append(" FROM ");
					strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
					strBuilder.Append(" INNER JOIN ");
					strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
					strBuilder.Append(" ON ");
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
					strBuilder.Append(" = ");
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);
					strBuilder.Append(" RIGHT OUTER JOIN ");
					strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLinkZoneZoneTypeTable.NAME));
					strBuilder.Append(" ON ");
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME);
					strBuilder.Append(" = ");
					SqlCommandHelper.AddTableColumnName(strBuilder, PmxLinkZoneZoneTypeTable.NAME, PmxLinkZoneZoneTypeTable.Columns.ParentCode.NAME);


					strBuilder.Append(" WHERE ");


					strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxLinkZoneZoneTypeTable.NAME));
					strBuilder.Append(".");
					strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxLinkZoneZoneTypeTable.Columns.ZoneTypeCode.NAME));
					strBuilder.Append(" = ");
					strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(zoneTypeCode, CultureInfo.InvariantCulture));


					strBuilder.Append(") ");

				}
			}

			if (emptyLocations)
			{
				//If there is no link to the inventory, the location is empty
				strBuilder.Append(" AND ");
				SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
				strBuilder.Append(" IS NULL ");

			}

			strBuilder.Append(" ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));


			return strBuilder.ToString();
		}

		/// <summary>
		/// Command for getting all products order by name
		/// </summary>
		/// <param name="sscc">The SSCC.</param>
		/// <param name="itemCode">The item code.</param>
		/// <param name="batchNumber">The batch number.</param>
		/// <param name="bestBeforeDate">The best before date.</param>
		/// <param name="locationCode">The location code.</param>
		/// <param name="qualityStatusCode">The quality status code.</param>
		/// <param name="checkSpecificBatchBestBefore">if set to <c>true</c> [check specific batch best before].</param>
		/// <returns>
		/// Command for getting all products order by name
		/// </returns>
		public static string GetProductBatchLUIDFromStock(string sscc, string itemCode, string batchNumber, DateTime? bestBeforeDate, string locationCode, string qualityStatusCode, bool checkSpecificBatchBestBefore)
		{
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT ");

			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemName.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME);

			strBuilder.Append(", SUM( ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME);
			strBuilder.Append(" ) AS ");
			strBuilder.Append(PmxInventoryTotalTable.Columns.Quantity.NAME);


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(" ON ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.Columns.ItemCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.Columns.ItemCode.NAME));

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME);


			string operand = " WHERE ";

			if (!string.IsNullOrEmpty(sscc))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			//else if (checkSpecificBatchBestBefore)
			//{
			//    strBuilder.Append(operand);
			//    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
			//    strBuilder.Append(".");
			//    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
			//    strBuilder.Append(" IS NULL ");
			//    operand = " AND ";
			//}

			if (!string.IsNullOrEmpty(itemCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(batchNumber))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(batchNumber, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (checkSpecificBatchBestBefore)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";
			}

			if (bestBeforeDate.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(bestBeforeDate.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (checkSpecificBatchBestBefore)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(locationCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(qualityStatusCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(qualityStatusCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			strBuilder.Append(" GROUP BY ");

			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemName.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME);


			strBuilder.Append(" ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.ItemName.NAME));
			return strBuilder.ToString();
		}


		/// <summary>
		/// Gets the transactional packaging types.
		/// </summary>
		/// <param name="batchNumber">The batch number.</param>
		/// <param name="itemCode">The item code.</param>
		/// <returns></returns>
		public static string GetTransactionalPackagingTypes(string batchNumber, int? itriKey, string itemCode)
		{
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT ");

			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.ItemTransactionalInfoKey.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.PackagingTypeCode.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.Quantity.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(SboUomTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboUomTable.Columns.UomName.NAME));

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemPackagingTypeTable.Columns.Barcode.NAME));


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(" ON ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.ItemTransactionalInfoKey.NAME));

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemPackagingTypeTable.NAME));
			strBuilder.Append(" ON ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.PackagingTypeCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemPackagingTypeTable.Columns.PackagingTypeCode.NAME));

			strBuilder.Append(" AND ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemPackagingTypeTable.Columns.ItemCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.ItemCode.NAME));

			strBuilder.Append(" INNER JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(SboUomTable.NAME));

			strBuilder.Append(" ON ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.PackagingTypeCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(SboUomTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboUomTable.Columns.UomCode.NAME));



			strBuilder.Append(" WHERE ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.ItemCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));

			if (!string.IsNullOrEmpty(batchNumber))
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(batchNumber, CultureInfo.InvariantCulture));
			}

			if (itriKey.HasValue)
			{
				strBuilder.Append(" AND ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itriKey, CultureInfo.InvariantCulture));
			}

			strBuilder.Append(" AND ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));
			strBuilder.Append(" IN (SELECT  ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));

			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

			strBuilder.Append(" WHERE ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
			strBuilder.Append(" ) ");


			strBuilder.Append(" ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));
			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.Quantity.NAME));
			strBuilder.Append(" DESC ");


			return strBuilder.ToString();
		}

		/// <summary>
		/// Gets the SSCC from stock.
		/// </summary>
		/// <param name="sscc">The SSCC.</param>
		/// <param name="location">The location.</param>
		/// <param name="itemCode">The item code.</param>
		/// <param name="batchNumber">The batch number.</param>
		/// <param name="bestBeforeDate">The best before date.</param>
		/// <param name="qualityStatusCode">The quality status code.</param>
		/// <param name="checkSpecificBatchOrBBD">if set to <c>true</c> [check specific batch or BBD].</param>
		/// <param name="luid">The luid.</param>
		/// <param name="itriKey">The itri key.</param>
		/// <returns></returns>
		public static string GetSSCCFromStock(string sscc, string location, string itemCode, string batchNumber, DateTime? bestBeforeDate, string qualityStatusCode, bool checkSpecificBatchOrBBD, int? luid, int? itriKey)
		{
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT DISTINCT ");

			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.SSCC.NAME, SSCCDataSet.Columns.SSCC.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, SSCCDataSet.Columns.LUID.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME, SSCCDataSet.Columns.STORAGE_LOCATION_CODE.Name));

			strBuilder.AppendFormat(", {0}",
				SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, SSCCDataSet.Columns.PMX_WAREHOUSE_CODE.Name));

			strBuilder.AppendFormat(", {0}",
				SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, SSCCDataSet.Columns.PMX_WAREHOUSE_NAME.Name));

			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

			strBuilder.AppendFormat("\r\n INNER JOIN {0}",
			 SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
			strBuilder.AppendFormat(" ON {0} = {1}",
				SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
				SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));

			strBuilder.AppendFormat("\r\n INNER JOIN {0}",
				SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
			strBuilder.AppendFormat(" ON {0} = {1}",
				SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME),
				SqlCommandHelper.EscapeTableColumnName(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME));



			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME);



			string operand = " WHERE ";

			if (!string.IsNullOrEmpty(sscc))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (luid.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (itriKey.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itriKey.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(qualityStatusCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(qualityStatusCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}


			if (!string.IsNullOrEmpty(location))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(location, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(itemCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(batchNumber))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(batchNumber, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (checkSpecificBatchOrBBD)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";

			}

			if (bestBeforeDate.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(bestBeforeDate.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (checkSpecificBatchOrBBD)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";

			}






			return strBuilder.ToString();
		}

		/// <summary>
		/// Gets the batch numbers from stock.
		/// </summary>
		/// <param name="luid">The luid.</param>
		/// <param name="location">The location.</param>
		/// <param name="itemCode">The item code.</param>
		/// <param name="batchNumber">The batch number.</param>
		/// <param name="bestBeforeDate">The best before date.</param>
		/// <param name="qualityStatusCode">The quality status code.</param>
		/// <param name="checkSpecificBatchOrBBD">if set to <c>true</c> [check specific batch or BBD].</param>
		/// <param name="checkSpecificSSCC">if set to <c>true</c> [check specific SSCC].</param>
		/// <param name="itriKey">The itri key.</param>
		/// <returns></returns>
		public static string GetBatchNumbersFromStock(int? luid, string location, string itemCode, string batchNumber, DateTime? bestBeforeDate, string qualityStatusCode, bool checkSpecificBatchOrBBD, bool checkSpecificSSCC, int? itriKey)
		{
			StringBuilder strBuilder = new StringBuilder();
			strBuilder.Append("SELECT ");

			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, BatchNumberDataSet.Columns.BATCH_NUMBER.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME, BatchNumberDataSet.Columns.BATCH_NUMBER2.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, BatchNumberDataSet.Columns.BEST_BEFORE_DATE.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME, BatchNumberDataSet.Columns.QUALITY_STATUS_CODE.Name));
			strBuilder.Append(", ");
			strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME, BatchNumberDataSet.Columns.ITEMTRANSACTIONALINFOKEY.Name));
			strBuilder.Append(", SUM( ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME);
			strBuilder.Append(" ) AS ");
			strBuilder.Append(BatchNumberDataSet.Columns.QUANTITY.Name);


			strBuilder.Append(" FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

			strBuilder.Append(" LEFT JOIN ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
			strBuilder.Append(" ON ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);
			strBuilder.Append(" = ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME);



			string operand = " WHERE ";

			if (luid.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(luid.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (checkSpecificSSCC)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";
			}

			if (itriKey.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itriKey.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(qualityStatusCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.QualityStatusCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(qualityStatusCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}


			if (!string.IsNullOrEmpty(location))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(location, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(itemCode))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
				operand = " AND ";
			}

			if (!string.IsNullOrEmpty(batchNumber))
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(batchNumber, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (checkSpecificBatchOrBBD)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";

			}

			if (bestBeforeDate.HasValue)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
				strBuilder.Append(" = ");
				strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(bestBeforeDate.Value, CultureInfo.InvariantCulture));
				operand = " AND ";
			}
			else if (checkSpecificBatchOrBBD)
			{
				strBuilder.Append(operand);
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
				strBuilder.Append(".");
				strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
				strBuilder.Append(" IS NULL ");
				operand = " AND ";

			}



			strBuilder.Append(" GROUP BY ");

			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME);
			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME);

			return strBuilder.ToString();
		}

		public static string GetLogisticCarriersOrderByName(bool onlyInStock, bool filterOutFrozenItems, DbTool dbTool)
		{
			DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();

			strBuilder.Append("SELECT DISTINCT ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME, ProductDataSet.Columns.PRODUCT_CODE.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.CustomItemDescr.NAME, ProductDataSet.Columns.PRODUCT_DESCRIPTION.Name);

			strBuilder.Append(", ");
			SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.CodeBars.NAME, ProductDataSet.Columns.GTIN.Name);

			strBuilder.Append(", ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));

			strBuilder.Append("\r\n FROM ");
			strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(strBuilder.WITH_NOLOCK);

			if (onlyInStock)
			{
				strBuilder.Append("\r\n INNER JOIN ");
				strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
				strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME));
				strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME));
				strBuilder.Append(" AND ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
				strBuilder.Append(" IS NULL ");
			}

			strBuilder.Append("\r\n WHERE ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.InventoryItem.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

			strBuilder.Append(" AND ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));
			strBuilder.Append(" = ");
			strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

			if (filterOutFrozenItems)
			{
				Produmex.Sbo.Logex.Data.SboCommands.GetFrozenItemFilterSQLWherePart(strBuilder, " AND ");
			}

			strBuilder.Append("\r\n ORDER BY ");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
			strBuilder.Append(".");
			strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.CustomItemDescr.NAME));





			return strBuilder.ToString();
		}

	}

	#endregion

}

