﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.Generators.SerialNumberController;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Collections;
using Produmex.Sbo.Logex.WorkFlowSteps;

// PmxWorkflowExecutionTypes.SUB_FLOW
namespace WorkflowScript_MovePartialSSCCScript
{
    /// <summary>
    /// Sub-flow : Move partial SSCC or non SSCC items for KS Tools
    /// </summary>
    public class WorkflowScript_MovePartialSSCCKSToolsScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger( MethodInfo.GetCurrentMethod().DeclaringType );

        // Input parameters
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;

        public ReadOnlyBinder<string> SrcLocationCode;
        public ReadOnlyBinder<string> DstLocationCode;
        public ReadOnlyBinder<string> WarehouseTransferDestinationPmxWhsCode;

        // Private fields
        ISboProviderService m_sboProviderService;



        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_MovePartialSSCCKSToolsScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_MovePartialSSCCKSToolsScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base( parent, factory )
        {
        }

        /// <summary>
        /// Executes this instance.
        /// </summary>
        protected override void Execute()
        {
            // Scope parameters
            Session session = GetScopeParameter("Session") as Session;
            m_sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

            StepHelper stepHelper = new StepHelper
            {
                DefaultCultureInfo = this.DefaultCultureInfo,
                ShowCustomizedScreen = session.ShowCustomizedScreen,
                WaitForMessage = this.WaitForMessage,
                SboProviderService = m_sboProviderService,
                DeviceId = session.DeviceInstanceId
            };

            string initialErrorKey = null;
            Message msg;

            bool blockMoveWhenNotEmpty = false;

            string srcPmxWhsCode = null;
            string destinationPmxWhsCode = null;
            string defaultLocation = null;
            string whsCodeToUse = null;

            Collection<string> listOfSerialNumbers = null;
            bool askForSerialNumbers = false;
            bool forceSerial = false;
            bool useRange = false;

            int numberOfReports = 0;

            string warehouseTransferDestinationPmxWhsCode = null;

            if (WarehouseTransferDestinationPmxWhsCode != null &&
               !string.IsNullOrEmpty(WarehouseTransferDestinationPmxWhsCode.Get()))
            {
                warehouseTransferDestinationPmxWhsCode = WarehouseTransferDestinationPmxWhsCode.Get();
            }

            PmxOseWarehouseInfo whsInfo = null;

            PmxOseWarehouseInfo whsInfoDevice = m_sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), session.DeviceInstanceId);

            bool askReprint = false;

            string intermediateDestinationLocation = null;
            string intermediateDestinationPmxWhsCode = null;
            string buttonKeyIdentifyLocationScreen = null;
            string enteredDestinationLocationCode = null;
            DataSet dsZoneTypes = null;
            Collection<string> listOfZoneTypes = null;
            DataSet dsDestinationLocations = null;


            #region Scan Source location

        Step_ScanSrcLocation:

            intermediateDestinationLocation = null;

            string srcLocationCode = (this.SrcLocationCode == null) ? null : this.SrcLocationCode.Get();
            srcPmxWhsCode = null;
            if (!String.IsNullOrEmpty(srcLocationCode) && !String.IsNullOrEmpty(initialErrorKey))
            {
                // We got here with a pre-defined srcLocationCode and an error, show the error and exit
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    this.DefaultCultureInfo, BuildParamCollection(
                    "InitialErrorKey", null,
                    "MessageKey", initialErrorKey,
                    "ShowButton", true));
                WaitForMessage();

                // Exit flow
                return;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_TITLE_IDENTIFY_PICK_LOCATION",
                    "HideDefaultLocation", true,
                    "AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION"/*, "MSG_BUTTON_SELECT_EMPTY_LOCATION"*/ }));
            initialErrorKey = null;
            msg = WaitForMessage();

            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.LocationEntered")
            {
                srcLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");

                goto Step_GetSrcLocation;
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.ButtonClicked")
            {
                string buttonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");
                if (buttonKey == "MSG_BUTTON_SELECT_LOCATION") goto Step_GetSrcLocation;
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreenReply.BackRequested")
            {
                // Exit flow
                return;
            }

            goto Step_ScanSrcLocation;

            #endregion

            #region Check Location

        Step_GetSrcLocation:
            string query = BuildQuery.GetStorageLocation(srcLocationCode, whsInfoDevice.PmxWarehouseCode, session.DeviceInstanceId);
            DataSet ds = m_sboProviderService.RunView(true, null, null, query);
            if (ds.Tables[0].Rows.Count == 0)
            {
                initialErrorKey = "MSG_ERROR_NO_LOCATION_FOUND";
                goto Step_ScanSrcLocation;
            }
            if (ds.Tables[0].Rows.Count == 1)
            {
                srcLocationCode = Convert.ToString(ds.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name]);
                srcPmxWhsCode = Convert.ToString(ds.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name]);

                goto Step_VerifySrcLocation;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                this.DefaultCultureInfo, BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_SELECT_PICK_LOCATION",
                "LocationDS", ds));
            initialErrorKey = null;
            msg = WaitForMessage();

            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreenReply.LocationSelected")
            {
                srcLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");
                srcPmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");
                goto Step_VerifySrcLocation;
            }

            goto Step_ScanSrcLocation;

            #endregion

            #region VERIFY SRC LOCATION

        Step_VerifySrcLocation:
            if (this.PmxOseCompany.Get().LogisticCarriersStoredOnOneStorageLocation)
            {
                string logCarrierStorLocCode = m_sboProviderService.InvokeMethodWithDbConnection<string>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
                {
                    PmxOseWarehouseProvider prov = new PmxOseWarehouseProvider(conn);
                    return prov.GetStorageLocationForLogisticCarriersForLocation(srcLocationCode);
                });

                if (logCarrierStorLocCode == srcLocationCode)
                {
                    initialErrorKey = "MSG_ERROR_NO_PICKING_FROM_LOCATION_FOR_LOG_CARRIER";
                    goto Step_ScanSrcLocation;
                }
            }

            bool isLocked = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
            {
                PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
                return prov.IsLocationLocked(srcLocationCode);
            });

            if (isLocked)
            {
                initialErrorKey = "MSG_ERROR_PICK_LOCATION_LOCKED";
                goto Step_ScanSrcLocation;
            }

            whsInfo = m_sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), srcLocationCode);


            #endregion

            #region Ask SSCC

        Step_ScanSSCC:
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.Reception.IIdentifySSCCScreen),
                this.DefaultCultureInfo, BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_IDENTIFY_SSCC",
                "ButtonNoSSCC", true));
            initialErrorKey = null;
            msg = WaitForMessage();

            string srcSSCC;
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.Reception.IIdentifySSCCScreenReply.SSCCEntered")
            {
                srcSSCC = ExtractParameter<string>(msg.Parameters, "sscc");
                goto Step_SelectProductFromStock;
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.Reception.IIdentifySSCCScreenReply.NoSSCC")
            {
                srcSSCC = null;
                goto Step_SelectProductFromStock;
            }

            goto Step_ScanSSCC;

            #endregion

        Step_SelectProductFromStock:

            intermediateDestinationLocation = null;

            WorkflowInstanceBase subSelectProductFromStockFlow = this.Create("SelectProductFromStockFlow");
            SubBackRequested = false;
            subSelectProductFromStockFlow.BindParameters(
                this.DefaultCultureInfo,
                this.PmxOseCompany,
                new ReadOnlyBinder<string>("LocationCode", srcLocationCode),
                new ReadOnlyBinder<string>("NeededSSCC", srcSSCC),
                new ReadWriteBinder<PmxItemInfo>("ItemInfo", this, "SubItemInfo"),
                new ReadWriteBinder<string>("ItemCode", this, "SubItemCode"),
                new ReadWriteBinder<int?>("ItemTransactionalInfoKey", this, "SubItriKey"),
                new ReadWriteBinder<string>("BatchNumber", this, "SubBatchNumber"),
                new ReadWriteBinder<DateTime?>("BestBeforeDate", this, "SubBestBeforeDate"),
                new ReadWriteBinder<string>("QualityStatusCode", this, "SubQualityStatusCode"),
                new ReadWriteBinder<string>("SSCC", this, "SubSSCC"),
                new ReadWriteBinder<double>("Quantity", this, "SubMaximumQuantity"),
                new ReadWriteBinder<string>("ItemInventoryUom", this, "SubItemInventoryUom"),
                new ReadWriteBinder<bool>("BackRequested", this, "SubBackRequested"));

            base.StartSubFlowAndWait(subSelectProductFromStockFlow, true);


            if (SubBackRequested) goto Step_ScanSrcLocation;

            if (String.IsNullOrEmpty(SubItemCode))
            {
                initialErrorKey = "MSG_ERROR_NO_ITEM_CAN_BE_FOUND";
                goto Step_ScanSrcLocation;
            }

            #region Ask Item

        Step_EnterQuantity:



            forceSerial = false;
            useRange = false;
            listOfSerialNumbers = null;
            m_subFlowListOfSerialNumbers = null;

            if (SubItemInfo.HasSerialNumber)
            {
                string[] buttonKeys = new string[2] { "MSG_BUTTON_SERIAL_NUMBER", "MSG_BUTTON_SERIAL_NUMBER_RANGE" };

                askForSerialNumbers = false;
                if (!string.IsNullOrEmpty(warehouseTransferDestinationPmxWhsCode))
                {
                    //check if serial numbers need to be asked
                    askForSerialNumbers = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null,
                    delegate(PmxDbConnection conn, object[] parameters)
                    {
                        PmxSerialNumberProvider prov = new PmxSerialNumberProvider(conn);
                        return prov.MoveNeedsSerialNumbers(srcPmxWhsCode, WarehouseTransferDestinationPmxWhsCode.Get());
                    });
                }


                if (srcPmxWhsCode == warehouseTransferDestinationPmxWhsCode ||
                    string.IsNullOrEmpty(warehouseTransferDestinationPmxWhsCode))
                {
                    bool askForDestinationLocation = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null,
                        delegate(PmxDbConnection conn, object[] parameters)
                        {
                            PmxSerialNumberProvider prov = new PmxSerialNumberProvider(conn);
                            return prov.AskDestLocBeforeEnteringSerial();
                        });

                    if (askForDestinationLocation && string.IsNullOrEmpty(intermediateDestinationLocation))
                    {
                    //ask for destination location first

                    Step_EnterDestinationLocationSerial:

                        #region ENTER DESTINATION LOCATION SERIAL

                        buttonKeyIdentifyLocationScreen = null;

                        if (!string.IsNullOrEmpty(DstLocationCode))
                        {
                            enteredDestinationLocationCode = DstLocationCode;
                            goto Step_SelectDestinationLocationSerial;
                        }


                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "InitialErrorKey", initialErrorKey,
                            "TitleKey", "MSG_TITLE_DST_LOCATION_OR_SSCC",
                            "HideDefaultLocation", true,
                            "DefaultLocation", null,
                            "AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION", "MSG_BUTTON_SELECT_EMPTY_LOCATION" }));
                        msg = WaitForMessage();

                        if (msg.Name.EndsWith(".ButtonClicked"))
                        {
                            buttonKeyIdentifyLocationScreen = ExtractParameter<string>(msg.Parameters, "buttonKey");
                            goto Step_SelectDestinationLocationSerial;
                        }

                        if (msg.Name.EndsWith(".LocationEntered"))
                        {
                            enteredDestinationLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");

                            goto Step_SelectDestinationLocationSerial;
                        }

                        //go back is not allowed
                        goto Step_EnterDestinationLocationSerial;



                        #endregion

                    Step_SelectDestinationLocationSerial:

                        #region SELECT DESTINATION LOCATION SERIAL

                        destinationPmxWhsCode = null;

                        //get list of items/quantities
                        Dictionary<string, PmxStorageLocationCanItemBeStoredInfo> canItemBeStoredInfoPerItemCodeSerial = new Dictionary<string, PmxStorageLocationCanItemBeStoredInfo>();

                        PmxStorageLocationCanItemBeStoredInfo entry;
                        if (canItemBeStoredInfoPerItemCodeSerial.TryGetValue(SubItemInfo.ItemCode, out entry))
                        {
                            entry.Quantity += 0;
                        }
                        else
                        {
                            entry = new PmxStorageLocationCanItemBeStoredInfo(0, null, null);
                            canItemBeStoredInfoPerItemCodeSerial.Add(SubItemInfo.ItemCode, entry);
                        }
                        if (SubItriKey.HasValue)
                        {
                            if (entry.ItriKeys == null) entry.ItriKeys = new List<int>();
                            entry.ItriKeys.Add(SubItriKey.Value);
                        }


                        //get zonetypes
                        Collection<string> itemCodesSerial = new Collection<string>();
                        foreach (string itemCode in canItemBeStoredInfoPerItemCodeSerial.Keys)
                        {
                            itemCodesSerial.Add(itemCode);
                        }
                        query = BuildQuery.GetZoneTypesForItems(itemCodesSerial);
                        dsZoneTypes = m_sboProviderService.RunView(false, null, null, query);

                        listOfZoneTypes = new Collection<string>();
                        if (this.GetNumberOfRows(dsZoneTypes) > 0)
                        {
                            foreach (DataRow row2 in dsZoneTypes.Tables[0].Rows)
                            {
                                listOfZoneTypes.Add(row2[PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME] as string);
                            }
                        }

                        string whsCodeToUseSerial = warehouseTransferDestinationPmxWhsCode;

                        if (string.IsNullOrEmpty(whsCodeToUseSerial))
                        {
                            whsCodeToUseSerial = whsInfo.PmxWarehouseCode;
                        }

                        query = BuildQuery.GetStorageLocationForZoneTypes(enteredDestinationLocationCode, whsCodeToUseSerial, listOfZoneTypes,
                        buttonKeyIdentifyLocationScreen == "MSG_BUTTON_SELECT_EMPTY_LOCATION");

                        dsDestinationLocations = m_sboProviderService.RunView(false, null, null, query);

                        if (this.GetNumberOfRows(dsDestinationLocations) == 0)
                        {
                            // Inform the user with the error
                            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                                DefaultCultureInfo.Get(), BuildParamCollection(
                                    "MessageKey", "MSG_ERROR_NO_LOCATION_FOUND",
                                    "NoTranslationOfMessageKey", false,
                                    "ShowButton", true));
                            WaitForMessage();
                            if (!string.IsNullOrEmpty(DstLocationCode))
                            {
                                return;
                            }
                            else
                            {
                                goto Step_EnterDestinationLocationSerial;
                            }

                        }

                        //locations found
                        if (!string.IsNullOrEmpty(enteredDestinationLocationCode) &&
                            this.GetNumberOfRows(dsDestinationLocations) == 1)
                        {
                            intermediateDestinationLocation = Convert.ToString(dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name]);
                            intermediateDestinationPmxWhsCode = Convert.ToString(dsDestinationLocations.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name]);
                            goto Step_ProceedSerial;
                        }

                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                            "InitialErrorKey", initialErrorKey,
                            "TitleKey", "MSG_TITLE_SELECT_DESTINATION_LOCATION",
                            "LocationDS", dsDestinationLocations,
                            "ShowStopButton", false));

                        msg = WaitForMessage();
                        // Reset latest error
                        initialErrorKey = null;

                        if (msg.Name.EndsWith(".LocationSelected"))
                        {
                            intermediateDestinationLocation = ExtractParameter<string>(msg.Parameters, "locationCode");
                            intermediateDestinationPmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");

                            goto Step_ProceedSerial;
                        }


                        //go back
                        goto Step_EnterDestinationLocationSerial;


                        #endregion
                    }

                Step_ProceedSerial:


                    EnterSerialNumbers enterSerialNumber = m_sboProviderService.InvokeMethodWithDbConnection<EnterSerialNumbers>(false, false, null, null,
                        delegate(PmxDbConnection conn, object[] parameters)
                        {
                            PmxSerialNumberProvider prov = new PmxSerialNumberProvider(conn);
                            return prov.NeedToEnterSerialNumbers(srcPmxWhsCode, intermediateDestinationPmxWhsCode, srcLocationCode, intermediateDestinationLocation, new Collection<string>() { SubItemInfo.ItemCode });
                        });

                    if (enterSerialNumber == EnterSerialNumbers.MustEnter)
                    {
                        askForSerialNumbers = true;
                    }
                    if (enterSerialNumber == EnterSerialNumbers.CanEnter)
                    {
                        askForSerialNumbers = true;
                        buttonKeys = new string[3] { "MSG_BUTTON_SERIAL_NUMBER", "MSG_BUTTON_SERIAL_NUMBER_RANGE", "MSG_BUTTON_NO_SERIAL_NUMBER" };
                    }
                }





                if (askForSerialNumbers)
                {

                    forceSerial = true;
                    //show screen to ask user what to do.

                    ToolBarButtons toolBarButtons = ToolBarButtons.Back;

                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                            "InitialErrorKey", initialErrorKey,
                            "TitleKey", "MSG_TITLE_ENTER_QUANTITY_SERIAL_NUMBER_TASK",
                            "AllowedButtons", buttonKeys,
                            "EnabledToolBarButtons", toolBarButtons
                            ));
                    msg = WaitForMessage();
                    initialErrorKey = null;
                    if (msg.Name.EndsWith(".ButtonClicked"))
                    {
                        useRange = ExtractParameter<string>(msg.Parameters, "buttonKey") == "MSG_BUTTON_SERIAL_NUMBER_RANGE";

                        //no serial number 
                        forceSerial = ExtractParameter<string>(msg.Parameters, "buttonKey") != "MSG_BUTTON_NO_SERIAL_NUMBER";

                    }

                    if (msg.Name.EndsWith(".BackRequested"))
                    {
                        goto Step_ScanSrcLocation;
                    }
                }


            }



            WorkflowInstanceBase subEnterQuantityFlow = this.Create("EnterQuantityScript");
            SubBackRequested = false;
            subEnterQuantityFlow.BindParameters(
                this.DefaultCultureInfo,
                this.PmxOseCompany,
                new ReadOnlyBinder<string>("TitleKey", "MSG_TITLE_ENTER_QUANTITY"),
                new ReadOnlyBinder<PmxItemInfo>("ItemInfo", SubItemInfo),
                new ReadOnlyBinder<int?>("ItriKey", SubItriKey),
                new ReadOnlyBinder<string>("BatchNumber", SubBatchNumber),
                new ReadOnlyBinder<DateTime?>("BestBeforeDate", SubBestBeforeDate),
                new ReadOnlyBinder<string>("SSCC", SubSSCC),

                new ReadOnlyBinder<bool>("AllowZero", false),
                new ReadOnlyBinder<double>("InitialQuantity", 0.0),
                new ReadOnlyBinder<double>("MaximumQuantity", SubMaximumQuantity),
                new ReadOnlyBinder<string>("UOM", SubItemInventoryUom),
                new ReadOnlyBinder<int>("NumberOfDigitsAfterDecimal", (SubItemInfo == null) ? 0 : SubItemInfo.UomDecimals),
                new ReadOnlyBinder<double>("InnerQuantity", 0.0),
                new ReadOnlyBinder<string>("InnerUOM", null),

                new ReadOnlyBinder<string>("DocNum", null),
                new ReadOnlyBinder<double>("StillToQuantity", SubMaximumQuantity),
                new ReadOnlyBinder<string>("MessageKeyStillQuantity", "MSG_LBL_MAXIMUM_QUANTITY"),

                new ReadOnlyBinder<bool>("ForceInputSerialNumbers", forceSerial),
                new ReadOnlyBinder<string>("ObjectType", Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxMove),
                new ReadOnlyBinder<int?>("DocEntry", null),
                new ReadOnlyBinder<bool>("UseSerialNumberRange", useRange),
                new ReadOnlyBinder<string>("LocationCode", srcLocationCode),
                new ReadOnlyBinder<string>("DestinationLocationCode", intermediateDestinationLocation),

                new ReadWriteBinder<bool>("BackRequested", this, "SubBackRequested"),
                new ReadWriteBinder<double>("QuantityEntered", this, "SubQuantity"),
                new ReadWriteBinder<Collection<string>>("ListOfSerialNumbers", this, "m_subFlowListOfSerialNumbers")
                );

            base.StartSubFlowAndWait(subEnterQuantityFlow, true);


            if (SubBackRequested) goto Step_ScanSrcLocation;

        Step_GetItemsFromStock:
            query = BuildQuery.GetProductBatchLUIDFromStock(SubSSCC, SubItemCode, SubBatchNumber, SubBestBeforeDate, srcLocationCode, SubQualityStatusCode, true);
            ds = m_sboProviderService.RunView(true, null, null, query);

            listOfSerialNumbers = m_subFlowListOfSerialNumbers;

            // Build list with MoveItemInfo's up to request quantity to move
            List<MoveItemInfo> moveItemInfoList = new List<MoveItemInfo>();
            double quantityToMove = SubQuantity;
            foreach (DataRow row in ds.Tables[0].Rows)
            {
                MoveItemInfo itemInfo = new MoveItemInfo();
                itemInfo.ItemCode = Convert.ToString(row[PmxItemTable.Columns.ItemCode.NAME]);
                itemInfo.ItemDescription = Convert.ToString(row[PmxItemTable.Columns.ItemName.NAME]);
                itemInfo.ItemTransactionalInfoKey = Convertor.ConvertToInt32Nullable(row[PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME]);
                itemInfo.SourceQualityStatusCode = Convert.ToString(row[PmxInventoryTotalTable.Columns.QualityStatusCode.NAME]);
                itemInfo.DestinationQualityStatusCode = itemInfo.SourceQualityStatusCode;
                itemInfo.SourceLocationCode = Convert.ToString(row[PmxInventoryTotalTable.Columns.StorLocCode.NAME]);

                itemInfo.SourcePmxWhsCode = srcPmxWhsCode;

                itemInfo.SourceLogisticUnitIdentKey = Convertor.ConvertToInt32Nullable(row[PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME]);
                itemInfo.Uom = Convert.ToString(row[PmxItemTable.Columns.InventoryUom.NAME]);
                itemInfo.QuantityPerUom = 1;
                itemInfo.Quantity = Math.Min(Convert.ToDouble(row[PmxInventoryTotalTable.Columns.Quantity.NAME]), quantityToMove);

                moveItemInfoList.Add(itemInfo);

                if (listOfSerialNumbers != null &&
                    listOfSerialNumbers.Count > 0)
                {

                    Collection<string> tempListOfSerialNumbers = new Collection<string>();

                    for (int iLoop = 0; iLoop < itemInfo.Quantity; iLoop++)
                    {
                        //add to temp list
                        tempListOfSerialNumbers.Add(listOfSerialNumbers[iLoop]);
                    }

                    itemInfo.ListOfSerialNumbers = tempListOfSerialNumbers;

                    foreach (string serialNumber in tempListOfSerialNumbers)
                    {
                        //remove from main list
                        listOfSerialNumbers.Remove(serialNumber);
                    }

                }




                //reduce the quantity to move
                quantityToMove -= itemInfo.Quantity;

                //no more quantity to move, so we break
                if (quantityToMove <= 0) break;
            }

        Step_ScanDestination:
            bool newSSCC = false;
            bool emptyLocations = false;
            int? dstLuid = null;
            string targetLogCarrierCode = null;
            destinationPmxWhsCode = null;
            blockMoveWhenNotEmpty = false;

            whsCodeToUse = warehouseTransferDestinationPmxWhsCode;

            if (string.IsNullOrEmpty(whsCodeToUse)) {
                whsCodeToUse = whsInfo.PmxWarehouseCode;
            }

            Step_ScanDestinationAgain:
            string dstLocationCode = (this.DstLocationCode == null) ? null : this.DstLocationCode.Get();
            if (!String.IsNullOrEmpty(dstLocationCode) && !String.IsNullOrEmpty(initialErrorKey))
            {
                // We got here with a pre-defined DstLocationCode and an error, show the error and exit
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    this.DefaultCultureInfo, BuildParamCollection(
                    "InitialErrorKey", null,
                    "MessageKey", initialErrorKey,
                    "ShowButton", true));
                WaitForMessage();

                // Exit flow
                return;
            }

            defaultLocation = "N/A";

         

            if (SubItemInfo != null) {
                string locationCode;

                if (SubItemInfo.DefaultWarehouseLocationOrZone.TryGetValue(whsCodeToUse, out locationCode)) {
                    defaultLocation = locationCode;
                }
                //else if (!String.IsNullOrEmpty(SubItemInfo.DefaultStorageLocationOrZoneCode))
                //{
                //	defaultLocation = SubItemInfo.DefaultStorageLocationOrZoneCode;
                //}
            }

            string[] buttons = null;

          
            if (!newSSCC)
            {
                goto Step_NewSSCCClicked;
            }

            if (newSSCC)
            {
                buttons = new string[] { "MSG_BUTTON_SELECT_LOCATION", "MSG_BUTTON_SELECT_EMPTY_LOCATION" };
            }
            else
            {
                buttons = new string[] { "MSG_BUTTON_SELECT_LOCATION", "MSG_BUTTON_SELECT_EMPTY_LOCATION", "MSG_BUTTON_NEW_SSCC" };
            }

            session.ShowScreen(typeof(IScanStringValueScreen),
                this.DefaultCultureInfo, BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    //"TitleKey", newSSCC ? "MSG_TITLE_DST_LOCATION_OR_SSCC" : "MSG_TITLE_SCAN_DESTINATION_LOCATION",
                    "TitleKey", "MSG_TITLE_DST_LOCATION_OR_SSCC",
                    "ForceDataEntry", true,
                    "AllowedButtonKeys", buttons,
                    "AllowToGoBack", true,
                    "Information", "MSG_LABEL_DEFAULT_LOCATION",
                    "MessageAddendum", defaultLocation

                    ));
            initialErrorKey = null;
            msg = WaitForMessage();

            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.IScanStringValueScreenReply.StringScanned")
            {
                BarcodeContainer barcode = new BarcodeContainer();
                ProdumexError pmxError = null;
                try
                {
                    pmxError = BarcodeHelper.ParseElementString(ExtractParameter<string>(msg.Parameters, "stringValue"), true, barcode);
                }
                catch
                {
                    // Do nothing
                }
                if (!String.IsNullOrEmpty(barcode.GS1DataObject.Sscc))
                {
                    query = BuildQuery.GetSSCCInfo(barcode.GS1DataObject.Sscc);
                    ds = m_sboProviderService.RunView(true, null, null, query);
                    if (GetRowCount(ds) > 0)
                    {
                        newSSCC = false;

                        dstLuid = Convert.ToInt32(ds.Tables[0].Rows[0][SSCCDataSet.Columns.LUID.Name]);
                        dstLocationCode = Convert.ToString(ds.Tables[0].Rows[0][SSCCDataSet.Columns.STORAGE_LOCATION_CODE.Name]);
                        destinationPmxWhsCode = Convert.ToString(ds.Tables[0].Rows[0][SSCCDataSet.Columns.PMX_WAREHOUSE_CODE.Name]);
                    }
                    if (String.IsNullOrEmpty(dstLocationCode))
                    {
                        initialErrorKey = "MSG_ERROR_INCORRECT_SSCC";
                        goto Step_ScanDestination;
                    }
                    else if (!string.IsNullOrEmpty(intermediateDestinationLocation) &&
                        intermediateDestinationLocation != dstLocationCode)
                    {
                        initialErrorKey = "MSG_ERROR_INCORRECT_LOCATION";
                        goto Step_ScanDestination;
                    }

                    goto Step_GetDstLocation;
                }
                else
                {
                    dstLocationCode = ExtractParameter<string>(msg.Parameters, "stringValue");

                    if (!string.IsNullOrEmpty(intermediateDestinationLocation) &&
                        intermediateDestinationLocation != dstLocationCode)
                    {
                        initialErrorKey = "MSG_ERROR_INCORRECT_LOCATION";
                        goto Step_ScanDestination;
                    }

                    goto Step_GetDstLocation;
                }
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.IScanStringValueScreenReply.ButtonClicked")
            {
                string buttonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");
                if (buttonKey == "MSG_BUTTON_SELECT_LOCATION")
                {
                    goto Step_GetDstLocation;
                }
                if (buttonKey == "MSG_BUTTON_SELECT_EMPTY_LOCATION")
                {
                    emptyLocations = true;
                    goto Step_GetDstLocation;
                }
                if (buttonKey == "MSG_BUTTON_NEW_SSCC")
                {

                    goto Step_NewSSCCClicked;
                }
            }
            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.IScanStringValueScreenReply.BackRequested")
            {
                goto Step_ScanSrcLocation;
            }

            goto Step_ScanDestinationAgain;

            #endregion

        Step_NewSSCCClicked:

            #region Step_IdentifyLogisticCarrier

            query = BuildQuery.GetLogisticCarriersOrderByName(true, true, m_sboProviderService.GetDbTool());
            DataSet dsLogisticCarriers = m_sboProviderService.RunView(false, null, null, query);
            if (GetRowCount(dsLogisticCarriers) > 0)
            {
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreen),
                    this.DefaultCultureInfo, BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_TITLE_SELECT_LOGISTIC_CARRIER",
                    "ProductDS", dsLogisticCarriers,
                    "AllowNoSelection", false,
                    "ButtonKey", "MSG_BUTTON_NO_LOGISTIC_CARRIER"));
                msg = WaitForMessage();
                initialErrorKey = null;

                if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreenReply.ProductSelected")
                {
                    targetLogCarrierCode = ExtractParameter<string>(msg.Parameters, "itemCode");
                }
                else if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreenReply.ButtonClicked")
                {
                    targetLogCarrierCode = "";  // Remember we chose MSG_BUTTON_NO_LOGISTIC_CARRIER
                }
                else if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreenReply.BackRequested")
                {
                    //go further back, because we came here automatic
                    goto Step_ScanSrcLocation;
                    //goto Step_ScanDestination;
                }
                else if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreenReply.StopRequested")
                {
                    return;
                }
                else
                {
                    initialErrorKey = KnownMessageKeys.MSG_ERROR_OPERATION_NOT_SUPPORTED;
                    goto Step_ScanDestination;
                }
            }

            #endregion

            newSSCC = true;
            goto Step_ScanDestinationAgain;




        Step_GetDstLocation:

            query = BuildQuery.GetZoneTypesForItem(SubItemCode);
            ds = m_sboProviderService.RunView(true, null, null, query);
            List<string> zoneTypeCodes = null;
            if (GetRowCount(ds) > 0)
            {
                zoneTypeCodes = new List<string>(GetRowCount(ds));
                foreach (DataRow row in ds.Tables[0].Rows)
                {
                    zoneTypeCodes.Add(Convert.ToString(row[PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME]));
                }
            }

             whsCodeToUse = warehouseTransferDestinationPmxWhsCode;

            if (string.IsNullOrEmpty(whsCodeToUse))
            {
                whsCodeToUse = whsInfo.PmxWarehouseCode;
            }


            query = BuildQuery.GetStorageLocationForZoneTypes(dstLocationCode, whsCodeToUse, zoneTypeCodes, emptyLocations);
            ds = m_sboProviderService.RunView(true, null, null, query);
            if (GetRowCount(ds) == 0)
            {
                initialErrorKey = "MSG_ERROR_NO_LOCATION_FOUND";
                goto Step_ScanDestination;
            }
            if (GetRowCount(ds) == 1)
            {
                //set locationcode from DB to avoid problems with uppercase/lowercase
                dstLocationCode = Convert.ToString(ds.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name]);
                destinationPmxWhsCode = Convert.ToString(ds.Tables[0].Rows[0][LocationDataSet.Columns.WAREHOUSECODE.Name]);
                blockMoveWhenNotEmpty = Convert.ToString(ds.Tables[0].Rows[0][PmxOseStorageLocationGeneralTable.Columns.BlockMoveWhenNotEmpty.NAME]) == SboBooleanColumnValues.Y.VALUE;

                goto Step_VerifyDestination;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                this.DefaultCultureInfo, BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_TITLE_SELECT_DESTINATION_LOCATION",
                "LocationDS", ds));
            initialErrorKey = null;
            msg = WaitForMessage();

            if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreenReply.LocationSelected")
            {
                dstLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");
                destinationPmxWhsCode = ExtractParameter<string>(msg.Parameters, "warehouseCode");
                DataRow[] rows = ds.Tables[0].Select(string.Format("{0} = '{1}'", LocationDataSet.Columns.CODE.Name, dstLocationCode));

                if (rows.Length > 0)
                {
                    blockMoveWhenNotEmpty = Convert.ToString(rows[0][PmxOseStorageLocationGeneralTable.Columns.BlockMoveWhenNotEmpty.NAME]) == SboBooleanColumnValues.Y.VALUE;
                }
                goto Step_VerifyDestination;
            }

            goto Step_ScanDestination;

        Step_VerifyDestination:

            if (!string.IsNullOrEmpty(intermediateDestinationLocation) &&
                        intermediateDestinationLocation != dstLocationCode)
            {
                initialErrorKey = "MSG_ERROR_INCORRECT_LOCATION";
                goto Step_ScanDestination;
            }

            isLocked = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
            {
                PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
                return prov.IsLocationLocked(dstLocationCode);
            });

            if (isLocked)
            {
                initialErrorKey = "MSG_ERROR_DESTINATION_LOCATION_LOCKED";
                goto Step_ScanDestination;
            }

            if (blockMoveWhenNotEmpty)
            {
                bool locationEmpty = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
                {
                    PmxInventoryProvider prov = new PmxInventoryProvider(conn);
                    double? dummy;
                    double tempQty = prov.GetCurrentQuantityForLocation(dstLocationCode, out dummy);

                    return tempQty == 0;
                });

                if (!locationEmpty)
                {
                    initialErrorKey = "MSG_ERROR_ITEMS_CANNOT_BE_STORED_ON_LOCATION_NOT_EMPTY";
                    goto Step_ScanDestination;
                }
            }

            PmxStorageLocationCanItemBeStoredInfo canItemBeStoredInfo = new PmxStorageLocationCanItemBeStoredInfo(SubQuantity, null, null);
            if (SubItriKey.HasValue)
            {
                canItemBeStoredInfo.ItriKeys = new List<int>(1);
                canItemBeStoredInfo.ItriKeys.Add(SubItriKey.Value);
            }
            bool canBeStored = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
            {
                PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
                return prov.CanItemBeStoredOnStorageLocation(dstLocationCode, SubItemCode, canItemBeStoredInfo);
            });
            if (!canBeStored)
            {
                initialErrorKey = "MSG_ERROR_ITEMS_CANNOT_BE_STORED_ON_LOCATION";
                goto Step_ScanDestination;
            }
            if (canItemBeStoredInfo.Status != PmxStorageLocationCanItemBeStored.Yes)
            {
                // Warn user and ask to continue
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_CONFIRM_MOVE",
                        "MessageKey", "MSG_CONFIRM_ADDING_DIFFERENT_ITEM_OR_BATCH"));
                msg = WaitForMessage();

                if (!msg.Name.EndsWith("IDecisionScreenReply.Yes"))
                {
                    goto Step_ScanDestination;
                }
            }

            // Execute MOVE
            bool useSboConnection = destinationPmxWhsCode != srcPmxWhsCode;
            bool removeLogCarrierFromList = false;

            Collection<DocumentRef> list = null;


            try
            {
                list = m_sboProviderService.InvokeMethodWithDbConnection<Collection<DocumentRef>>(useSboConnection, false, null, null, delegate(PmxDbConnection conn, object[] parameters)
                {
                    if (newSSCC)
                    {
                        PmxLogisticUnitIDProvider luidProv = new PmxLogisticUnitIDProvider(conn);
                        dstLuid = luidProv.GenerateNewLogisticUnit(null);

                        // Also move log.carrier
                        if (!String.IsNullOrEmpty(targetLogCarrierCode))
                        {
                            PmxInventoryProvider invProv = new PmxInventoryProvider(conn);
                            moveItemInfoList.Add(invProv.GetMoveItemInfoForFreeLogisticCarrier(dstLocationCode, targetLogCarrierCode));

                            removeLogCarrierFromList = true;
                        }
                    }

                    foreach (MoveItemInfo itemInfo in moveItemInfoList)
                    {
                        itemInfo.DestinationLocationCode = dstLocationCode;
                        itemInfo.DestinationLogisticUnitIdentKey = dstLuid;

                        itemInfo.DestinationPmxWhsCode = destinationPmxWhsCode;
                    }

                    PmxMoveProvider moveProv = new PmxMoveProvider(conn);
                    return moveProv.MakeAdHocMove(moveItemInfoList, null, dstLocationCode);
                });
            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
                if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ex.Message,
                            "NoTranslationOfMessageKey", true,
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();
                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();
                }

                //retry?
                //ask user if he wants to retry
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_RETRY_UPDATE",
                        "MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_WANT_RETRY"));
                msg = WaitForMessage();

                if (msg.Name.ToLower().EndsWith(".yes"))
                {
                    if (removeLogCarrierFromList)
                    {
                        // In case transaction fails we again have the original list
                        moveItemInfoList.RemoveAt(moveItemInfoList.Count - 1);
                    }

                    goto Step_VerifyDestination;
                }

                return;
            }

            // Print LABEL
            if (newSSCC)
            {
                bool proceed = false;
                while (!proceed)
                {
                    numberOfReports = 0;

                    try
                    {
                        //trigger event
                        numberOfReports += m_sboProviderService.InvokeMethodWithDbConnection<int>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
                        {
                            PmxPrintReportProvider printProv = new PmxPrintReportProvider(conn);
                            return printProv.PrintReportsForEvent(PmxPrintReportEventType.WarehouseCreatedLogisticUnit, dstLocationCode, session.DeviceInstanceId, dstLuid.Value, out askReprint, stepHelper.GetPrinterFromSelectPrinterScreen);
                        });
                    }
                    catch (Produmex.Foundation.ProdumexException ex)
                    {
                        s_log.Error(ex.ToString());
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                                "MessageAddendum", ex.Message,
                                "PmxError", ex.Error,
                                "ShowButton", true));

                        msg = WaitForMessage();
                    }
                    catch (Exception ex)
                    {
                        s_log.Error(ex.ToString());
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                                "MessageAddendum", ex.Message,
                                "PmxError", Produmex.Sbo.Logex.Data.ProdumexErrors.UnexpectedError(s_log, ex),
                                "ShowButton", true));

                        msg = WaitForMessage();
                    }

                    if (numberOfReports > 0 && askReprint)
                    {
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "MessageKey", "MSG_QUESTION_REPRINT_LABEL",
                                "TitleKey", "MSG_TITLE_REPRINT_LABEL"
                                ));

                        msg = WaitForMessage();

                        if (msg.Name.EndsWith(".No"))
                        {
                            proceed = true;
                        }

                    }
                    else
                    {
                        proceed = true;
                    }

                }


            }


            // Print move document
            if (!string.IsNullOrEmpty(warehouseTransferDestinationPmxWhsCode))
            {
                bool proceed = false;
                while (!proceed)
                {
                    numberOfReports = 0;

                    try
                    {

                        foreach (DocumentRef docRef in list)
                        {

                            //trigger event
                            numberOfReports += m_sboProviderService.InvokeMethodWithDbConnection<int>(false, true, null, null, delegate(PmxDbConnection conn, object[] parameters)
                            {
                                PmxDictionary<string, object> paramList = new PmxDictionary<string, object>();

                                if (docRef.DocType == ((int)SboObjectType.StockTransfer).ToString())
                                {
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.StockTransferDocEntry.NAME, docRef.DocEntry);
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.MoveDocentry.NAME, (int?)null);
                                }
                                else
                                {
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.StockTransferDocEntry.NAME, (int?)null);
                                    paramList.Add(Produmex.Sbo.Logex.Data.Reports.Definitions.ReportTypeWarehouseMoveDefinition.Parameters.MoveDocentry.NAME, docRef.DocEntry);
                                }

                                PmxPrintReportProvider printProv = new PmxPrintReportProvider(conn);
                                return printProv.PrintReportsForEventWithParameters(PmxPrintReportEventType.WarehouseMoveAdded, null, session.DeviceInstanceId, paramList, false, out askReprint, stepHelper.GetPrinterFromSelectPrinterScreen);
                            });
                        }//foreach
                    }
                    catch (Produmex.Foundation.ProdumexException ex)
                    {
                        s_log.Error(ex.ToString());
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                                "MessageAddendum", ex.Message,
                                "PmxError", ex.Error,
                                "ShowButton", true));

                        msg = WaitForMessage();
                    }
                    catch (Exception ex)
                    {
                        s_log.Error(ex.ToString());
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                                "MessageAddendum", ex.Message,
                                "PmxError", Produmex.Sbo.Logex.Data.ProdumexErrors.UnexpectedError(s_log, ex),
                                "ShowButton", true));

                        msg = WaitForMessage();
                    }

                    if (numberOfReports > 0 && askReprint)
                    {
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "MessageKey", "MSG_QUESTION_REPRINT_DOCUMENT",
                                "TitleKey", "MSG_TITLE_REPRINT_DOCUMENT"
                                ));

                        msg = WaitForMessage();

                        if (msg.Name.EndsWith(".No"))
                        {
                            proceed = true;
                        }

                    }
                    else
                    {
                        proceed = true;
                    }

                }


            }





            // Show message and exit
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                this.DefaultCultureInfo, BuildParamCollection(
                "InitialErrorKey", null,
                "MessageKey", "MSG_ITEMS_MOVED",
                "ShowButton", true));
            WaitForMessage();

            // Return to start of flow
            if ((this.SrcLocationCode == null || String.IsNullOrEmpty(this.SrcLocationCode.Get())
                || this.DstLocationCode == null || String.IsNullOrEmpty(this.DstLocationCode.Get())) &&
                string.IsNullOrEmpty(warehouseTransferDestinationPmxWhsCode))
            {
                goto Step_ScanSrcLocation;
            }

            // End of flow
        }

        // Sub control
        protected bool SubBackRequested;

        // Sub values
        protected PmxItemInfo SubItemInfo;
        protected string SubItemCode;
        protected int? SubItriKey;
        protected string SubBatchNumber;
        protected DateTime? SubBestBeforeDate;
        protected string SubQualityStatusCode;
        protected string SubSSCC;
        protected double SubMaximumQuantity;
        protected double SubQuantity;
        protected string SubItemInventoryUom;
        protected Collection<string> m_subFlowListOfSerialNumbers;

        private static int GetRowCount( DataSet ds )
        {
            if ( ds != null && ds.Tables.Count > 0 )
            {
                return ds.Tables[ 0 ].Rows.Count;
            }
            return 0;
        }


        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }
            return 0;
        }

        private class BuildQuery
        {


            /// <summary>
            /// Gets the zone types for items.
            /// </summary>
            /// <param name="itemCodes">The item codes.</param>
            /// <returns></returns>
            public static string GetZoneTypesForItems(Collection<string> itemCodes)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append("SELECT DISTINCT");

                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxItemZoneTypeTable.NAME, PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME, PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME);

                strBuilder.Append(" FROM ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemZoneTypeTable.NAME));


                string operand = "";
                strBuilder.Append(" WHERE ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxItemZoneTypeTable.NAME, PmxItemZoneTypeTable.Columns.ItemCode.NAME);
                strBuilder.Append(" IN ( ");

                foreach (string itemCode in itemCodes)
                {
                    strBuilder.Append(operand);
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
                    operand = ", ";
                }
                strBuilder.Append(") ");


                return strBuilder.ToString();
            }

            /// <summary>
            /// Gets the name and the code of the  location, ordered by name.
            /// </summary>
            /// <param name="locationCode">The location code.</param>
            /// <param name="pmxWarehouseCode">The PMX warehouse code.</param>
            /// <param name="deviceID">The device ID.</param>
            /// <returns>The sql statement to get the location</returns>
            public static string GetStorageLocation(string locationCode, string pmxWarehouseCode, string deviceID)
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append( "SELECT " );

                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Code.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( LocationDataSet.Columns.CODE.Name );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Name.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( LocationDataSet.Columns.DESCRIPTION.Name );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( LocationDataSet.Columns.WAREHOUSECODE.Name );

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);


                strBuilder.Append( " FROM " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( " INNER JOIN " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxOseGeneralTable.NAME ) );
                strBuilder.Append( " ON " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME );
                strBuilder.Append( " = " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME );


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);



                strBuilder.Append( " WHERE " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME ) );
                strBuilder.Append( " = " );
                strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture ) );


                if ( !string.IsNullOrEmpty( locationCode ) )
                {
                    strBuilder.Append( " AND " );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Code.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( locationCode, CultureInfo.InvariantCulture ) );
                }



                if (!String.IsNullOrEmpty(pmxWarehouseCode) || !String.IsNullOrEmpty(deviceID))
                {
                    strBuilder.Append(" AND ( ");
                    if (!String.IsNullOrEmpty(pmxWarehouseCode))
                    {
                        SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                        strBuilder.Append(" = ");
                        strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(pmxWarehouseCode, CultureInfo.InvariantCulture));
                    }
                    if (!String.IsNullOrEmpty(deviceID))
                    {
                        if (!String.IsNullOrEmpty(pmxWarehouseCode)) strBuilder.Append(" OR ");

                        strBuilder.AppendFormat("{0} IN ( SELECT {1} FROM {2} WHERE {3} = {4} )",
                            SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME),
                            SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.PmxWarehouseCode.NAME),
                            SqlCommandHelper.EscapeTableName(PmxThinClientWarehouseTable.NAME),
                            SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.ParentCode.NAME),
                            SqlCommandHelper.FormatAndEscapeColumnValue(deviceID, CultureInfo.InvariantCulture));
                    }
                    strBuilder.Append(" )");
                }


                strBuilder.Append( " ORDER BY " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Name.NAME ) );


                return strBuilder.ToString();
            }


            /// <summary>
            /// Command for getting all products order by name
            /// </summary>
            /// <param name="sscc">The SSCC.</param>
            /// <param name="itemCode">The item code.</param>
            /// <param name="batchNumber">The batch number.</param>
            /// <param name="bestBeforeDate">The best before date.</param>
            /// <param name="locationCode">The location code.</param>
            /// <param name="qualityStatusCode">The quality status code.</param>
            /// <param name="checkSpecificBatchBestBefore">if set to <c>true</c> [check specific batch best before].</param>
            /// <returns>
            /// Command for getting all products order by name
            /// </returns>
            public static string GetProductBatchLUIDFromStock( string sscc, string itemCode, string batchNumber, DateTime? bestBeforeDate, string locationCode, string qualityStatusCode, bool checkSpecificBatchBestBefore )
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append( "SELECT " );

                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.Columns.ItemCode.NAME ) );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.ItemName.NAME ) );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.Columns.StorLocCode.NAME ) );

                strBuilder.Append( ", " );
                strBuilder.Append( SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull( PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME ) );

                strBuilder.Append( ", " );
                strBuilder.Append( SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull( PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME ) );

                strBuilder.Append( ", " );
                strBuilder.Append( SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME ) );

                strBuilder.Append( ", " );
                strBuilder.Append( SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME ) );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.Columns.QualityStatusCode.NAME ) );

                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME );

                strBuilder.Append( ", SUM( " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME );
                strBuilder.Append( " ) AS " );
                strBuilder.Append( PmxInventoryTotalTable.Columns.Quantity.NAME );


                strBuilder.Append( " FROM " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxInventoryTotalTable.NAME ) );

                strBuilder.Append( " INNER JOIN " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( " ON " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxItemTable.Columns.ItemCode.NAME ) );
                strBuilder.Append( " = " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxInventoryTotalTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxInventoryTotalTable.Columns.ItemCode.NAME ) );

                strBuilder.Append( " LEFT JOIN " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxItemTransactionalInfoTable.NAME ) );
                strBuilder.Append( " ON " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME );
                strBuilder.Append( " = " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME );


                string operand = " WHERE ";

                if ( !string.IsNullOrEmpty( sscc ) )
                {
                    strBuilder.Append( operand );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.Columns.SSCC.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( sscc, CultureInfo.InvariantCulture ) );
                    operand = " AND ";
                }
                //else if (checkSpecificBatchBestBefore)
                //{
                //    strBuilder.Append(operand);
                //    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                //    strBuilder.Append(".");
                //    strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
                //    strBuilder.Append(" IS NULL ");
                //    operand = " AND ";
                //}

                if ( !string.IsNullOrEmpty( itemCode ) )
                {
                    strBuilder.Append( operand );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.Columns.ItemCode.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( itemCode, CultureInfo.InvariantCulture ) );
                    operand = " AND ";
                }

                if ( !string.IsNullOrEmpty( batchNumber ) )
                {
                    strBuilder.Append( operand );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTransactionalInfoTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( batchNumber, CultureInfo.InvariantCulture ) );
                    operand = " AND ";
                }
                else if ( checkSpecificBatchBestBefore )
                {
                    strBuilder.Append( operand );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTransactionalInfoTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME ) );
                    strBuilder.Append( " IS NULL " );
                    operand = " AND ";
                }

                if ( bestBeforeDate.HasValue )
                {
                    strBuilder.Append( operand );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTransactionalInfoTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( bestBeforeDate.Value, CultureInfo.InvariantCulture ) );
                    operand = " AND ";
                }
                else if ( checkSpecificBatchBestBefore )
                {
                    strBuilder.Append( operand );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTransactionalInfoTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME ) );
                    strBuilder.Append( " IS NULL " );
                    operand = " AND ";
                }

                if ( !string.IsNullOrEmpty( locationCode ) )
                {
                    strBuilder.Append( operand );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.Columns.StorLocCode.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( locationCode, CultureInfo.InvariantCulture ) );
                    operand = " AND ";
                }

                if ( !string.IsNullOrEmpty( qualityStatusCode ) )
                {
                    strBuilder.Append( operand );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxInventoryTotalTable.Columns.QualityStatusCode.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( qualityStatusCode, CultureInfo.InvariantCulture ) );
                    operand = " AND ";
                }

                strBuilder.Append( " GROUP BY " );

                SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME );
                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemName.NAME );
                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME );
                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME );
                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME );
                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME );
                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME );
                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME );
                strBuilder.Append( ", " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.InventoryUom.NAME );


                strBuilder.Append( " ORDER BY " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.ItemName.NAME ) );
                return strBuilder.ToString();
            }


            internal static string GetSSCCInfo( string sscc )
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat( "SELECT DISTINCT {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias( PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME, SSCCDataSet.Columns.LUID.Name ) );
                strBuilder.AppendFormat( ", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias( PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME, SSCCDataSet.Columns.SSCC.Name ) );
                strBuilder.AppendFormat( ", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME, SSCCDataSet.Columns.STORAGE_LOCATION_CODE.Name ) );
                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, SSCCDataSet.Columns.PMX_WAREHOUSE_CODE.Name));

                strBuilder.AppendFormat(", {0}",
                    SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, SSCCDataSet.Columns.PMX_WAREHOUSE_NAME.Name));


                strBuilder.AppendFormat( "\r\n FROM {0}",
                    SqlCommandHelper.EscapeTableName( PmxInventoryTotalTable.NAME ) );

                strBuilder.AppendFormat( "\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName( PmxLogisticUnitIDTable.NAME ) );

                strBuilder.AppendFormat( " ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName( PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME ) );

                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));

                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));

                strBuilder.AppendFormat("\r\n INNER JOIN {0}",
                    SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.AppendFormat(" ON {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME));




                strBuilder.AppendFormat( "\r\n WHERE {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName( PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME ),
                    SqlCommandHelper.FormatAndEscapeColumnValue( sscc, CultureInfo.InvariantCulture ) );

                return strBuilder.ToString();
            }

            internal static string GetZoneTypesForItem( string itemCode )
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat( "SELECT DISTINCT {0}",
                    SqlCommandHelper.EscapeTableColumnName( PmxItemZoneTypeTable.NAME, PmxItemZoneTypeTable.Columns.ZoneTypeCode.NAME ) );

                strBuilder.AppendFormat( " FROM {0}",
                    SqlCommandHelper.EscapeTableName( PmxItemZoneTypeTable.NAME ) );

                strBuilder.AppendFormat( " WHERE {0} = {1}",
                    SqlCommandHelper.EscapeTableColumnName( PmxItemZoneTypeTable.NAME, PmxItemZoneTypeTable.Columns.ItemCode.NAME ),
                    SqlCommandHelper.FormatAndEscapeColumnValue( itemCode,CultureInfo.InvariantCulture ) );

                return strBuilder.ToString();
            }


            /// <summary>
            /// Gets the name and the code of the  location, ordered by name.
            /// </summary>
            /// <param name="locationCode">The location code.</param>
            /// <param name="warehouseCode">The warehouse code.</param>
            /// <param name="zoneTypeCodes">The zone type codes.</param>
            /// <param name="emptyLocations">if set to <c>true</c> [empty locations].</param>
            /// <returns>The sql statement to get the location</returns>
            internal static string GetStorageLocationForZoneTypes( string locationCode, string warehouseCode, IList<string> zoneTypeCodes, bool emptyLocations )
            {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.Append( "SELECT " );

                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Code.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( LocationDataSet.Columns.CODE.Name );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Name.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( LocationDataSet.Columns.DESCRIPTION.Name );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( LocationDataSet.Columns.WAREHOUSECODE.Name );

                strBuilder.Append(", ");
                SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);

                strBuilder.Append(", ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.BlockMoveWhenNotEmpty.NAME));


                strBuilder.Append( " FROM " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( " INNER JOIN " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxOseGeneralTable.NAME ) );
                strBuilder.Append( " ON " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME );
                strBuilder.Append( " = " );
                SqlCommandHelper.AddTableColumnName( strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME );


                strBuilder.Append(" INNER JOIN ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
                strBuilder.Append(" ON ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                strBuilder.Append(" = ");
                SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);


                if ( emptyLocations )
                {
                    strBuilder.Append( " LEFT JOIN " );
                    strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxInventoryTotalTable.NAME ) );
                    strBuilder.Append( " ON " );
                    SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME );
                    strBuilder.Append( " = " );
                    SqlCommandHelper.AddTableColumnName( strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME );

                }

                strBuilder.Append( " WHERE " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME ) );
                strBuilder.Append( " = " );
                strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture ) );


                if ( !string.IsNullOrEmpty( locationCode ) )
                {
                    strBuilder.Append( " AND " );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Code.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( locationCode, CultureInfo.InvariantCulture ) );
                }

                if ( warehouseCode != null &&
                    warehouseCode.Trim() != "" )
                {
                    strBuilder.Append( " AND " );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseGeneralTable.NAME ) );
                    strBuilder.Append( "." );
                    strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME ) );
                    strBuilder.Append( " = " );
                    strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( warehouseCode, CultureInfo.InvariantCulture ) );

                }

                if ( zoneTypeCodes != null &&
                    zoneTypeCodes.Count > 0 )
                {
                    foreach ( string zoneTypeCode in zoneTypeCodes )
                    {
                        strBuilder.Append( " AND " );
                        strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                        strBuilder.Append( "." );
                        strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Code.NAME ) );
                        strBuilder.Append( " IN ( " );

                        strBuilder.Append( "SELECT " );

                        strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                        strBuilder.Append( "." );
                        strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Code.NAME ) );


                        strBuilder.Append( " FROM " );
                        strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxOseStorageLocationGeneralTable.NAME ) );
                        strBuilder.Append( " INNER JOIN " );
                        strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxOseGeneralTable.NAME ) );
                        strBuilder.Append( " ON " );
                        SqlCommandHelper.AddTableColumnName( strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME );
                        strBuilder.Append( " = " );
                        SqlCommandHelper.AddTableColumnName( strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME );
                        strBuilder.Append( " RIGHT OUTER JOIN " );
                        strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxLinkZoneZoneTypeTable.NAME ) );
                        strBuilder.Append( " ON " );
                        SqlCommandHelper.AddTableColumnName( strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME );
                        strBuilder.Append( " = " );
                        SqlCommandHelper.AddTableColumnName( strBuilder, PmxLinkZoneZoneTypeTable.NAME, PmxLinkZoneZoneTypeTable.Columns.ParentCode.NAME );


                        strBuilder.Append( " WHERE " );


                        strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxLinkZoneZoneTypeTable.NAME ) );
                        strBuilder.Append( "." );
                        strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxLinkZoneZoneTypeTable.Columns.ZoneTypeCode.NAME ) );
                        strBuilder.Append( " = " );
                        strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( zoneTypeCode, CultureInfo.InvariantCulture ) );


                        strBuilder.Append( ") " );

                    }
                }

                if ( emptyLocations )
                {
                    //If there is no link to the inventory, the location is empty
                    strBuilder.Append( " AND " );
                    SqlCommandHelper.AddTableColumnName( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME );
                    strBuilder.Append( " IS NULL " );

                }

                strBuilder.Append( " ORDER BY " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxOseStorageLocationGeneralTable.Columns.Name.NAME ) );


                return strBuilder.ToString();
            }


            /// <summary>
            /// Command for getting all logistic carriers order by name
            /// </summary>
            /// <param name="onlyInStock">if set to <c>true</c> the system will get the logistic carriers that are in stock and have no products on it (LUID IS NULL)</param>
            /// <param name="filterOutFrozenItems">if set to <c>true</c> [filter out frozen items].</param>
            /// <param name="dbTool">The database tool.</param>
            /// <returns>
            /// Command for getting all logistic carriers order by name
            /// </returns>
            public static string GetLogisticCarriersOrderByName(bool onlyInStock, bool filterOutFrozenItems, DbTool dbTool)
            {
                DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();

                strBuilder.Append( "SELECT DISTINCT " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.ItemCode.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( ProductDataSet.Columns.PRODUCT_CODE.Name );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.CustomItemDescr.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( ProductDataSet.Columns.PRODUCT_DESCRIPTION.Name );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.CodeBars.NAME ) );
                strBuilder.Append( " AS " );
                strBuilder.Append( ProductDataSet.Columns.GTIN.Name );

                strBuilder.Append( ", " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.IsLogisticCarrier.NAME ) );

                strBuilder.Append( "\r\n FROM " );
                strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxItemTable.VIEW_NAME ) );

                if ( onlyInStock )
                {
                    strBuilder.Append( "\r\n INNER JOIN " );
                    strBuilder.Append( SqlCommandHelper.EscapeTableName( PmxInventoryTotalTable.NAME ) );
                    strBuilder.Append( " ON " );
                    strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME));
                    strBuilder.Append( " = " );
                    strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxItemTable.VIEW_NAME, PmxItemTable.Columns.ItemCode.NAME));
                    strBuilder.Append( " AND " );
                    strBuilder.Append(SqlCommandHelper.EscapeTableColumnName(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
                    strBuilder.Append( " IS NULL " );
                }

                strBuilder.Append( "\r\n WHERE " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.InventoryItem.NAME ) );
                strBuilder.Append( " = " );
                strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture ) );

                strBuilder.Append( " AND " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.IsLogisticCarrier.NAME ) );
                strBuilder.Append( " = " );
                strBuilder.Append( SqlCommandHelper.FormatAndEscapeColumnValue( SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture ) );

                if ( filterOutFrozenItems )
                {
                    Produmex.Sbo.Logex.Data.SboCommands.GetFrozenItemFilterSQLWherePart( strBuilder, " AND ");
                }

                strBuilder.Append( "\r\n ORDER BY " );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.VIEW_NAME ) );
                strBuilder.Append( "." );
                strBuilder.Append( SqlCommandHelper.EscapeColumnName( PmxItemTable.Columns.CustomItemDescr.NAME ) );

                return strBuilder.ToString();
            }

        }



        /// <summary>
        /// Executes the get PMX warehouse code.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static PmxOseWarehouseInfo ExecuteGetPmxWarehouseCode(PmxDbConnection conn, object[] parameters)
        {
            PmxOseProvider oseProv = new PmxOseProvider(conn);
            return oseProv.GetPmxWarehouseInfo((string)parameters[0]);
        }

    }
}
