//css_ref System.Data;
//css_ref System.Transactions;
//css_ref System.Xml;
//css_ref Interop.SAPbobsCOM.dll;
//css_ref log4net.dll;
//css_ref Produmex.Foundation.dll;
//using Produmex.Foundation.Data.dll;
//css_ref Produmex.Foundation.Data.Sbo.dll;
//using Produmex.Foundation.Sbo.dll;
//css_ref Produmex.Sbo.Logex.Data.dll;
//css_ref Produmex.Sbo.Logex.KalFire.dll;

using System;
using System.Diagnostics;
using System.Reflection;
using System.Transactions;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.Attributes;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Reflection;
using Produmex.Foundation.Resources;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Data;
using Produmex.Foundation;
using Produmex.Sbo.Logex.Data.Generators.PickListController;

namespace AddUpdateScript
{
	class Program
	{
		static string CONNECTION_STRING = "Server=DEV_SAP9_FR;CompanyDB=SBODemo_US_64;ExtraDb=PMX_SBODemo_US_64;UseTrusted=False;DbUserName=sa;DbPassword=B1Admin;UserName=manager;Password=produmex;Pooling=True;MinPoolSize=2;MaxPoolSize=10;ServerType=MSSQL2008;DBCultureInfo=en-US;LicenseServer=localhost:30000";

		/// <summary>
		/// Used for logging
		/// </summary>
		private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

		static void Main(string[] args)
		{
			try
			{
				Produmex.Foundation.Diagnostics.LogProvider.SetConsoleAppender("WARN");
				Execute();
			}
			catch (Exception ex)
			{
				s_log.Error("", ex);
			}
			if (Debugger.IsAttached)
			{
				Console.WriteLine("Press <Enter>");
				Console.ReadLine();
			}
		}

		static void Execute()
		{

			using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
			{
				using (SboConnection conn = new SboConnection(CONNECTION_STRING))
				{
					conn.Open(); //Open connection to SAP
					Console.WriteLine("Connection is open to database");

					PmxDbVersionUpdaterProvider updateProv = new PmxDbVersionUpdaterProvider(conn);


				}

				//Complete transaction
				scope.Complete();
			}

			

			Console.WriteLine("Done ...");
		}




		/// <summary>
		/// Add/Update <see cref="PmxExtension"/>
		/// </summary>
		/// <param name="code">The code of the extension.</param>
		/// <param name="name">The name of the extension.</param>
		/// <param name="type">The type of the extension.</param>
		/// <param name="extensionTypeCode">The extension type code.</param>
		/// <param name="conn">The SBO connection</param>
		private static void AddUpdateExtension(string code, string name, Type type, string extensionTypeCode, PmxDbConnectionSql conn)
		{
			PmxExtensionProvider prov = new PmxExtensionProvider(conn);
			PmxExtension extension = null;
			try
			{
				bool newBO = false;
				extension = prov.GetBO(code);
				if (extension == null)
				{
					newBO = true;
					extension = prov.GetNewBO();
					extension.Code = code;
				}
				extension.Name = name;
				extension.ExtensionTypeCode = extensionTypeCode;
				extension.Type = ReflectionHelper.GetTypeAndAssemblyName(type);
				if (newBO)
				{
					prov.AddBO(extension);
				}
				else
				{
					prov.UpdateBO(extension, false, false);
				}
			}
			finally
			{
				if (extension != null)
					extension.Dispose();
			}
		}

		/// <summary>
		/// Add/Update script workflow
		/// </summary>
		/// <param name="executionType">Type of the execution.</param>
		/// <param name="name">The name of the flow.</param>
		/// <param name="sourceFilePath">Name of the file.</param>
		/// <param name="sqlConn">The SQL conn.</param>
		private static void AddUpdateWorkflowScript(string executionType, string name, string sourceFilePath, PmxDbConnectionSql sqlConn)
		{
			PmxWorkflowProvider wfProvider = new PmxWorkflowProvider(sqlConn);
			PmxWorkflow workflow = wfProvider.GetWorkflowByName(name);
			PmxWorkflowScriptProvider wfscProvider = new PmxWorkflowScriptProvider(sqlConn);
			PmxWorkflowScript bo = null;
			if (workflow == null)
			{
				//add the workflow
				bo = wfscProvider.GetNewBO();
				bo.Name = name;
				wfscProvider.AddBO(bo);
			}
			else
			{
				if (workflow.ObjType == Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxWorkflowScript)
				{
					bo = wfscProvider.GetBO(workflow.InternalKey);

				}
			}

			if (bo != null)
			{
				bo.ExecutionType = executionType;

				wfscProvider.UpdateSourceFromFileAndCompile(bo, sourceFilePath, sqlConn);
			}
		}

		/// <summary>
		/// Runs the table SQL script.
		/// </summary>
		/// <param name="tableScript">The table script.</param>
		/// <param name="conn">The conn.</param>
		private static void RunTableSqlScript(string tableScript, PmxDbConnection conn)
		{
			string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.KalFire.SboCommands)), "Produmex.Sbo.Logex.KalFire.Scripts.Tables." + tableScript);
			SboRecordsetHelper.RunSqlScript(s_log, content, conn);
		}

		/// <summary>
		/// Adds the update user fields not in transaction.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="types">The types.</param>
		private static void AddUpdateUserFieldsNotInTransaction(SboConnection conn, params Type[] types)
		{
			SboUserFieldMDProvider userFieldMDProv = new SboUserFieldMDProvider(conn);
			//System.Data.Common.DbTransaction transaction = null;
			try
			{
				//transaction = this.Connection.BeginTransaction();
				userFieldMDProv.AddUpdateUserFields(types);

				//Commit transaction
				//transaction.Commit();
			}
			catch (Exception)
			{
				//if (transaction != null) transaction.Rollback();
				throw;
			}
		}

		/// <summary>
		/// Runs the stored procedure SQL script.
		/// </summary>
		/// <param name="spScript">The sp script.</param>
		/// <param name="conn">The conn.</param>
		private static void RunStoredProcedureSqlScript(string spScript, PmxDbConnection conn)
		{
			string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.KalFire.SboCommands)), "Produmex.Sbo.Logex.KalFire.Scripts.StoredProcedures." + spScript);
			SboRecordsetHelper.RunSqlScript(s_log, content, conn);
		}
	}
}
