﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Transactions;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.RestApiClient;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.GS1;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.DataObjects;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Utilities;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo;
using Produmex.Foundation.Wwf.Sbo.DataObjects;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Devices;
using Produmex.Sbo.Logex.Data.Generators.BatchNumberGenerators;
using Produmex.Sbo.Logex.Data.Generators.PackingController;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;

// PmxWorkflowExecutionTypes.HOOK_FLOW

namespace Produmex.Sbo.Logex.WorkflowScripts
{
	/// <summary>
	/// The constant parameters to configure the operation of the process
	/// </summary>
	internal static class Definitions
	{
		public const string WEBSERVICE_URL = "http://KF-APP04.kal-fire.lan:8080/B1iXcellerator/exec/ipo/vP.0010000105.in_HCSX/com.sap.b1i.vplatform.runtime/INB_HT_CALL_SYNC_XPT/INB_HT_CALL_SYNC_XPT.ipo/proc/tst/api/v1/productionorder";
		public const string WEBSERVICE_USER_NAME = "produmex";
		public const string WEBSERVICE_USER_PWD = "produmex";
	}

	public class WebServiceRequest
	{
		public int DocEntry;
	}

	public class WebServiceResponse
	{
		public string Message;
	}

	public class WorkflowScript_AfterProductionOrderSelectedProductionReceiptHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<int> ProductionOrderDocEntry;

        //output
        public ReadWriteBinder<bool> BackRequested;

        // Sub-flows
        // <none>

        public WorkflowScript_AfterProductionOrderSelectedProductionReceiptHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
			// Parameters in scope
			Session session = GetScopeParameter("Session") as Session;
			//ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

			RestApiCient restApiClient = new RestApiCient(Definitions.WEBSERVICE_URL);
			RestApiBasicAuthorizationCredentials credentials = new RestApiBasicAuthorizationCredentials(Definitions.WEBSERVICE_USER_NAME, Definitions.WEBSERVICE_USER_PWD); 

			RestApiResponse<WebServiceResponse> response = restApiClient.DoAction<WebServiceRequest, WebServiceResponse>(
				RestMethodType.Post,
				"",
				new WebServiceRequest() { DocEntry = ProductionOrderDocEntry.Get() },
				RestApiSerializationType.JSON, credentials);

			if (!string.IsNullOrEmpty(response.ErrorMessage) || response.ResponseHttpStatus != System.Net.HttpStatusCode.OK)
			{
				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
					DefaultCultureInfo.Get(), BuildParamCollection(
						"MessageKey", !string.IsNullOrEmpty(response.ErrorMessage) ?
							response.ErrorMessage : 
							!string.IsNullOrEmpty(response.ResponseObject.Message) ?
								response.ResponseObject.Message :
								"HTTP Status: " + response.ResponseHttpStatus.ToString(),
						"NoTranslationOfMessageKey", true,
						"IsError", true,
						"ShowButton", true));

				WaitForMessage();

				BackRequested.Set(true);
			}
			else
			{
				BackRequested.Set(false);
			}
        }

        #endregion
    }
}
