using System;
using System.Reflection;
using System.Transactions;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.Attributes;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Reflection;
using Produmex.Foundation.Resources;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.NGK.Extensions.Interfacing;
using Produmex.Sbo.Logex.NGK.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.NGK.Generators.CreateNGKSAPDeliveryFromPMXDeliveryController;
using Produmex.Sbo.Logex.NGK.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.NGK.Generators.PickListRobot;

namespace AddUpdateScript
{
    class Program
    {
        static string CONNECTION_STRING = "Server=PDMX-SPRUYTN;CompanyDB=SBODemo_US;ExtraDb=PMX_SBODemo_US;UseTrusted=False;DbUserName=sa;DbPassword=B1Admin;UserName=manager;Password=produmex;Pooling=True;MinPoolSize=2;MaxPoolSize=10;ServerType=MSSQL2012;DBCultureInfo=en-US;LicenseServer=localhost:30000";
        static string SCRIPT_ROOT = @"..\..\WorkflowScripts";

        /// <summary>
        /// Used for logging
        /// </summary>
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        static void Main(string[] args)
        {
            string test = SCRIPT_ROOT;
            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (PmxDbConnectionSql dbConn = new PmxDbConnectionSql(CONNECTION_STRING))
                {
                    dbConn.Open(); //Open connection to SAP
                    Console.WriteLine("Connection is open to database");

                    //Console.WriteLine("Workflows");

                    Console.WriteLine("Extensions");

                    AddUpdateExtension(
                         PmxAdvanceShippingNoticeInterfaceNGK.IDs.ExtCode,
                         "IPmxAdvanceShippingNoticeInterface - NGK",
                         typeof(PmxAdvanceShippingNoticeInterfaceNGK),
                         Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IADVANCESHIPPINGNOTICE_INTERFACE,
                         dbConn
                         );
                }
                //Complete transaction
                scope.Complete();
            }

            using (SboConnection conn = new SboConnection(CONNECTION_STRING))
            {
                conn.Open();
                // * UDF's *
                Console.WriteLine("Add update UDF: ShippingTypeNGK");
                SboUserFieldMDProvider udfProv = new SboUserFieldMDProvider(conn);
                udfProv.AddUpdateUserfield(PmxShippingTypeTable.NAME, new SboColumnDefinitionAttribute(
                    PmxShippingTypeNGKTable.Columns.CreateDeliveryAutomatically.NAME,
                    PmxShippingTypeNGKTable.Columns.CreateDeliveryAutomatically.DESCR,
                    PmxShippingTypeNGKTable.Columns.CreateDeliveryAutomatically.TYPE,
                    PmxShippingTypeNGKTable.Columns.CreateDeliveryAutomatically.SIZE,
                    PmxShippingTypeNGKTable.Columns.CreateDeliveryAutomatically.SUB_TYPE));

                Console.WriteLine("Add update UDF: block creation picklist");
                udfProv.AddUpdateUserfield(PmxSalesOrderNGKTable.NAME, new SboColumnDefinitionAttribute(
                    PmxSalesOrderNGKTable.Columns.blockCreationPL.NAME,
                    PmxSalesOrderNGKTable.Columns.blockCreationPL.DESCR,
                    PmxSalesOrderNGKTable.Columns.blockCreationPL.TYPE,
                    PmxSalesOrderNGKTable.Columns.blockCreationPL.SIZE,
                    PmxSalesOrderNGKTable.Columns.blockCreationPL.SUB_TYPE));
                // * UDF's *

                //scope.Complete();
            }

            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (PmxDbConnectionSql dbConn = new PmxDbConnectionSql(CONNECTION_STRING))
                {
                    dbConn.Open();

                    AddUpdateExtension(
                        CreateNGKSAPDeliveryFromPMXDeliveryController.IDs.ExtCode,
                        "Create NGK SAP delivery",
                        typeof(CreateNGKSAPDeliveryFromPMXDeliveryController),
                        Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.ICREATEDELIVERYCONTROLLER,
                        dbConn
                        );

                    AddUpdateExtensionParameter(
                        CreateNGKSAPDeliveryFromPMXDeliveryController.IDs.ExtParamCreateSAPDelivery,
                        "Create automatically SAP deliveries from PMX deliveries? (Y/N)",
                        CreateNGKSAPDeliveryFromPMXDeliveryController.IDs.ExtCode,
                        Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                        "True",
                        PmxExtensionParameterCodes.CREATE_SAP_DELIVERY_FROM_PMX_DELIVERY,
                        dbConn
                        );
                }
                scope.Complete();
            }

            using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
            {
                using (SboConnection dbConn = new SboConnection(CONNECTION_STRING))
                {
                    dbConn.Open();
                    Console.WriteLine("Connection is open to database");
                    PmxDbVersionUpdaterProvider updateProv = new PmxDbVersionUpdaterProvider(dbConn);
                  
                    Assembly NGKAssembly = typeof(Produmex.Sbo.Logex.NGK.SboCommands).Assembly;

                    updateProv.AddUpdateExtension(PickListRobot.IDs.ExtCode, "NGK Pick List robot",
                    typeof(Produmex.Sbo.Logex.NGK.Generators.PickListRobot.PickListRobot), Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IPICKLISTROBOT);

                    AddUpdateExtensionParameter(
                      PickListRobot.IDs.ExtParamReportKey,
                      "Report key for pick list robot?",
                      PickListRobot.IDs.ExtCode,
                      Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_INT32_CONVERTOR,
                      "0",
                      PmxExtensionParameterCodesNGK.PICKLIST_ROBOT_REPORT_KEY,
                      dbConn
                      );

                    AddUpdateExtensionParameter(
                       PickListRobot.IDs.ExtParamLocationCode,
                       "Location code for pick list robot?",
                       PickListRobot.IDs.ExtCode,
                       Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
                       "",
                       PmxExtensionParameterCodesNGK.PICKLIST_ROBOT_LOCATIONCODE,
                       dbConn
                       );


                  //  Console.WriteLine("Client Parameters");
                    PmxDbVersionUpdaterProvider dbVersionProv = new PmxDbVersionUpdaterProvider(dbConn);



                    string resourceName = "Produmex.Sbo.Logex.NGK.Scripts.Views.PMX_NGK_OPEN_SALES_ORDERS_WITH_STOCK_STATUS.sql";
                    dbConn.DbTool.CreateUpdateView("PMX_NGK_OPEN_SALES_ORDERS_WITH_STOCK_STATUS", dbVersionProv.PreprocessSqlScript(ResourceHelper.ReadResourceContentAsString(NGKAssembly, resourceName)));

                    resourceName = "Produmex.Sbo.Logex.NGK.Scripts.Views.PMX_NGK_PROPOSALS_TO_PICK_LIST.sql";
                    dbConn.DbTool.CreateUpdateView("PMX_NGK_PROPOSALS_TO_PICK_LIST", dbVersionProv.PreprocessSqlScript(ResourceHelper.ReadResourceContentAsString(NGKAssembly, resourceName)));

                }
                scope.Complete();
            }

            Console.WriteLine("Done ...");
        }

        /// <summary>
        /// Runs the table SQL script.
        /// </summary>
        /// <param name="tableScript">The table script.</param>
        /// <param name="conn">The conn.</param>
        private static void RunTableSqlScript(string tableScript, PmxDbConnection conn)
        {
            string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.NGK.SboCommands)), "Produmex.Sbo.Logex.NGK.Scripts.Tables." + tableScript);
            SboRecordsetHelper.RunSqlScript(s_log, content, conn);
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtension"/>
        /// </summary>
        /// <param name="code">The code of the extension.</param>
        /// <param name="name">The name of the extension.</param>
        /// <param name="type">The type of the extension.</param>
        /// <param name="extensionTypeCode">The extension type code.</param>
        /// <param name="conn">The SBO connection</param>
        private static void AddUpdateExtension(string code, string name, Type type, string extensionTypeCode, PmxDbConnectionSql conn)
        {
            PmxExtensionProvider prov = new PmxExtensionProvider(conn);
            PmxExtension extension = null;
            try
            {
                bool newBO = false;
                extension = prov.GetBO(code);
                if (extension == null)
                {
                    newBO = true;
                    extension = prov.GetNewBO();
                    extension.Code = code;
                }
                extension.Name = name;
                extension.ExtensionTypeCode = extensionTypeCode;
                extension.Type = ReflectionHelper.GetTypeAndAssemblyName(type);
                if (newBO)
                {
                    prov.AddBO(extension);
                }
                else
                {
                    prov.UpdateBO(extension, false, false);
                }
            }
            finally
            {
                if (extension != null) extension.Dispose();
            }
        }

        


        /// <summary>
        /// Add/Update script workflow
        /// </summary>
        /// <param name="executionType">Type of the execution.</param>
        /// <param name="name">The name of the flow.</param>
        /// <param name="sourceFilePath">Name of the file.</param>
        /// <param name="sqlConn">The SQL conn.</param>
        private static void AddUpdateWorkflowScript(string executionType, string name, string sourceFilePath, PmxDbConnectionSql sqlConn)
        {
            PmxWorkflowProvider wfProvider = new PmxWorkflowProvider(sqlConn);
            PmxWorkflow workflow = wfProvider.GetWorkflowByName(name);
            PmxWorkflowScriptProvider wfscProvider = new PmxWorkflowScriptProvider(sqlConn);
            PmxWorkflowScript bo = null;
            if (workflow == null)
            {
                //add the workflow
                bo = wfscProvider.GetNewBO();
                bo.Name = name;
                wfscProvider.AddBO(bo);
            }
            else
            {
                if (workflow.ObjType == Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxWorkflowScript)
                {
                    bo = wfscProvider.GetBO(workflow.InternalKey);

                }
            }

            if (bo != null)
            {
                bo.ExecutionType = executionType;

                wfscProvider.UpdateSourceFromFileAndCompile(bo, sourceFilePath, sqlConn);
            }



        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionParameter(string code, string name, string extensionCode, string convertorCode, string defaultValue, PmxDbConnection conn)
        {
            AddUpdateExtensionParameter(code, name, extensionCode, convertorCode, defaultValue, code, conn);
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="generalParameterCode">The general parameter code.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionParameter(string code, string name, string extensionCode, string convertorCode, string defaultValue, string generalParameterCode, PmxDbConnection conn)
        {
            AddUpdateExtensionParameter(code, name, extensionCode, convertorCode, defaultValue, generalParameterCode, 0, conn);
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="generalParameterCode">The general parameter code.</param>
        /// <param name="sequence">The sequence.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionParameter(string code, string name, string extensionCode, string convertorCode, string defaultValue, string generalParameterCode, int sequence, PmxDbConnection conn)
        {
            PmxExtensionParameterProvider prov = new PmxExtensionParameterProvider(conn);
            PmxExtensionParameter extParam = null;
            try
            {
                bool newBO = false;
                extParam = prov.GetBO(code);
                if (extParam == null)
                {
                    newBO = true;
                    extParam = prov.GetNewBO();
                    extParam.Code = code;
                }
                extParam.Name = name;
                extParam.ExtensionCode = extensionCode;
                extParam.ConvertorCode = convertorCode;
                extParam.GeneralParameterCode = generalParameterCode;
                extParam.DefaultValue = defaultValue;
                extParam.Sequence = sequence;
                if (newBO)
                {
                    prov.AddBO(extParam);
                }
                else
                {
                    prov.UpdateBO(extParam, false, false);
                }
            }
            finally
            {
                if (extParam != null) extParam.Dispose();
            }
        }
    }
}
