﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Text;
using Produmex.Foundation.Convertors;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Utilities;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Foundation;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.Utilities;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_SalesDeliveryCreatedHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_SalesDeliveryCreatedHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger( MethodInfo.GetCurrentMethod().DeclaringType );

   

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<DocumentRef[]> DocumentRefs;

        // Output parameters
        // <none>

        // Sub-flows
        // <none>


        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_SalesDeliveryCreatedHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_SalesDeliveryCreatedHookScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base( parent, factory )
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter( "Session" ) as Session;
            ISboProviderService sboProviderService = GetScopeParameter( "<WwfService>ISboService" ) as ISboProviderService;

            Message msg = null;

            string query = null;
            string initialErrorKey = null;


            DocumentRef[] documentRefs = DocumentRefs.Get();

            List<int> listOfPmxSalesDeliveries = new List<int>();

            foreach ( DocumentRef docRef in documentRefs )
            {
                if ( docRef.DocType == Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxSalesShipping )
                {
                    listOfPmxSalesDeliveries.Add( docRef.DocEntry );
                }
            }

            DateTime date = DateTime.Now;

            Step_GetReturnDate:

            if (listOfPmxSalesDeliveries.Count > 0)
            {


                #region GET RETURN DATE

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterDateScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                   "InitialErrorKey", initialErrorKey,
                   "TitleKey", "MSG_TITLE_ENTER_DISPATCH_DATE_NGK",
                   "DefaultDate", date,
                   "AllowToGoBack", false
                   ));
                msg = WaitForMessage();

                initialErrorKey = null;

                if (msg.Name.EndsWith(".DateEntered"))
                {
                    date = ExtractParameter<DateTime?>(msg.Parameters, "date") ?? DateTime.Now;

                    goto Step_Update;
                    

                }

                //Go back is not allowed
                goto Step_GetReturnDate;

            }
            else
            {
                return;
            }

            #endregion





            Step_Update:

            #region UPDATE

            try
            {
                sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
               delegate (PmxDbConnection conn, object[] parameters)
               {
                   query = BuildQuery.UpdateSalesShippingHeader(listOfPmxSalesDeliveries, date.ToString("ddMMyy"), conn.DbCultureInfo);

                   SboRecordsetHelper.RunQueryNoReturn(s_log, query, conn);

                   
                   return null;
               });
            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
                if (!(ex is ProdumexException) || ((ProdumexException)ex).Error == null)
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ExceptionHelper.Format(ex, this.DefaultCultureInfo),
                            "NoTranslationOfMessageKey", true,
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();

                }
                else
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "PmxError", ((ProdumexException)ex).Error,
                            "ShowButton", true));
                    WaitForMessage();
                }

                //retry?
                //ask user if he wants to retry
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_RETRY_UPDATE",
                        "MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_WANT_RETRY"));
                msg = WaitForMessage();

                if (msg.Name.ToLower().EndsWith(".yes"))
                {
                    goto Step_Update;
                }

            }

            #endregion


        }

        #endregion



        #region HELPERS




        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }
            return 0;
        }

        #endregion

        #region QUERY

        private class BuildQuery
        {

            
            internal static string UpdateSalesShippingHeader(List<int> docEntries, string driverName, CultureInfo cultInfo)
            {
                StringBuilder strBuilder = new StringBuilder();

                strBuilder.AppendFormat("UPDATE {0}",
                    SqlCommandHelper.EscapeTableName(PmxSalesShippingTable.NAME));

                strBuilder.AppendFormat(" SET {0} = {1}",
                  SqlCommandHelper.EscapeTableColumnName(PmxSalesShippingTable.NAME, PmxSalesShippingTable.Columns.DriverName.NAME),
                  SqlCommandHelper.FormatAndEscapeColumnValue(driverName, cultInfo));

                strBuilder.AppendFormat(", {0} = {0} + 1",
                  SqlCommandHelper.EscapeTableColumnName(PmxSalesShippingTable.NAME, PmxSalesShippingTable.Columns.Version.NAME));


                strBuilder.AppendFormat("\r\nWHERE {0} IN ({1})",
                    SqlCommandHelper.EscapeTableColumnName(PmxSalesShippingTable.NAME, PmxSalesShippingTable.Columns.DocEntry.NAME),
                    SqlCommandHelper.FormatAndEscapeColumnValue(docEntries, cultInfo));
               

                return strBuilder.ToString();
            }


  
        }

        #endregion
    }
}
