﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.Reflection;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.ProLaser.BusinessObjects.Definitions.Tables;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_BeforePickingWaveHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_BeforePickingWaveHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<int> WaveKey;

        // Output parameters * do not change *
        public ReadWriteBinder<bool> BackRequested;

        // Sub-flows
        // <none>

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_BeforePickingWaveHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_BeforePickingWaveHookScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        /// <summary>
        /// Executes this instance.
        /// </summary>
        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;
            Message msg = null;

            string query = BuildQuery.GetItemToPrint(WaveKey.Get(), sboProviderService);
            DataSet ds = sboProviderService.RunView(false, null, null, query);


            if (GetNumberOfRows(ds) > 0)
            {
                //Ask if labels need to be printed
                //ask user if he wants to print item labels
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_PRINT_ITEM_LABEL",
                        "MessageKey", "MSG_QUESTION_PRINT_ITEM_LABEL"));
                msg = WaitForMessage();

                if (msg.Name.EndsWith(".Yes"))
                {
                    foreach (DataRow row in ds.Tables[0].Rows)
                    {
                        string itemCode = row[PmxPickListLineTable.Columns.ItemCode.NAME] as string;
                        int quantity = Convert.ToInt32(row[PmxPickListLineTable.Columns.Quantity.NAME]);
                        string dock = row[PmxPickListTable.Columns.DestStorLocCode.NAME] as string;

                        if (PrintItemLabels(itemCode, quantity, dock))
                        {
                            BackRequested.Set(true);
                        }

                    }

                    //show the message
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "ShowButton", true,
                            "MessageKey", "MSG_LABELS_PRINTED_PL",
                            "NoTranslationOfMessageKey", false
                        ));
                    msg = WaitForMessage();
                }
            }

            //Get extra pick message
            query = BuildQuery.GetExtraPickMessage(WaveKey.Get(), sboProviderService);
            ds = sboProviderService.RunView(false, null, null, query);


            if (GetNumberOfRows(ds) > 0)
            {
                List<string> listOfMessages = new List<string>();
                foreach (DataRow row in ds.Tables[0].Rows)
                {
                    string remark = row[PmxSalesOrderTablePL.Columns.ExtraPickMessage.NAME] as string;
                    listOfMessages.Add(remark);
                }

                string remarks = string.Join(", ", listOfMessages);

                //show the message
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "ShowButton", true,
                        "MessageKey", remarks,
                        "NoTranslationOfMessageKey", true
                    ));
                msg = WaitForMessage();
            }
        }

        #endregion

        #region HELPERS


        private class PrintItemLabelFlowData
        {
            public bool BackRequested;
            public string LocationCode;
            public string NeededItemCode;
            public string NeededBatchNumber;
            public string NeededBatchNumber2;
            public DateTime? NeededBestBeforeDate;
            public int? NeededNrOfLabels;
            public bool AskBatchInfo;
            public double? EnteredQuantity;
            public bool ShowPrintMessage;
        }


        private bool PrintItemLabels(string itemCode, int numberOfItemLabels, string locationCode)
        {

            PrintItemLabelFlowData printData = new PrintItemLabelFlowData()
            {
                BackRequested = false,
                ShowPrintMessage = false,
                NeededItemCode = itemCode,
                NeededNrOfLabels = numberOfItemLabels,
                LocationCode = locationCode,
                EnteredQuantity = numberOfItemLabels,
                AskBatchInfo = false
            };

            WorkflowInstanceBase printItemLabelFlow = Create("PrintItemLabelScript");

            printItemLabelFlow.BindParameters(
                DefaultCultureInfo,
                PmxOseCompany,
                new ReadOnlyBinder<string>(nameof(printData.LocationCode), printData, nameof(printData.LocationCode)),
                new ReadOnlyBinder<string>(nameof(printData.NeededItemCode), printData, nameof(printData.NeededItemCode)),
                new ReadOnlyBinder<string>(nameof(printData.NeededBatchNumber), printData, nameof(printData.NeededBatchNumber)),
                new ReadOnlyBinder<string>(nameof(printData.NeededBatchNumber2), printData, nameof(printData.NeededBatchNumber2)),
                new ReadOnlyBinder<DateTime?>(nameof(printData.NeededBestBeforeDate), printData, nameof(printData.NeededBestBeforeDate)),
                new ReadOnlyBinder<int?>(nameof(printData.NeededNrOfLabels), printData, nameof(printData.NeededNrOfLabels)),
                new ReadOnlyBinder<bool>(nameof(printData.AskBatchInfo), printData, nameof(printData.AskBatchInfo)),
                new ReadWriteBinder<bool>(nameof(printData.BackRequested), printData, nameof(printData.BackRequested)),
                new ReadWriteBinder<double?>(nameof(printData.EnteredQuantity), printData, nameof(printData.EnteredQuantity)),
                new ReadWriteBinder<bool>(nameof(printData.ShowPrintMessage), printData, nameof(printData.ShowPrintMessage))
            );

            StartSubFlowAndWait(printItemLabelFlow, true);

            return printData.BackRequested;

        }


        private static int GetNumberOfRows(DataSet ds)
        {
            if (ds != null && ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }

            return 0;
        }
        #endregion

        #region Query
        private static class BuildQuery
        {
            public static string GetItemToPrint(int waveKey, ISboProviderService sboProviderService)
            {
                DbQueryBuilder qb = sboProviderService.GetDbTool().GetQueryBuilder();

                qb = qb.Select.AppendFormat("SUM({0}*{1}) AS {2}", SqlCommandHelper.EscapeTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.OpenQty.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.QuantityPerUom.NAME),
                    SqlCommandHelper.EscapeColumnName(PmxPickListLineTable.Columns.Quantity.NAME)).Comma.
                    EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.ItemCode.NAME).Comma.
                    AppendFormat("MAX({0}) AS {1}", SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DestStorLocCode.NAME),
                        SqlCommandHelper.EscapeColumnName(PmxPickListTable.Columns.DestStorLocCode.NAME)).CRLF.


                    From.
                    EscTableName(PmxPickListTable.NAME).WithNoLock.CRLF.

                    InnerJoin.EscTableName(PmxPickListLineTable.NAME).WithNoLock.
                    On.EscTableColumnName(PmxPickListTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME).Eq.
                    EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME).CRLF.

                    InnerJoin.EscTableName(PmxPickListProposalLineTable.NAME).WithNoLock.
                    On.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.DocEntry.NAME).Eq.
                    EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.BaseEntry.NAME).CRLF.
                    And.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.LineNum.NAME).Eq.
                    EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.BaseLine.NAME).CRLF.
                    And.EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.BaseType.NAME).Eq.Append(qb.AsOwnType(PmxObjectTypes.PmxPickListProposal)).CRLF.


                    InnerJoin.EscTableName(PmxSalesOrderTable.NAME).WithNoLock.
                    On.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.BaseEntry.NAME).Eq.
                    EscTableColumnName(PmxSalesOrderTable.NAME, PmxSalesOrderTablePL.Columns.DocEntry.NAME).CRLF.
                    And.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.BaseType.NAME).Eq.Append(qb.AsOwnType(SboObjectTypes.SalesOrder)).CRLF.

                    Where.
                    EscTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME).
                    Eq.
                    Append(qb.AsOwnType(waveKey)).CRLF.
                    And.EscTableColumnName(PmxSalesOrderTable.NAME, PmxSalesOrderTablePL.Columns.PrintItemLabels.NAME).
                    Eq.
                    Append(qb.AsOwnType(SboBooleanColumnValues.Y.VALUE)).CRLF.

                    GroupBy.CRLF.
                    EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.ItemCode.NAME);



                return qb.ToString();
            }

            public static string GetExtraPickMessage(int waveKey, ISboProviderService sboProviderService)
            {
                DbQueryBuilder qb = sboProviderService.GetDbTool().GetQueryBuilder();

                qb = qb.Select.Distinct.AppendFormat("CAST({0} AS NVARCHAR(4000)) AS {1}", SqlCommandHelper.EscapeTableColumnName(PmxSalesOrderTablePL.NAME, PmxSalesOrderTablePL.Columns.ExtraPickMessage.NAME),
                    SqlCommandHelper.EscapeColumnName(PmxSalesOrderTablePL.Columns.ExtraPickMessage.NAME)).CRLF.

                    From.
                    EscTableName(PmxPickListTable.NAME).WithNoLock.CRLF.

                    InnerJoin.EscTableName(PmxPickListLineTable.NAME).WithNoLock.
                    On.EscTableColumnName(PmxPickListTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME).Eq.
                    EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME).CRLF.

                    InnerJoin.EscTableName(PmxPickListProposalLineTable.NAME).WithNoLock.
                    On.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.DocEntry.NAME).Eq.
                    EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.BaseEntry.NAME).CRLF.
                    And.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.LineNum.NAME).Eq.
                    EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.BaseLine.NAME).CRLF.
                    And.EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.BaseType.NAME).Eq.Append(qb.AsOwnType(PmxObjectTypes.PmxPickListProposal)).CRLF.


                    InnerJoin.EscTableName(PmxSalesOrderTable.NAME).WithNoLock.
                    On.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.BaseEntry.NAME).Eq.
                    EscTableColumnName(PmxSalesOrderTable.NAME, PmxSalesOrderTable.Columns.DocEntry.NAME).CRLF.
                    And.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.BaseType.NAME).Eq.Append(qb.AsOwnType(SboObjectTypes.SalesOrder)).CRLF.

                    Where.
                    EscTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.WaveKey.NAME).
                    Eq.Append(qb.AsOwnType(waveKey)).CRLF.
                    And.EscTableColumnName(PmxSalesOrderTablePL.NAME, PmxSalesOrderTablePL.Columns.ExtraPickMessage.NAME).IsNotNull;



                return qb.ToString();
            }


        }
        #endregion
    }
}
