//css_ref System.Data;
//css_ref System.Transactions;
//css_ref System.Xml;
//css_ref Interop.SAPbobsCOM.dll;
//css_ref log4net.dll;
//css_ref Produmex.Foundation.dll;
//css_ref Produmex.Foundation.Data.dll;
//css_ref Produmex.Foundation.Data.Sbo.dll;
//css_ref Produmex.Sbo.Logex.Data.dll;
//css_ref Produmex.Sbo.Logex.ProLaser.dll;

using System;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Globalization;
using System.Reflection;
using System.Transactions;
using Produmex.Foundation;
using Produmex.Foundation.Collections;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.Attributes;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Reflection;
using Produmex.Foundation.Resources;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.Functions.Definitions;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.Utilities;
using Produmex.Sbo.Logex.ProLaser.BusinessObjects;
using Produmex.Sbo.Logex.ProLaser.BusinessObjects.Convertors;
using Produmex.Sbo.Logex.ProLaser.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.ProLaser.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.ProLaser.Data.Generators.WarehouseAutomationController;
using Produmex.Sbo.Logex.ProLaser.Generators.PicklistController;
using Produmex.Sbo.Logex.ProLaser.Generators.PickListProposalGenerator;
using Produmex.Sbo.Logex.ProLaser.Generators.PickListRobot;
using Produmex.Sbo.Logex.ProLaser.Generators.ReplenishmentGenerator;

namespace AddUpdateScript
{
	class Program
	{
		static string CONNECTION_STRING = "Server=testsrv;CompanyDB=trunk_pmx;ExtraDb=PMX_trunk_pmx;UseTrusted=False;DbUserName=sa;DbPassword=sadmin;UserName=manager;Password=123456;Pooling=True;MinPoolSize=2;MaxPoolSize=10;ServerType=MSSQL2014;DBCultureInfo=en-US;LicenseServer=localhost:30000";

		/// <summary>
		/// Used for logging
		/// </summary>
		private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

		static void Main(string[] args)
		{
			try
			{
				LogProvider.SetConsoleAppender("WARN");
				Execute();
			}
			catch (Exception ex)
			{
				s_log.Error("", ex);
			}
			if (Debugger.IsAttached)
			{
				Console.WriteLine("Press <Enter>");
				Console.ReadLine();
			}
		}

		/// <summary>
		/// Executes this instance.
		/// </summary>
		static void Execute()
		{
			using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
			{
				using (SboConnection conn = new SboConnection(CONNECTION_STRING))
				{
					conn.Open(); //Open connection to SAP
					Console.WriteLine("Connection is open to database");

					Console.WriteLine("Creating UDFs");
					CreatingUDFs(conn);

					Console.WriteLine("Creating location types");
					CreatingLocationTypes(conn);

					Console.WriteLine("Creating pick list types");
					CreatingPickListTypes(conn);

					Console.WriteLine("Creating user groups");
					CreatingUserGroups(conn);

					Console.WriteLine("Creating logistic carrier items");
					CreatingLogisticCarriers(conn);
				}

				//Complete transaction
				scope.Complete();
			}

			using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
			{
				using (PmxDbConnectionSql conn = new PmxDbConnectionSql(CONNECTION_STRING))
				{
					conn.Open(); //Open connection to SAP
					Console.WriteLine("Connection is open to database");

					Console.WriteLine("Creating Views");
					CreateUpdateViews(conn);

					Console.WriteLine("Creating Generators");
					CreateUpdateExtensionsForReplenishmentGenerator(conn);

					CreateUpdateExtensionsForPickListRobot(conn);

					AddPickListController(conn);

					AddPickListProposalGenerator(conn);

					CreateUpdateExtensionsForWarehouseAutomationController(conn);

					Console.WriteLine("Add custom fields for PMX_* tables");
					AddCustomFieldsForPmxTables(conn);

					Console.WriteLine("Add SP ");
					RunStoredProcedureSqlScript("PMX_SP_ProLaser_TransactionNotification.sql", conn);
				}

				scope.Complete();
			}

			Console.WriteLine("Done ...");
		}

		private static void CreateUpdateExtensionsForWarehouseAutomationController(PmxDbConnectionSql conn)
		{
			AddUpdateExtension(
				WarehouseAutomationControllerPL.IDs.ExtCode,
				"ProLaser - WAC (Warehouse Automation Controller",
				typeof(WarehouseAutomationControllerPL),
				Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IWAREHOUSEAUTOMATIONCONTROLLER,
				conn);
		}

		private static void CreatingUserGroups(SboConnection conn)
        {
            PmxUserGroup pickingSupervisorGroup = new PmxUserGroup
            {
                Code = PmxUserGroupPL.PickingSupervisior.CODE,
                Name = PmxUserGroupPL.PickingSupervisior.NAME
            };

            string[] searchColumn = new string[] { PmxUserGroupTable.Columns.Code.NAME };
            SboUserObjectMDProvider userObjectMDProv = new SboUserObjectMDProvider(conn);
            userObjectMDProv.AddUpdateData(pickingSupervisorGroup, searchColumn, new object[] { pickingSupervisorGroup.Code });

        }

        static void CreatingUDFs(SboConnection conn)
		{
					SboUserFieldMDProvider udfProv = new SboUserFieldMDProvider(conn);

			// UDF for OCRD table
					SboColumnDefinitionAttribute columnDef = new SboColumnDefinitionAttribute(PmxBusinessPartnerTablePL.Columns.PrintItemLabels.NAME,
						PmxBusinessPartnerTablePL.Columns.PrintItemLabels.DESCR, PmxBusinessPartnerTablePL.Columns.PrintItemLabels.TYPE,
						PmxBusinessPartnerTablePL.Columns.PrintItemLabels.SIZE, SboFieldSubType.None);

			columnDef.IsMandatory = !PmxBusinessPartnerTablePL.Columns.PrintItemLabels.ISNULL;
					columnDef.CanBeNull = PmxBusinessPartnerTablePL.Columns.PrintItemLabels.ISNULL;
					columnDef.SboBOColumnConverterType = typeof(SboBooleanConvertor);
					columnDef.DefaultValue = SboBooleanColumnValues.N.VALUE;

			udfProv.AddUpdateUserfield(PmxBusinessPartnerTablePL.NAME, columnDef);


			// UDFs for OSHP table
			columnDef = new SboColumnDefinitionAttribute(PmxShippingTypeTablePL.Columns.PalletShipping.NAME,
				PmxShippingTypeTablePL.Columns.PalletShipping.DESCR, PmxShippingTypeTablePL.Columns.PalletShipping.TYPE,
				PmxShippingTypeTablePL.Columns.PalletShipping.SIZE, PmxShippingTypeTablePL.Columns.PalletShipping.SUB_TYPE);

			columnDef.IsMandatory = !PmxShippingTypeTablePL.Columns.PalletShipping.ISNULL;
			columnDef.CanBeNull = PmxShippingTypeTablePL.Columns.PalletShipping.ISNULL;
			columnDef.SboBOColumnConverterType = typeof(SboBooleanConvertor);
			columnDef.DefaultValue = PmxShippingTypeTablePL.Columns.PalletShipping.DEFAULT_VALUE;

			udfProv.AddUpdateUserfield(PmxShippingTypeTablePL.NAME, columnDef);

			columnDef = new SboColumnDefinitionAttribute(PmxShippingTypeTablePL.Columns.BoxShipping.NAME,
				PmxShippingTypeTablePL.Columns.BoxShipping.DESCR, PmxShippingTypeTablePL.Columns.BoxShipping.TYPE,
				PmxShippingTypeTablePL.Columns.BoxShipping.SIZE, PmxShippingTypeTablePL.Columns.BoxShipping.SUB_TYPE);

			columnDef.IsMandatory = !PmxShippingTypeTablePL.Columns.BoxShipping.ISNULL;
			columnDef.CanBeNull = PmxShippingTypeTablePL.Columns.BoxShipping.ISNULL;
			columnDef.SboBOColumnConverterType = typeof(SboBooleanConvertor);
			columnDef.DefaultValue = PmxShippingTypeTablePL.Columns.BoxShipping.DEFAULT_VALUE;

			udfProv.AddUpdateUserfield(PmxShippingTypeTablePL.NAME, columnDef);

			columnDef = new SboColumnDefinitionAttribute(PmxShippingTypeTablePL.Columns.DeliveryTime.NAME,
				PmxShippingTypeTablePL.Columns.DeliveryTime.DESCR, PmxShippingTypeTablePL.Columns.DeliveryTime.TYPE,
				PmxShippingTypeTablePL.Columns.DeliveryTime.SIZE, PmxShippingTypeTablePL.Columns.DeliveryTime.SUB_TYPE);

			columnDef.IsMandatory = !PmxShippingTypeTablePL.Columns.DeliveryTime.ISNULL;
			columnDef.CanBeNull = PmxShippingTypeTablePL.Columns.DeliveryTime.ISNULL;

			udfProv.AddUpdateUserfield(PmxShippingTypeTablePL.NAME, columnDef);


			// UDF for ORDR table
			//columnDef = new SboColumnDefinitionAttribute(PmxSalesOrderTablePL.Columns.OrderType.NAME,
			//	PmxSalesOrderTablePL.Columns.OrderType.DESCR, PmxSalesOrderTablePL.Columns.OrderType.TYPE,
			//	PmxSalesOrderTablePL.Columns.OrderType.SIZE, PmxSalesOrderTablePL.Columns.OrderType.SUB_TYPE);

			//columnDef.IsMandatory = !PmxSalesOrderTablePL.Columns.OrderType.ISNULL;
			//columnDef.CanBeNull = PmxSalesOrderTablePL.Columns.OrderType.ISNULL;
			//columnDef.SboBOColumnConverterType = typeof(PmxOrderTypePLConvertor);
			//columnDef.DefaultValue = PmxSalesOrderTablePL.Columns.OrderType.DEFAULT_VALUE;

			//udfProv.AddUpdateUserfield(PmxSalesOrderTablePL.NAME, columnDef);


			udfProv.AddUpdateUserFields(typeof(PmxSalesOrderPL));


			//UDF for OITM table 
			columnDef = new SboColumnDefinitionAttribute(PmxItemsTablePL.Columns.WeightTolerancePercentage.NAME,
				PmxItemsTablePL.Columns.WeightTolerancePercentage.DESCR, PmxItemsTablePL.Columns.WeightTolerancePercentage.TYPE,
				PmxItemsTablePL.Columns.WeightTolerancePercentage.SIZE, PmxItemsTablePL.Columns.WeightTolerancePercentage.SUB_TYPE);

			columnDef.CanBeNull = PmxItemsTablePL.Columns.WeightTolerancePercentage.ISNULL;

			udfProv.AddUpdateUserfield(PmxItemsTablePL.NAME, columnDef);

			////UDF for Pick list types
			AddUpdateUserDefinedTable(typeof(PmxPickListTypePL), conn); 
			AddUpdateUserDefinedObject(typeof(PmxPickListTypePL), conn);
		}

        private static void AddUpdateUserDefinedTable(Type type, SboConnection conn)
        {
	        SboUserTableMDProvider userTableMDProv = new SboUserTableMDProvider(conn);
	        userTableMDProv.AddUpdateBO(type);
        }

        private static void AddUpdateUserDefinedObject(Type type, SboConnection conn)
        {
	        SboUserObjectMDProvider userObjectMDProv = new SboUserObjectMDProvider(conn);

	        if (userObjectMDProv.AddUpdateBO(type))
	        {
		        //Rerun in case of delete of columns
		        userObjectMDProv.AddUpdateBO(type);
	        }
        }

		static void CreatingLocationTypes(SboConnection conn)
	    {
	        SboUserObjectMDProvider userObjectMDProv = new SboUserObjectMDProvider(conn);

	        PmxLocationType locTypeDynamic = new PmxLocationType() {Code = PmxLocationTypesPL.DYNAMIC.VALUE, Name = PmxLocationTypesPL.DYNAMIC.DESCR};
	        PmxLocationType locTypeRackBulk = new PmxLocationType() {Code = PmxLocationTypesPL.RACK_BULK.VALUE, Name = PmxLocationTypesPL.RACK_BULK.DESCR};
	        PmxLocationType locTypeRackPick = new PmxLocationType() {Code = PmxLocationTypesPL.RACK_PICK.VALUE, Name = PmxLocationTypesPL.RACK_PICK.DESCR};

	        string[] searchColumn = new string[] {PmxLocationTypeTable.Columns.Code.NAME};

	        userObjectMDProv.AddUpdateData(locTypeDynamic, searchColumn, new object[] {locTypeDynamic.Code});
	        userObjectMDProv.AddUpdateData(locTypeRackPick, searchColumn, new object[] {locTypeRackPick.Code});
	        userObjectMDProv.AddUpdateData(locTypeRackBulk, searchColumn, new object[] {locTypeRackBulk.Code});
	    }

		static void CreatingLogisticCarriers(SboConnection conn)
		{
			PmxDictionary<string, string> logcars = new PmxDictionary<string, string>();

			logcars.Add(PmxLogisticCarrierTypesPL.SMALLENVELOPE.VALUE, PmxLogisticCarrierTypesPL.SMALLENVELOPE.DESCR);
			logcars.Add(PmxLogisticCarrierTypesPL.BIGENVELOPE.VALUE, PmxLogisticCarrierTypesPL.BIGENVELOPE.DESCR);
			logcars.Add(PmxLogisticCarrierTypesPL.SMALLBOX.VALUE, PmxLogisticCarrierTypesPL.SMALLBOX.DESCR);
			logcars.Add(PmxLogisticCarrierTypesPL.BIGBOX.VALUE, PmxLogisticCarrierTypesPL.BIGBOX.DESCR);

			PmxItemProvider itemProv = new PmxItemProvider(conn);

			PmxItem logcar;

			foreach (var lcCodeAndDescr in logcars)
			{
				logcar = itemProv.GetBO(lcCodeAndDescr.Key);

				if (logcar == null)
				{
					logcar = itemProv.GetNewBO();
					logcar.ItemCode = lcCodeAndDescr.Key;
					logcar.ItemName = lcCodeAndDescr.Value;

					logcar.InventoryItem = true;
					logcar.PurchaseItem = true;
					logcar.SalesItem = true;
					logcar.IsLogisticCarrier = true;

					itemProv.AddBO(logcar);
				}
				else if (!logcar.IsLogisticCarrier)
				{
					s_log.WarnFormat("The item '{0}' exists, but it is not set as a logistic carrier!", lcCodeAndDescr.Key);
				}
			}
		}

		static void CreatingPickListTypes(SboConnection conn)
	    {
	        SboUserObjectMDProvider userObjectMDProv = new SboUserObjectMDProvider(conn);

	        PmxPickListType pltDynamic = new PmxPickListType() { Code = PmxPickListTypesPL.DYNAMIC.VALUE, Name = PmxPickListTypesPL.DYNAMIC.DESCR, UseForMultiPicking = true, UseForPicking = true };
	        PmxPickListType pltRack = new PmxPickListType() { Code = PmxPickListTypesPL.RACK.VALUE, Name = PmxPickListTypesPL.RACK.DESCR, UseForMultiPicking = true, UseForPicking = true };
	        PmxPickListType pltKardex = new PmxPickListType() { Code = PmxPickListTypesPL.KARDEX.VALUE, Name = PmxPickListTypesPL.KARDEX.DESCR, UseForMultiPicking = true, UseForPicking = true };
	        PmxPickListType pltEnvelope = new PmxPickListType() { Code = PmxPickListTypesPL.ENVELOPE.VALUE, Name = PmxPickListTypesPL.ENVELOPE.DESCR, UseForMultiPicking = true, UseForPicking = true };

            string[] searchColumn = new string[] { PmxPickListTypeTable.Columns.Code.NAME };

            //Only add, no update!
	        userObjectMDProv.AddUpdateData(pltDynamic, searchColumn, new object[] { pltDynamic.Code }, true);
	        userObjectMDProv.AddUpdateData(pltRack, searchColumn, new object[] { pltRack.Code }, true);
	        userObjectMDProv.AddUpdateData(pltKardex, searchColumn, new object[] { pltKardex.Code }, true);
	        userObjectMDProv.AddUpdateData(pltEnvelope, searchColumn, new object[] { pltEnvelope.Code }, true);
	    }

	    static void CreateUpdateViews(PmxDbConnectionSql conn)
	    {
	        Assembly plAssembly = typeof(Produmex.Sbo.Logex.ProLaser.SboCommands).Assembly;
	        string scriptLocations = "Produmex.Sbo.Logex.ProLaser.Scripts.";

	        conn.DbTool.CreateUpdateView("PMX_PL_REPLENISHMENT_CLOSE_MOVE_ORDERS", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PL_REPLENISHMENT_CLOSE_MOVE_ORDERS.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PL_RACK_PICK_TO_PRODUCTION", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PL_RACK_PICK_TO_PRODUCTION.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PL_RACK_BULK_TO_RACK_PICK", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PL_RACK_BULK_TO_RACK_PICK.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PL_RACK_PICK_TO_DYNAMIC_PICK", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PL_RACK_PICK_TO_DYNAMIC_PICK.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PL_CONSIGNMENT_STOCK", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PL_CONSIGNMENT_STOCK.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PICK_LIST_ROBOT_SALES_ORDER_LINES_PL", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PICK_LIST_ROBOT_SALES_ORDER_LINES_PL.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PICK_LIST_ROBOT_VOLUMETRIC_ANALYSIS_PL", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PICK_LIST_ROBOT_VOLUMETRIC_ANALYSIS_PL.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PICKING_SELECT_WAVE_PL", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PICKING_SELECT_WAVE_PL.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PICK_LIST_ROBOT_PROPOSAL_SPLIT_UP_PL", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PICK_LIST_ROBOT_PROPOSAL_SPLIT_UP_PL.sql"));
			conn.DbTool.CreateUpdateView("PMX_PICK_LIST_ROBOT_PROPOSALS_TO_PICKLIST_PL", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PICK_LIST_ROBOT_PROPOSALS_TO_PICKLIST_PL.sql"));
	        conn.DbTool.CreateUpdateView("PMX_PICK_LIST_ROBOT_EXPORT_KARDEX_PL", ResourceHelper.ReadResourceContentAsString(plAssembly, scriptLocations + "Views.PMX_PICK_LIST_ROBOT_EXPORT_KARDEX_PL.sql"));
		}


	    private static void AddPickListController(PmxDbConnection conn)
        {


            AddUpdateExtension(PicklistControllerPL.IDs.ExtCode, "Pick list controller for Pro Laser", typeof(PicklistControllerPL), Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IPICKLISTCONTROLLER, conn);

            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CAN_PICK_FULL_LUID_FROM_BULK_LOCATION,
                "Can the user pick full pallet from bulk location? (Y/N)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CAN_PICK_FULL_LUID_FROM_BULK_LOCATION, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MUST_FIRST_PICK_FULL_LUID_FROM_BULK_LOCATION,
                "Must the user first pick full pallet from bulk location? (Y/N)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MUST_FIRST_PICK_FULL_LUID_FROM_BULK_LOCATION, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_FORCE_PICK_FULL_LUID,
                "Force the user to pick full pallet? (Y/N)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_FORCE_PICK_FULL_LUID, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ONLY_ITEMS_UNDER_DOCK,
                "Only pick items on location on same or lower level as dock? (Y/N)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ONLY_ITEMS_UNDER_DOCK, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_COPY_BATCH_FOR_ALTERNATE_ITEMS,
                "Copy batch number when selecting alternate item? (Y/N)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_COPY_BATCH_FOR_ALTERNATE_ITEMS, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MAKE_READY_BEFORE_PRINT,
                "Make picklist ready before print? (Y/N)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MAKE_READY_BEFORE_PRINT, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CUSTOM_WAVE_DESCR_JOIN_SQL,
                "JOIN-sql for custom wave description for scanner",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, null, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CUSTOM_WAVE_DESCR_JOIN_SQL, 900, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CUSTOM_WAVE_DESCR_FIELDS,
                "Custom wave description fields for scanner",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, null, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CUSTOM_WAVE_DESCR_FIELDS, 901, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamCopyNonInventoryItemsToResInv,
                "Copy non-inventory items to reserve invoice?",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_COPY_NON_INVENTORY_ITEMS_TO_RES_INV, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamPickItemsOrderBy,
                "Pick items order by", PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR,
                PmxPickListItemOrderByCodes.FULL_LOCATION_NO_PICK, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, 900, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, PmxPickListItemOrderByCodes.FULL_LOCATION_NO_PICK, "Order by Full LUID, sequence, no location", conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, PmxPickListItemOrderByCodes.FULL_PICKEDITEM_LOCATION, "Order by Full LUID, picked item, locationcode", conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, PmxPickListItemOrderByCodes.SEQUENCE_LOCATION_FULLLUID, "Order by Sequence, location code, full LUID", conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, PmxPickListItemOrderByCodes.CUSTOM_STORED_PROCEDURE, "Order by Custom stored procedure", conn);

            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamPickItemsOrderByCustomSP,
                "Pick items order by - Stored procedure name",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, "PMX_SP_PickItemsOrderByLineNum",
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY_CUSTOM_SP, 901, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAdHocAlternateItem,
                "Ad hoc alternate item? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AD_HOC_ALTERNATE_ITEM, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAllowAllGoodsPickedConfirm,
                "Allow confirmation that ALL goods were picked",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_ALL_GOODS_PICKED_CONFIRM, (int)PicklistControllerPL.IDs.ExtensionParameterType.AdHoc, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAutoMoveSSCCOnCustomerCollect,
                "Auto move SSCC on a customer-collected related move",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_MOVE_SSCC_ON_CUSTOMER_COLLECT, 1, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamEnterReasonWhenSkippingFirstLocationAdHocPicking,
                "Reason requirements when skipping first location (Ad hoc picking)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR,
                PmxPickListRequiresReasonCodes.REQUIRES_NO_REASON, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ENTER_REASON_SKIP_FIRST_LOC_ADHOC_PICKING,
                (int)PicklistControllerPL.IDs.ExtensionParameterType.AdHoc, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ENTER_REASON_SKIP_FIRST_LOC_ADHOC_PICKING, PmxPickListRequiresReasonCodes.REQUIRES_NO_REASON, "No reason is necessary.", conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ENTER_REASON_SKIP_FIRST_LOC_ADHOC_PICKING, PmxPickListRequiresReasonCodes.REQUIRES_REASON_FREE_TEXT, "Requires user-entered reasontext", conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ENTER_REASON_SKIP_FIRST_LOC_ADHOC_PICKING, PmxPickListRequiresReasonCodes.REQUIRES_SELECTED_REASON, "Requires selected reason from list", conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAdHocPickOnlyWithSSCC,
                "Ad hoc: Force to scan SSCC? (Y/N)", PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AD_HOC_PICKING_ONLY_WITH_SSCC, (int)PicklistControllerPL.IDs.ExtensionParameterType.AdHoc, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAllowToCreateMasterSSCC,
                "Allow to create master SSCC? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_TO_CREATE_MASTER_SSCC, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAllowMultipleCustomersOnSSCC,
                "Allow multiple customers on SSCC?",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_MULTIPLE_CUSTOMERS_ON_SSCC, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAutoFillInQuantityForPackingTypes,
                "Auto fill quantity for packaging types?", PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_FILL_QTY_PACK_TYPES, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamWaveOrderBy, "Wave order by",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR,
                PmxWaveOrderByCodes.PRIORITY_DUE_KEY, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_WAVE_ORDER_BY, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_WAVE_ORDER_BY, PmxWaveOrderByCodes.PRIORITY_DUE_KEY, "Order by priority, due date, wave key", conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_WAVE_ORDER_BY, PmxWaveOrderByCodes.DUE_PRIORITY_KEY, "Order by due date, priority, wave key", conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAutoSelectWave, "Auto select the wave?",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_SELECT_WAVE, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAutoSelectItri, "Auto select batch/BBD on picking?",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_SELECT_ITRI, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAllowToIdentifySSCCToPickOn, "Allow to identify the SSCC to pick on?",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_TO_IDENTIFY_SSCC_TO_PICK_ON, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAllowToSelectItemToPick,
                "Allow to select the item to pick?", PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_TO_SELECT_ITEM_TO_PICK, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamConsolidateItemsToPick, "Consolidate items to pick?",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CONSOLIDATE_ITEMS_TO_PICK, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamDisableSelectionOfItems,
                "Disable selection of items? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_DISABLE_SELECTION_OF_ITEMS, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamRoutePickingPickListOrderBy,
                "Route picking picklist order by", PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR,
                PmxRoutePickingPickListOrderByCodes.PRIORITY_DUEDATE_DOCENTRY, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ROUTEPICKING_PICKLIST_ORDER_BY, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateParameterValidValues(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ROUTEPICKING_PICKLIST_ORDER_BY, typeof(PmxRoutePickingPickListOrderByCodes), conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAllowCycleCountOfOriginalPickLocationOnAlternatePicking,
                "Allow cycle count on alternate picking? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_CYCLE_COUNT_OF_ORIGINAL_PICK_LOCATION_ON_ALTERNATE_PICKING, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamLockWaveByZoneUserForZonePicking,
                "Lock wave by zone/user (Zone picking)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_LOCK_WAVE_BY_ZONE_USER_FOR_ZONE_PICKING, (int)PicklistControllerPL.IDs.ExtensionParameterType.ZonePicking, PicklistControllerPL.Grouping.ZonePicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamOnlyShowCompletelyUnlockedWavesOnZonePicking,
                "Only show completely unlocked waves in case of zone picking?",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ONLY_SHOW_COMPLETELY_UNLOCKED_WAVES_FOR_ZONE_PICKING, (int)PicklistControllerPL.IDs.ExtensionParameterType.ZonePicking, PicklistControllerPL.Grouping.ZonePicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamMsgItemIsPickedTimeInterval,
                "Time to show 'item is picked' message?",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_INT32_CONVERTOR,
                "0", PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MSG_ITEM_IS_PICKED_TIME_INTERVAL, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.General, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamPackingMsgPickPackRemarksTimeInterval,
                "Time to show pick/pack remarks on packing?",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_INT32_CONVERTOR, "-1",
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PACKING_MSG_PICK_PACK_REMARKS_TIME_INTERVAL, (int)PicklistControllerPL.IDs.ExtensionParameterType.Packing, PicklistControllerPL.Grouping.Packing, conn);
            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CAN_PICK_BULK_QTY_FROM_BULK_LOCATION,
                "Can the user pick bulk quantity from bulk location? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                ProdumexValues.False, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CAN_PICK_BULK_QTY_FROM_BULK_LOCATION, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamPickFromBulkForAdhocPicking,
                "Allow ad hoc picking from bulk locations?",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_ADHOC_PICKING_FROM_BULK, (int)PicklistControllerPL.IDs.ExtensionParameterType.AdHoc, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamChooseDockAdhocPicking,
                "Choose dock on ad hoc picking?",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CHOOSE_DOCK_ADHOC_PICKING, (int)PicklistControllerPL.IDs.ExtensionParameterType.AdHoc, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamKeepPickingSameItemForAdhocPicking,
                "Ad hoc picking: Keep picking same item? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_KEEP_PICKING_SAME_ITEM_ADHOC_PICKING, (int)PicklistControllerPL.IDs.ExtensionParameterType.AdHoc, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamKeepPickingSameLocationForPicking,
                "Picking: Keep picking same location? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_KEEP_PICKING_SAME_LOCATION_PICKING, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.Picking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAutoFillInitialQuantityAdHocPicking,
                "Ad hoc: Auto fill pick quantity? (Y/N)", PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                ProdumexValues.False, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AD_HOC_AUTO_FILL_INITIAL_QUANTITY, (int)PicklistControllerPL.IDs.ExtensionParameterType.AdHoc, PicklistControllerPL.Grouping.AdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamShowLockedQuantityForLineAlternatePicking,
                "Alternate: Show locked quantity for current line? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_SHOW_LOCKED_STOCK_FOR_LINE_ALTERNATE_PICKING, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAutomaticSelectionOfMoveableLocation,
                "Auto selection of moveable location during picking? (Y/N)", PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTOMATIC_SELECTION_OF_MOVEABLE_LOCATION, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamStockOrderBy,
                "Stock order by",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_CONVERTOR,
                PmxPickListStockOrderByCodes.DEFAULT, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_STOCK_ORDER_BY, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_STOCK_ORDER_BY, PmxPickListStockOrderByCodes.DEFAULT, "Default Order by", conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_STOCK_ORDER_BY, PmxPickListStockOrderByCodes.LOWEST_QUANTITY_FIRST, "Order by lowest quantity", conn);
            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_STOCK_ORDER_BY, PmxPickListStockOrderByCodes.BIGGEST_PALLET_FIRST, "Order by Highest quantity, oldest LUID", conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamPickingForceScanSSCCOnItemPicking,
                "Item picking: Force user to scan SSCC when stock is on SSCC? (Y/N)", PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICKING_FORCE_SCAN_SSCC_ON_ITEM_PICKING, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAutoFillInQuantityForNoPackingTypes,
                "Auto fill quantity (No packaging types)? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_FILL_QTY_NO_PACK_TYPES, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamMultiPickingSetMovableLocationAtStart,
                "Multi picking: Set movable locations at start of picking? (Y/N)",
                PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MULTI_PICK_SET_MOVABLE_LOC_AT_START, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.MultiPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamSkipIdentifyLocationScreen,
                "Skip screen to identify the pick location? (Y/N)", PicklistControllerPL.IDs.ExtCode, Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                ProdumexValues.False, PmxExtensionParameterCodes.PICKLIST_CONTROLLER_SKIP_IDENTIFY_LOCATION_SCREEN, (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.NotAdHocPicking, conn);
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamMultiPickingAllowToSelectWave,
                "Multi picking: Allow to select wave? (Y/N)", PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MULTI_PICK_ALLOW_TO_SELECT_WAVE, PicklistControllerPL.Grouping.MultiPicking, conn);

            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamOnlyPickOn1SSCC,
                "Only pick on 1 SSCC? (Y/N)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ONLY_PICK_ON_ONE_SSCC, 1, PicklistControllerPL.Grouping.NotAdHocPicking, conn);

            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamOnlyCreateReplenishmentOrdersAfterPicking,
                "Create replenishment orders after picking? (Y/N)",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CREATE_REPLENISHMENT_ORDERS_AFTER_PICKING, 1, PicklistControllerPL.Grouping.General, conn);

           
            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAdHocFunctionNameForGettingLocations,
            "Function name to get the locations",
            PicklistControllerPL.IDs.ExtCode,
            Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, GetAllLocationsForItemForAdHocPickingFunction.NAME,
            PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AD_HOC_FUNCTION_TO_GET_LOCATIONS, 120, PicklistControllerPL.Grouping.AdHocPicking, conn);

            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAdHocFunctionNameForGettingLocationSequence,
            "Function name to get the location sequence",
            PicklistControllerPL.IDs.ExtCode,
            Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, GetFirstSequenceForLocationsForItemForAdHocPickingFunction.NAME,
            PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AD_HOC_FUNCTION_TO_GET_LOCATION_SEQUENCE, 121, PicklistControllerPL.Grouping.AdHocPicking, conn);
           


            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamAdHocViewNameForGettingProducts,
                "View name to get the products",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, "",
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AD_HOC_VIEW_NAME_TO_GET_PRODUCTS, 122, PicklistControllerPL.Grouping.AdHocPicking, conn);

            AddUpdateExtensionParameter(
                    PicklistControllerPL.IDs.ExtParamMakePickListReadyForSelectedLine,
                    "Make pick list ready for selected line? (Y/N)",
                    PicklistControllerPL.IDs.ExtCode,
                    Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                    ProdumexValues.False,
                    PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MAKE_PICK_LIST_READY_FOR_SELECTED_LINES,
                    (int)PicklistControllerPL.IDs.ExtensionParameterType.Default, PicklistControllerPL.Grouping.Picking, conn);



            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamPrepareCartsWaveViewName,
                "Wave - View name",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, "PMX_PREPARE_CARTS_WAVE",
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PREPARE_CARTS_WAVE_VIEW_NAME, 1, PicklistControllerPL.Grouping.PrepareCarts, conn);

            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamPrepareCartsWaveOrderBy,
                "Wave - Order by",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, SqlCommandHelper.EscapeTableColumnName("PMX_PREPARE_CARTS_WAVE", PmxWaveTable.Columns.Priority.NAME) + "," + SqlCommandHelper.EscapeTableColumnName("PMX_PREPARE_CARTS_WAVE", "WaveKey"),
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PREPARE_CARTS_WAVE_ORDER_BY, 2, PicklistControllerPL.Grouping.PrepareCarts, conn);

            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamPrepareCartsPickListOrderBy,
                "Pick list - Order by",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.Priority.NAME) + "," + SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DueDate.NAME) + "," + SqlCommandHelper.EscapeTableColumnName(PmxPickListTable.NAME, PmxPickListTable.Columns.DocEntry.NAME),
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PREPARE_CARTS_PICK_LIST_ORDER_BY, 3, PicklistControllerPL.Grouping.PrepareCarts, conn);


            AddUpdateExtensionParameter(PicklistControllerPL.IDs.ExtParamSelectWaveViewName,
                "Select wave - View name",
                PicklistControllerPL.IDs.ExtCode,
                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR, "PMX_PICKING_SELECT_WAVE_PL",
                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_SELECT_WAVE_VIEW_NAME, 1, PicklistControllerPL.Grouping.PickingMultiPicking, conn);

        }

		private static void AddPickListProposalGenerator(PmxDbConnection conn)
		{
			AddUpdateExtension(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				"ProLaser - PickListProposalGenerator - Generates picklist proposals grouped by customer-address",
				typeof(CustomerShipToAddressPickListProposalGeneratorPL),
				Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IPICKLISTPROPOSALGENERATOR, conn);

			AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_PROPOSAL_GENERATOR_GROUPED_ADD_EMPTY_ROWS_FOR_ITEMS_WITH_INSUFFICIENT_STOCK,
				"Add empty rows for items with insufficient stock? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_GENERATOR_GENERAL_ADD_EMPTY_ROWS_FOR_ITEMS_WITH_INSUFFICIENT_STOCK, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamAddEmptyRowsWhenQtyToReserveIsZero,
				"Add empty rows for items with quantity to reserve zero? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_GENERATOR_GENERAL_ADD_EMPTY_ROWS_FOR_ITEMS_WITH_QTY_TO_RESERVE_ZERO, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamAllowBrokenUpSalesItemBOMs,
				"Allow broken-up (incomplete) sales-item BOM's? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_GENERATOR_GENERAL_ALLOW_BROKENUP_SALES_ITEM_BOMS, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamOrderByFields,
				"Stock order by",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR, PmxFreeStockOrderByCodes.FEFO_PICKLOCATION,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_STOCK_ORDER_BY, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamPrioritizeByPickLocations,
				"Prioritize pick locations over bulk locations? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_GENERATOR_GENERAL_PRIORITIZE_BY_PICKLOCATIONS, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamBaseDocumentOrderByFields,
				"Base document - order by",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR, PmxBaseDocumentOrderByCodes.DOC_DUE_DATE,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_BASE_DOCUMENT_ORDER_BY, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamForceBatch,
				"Force the proposed batch? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_GENERATOR_FORCE_BATCH, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamShowProposalsWithPickLists,
				"Show proposals with pick lists on open doc. report? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_SHOW_PROPOSALS_WITH_PICKLISTS, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamTryToGroupItemsOn1Proposal,
				"Try to group items on 1 proposal? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_TRY_TO_GROUP_ITEMS_ON_1_PROPOSAL, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamSerialNumbersStockOrderBy,
				"Serial numbers stock order by",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR, PmxFreeStockSerialNumberOrderByCodes.DEFAULT,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_SERIAL_NUMBERS_STOCK_ORDER_BY, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamShowProposalInfoScreen,
				"Show pick list proposal info screen on incomplete proposal? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.False,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_SHOW_PROPOSAL_INFO_SCREEN, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);

			AddUpdateExtensionParameter(CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtParamCalculateStockStatus,
				"Calculate stock status for expired stock (= slower creation)? (Y/N)",
				CustomerShipToAddressPickListProposalGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR, ProdumexValues.True,
				PmxExtensionParameterCodes.PICKLIST_PROPOSAL_CALCULATE_STOCK_STATUS, CustomerShipToAddressPickListProposalGeneratorPL.Grouping.General, conn);
		}

		static void CreateUpdateExtensionsForReplenishmentGenerator(PmxDbConnectionSql conn)
		{
					AddUpdateExtension(
						ReplenishmentGeneratorPL.IDs.ExtCode,
						"ReplenishmentGenerator ProLaser - Generates replenishment orders",
						typeof(ReplenishmentGeneratorPL),
						Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IREPLENISHMENTGENERATOR, conn);

					//parameters
					AddUpdateExtensionParameter(
						ReplenishmentGeneratorPL.IDs.ExtOpenMoveOrdersToBeClosed,
						"View name: Open move orders to be closed",
						ReplenishmentGeneratorPL.IDs.ExtCode,
						Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
						"PMX_PL_REPLENISHMENT_CLOSE_MOVE_ORDERS",					
						PmxExtensionParameterCodesPL.REPLENISHMENT_GENERATOR_OPEN_MOVE_ORDERS_TO_BE_CLOSED,
						ReplenishmentGeneratorPL.Grouping.General, conn);

					AddUpdateExtensionParameter(
						ReplenishmentGeneratorPL.IDs.ExtRackBulkToRackPickLocation,
						"View name: Rack bulk to rack pick location",
						ReplenishmentGeneratorPL.IDs.ExtCode,
						Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
						"PMX_PL_RACK_BULK_TO_RACK_PICK",
						PmxExtensionParameterCodesPL.REPLENISHMENT_GENERATOR_RACK_BULK_TO_RACK_PICK_LOCATION,
						ReplenishmentGeneratorPL.Grouping.General, conn);

					AddUpdateExtensionParameter(
						ReplenishmentGeneratorPL.IDs.ExtRackPickToDynamicPickLocation,
						"View name: Rack pick to dynamic pick location",
						ReplenishmentGeneratorPL.IDs.ExtCode,
						Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
						"PMX_PL_RACK_PICK_TO_DYNAMIC_PICK",
						PmxExtensionParameterCodesPL.REPLENISHMENT_GENERATOR_RACK_PICK_TO_DYNAMIC_LOCATION,
						ReplenishmentGeneratorPL.Grouping.General, conn);

					AddUpdateExtensionParameter(
						ReplenishmentGeneratorPL.IDs.ExtRackPickToProduction,
						"View name: Rack pick to production",
						ReplenishmentGeneratorPL.IDs.ExtCode,
						Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
						"PMX_PL_RACK_PICK_TO_PRODUCTION",
						PmxExtensionParameterCodesPL.REPLENISHMENT_GENERATOR_RACK_PICK_TO_PRODUCTION,
						ReplenishmentGeneratorPL.Grouping.General, conn);

					AddUpdateExtensionParameter(
						ReplenishmentGeneratorPL.IDs.ExtConsignmentStock,
						"View name: Consignment stock",
						ReplenishmentGeneratorPL.IDs.ExtCode,
						Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
						"PMX_PL_CONSIGNMENT_STOCK",
						PmxExtensionParameterCodesPL.REPLENISHMENT_GENERATOR_CONSIGNMENT_STOCK,
						ReplenishmentGeneratorPL.Grouping.General, conn);

		            AddUpdateExtensionParameter(
						ReplenishmentGeneratorPL.IDs.ExtMainPmxWhs,
						"Main Pmx WHS",
						ReplenishmentGeneratorPL.IDs.ExtCode,
						Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
						"WH01",
						PmxExtensionParameterCodesPL.REPLENISHMENT_GENERATOR_MAIN_PMX_WHS,
						ReplenishmentGeneratorPL.Grouping.General, conn);

		    AddUpdateExtensionParameter(
				ReplenishmentGeneratorPL.IDs.ExtConsignmentWhs,
				"Consignment Pmx WHS",
				ReplenishmentGeneratorPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
				"WH02",
				PmxExtensionParameterCodesPL.REPLENISHMENT_GENERATOR_CONSIGNMENT_WHS,
				ReplenishmentGeneratorPL.Grouping.General, conn);
			    }

		static void CreateUpdateExtensionsForPickListRobot(PmxDbConnectionSql conn)
		{
			AddUpdateExtension(
				PickListRobotPL.IDs.ExtCode,
				"ProLaser - Pick List Robot",
				typeof(PickListRobotPL),
				Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IPICKLISTROBOT, conn);

			//parameters
			AddUpdateExtensionParameter(
				PickListRobotPL.IDs.ExtParamViewSalesOrderLines,
				"Create proposals - View name",
				PickListRobotPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
				"PMX_PICK_LIST_ROBOT_SALES_ORDER_LINES_PL",
				PmxExtensionParameterCodesPL.PICKLIST_ROBOT_VIEW_SALES_ORDER_LINES,
				PickListRobotPL.Grouping.General, conn);

			AddUpdateExtensionParameter(
				PickListRobotPL.IDs.ExtParamViewSalesOrderOrderBy,
				"Create proposals - Order by",
				PickListRobotPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
				"ShipDate",
				PmxExtensionParameterCodesPL.PICKLIST_ROBOT_VIEW_SALES_ORDER_ORDERBY,
				PickListRobotPL.Grouping.General, conn);

			AddUpdateExtensionParameter(
				PickListRobotPL.IDs.ExtParamViewProposalsToPickList,
				"Create pick lists - View name",
				PickListRobotPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
				"PMX_PICK_LIST_ROBOT_PROPOSALS_TO_PICKLIST_PL",
				PmxExtensionParameterCodesPL.PICKLIST_ROBOT_VIEW_PROPOSALS_TO_PICKLIST,
				PickListRobotPL.Grouping.General, conn);

			AddUpdateExtensionParameter(
				PickListRobotPL.IDs.ExtParamKardexBoxPickingNumber,
				"Kardex picking number of boxes/envelopes",
				PickListRobotPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_INT32_CONVERTOR,
				"10",
				PmxExtensionParameterCodesPL.PICKLIST_ROBOT_KARDEX_BOX_PICKING_NUMBER,
				PickListRobotPL.Grouping.General, conn);

			AddUpdateExtensionParameter(
				PickListRobotPL.IDs.ExtParamDynamicBoxPickingNumber,
				"Dynamic picking number of boxes",
				PickListRobotPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_INT32_CONVERTOR,
				"6",
				PmxExtensionParameterCodesPL.PICKLIST_ROBOT_DYNAMIC_BOX_PICKING_NUMBER,
				PickListRobotPL.Grouping.General, conn);

			AddUpdateExtensionParameter(
				PickListRobotPL.IDs.ExtParamViewVolumetricAnalysis,
				"Pick lists for Volumetric analysis - View name",
				PickListRobotPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
				"PMX_PICK_LIST_ROBOT_VOLUMETRIC_ANALYSIS_PL",
				PmxExtensionParameterCodesPL.PICKLIST_ROBOT_VIEW_VOLUMETRIC_ANALYSIS,
				PickListRobotPL.Grouping.General, conn);

			AddUpdateExtensionParameter(
				PickListRobotPL.IDs.ExtParamViewPickListForExportKardex,
				"Pick lists for Export Kardex - View name",
				PickListRobotPL.IDs.ExtCode,
				Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
				"PMX_PICK_LIST_ROBOT_EXPORT_KARDEX_PL",
				PmxExtensionParameterCodesPL.PICKLIST_ROBOT_VIEW_PICKLIST_FOR_EXPORT_KARDEX,
				PickListRobotPL.Grouping.General, conn);

		    AddUpdateExtensionParameter(
		        PickListRobotPL.IDs.ExtParamViewProposalSplitUp,
		        "Proposals to split up - View name",
		        PickListRobotPL.IDs.ExtCode,
		        Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
		        "PMX_PICK_LIST_ROBOT_PROPOSAL_SPLIT_UP_PL",
		        PmxExtensionParameterCodesPL.PICKLIST_ROBOT_VIEW_PROPOSAL_SPLIT_UP_PL,
		        PickListRobotPL.Grouping.General, conn);
        }

		static void AddCustomFieldsForPmxTables(PmxDbConnectionSql conn)
		{
			//conn.DbTool.AddUpdateColumn(PmxPickListProposalPLTable.NAME, PmxPickListProposalPLTable.Columns.U_PL_SplitUpByRobot.NAME, new DbTypeDef(DbType.String, PmxPickListProposalPLTable.Columns.U_PL_SplitUpByRobot.SIZE), ColumnFlags.NotNullable, PmxPickListProposalPLTable.Columns.U_PL_SplitUpByRobot.DEFAULT_VALUE);

			conn.DbTool.CreateUpdateTableNotInTransaction(typeof(PmxPickListProposalPLTable), DbTool.TableParts.All);
			conn.DbTool.CreateUpdateTableNotInTransaction(typeof(PmxPickListPLTable), DbTool.TableParts.All);
		}

		/// <summary>
		/// Add/Update <see cref="PmxExtension"/>
		/// </summary>
		/// <param name="code">The code of the extension.</param>
		/// <param name="name">The name of the extension.</param>
		/// <param name="type">The type of the extension.</param>
		/// <param name="extensionTypeCode">The extension type code.</param>
		/// <param name="conn">The SBO connection</param>
		private static void AddUpdateExtension(string code, string name, Type type, string extensionTypeCode, PmxDbConnection conn)
		{
			PmxExtensionProvider prov = new PmxExtensionProvider(conn);
			PmxExtension extension = null;
			try
			{
				bool newBO = false;
				extension = prov.GetBO(code);
				if (extension == null)
				{
					newBO = true;
					extension = prov.GetNewBO();
					extension.Code = code;
				}
				extension.Name = name;
				extension.ExtensionTypeCode = extensionTypeCode;
				extension.Type = ReflectionHelper.GetTypeAndAssemblyName(type);
				if (newBO)
				{
					prov.AddBO(extension);
				}
				else
				{
					prov.UpdateBO(extension, false, false);
				}
			}
			finally
			{
				if (extension != null) extension.Dispose();
			}
		}

        /// <summary>
        /// Adds/updates parameter valid values.
        /// </summary>
        /// <param name="parameterCode">The parameter code.</param>
        /// <param name="staticClassType">Type of the static class.</param>
        /// <param name="conn">The connection.</param>
        public static void AddUpdateParameterValidValues(string parameterCode, Type staticClassType, PmxDbConnection conn)
	    {
	        FieldInfo[] fis = staticClassType.GetFields();
	        foreach (FieldInfo fi in fis)
	        {
	            foreach (DescriptionAttribute attr in fi.GetCustomAttributes(typeof(DescriptionAttribute), false))
	            {
	                AddUpdateParameterValidValue(parameterCode, (string)fi.GetValue(null), attr.Description, conn);
	            }
	        }
	    }

        /// <summary>
        /// Add <see cref="PmxParameterValidValues" />
        /// </summary>
        /// <param name="parameterCode">The parameter code.</param>
        /// <param name="parameterValidValue">The parameter valid value.</param>
        /// <param name="parameterValidValueDescription">The parameter valid value description.</param>
        /// <param name="conn">The connection.</param>
        public static void AddUpdateParameterValidValue(string parameterCode, string parameterValidValue, string parameterValidValueDescription, PmxDbConnection conn)
	    {
	        PmxParameterValidValuesProvider prov = new PmxParameterValidValuesProvider(conn);
	        PmxParameterValidValues validValue = null;
	        try
	        {
	            bool newBO = false;
	            validValue = prov.GetParameterValidValue(parameterCode, parameterValidValue);
	            if (validValue == null)
	            {
	                newBO = true;
	                validValue = prov.GetNewBO();
	                validValue.ParameterCode = parameterCode;
	                validValue.ParameterValidValue = parameterValidValue;
	            }
	            validValue.ParameterValidValueDescription = parameterValidValueDescription;
	            if (newBO)
	            {
	                prov.AddBO(validValue);
	            }
	            else
	            {
	                prov.UpdateBO(validValue, false, false);
	            }
	        }
	        finally
	        {
	            if (validValue != null)
	                validValue.Dispose();
	        }

	    }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter" />
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="generalParameterCode">The general parameter code.</param>
        /// <param name="grouping">The grouping.</param>
        /// <param name="conn">The SBO connection</param>
        public static void AddUpdateExtensionParameter(string code, string name, string extensionCode, string convertorCode, string defaultValue, string generalParameterCode, string grouping, PmxDbConnection conn)
	    {
	        AddUpdateExtensionParameter(code, name, extensionCode, convertorCode, defaultValue, generalParameterCode, 0, grouping, conn);

	    }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter" />
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="generalParameterCode">The general parameter code.</param>
        /// <param name="sequence">The sequence.</param>
        /// <param name="grouping">The grouping.</param>
        /// <param name="conn">The SBO connection</param>
        public static void AddUpdateExtensionParameter(string code, string name, string extensionCode, string convertorCode, string defaultValue, string generalParameterCode, int sequence, string grouping, PmxDbConnection conn)
	    {

            PmxExtensionParameterProvider prov = new PmxExtensionParameterProvider(conn);
			PmxExtensionParameter extParam = null;
			try
			{
				bool newBO = false;
				extParam = prov.GetBO(code);
				if (extParam == null)
				{
					newBO = true;
					extParam = prov.GetNewBO();
					extParam.Code = code;
				}
				extParam.Name = name;
				extParam.ExtensionCode = extensionCode;
				extParam.ConvertorCode = convertorCode;
				extParam.DefaultValue = defaultValue;
				extParam.GeneralParameterCode = generalParameterCode;
			    extParam.Grouping = grouping;
			    extParam.Sequence = sequence;
				if (newBO)
				{
					prov.AddBO(extParam);
				}
				else
				{
					prov.UpdateBO(extParam, false, false);
				}
			}
			finally
			{
				if (extParam != null)
					extParam.Dispose();
			}
		}


		/// <summary>
		/// Add/Update script workflow
		/// </summary>
		/// <param name="executionType">Type of the execution.</param>
		/// <param name="name">The name of the flow.</param>
		/// <param name="sourceFilePath">Name of the file.</param>
		/// <param name="sqlConn">The SQL conn.</param>
		private static void AddUpdateWorkflowScript(string executionType, string name, string sourceFilePath, PmxDbConnectionSql sqlConn)
		{
			PmxWorkflowProvider wfProvider = new PmxWorkflowProvider(sqlConn);
			PmxWorkflow workflow = wfProvider.GetWorkflowByName(name);
			PmxWorkflowScriptProvider wfscProvider = new PmxWorkflowScriptProvider(sqlConn);
			PmxWorkflowScript bo = null;
			if (workflow == null)
			{
				//add the workflow
				bo = wfscProvider.GetNewBO();
				bo.Name = name;
				wfscProvider.AddBO(bo);
			}
			else
			{
				if (workflow.ObjType == Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxWorkflowScript)
				{
					bo = wfscProvider.GetBO(workflow.InternalKey);

				}
			}

			if (bo != null)
			{
				bo.ExecutionType = executionType;

				wfscProvider.UpdateSourceFromFileAndCompile(bo, sourceFilePath, sqlConn);
			}
		}

		/// <summary>
		/// Runs the table SQL script.
		/// </summary>
		/// <param name="tableScript">The table script.</param>
		/// <param name="conn">The conn.</param>
		private static void RunTableSqlScript(string tableScript, PmxDbConnection conn)
		{
			string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.ProLaser.SboCommands)), "Produmex.Sbo.Logex.ProLaser.Scripts.Tables." + tableScript);
			SboRecordsetHelper.RunSqlScript(s_log, content, conn);
		}

		/// <summary>
		/// Adds the update user fields not in transaction.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="types">The types.</param>
		private static void AddUpdateUserFieldsNotInTransaction(SboConnection conn, params Type[] types)
		{
			SboUserFieldMDProvider userFieldMDProv = new SboUserFieldMDProvider(conn);
			userFieldMDProv.AddUpdateUserFields(types);
		}

		private static void AddUpdateReportType(SboConnection conn, string code, string name)
		{
			PmxReportType reportType = null;
			try
			{
				PmxReportTypeProvider rtProvider = new PmxReportTypeProvider(conn);
				reportType = rtProvider.GetBO(code);

				//Create new type if is it not found
				bool newType;
				if (reportType == null)
				{
					reportType = rtProvider.GetNewBO();
					newType = true;
				}
				else
				{
					newType = false;
				}

				//Set values
				reportType.Name = name;
				reportType.Code = code;
				//always locked when we make our own reportTypes
				reportType.Locked = true;

				//Add/update type
				if (newType)
				{
					rtProvider.AddBO(reportType);
				}
				else
				{
					rtProvider.UpdateBO(reportType, false, false);
				}
			}
			finally
			{
				if (reportType != null)
				{
					reportType.Dispose();
					reportType = null;
				}
			}
		}

		/// <summary>
		/// Runs the stored procedure SQL script.
		/// </summary>
		/// <param name="spScript">The sp script.</param>
		/// <param name="conn">The conn.</param>
		private static void RunStoredProcedureSqlScript(string spScript, PmxDbConnection conn)
		{
			string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.ProLaser.SboCommands)), "Produmex.Sbo.Logex.ProLaser.Scripts.StoredProcedures." + spScript);
			SboRecordsetHelper.RunSqlScript(s_log, content, conn);
		}

		/// <summary>
		/// Preprocesses the SQL script.
		/// </summary>
		/// <param name="query">The query.</param>
		/// <param name="conn">The connection.</param>
		/// <returns></returns>
		private static string PreprocessSqlScript(string query, PmxDbConnection conn)
		{
			string serverType;
			switch (conn.ConnectionStringObject.ServerType)
			{
				case SboServerType.HANA:
					serverType = "HANA";
					query = query.Replace("{DB-SCHEMA}", "\"" + conn.ConnectionStringObject.CompanyDBSchema.SchemaName + "\"");
								 
					break;
				default:
					serverType = "MSSQL";
					break;
			}

			int mssqlBlockBegin = query.IndexOf("--<?DB:");
			while (mssqlBlockBegin >= 0)
			{
				int mssqlBlockEnd = query.IndexOf("--?>", mssqlBlockBegin);
				if (mssqlBlockEnd < 0)
				{
					break;
				}

				if (query.Substring(mssqlBlockBegin + "--<?DB:".Length, serverType.Length) == serverType)
				{
					query = query.Substring(0, mssqlBlockBegin)
						  + query.Substring(mssqlBlockBegin + "--<?DB:".Length + serverType.Length, mssqlBlockEnd - mssqlBlockBegin - "--<?DB:".Length - serverType.Length)
						  + query.Substring(mssqlBlockEnd + "--?>".Length);
					mssqlBlockEnd -= "--<?DB:".Length + serverType.Length + "--?>".Length;
				}
				else
				{
					query = query.Substring(0, mssqlBlockBegin) + query.Substring(mssqlBlockEnd + "--?>".Length);
					mssqlBlockEnd = mssqlBlockBegin;
				}
				mssqlBlockBegin = query.IndexOf("--<?DB:", mssqlBlockEnd);
			}

			if (conn.ConnectionStringObject.ServerType == SboServerType.HANA)
			{
				int tokenPos = query.IndexOf("ISNULL(", StringComparison.OrdinalIgnoreCase);
				while (tokenPos >= 0)
				{
					int endPos = tokenPos + "ISNULL(".Length;
					query = query.Substring(0, tokenPos) + "IFNULL(" + query.Substring(endPos);
					tokenPos = query.IndexOf("ISNULL(", endPos, StringComparison.OrdinalIgnoreCase);
				}

				tokenPos = query.IndexOf("@");
				while (tokenPos >= 0)
				{
					if (query[tokenPos - 1] != '"' && Char.IsLetter(query[tokenPos + 1]))
					{
						query = query.Substring(0, tokenPos) + "p_" + query.Substring(tokenPos + 1);
					}
					tokenPos = query.IndexOf("@", tokenPos + 2);
				}
			}

			return query;
		}
	}
}
