﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Sbo.Logex.ProLaser.BusinessObjects.Definitions.Tables;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_AfterLogisticUnitFinishedPackingHookScript
{
	/// <summary>
	/// This is a hook script, meant to be customized on a "per project" basis
	/// </summary>
	public class WorkflowScript_AfterLogisticUnitFinishedPackingHookScript : WorkflowInstanceScriptBase
	{
	    private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

	    // Input parameters * do not change *
	    public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
	    public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
	    public ReadOnlyBinder<List<int>> LUIDs;
	    public ReadOnlyBinder<Collection<int>> ListOfPickListEntries;

		/// <summary>
		/// Initializes a new instance of the <see cref="WorkflowScript_AfterLogisticUnitFinishedPackingHookScript"/> class.
		/// </summary>
		/// <param name="parent">The parent.</param>
		/// <param name="factory">The factory.</param>
		public WorkflowScript_AfterLogisticUnitFinishedPackingHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
		    : base(parent, factory)
	    {
	    }

		private static class Definitions
		{
			//report definitions
			public const string REPORT_PATH_PROMO_CARD_REPORT = @"PromoCard.rpt";
			public const int NUMBER_OF_PROMO_CARD_REPORT = 1;
		}

		#region WorkflowInstanceScriptBase Members

		protected override void Execute()
	    {
			// Parameters in scope
			Session session = GetScopeParameter("Session") as Session;
			ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

			foreach (int luid in LUIDs.Get())
			{
				List<int> salesOrderDocEntries = GetSalesOrderDocEntriesWhichNeedPromoCardsByLuid(luid, sboProviderService);

				foreach (int salesOrderDocEntry in salesOrderDocEntries)
				{
					PrintPromoCardForSalesOrderDocEntry(salesOrderDocEntry, sboProviderService, session);
				}
			}
		}

		#endregion

		private List<int> GetSalesOrderDocEntriesWhichNeedPromoCardsByLuid(int luid, ISboProviderService sboProviderService)
		{
			List<int> result = new List<int>();

			string query = BuildQuery.GetSalesOrderDocEntriesWhichNeedPromoCardsByLuid(luid, sboProviderService);
			DataSet ds = sboProviderService.RunView(true, null, null, query);

			if (GetNumberOfRows(ds) > 0)
			{
				foreach (DataRow dataRow in ds.Tables[0].Rows)
				{
					result.Add(Convert.ToInt32(dataRow[PmxSalesOrderTablePL.Columns.DocEntry.NAME]));
				}
			}

			return result;
		}

		private static int GetNumberOfRows(DataSet ds)
		{
			if (ds != null && ds.Tables.Count > 0)
			{
				return ds.Tables[0].Rows.Count;
			}

			return 0;
		}

		private void PrintPromoCardForSalesOrderDocEntry(int salesOrderDocEntry, ISboProviderService sboProviderService, Session session)
	    {
			sboProviderService.InvokeMethodWithDbConnection<PmxOsePrinter>(false, false, null, null,
				delegate (PmxDbConnection conn, object[] parameters)
				{
					PmxPrintReportProvider prov = new PmxPrintReportProvider(conn);

					Collection<ReportParameter> reportParameters = new Collection<ReportParameter>();
					reportParameters.Add(new ReportParameter("@salesOrderDocEntry", salesOrderDocEntry));

					return prov.PrintReport(reportParameters, Definitions.REPORT_PATH_PROMO_CARD_REPORT, Definitions.NUMBER_OF_PROMO_CARD_REPORT, session.DeviceInstanceId, null, false);
				});
		}

		#region Query

		private static class BuildQuery
		{
			public static string GetSalesOrderDocEntriesWhichNeedPromoCardsByLuid(int logisticUnitId, ISboProviderService sboProviderService)
			{
				DbQueryBuilder qb = sboProviderService.GetDbTool().GetQueryBuilder();

				qb = qb.Select.Distinct
						.EscTableColumnName(PmxSalesOrderTablePL.NAME, PmxSalesOrderTablePL.Columns.DocEntry.NAME)
					.From
						.EscTableName(PmxLinkPickListLastMoveTable.NAME).WithNoLock
						.InnerJoin.EscTableName(PmxMoveLineTable.NAME).WithNoLock
							.On
									.EscTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveDocEntry.NAME)
									.Eq
									.EscTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DocEntry.NAME)
								.And
									.EscTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.MoveLineNum.NAME)
									.Eq
									.EscTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.LineNum.NAME)
						.InnerJoin.EscTableName(PmxPickListLineTable.NAME).WithNoLock
							.On
									.EscTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListDocEntry.NAME)
									.Eq
									.EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.DocEntry.NAME)
								.And
									.EscTableColumnName(PmxLinkPickListLastMoveTable.NAME, PmxLinkPickListLastMoveTable.Columns.PickListLineNum.NAME)
									.Eq
									.EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.LineNum.NAME)
						.InnerJoin.EscTableName(PmxPickListProposalLineTable.NAME).WithNoLock
							.On
									.EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.BaseEntry.NAME)
									.Eq
									.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.DocEntry.NAME)
								.And
									.EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.BaseLine.NAME)
									.Eq
									.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.LineNum.NAME)
						.InnerJoin.EscTableName(PmxSalesOrderTablePL.NAME).WithNoLock
							.On
									.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.BaseEntry.NAME)
									.Eq
									.EscTableColumnName(PmxSalesOrderTablePL.NAME, PmxSalesOrderTablePL.Columns.DocEntry.NAME)
					.Where
							.EscTableColumnName(PmxPickListProposalLineTable.NAME, PmxPickListProposalLineTable.Columns.BaseType.NAME)
							.Eq
							.String_(SboObjectTypeValues.SalesOrder)
						.And
							.EscTableColumnName(PmxSalesOrderTablePL.NAME, PmxSalesOrderTablePL.Columns.OrderType.NAME)
							.Eq
							.String_(PmxOrderTypePLColumnValues.PROMO.VALUE)
						.And
							.Append(" ( ")
									.EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.PickListLineStatus.NAME)
									.Eq
									.String_(PmxPickListStatusColumnValues.Packed.VALUE)
								.Or
									.EscTableColumnName(PmxPickListLineTable.NAME, PmxPickListLineTable.Columns.PickListLineStatus.NAME)
									.Eq
									.String_(PmxPickListStatusColumnValues.PartiallyPacked.VALUE)
							.Append(" ) ")
						.And
							.EscTableColumnName(PmxMoveLineTable.NAME, PmxMoveLineTable.Columns.DestinationLogisticUnitIdentificationKey.NAME)
							.Eq
							.Append(logisticUnitId);

				return qb.ToString();
			}
		}

		#endregion
	}
}
