using System.Collections.Generic;
using System.Globalization;
using System.Reflection;
using Produmex.Foundation.Collections;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.Providers;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_AfterPickListPackedHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_AfterPickListPackedHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<int> PickListDocEntry;
        public ReadWriteBinder<bool> DoAutomaticShipping;

        // Output parameters * do not change *
        public ReadWriteBinder<PmxDictionary<string, object>> DeliveryData;

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_AfterPickListPackedHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_AfterPickListPackedHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
        }

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

            //This line calls the IsPicklistForAutoShipping method, passes the picklist docentry as a parameter
            //and retrieves if the picklist needs to be shipped automatically based on the picklist type
            bool doAutomaticShipping = sboProviderService.InvokeMethodWithDbConnectionWithoutTransaction(false, true, null, null,
                IsPicklistForAutoShipping, PickListDocEntry.Get());

            //If the picklist needs to be shipped automatically based on the picklist type,
            //then the DoAutomaticShipping parameter will be set to true,
            //so the Packing flow will do the automatic shipping
            if (doAutomaticShipping) DoAutomaticShipping.Set(true);
        }

        //The list of picklist types which need to be shipped automatically
        //This list should be extended, if other picklist types needs to be shipped automatically
        private List<string> m_picklistTypesForAutoShip = new List<string>() { "DYN-B", "DYN-C" };

        //This method retrieves the picklist object based on the picklist docentry
        //and checks the picklist type to determine if the picklist needs to be shipped automatically
        private bool IsPicklistForAutoShipping(PmxDbConnection conn, object[] parameters)
        {
            PmxPickListProvider pickListProvider = new PmxPickListProvider(conn);
            //Retrieving the picklist based on the picklist docentry
            PmxPickList pickList = pickListProvider.GetBO((int)parameters[0]);

            //Checking the picklist type to determine if the picklist needs to be shipped automatically
            if (pickList != null && m_picklistTypesForAutoShip.Contains(pickList.PickListType))
            {
                return true;
            }
            else return false;
        }
    }
}
