//css_ref System.Data;
//css_ref System.Transactions;
//css_ref System.Xml;
//css_ref Interop.SAPbobsCOM.dll;
//css_ref log4net.dll;
//css_ref Produmex.Foundation.dll;
//css_ref Produmex.Foundation.Data.Sbo.dll;
//css_ref Produmex.Sbo.Logex.Data.dll;
//css_ref Produmex.Sbo.Logex.ServiceMetals.dll;

using System;
using System.Diagnostics;
using System.Reflection;
using System.Transactions;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Reflection;
using Produmex.Foundation.Resources;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.ServiceMetals.BusinessObjects;

namespace AddUpdateScript
{
	class Program
	{
		static string CONNECTION_STRING = "Server=DEV_SAP9_FR;CompanyDB=SBODemo_US_64;ExtraDb=PMX_SBODemo_US_64;UseTrusted=False;DbUserName=sa;DbPassword=B1Admin;UserName=manager;Password=produmex;Pooling=True;MinPoolSize=2;MaxPoolSize=10;ServerType=MSSQL2008;DBCultureInfo=en-US;LicenseServer=localhost:30000";

		/// <summary>
		/// Used for logging
		/// </summary>
		private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

		static void Main(string[] args)
		{
			try
			{
				LogProvider.SetConsoleAppender("WARN");
				Execute();
			}
			catch (Exception ex)
			{
				s_log.Error("", ex);
			}
			if (Debugger.IsAttached)
			{
				Console.WriteLine("Press <Enter>");
				Console.ReadLine();
			}
		}

		static void Execute()
		{

			using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
			{
				using (SboConnection conn = new SboConnection(CONNECTION_STRING))
				{
					conn.Open(); //Open connection to SAP
					Console.WriteLine("Connection is open to database");

					PmxDbVersionUpdaterProvider dbVersionProv = new PmxDbVersionUpdaterProvider(conn);

					Console.WriteLine("Creating UDFs");

					//Heat codes
					dbVersionProv.AddUpdateUserDefinedTable(typeof(PmxLinkPicklistLineHeatCodes));
					dbVersionProv.AddUpdateUserDefinedObject(typeof(PmxLinkPicklistLineHeatCodes));

				}

				//Complete transaction
				scope.Complete();
			}


			using (TransactionScope scope = PmxDbConnection.GetNewTransactionScope())
			{
				
				using (PmxDbConnectionHana conn = new PmxDbConnectionHana(CONNECTION_STRING))
				//using (PmxDbConnectionSql conn = new PmxDbConnectionSql(CONNECTION_STRING))
				{
					//conn.Open(); //Open connection to SAP
					Console.WriteLine("Connection is open to database");

					Console.WriteLine("Creating Tables");
				
					Console.WriteLine("Creating Views");
				
					Console.WriteLine("Creating Extensions");

				}
				scope.Complete();
				Console.WriteLine("Done ...");				
			}
		}

	

		/// <summary>
		/// Add/Update <see cref="PmxExtension"/>
		/// </summary>
		/// <param name="code">The code of the extension.</param>
		/// <param name="name">The name of the extension.</param>
		/// <param name="type">The type of the extension.</param>
		/// <param name="extensionTypeCode">The extension type code.</param>
		/// <param name="conn">The SBO connection</param>
		private static void AddUpdateExtension(string code, string name, Type type, string extensionTypeCode, PmxDbConnectionSql conn) // PmxDbConnectionHana conn)
		{
			PmxExtensionProvider prov = new PmxExtensionProvider(conn);
			PmxExtension extension = null;
			try
			{
				bool newBO = false;
				extension = prov.GetBO(code);
				if (extension == null)
				{
					newBO = true;
					extension = prov.GetNewBO();
					extension.Code = code;
				}
				extension.Name = name;
				extension.ExtensionTypeCode = extensionTypeCode;
				extension.Type = ReflectionHelper.GetTypeAndAssemblyName(type);
				if (newBO)
				{
					prov.AddBO(extension);
				}
				else
				{
					prov.UpdateBO(extension, false, false);
				}
			}
			finally
			{
				extension?.Dispose();
			}
		}

		/// <summary>
		/// Add/Update script workflow
		/// </summary>
		/// <param name="executionType">Type of the execution.</param>
		/// <param name="name">The name of the flow.</param>
		/// <param name="sourceFilePath">Name of the file.</param>
		/// <param name="sqlConn">The SQL conn.</param>
		private static void AddUpdateWorkflowScript(string executionType, string name, string sourceFilePath, PmxDbConnectionSql sqlConn)
		{
			PmxWorkflowProvider wfProvider = new PmxWorkflowProvider(sqlConn);
			PmxWorkflow workflow = wfProvider.GetWorkflowByName(name);
			PmxWorkflowScriptProvider wfscProvider = new PmxWorkflowScriptProvider(sqlConn);
			PmxWorkflowScript bo = null;
			if (workflow == null)
			{
				//add the workflow
				bo = wfscProvider.GetNewBO();
				bo.Name = name;
				wfscProvider.AddBO(bo);
			}
			else
			{
				if (workflow.ObjType == Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxObjectTypes.PmxWorkflowScript)
				{
					bo = wfscProvider.GetBO(workflow.InternalKey);

				}
			}

			if (bo != null)
			{
				bo.ExecutionType = executionType;

				wfscProvider.UpdateSourceFromFileAndCompile(bo, sourceFilePath, sqlConn);
			}
		}

		/// <summary>
		/// Runs the table SQL script.
		/// </summary>
		/// <param name="tableScript">The table script.</param>
		/// <param name="conn">The conn.</param>
		private static void RunTableSqlScript(string tableScript, PmxDbConnection conn)
		{
			string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.ServiceMetals.SboCommands)), "Produmex.Sbo.Logex.ServiceMetals.Scripts.Tables." + tableScript);
			SboRecordsetHelper.RunSqlScript(s_log, content, conn);
		}


		private static void RunTableOrViewSqlScript(string tableOrViewName, PmxDbConnection conn, bool isView)
		{
			Console.WriteLine("Add" + (isView ? " view " : " table ") + tableOrViewName);
			string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.ServiceMetals.SboCommands)), "Produmex.Sbo.Logex.ServiceMetals.Scripts." + (isView ? "Views." : "Tables.") + tableOrViewName + ".sql");
			SboRecordsetHelper.RunSqlScript(s_log, content, conn);
		}

		/// <summary>
		/// Runs the view SQL script.
		/// </summary>
		/// <param name="viewScript">The view script.</param>
		/// <param name="conn">The conn.</param>
		private static void RunViewSqlScript(string viewScript, PmxDbConnection conn)
		{
			string content = PreprocessSqlScript(ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.ServiceMetals.SboCommands)), "Produmex.Sbo.Logex.ServiceMetals.Scripts.Views." + viewScript), conn);
			s_log.DebugFormat("content: {0}",content);
			SboRecordsetHelper.RunSqlScript(s_log, content, conn);
		}
		/// <summary>
		/// Adds the update user fields not in transaction.
		/// </summary>
		/// <param name="conn">The conn.</param>
		/// <param name="types">The types.</param>
		private static void AddUpdateUserFieldsNotInTransaction(SboConnection conn, params Type[] types)
		{
			SboUserFieldMDProvider userFieldMDProv = new SboUserFieldMDProvider(conn);
			userFieldMDProv.AddUpdateUserFields(types);
		}

		private static void AddUpdateReportType(SboConnection conn, string code, string name)
		{
			PmxReportType reportType = null;
			try
			{
				PmxReportTypeProvider rtProvider = new PmxReportTypeProvider(conn);
				reportType = rtProvider.GetBO(code);

				//Create new type if is it not found
				bool newType;
				if (reportType == null)
				{
					reportType = rtProvider.GetNewBO();
					newType = true;
				}
				else
				{
					newType = false;
				}

				//Set values
				reportType.Name = name;
				reportType.Code = code;
				//always locked when we make our own reportTypes
				reportType.Locked = true;

				//Add/update type
				if (newType)
				{
					rtProvider.AddBO(reportType);
				}
				else
				{
					rtProvider.UpdateBO(reportType, false, false);
				}
			}
			finally
			{
				if (reportType != null)
				{
					reportType.Dispose();
					reportType = null;
				}
			}
		}

		/// <summary>
		/// Runs the stored procedure SQL script.
		/// </summary>
		/// <param name="spScript">The sp script.</param>
		/// <param name="conn">The conn.</param>
		private static void RunStoredProcedureSqlScript(string spScript, PmxDbConnection conn)
		{
			string content = ResourceHelper.ReadResourceContentAsString(Assembly.GetAssembly(typeof(Produmex.Sbo.Logex.ServiceMetals.SboCommands)), "Produmex.Sbo.Logex.ServiceMetals.Scripts.StoredProcedures." + spScript);
			SboRecordsetHelper.RunSqlScript(s_log, content, conn);
		}

		/// <summary>
		/// Preprocesses the SQL script.
		/// </summary>
		/// <param name="query">The query.</param>
		/// <param name="conn">The connection.</param>
		/// <returns></returns>
		private static string PreprocessSqlScript(string query, PmxDbConnection conn)
		{
			string serverType;
			switch (conn.ConnectionStringObject.ServerType)
			{
				case SboServerType.HANA:
					serverType = "HANA";
					query = query.Replace("{DB-SCHEMA}", "\"" + conn.ConnectionStringObject.CompanyDBSchema.SchemaName + "\"");
					break;
				default:
					serverType = "MSSQL";
					break;
			}

			serverType = "HANA";
			query = query.Replace("{DB-SCHEMA}", "\"" + conn.ConnectionStringObject.CompanyDBSchema.SchemaName + "\"");

			int mssqlBlockBegin = query.IndexOf("--<?DB:");
			while (mssqlBlockBegin >= 0)
			{
				int mssqlBlockEnd = query.IndexOf("--?>", mssqlBlockBegin);
				if (mssqlBlockEnd < 0)
				{
					break;
				}

				if (query.Substring(mssqlBlockBegin + "--<?DB:".Length, serverType.Length) == serverType)
				{
					query = query.Substring(0, mssqlBlockBegin)
						  + query.Substring(mssqlBlockBegin + "--<?DB:".Length + serverType.Length, mssqlBlockEnd - mssqlBlockBegin - "--<?DB:".Length - serverType.Length)
						  + query.Substring(mssqlBlockEnd + "--?>".Length);
					mssqlBlockEnd -= "--<?DB:".Length + serverType.Length + "--?>".Length;
				}
				else
				{
					query = query.Substring(0, mssqlBlockBegin) + query.Substring(mssqlBlockEnd + "--?>".Length);
					mssqlBlockEnd = mssqlBlockBegin;
				}
				mssqlBlockBegin = query.IndexOf("--<?DB:", mssqlBlockEnd);
			}

			if (serverType == "HANA")
			{
				int tokenPos = query.IndexOf("ISNULL(", StringComparison.OrdinalIgnoreCase);
				while (tokenPos >= 0)
				{
					int endPos = tokenPos + "ISNULL(".Length;
					query = query.Substring(0, tokenPos) + "IFNULL(" + query.Substring(endPos);
					tokenPos = query.IndexOf("ISNULL(", endPos, StringComparison.OrdinalIgnoreCase);
				}

				tokenPos = query.IndexOf("@");
				while (tokenPos >= 0)
				{
					if (query[tokenPos - 1] != '"' && Char.IsLetter(query[tokenPos + 1]))
					{
						query = query.Substring(0, tokenPos) + "p_" + query.Substring(tokenPos + 1);
					}
					tokenPos = query.IndexOf("@", tokenPos + 2);
				}
			}

			return query;
		}
	}
}
