﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Transactions;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.GS1;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.DataObjects;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Utilities;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo;
using Produmex.Foundation.Wwf.Sbo.DataObjects;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Devices;
using Produmex.Sbo.Logex.Data.Generators.BatchNumberGenerators;
using Produmex.Sbo.Logex.Data.Generators.PackingController;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Foundation.Data.Sbo.Generators.BarcodeController;
using Produmex.Sbo.Logex.ServiceMetals.Providers;

namespace Produmex.Sbo.Logex.WorkflowScripts
{
    public class WorkflowScript_AfterItemPickedHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;

        public ReadOnlyBinder<Collection<PickingItemInfo>> PickedItemInfos;
        public ReadOnlyBinder<int?> LUID;
        public ReadOnlyBinder<Collection<string>> ListOfSerialNumbers;
        public ReadOnlyBinder<int> DocEntry;
        public ReadOnlyBinder<string> ObjType;

        // Sub-flows
        // <none>

        public DataSet dsLinkedHeatCodes;
        static class Definitions
        {
            /// <summary>
            /// Seperator
            /// </summary>
			public const string VIEW_NAME = "PMX_V33_Itemcode_HeatCodes";

            public const string VIEW_COLUMN_ITEMCODE = "ItemCode";

            public const string VIEW_COLUMN_HEATCODE = "HeatCode";
            public const string VIEW_COLUMN_CONFIRMATION = "Confirmation";

            public const string MSG_BUTTON_OTHER_TASK = "List";
            public const string MSG_TITLE_SELECT_HEATCODE = "Select Heat Code";


            public const string MSG_TITLE_CONFIRMATION = "Confirmation";
            public const string MSG_QUESTION_COFIRMATON = "Are you sure you want to save this list?";

            public const string MSG_TITLE_LINKED_HEAT_CODE = "Linked heat code";
            public const string MSG_ERROR_HEAT_CODE_IN_LIST = "Heat code already in list";
            public const string MSG_TITLE_ENTER_CREDENTIALS = "Authorizations: Enter username and PIN code";
            public const string MSG_ERROR_NOT_AUTHORIZATED = "You are not authorized to add an NF heat code. Try again?";
            public const string MSG_ERROR_WRONG_PIN_CODE = "Wrong PIN code";
            public const string MSG_ERROR_MISSING_USER_OR_PIN_CODE = "Missing username or PIN code";
            public const string MSG_ERROR_INVALID_USER = "Invalid username";

        }

        public WorkflowScript_AfterItemPickedHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
            : base(parent, factory)
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            //Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;
            IBarcodeController barcodeController = null;
            string initialErrorKey = null;
            object[] initialErrorParams = null;
            bool confirmation = false;
            Message msg = null;
            DataSet ds = null;
            DataSet dsLogin = null;
            string heatCode = null;
            List<string> HeatCodes = null;

            int docEntry = DocEntry.Get();
            Collection<PickingItemInfo> itemInfos = PickedItemInfos.Get();
            PickingItemInfo itemInfo = itemInfos[0];


            //query to view
            string query = String.Format("SELECT \"{0}\" as \"{1}\" ,\"{0}\" as \"{2}\",'' as \"{3}\", \"{6}\" fROM {4} WHERE \"{5}\" = '{7}'",
                Definitions.VIEW_COLUMN_HEATCODE,
                ProductDataSet.Columns.PRODUCT_CODE.Name,
                ProductDataSet.Columns.PRODUCT_DESCRIPTION.Name,
                ProductDataSet.Columns.GTIN.Name,
                Definitions.VIEW_NAME,
                Definitions.VIEW_COLUMN_ITEMCODE,
                Definitions.VIEW_COLUMN_CONFIRMATION,
                itemInfo.ItemCode);
            ds = sboProviderService.RunView(false, null, null, query);

            dsLinkedHeatCodes = GetNewSerialNumberDataSet();

            //nothing in the view skip this hookscript
            if (GetNumberOfRows(ds) == 0) return;


            DataRow dr = ds.Tables[0].Rows[0];
            confirmation = (dr[Definitions.VIEW_COLUMN_CONFIRMATION].ToString() == SboBooleanColumnValues.Y.VALUE);


        Step_ShowHeatCodes:
            #region SHOW HEAT CODES

            // Show screen with list
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", Definitions.MSG_TITLE_SELECT_HEATCODE,
                    "ProductDS", ds,
                    "AllowNoSelection", true,
                    "ButtonKey", Definitions.MSG_BUTTON_OTHER_TASK));
            msg = WaitForMessage();

            initialErrorKey = null;

            if (msg.Name.EndsWith(".StopRequested"))
            {
                //confirmation
            }

            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                goto Step_ShowList;
            }
            if (!msg.Name.EndsWith(".ProductSelected"))
            {
                initialErrorKey = KnownMessageKeys.MSG_ERROR_OPERATION_NOT_SUPPORTED;
                //goto Step_SelectLogisticCarrier;
            }

            heatCode = ExtractParameter<string>(msg.Parameters, "itemCode");
            if (heatCode != null)
            {
                DataRow[] rows = dsLinkedHeatCodes.Tables[0].Select(string.Format("{0} = '{1}'", SerialNumberDataSet.Columns.SERIALNUMBER.Name, heatCode));
                if (rows.Length > 0)
                {
                    initialErrorKey = Definitions.MSG_ERROR_HEAT_CODE_IN_LIST;
                }
                else
                {
                    AddHeatCodeToDataSet(heatCode, out dsLinkedHeatCodes);
                }

                goto Step_ShowHeatCodes;
            }

            goto Step_ShowHeatCodes;




        #endregion

        Step_ShowList:
            #region SHOW LIST
            //show all linked serial numbers
            session.ShowCustomizedScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IIdentifyMultipleSerialNumberScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "InitialErrorParams", initialErrorParams,
                    "InitialErrorKeyIsError", false,
                    "TitleKey", Definitions.MSG_TITLE_LINKED_HEAT_CODE,
                    "BarcodeController", barcodeController,
                    "SerialNumberDS", dsLinkedHeatCodes,
                    "ItemDescription", itemInfo.ItemDescription,
                    "ItemCode", itemInfo.ItemCode,
                    "ItemBarcode", itemInfo.ItemBarcode,
                    "UOM", itemInfo.Uom,
                    "BatchNumber", itemInfo.BatchNumber,
                    "BestBeforeDate", itemInfo.BestBeforeDate,
                    "SSCC", itemInfo.SSCC,
                    "DocNum", docEntry.ToString(),
                    "StillToQuantity", -1,
                    "MessageKeyStillQuantity", null,
                    "UseSerialNumberRange", false,
                    "OnlyShowList", false,
                    "UseUppercase", false
                    ),
                WorkflowId,
                nameof(EnterQuantityScript_Screens.IdentifyMultipleSerialNumberScreen4));
            msg = WaitForMessage();


            if (msg.Name.EndsWith(".StopRequested"))
            {
                //confirmation
            }
            if (msg.Name.EndsWith(".BackRequested"))
            {
                goto Step_ShowHeatCodes;
            }

            if (msg.Name.EndsWith(".ForwardRequested"))
            {
                goto Step_CrendentialCheck;
            }
            if (msg.Name.EndsWith(".DeleteSerialNumber"))
            {
                string heatCodeToDelete = ExtractParameter<string>(msg.Parameters, "serialNumber");
                DataRow[] rows = dsLinkedHeatCodes.Tables[0].Select(string.Format("{0} = '{1}'", SerialNumberDataSet.Columns.SERIALNUMBER.Name, heatCodeToDelete));
                foreach (DataRow row in rows)
                {
                    dsLinkedHeatCodes.Tables[0].Rows.Remove(row);
                }
                dsLinkedHeatCodes.AcceptChanges();
                goto Step_ShowList;
            }

            if (msg.Name.EndsWith(".SerialNumberScanned"))
            {
                string heatCodeToAdd = ExtractParameter<string>(msg.Parameters, "serialNumber");
                DataRow[] rowsLinkedHeatCodes = dsLinkedHeatCodes.Tables[0].Select(string.Format("{0} = '{1}'", SerialNumberDataSet.Columns.SERIALNUMBER.Name, heatCodeToAdd));
                DataRow[] rows = ds.Tables[0].Select(string.Format("{0} = '{1}'", ProductDataSet.Columns.PRODUCT_CODE.Name, heatCodeToAdd));

                if (rowsLinkedHeatCodes.Length > 0)
                {
                }
                else if (rows.Length > 0)
                {
                    AddHeatCodeToDataSet(rows[0][ProductDataSet.Columns.PRODUCT_CODE.Name].ToString(), out dsLinkedHeatCodes);
                }
                else
                {
                    AddHeatCodeToDataSet("NF " + heatCodeToAdd, out dsLinkedHeatCodes);
                }
                goto Step_ShowList;
            }


        #endregion

        Step_CrendentialCheck:
            #region Check credentials

            string userName = null;
            string userPin = null;
            int? supervisor = null;

            DataRow[] rowsLinkedHeatCodesWithPrefix = dsLinkedHeatCodes.Tables[0].Select(string.Format("{0} like  '{1} %'", SerialNumberDataSet.Columns.SERIALNUMBER.Name, "NF"));
            if (rowsLinkedHeatCodesWithPrefix.Length == 0)
            {
                goto Step_ShowConfirmation;
            }

            try
            {

            Step_GetUserPINCode:

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ILogonScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "DefaultUserName", "",
                        "TitleKey", Definitions.MSG_TITLE_ENTER_CREDENTIALS,
                        "IsForCredentialCheck", true));
                msg = WaitForMessage();

                userName = ExtractParameter<string>(msg.Parameters, "UserName");
                userPin = ExtractParameter<string>(msg.Parameters, "Password");

                if (msg.Name.EndsWith(".BackRequested"))
                {
                    goto Step_ShowList;
                }
                if (string.IsNullOrEmpty(userName) || string.IsNullOrEmpty(userPin))
                {
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            this.DefaultCultureInfo, BuildParamCollection(
                            "MessageKey", Definitions.MSG_ERROR_MISSING_USER_OR_PIN_CODE,
                            "ShowButton", true));
                    WaitForMessage();
                    goto Step_GetUserPINCode;
                }

                //check if admin

                StringBuilder qry = new StringBuilder();
                qry.AppendFormat("SELECT {0}, {1}, {2} FROM {3} WHERE {4} = \'{5}\'",
                    SqlCommandHelper.EscapeTableColumnName(PmxUserTable.NAME, PmxUserTable.Columns.PmxUserPin.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxUserTable.NAME, PmxUserTable.Columns.PmxUserGroup.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxUserTable.NAME, PmxUserTable.Columns.UserId.NAME),
                    SqlCommandHelper.EscapeTableName(PmxUserTable.NAME),
                    SqlCommandHelper.EscapeTableColumnName(PmxUserTable.NAME, PmxUserTable.Columns.UserCode.NAME),
                    userName);

                DataSet checkedUser = sboProviderService.RunView(false, null, null, qry.ToString());
                if (GetNumberOfRows(checkedUser) == 0)
                {
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        this.DefaultCultureInfo, BuildParamCollection(
                        "MessageKey", Definitions.MSG_ERROR_INVALID_USER,
                        "ShowButton", true));
                    WaitForMessage();
                    goto Step_GetUserPINCode;
                }

                string checkedPin = checkedUser.Tables[0].Rows[0][PmxUserTable.Columns.PmxUserPin.NAME].ToString();
                string checkedUserGroup = checkedUser.Tables[0].Rows[0][PmxUserTable.Columns.PmxUserGroup.NAME].ToString();

                if (checkedUserGroup != "01_ADMIN")
                {
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_RETRY_UPDATE",
                        "MessageKey", Definitions.MSG_ERROR_NOT_AUTHORIZATED));
                    msg = WaitForMessage();

                    if (msg.Name.ToLower().EndsWith(".yes"))
                    {
                        goto Step_CrendentialCheck;
                    }
                    goto Step_ShowList;
                }

                if (checkedPin != userPin)
                {
                    userName = null;
                    supervisor = null;

                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        this.DefaultCultureInfo, BuildParamCollection(
                        "MessageKey", Definitions.MSG_ERROR_WRONG_PIN_CODE,
                        "ShowButton", true));
                    WaitForMessage();
                    goto Step_GetUserPINCode;
                }

                supervisor = Convertor.ConvertToInt32Nullable(checkedUser.Tables[0].Rows[0][PmxUserTable.Columns.UserId.NAME]);
                goto Step_ShowConfirmation;
            }
            catch (ProdumexException px)
            {
                userName = null;
                supervisor = null;

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            this.DefaultCultureInfo, BuildParamCollection(
                            "PmxError", px.Error,
                            "ShowButton", true));
                WaitForMessage();
                goto Step_ShowList;
            }
            catch (Exception ex)
            {
                userName = null;
                supervisor = null;

                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            this.DefaultCultureInfo, BuildParamCollection(
                            "TitleKey", "Error",
                            "MessageKey", ex.Message,
                            "NoTranslationOfMessageKey", true,
                            "ShowButton", true));
                WaitForMessage();
                goto Step_ShowList;
            }

        #endregion

        Step_ShowConfirmation:
            #region SHOW CONFIRMATION

            if (confirmation)
            {
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                           DefaultCultureInfo.Get(), BuildParamCollection(
                               "TitleKey", Definitions.MSG_TITLE_CONFIRMATION,
                               "MessageKey", Definitions.MSG_QUESTION_COFIRMATON));
                msg = WaitForMessage();

                if (msg.Name.ToLower().EndsWith(".yes"))
                {
                    goto Step_SaveHeatCodes;
                }

                goto Step_ShowHeatCodes;
            }
            goto Step_SaveHeatCodes;

        #endregion

        Step_SaveHeatCodes:
            #region SAVE HEAT CODES
            foreach (DataRow row in dsLinkedHeatCodes.Tables[0].Rows)
            {
                sboProviderService.InvokeMethodWithDbConnection<object>(true, false, null, null,
                   delegate (PmxDbConnection conn, object[] parameters)
                   {
                       PmxHeatCodeProvider prov = new PmxHeatCodeProvider((SboConnection)conn);
                       prov.AddDocumentLinkToHeatCode(row[SerialNumberDataSet.Columns.SERIALNUMBER.Name].ToString(), ObjType.Get(), itemInfo.PickListDocEntry, itemInfo.PickListLineID, supervisor);

                       return null;
                   });
            }

            #endregion
        }

        #endregion
        #region HELPERS

        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null &&
                ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }

            return 0;
        }

        /// <summary>
        /// Gets the new Serial number data set.
        /// </summary>
        /// <returns></returns>
        private DataSet GetNewSerialNumberDataSet()
        {
            DataSet ds = new DataSet();
            ds.Tables.Add(SerialNumberDataSet.NAME);

            foreach (ColumnDefinition colDef in SerialNumberDataSet.Columns.ALL)
            {
                ds.Tables[0].Columns.Add(colDef.Name, colDef.Types[0]);
            }

            return ds;

        }

        /// <summary>
        /// Gets the new Serial number data set.
        /// </summary>
        /// <returns></returns>
        private void AddHeatCodeToDataSet(string heatCode, out DataSet dsHeatCodes)
        {
            dsHeatCodes = dsLinkedHeatCodes;
            DataRow rowToAdd = dsHeatCodes.Tables[0].NewRow();
            rowToAdd[SerialNumberDataSet.Columns.SERIALNUMBER.Name] = heatCode;
            rowToAdd[SerialNumberDataSet.Columns.INFO1.Name] = "";
            rowToAdd[SerialNumberDataSet.Columns.INFO2.Name] = "";
            rowToAdd[SerialNumberDataSet.Columns.IS_SCANNED.Name] = SboBooleanColumnValues.N.VALUE;

            dsHeatCodes.Tables[0].Rows.Add(rowToAdd);



        }

        #endregion

        #region BUILD QUERY

        internal static class BuildQuery
        {
        }

        #endregion
    }


}
