CREATE PROCEDURE [dbo].[PMX_SP_DeliveryDocumentWBE_Odette] 
	-- Parameters for the stored procedure
	@salesDeliveryNoteDocEntry int = 0


AS
BEGIN
    
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;

	SELECT ODLN.DocNum, ODLN.NumAtCard as "NumAtCard", ORDR.DocDueDate as "DocDate",
				RDR1.U_GT_ExtraInfo1 as "Division", RDR1.U_GT_ExtraInfo2 as "VendorCode", RDR1.U_GT_ExtraInfo3 as "ItemCustomDescription",
				RDR1.U_GT_ExtraInfo4 as "Location", RDR1.U_GT_ExtraInfo5 as "ShopOrderNumber",
				ODLN."CardCode", ODLN."CardName", ORDR."ShipToCode", ODLN.Address2 as "ShipToAddress",
                DLN1."ItemCode", DLN1."Dscription", CASE WHEN LEN(ISNULL(DLN1.SubCatNum,'')) <= 0 THEN OSCN.Substitute ELSE DLN1.SubCatNum END as CatalogNo,
                CASE WHEN PMX_SENU."SerialNumber" IS NULL THEN ABS(DLN1."Quantity") ELSE 1 END as Quantity, DLN1."UomCode", 
                PMX_SENU.SerialNumber,
				(CASE WHEN PMX_SENU."SerialNumber" IS NULL THEN ABS(DLN1."Quantity") ELSE 1 END * OITM.SWeight1 * OWGT.WightInMG) / 1000000 as "GrossWeightKG",
				(CASE WHEN PMX_SENU."SerialNumber" IS NULL THEN ABS(DLN1."Quantity") ELSE 1 END * OITM.U_NtWeight) as "NetWeightKG"
	FROM DLN1
	INNER JOIN ODLN ON ODLN.DocEntry = DLN1.DocEntry
	INNER JOIN RDR1 ON RDR1.DocEntry = DLN1.BaseEntry and RDR1.LineNum = DLN1.BaseLine and RDR1.ObjType = DLN1.BaseType
	INNER JOIN ORDR ON ORDR.DocEntry = DLN1.BaseEntry and ORDR.ObjType = DLN1.BaseType
	INNER JOIN OITM ON OITM.ItemCode = DLN1.ItemCode
	LEFT JOIN OWGT ON OITM.SWght1Unit = OWGT.UnitCode
	LEFT JOIN PMX_SELD ON PMX_SELD.BaseEntry = DLN1.DocEntry AND PMX_SELD.BaseLine = DLN1.LineNum AND PMX_SELD.BaseType = '15'
	LEFT JOIN PMX_SENU ON PMX_SENU.InternalKey = PMX_SELD.SerialKey
	LEFT JOIN OSCN ON OSCN.CardCode = ODLN.CardCode and OSCN.ItemCode = DLN1.ItemCode
	WHERE DLN1.DocEntry = @salesDeliveryNoteDocEntry


END
