USE [WIB_4005_QA_PMX]
GO

/****** Object:  StoredProcedure [dbo].[PMX_SP_PacklingListWEG]    Script Date: 29/02/2016 08:20:32 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[PMX_SP_PacklingListWEG] 
	@salesDeliveryNoteDocEntry INT


AS
BEGIN
    
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	

SELECT	PMX_LUID.SSCC, 
		ODLN."DocEntry", ODLN."DocNum" AS DeliveryDocNum, ODLN."CardName", ODLN."Address2" AS Address, ODLN."DocDate",
		ISNULL( ORDR."ObjType", OINV."ObjType" ) AS DocType, ISNULL( ORDR."DocNum", OINV."DocNum" ) AS DocNum,
		DLN1."ItemCode", DLN1."Dscription", 
		COALESCE(RDR1."Quantity", INV1."Quantity", 0) AS OrderQuantity, SUM(PMX_INVD."Quantity") * - 1 AS DeliveredQuantity, 
		PMX_ITRI."BatchNumber" AS BatchNum, PMX_ITRI."BestBeforeDate", PMX_LUID."Weight", PMX_LUID."Length", PMX_LUID."Width", PMX_LUID."Height",
		ODLN."DocDueDate", OCPR."E_MailL" as 'ContactpersonEmail', ISNULL([@GT_CALT]."Name", '') as 'Transporter'
FROM        DLN1
INNER JOIN	ODLN ON DLN1."DocEntry" = ODLN."DocEntry"
INNER JOIN  PMX_INVD ON ODLN."ObjType" = PMX_INVD."TransType" AND DLN1."DocEntry" = PMX_INVD."DocEntry" AND DLN1."LineNum" = PMX_INVD."DocLineNum"
INNER JOIN  PMX_LUID ON PMX_INVD."LogUnitIdentKey" = PMX_LUID."InternalKey"
LEFT  JOIN  PMX_ITRI ON PMX_ITRI."InternalKey" = PMX_INVD."ItemTransactionalInfoKey"
LEFT  JOIN  ORDR
	INNER JOIN RDR1 ON ORDR."DocEntry" = RDR1."DocEntry"
ON DLN1."BaseType" = ORDR."ObjType" AND DLN1."BaseEntry" = RDR1."DocEntry" AND DLN1."BaseLine" = RDR1."LineNum"
LEFT  JOIN  OINV
	INNER JOIN  INV1 ON INV1."DocEntry" = OINV."DocEntry"
ON DLN1."BaseType" = INV1."ObjType" AND DLN1."BaseEntry" = INV1."DocEntry" AND DLN1."BaseLine" = INV1."LineNum"
LEFT JOIN OCPR ON ODLN."CntctCode" = OCPR."CntctCode" and OCPR."CardCode" = ODLN."CardCode"
LEFT JOIN [@GT_CALT] ON [@GT_CALT]."Code" = ODLN."U_GT_Carrier"
WHERE    ODLN."DocEntry" = @salesDeliveryNoteDocEntry
GROUP BY PMX_LUID.SSCC,
		 ODLN."DocEntry", ODLN."DocNum", ODLN."CardName", ODLN."Address2", ODLN."DocDate", 
		 ORDR."ObjType", OINV."ObjType", ORDR."DocNum", OINV."DocNum", 
 		 DLN1."ItemCode", DLN1."Dscription", 
		 RDR1."Quantity", INV1."Quantity",
		 PMX_ITRI."BestBeforeDate", PMX_ITRI."BatchNumber",
		 PMX_LUID."Weight", PMX_LUID."Length", PMX_LUID."Width", PMX_LUID."Height",
		 ODLN."DocDueDate", OCPR."E_MailL", [@GT_CALT]."Name";

END


GO


