CREATE PROCEDURE [dbo].[PMX_SP_ShippingLabelWBE_Odette] 
	-- Parameters for the stored procedure
	@luid int = 0


AS
BEGIN
    
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;

	declare @list table
	(
		sscc nvarchar (18),
		gtin nvarchar (16),
		ProductDescription nvarchar(100),
		quantity nvarchar(50),
		batchNumber nvarchar (32),
		bestBeforeDate nvarchar(50),
		SSCCBarcode nvarchar (100),
		SSCCBarcodeDigit nvarchar (100),
		GTINBarcode nvarchar (200),
		GTINBarcodeDigit nvarchar (200),
		purchaseDocObjType nvarchar(20),
		purchaseDocNum nvarchar(50),
		supplierName nvarchar (100),
		supplierAddress nvarchar (254),
		receptionDate nvarchar(50),
		GTINLabel nvarchar (20),
		PackagingTypeText nvarchar (max),
		QuantityByPackagingTypeText nvarchar (max),
		BatchNumber2 nvarchar(32) ,
		LocationCode nvarchar(50) ,
		itemCode nvarchar (20)
	);

	--Declare return variables
	DECLARE @returnSSCC [nvarchar](18)
	DECLARE @returnGTIN AS [nvarchar] (16) 
	DECLARE @returnLogisticCarrierCode AS [nvarchar] (20)  
	DECLARE @returnItemCode AS [nvarchar](20) 
	DECLARE @returnProductDescription AS [nvarchar](100) 
	DECLARE @returnQuantity AS [numeric](19,6) 
	DECLARE @returnIsLogisticUnit AS [nvarchar](1) 
	DECLARE @returnBatchNumber AS [nvarchar](32) 
	DECLARE @returnBestBeforeDate AS [datetime]
	DECLARE @returnSSCCBarcode AS [nvarchar] (100)
	DECLARE @returnSSCCBarcodeDigit AS [nvarchar] (100)
	DECLARE @returnGTINBarcode AS [nvarchar] (200)
	DECLARE @returnGTINBarcodeDigit AS [nvarchar] (200)
 	DECLARE @returnBarcodeType AS [nvarchar] (1)
	DECLARE @returnGTINLabel AS [nvarchar] (20)
	DECLARE @returnPackagingTypeText AS [nvarchar] (max)
	DECLARE @returnQuantityByPackagingTypeText AS [nvarchar] (max)
	DECLARE @returnBatchNumber2 AS [nvarchar](32) 
	DECLARE @returnLocationCode AS [nvarchar](50) 


	--Getting the PO info
	--Declare variables for the cursor
	DECLARE @PurchaseDocNum AS [int]
	DECLARE @SupplierName AS [nvarchar] (100) 
	DECLARE @SupplierAddress AS [nvarchar] (254)  
	DECLARE @ReceptionDate AS [datetime] 


	--Declare variables for product
	DECLARE @GTIN AS [nvarchar] (16) 
	DECLARE @LogisticCarrierCode AS [nvarchar] (20)  
	DECLARE @ProductDescription AS [nvarchar](100) 
	DECLARE @IsLogisticCarrier AS [nvarchar](1) 
	DECLARE @BarcodeType AS [nvarchar] (1)
	DECLARE @TempPackagingTypeText AS [nvarchar] (max)
	DECLARE @TempQuantityByPackagingTypeText AS [nvarchar] (max)


	DECLARE @weightDecimals AS INT
	DECLARE @weightAI AS [nvarchar](3) 
	DECLARE @tempWeightDecimals AS INT
	DECLARE @tempWeightAI AS [nvarchar](3) 
	DECLARE @tempQuantityUom2 AS [numeric](19,6) 

	DECLARE @sscc nvarchar (18)
	DECLARE @itemCode nvarchar (20)
	DECLARE @quantity numeric (19,6)
	DECLARE @bestBeforeDate datetime
	DECLARE @batchNumber nvarchar (32)
	DECLARE @purchaseDocObjType nvarchar(20)
	DECLARE @purchaseDocEntry int
	DECLARE @cardCode nvarchar (15)
	DECLARE @packagingTypeText nvarchar(max)
	DECLARE @quantityByPackagingTypeText nvarchar(max)
	DECLARE @locationCode nvarchar (50)
	DECLARE @batchNumber2 nvarchar (32)
	DECLARE @quantityUom2 numeric (19,6)
	DECLARE @internalLuid int

		--Declare memory table for storing the products on an sscc
		DECLARE @productsTable TABLE (
			[SSCC] [nvarchar] (18) NOT NULL ,
			[GTIN] [nvarchar] (16) NULL ,
			[LogisticCarrierCode] [nvarchar] (20) NULL ,
			[ItemCode] [nvarchar](20) NULL ,
			[ProductDescription] [nvarchar](100) NULL,
			[Quantity] [numeric](19,6) NULL,
			[IsLogisticCarrier] [nvarchar](1) NULL,
			[BatchNumber] [nvarchar](32) NULL,
			[BestBeforeDate] [datetime] NULL,
			[BarcodeType] [nvarchar](1) NULL,
			[PackagingTypesText] nvarchar(max) NULL,
			[QuantityByPackagingTypeText] nvarchar(max) NULL,
			[BatchNumber2] [nvarchar](32) NULL,
			[LocationCode] [nvarchar](50) NULL,
			[QuantityUom2] [numeric](19,6) NULL,
			[Uom2Decimals] int NULL,
			[Uom2AI] nvarchar(3)

		)

		-- Insert the products into an in memory table
		INSERT into @productsTable
			SELECT SSCC, Barcode, LogisticCarrierCode, PMX_SSCC_GOODSRECEIPT_LABEL.ItemCode, ISNULL(ProductDescription, 
			PMX_SSCC_GOODSRECEIPT_LABEL.ItemCode) AS ProductDescription, Quantity , IsLogisticCarrier, BatchNumber, BestBeforeDate,
			ISNULL(U_PMX_BCTY,'G') AS BarcodeType, dbo.PMX_FN_GetPackagingTypesText(PMX_SSCC_GOODSRECEIPT_LABEL.ItemCode, PMX_SSCC_GOODSRECEIPT_LABEL.ItemTransactionalInfoKey, PMX_SSCC_GOODSRECEIPT_LABEL.Quantity, 'B'),
			dbo.PMX_FN_GetQuantityByPackagingTypesText(PMX_SSCC_GOODSRECEIPT_LABEL.ItemCode, PMX_SSCC_GOODSRECEIPT_LABEL.ItemTransactionalInfoKey),
			PMX_SSCC_GOODSRECEIPT_LABEL.InternalBatchNumber, PMX_SSCC_GOODSRECEIPT_LABEL.StorLocCode,
			dbo.PMX_SSCC_GOODSRECEIPT_LABEL.QuantityUom2, U_PMX_UM2D, U_PMX_U2MT+'0'		
			FROM dbo.PMX_SSCC_GOODSRECEIPT_LABEL INNER JOIN dbo.OITM ON dbo.OITM.ItemCode = dbo.PMX_SSCC_GOODSRECEIPT_LABEL.ItemCode
			WHERE "LogUnitIdentKey" = @luid
			ORDER BY IsLogisticCarrier, ItemCode

		--Loop tru all the lines
		DECLARE productsCursor CURSOR FOR SELECT SSCC, GTIN, LogisticCarrierCode, ItemCode, ProductDescription, Quantity , IsLogisticCarrier, 
			BatchNumber, BestBeforeDate, BarcodeType, PackagingTypesText, QuantityByPackagingTypeText, BatchNumber2, LocationCode, 
			@tempQuantityUom2, Uom2Decimals, Uom2AI
			FROM @productsTable
		OPEN productsCursor
		FETCH NEXT FROM productsCursor INTO @SSCC, @GTIN, @LogisticCarrierCode, @ItemCode, @ProductDescription, @Quantity , @IsLogisticCarrier, 
		@BatchNumber, @BestBeforeDate, @BarcodeType, @TempPackagingTypeText, @TempQuantityByPackagingTypeText, @batchNumber2, @locationCode, 
		@tempQuantityUom2, @tempWeightDecimals, @tempWeightAI
		WHILE @@FETCH_STATUS >= 0 BEGIN
			SET @returnSSCC = @SSCC
			SET @returnGTIN = @GTIN
			SET @returnLogisticCarrierCode = @LogisticCarrierCode
			SET @returnItemCode = @ItemCode
			SET @returnProductDescription = @ProductDescription
			SET @returnQuantity = @Quantity
			SET @returnIsLogisticUnit = @IsLogisticCarrier
			SET @returnBatchNumber = @BatchNumber
			SET @returnBestBeforeDate = @BestBeforeDate
			SET @returnBarcodeType = @BarcodeType
			SET @returnPackagingTypeText = @TempPackagingTypeText
			SET @returnQuantityByPackagingTypeText = @TempQuantityByPackagingTypeText
			SET @returnLocationCode = @locationCode
			SET @weightAI = @tempWeightAI
			SET @weightDecimals = @tempWeightDecimals
			SET @quantityUom2 = @tempQuantityUom2
			
			--Set the barcodes
			SET @returnSSCCBarcode = dbo.PMX_FN_GenerateGS1Barcode( @returnSSCC, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '' )
			SET @returnSSCCBarcodeDigit = dbo.PMX_FN_GenerateGS1BarcodeDigit ( @returnSSCC, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL )
			SET @returnGTINBarcode = dbo.PMX_FN_GenerateGS1Barcode( NULL, @returnGTIN, @returnIsLogisticUnit, @returnBarcodeType,@returnBestBeforeDate, @returnBatchNumber, @returnQuantity, @quantityUom2, @weightDecimals, @weightAI, '')
			SET @returnGTINBarcodeDigit = dbo.PMX_FN_GenerateGS1BarcodeDigit ( NULL , @returnGTIN, @returnIsLogisticUnit, @returnBarcodeType,@returnBestBeforeDate, @returnBatchNumber, @returnQuantity, @quantityUom2, @weightDecimals, @weightAI)


			IF(@returnIsLogisticUnit = 'Y') SET @returnGTINLabel = 'GTIN'
			ELSE SET @returnGTINLabel = 'CONTENT'


			SELECT TOP 1    @PurchaseDocObjType = PurchaseDocObjType,
							@PurchaseDocNum     = PurchaseDocNum,
							@SupplierName       = SupplierName,
							@SupplierAddress    = SupplierAddress,
							@ReceptionDate      = ReceptionDate
			FROM dbo.PMX_DELIVERY_INFO_LABEL
			WHERE "LogUnitIdentKey" = @luid
			ORDER BY PurchaseDocNum DESC

			INSERT INTO @list
			--Return the values
			SELECT	@returnSSCC AS SSCC, 	
					ISNULL(@returnGTIN,'N/A') AS GTIN,
					ISNULL(@returnProductDescription,'N/A') AS ProductDescription, 
					ISNULL(CAST (CAST(@returnQuantity AS float) AS nvarchar),'N/A') Quantity,
					ISNULL(@returnBatchNumber,'N/A') AS BatchNumber, 
					ISNULL( CONVERT(nvarchar, @returnBestBeforeDate, 103),'N/A')  AS BestBeforeDate,
					@returnSSCCBarcode AS SSCCBarcode,
					@returnSSCCBarcodeDigit AS SSCCBarcodeDigit,
					@returnGTINBarcode AS GTINBarcode,
					@returnGTINBarcodeDigit AS GTINBarcodeDigit,
					@PurchaseDocObjType AS PurchaseDocObjType,
					ISNULL( CAST( @PurchaseDocNum AS nvarchar),'N/A') AS PurchaseDocNum,
					ISNULL(@SupplierName,'N/A') AS SupplierName,
					ISNULL(@SupplierAddress,'N/A') AS SupplierAddress,
					ISNULL( CONVERT(nvarchar, @ReceptionDate, 103),'N/A') AS ReceptionDate,
					@returnGTINLabel AS GTINLabel,
					@returnPackagingTypeText AS PackagingTypeText,
					@returnQuantityByPackagingTypeText AS QuantityByPackagingTypeText,
					@returnBatchNumber2 AS BatchNumber2, 
					@returnLocationCode AS LocationCode,
					@itemCode as ItemCode

			FETCH NEXT FROM productsCursor INTO @SSCC, @GTIN, @LogisticCarrierCode, @ItemCode, @ProductDescription, @Quantity , @IsLogisticCarrier, 
			@BatchNumber, @BestBeforeDate, @BarcodeType, @TempPackagingTypeText, @TempQuantityByPackagingTypeText, @batchNumber2, @locationCode, 
			@tempQuantityUom2, @tempWeightDecimals, @tempWeightAI
		END

		CLOSE productsCursor 
		DEALLOCATE productsCursor

		SELECT ORDR.NumAtCard as "NumAtCard", RDR1.U_GT_ExtraInfo1 as "Division", RDR1.U_GT_ExtraInfo2 as "VendorCode", RDR1.U_GT_ExtraInfo3 as "ItemCustomDescription",
				RDR1.U_GT_ExtraInfo4 as "Location", RDR1.U_GT_ExtraInfo5 as "ShopOrderNumber",
				PMX_PLHE."CardCode", PMX_PLHE."CardName", ORDR."ShipToCode", PMX_PLHE."ShipToAddress",
                PMX_PLLI."ItemCode", PMX_PLLI."Dscription", 
                PMX_PLLI."Quantity", PMX_PLLI."Uom", 
                OSCN.Substitute as CatalogNo, PMX_SENU.SerialNumber, (PMX_PLLI.Quantity * OITM.SWeight1 * OWGT.WightInMG) / 1000000 as "WeightKG"
		FROM @list as list
		join (SELECT     PMX_LUID.SSCC, PMX_PLHE."ShipToAddress", ISNULL(ORDR."CardName", OINV."CardName") AS ShipTo, ordr.DocEntry as SODocEntry, owtq.DocEntry as TRDocEntry, OITM."ItemName" AS ProductDescription, 
                      PMX_MVLI."Quantity", OITM."CodeBars" AS Barcode, PMX_ITRI."BatchNumber", PMX_ITRI."BestBeforeDate", PMX_PLHE."DueDate" AS DepartureDate, 
                      PMX_LUID."InternalKey" AS LUID, PMX_LUID."LogisticCarrierCode", PMX_MVLI."ItemCode", ISNULL(OITM.U_PMX_LOCA, 'N') AS IsLogisticCarrier, 
                      PMX_MVLI."QuantityUom2", PMX_PLHE.WaveKey, PMX_PLHE.DocEntry as PickListDocEntry, PMX_PLLI.LineNum as PickListLine,
					  PMX_PLPL.BaseEntry as PLPLBaseEntry, PMX_PLPL.BaseLine as PLPLBaseLine, PMX_PLPL.BaseType as PLPLBaseType
			FROM      PMX_LPLM INNER JOIN
                      PMX_PLLI INNER JOIN
                      PMX_PLHE ON PMX_PLLI."DocEntry" = PMX_PLHE."DocEntry" ON PMX_LPLM."PickListDocEntry" = PMX_PLHE."DocEntry" AND 
                      PMX_LPLM."PickListLineNum" = PMX_PLLI."LineNum" AND PMX_PLLI."LineStatus" = 'O' INNER JOIN
                      OITM INNER JOIN
                      PMX_LUID INNER JOIN
                      PMX_MVLI ON PMX_LUID."InternalKey" = PMX_MVLI."DestLogUnitIdentKey" ON OITM."ItemCode" = PMX_MVLI."ItemCode" ON 
                      PMX_LPLM."MoveDocEntry" = PMX_MVLI."DocEntry" AND PMX_LPLM."MoveLineNum" = PMX_MVLI."LineNum" INNER JOIN
                      PMX_PLPL ON PMX_PLPL."DocEntry" = PMX_PLLI."BaseEntry" AND PMX_PLPL."LineNum" = PMX_PLLI."BaseLine" AND 
                      PMX_PLLI."BaseType" = 'PMX_PLPH' LEFT JOIN
                      OINV ON PMX_PLPL."BaseType" = OINV."ObjType" AND PMX_PLPL."BaseEntry" = OINV."DocEntry" LEFT JOIN
                      ORDR ON ORDR."DocEntry" = PMX_PLPL."BaseEntry" AND ORDR."ObjType" = PMX_PLPL."BaseType" LEFT JOIN
					  OWTQ on OWTQ."DocEntry" = PMX_PLPL."BaseEntry" and OWTQ."ObjType" = PMX_PLPL."BaseType" LEFT JOIN
                      PMX_ITRI ON PMX_MVLI."ItemTransactionalInfoKey" = PMX_ITRI."InternalKey") as shippingSSCC on list.sscc = shippingSSCC.sscc and list.itemcode = shippingSSCC.itemcode
		left join ordr on ORDR.docentry = shippingSSCC.SODocEntry
		left join owtq on owtq.docentry = shippingSSCC.TRDocEntry
		left join RDR1 ON PLPLBaseEntry = RDR1."DocEntry" and PLPLBaseLine = RDR1."LineNum" and PLPLBaseType = '17'
		left join PMX_PLHE ON PMX_PLHE."DocEntry" = PickListDocEntry
		left join PMX_PLLI ON PMX_PLLI."DocEntry" = PickListDocEntry and PMX_PLLI."LineNum" = PickListLine
		LEFT JOIN OSCN ON OSCN."CardCode" = PMX_PLHE."CardCode" and OSCN."ItemCode" = PMX_PLLI."ItemCode"
		left join PMX_SENU ON PMX_SENU.LUID = shippingSSCC.LUID and PMX_SENU.ItemCode = shippingSSCC.ItemCode
		INNER JOIN OITM ON shippingSSCC.ItemCode = OITM.ItemCode
		INNER JOIN OWGT ON OITM.SWght1Unit = OWGT.UnitCode

    
	
END
