CREATE PROCEDURE [dbo].[PMX_SP_PickListDocumentWeg] 
	-- Parameters for the stored procedure
	@pickListDocEntry int = 0


AS
BEGIN
    
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;

	declare @glossarySeparator nvarchar(max)
	set @glossarySeparator = '\r\n'

	declare @headerGlossaries nvarchar(max)

	-- cursor variables	
	declare @lineNum int
	declare @text nvarchar(max)

	CREATE TABLE #LinesGlossaries (LineNum int, Text nvarchar(max))
	SET @headerGlossaries = ''

	DECLARE curs CURSOR FOR
	SELECT distinct PMX_PLLI.LineNum, PMX_W_OPENGLOSSARIES.Text
			FROM PMX_PLHE
			JOIN PMX_PLLI ON PMX_PLHE."DocEntry" = PMX_PLLI."DocEntry"
			JOIN PMX_W_OPENGLOSSARIES ON PMX_W_OPENGLOSSARIES.ItemCode = PMX_PLLI.ItemCode
			AND (PMX_W_OPENGLOSSARIES.CardCode IS NULL OR PMX_W_OPENGLOSSARIES.CardCode = PMX_PLHE.CardCode)
			WHERE PMX_PLHE."DocEntry" = @pickListDocEntry
			AND PMX_PLLI."LineStatus" NOT IN ('C', 'F')
	OPEN curs
	FETCH NEXT FROM curs INTO @lineNum, @text
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF (EXISTS(SELECT 1 FROM #LinesGlossaries WHERE LineNum = @lineNum)) BEGIN
			UPDATE #LinesGlossaries SET Text = Text + @glossarySeparator + @text WHERE LineNum = @lineNum
		END ELSE BEGIN
			INSERT INTO #LinesGlossaries (LineNum, Text) VALUES (@lineNum, @text)
		END
		FETCH NEXT FROM curs INTO @lineNum, @text
	END
	CLOSE curs
	DEALLOCATE curs

	DECLARE curs CURSOR FOR
	SELECT distinct PMX_W_OPENGLOSSARIES.Text
			FROM PMX_PLHE
			JOIN PMX_W_OPENGLOSSARIES ON PMX_W_OPENGLOSSARIES.CardCode = PMX_PLHE.CardCode
				AND PMX_W_OPENGLOSSARIES.ItemCode IS NULL
			WHERE PMX_PLHE."DocEntry" = @pickListDocEntry
	OPEN curs
	FETCH NEXT FROM curs INTO @text
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF (LEN(@headerGlossaries) > 0) BEGIN
			SET @headerGlossaries = @headerGlossaries + @glossarySeparator
		END
		SET @headerGlossaries = @headerGlossaries + @text
		FETCH NEXT FROM curs INTO @text
	END
	CLOSE curs
	DEALLOCATE curs

	--SELECT * FROM #LinesGlossaries
	--SELECT @headerGlossaries

	declare @numAtCardList nvarchar(4000)
	declare @carrierList nvarchar(4000)

	Select @numAtCardList = substring(
        (
            Select distinct ', ' + ISNULL(ORDR.NumAtCard, ISNULL(CAST(OWTQ."DocNum" as nvarchar(20)), ORDR2.NumAtCard))  AS [text()]
            From PMX_PLLI
			LEFT JOIN   PMX_PLPL ON PMX_PLPL."DocEntry" = PMX_PLLI."BaseEntry" and PMX_PLPL."LineNum" = PMX_PLLI."BaseLine" and 'PMX_PLPH' = PMX_PLLI."BaseType"
			LEFT JOIN	ORDR ON PMX_PLPL."BaseEntry" = ORDR."DocEntry" and PMX_PLPL."BaseType" = '17'
			LEFT JOIN	OWTQ ON PMX_PLPL."BaseEntry" = OWTQ."DocEntry" and PMX_PLPL."BaseType" = '1250000001'
			LEFT JOIN	OWOR ON PMX_PLPL."BaseEntry" = OWOR."DocEntry" and PMX_PLPL."BaseType" = '202'
			LEFT JOIN	ORDR ORDR2 ON OWOR."OriginAbs" = ORDR2."DocEntry"
			WHERE PMX_PLLI."DocEntry" = @pickListDocEntry
			AND   PMX_PLLI."LineStatus" NOT IN ('C', 'F')
			and ISNULL(ISNULL(ORDR.NumAtCard, ISNULL(CAST(OWTQ."DocNum" as nvarchar(20)), ORDR2.NumAtCard)), '') <> ''
            For XML PATH ('')
        ), 3, 1000) 

	Select @carrierList = substring(
        (
            Select distinct ', ' + ISNULL(ORDR."U_GT_Carrier", OWTQ."U_GT_Carrier")  AS [text()]
            From PMX_PLLI
			LEFT JOIN   PMX_PLPL ON PMX_PLPL."DocEntry" = PMX_PLLI."BaseEntry" and PMX_PLPL."LineNum" = PMX_PLLI."BaseLine" and 'PMX_PLPH' = PMX_PLLI."BaseType"
			LEFT JOIN	ORDR ON PMX_PLPL."BaseEntry" = ORDR."DocEntry" and PMX_PLPL."BaseType" = '17'
			LEFT JOIN	OWTQ ON PMX_PLPL."BaseEntry" = OWTQ."DocEntry" and PMX_PLPL."BaseType" = '1250000001'
			WHERE PMX_PLLI."DocEntry" = @pickListDocEntry
			AND   PMX_PLLI."LineStatus" NOT IN ('C', 'F')
			AND ISNULL(ISNULL(ORDR."U_GT_Carrier", OWTQ."U_GT_Carrier"), '') <> ''
            For XML PATH ('')
        ), 3, 1000) 

    SELECT      PMX_PLHE."DocEntry", PMX_PLHE."WaveKey", PMX_PLHE."CardCode", PMX_PLHE."CardName", ORDR."ShipToCode", PMX_PLHE."ShipToAddress", PMX_OSEL_1."Name" AS Dock, 
                PMX_PLHE."DueDate", PMX_PLHE."Priority", ISNULL(OWTQ.PickRmrk,'') + ' ' + cast(PMX_PLHE."PickPackRemarks" as nvarchar(4000)) as "PickPackRemarks",
				PickListLines."ItemCode", PickListLines."Dscription", 
                PickListLines."Quantity", PickListLines."Uom", PickListLines."QualityStatusCode",
                PMX_LUID.SSCC, PMX_OSSL."Name" AS PickLocation, ISNULL(PMX_OSSL."Sequence", 999999999) AS Sequence, OSCN.Substitute as CatalogNo,
                @headerGlossaries as HeaderGlossaries, #LinesGlossaries.Text as LineGlossaries, Weights.WeightInKG, @numAtCardList as "NumAtCard",
                @carrierList as "Carrier", OHEM.officeExt, CASE WHEN OWOR."DocEntry" IS NULL THEN NULL ELSE 'ATELIER' END as "Subtitle"
    FROM        (
		SELECT PMX_PLLI."DocEntry", PMX_PLLI."LineStatus", PMX_PLLI."ItemCode", PMX_PLLI."Dscription", PMX_PLLI.StorLocCode, PMX_PLLI.LogUnitIdentKey,
        PMX_PLLI."Uom", PMX_PLLI."QualityStatusCode", PMX_PLLI."BaseEntry", PMX_PLLI."BaseType",
		SUM(PMX_PLLI."Quantity") as "Quantity", MIN(PMX_PLLI."LineNum") as "LineNum", MIN(PMX_PLLI."BaseLine") as "BaseLine"
		FROM PMX_PLLI
		WHERE PMX_PLLI."DocEntry" = @pickListDocEntry
		GROUP BY PMX_PLLI."DocEntry", PMX_PLLI."LineStatus", PMX_PLLI."ItemCode", PMX_PLLI."Dscription", PMX_PLLI.StorLocCode, PMX_PLLI.LogUnitIdentKey,
        PMX_PLLI."Uom", PMX_PLLI."QualityStatusCode", PMX_PLLI."BaseEntry", PMX_PLLI."BaseType"
		) AS PickListLines
	INNER JOIN PMX_PLHE ON PMX_PLHE."DocEntry" = PickListLines."DocEntry"
    INNER JOIN  PMX_OSEL AS PMX_OSEL_1 ON PMX_PLHE."DestStorLocCode" = PMX_OSEL_1."Code"
    LEFT JOIN   PMX_OSSL ON PickListLines."StorLocCode" = PMX_OSSL."Code"
    LEFT JOIN   PMX_LUID ON PickListLines."LogUnitIdentKey" = PMX_LUID."InternalKey"
    LEFT JOIN   OSCN ON OSCN."CardCode" = PMX_PLHE."CardCode" and OSCN."ItemCode" = PickListLines."ItemCode"
    LEFT JOIN  PMX_PLPL ON PMX_PLPL."DocEntry" = PickListLines."BaseEntry" and PMX_PLPL."LineNum" = PickListLines."BaseLine" and 'PMX_PLPH' = PickListLines."BaseType"
    LEFT JOIN	ORDR ON PMX_PLPL."BaseEntry" = ORDR."DocEntry" and PMX_PLPL."BaseType" = '17'
    LEFT JOIN	OWTQ ON PMX_PLPL."BaseEntry" = OWTQ."DocEntry" and PMX_PLPL."BaseType" = '1250000001'
    --LEFT JOIN   WTQ1 ON PMX_PLPL."BaseEntry" = WTQ1."DocEntry" and PMX_PLPL."BaseLine" = WTQ1."LineNum" and PMX_PLPL."BaseType" = '1250000001'
    LEFT JOIN	OWOR ON PMX_PLPL."BaseEntry" = OWOR."DocEntry" and PMX_PLPL."BaseType" = '202'
    LEFT JOIN   #LinesGlossaries ON #LinesGlossaries.LineNum = PickListLines.LineNum
    LEFT JOIN   OHEM on OHEM.empID = ORDR.ownerCode
    LEFT JOIN   (SELECT PLHE2.DocEntry as DocEntry, SUM(PLLI2.Quantity * OITM.SWeight1 * OWGT.WightInMG) / 1000000 as WeightInKG
		FROM PMX_PLHE PLHE2
		INNER JOIN PMX_PLLI PLLI2 ON PLHE2.DocEntry = PLLI2.DocEntry
		INNER JOIN OITM ON PLLI2.ItemCode = OITM.ItemCode
		INNER JOIN OWGT ON OITM.SWght1Unit = OWGT.UnitCode
		GROUP BY PLHE2.DocEntry) AS Weights ON Weights.DocEntry = PMX_PLHE.DocEntry
    WHERE PickListLines."DocEntry" = @pickListDocEntry
    AND   PickListLines."LineStatus" NOT IN ('C', 'F')
    ORDER BY Sequence, PMX_OSSL."Code";
    
	DROP TABLE #LinesGlossaries
	
END
