ALTER PROCEDURE [dbo].[PMX_SP_PickListDocumentWeg_Pallets] 
	-- Parameters for the stored procedure
	@pickListDocEntry int = 0


AS
BEGIN
    
	-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
	SET NOCOUNT ON;

	declare @glossarySeparator nvarchar(max)
	set @glossarySeparator = '\r\n'

	declare @headerGlossaries nvarchar(max)

	-- cursor variables	
	declare @lineNum int
	declare @text nvarchar(max)

	CREATE TABLE #LinesGlossaries (LineNum int, Text nvarchar(max))
	SET @headerGlossaries = ''

	DECLARE curs CURSOR FOR
	SELECT distinct PMX_PLLI.LineNum, PMX_W_OPENGLOSSARIES.Text
			FROM PMX_PLHE
			JOIN PMX_PLLI ON PMX_PLHE."DocEntry" = PMX_PLLI."DocEntry"
			JOIN PMX_W_OPENGLOSSARIES ON PMX_W_OPENGLOSSARIES.ItemCode = PMX_PLLI.ItemCode
			AND (PMX_W_OPENGLOSSARIES.CardCode IS NULL OR PMX_W_OPENGLOSSARIES.CardCode = PMX_PLHE.CardCode)
			WHERE PMX_PLHE."DocEntry" = @pickListDocEntry
			AND PMX_PLLI."LineStatus" NOT IN ('C', 'F')
	OPEN curs
	FETCH NEXT FROM curs INTO @lineNum, @text
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF (EXISTS(SELECT 1 FROM #LinesGlossaries WHERE LineNum = @lineNum)) BEGIN
			UPDATE #LinesGlossaries SET Text = Text + @glossarySeparator + @text WHERE LineNum = @lineNum
		END ELSE BEGIN
			INSERT INTO #LinesGlossaries (LineNum, Text) VALUES (@lineNum, @text)
		END
		FETCH NEXT FROM curs INTO @lineNum, @text
	END
	CLOSE curs
	DEALLOCATE curs

	DECLARE curs CURSOR FOR
	SELECT distinct PMX_W_OPENGLOSSARIES.Text
			FROM PMX_PLHE
			JOIN PMX_W_OPENGLOSSARIES ON PMX_W_OPENGLOSSARIES.CardCode = PMX_PLHE.CardCode
				AND PMX_W_OPENGLOSSARIES.ItemCode IS NULL
			WHERE PMX_PLHE."DocEntry" = @pickListDocEntry
	OPEN curs
	FETCH NEXT FROM curs INTO @text
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF (LEN(@headerGlossaries) > 0) BEGIN
			SET @headerGlossaries = @headerGlossaries + @glossarySeparator
		END
		SET @headerGlossaries = @headerGlossaries + @text
		FETCH NEXT FROM curs INTO @text
	END
	CLOSE curs
	DEALLOCATE curs

	--SELECT * FROM #LinesGlossaries
	--SELECT @headerGlossaries

    SELECT      PMX_PLHE."DocEntry", PMX_PLHE."WaveKey", PMX_PLHE."CardCode", PMX_PLHE."CardName", PMX_PLHE."ShipToAddress", PMX_OSEL_1."Name" AS Dock, 
                PMX_PLHE."DueDate", PMX_PLHE."Priority", PMX_PLHE."PickPackRemarks", @headerGlossaries as HeaderGlossaries, Weights.WeightInKG, LinesSSCC.SSCC
    FROM        PMX_PLHE 
    INNER JOIN  PMX_OSEL AS PMX_OSEL_1 ON PMX_PLHE."DestStorLocCode" = PMX_OSEL_1."Code"
    LEFT JOIN   (SELECT PLHE2.DocEntry as DocEntry, SUM(PLLI2.Quantity * OITM.SWeight1 * OWGT.WightInMG) / 1000000 as WeightInKG
		FROM PMX_PLHE PLHE2
		INNER JOIN PMX_PLLI PLLI2 ON PLHE2.DocEntry = PLLI2.DocEntry
		INNER JOIN OITM ON PLLI2.ItemCode = OITM.ItemCode
		INNER JOIN OWGT ON OITM.SWght1Unit = OWGT.UnitCode
		GROUP BY PLHE2.DocEntry) AS Weights ON Weights.DocEntry = PMX_PLHE.DocEntry
    LEFT JOIN (
		SELECT      DISTINCT PMX_PLLI."DocEntry", PMX_LUID.SSCC
		FROM        PMX_PLLI 
		LEFT JOIN   PMX_OSSL ON PMX_PLLI."StorLocCode" = PMX_OSSL."Code"
		LEFT JOIN   PMX_ITRI ON PMX_PLLI."ItemTransactionalInfoKey" = PMX_ITRI."InternalKey"
		LEFT JOIN   PMX_LUID ON PMX_PLLI."LogUnitIdentKey" = PMX_LUID."InternalKey"
		WHERE PMX_PLLI."DocEntry" = @pickListDocEntry
		AND   PMX_PLLI."LineStatus" NOT IN ('C', 'F')
		AND   PMX_LUID.SSCC IS NOT NULL
	) as LinesSSCC on LinesSSCC."DocEntry" = PMX_PLHE."DocEntry"
    WHERE PMX_PLHE."DocEntry" = @pickListDocEntry
    ORDER BY LinesSSCC.SSCC;
    
	DROP TABLE #LinesGlossaries
	
END
