CREATE VIEW [PMX_PICKLIST_PROPOSAL_MANAGER_SALES_WBE] AS


SELECT DISTINCT 
"ORDR"."ObjType" AS "ObjType", 
"ORDR"."ObjType" AS "ObjTypeString",
"ORDR"."DocEntry" AS "DocEntry", 
"ORDR"."DocNum" AS "DocNum", 
"ORDR"."DocDueDate" AS "DocDueDate", 
"RDR1"."ShipDate" AS "DocLineShipDate", 
"ORDR"."CardCode" AS "CardCode", 
"ORDR"."CardName" AS "CardName", 
"ORDR"."Address2" AS "ShipToAddress", 
"ORDR"."ShipToCode" AS "ShipToCode", 
"RDR1"."ItemCode" AS "ItemCode",
"OITM"."ItemName" AS "ItemName",
"OITM"."ItmsGrpCod" AS "ItmsGrpCod",
"RDR1"."LineNum" AS "LineNum",
"RDR1"."WhsCode" AS "WhsCode",
"OSHP"."TrnspName" AS "ShippingType", 
"ORDR"."NumAtCard" AS "NumAtCard", 
"ORDR"."PickRmrk" AS "PickRmrk", 
SUM("RDR1"."OpenQty") AS "OpenQuantity", 
SUM("PMX_OITM_MEASUREMENTS"."SVolume" * "OLGT"."SizeInMM" * "OLGT"."SizeInMM" * "OLGT"."SizeInMM" * 1E-9 * "RDR1"."OpenQty") AS "OpenVolume", SUM("PMX_OITM_MEASUREMENTS"."SWeight1" * "OWGT"."WightInMG" * 1E-6 * "RDR1"."OpenQty") AS "OpenWeight", SUM("RDR1"."LineTotal" * "RDR1"."OpenQty" / "RDR1"."Quantity") AS "OpenPrice", SUM("RDR1"."Quantity") AS "TotalQuantity", COUNT(DISTINCT "RDR1"."ItemCode") AS "UniqueItems", SUM("PMX_OITM_MEASUREMENTS"."SVolume" * "OLGT"."SizeInMM" * "OLGT"."SizeInMM" * "OLGT"."SizeInMM" * 1E-9 * "RDR1"."Quantity") AS "TotalVolume", SUM("PMX_OITM_MEASUREMENTS"."SWeight1" * "OWGT"."WightInMG" * 1E-6 * "RDR1"."Quantity") AS "TotalWeight", SUM("RDR1"."LineTotal") AS "TotalPrice",
CAST(NULLIF(Left(SubString(U_Frame, PatIndex('%[0-9.-]%', U_Frame), 8000), PatIndex('%[^0-9.-]%', SubString(U_Frame, PatIndex('%[0-9.-]%', U_Frame), 8000) + 'X')-1),'') as int) as "Frame Size"
 FROM "ORDR"
 INNER JOIN "RDR1" ON "RDR1"."DocEntry" = "ORDR"."DocEntry"
 INNER JOIN "OITM" ON "OITM"."ItemCode" = "RDR1"."ItemCode"
 INNER JOIN "OCRD" ON "ORDR"."CardCode" = "OCRD"."CardCode"
 LEFT JOIN "OSHP" ON "ORDR"."TrnspCode" = "OSHP"."TrnspCode"
 LEFT JOIN "PMX_DOLL" ON "PMX_DOLL"."DocEntry" = "RDR1"."DocEntry" AND "PMX_DOLL"."LineNum" = "RDR1"."LineNum" AND "PMX_DOLL"."ObjType" = "ORDR"."ObjType"
 LEFT JOIN "PMX_OITM_MEASUREMENTS" ON "PMX_OITM_MEASUREMENTS"."ItemCode" = "OITM"."ItemCode" AND "RDR1"."UomEntry" = "PMX_OITM_MEASUREMENTS"."UomEntry"
 LEFT JOIN "OLGT" ON "OLGT"."UnitCode" = "PMX_OITM_MEASUREMENTS"."SVolUnit"
 LEFT JOIN "OWGT" ON "OWGT"."UnitCode" = "PMX_OITM_MEASUREMENTS"."SWght1Unit"
 WHERE "ORDR"."Confirmed" = N'Y' 
 AND "ORDR"."DocStatus" = N'O' 
 AND "RDR1"."LineStatus" = N'O' 
 AND "OITM"."InvntItem" = N'Y' AND ( "RDR1"."OpenQty" - ISNULL( "PMX_DOLL"."LockedQuantity", 0 ) > 0 ) 
 AND NOT ( "OCRD"."validFor" = N'Y' AND ( ( "OCRD"."validFrom" IS NOT NULL AND CURRENT_TIMESTAMP < "OCRD"."validFrom" ) 
 OR ( "OCRD"."validTo" IS NOT NULL AND CURRENT_TIMESTAMP >= DATEADD( day, 1, "OCRD"."validTo" ) ) ) ) 
 AND NOT ( "OCRD"."frozenFor" = N'Y' AND ( "OCRD"."frozenFrom" IS NULL OR CURRENT_TIMESTAMP >= "OCRD"."frozenFrom" ) 
 AND ( "OCRD"."frozenTo" IS NULL OR CURRENT_TIMESTAMP < DATEADD( day, 1, "OCRD"."frozenTo" ) ) ) 
 GROUP BY "ORDR"."ObjType","ORDR"."DocEntry","ORDR"."DocNum","ORDR"."DocDueDate","RDR1"."ShipDate","ORDR"."CardCode","ORDR"."CardName",
 "ORDR"."Address2","ORDR"."ShipToCode","OSHP"."TrnspName","ORDR"."NumAtCard","RDR1"."ItemCode","RDR1"."LineNum","RDR1"."WhsCode","OITM"."ItemName","OITM"."ItmsGrpCod","ORDR"."PickRmrk",
 OITM."U_Frame"
 UNION SELECT "OINV"."ObjType" AS "ObjType", "OINV"."ObjType" AS "ObjTypeString", "OINV"."DocEntry" AS "DocEntry", "OINV"."DocNum" AS "DocNum", "OINV"."DocDueDate" AS "DocDueDate", "INV1"."ShipDate", "OINV"."CardCode" AS "CardCode", "OINV"."CardName" AS "CardName", "OINV"."Address2" AS "ShipToAddress", "OINV"."ShipToCode" AS "ShipToCode", "INV1"."ItemCode" AS "ItemCode", "OITM"."ItemName" AS "ItemName", "OITM"."ItmsGrpCod" AS "ItmsGrpCod","INV1"."LineNum" AS "LineNum","INV1"."WhsCode" AS "WhsCode", "OSHP"."TrnspName" AS "ShippingType", "OINV"."NumAtCard" AS "NumAtCard", "OINV"."PickRmrk" AS "PickRmrk", SUM("INV1"."OpenQty") AS "OpenQuantity", SUM("PMX_OITM_MEASUREMENTS"."SVolume" * "OLGT"."SizeInMM" * "OLGT"."SizeInMM" * "OLGT"."SizeInMM" * 1E-9 * "INV1"."OpenQty") AS "OpenVolume", SUM("PMX_OITM_MEASUREMENTS"."SWeight1" * "OWGT"."WightInMG" * 1E-6 * "INV1"."OpenQty") AS "OpenWeight", SUM("INV1"."LineTotal" * "INV1"."OpenQty" / "INV1"."Quantity") AS "OpenPrice", SUM("INV1"."Quantity") AS "TotalQuantity", COUNT(DISTINCT "INV1"."ItemCode") AS "UniqueItems", SUM("PMX_OITM_MEASUREMENTS"."SVolume" * "OLGT"."SizeInMM" * "OLGT"."SizeInMM" * "OLGT"."SizeInMM" * 1E-9 * "INV1"."Quantity") AS "TotalVolume", SUM("PMX_OITM_MEASUREMENTS"."SWeight1" * "OWGT"."WightInMG" * 1E-6 * "INV1"."Quantity") AS "TotalWeight", SUM("INV1"."LineTotal") AS "TotalPrice",
 CAST(NULLIF(Left(SubString(U_Frame, PatIndex('%[0-9.-]%', U_Frame), 8000), PatIndex('%[^0-9.-]%', SubString(U_Frame, PatIndex('%[0-9.-]%', U_Frame), 8000) + 'X')-1),'') as int) as "Frame Size"
 FROM "OINV"
 INNER JOIN "INV1" ON "INV1"."DocEntry" = "OINV"."DocEntry"
 INNER JOIN "OITM" ON "OITM"."ItemCode" = "INV1"."ItemCode"
 INNER JOIN "OCRD" ON "OINV"."CardCode" = "OCRD"."CardCode"
 LEFT JOIN "OSHP" ON "OINV"."TrnspCode" = "OSHP"."TrnspCode"
 LEFT JOIN "PMX_DOLL" ON "PMX_DOLL"."DocEntry" = "INV1"."DocEntry" AND "PMX_DOLL"."LineNum" = "INV1"."LineNum" AND "PMX_DOLL"."ObjType" = "OINV"."ObjType"
 LEFT JOIN "PMX_OITM_MEASUREMENTS" ON "PMX_OITM_MEASUREMENTS"."ItemCode" = "OITM"."ItemCode" AND "INV1"."UomEntry" = "PMX_OITM_MEASUREMENTS"."UomEntry"
 LEFT JOIN "OLGT" ON "OLGT"."UnitCode" = "PMX_OITM_MEASUREMENTS"."SVolUnit"
 LEFT JOIN "OWGT" ON "OWGT"."UnitCode" = "PMX_OITM_MEASUREMENTS"."SWght1Unit"
 WHERE "OINV"."Confirmed" = N'Y' 
 AND  "OINV"."InvntSttus" = N'O' 
 AND "OINV"."isIns" = N'Y' 
 AND "INV1"."LineStatus" = N'O' 
 AND "INV1"."BaseType" = N'17' 
 AND "OITM"."InvntItem" = N'Y' 
 AND ( "INV1"."OpenQty" - ISNULL( "PMX_DOLL"."LockedQuantity", 0 ) > 0 ) 
AND NOT ( 
"OCRD"."validFor" = N'Y'
AND ( ( "OCRD"."validFrom" IS NOT NULL AND CURRENT_TIMESTAMP < "OCRD"."validFrom" ) OR ( "OCRD"."validTo" IS NOT NULL AND CURRENT_TIMESTAMP >= DATEADD( day, 1, "OCRD"."validTo" ) ) ) ) 
AND NOT ( "OCRD"."frozenFor" = N'Y' AND ( "OCRD"."frozenFrom" IS NULL OR CURRENT_TIMESTAMP >= "OCRD"."frozenFrom" ) AND
 ( "OCRD"."frozenTo" IS NULL OR CURRENT_TIMESTAMP < DATEADD( day, 1, "OCRD"."frozenTo" ) ) 
) 
GROUP BY "OINV"."ObjType","OINV"."DocEntry","OINV"."DocNum","OINV"."DocDueDate","INV1"."ShipDate","OINV"."CardCode","OINV"."CardName","OINV"."Address2","OINV"."ShipToCode","OSHP"."TrnspName","OINV"."NumAtCard","INV1"."ItemCode","INV1"."LineNum","INV1"."WhsCode", "OITM"."ItemName", "OITM"."ItmsGrpCod","OINV"."PickRmrk",
 OITM."U_Frame"
