SELECT "TWeights"."StorLocGroup", SUM("TWeights"."TotalWeightInMG")
FROM (
	SELECT SUBSTRING("PMX_INVT"."StorLocCode", 1, LEN("PMX_INVT"."StorLocCode") - 1) AS "StorLocGroup", "OITM"."BWeight1" * "OWGT"."WightInMG" AS "TotalWeightInMG"
	FROM "PMX_INVT"
	INNER JOIN "OITM" ON "PMX_INVT"."ItemCode" = "OITM"."ItemCode"
	LEFT JOIN "OWGT" ON "OITM"."BWght1Unit" = "OWGT"."UnitCode"
	WHERE (
		(
			LEN("PMX_INVT"."StorLocCode") = 4
			AND SUBSTRING("PMX_INVT"."StorLocCode", 1, 1) IN ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L')
		)
		OR
		(
			LEN("PMX_INVT"."StorLocCode") = 5
			AND SUBSTRING("PMX_INVT"."StorLocCode", 1, 2) IN ('VA', 'WA', 'WB', 'XA', 'XB', 'YA', 'YB', 'ZA', 'ZB')
		)
	)
	AND "OITM"."BWeight1" IS NOT NULL
	AND "PMX_INVT"."StorLocCode" NOT IN ('LDPI')
) AS "TWeights"
GROUP BY "StorLocGroup"
HAVING SUM("TotalWeightInMG") > 3200000000