--SELECT T0."DocDate" FROM ODLN T0, ORDR T1 WHERE T0."DocDate" >= [%0] AND T1."DocDate" <= [%1]
SELECT ODLN."DocEntry" as "Id livraison", ODLN."DocNum" as "No livraison", ODLN."NumAtCard" as "PO Number", RDR1."U_GT_ExtraInfo1" AS "Division", DLN1."ItemCode" as "Item Code", OSCN."Substitute" as "Ref Atlas",
CEILING(SUM(DLN1."Quantity" * "@WBE_PKAT"."U_WBE_Rings" / CASE WHEN ISNULL("@WBE_PKAT"."U_WBE_Colisage", 0) = 0 THEN 1 ELSE "@WBE_PKAT"."U_WBE_Colisage" END)) as "Rings",
CEILING(SUM(DLN1."Quantity" * "@WBE_PKAT"."U_WBE_Covers" / CASE WHEN ISNULL("@WBE_PKAT"."U_WBE_Colisage", 0) = 0 THEN 1 ELSE "@WBE_PKAT"."U_WBE_Colisage" END)) as "Covers"
FROM DLN1
INNER JOIN ODLN ON ODLN."DocEntry" = DLN1."DocEntry"
INNER JOIN OITM ON OITM."ItemCode" = DLN1."ItemCode"
INNER JOIN "@WBE_PKAT" ON "@WBE_PKAT"."Code" = OITM."U_WBE_AtlasPckGrp"
LEFT JOIN RDR1 ON RDR1."DocEntry" = DLN1."BaseEntry" AND RDR1."LineNum" = DLN1."BaseLine" AND DLN1."BaseType" = 17
LEFT JOIN OSCN ON OSCN."CardCode" = ODLN."CardCode" AND OSCN."ItemCode" = DLN1."ItemCode"
WHERE ODLN."CardCode" in (
'779056',
'779092',
'788669',
'797401',
'797416',
'797420',
'797465',
'797466',
'797467',
'822303',
'860349',
'860350',
'860351',
'860523',
'779546',
'860390',
'860507',
'797381'
)
AND ODLN."DocDate" >= [%0] AND ODLN."DocDate" <= [%1]
GROUP BY ODLN."DocEntry", ODLN."DocNum", ODLN."NumAtCard", RDR1."U_GT_ExtraInfo1", DLN1."ItemCode", OSCN."Substitute"