--SELECT 1 FROM "OSRN" T0 WHERE T0."Quantity" = [%0]
SELECT "OITM"."ItemCode", "OITM"."ItemName", "SmallestStock"."StorLocCode" AS "Smallest location", "SmallestStock"."Quantity" AS "Smallest quantity", "GreatestStock"."StorLocCode" AS "Greatest location", "GreatestStock"."Quantity" AS "Greatest quantity"
FROM "OITM"
LEFT JOIN "PMX_INVT" AS "SmallestStock"
	ON "SmallestStock"."ItemCode" = "OITM"."ItemCode"
	AND NOT EXISTS (SELECT 1 FROM "PMX_INVT" AS "INVT1"
		WHERE "INVT1"."ItemCode" = "SmallestStock"."ItemCode"
		AND "INVT1"."Quantity" < "SmallestStock"."Quantity"
	)
LEFT JOIN "PMX_INVT" AS "GreatestStock"
	ON "GreatestStock"."ItemCode" = "OITM"."ItemCode"
	AND NOT EXISTS (SELECT 1 FROM "PMX_INVT" AS "INVT1"
		WHERE "INVT1"."ItemCode" = "GreatestStock"."ItemCode"
		AND "INVT1"."Quantity" > "GreatestStock"."Quantity"
	)
WHERE "SmallestStock"."Quantity" IS NOT NULL
AND "GreatestStock"."Quantity" IS NOT NULL
AND "SmallestStock"."Quantity" * [%0] <= "GreatestStock"."Quantity"
ORDER BY "OITM"."ItemCode"