﻿using System.Globalization;
using System.Reflection;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using System.Collections.Generic;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects.Definitions;
using System.Text;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using System.Data;
using System;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Sbo.Logex.Weg.Data.Providers;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_AfterSSCCIdentifiedForPutAwayHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_AfterSSCCIdentifiedForPutAwayHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger( MethodInfo.GetCurrentMethod().DeclaringType );

        string query = null;
        string itemCode = null;
        double palletMaxQty = 0.0;

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<string> SSCC;

        // Output parameters * do not change *
        public ReadWriteBinder<bool> BackRequested;

        // Sub-flows
        // <none>

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_AfterSSCCIdentifiedForPutAwayHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_AfterSSCCIdentifiedForPutAwayHookScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base( parent, factory )
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {

            // Parameters in scope
            Session session = GetScopeParameter( "Session" ) as Session;
            ISboProviderService sboProviderService = GetScopeParameter( "<WwfService>ISboService" ) as ISboProviderService;

            string initialErrorKey = null;

            bool palletFillInDuringPutAway = false;

            sboProviderService.InvokeMethodWithDbConnection<object>( true, false, null, null,
              delegate( PmxDbConnection conn, object[] parameters )
              {
                  PmxWegGeneralProvider wegProv = new PmxWegGeneralProvider( (SboConnection)conn );
                  Dictionary<string, PmxParameterValue> plcParams = wegProv.GetParametersWegController();

                  palletFillInDuringPutAway = PmxParameterValueProvider.GetParameterValue<bool>( plcParams, PmxWegExtensionParameterCodes.RECOMMEND_PALLET_TO_FILL_IN_PUT_AWAY, false );

                  return null;
              } );

            if ( palletFillInDuringPutAway ) //if palletFillInDuringPutAway is false than do nothing
            {

                query = BuildQuery.GetItemOnSSCC( SSCC.Get(), CultureInfo.InvariantCulture );
                DataSet dsTemp = sboProviderService.RunView( false, null, null, query );


                if ( GetNumberOfRows( dsTemp ) > 0 )
                {
                    itemCode = dsTemp.Tables[ 0 ].Rows[ 0 ][ PmxInventoryDetailTable.Columns.ItemCode.NAME ] as string;
                    palletMaxQty = Convert.ToDouble( dsTemp.Tables[ 0 ].Rows[ 0 ][ PmxItemWegTable.Columns.MaxPalletQty.NAME ] );

                    query = BuildQuery.GetLocationContainItem( itemCode, palletMaxQty, CultureInfo.InvariantCulture );
                    dsTemp = sboProviderService.RunView( false, null, null, query );

                    if ( GetNumberOfRows( dsTemp ) > 0 )
                    {
                        string storeLoc = dsTemp.Tables[ 0 ].Rows[ 0 ][ PmxInventoryTotalTable.Columns.StorLocCode.NAME ] as string;
                        double quantity = Convert.ToDouble( dsTemp.Tables[ 0 ].Rows[ 0 ][ PmxInventoryTotalTable.Columns.Quantity.NAME ] );
                        session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen ),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", "MSG_WEG_REFILL_PALLET",
                            "ShowButton", true,
                            "Parameters", new object[] { SSCC.Get(), storeLoc, quantity } ) );

                        WaitForMessage();
                    }
                }
                else
                {
                    session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen ),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", "MSG_WEG_INCORRECT_SSCC_ENTERED",
                            "ShowButton", true ) );

                    WaitForMessage();
                }

            }

        }

        #endregion

        #region HELPERS
        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows( DataSet ds )
        {
            if ( ds != null && ds.Tables.Count > 0 )
            {
                return ds.Tables[ 0 ].Rows.Count;
            }
            return 0;
        }
        #endregion

        #region BUILD QUERY

        /// <summary>
        /// Static class grouping our native queries
        /// </summary>
        internal static class BuildQuery
        {
            public static string GetItemOnSSCC( string sscc, CultureInfo cultureInfo )
            {
                /*select top 1 PMX_INVT.ItemCode,OITM.U_MaxPalletQty
                    from PMX_INVT 
                    inner join OITM on OITM.ItemCode = PMX_INVT.ItemCode
                    where SSCC = ''*/


                StringBuilder strBuilder = new StringBuilder();
                strBuilder.AppendFormat( "SELECT TOP 1 {0}, {1} FROM {2} INNER JOIN {3} ON {4} = {5} WHERE {6} = {7} ",
                    SqlCommandHelper.EscapeTableColumnName( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxItemWegTable.NAME, PmxItemWegTable.Columns.MaxPalletQty.NAME ),
                    SqlCommandHelper.EscapeTableName( PmxInventoryTotalTable.NAME ),
                    SqlCommandHelper.EscapeTableName( PmxItemTable.VIEW_NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxItemTable.VIEW_NAME, SboItemTable.Columns.ItemCode.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.SSCC.NAME ),
                   SqlCommandHelper.FormatAndEscapeColumnValue( sscc, cultureInfo ) );

                return strBuilder.ToString();
            }

            public static string GetLocationContainItem( string itemCode, double quantity, CultureInfo cultureInfo )
            {
                //select PMX_INVT.StorLocCode, PMX_INVT.Quantity from PMX_INVT where ItemCode = 'ITEM01OK' and Quantity < {}

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.AppendFormat( "SELECT TOP 1 {0}, {1} FROM {2} WHERE {3} = {4} AND {1} < {5} ",
                       SqlCommandHelper.EscapeTableColumnName( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME ),
                       SqlCommandHelper.EscapeTableColumnName( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME ),
                       SqlCommandHelper.EscapeTableName( PmxInventoryTotalTable.NAME ),
                       SqlCommandHelper.EscapeTableColumnName( PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemCode.NAME ),
                       SqlCommandHelper.FormatAndEscapeColumnValue( itemCode, cultureInfo ),
                       SqlCommandHelper.EscapeColumnValue( quantity ) );

                return strBuilder.ToString();
            }
        }

        #endregion
    }
}
