﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Globalization;
using System.Reflection;
using System.Text;
using Produmex.Foundation;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Messages;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.DataObjects;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.SlimScreen.WinGui;
using Produmex.Foundation.Utilities;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.Wwf.Sbo.DataObjects;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Convertors;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.DataObjects;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Data.ViewObjects.Definitions.Views;
using Produmex.Foundation.Data.Sbo.Generators.BarcodeController;
using Produmex.Sbo.Logex.Data;
using System.IO;
using static Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables.PmxCycleCountLogLineTable.Columns;

// PmxWorkflowExecutionTypes.SUB_FLOW
namespace Produmex.Sbo.Logex.WorkflowScripts
{
    /// <summary>
    /// Cycle counting
    /// </summary>
    public class WorkflowScript_CycleCountingWegFullPalletScript : WorkflowInstanceScriptBase
    {
        /// <summary>
        /// Definitions
        /// </summary>
        private static class Definitions
        {
            /// <summary>
            /// Minimum number of characters when entering reason
            /// </summary>
            public const int MIMIMUM_NUMBER_OF_CHARACTERS_FOR_REASON = 10;
        }


        // Input parameters
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<string> LocationCode;
        public ReadOnlyBinder<int> OtherOperationType;

        private CultureInfo current_DefaultCultureInfo
        {
            get { return DefaultCultureInfo.Get(); }
        }

        private PmxOseCompany currentPmxOseCompany
        {
            get { return PmxOseCompany.Get(); }
        }

        private string currentLocationCode
        {
            get { return LocationCode == null ? null : LocationCode.Get(); }
        }

        private int currentOtherOperationType
        {
            get
            {
                if (OtherOperationType == null || OtherOperationType.Get() == null || OtherOperationType.Get() == 0)
                {
                    return (int)PmxOtherOperationForCycleCountType.CycleCount;
                }
                return OtherOperationType.Get();
            }
        }

        //Subflows
        /// <summary>
        /// The m_enter quantity sub flow
        /// </summary>
        WorkflowInstanceBase m_enterQuantitySubFlow;

        /// <summary>
        /// The m_sub flow back requested
        /// </summary>
        protected bool m_subFlowBackRequested;
        /// <summary>
        /// The m_sub flow list of serial numbers
        /// </summary>
        protected Collection<string> m_subFlowListOfSerialNumbers;
        /// <summary>
        /// The m_sub flow quantity
        /// </summary>
        protected double m_subFlowQuantity;


        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        // Private fields
        ISboProviderService m_sboProviderService;


        #region Constructors

        public WorkflowScript_CycleCountingWegFullPalletScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base(parent, factory)
        {
            m_enterQuantitySubFlow = this.Create( "EnterQuantityScript" );
        }

        #endregion

        #region WorkflowInstanceScriptBase Members

        /// <summary>
        /// Executes this instance.
        /// </summary>
        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            m_sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

            string selectedLocationCode = null;
            string selectedZoneCode = null;

            string initialErrorKey = null;
            object[] initialErrorParams = null;
            string deviceID = session.DeviceInstanceId;
            SboUserInfo userInfo = m_sboProviderService.GetCurrentUser();
            Message msg = null;
            string query = null;
            bool duringOtherOperation = false;
            bool doesLocationNeedToBeCountedDuringOtherOperation = false;
            bool wasGoBack = false;

            //bool isFirstProductForLocation = true;  // Never used

            Dictionary<string, PmxParameterValue> cycleCountParameters = m_sboProviderService.InvokeMethodWithDbConnection<Dictionary<string, PmxParameterValue>>(false, false, null, null, new DelegateWithPmxDbConnection<Dictionary<string, PmxParameterValue>>(ExecuteGetParametersCycleCountController));

            bool allowToSkipDuringOtherOperations = PmxParameterValueProvider.GetParameterValue<bool>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_ALLOW_SKIP_COUNT, true);
            bool showDifferenceScreenDuringCycleCount = PmxParameterValueProvider.GetParameterValue<bool>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_SHOW_DIFFERENCES_DURING_CYCLE_COUNT, false);
            bool showDifferenceScreenDuringOtherOperation = PmxParameterValueProvider.GetParameterValue<bool>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_SHOW_DIFFERENCES_DURING_OTHER_OPERATION, true);
            string cycleCountTypeOtherOperations = PmxParameterValueProvider.GetParameterValue<string>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_TYPE_OTHER_OPERATIONS, PmxCycleCountTypeCodes.LOST_AND_FOUND);
            string cycleCountTypeCycleCount = PmxParameterValueProvider.GetParameterValue<string>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_TYPE_CYCLE_COUNT, PmxCycleCountTypeCodes.LOST_AND_FOUND);
            bool enterReasonWhenSkippingCount = PmxParameterValueProvider.GetParameterValue<bool>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_ENTER_REASON_SKIP_COUNT, false);
            bool autoHandleBatchNumbers = PmxParameterValueProvider.GetParameterValue<bool>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_AUTO_HANDLE_BATCH, false);
            string defaultBatchOnAutoHandleBatchNumbers = PmxParameterValueProvider.GetParameterValue<string>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_DEFAULT_BATCH_ON_AUTO_HANDLE_BATCH, "CC_BATCH");
            bool proposeItemDefQtyOnLogUnit = PmxParameterValueProvider.GetParameterValue<bool>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_PROPOSE_ITEM_DEF_QTY_ON_LOG_UNIT, false);
            bool autoSelectBatchBBDOnMonolotPallet = PmxParameterValueProvider.GetParameterValue<bool>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_AUTO_SELECT_BATCH_MONOLOT_PALLET, false);


            string cycleCountAutoMoveLUID = PmxParameterValueProvider.GetParameterValue<string>(cycleCountParameters, PmxExtensionParameterCodes.CYCLE_COUNT_AUTO_MOVE_LUID, PmxCycleCountAutoMoveLUIDCodes.NO_MOVE);
            string messageKey = null;

            DataSet dsActiveStocks = null;

            // Local fields
            Dictionary<string, CycleCountInventoryItemInfo> indexItemsToProduce = new Dictionary<string, CycleCountInventoryItemInfo>();
            Collection<CycleCountInventoryItemInfo> listOfItemsToCount = new Collection<CycleCountInventoryItemInfo>();
            string buttonKeySelectPackingTask = null;
            string itemCode = null;
            string itemDescription = null;
            BarcodeContainer barCode = null;
            string GTIN = null;
            string SSCC = null;
            string batchNumber = null;
            string secondBatchNumber = null;
            DateTime? bestBeforeDate = null;
            double quantity = 0;
            double? initialWeight = null;
            double? quantityUom2 = null;
            string identifiedLocationCode = null;
            Collection<string> listOfSerialNumbers = null;

            DataSet dsItems = null;
            PmxItemInfo itemInfo = null;
            bool askToAddMore = false;
            bool cycleCountWithTask = false;
            DataSet dsLocations = null;
            DataSet dsRegistration = null;

            Collection<ItemTransactionalPackagingTypeInfo> currentListOfTransactionalPackagingTypeInfos;
            DataSet dsExistingBatch = null;
            Collection<PackagingTypeInfo> listOfPackagingTypeInfosForScreen = null;

            bool cycleCountOptionAllSSCCs = false;
            int numberOfFullLUID = 0;
            DataSet dsFullLUID = null;
            bool detailedCountAfterFullLUID = false;

            DataSet dsLocationForSSCC = null;

            string reasonCode = null;
            string reasonName = null;
            string reasonFreeText = null;
            Dictionary<string, bool> reasonsCodesRequiresFreeText = null;
            bool enterReasonFreeTextGoBack = false;

            Dictionary<string, PmxItemInfo> cachedItemInfos = new Dictionary<string, PmxItemInfo>();

            bool? isLogisticCarrier = null;
            if (this.currentPmxOseCompany.LogisticCarriersStoredOnOneStorageLocation)
            {
                isLogisticCarrier = false;
            }

            PmxOseWarehouseInfo whsInfo = null;

            PmxOseWarehouseInfo whsInfoDevice = null;
            whsInfoDevice = m_sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), deviceID);

            bool isItemCounting = false;
            List<string> allowedButtonsScanItemScreen = new List<string>();
        //isFirstProductForLocation = true;

            IBarcodeController barcodeController = null;

            m_sboProviderService.InvokeMethodWithDbConnection<object>( false, false, null, null,
             delegate( PmxDbConnection conn, object[] parameters )
             {
                 PmxBarcodeProvider bcProv = new PmxBarcodeProvider( conn );
                 barcodeController = bcProv.GetBarcodeController();

                 return null;
             } );


        Step_GetCycleCountingTask:

            #region GET CYCLE COUNT TASK

            duringOtherOperation = false;
            doesLocationNeedToBeCountedDuringOtherOperation = false;
            // Check if there was a location provided
            if (!string.IsNullOrEmpty(currentLocationCode))
            {
                duringOtherOperation = true;
                if (wasGoBack)
                {
                    enterReasonFreeTextGoBack = false;
                    goto Step_SkipCount;
                }
                wasGoBack = false;
                //this is during other operation, so check if the location needs to be counted
                doesLocationNeedToBeCountedDuringOtherOperation = m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, new DelegateWithPmxDbConnection<bool>(ExecuteDoesLocationNeedToBeCounted), currentLocationCode, currentOtherOperationType);
                if (!doesLocationNeedToBeCountedDuringOtherOperation)
                {
                    //location does not need to be counted, so return
                    return;
                }
                //inform user the location needs to be counted
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "MessageKey", "MSG_CC_LOCATION_NEEDS_TO_BE_COUNTED",
                        "NoTranslationOfMessageKey", false,
                        "ShowButton", true,
                        "MessageAddendum", Environment.NewLine + currentLocationCode));
                WaitForMessage();

                selectedLocationCode = currentLocationCode;
                goto Step_LockLocation;
            }
            else
            {
                wasGoBack = false;
                goto Step_SelectCycleCountTaskForCycleCount;
            }



            #endregion

        Step_SelectCycleCountTaskForCycleCount:

            #region SELECT TASK FOR CYCLE COUNTING

            cycleCountWithTask = false;
            List<string> buttonKeys = new List<string>() { "MSG_BUTTON_CYCLE_COUNT_TASK", "MSG_BUTTON_CYCLE_COUNT_NO_TASK" };
            ToolBarButtons toolBarButtons = ToolBarButtons.Back;

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_CC_TITLE_SELECT_TASK",
                    "AllowedButtons", buttonKeys.ToArray(),
                    "EnabledToolBarButtons", toolBarButtons
                    ));
            msg = WaitForMessage();
            initialErrorKey = null;
            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                string buttonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");

                if (buttonKey == "MSG_BUTTON_CYCLE_COUNT_TASK")
                {
                    cycleCountWithTask = true;
                    goto Step_SelectZone;
                }

                goto Step_IdentifyLocation;
            }

            if (msg.Name.EndsWith(".BackRequested"))
            {
                return;
            }


            #endregion

        Step_IdentifyLocation:

            #region IDENTIFY LOCATION

            identifiedLocationCode = null;

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.MoveOrder.IIdentifyLocationScreen),
            DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_CC_TITLE_SCAN_LOCATION",
                "HideDefaultLocation", true,
                "AllowedButtons", new string[] { "MSG_BUTTON_SELECT_LOCATION" }));
            msg = WaitForMessage();

            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                goto Step_SelectLocation;
            }

            if (msg.Name.EndsWith(".LocationEntered"))
            {
                identifiedLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");

                goto Step_SelectLocation;
            }

            goto Step_SelectCycleCountTaskForCycleCount;


            #endregion

        Step_SelectZone:

            #region SELECT ZONE

            // Get locations
            query = BuildQuery.GetAllZonesToCount(whsInfoDevice.PmxWarehouseCode, userInfo.Username, deviceID);
            dsLocations = m_sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsLocations) == 0)
            {
                // Inform the user
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "MessageKey", "MSG_CC_ERROR_NO_MORE_ZONES_TO_COUNT",
                        "NoTranslationOfMessageKey", false,
                        "ShowButton", true));
                WaitForMessage();

                return;
            }


            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_CC_TITLE_SELECT_ZONE",
                "LocationDS", dsLocations));

            msg = WaitForMessage();
            // Reset latest error
            initialErrorKey = null;
            selectedLocationCode = null;
            selectedZoneCode = null;

            if (msg.Name.EndsWith(".LocationSelected"))
            {
                selectedZoneCode = ExtractParameter<string>(msg.Parameters, "locationCode");

                goto Step_SelectLocation;
            }
            else if (msg.Name.EndsWith(".BackRequested"))
            {
                // We go back on previous step
                goto Step_SelectCycleCountTaskForCycleCount;
            }

            #endregion

        Step_SelectLocation:

            #region SELECT LOCATION

            // Get locations
            query = BuildQuery.GetAllLocationToCount(whsInfoDevice.PmxWarehouseCode, userInfo.Username, cycleCountWithTask, identifiedLocationCode, selectedZoneCode, deviceID);
            dsLocations = m_sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsLocations) == 0)
            {
                // Inform the user
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "MessageKey", cycleCountWithTask ? "MSG_CC_ERROR_NO_MORE_LOCATIONS_TO_COUNT" : "MSG_CC_ERROR_INCORRECT_LOCATION",
                        "NoTranslationOfMessageKey", false,
                        "ShowButton", true));
                WaitForMessage();

                if (!cycleCountWithTask)
                {
                    goto Step_IdentifyLocation;
                }
                else
                {
                    goto Step_SelectZone;
                }
            }


            //we come from identify location, and location was entered
            if (this.GetNumberOfRows(dsLocations) == 1 &&
                !duringOtherOperation && !cycleCountWithTask &&
                !string.IsNullOrEmpty(identifiedLocationCode))
            {
                //autoselect location
                selectedLocationCode = dsLocations.Tables[0].Rows[0][LocationDataSet.Columns.CODE.Name] as string;
                goto Step_LockLocation;
            }


            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectLocationScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_CC_TITLE_SELECT_LOCATION",
                "LocationDS", dsLocations,
                "ShowStopButton", false));

            msg = WaitForMessage();
            // Reset latest error
            initialErrorKey = null;
            selectedLocationCode = null;

            if (msg.Name.EndsWith(".LocationSelected"))
            {
                selectedLocationCode = ExtractParameter<string>(msg.Parameters, "locationCode");

                goto Step_LockLocation;
            }
            else if (msg.Name.EndsWith(".BackRequested"))
            {
                // We go back on previous step
                if (cycleCountWithTask)
                {
                    goto Step_SelectZone;
                }
                else
                {
                    goto Step_IdentifyLocation;
                }
            }
            else if (msg.Name.EndsWith(".StopRequested"))
            {
                // We go back on previous step
                if (cycleCountWithTask)
                {
                    goto Step_SelectZone;
                }
                else
                {
                    goto Step_IdentifyLocation;
                }
            }




            #endregion

        Step_LockLocation:

            #region LOCK LOCATION

            //get whs info
            whsInfo = m_sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>(ExecuteGetPmxWarehouseCode), selectedLocationCode);

            // We must reload the list of items allowed on the location
            dsItems = null;
            // Be shure the current cache list is empty
            indexItemsToProduce.Clear();
            listOfItemsToCount.Clear();

            //check if there is already a registration done for the location
            if ((duringOtherOperation && cycleCountTypeOtherOperations == PmxCycleCountTypeCodes.REGISTRATION) ||
                (!duringOtherOperation && cycleCountTypeCycleCount == PmxCycleCountTypeCodes.REGISTRATION))
            {
                //the type is registration
                query = BuildQuery.GetRegistrations(selectedLocationCode);
                dsRegistration = m_sboProviderService.RunView(false, null, null, query);

                if (this.GetNumberOfRows(dsRegistration) > 0)
                {
                    //there are registrations for the location, so ask user what to do.
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "TitleKey", "MSG_CC_TITLE_REGISTRATIONS_FOUND",
                            "MessageKey", "MSG_CC_QUESTION_REGISTRATIONS_FOUND"));
                    msg = WaitForMessage();

                    if (msg.Name.EndsWith(".Yes"))
                    {
                        try
                        {
                            m_sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null, new DelegateWithPmxDbConnection<object>(ExecuteRemoveRegistration), selectedLocationCode);
                        }
                        catch (Exception ex)
                        {
                            if (!(ex is ProdumexException))
                            {
                                // Inform the user with the error
                                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                                    DefaultCultureInfo.Get(), BuildParamCollection(
                                        "MessageKey", ExceptionHelper.Format(ExceptionHelper.Content.InnerExceptions, ex, DefaultCultureInfo.Get()),
                                        "NoTranslationOfMessageKey", true,
                                        "IsError", true,
                                        "ShowButton", true));
                                WaitForMessage();

                            }
                            else
                            {
                                // Inform the user with the error
                                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                                    DefaultCultureInfo.Get(), BuildParamCollection(
                                        "PmxError", ((ProdumexException)ex).Error,
                                        "ShowButton", true));
                                WaitForMessage();
                            }
                            if (duringOtherOperation)
                            {
                                return;
                            }
                            if (cycleCountWithTask)
                            {
                                goto Step_SelectLocation;
                            }
                            else
                            {
                                goto Step_IdentifyLocation;
                            }
                        }
                    }
                }
            }

            try
            {
                m_sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null, new DelegateWithPmxDbConnection<object>(ExecuteLockLocation), selectedLocationCode);
            }
            catch (Exception ex)
            {
                if (!(ex is ProdumexException))
                {
                    // Inform the user with the error
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "MessageKey", ExceptionHelper.Format(ExceptionHelper.Content.InnerExceptions, ex, DefaultCultureInfo.Get()),
                            "NoTranslationOfMessageKey", true,
                            "IsError", true,
                            "ShowButton", true));
                    WaitForMessage();

                }
                else
                {

                    if (((ProdumexException)ex).Error.ErrorCode == Produmex.Sbo.Logex.Data.ProdumexErrorCodes.LockedLocationCannotBeLockedByAnotherUser)
                    {
                        //already locked by another user
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "MessageKey", "MSG_CC_ERROR_LOCATION_ALREADY_LOCKED",
                                "NoTranslationOfMessageKey", false,
                                "ShowButton", true));
                        WaitForMessage();
                    }
                    else
                    {
                        // Inform the user with the error
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "PmxError", ((ProdumexException)ex).Error,
                                "ShowButton", true));
                        WaitForMessage();
                    }

                }
                if (duringOtherOperation)
                {
                    return;
                }
                if (cycleCountWithTask)
                {
                    goto Step_SelectLocation;
                }
                else
                {
                    goto Step_IdentifyLocation;
                }
            }




            goto Step_SelectCountingOption;
            #endregion

        Step_SelectCountingOption:

            #region SELECT COUNTING OPTION

            cycleCountOptionAllSSCCs = false;
            isItemCounting = false;

            if (cycleCountWithTask)
            {
                buttonKeys = new List<string>() { "MSG_BUTTON_CYCLE_COUNT_COUNT_EVERYTHING", "MSG_BUTTON_CYCLE_COUNT_COUNT_SSCC" };
            }
            else
            {
                buttonKeys = new List<string>() { "MSG_BUTTON_CYCLE_COUNT_COUNT_EVERYTHING", "MSG_BUTTON_CYCLE_COUNT_COUNT_SSCC", "MSG_BUTTON_COUNT_ITEMS" };
            }
            toolBarButtons = ToolBarButtons.Back;

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_CC_TITLE_SELECT_TASK",
                    "AllowedButtons", buttonKeys.ToArray(),
                    "EnabledToolBarButtons", toolBarButtons
                    ));
            msg = WaitForMessage();
            initialErrorKey = null;
            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                string buttonKey = ExtractParameter<string>(msg.Parameters, "buttonKey");

                if (buttonKey == "MSG_BUTTON_CYCLE_COUNT_COUNT_SSCC")
                {
                    cycleCountOptionAllSSCCs = true;
                    detailedCountAfterFullLUID = false;

                    goto Step_EnterNumberOfFullSSCC;
                }
                else if (buttonKey == "MSG_BUTTON_COUNT_ITEMS")
                {
                    isItemCounting = true;
                    goto Step_InitializeScanItem;
                }

                detailedCountAfterFullLUID = false;
                goto Step_ScanSSCC;
            }

            if (msg.Name.EndsWith(".BackRequested"))
            {
                if (listOfItemsToCount != null &&
                    listOfItemsToCount.Count > 0)
                {
                    goto Step_AbortCycleCounting;
                }

                if (duringOtherOperation)
                {
                    // We go back on previous step
                    wasGoBack = true;
                    goto Step_GetCycleCountingTask;
                }

                if (cycleCountWithTask)
                {
                    goto Step_SelectLocation;
                }
                else
                {
                    goto Step_IdentifyLocation;
                }
            }


            #endregion

        Step_ScanSSCC:

            #region SCAN THE SSCC

            SSCC = null;

            //if (!isItemCounting)
            //{
                barCode = null;
            //}

            Collection<string> list = new Collection<string>();

            if ( !( isItemCounting && itemInfo.TrackLocationSerialNumber ) )
            {
                list.Add( "MSG_BUTTON_NO_SSCC" );
            }

            if ((listOfItemsToCount == null ||
                listOfItemsToCount.Count == 0) && !isItemCounting)
            {
                if (!cycleCountOptionAllSSCCs || detailedCountAfterFullLUID)
                {
                    list.Add("MSG_BUTTON_LOCATION_IS_EMPTY");
                }
                else
                {
                    list.Add("MSG_BUTTON_LOCATION_HAS_NO_PARTIAL_SSCC");
                }
                if (allowToSkipDuringOtherOperations &&
                    duringOtherOperation)
                {
                    list.Add("MSG_BUTTON_SKIP_COUNT");
                }
            }




            string[] listOfButtons = new string[list.Count];
            list.CopyTo(listOfButtons, 0);

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IIdentifyGS1DataScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "InitialErrorParams", initialErrorParams,
                    "TitleKey", "MSG_CC_TITLE_IDENTIFY_SSCC",
                    "BarcodeController", barcodeController,
                    "AllowedButtons", listOfButtons,
                    "AllowStopButton", true,
                    "ImageType", GS1ImageType.PalletImage,
                    "ForceGS1_128", true,
                    "GS1DataObject", barCode != null ? barCode.GS1DataObject : null
                    ));

            msg = WaitForMessage();

            //clear data
            initialErrorKey = null;
            initialErrorParams = null;

            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                buttonKeySelectPackingTask = ExtractParameter<string>(msg.Parameters, "buttonKey");

                switch (buttonKeySelectPackingTask)
                {
                    case "MSG_BUTTON_NO_SSCC":
                        SSCC = null;
                        if (isItemCounting)
                        {
                            goto Step_SelectBatchNumber;
                        }
                        goto Step_InitializeScanItem;
                    case "MSG_BUTTON_LOCATION_IS_EMPTY":
                        //ask user if he is sure
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "TitleKey", "MSG_CC_TITLE_LOCATION_EMPTY",
                                "MessageKey", "MSG_CC_QUESTION_LOCATION_EMPTY"));
                        msg = WaitForMessage();

                        if (msg.Name.EndsWith(".Yes"))
                        {
                            // Prepare diffs
                            goto Step_PrepareDataForStock;
                        }
                        break;
                    case "MSG_BUTTON_LOCATION_HAS_NO_PARTIAL_SSCC":
                        //ask user if he is sure
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "TitleKey", "MSG_CC_TITLE_LOCATION_HAS_NO_PARTIAL_SSCC",
                                "MessageKey", "MSG_CC_QUESTION_LOCATION_HAS_NO_PARTIAL_SSCC"));
                        msg = WaitForMessage();

                        if (msg.Name.EndsWith(".Yes"))
                        {
                            // Prepare diffs
                            goto Step_PrepareDataForStock;
                        }
                        break;
                    case "MSG_BUTTON_SKIP_COUNT":
                        enterReasonFreeTextGoBack = false;
                        goto Step_SkipCount;

                    default: break;
                }
            }
            else if (msg.Name.EndsWith(".StopRequested"))
            {
                //ask user if he wants to add another item to the list
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "TitleKey", "MSG_TITLE_STOP_CYCLE_COUNTING",
                        "MessageKey", "MSG_QUESTION_STOP_CYCLE_COUNTING"));
                msg = WaitForMessage();

                if (msg.Name.EndsWith(".Yes"))
                {
                    // Prepare diffs
                    goto Step_PrepareDataForStock;
                }
            }
            else if (msg.Name.EndsWith(".DataEntered"))
            {
                barCode = ExtractParameter<BarcodeContainer>(msg.Parameters, "data");

                //check if there is a product present
                if (barCode != null &&
                !string.IsNullOrEmpty(barCode.GS1DataObject.Sscc))
                {

                    if (m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, new DelegateWithPmxDbConnection<bool>(ExecuteIsMasterLogUnit), barCode.GS1DataObject.Sscc))
                    {
                        initialErrorKey = "MSG_ERROR_CANNOT_USE_MASTER_LOG_UNIT";
                        goto Step_ScanSSCC;
                    }

                    if (PmxSSCCProvider.IsValidChecksumSSCC(barCode.GS1DataObject.Sscc))
					{
                        SSCC = barCode.GS1DataObject.Sscc;

                        if (cycleCountOptionAllSSCCs && !detailedCountAfterFullLUID)
                        {
                            //we need to check if SSCC is not one of the full luid's
                            if (this.GetNumberOfRows(dsFullLUID) > 0)
                            {
                                DataRow[] rows = dsFullLUID.Tables[0].Select(string.Format(" {0} = '{1}'", PmxLogisticUnitIDTable.Columns.SSCC.NAME, SSCC));
                                if (rows.Length > 0)
                                {
                                    // We must ask if the operator wants to leave the process
                                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                                        DefaultCultureInfo.Get(), BuildParamCollection(
                                            "TitleKey", "MSG_CC_TITLE_PARTIAL_SSCC_WAS_COUNTED_AS_FULL",
                                            "MessageKey", "MSG_CC_QUESTION_PARTIAL_SSCC_WAS_COUNTED_AS_FULL"));
                                    msg = WaitForMessage();

                                    if (msg.Name.EndsWith(".No"))
                                    {
                                        //clear counted list, because we need to perform new full detailed count
                                        dsItems = null;
                                        indexItemsToProduce.Clear();
                                        listOfItemsToCount.Clear();
                                        dsFullLUID = null;
                                        detailedCountAfterFullLUID = true;

                                        //inform user detailed count will be needed
                                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                                       DefaultCultureInfo.Get(), BuildParamCollection(
                                           "MessageKey", "MSG_CC_DETAILED_COUNT_NEEDED",
                                           "NoTranslationOfMessageKey", false,
                                           "ShowButton", true));
                                        WaitForMessage();
                                    }

                                    goto Step_ScanSSCC;

                                }
                            }
                        }

                        //check if we can find the SSCC on a different location as the current location
                        //If this is the case, the counting will fail in case of lost and found, because then the LUID will on 2 different locations!
                        if (cycleCountTypeOtherOperations == PmxCycleCountTypeCodes.LOST_AND_FOUND)
                        {
                            query = BuildQuery.GetSSCCOnOtherLocation(SSCC, selectedLocationCode);
                            dsLocationForSSCC = m_sboProviderService.RunView(false, null, null, query);

                            if (this.GetNumberOfRows(dsLocationForSSCC) > 0)
                            {

                                string locCode = dsLocationForSSCC.Tables[0].Rows[0][PmxInventoryTotalTable.Columns.StorLocCode.NAME] as string;
                                int luidOnOtherLocation = Convert.ToInt32(dsLocationForSSCC.Tables[0].Rows[0][PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME]);
                                string otherSboWhs = dsLocationForSSCC.Tables[0].Rows[0][PmxOseWarehouseTable.Columns.SboWarehouseCode.NAME] as string;

                                bool moveLUID = false;

                                if (otherSboWhs == whsInfo.SboWarehouseCode)
                                {
                                    //Only local moves are allowed
                                    switch (cycleCountAutoMoveLUID)
                                    {
                                        case PmxCycleCountAutoMoveLUIDCodes.NO_MOVE:
                                            moveLUID = false;
                                            break;
                                        case PmxCycleCountAutoMoveLUIDCodes.ASK:
                                            //Ask the user
                                            // We must ask if the operator wants to leave the process
                                            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                                                DefaultCultureInfo.Get(), BuildParamCollection(
                                                    "TitleKey", "MSG_TITLE_CYCLE_COUNTING_MOVE_SSCC",
                                                    "MessageKey", "MSG_QUESTION_CYCLE_COUNTING_MOVE_SSCC",
                                                    "Parameters", new object[] { locCode }));
                                            msg = WaitForMessage();

                                            if (msg.Name.EndsWith(".Yes"))
                                            {
                                                moveLUID = true;
                                            }
                                            break;
                                        case PmxCycleCountAutoMoveLUIDCodes.AUTO_MOVE:
                                            moveLUID = true;
                                            break;
                                    }
                                }


                                if (!moveLUID)
                                {
                                    initialErrorParams = new object[1] { locCode };
                                    initialErrorKey = "MSG_ERROR_CC_SSCC_ON_DIFFERENT_LOCATION";
                                    goto Step_ScanSSCC;
                                }
                                else
                                {
                                    //perform move
                                    m_sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                                      delegate(PmxDbConnection conn, object[] parameters)
                                      {
                                          // we need to unlock the location before we can excecute the move
                                          PmxCycleCountProvider ccProv = new PmxCycleCountProvider(conn);
                                          ccProv.UnlockLocation(selectedLocationCode);

                                          PmxMoveProvider prov = new PmxMoveProvider(conn);
                                          prov.MakeAdHocMoveForLUIDs(new Collection<int>() { luidOnOtherLocation }, selectedLocationCode, null, null);
                                          return null;

                                          // we need to lock the location again after to comply with standard cycle counting flow
                                          ccProv.LockLocation(selectedLocationCode);

                                      });
                                }
                            }
                        }

                        // check if batch/BDD must be filled in for monolot pallet
                        // if true, check if monolot pallet, if true, auto-fill batch/BBD
                        if (autoSelectBatchBBDOnMonolotPallet)
                        {
                            if (m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, new DelegateWithPmxDbConnection<bool>(ExecuteIsSSCCMonolotPallet), barCode.GS1DataObject.Sscc))
                            {
                                // set itemcode, batch & DDB and continue

                                query = BuildQuery.GetProductsFromStockOrderByName(null, isItemCounting ? itemCode : null, null, barCode.GS1DataObject.Sscc, true, null, null, null, null, null, false, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, m_sboProviderService.GetDbTool());

                                DataSet dsInventory = m_sboProviderService.RunView(false, null, null, query);

                                if (!isItemCounting)
                                {
                                    itemCode = dsInventory.Tables[0].Rows[0][PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME].ToString();
                                }
                                itemInfo = m_sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>(ExecuteGetItemInfo), itemCode);

                                itemDescription = itemInfo.CustomItemDescription;

                                if (!cachedItemInfos.ContainsKey(itemInfo.ItemCode))
                                {
                                    cachedItemInfos.Add(itemInfo.ItemCode, itemInfo);
                                }

                                // has batch number ?
                                if (itemInfo.HasBatchnumber)
                                {
                                    batchNumber = dsInventory.Tables[0].Rows[0][PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME].ToString();
                                }
                                // has second batch number ?
                                if (itemInfo.HasSecondBatchNumber)
                                {
                                    secondBatchNumber = dsInventory.Tables[0].Rows[0][PmxStockOverviewOnLocationDefinition.Columns.BatchNumber2.NAME].ToString();
                                }

                                // has best before date ?
                                if (itemInfo.HasBestBeforeDate)
                                {
                                    bestBeforeDate = DateTime.Parse(dsInventory.Tables[0].Rows[0][PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME].ToString());
                                }
                                // goto step AFTER batch/BBD selection
                                goto Step_EnterPackagingQuantity;
                            }
                            //no mono lot pallet -> proceed with normal flow
                        }
                        if (isItemCounting)
                        {
                            goto Step_SelectBatchNumber;
                        }

                        buttonKeys = new List<string>( new Collection<string>() { "Full pallet", "Partial pallet" } );
                        toolBarButtons = ToolBarButtons.Back;
                        session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen ),
                                DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "TitleKey", "MSG_TITLE_SELECT_PO_FILTER",
                                "AllowedButtons", buttonKeys.ToArray(),
                                "EnabledToolBarButtons", toolBarButtons
                                ) );
                        msg = WaitForMessage();
                        initialErrorKey = null;
                        if ( msg.Name.EndsWith( ".ButtonClicked" ) )
                        {
                            string filterButtonKey = ExtractParameter<string>( msg.Parameters, "buttonKey" );

                            if ( filterButtonKey == "Full pallet" )
                            {
                                string fullPalletsFileName = @"\\BRJGS100\DFSWEG\APPS\SAP_B1_PRD\WFR\ProdumexInventory\FullSSCC" + DateTime.Now.ToString("yyyyMMdd") + ".txt";

                                string directory = Path.GetDirectoryName( fullPalletsFileName );
                                if ( !Directory.Exists( directory ) ) Directory.CreateDirectory( directory );

                                if ( !File.Exists( fullPalletsFileName ) )
                                {
                                    using ( FileStream fs = File.Create( fullPalletsFileName ) )
                                    {
                                    }
                                }

                                using ( StreamWriter sw = File.AppendText( fullPalletsFileName ) )
                                {
                                    sw.WriteLine( DateTime.Now.ToString( "yyyyMMdd-HHmmss" ) + ";" + selectedLocationCode + ";" + SSCC );
                                }

                                session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen ),
                                    DefaultCultureInfo.Get(), BuildParamCollection(
                                        "MessageKey", "Full pallet counted successfully",
                                        "NoTranslationOfMessageKey", true,
                                        "ShowButton", true ) );

                                msg = WaitForMessage();

                                goto Step_ScanSSCC;
                            }

                            if ( filterButtonKey == "Partial pallet" )
                            {
                                goto Step_InitializeScanItem;
                            }
                        }
                        if ( msg.Name.EndsWith( ".BackRequested" ) )
                        {
                            goto Step_IdentifyLocation;
                        }


                        //sscc is present and valid, so proceed
                        goto Step_InitializeScanItem;
                    }
                }
                initialErrorKey = "MSG_ERROR_INVALID_SSCC";

            }
            else if (msg.Name.EndsWith(".BackRequested"))
            {
               

                if (listOfItemsToCount != null &&
                listOfItemsToCount.Count > 0)
                {
                    goto Step_AbortCycleCounting;
                }
                if (isItemCounting)
                {
                    goto Step_ScanItem;
                }
                //if (cycleCountOptionAllSSCCs)
                //{
                //    goto Step_EnterNumberOfFullSSCC;
                //}

                if (duringOtherOperation)
                {
                    // We go back on previous step
                    wasGoBack = true;
                    goto Step_GetCycleCountingTask;
                }

                if (cycleCountWithTask)
                {
                    goto Step_SelectLocation;
                }
                else
                {
                    goto Step_IdentifyLocation;
                }
            }

            goto Step_ScanSSCC;


            #endregion


        Step_InitializeScanItem:

            #region INITIALIZE SCAN ITEM

            if (barCode != null &&
            !string.IsNullOrEmpty(BarcodeHelper.GetProductIdentification(barCode)))
            {
                GTIN = BarcodeHelper.GetProductIdentification(barCode);

                // Look on the catalog if we can find the item
                DataSet dsCatalogItems = null;


                query = BuildQuery.GetProductsFromCatalogOrderByName(GTIN, null, isLogisticCarrier, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, false, m_sboProviderService.GetDbTool());
                dsCatalogItems = m_sboProviderService.RunView(false, null, null, query);


                //Is there any items available on the catalog
                if (GetNumberOfRows(dsCatalogItems) > 0)
                {
                    DataRow[] rows = null;

                    if (GetNumberOfRows(dsCatalogItems) == 1)
                    {
                        rows = dsCatalogItems.Tables[0].Select();
                    }
                    else
                    {
                        // Be shure the GTIN is in that list
                        rows = dsCatalogItems.Tables[0].Select(string.Format("{0} = '{1}'", ProductDataSet.Columns.GTIN.Name, GTIN));
                    }

                    if (rows.Length > 0)
                    {
                        //copy the data
                        itemCode = rows[0][ProductDataSet.Columns.PRODUCT_CODE.Name] as string;
                        itemDescription = rows[0][ProductDataSet.Columns.PRODUCT_DESCRIPTION.Name] as string;

                        goto Step_InitBeforeItemDetails;
                    }
                }

                // Could not be found
                initialErrorKey = "MSG_ERROR_PRODUCT_NOT_FOUND";
            }

            goto Step_ScanItem;

            #endregion

        Step_ScanItem:

            #region SCAN THE COUNTED ITEM

            allowedButtonsScanItemScreen.Clear();

            if (!PmxOseCompany.Get().DisableItemSelectionInFlows)
            {
                allowedButtonsScanItemScreen.Add("MSG_BUTTON_SELECT_PRODUCT");
            }
            if (isItemCounting)
            {
                allowedButtonsScanItemScreen.Add("MSG_BUTTON_LOCATION_IS_EMPTY");
            }
            //check if there is a product present

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IIdentifyGS1DataScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_CC_TITLE_IDENTIFY_PRODUCT",
                    "BarcodeController", barcodeController,
                    "AllowedButtons", allowedButtonsScanItemScreen.ToArray(),
                    "AllowStopButton", false,
                    "ImageType", GS1ImageType.BoxImage));


            msg = WaitForMessage();
            // Reset latest error
            initialErrorKey = null;
            barCode = null;
            GTIN = null;
            if (!isItemCounting)
            {
                itemCode = null;
                itemDescription = null;
            }

            if (msg.Name.EndsWith(".ButtonClicked"))
            {
                buttonKeySelectPackingTask = ExtractParameter<string>(msg.Parameters, "buttonKey");

                switch (buttonKeySelectPackingTask)
                {
                    case "MSG_BUTTON_SELECT_PRODUCT":
                        goto Step_SelectItem;
                    case "MSG_BUTTON_LOCATION_IS_EMPTY":
                        //ask user if he is sure
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "TitleKey", "MSG_CC_TITLE_LOCATION_EMPTY",
                                "MessageKey", "MSG_CC_QUESTION_LOCATION_EMPTY"));
                        msg = WaitForMessage();

                        if (msg.Name.EndsWith(".Yes"))
                        {
                            // Prepare diffs
                            goto Step_PrepareDataForStock;
                        }
                        break;
                    default: break;
                }
            }
            else if (msg.Name.EndsWith(".DataEntered"))
            {
                barCode = ExtractParameter<BarcodeContainer>(msg.Parameters, "data");

                //check if there is a product present
                if (barCode != null &&
                !string.IsNullOrEmpty(BarcodeHelper.GetProductIdentification(barCode)))
                {
                    GTIN = BarcodeHelper.GetProductIdentification(barCode);

                    // Look on the catalog if we can find the item
                    DataSet dsCatalogItems = null;



                    query = BuildQuery.GetProductsFromCatalogOrderByName( GTIN, null, isLogisticCarrier, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, false, m_sboProviderService.GetDbTool() );
                    dsCatalogItems = m_sboProviderService.RunView(false, null, null, query);


                    //Is there any items available on the catalog
                    if (GetNumberOfRows(dsCatalogItems) > 0)
                    {
                        DataRow[] rows = null;

                        if (GetNumberOfRows(dsCatalogItems) == 1)
                        {
                            rows = dsCatalogItems.Tables[0].Select();
                        }
                        else
                        {
                            // Be shure the GTIN is in that list
                            rows = dsCatalogItems.Tables[0].Select(string.Format("{0} = '{1}'", ProductDataSet.Columns.GTIN.Name, GTIN));
                        }

                        if (rows.Length > 0)
                        {
                            //copy the data
                            itemCode = rows[0][ProductDataSet.Columns.PRODUCT_CODE.Name] as string;
                            itemDescription = rows[0][ProductDataSet.Columns.PRODUCT_DESCRIPTION.Name] as string;
                            PmxItemInfo itemInfoTemp = m_sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>( false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>( ExecuteGetItemInfo ), itemCode );
                            if ( !isItemCounting && itemInfoTemp.TrackLocationSerialNumber && string.IsNullOrEmpty( SSCC ) )
                            {
                                initialErrorKey = "MSG_ERROR_TRACK_LOCATION_PRODUCT_NOT_ALLOWED_WITHOUT_SSCC";
                                goto Step_ScanItem;
                            }
                            else
                            {
                                goto Step_InitBeforeItemDetails;
                            }
                        }
                    }

                    // Could not be found
                    initialErrorKey = "MSG_ERROR_PRODUCT_NOT_FOUND";
                }
                else
                {
                    initialErrorKey = "MSG_ERROR_NO_PRODUCT_ON_BARCODE";
                }
            }           
            else if (msg.Name.EndsWith(".BackRequested"))
            {
                if (isItemCounting)
                {
                    goto Step_AbortCycleCounting;
                }

                goto Step_ScanSSCC;
            }

            goto Step_ScanItem;

            #endregion

        Step_AbortCycleCounting:

            #region ABORT CYCLE COUNTING

            // We must ask if the operator wants to leave the process
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "TitleKey", "MSG_TITLE_LOOSE_CYCLE_COUNTING_DATA",
                    "MessageKey", "MSG_QUESTION_LOOSE_CYCLE_COUNTING_DATA"));
            msg = WaitForMessage();

            if (msg.Name.EndsWith(".No"))
            {
                // Continue to scan
                if (isItemCounting)
                {
                    goto Step_ScanItem;
                }
                goto Step_ScanSSCC;

            }

            //Clear the list
            listOfItemsToCount.Clear();

            if (duringOtherOperation)
            {
                wasGoBack = true;
                goto Step_GetCycleCountingTask;
            }

            if (cycleCountWithTask)
            {
                goto Step_SelectLocation;
            }
            else
            {
                goto Step_IdentifyLocation;
            }

            #endregion

        Step_SelectItem:

            #region SELECT THE COUNTED ITEM

            // If this is the first time we come here, load the full list of items
            if (dsItems == null)
            {
                query = BuildQuery.GetProductsFromCatalogOrderByName( null, null, isLogisticCarrier, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, true, m_sboProviderService.GetDbTool() );
                dsItems = m_sboProviderService.RunView(false, null, null, query);
            }

            // We reuse the list loaded durint the step 'Step_ScanItem'
            if (GetNumberOfRows(dsItems) < 1)
            {
                initialErrorKey = "MSG_ERROR_NO_ITEM_CAN_BE_FOUND";

                goto Step_ScanItem;
            }

            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectProductScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                "InitialErrorKey", initialErrorKey,
                "TitleKey", "MSG_CC_TITLE_SELECT_PRODUCT",
                "ProductDS", dsItems));

            msg = WaitForMessage();

            //clear data
            initialErrorKey = null;
            itemCode = null;
            itemDescription = null;

            if (msg.Name.EndsWith(".ProductSelected"))
            {
                itemCode = ExtractParameter<string>(msg.Parameters, "itemCode");
                //get itemdescription
                DataRow[] rows = dsItems.Tables[0].Select(string.Format("{0} = '{1}'", ProductDataSet.Columns.PRODUCT_CODE.Name, itemCode));
                if (rows.Length > 0)
                {
                    //copy the data
                    itemDescription = rows[0][ProductDataSet.Columns.PRODUCT_DESCRIPTION.Name] as string;

                    PmxItemInfo itemInfoTemp = m_sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>( false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>( ExecuteGetItemInfo ), itemCode );
                    if ( !isItemCounting && itemInfoTemp.TrackLocationSerialNumber && string.IsNullOrEmpty( SSCC ) )
                    {
                        initialErrorKey = "MSG_ERROR_TRACK_LOCATION_PRODUCT_NOT_ALLOWED_WITHOUT_SSCC";
                        goto Step_SelectItem;
                    }
                }
                //select the batch
                goto Step_InitBeforeItemDetails;
            }
            else if (msg.Name.EndsWith(".BackRequested"))
            {
                // We go back on previous step
                goto Step_ScanItem;
            }

            goto Step_SelectItem;

            #endregion

        Step_InitBeforeItemDetails:

            #region Initialise data before we try to get extra info

            // Validate if this item is compatible with the location
            if (!m_sboProviderService.InvokeMethodWithDbConnection<bool>(false, false, null, null, new DelegateWithPmxDbConnection<bool>(ExecuteCanItemBeStoredOnStorageLocation), selectedLocationCode, itemCode))
            {
                initialErrorKey = "MSG_ERROR_ITEMS_CANNOT_BE_STORED_ON_LOCATION";
                goto Step_ScanItem;
            }

            batchNumber = null;
            secondBatchNumber = null;
            bestBeforeDate = null;
            quantity = 0;
            quantityUom2 = null;

            //get the iteminfo
            itemInfo = m_sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>(ExecuteGetItemInfo), itemCode);

            if (!cachedItemInfos.ContainsKey(itemInfo.ItemCode))
            {
                cachedItemInfos.Add(itemInfo.ItemCode, itemInfo);
            }

            if (isItemCounting)
            {
                SSCC = null;
                goto Step_ScanSSCC;
            }
            else
            {
                goto Step_SelectBatchNumber;
            }

            #endregion

        Step_SelectBatchNumber:

            #region PROVIDE THE LOT ASSOCIATED TO THE COUNTED ITEM

            if (itemInfo.HasBatchnumber)
            {
                if (barCode != null &&
                    barCode.GS1DataObject != null &&
                    !string.IsNullOrEmpty(barCode.GS1DataObject.LotNumber))
                {
                    batchNumber = barCode.GS1DataObject.LotNumber.ToUpper();
                }
                else
                {
                    if (!autoHandleBatchNumbers)
                    {
                        //no batchnumber provided, so ask for batchnumber
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IIdentifyGS1DataScreen),
                         DefaultCultureInfo.Get(), BuildParamCollection(
                             "InitialErrorKey", initialErrorKey,
                             "TitleKey", "MSG_CC_TITLE_IDENTIFY_BATCH_NUMBER",
                             "BarcodeController", barcodeController
                             ));
                        msg = WaitForMessage();

                        // reset error
                        initialErrorKey = null;

                        if (msg.Name.EndsWith(".DataEntered"))
                        {
                            barCode = ExtractParameter<BarcodeContainer>(msg.Parameters, "data");

                            if (barCode == null)
                            {
                                goto Step_SelectBatchNumber;
                            }

                            //check if there is a product present
                            if (barCode != null &&
                            !string.IsNullOrEmpty(barCode.GS1DataObject.LotNumber))
                            {
                                batchNumber = barCode.GS1DataObject.LotNumber;
                                goto Step_SecondBatchNumber;
                            }

                            if (barCode != null &&
                            !string.IsNullOrEmpty(barCode.FreeBarcode) &&
                                barCode.FreeBarcode.Length <= 36)
                            {
                                //We got a free barcode, so in this case we will suppose this is an entered batch number.
                                //However it is possible that the GS1 barcode was not started with a valid FNC1 symbol, resulting in not getting the correct barcode.
                                //So if length is greater than 36, it is not a valid batch number!
                                batchNumber = barCode.FreeBarcode;
                                goto Step_SecondBatchNumber;
                            }
                        }
                        else if (msg.Name.EndsWith(".BackRequested"))
                        {
                            goto Step_ScanItem;
                        }

                        goto Step_SelectBatchNumber;

                        


                        ////no batchnumber provided, so ask for batchnumber
                        //session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterStringValueScreen),
                        // DefaultCultureInfo.Get(), BuildParamCollection(
                        //     "InitialErrorKey", initialErrorKey,
                        //     "TitleKey", "MSG_CC_TITLE_IDENTIFY_BATCH_NUMBER",
                        //     "ForceDataEntry", true,
                        //     "ForceUppercase", true,
                        //     "AllowToGoBack", true
                        //     ));
                        //msg = WaitForMessage();

                        //// reset error
                        //initialErrorKey = null;

                        //if (msg.Name.EndsWith(".StringEntered"))
                        //{
                        //    batchNumber = ExtractParameter<string>(msg.Parameters, "stringValue");
                        //    //TODO : Do we have to check the length of the provided value ?
                        //    goto Step_SecondBatchNumber;
                        //}
                        //else if (msg.Name.EndsWith(".BackRequested"))
                        //{
                        //    goto Step_ScanItem;
                        //}

                        //goto Step_SelectBatchNumber;
                    }
                    else
                    {
                        //get youngest batch on the location
                        query = BuildQuery.GetExistingYoungestBatch(itemCode, selectedLocationCode);
                        DataSet dsYoungestBatch = m_sboProviderService.RunView(false, null, null, query);

                        if (GetNumberOfRows(dsYoungestBatch) > 0)
                        {
                            batchNumber = dsYoungestBatch.Tables[0].Rows[0][PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME] as string;
                            if (itemInfo.HasSecondBatchNumber)
                            {
                                secondBatchNumber = dsYoungestBatch.Tables[0].Rows[0][PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME] as string;
                            }
                        }
                        else
                        {
                            batchNumber = defaultBatchOnAutoHandleBatchNumbers;
                            if (itemInfo.HasSecondBatchNumber)
                            {
                                secondBatchNumber = batchNumber;
                            }
                        }

                        goto Step_BestBeforeDate;
                    }
                }
            }
            else
            {
                //no batchnumber, so we try to get second batch number
                goto Step_SecondBatchNumber;
            }

            #endregion

        Step_SecondBatchNumber:

            #region PROVIDE THE SECOND BATCH ASSOCIATED TO THE COUNTED ITEM

            if (itemInfo.HasSecondBatchNumber)
            {
                //ask for second batchnumber
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterStringValueScreen),
                 DefaultCultureInfo.Get(), BuildParamCollection(
                     "InitialErrorKey", initialErrorKey,
                     "TitleKey", "MSG_CC_TITLE_IDENTIFY_BATCH_NUMBER2",
                     "ForceDataEntry", true,
                     "ForceUppercase", true,
                     "AllowToGoBack", true
                     ));
                msg = WaitForMessage();

                // reset error
                initialErrorKey = null;

                if (msg.Name.EndsWith(".StringEntered"))
                {
                    secondBatchNumber = ExtractParameter<string>(msg.Parameters, "stringValue");
                    //TODO : Do we have to check the length of the provided value ?
                    goto Step_BestBeforeDate;
                }
                else if (msg.Name.EndsWith(".BackRequested"))
                {
                    goto Step_ScanItem;
                }

                goto Step_SecondBatchNumber;

            }
            else
            {
                //no second batchnumber, so we try to get best before date
                goto Step_BestBeforeDate;
            }

            #endregion

        Step_BestBeforeDate:

            #region PROVIDE BEST BEFORE DATE ASSOCIATED TO THE COUNTED ITEM

            if (itemInfo.HasBestBeforeDate)
            {
                if (barCode != null &&
                    barCode.GS1DataObject != null &&
                    barCode.GS1DataObject.BestBeforeDate.HasValue)
                {
                    bestBeforeDate = barCode.GS1DataObject.BestBeforeDate.Value;
                }
                else
                {
                    //ask for best before date
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterDateScreen),
                     DefaultCultureInfo.Get(), BuildParamCollection(
                         "InitialErrorKey", initialErrorKey,
                         "TitleKey", "MSG_CC_TITLE_ENTER_BEST_BEFORE_DATE",
                         "DefaultDate", DateTime.Now,
                         "AllowToGoBack", true
                         ));
                    msg = WaitForMessage();

                    // reset error
                    initialErrorKey = null;

                    if (msg.Name.EndsWith(".DateEntered"))
                    {
                        bestBeforeDate = ExtractParameter<DateTime?>(msg.Parameters, "date");

                        goto Step_CheckIfBatchNumberExists;
                    }
                    else if (msg.Name.EndsWith(".BackRequested"))
                    {
                        goto Step_ScanItem;
                    }

                    goto Step_BestBeforeDate;
                }
            }
            else
            {
                //no best before date
                goto Step_CheckIfBatchNumberExists;
            }

            #endregion

        Step_CheckIfBatchNumberExists:

            #region CHECK IF BATCH NUMBER EXISTS


            if (!autoHandleBatchNumbers)
            {
                query = BuildQuery.GetProductsFromStockOrderByName(null, itemCode, null, null, false, null, isLogisticCarrier, batchNumber, secondBatchNumber, bestBeforeDate, true, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, m_sboProviderService.GetDbTool());
                dsActiveStocks = m_sboProviderService.RunView(false, null, null, query);

                if (this.GetNumberOfRows(dsActiveStocks) == 0 &&
                    (itemInfo.HasBatchnumber || itemInfo.HasSecondBatchNumber || itemInfo.HasBestBeforeDate))
                {
                    //the stock is not found, ask if user wants to provide batch again.
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "TitleKey", "MSG_CC_TITLE_BATCH_NOT_FOUND",
                            "MessageKey", "MSG_CC_QUESTION_BATCH_NOT_FOUND"));
                    msg = WaitForMessage();

                    if (msg.Name.ToLower().EndsWith(".yes"))
                    {
                        goto Step_SelectBatchNumber;
                    }
                }
            }


            goto Step_EnterPackagingQuantity;
            #endregion

        Step_EnterPackagingQuantity:

            #region ENTER PACKAGING QUANTITY

            if ((itemInfo.HasBatchnumber || itemInfo.HasSecondBatchNumber || itemInfo.HasBestBeforeDate))
            {
                currentListOfTransactionalPackagingTypeInfos = GetTransactionalPackagingInfo(indexItemsToProduce, batchNumber, secondBatchNumber, bestBeforeDate, itemInfo.ItemCode);

                if (currentListOfTransactionalPackagingTypeInfos == null)
                {
                    query = BuildQuery.GetExistingITRI(itemCode, batchNumber, secondBatchNumber, bestBeforeDate);
                    dsExistingBatch = m_sboProviderService.RunView(false, null, null, query);

                    if (this.GetNumberOfRows(dsExistingBatch) == 0)
                    {
                        //batch not found, so we need to enter the quantity for the packaging types
                        currentListOfTransactionalPackagingTypeInfos = SetItemTransactionalPackagingTypeInfoList(itemInfo);
                        bool foundAtLeastOnePackagingTypeToShowOnScreen = false;
                        bool isFirst = true;
                        listOfPackagingTypeInfosForScreen = new Collection<PackagingTypeInfo>();
                        foreach (PmxItemPackagingTypeInfo packType in itemInfo.ListOfPackagingTypes)
                        {

                            PackagingTypeInfo info = new PackagingTypeInfo();

                            if (isFirst)
                            {
                                info.NumberOfDecimals = itemInfo.UomDecimals;
                            }

                            info.Quantity = packType.Quantity;
                            info.PackagingTypeCode = packType.PackagingTypeCode;
                            info.PackagingTypeName = packType.PackagingTypeName;

                            info.ShowOnScreen = (packType.AskDuringReception &&
                            (!packType.Barcodes.Contains(GTIN)));

                            listOfPackagingTypeInfosForScreen.Add(info);

                            if (!foundAtLeastOnePackagingTypeToShowOnScreen &&
                                info.ShowOnScreen)
                            {
                                foundAtLeastOnePackagingTypeToShowOnScreen = true;
                            }
                            isFirst = false;
                        }

                        if (foundAtLeastOnePackagingTypeToShowOnScreen)
                        {
                            if (proposeItemDefQtyOnLogUnit && !String.IsNullOrEmpty(SSCC) && itemInfo.DefaultQuantityOnLogisticUnit > 0)
                            {
                                double qtyOnLogUnit = itemInfo.DefaultQuantityOnLogisticUnit;

                                for (int i = listOfPackagingTypeInfosForScreen.Count - 1; i >= 0; i--)
                                {
                                    if (SboQuantity.IsZeroOrLess(qtyOnLogUnit, itemInfo.UomDecimals))
                                    {
                                        break;
                                    }
                                    PackagingTypeInfo info = listOfPackagingTypeInfosForScreen[i];
                                    info.InitialQuantity = Math.Floor(qtyOnLogUnit / info.Quantity + SboQuantity.EpsilonBeforeRounding);
                                    qtyOnLogUnit = Math.Round(qtyOnLogUnit - info.InitialQuantity.Value * info.Quantity, itemInfo.UomDecimals);
                                }
                            }

                            initialErrorKey = "MSG_ENTER_QUANTITY_OF_ALL_PACKAGING_TYPES";
                            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterPackagingQuantityScreen),
                                DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "TitleKey", "MSG_CC_TITLE_ENTER_QUANTITY_OF_ALL_PACKAGING_TYPES",
                                "BarcodeController", barcodeController,
                                "ItemDescription", itemInfo.Description,
                                "ItemCode", itemInfo.ItemCode,
                                "ItemBarcode", itemInfo.CodeBars, "UOM", itemInfo.InventoryUom,
                                "ListOfPackagingTypeInfos", listOfPackagingTypeInfosForScreen,
                                "IsForEnteringDefaultPackagingQuantity", true,
                                "BatchNumber", batchNumber,
                                "BestBeforeDate", bestBeforeDate,
                                "SSCC", SSCC,
                                "DocNum", null
                                ));

                            msg = WaitForMessage();

                            // reset error
                            initialErrorKey = null;

                            if (msg.Name.EndsWith(".QuantitiesEntered"))
                            {
                                PackagingTypeInfos screenListOfPackagingTypeInfos = ExtractParameter<PackagingTypeInfos>(msg.Parameters, "listOfPackagingTypeInfos");

                                //build the list of packaging quantities
                                foreach (ItemTransactionalPackagingTypeInfo info in currentListOfTransactionalPackagingTypeInfos)
                                {
                                    //try to get new qty from user
                                    if (screenListOfPackagingTypeInfos.PackagingTypeInfoList.ContainsKey(info.PackagingTypeCode))
                                    {
                                        info.Quantity = screenListOfPackagingTypeInfos.PackagingTypeInfoList[info.PackagingTypeCode].Quantity;
                                    }
                                }

                                goto Step_EnterQuantity;
                            }
                            else if (msg.Name.EndsWith(".BackRequested"))
                            {
                                if (isItemCounting)
                                {
                                    goto Step_ScanSSCC;
                                }
                                goto Step_ScanItem;
                            }

                        }

                    }
                    else
                    {
                        //we found the batch, so now fill in the packaging data from the batch
                        currentListOfTransactionalPackagingTypeInfos = new Collection<ItemTransactionalPackagingTypeInfo>();
                        foreach (DataRow row in dsExistingBatch.Tables[0].Rows)
                        {
                            ItemTransactionalPackagingTypeInfo newPackInfo = new ItemTransactionalPackagingTypeInfo();

                            newPackInfo.PackagingTypeCode = Convert.ToString(row[PmxItemTransactionalPackagingTypeTable.Columns.PackagingTypeCode.NAME]);
                            newPackInfo.Quantity = Convert.ToDouble(row[PmxItemTransactionalPackagingTypeTable.Columns.Quantity.NAME]);
                            newPackInfo.ItriKey = Convert.ToInt32(row[PmxItemTransactionalInfoTable.Columns.InternalKey.NAME]);

                            newPackInfo.ItemCode = itemInfo.ItemCode;

                            currentListOfTransactionalPackagingTypeInfos.Add(newPackInfo);
                        }

                        goto Step_EnterQuantity;
                    }
                }

                goto Step_EnterQuantity;
            }
            else
            {
                //no batch info
                //get the packaging types qty from item
                currentListOfTransactionalPackagingTypeInfos = SetItemTransactionalPackagingTypeInfoList(itemInfo);



                goto Step_EnterQuantity;
            }

            #endregion

        Step_EnterQuantity:

            #region ENTER QUANTITY

            quantity = 0;
            quantityUom2 = null;

            //if (isItemCounting)
            //{
            //    barCode = null;
            //}

            listOfSerialNumbers = null;
            if ( ( itemInfo.HasSerialNumber || itemInfo.HasSAPSerialNumber ) && itemInfo.TrackLocationSerialNumber )
            {
                //show screen to ask user what to do.
                buttonKeys = new List<string>( new Collection<string>() { "MSG_BUTTON_SERIAL_NUMBER", "MSG_BUTTON_SERIAL_NUMBER_RANGE" } );

                // don't allow quantity for SAP serials on every transaction
                if ( !itemInfo.ForceSerialNumberCycleCount && !( itemInfo.HasSAPSerialNumber && itemInfo.ManageMethod == SboItemManageMethod.OnEveryTransaction ) )
                {
                    buttonKeys.Add( "MSG_BUTTON_QUANTITY" );
                }

                toolBarButtons = ToolBarButtons.Back;

                session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen ),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                        "InitialErrorKey", initialErrorKey,
                        "TitleKey", "MSG_TITLE_ENTER_QUANTITY_SERIAL_NUMBER_TASK",
                        "AllowedButtons", buttonKeys.ToArray(),
                        "EnabledToolBarButtons", toolBarButtons
                        ) );
                msg = WaitForMessage();
                bool goBack = false;
                initialErrorKey = null;
                if ( msg.Name.EndsWith( ".ButtonClicked" ) )
                {
                    string buttonKeySerial = ExtractParameter<string>( msg.Parameters, "buttonKey" );

                    if ( buttonKeySerial == "MSG_BUTTON_SERIAL_NUMBER" ||
                        buttonKeySerial == "MSG_BUTTON_SERIAL_NUMBER_RANGE" )
                    {

                        #region ENTER SERIAL NUMBERS

                        bool isSerialNumberRange = ( buttonKeySerial == "MSG_BUTTON_SERIAL_NUMBER_RANGE" );

                        m_enterQuantitySubFlow.BindParameters(
                            this.DefaultCultureInfo,
                            this.PmxOseCompany,
                            new ReadOnlyBinder<string>( "TitleKey", "MSG_TITLE_ENTER_QUANTITY" ),
                            new ReadOnlyBinder<PmxItemInfo>( "ItemInfo", itemInfo ),
                            new ReadOnlyBinder<string>( "BatchNumber", batchNumber ),
                            new ReadOnlyBinder<DateTime?>( "BestBeforeDate", bestBeforeDate ),
                            new ReadOnlyBinder<int?>( "ItriKey", null ),
                            new ReadOnlyBinder<string>( "LocationCode", null ),
                            new ReadOnlyBinder<string>( "SSCC", SSCC ),

                            new ReadOnlyBinder<string>( "DocNum", null ),
                            new ReadOnlyBinder<bool>( "UsePickingInfo", false ),

                            new ReadOnlyBinder<bool>( "AllowZero", false ),
                            new ReadOnlyBinder<double>( "InitialQuantity", 0 ),
                            new ReadOnlyBinder<string>( "MessageKeyStillQuantity", "MSG_LBL_STILL_TO_RECEIVE" ),
                            new ReadOnlyBinder<double>( "StillToQuantity", 0 ),
                            new ReadOnlyBinder<double>( "MaximumQuantity", -1 ),
                            new ReadOnlyBinder<double>( "TotalQuantityToPick", 0 ),
                            new ReadOnlyBinder<string>( "UOM", itemInfo.InventoryUom ),
                            new ReadOnlyBinder<int>( "NumberOfDigitsAfterDecimal", ( itemInfo != null ) ? itemInfo.UomDecimals : 0 ),

                            new ReadOnlyBinder<double>( "InnerQuantity", 1 ),
                            new ReadOnlyBinder<string>( "InnerUOM", null ),
                            new ReadOnlyBinder<bool>( "ForceInputSerialNumbers", true ),
                            new ReadOnlyBinder<string>( "ObjectType", PmxObjectTypes.PmxCycleCount ),
                            new ReadOnlyBinder<int?>( "DocEntry", null ),
                            new ReadOnlyBinder<bool>( "UseSerialNumberRange", isSerialNumberRange ),

                            new ReadOnlyBinder<int?>( "LUID", null ),


                            new ReadWriteBinder<double>( "QuantityEntered", this, "m_subFlowQuantity" ),
                            new ReadWriteBinder<bool>( "BackRequested", this, "m_subFlowBackRequested" ),
                            new ReadWriteBinder<Collection<string>>( "ListOfSerialNumbers", this, "m_subFlowListOfSerialNumbers" )

                            );
                        m_subFlowBackRequested = false;
                        this.StartSubFlowAndWait( m_enterQuantitySubFlow, true );

                        if ( m_subFlowBackRequested )
                        {
                            goto Step_EnterQuantity;
                        }

                        listOfSerialNumbers = m_subFlowListOfSerialNumbers;

                        quantity = m_subFlowQuantity;

                        goto Step_NewDataForCounting;

                        #endregion

                    }
                }

                if ( msg.Name.EndsWith( ".BackRequested" ) )
                {
                    if ( isItemCounting )
                    {
                        goto Step_ScanSSCC;
                    }
                    goto Step_ScanItem;
                }

            }


            if (itemInfo.IsCatchWeightItem)
            {
                #region ENTER QUANTITY CATCH WEIGHT

                bool askForPieces = itemInfo.UomToUseForInventoryTransitions == PmxUomToUse.UOM1AndUOM2 ||
                        itemInfo.UomToUseForInventoryTransitions == PmxUomToUse.UOM1;
                bool askForWeight = itemInfo.UomToUseForInventoryTransitions == PmxUomToUse.UOM1AndUOM2 ||
                                    itemInfo.UomToUseForInventoryTransitions == PmxUomToUse.UOM2;


                double? quantityForPieces = null;
                double? quantityForWeight = null;

                double initialQuantity = 0;

                //Only set qty if it needs to be set
                initialWeight = BarcodeHelper.GetQuantityForMeasureType(itemInfo.Uom2GS1MeasureType, barCode, null);

                if ((proposeItemDefQtyOnLogUnit && !String.IsNullOrEmpty(SSCC)))
                {
                    initialQuantity = Math.Max(1, itemInfo.DefaultQuantityOnLogisticUnit);
                    initialWeight = PmxItemAllConnectionsProvider.CalculateWeightFromPieces(initialQuantity, itemInfo);
                }
                else
                {
                    if (IsQuantityOnBarcode(barCode))
                    {
                        initialQuantity = Convert.ToDouble(barCode.GS1DataObject.Count);
                    }
                    else
                    {
                        if (initialWeight.HasValue)
                        {
                            initialQuantity = PmxItemAllConnectionsProvider.CalculatePiecesFromWeight(initialWeight.Value, itemInfo).Value;
                        }
                        else
                        {
                            initialQuantity = 1;
                        }
                    }
                }
               


                if (askForPieces)
                {

                    if (itemInfo.ListOfPackagingTypes != null &&
                        currentListOfTransactionalPackagingTypeInfos.Count > 0)
                    {
                        //build list of packaging types
                        listOfPackagingTypeInfosForScreen = new Collection<PackagingTypeInfo>();

                        //add first one for the uom

                        PackagingTypeInfo info = new PackagingTypeInfo();

                        info.Quantity = 1;
                        info.PackagingTypeCode = null;
                        info.PackagingTypeName = itemInfo.InventoryUom == null ? itemInfo.ItemCode : itemInfo.InventoryUom;
                        info.QuantityPerPack = 1;
                        if (!string.IsNullOrEmpty(itemInfo.CodeBars))
                        {
                            info.Barcode.Add(itemInfo.CodeBars);
                        }
                        info.NumberOfDecimals = itemInfo.UomDecimals;
                        if (info.Barcode.Contains(GTIN))
                        {
                            info.InitialQuantity = 1;
                        }
                        else
                        {
                            info.InitialQuantity = 0;
                        }
                        listOfPackagingTypeInfosForScreen.Add(info);


                        foreach (ItemTransactionalPackagingTypeInfo packType in currentListOfTransactionalPackagingTypeInfos)
                        {
                            info = new PackagingTypeInfo();

                            info.Quantity = packType.Quantity;
                            info.PackagingTypeCode = packType.PackagingTypeCode;
                            info.PackagingTypeName = GetPackTypeName(packType.PackagingTypeCode, itemInfo.ListOfPackagingTypes);
                            info.Barcode = GetPackBarcode(packType.PackagingTypeCode, itemInfo.ListOfPackagingTypes);

                            if (info.Barcode.Contains(GTIN))
                            {
                                info.InitialQuantity = 1;
                                //Check if barcode is also added to inventory uom.
                                //If so, we need to adjust initial qty
                                if (listOfPackagingTypeInfosForScreen[0].Barcode.Contains(GTIN))
                                {
                                    listOfPackagingTypeInfosForScreen[0].InitialQuantity = 0;
                                }
                            }
                            else
                            {
                                info.InitialQuantity = 0;
                            }

                            info.QuantityPerPack = packType.Quantity;

                            listOfPackagingTypeInfosForScreen.Add(info);
                        }

                        if (proposeItemDefQtyOnLogUnit && !String.IsNullOrEmpty(SSCC) && itemInfo.DefaultQuantityOnLogisticUnit > 0)
                        {
                            double qtyOnLogUnit = itemInfo.DefaultQuantityOnLogisticUnit;

                            for (int i = listOfPackagingTypeInfosForScreen.Count - 1; i >= 0; i--)
                            {
                                if (SboQuantity.IsZeroOrLess(qtyOnLogUnit, itemInfo.UomDecimals))
                                {
                                    break;
                                }
                                info = listOfPackagingTypeInfosForScreen[i];
                                info.InitialQuantity = Math.Floor(qtyOnLogUnit / info.Quantity + SboQuantity.EpsilonBeforeRounding);
                                qtyOnLogUnit = Math.Round(qtyOnLogUnit - info.InitialQuantity.Value * info.Quantity, itemInfo.UomDecimals);
                            }
                        }

                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterPackagingQuantityScreen),
                                            DefaultCultureInfo.Get(), BuildParamCollection(
                                            "InitialErrorKey", initialErrorKey,
                                            "TitleKey", "MSG_CC_TITLE_ENTER_QUANTITY",
                                            "BarcodeController", barcodeController,
                                            "ItemDescription", itemInfo.Description,
                                            "ItemCode", itemInfo.ItemCode,
                                            "ItemBarcode", itemInfo.CodeBars,
                                            "UOM", itemInfo.InventoryUom,
                                            "ListOfPackagingTypeInfos", listOfPackagingTypeInfosForScreen,
                                            "IsForEnteringDefaultPackagingQuantity", false,
                                            "BatchNumber", batchNumber,
                                            "BestBeforeDate", bestBeforeDate,
                                            "SSCC", SSCC,
                                            "DocNum", null,
                                            "StillToQuantity", null,
                                            "MessageKeyStillQuantity", null,
                                            "AllowZero", false
                                            ));

                        msg = WaitForMessage();
                        // reset error
                        initialErrorKey = null;

                        if (msg.Name.EndsWith(".QuantitiesEntered"))
                        {
                            PackagingTypeInfos screenListOfPackagingTypeInfos = ExtractParameter<PackagingTypeInfos>(msg.Parameters, "listOfPackagingTypeInfos");

                            quantityForPieces = 0;

                            //build the list of packaging quantities
                            foreach (PackagingTypeInfo infoForQty in screenListOfPackagingTypeInfos.PackagingTypeInfoList.Values)
                            {
                                quantityForPieces += (infoForQty.Quantity * infoForQty.QuantityPerPack);
                            }

                        }
                        else if (msg.Name.EndsWith(".BackRequested"))
                        {
                            if (isItemCounting)
                            {
                                goto Step_ScanSSCC;
                            }
                            goto Step_ScanItem;
                        }
                    }
                    else
                    {

                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityWithItemInfoScreen),
                           DefaultCultureInfo.Get(), BuildParamCollection(
                               "InitialErrorKey", initialErrorKey,
                               "TitleKey", "MSG_CC_TITLE_ENTER_QUANTITY",
                               "BarcodeController", barcodeController,
                               "InitialQuantity", ( proposeItemDefQtyOnLogUnit && !String.IsNullOrEmpty( SSCC ) ) ? Math.Max( 1, itemInfo.DefaultQuantityOnLogisticUnit ) : 1,
                               "NumberOfDigitsAfterDecimal", itemInfo.UomDecimals,
                               "MaximumQuantity", -1,
                               "UOM", itemInfo.InventoryUom,
                               "ItemDescription", itemDescription,
                               "ItemCode", itemCode,
                               "ItemBarcode", itemInfo.CodeBars,
                               "BatchNumber", batchNumber,
                               "BestBeforeDate", bestBeforeDate,
                               "SSCC", SSCC,
                               "StillToQuantity", null
                              ));

                        msg = WaitForMessage();
                        // reset error
                        initialErrorKey = null;

                        if (msg.Name.EndsWith(".QuantityEntered"))
                        {
                            quantityForPieces = ExtractParameter<double>(msg.Parameters, "quantity");
                        }
                        else if (msg.Name.EndsWith(".BackRequested"))
                        {
                            if (isItemCounting)
                            {
                                goto Step_ScanSSCC;
                            }
                            goto Step_ScanItem;
                        }
                    }
                }

                double totalInvQtyScanned = 0;

                if (askForWeight)
                {

                    quantityForWeight = 0;
                    double maxQuantityForWeight = -1;

                    if (quantityForPieces.HasValue)
                    {
                        //Calculate weight maximum
                        double? tempMax = PmxItemAllConnectionsProvider.GetMaximumWeightForCatchWeightItem(quantityForPieces.Value, itemInfo);

                        if (itemInfo.CatchWeightWeightTolerancePercentage >= 100)
                        {
                            //Tolerance greater than 100%, so actually no maximum is required
                            maxQuantityForWeight = -1;
                        }
                        else
                        {
                            //Calculate weight maximum
                            if (tempMax.HasValue)
                            {
                                maxQuantityForWeight = tempMax.Value;
                            }
                        }
                    }

                    totalInvQtyScanned = 0;

                    //Get quantity from scanned barcode in previous steps.
                    if (barCode != null)
                    {
                        double? quantityForWeightFromBarCode = BarcodeHelper.GetQuantityForMeasureType(itemInfo.Uom2GS1MeasureType, barCode, null);
                        if (quantityForWeightFromBarCode.HasValue)
                        {
                            quantityForWeight = quantityForWeightFromBarCode;
                            totalInvQtyScanned += PmxItemAllConnectionsProvider.CalculatePiecesFromWeight(quantityForWeightFromBarCode.Value, itemInfo).Value;
                            initialWeight = 0;
                        }
                    }


                Step_NextWeight:

                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityWithItemInfoScreen),
                      DefaultCultureInfo.Get(), BuildParamCollection(
                          "InitialErrorKey", initialErrorKey,
                          "TitleKey", "MSG_CC_TITLE_ENTER_WEIGHT",
                          "BarcodeController", barcodeController,
                          "InitialQuantity", initialWeight,
                          "NumberOfDigitsAfterDecimal", itemInfo.Uom2Decimals,
                          "MaximumQuantity", maxQuantityForWeight,
                          "UOM", itemInfo.Uom2,
                          "ItemDescription", itemDescription,
                          "ItemCode", itemCode,
                          "ItemBarcode", itemInfo.CodeBars,
                          "BatchNumber", batchNumber,
                          "BestBeforeDate", bestBeforeDate,
                          "SSCC", SSCC,
                          "StillToQuantity", null,
                          "ForceGS1_128", true,
                          "GS1WeightAI", itemInfo.Uom2GS1MeasureType,
                          "UomToDisplayOnQtyProvider", itemInfo.Uom2,
                          "QtyEntered", quantityForWeight.Value,
                          "AllowZero", true
                         ));

              
                    msg = WaitForMessage();
                    // reset error
                    initialErrorKey = null;

                    if (msg.Name.EndsWith(".QuantityEntered"))
                    {
                        double tempWeight = ExtractParameter<double>(msg.Parameters, "quantity");
                        if (tempWeight != 0)
                        {
                            if (!quantityForWeight.HasValue)
                            {
                                quantityForWeight = 0;
                            }

                            double tempInvQty = PmxItemAllConnectionsProvider.CalculatePiecesFromWeight(tempWeight, itemInfo).Value;
                            totalInvQtyScanned += tempInvQty;
                            quantityForWeight += tempWeight;

                            //Reset initial quantity
                            initialWeight = null;

                            if (!quantityForPieces.HasValue ||
                                (quantityForPieces.HasValue && totalInvQtyScanned < quantityForPieces.Value))
                            {
                                //Pieces were asked, and the number of pieces was not reached yet, so ask next weight.
                                goto Step_NextWeight;
                            }
                        }
                    }
                    else if (msg.Name.EndsWith(".BackRequested"))
                    {
                        if (isItemCounting)
                        {
                            goto Step_ScanSSCC;
                        }
                        goto Step_ScanItem;
                    }
                }

                //Check if we need to calculate any of the quantities.
                if (!quantityForWeight.HasValue)
                {
                    //Check if there was weight on the barcode.
                    //If so, use this weight if it is within tolerance
                    //Get quantity from scanned barcode in previous steps.
                    if (barCode != null)
                    {
                        double? tempQuantityForWeight = BarcodeHelper.GetQuantityForMeasureType(itemInfo.Uom2GS1MeasureType, barCode, null);
                        if (tempQuantityForWeight.HasValue &&
                            quantityForPieces.HasValue &&
                            PmxItemAllConnectionsProvider.IsCatchWeightWithinTolerance(quantityForPieces.Value, tempQuantityForWeight.Value, itemInfo))
                        {
                            quantityForWeight = tempQuantityForWeight;
                        }
                    }

                    if (!quantityForWeight.HasValue)
                    {
                        quantityForWeight = PmxItemAllConnectionsProvider.CalculateWeightFromPieces(quantityForPieces.Value, itemInfo);
                    }
                }
                else if (!quantityForPieces.HasValue)
                {
                    if (totalInvQtyScanned > 0)
                    {
                        quantityForPieces = totalInvQtyScanned;
                    }
                    else
                    {
                        quantityForPieces = PmxItemAllConnectionsProvider.CalculatePiecesFromWeight(quantityForWeight.Value, itemInfo);
                    }
                }


                //if (!quantityForWeight.HasValue)
                //{
                //    quantityForWeight = PmxItemAllConnectionsProvider.CalculateWeightFromPieces(quantityForPieces.Value, itemInfo);
                //}
                //else if (!quantityForPieces.HasValue)
                //{
                //    quantityForPieces = PmxItemAllConnectionsProvider.CalculatePiecesFromWeight(quantityForWeight.Value, itemInfo);
                //}


                quantity = quantityForPieces.Value;
                quantityUom2 = quantityForWeight.Value;

                //Check if quantity is within tolerance
                if (!PmxItemAllConnectionsProvider.IsCatchWeightWithinTolerance(quantityForPieces.Value, quantityForWeight.Value, itemInfo))
                {
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            this.DefaultCultureInfo, BuildParamCollection(
                            "MessageKey", "MSG_ERROR_CW_WEIGHT_NOT_WITHIN_TOLERANCE",
                            "ShowButton", true,
                            "IsError", true,
                            "Parameters", new object[] { quantityForWeight.Value, quantityForPieces.Value, itemInfo.CatchWeightWeightTolerancePercentage }));
                    msg = WaitForMessage();

                    goto Step_EnterQuantity;
                }

                goto Step_NewDataForCounting;

                #endregion
            }
            else
            {
                #region ENTER QUANTITY NON CATCH WEIGHT

                if (itemInfo.ListOfPackagingTypes != null &&
                    currentListOfTransactionalPackagingTypeInfos.Count > 0)
                {

                    //build list of packaging types

                    listOfPackagingTypeInfosForScreen = new Collection<PackagingTypeInfo>();

                    //add first one for the uom

                    PackagingTypeInfo info = new PackagingTypeInfo();

                    info.Quantity = 1;
                    info.PackagingTypeCode = null;
                    info.PackagingTypeName = itemInfo.InventoryUom == null ? itemInfo.ItemCode : itemInfo.InventoryUom;
                    info.QuantityPerPack = 1;
                    if (!string.IsNullOrEmpty(itemInfo.CodeBars))
                    {
                        info.Barcode.Add(itemInfo.CodeBars);
                    }
                    info.NumberOfDecimals = itemInfo.UomDecimals;
                    if (info.Barcode.Contains(GTIN))
                    {
                        info.InitialQuantity = 1;
                    }
                    else
                    {
                        info.InitialQuantity = 0;
                    }
                    listOfPackagingTypeInfosForScreen.Add(info);

                    foreach (ItemTransactionalPackagingTypeInfo packType in currentListOfTransactionalPackagingTypeInfos)
                    {
                        info = new PackagingTypeInfo();

                        info.Quantity = packType.Quantity;
                        info.PackagingTypeCode = packType.PackagingTypeCode;
                        info.PackagingTypeName = GetPackTypeName(packType.PackagingTypeCode, itemInfo.ListOfPackagingTypes);
                        info.Barcode = GetPackBarcode(packType.PackagingTypeCode, itemInfo.ListOfPackagingTypes);

                        if (info.Barcode.Contains(GTIN))
                        {
                            info.InitialQuantity = 1;
                            //Check if barcode is also added to inventory uom.
                            //If so, we need to adjust initial qty
                            if (listOfPackagingTypeInfosForScreen[0].Barcode.Contains(GTIN))
                            {
                                listOfPackagingTypeInfosForScreen[0].InitialQuantity = 0;
                            }
                        }
                        else
                        {
                            info.InitialQuantity = 0;
                        }

                        info.QuantityPerPack = packType.Quantity;

                        listOfPackagingTypeInfosForScreen.Add(info);
                    }

                    if (proposeItemDefQtyOnLogUnit && !String.IsNullOrEmpty(SSCC) && itemInfo.DefaultQuantityOnLogisticUnit > 0)
                    {
                        double qtyOnLogUnit = itemInfo.DefaultQuantityOnLogisticUnit;

                        for (int i = listOfPackagingTypeInfosForScreen.Count - 1; i >= 0; i--)
                        {
                            if (SboQuantity.IsZeroOrLess(qtyOnLogUnit, itemInfo.UomDecimals))
                            {
                                break;
                            }
                            info = listOfPackagingTypeInfosForScreen[i];
                            info.InitialQuantity = Math.Floor(qtyOnLogUnit / info.Quantity + SboQuantity.EpsilonBeforeRounding);
                            qtyOnLogUnit = Math.Round(qtyOnLogUnit - info.InitialQuantity.Value * info.Quantity, itemInfo.UomDecimals);
                        }
                    }

                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterPackagingQuantityScreen),
                                        DefaultCultureInfo.Get(), BuildParamCollection(
                                        "InitialErrorKey", initialErrorKey,
                                        "TitleKey", "MSG_CC_TITLE_ENTER_QUANTITY",
                                        "BarcodeController", barcodeController,
                                        "ItemDescription", itemInfo.Description,
                                        "ItemCode", itemInfo.ItemCode,
                                        "ItemBarcode", itemInfo.CodeBars,
                                        "UOM", itemInfo.InventoryUom,
                                        "ListOfPackagingTypeInfos", listOfPackagingTypeInfosForScreen,
                                        "IsForEnteringDefaultPackagingQuantity", false,
                                        "BatchNumber", batchNumber,
                                        "BestBeforeDate", bestBeforeDate,
                                        "SSCC", SSCC,
                                        "DocNum", null,
                                        "StillToQuantity", null,
                                        "MessageKeyStillQuantity", null,
                                        "AllowZero", false
                                        ));

                    msg = WaitForMessage();

                    // reset error
                    initialErrorKey = null;

                    if (msg.Name.EndsWith(".QuantitiesEntered"))
                    {
                        PackagingTypeInfos screenListOfPackagingTypeInfos = ExtractParameter<PackagingTypeInfos>(msg.Parameters, "listOfPackagingTypeInfos");

                        //build the list of packaging quantities
                        foreach (PackagingTypeInfo infoForQty in screenListOfPackagingTypeInfos.PackagingTypeInfoList.Values)
                        {
                            quantity += (infoForQty.Quantity * infoForQty.QuantityPerPack);
                        }


                        goto Step_NewDataForCounting;
                    }
                    else if (msg.Name.EndsWith(".BackRequested"))
                    {
                        if (isItemCounting)
                        {
                            goto Step_ScanSSCC;
                        }
                        goto Step_ScanItem;
                    }
                }
                else
                {

                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityWithItemInfoScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "InitialErrorKey", initialErrorKey,
                            "TitleKey", "MSG_CC_TITLE_ENTER_QUANTITY",
                            "BarcodeController", barcodeController,
                            "InitialQuantity", ( proposeItemDefQtyOnLogUnit && !String.IsNullOrEmpty( SSCC ) ) ? Math.Max( 1, itemInfo.DefaultQuantityOnLogisticUnit ) : 1,
                            "NumberOfDigitsAfterDecimal", itemInfo.UomDecimals,
                            "MaximumQuantity", -1,
                            "UOM", itemInfo.InventoryUom,
                            "ItemDescription", itemDescription,
                            "ItemCode", itemCode,
                            "ItemBarcode", itemInfo.CodeBars,
                            "BatchNumber", batchNumber,
                            "BestBeforeDate", bestBeforeDate,
                            "SSCC", SSCC,
                            "StillToQuantity", null
                           ));
                    msg = WaitForMessage();

                    // reset error
                    initialErrorKey = null;

                    if (msg.Name.EndsWith(".QuantityEntered"))
                    {
                        quantity = ExtractParameter<double>(msg.Parameters, "quantity");

                        goto Step_NewDataForCounting;
                    }
                    else if (msg.Name.EndsWith(".BackRequested"))
                    {
                        if (autoSelectBatchBBDOnMonolotPallet || isItemCounting)
                        {
                            goto Step_ScanSSCC;
                        }

                        goto Step_ScanItem;

                    }

                }
                #endregion
            }



            #endregion


        Step_NewDataForCounting:

            #region STORE THE INFO RELATED TO THE COUNTED ITEM

            barCode = null;

            //add the data to the list to produce
            CycleCountInventoryItemInfo invItemInfo = new CycleCountInventoryItemInfo();

            // Create a unique key ?
            string key = string.Format("{0}|{1}|{2}|{3}|{4}",
                itemCode,
                batchNumber,
                secondBatchNumber,
                (bestBeforeDate.HasValue ? bestBeforeDate.Value.ToString("s") : string.Empty),
                SSCC);

            if (indexItemsToProduce.ContainsKey(key))
            {
                invItemInfo = indexItemsToProduce[key];
                // Add the quantity to the existing item
                invItemInfo.Difference += quantity;
                if (itemInfo.IsCatchWeightItem)
                {
                    invItemInfo.DifferenceUom2 = (invItemInfo.DifferenceUom2.HasValue ? invItemInfo.DifferenceUom2.Value : 0) + quantityUom2;
                }
            }
            else
            {
                invItemInfo.ItemCode = itemCode;
                invItemInfo.ItemDescription = itemDescription;
                invItemInfo.Difference = quantity;
                invItemInfo.DifferenceUom2 = quantityUom2;
                invItemInfo.BatchNumber = batchNumber;
                invItemInfo.SecondBatchNumber = secondBatchNumber;
                invItemInfo.BestBeforeDate = bestBeforeDate;
                invItemInfo.SSCC = SSCC;
                invItemInfo.LocationCode = selectedLocationCode;
                invItemInfo.Uom = itemInfo.InventoryUom;
                invItemInfo.Uom2 = itemInfo.Uom2;
                // TODO : Do we support the quality status ?
                //invItemInfo.QualityStatusCode = qualityStatusCode;

                invItemInfo.ItemInfo = itemInfo;

                invItemInfo.ListOfSerialNumbers = listOfSerialNumbers;

                invItemInfo.ListOfPackagingTypes = currentListOfTransactionalPackagingTypeInfos;

                listOfItemsToCount.Add(invItemInfo);
                indexItemsToProduce.Add(key, invItemInfo);
            }

            //isFirstProductForLocation = false;

            if (askToAddMore)
            {

                //ask user if he wants to add another item to the list
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "TitleKey", isItemCounting ? "MSG_TITLE_ADD_EXTRA_CYCLE_COUNTING_SSCC" : "MSG_TITLE_ADD_EXTRA_CYCLE_COUNTING_ITEM",
                    "MessageKey", isItemCounting ? "MSG_QUESTION_ADD_EXTRA_CYCLE_COUNTING_SSCC" : "MSG_QUESTION_ADD_EXTRA_CYCLE_COUNTING_ITEM"));
                msg = WaitForMessage();

                if (msg.Name.EndsWith(".No"))
                {
                    // Continue to scan
                    goto Step_PrepareDataForStock;
                }
                if (isItemCounting)
                {
                    goto Step_ScanSSCC;
                }
                // enter a new item
                goto Step_InitBeforeItemDetails;
            }

            // enter a new item
            goto Step_ScanSSCC;

            #endregion

        Step_PrepareDataForStock:

            #region GENERATE THE LIST OF COUNTED ITEMS TO UPDATE

            Collection<CycleCountInventoryItemInfo> listOfItemsToUpdate = new Collection<CycleCountInventoryItemInfo>();

            bool? onlyFullLUID = null;

            if (cycleCountOptionAllSSCCs && !detailedCountAfterFullLUID)
            {
                onlyFullLUID = false;
            }

            whsInfo = m_sboProviderService.InvokeMethodWithDbConnection<PmxOseWarehouseInfo>( false, false, null, null, new DelegateWithPmxDbConnection<PmxOseWarehouseInfo>( ExecuteGetPmxWarehouseCode ), selectedLocationCode );

            // Retrieve the product previously stored on the location
            query = BuildQuery.GetProductsFromStockOrderByName(null, isItemCounting ? itemCode : null, selectedLocationCode, null, false, null, isLogisticCarrier, null, null, null, false, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit.Inventory, onlyFullLUID, m_sboProviderService.GetDbTool());
            dsActiveStocks = m_sboProviderService.RunView(false, null, null, query);

            // Force the dataset to invariant culture
            dsActiveStocks.Locale = CultureInfo.InvariantCulture;
            // Analyse and detect difference between real stock and registered stock


            foreach (CycleCountInventoryItemInfo currInvItemInfo in listOfItemsToCount)
            {
                DataRow[] rows = null;

                // If we don't have actual stock anymore, break the loop
                if (GetNumberOfRows(dsActiveStocks) > 0)
                {
                    // Prepare a new search
                    StringBuilder Filter = new StringBuilder();
                    string Operator = string.Empty;

                    Filter.Append(string.Format(" {0} {1} = '{2}' ", Operator,
                        PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME,
                        currInvItemInfo.ItemCode));
                    Operator = " AND ";

                    if (!string.IsNullOrEmpty(currInvItemInfo.BatchNumber))
                    {
                        Filter.Append(string.Format(" {0} {1} = '{2}' ", Operator,
                            PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME,
                            currInvItemInfo.BatchNumber));
                        Operator = " AND ";
                    }
                    else
                    {
                        Filter.Append(string.Format(" {0} {1} IS NULL ", Operator,
                            PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME));
                        Operator = " AND ";
                    }

                    if (!string.IsNullOrEmpty(currInvItemInfo.SecondBatchNumber))
                    {
                        Filter.Append(string.Format(" {0} {1} = '{2}' ", Operator,
                            PmxStockOverviewOnLocationDefinition.Columns.BatchNumber2.NAME,
                            currInvItemInfo.SecondBatchNumber));
                        Operator = " AND ";
                    }
                    else
                    {
                        Filter.Append(string.Format(" {0} {1} IS NULL ", Operator,
                            PmxStockOverviewOnLocationDefinition.Columns.BatchNumber2.NAME));
                        Operator = " AND ";
                    }

                    if (currInvItemInfo.BestBeforeDate.HasValue)
                    {
                        Filter.Append(string.Format(" {0} ({1} >= #{2}# AND {1} < #{3}#) ", Operator,
                            PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME,
                            currInvItemInfo.BestBeforeDate.Value.ToString("yyyy/MM/dd"),
                            currInvItemInfo.BestBeforeDate.Value.AddDays(1).ToString("yyyy/MM/dd")));
                        Operator = " AND ";
                    }
                    else
                    {
                        Filter.Append(string.Format(" {0} {1} IS NULL ", Operator,
                            PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME));
                        Operator = " AND ";
                    }

                    if (!string.IsNullOrEmpty(currInvItemInfo.SSCC))
                    {
                        Filter.Append(string.Format(" {0} {1} = '{2}' ", Operator,
                            PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME,
                            currInvItemInfo.SSCC));
                        Operator = " AND ";
                    }
                    else
                    {
                        Filter.Append(string.Format(" {0} {1} IS NULL ", Operator,
                            PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME));
                        Operator = " AND ";
                    }

                    // Look for data in stock
                    rows = dsActiveStocks.Tables[0].Select(Filter.ToString());
                }
                if (rows != null &&
                    rows.Length > 0)
                {
                    double quantityCounted = Math.Round(currInvItemInfo.Difference, currInvItemInfo.ItemInfo.UomDecimals);
                    double? quantityUom2Counted = null;
                    if (currInvItemInfo.ItemInfo.IsCatchWeightItem)
                    {
                        quantityUom2Counted = Math.Round(currInvItemInfo.DifferenceUom2.Value, currInvItemInfo.ItemInfo.Uom2Decimals);
                    }


                    double currentTotalStockQty = 0;
                    double? currentTotalStockQtyUom2 = 0;
                    foreach (DataRow row in rows)
                    {
                        currentTotalStockQty += Convert.ToDouble(row[PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME]);
                        if (currInvItemInfo.ItemInfo.IsCatchWeightItem)
                        {
                            currentTotalStockQtyUom2 += Convert.ToDouble(row[PmxStockOverviewOnLocationDefinition.Columns.QuantityUom2.NAME]);
                        }
                    }

                    foreach (DataRow row in rows)
                    {
                        double qtyOnStock = Convert.ToDouble(row[PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME]);

                        double? qtyUom2OnStock = null;

                        if (currInvItemInfo.ItemInfo.IsCatchWeightItem)
                        {
                            qtyUom2OnStock = Convert.ToDouble(row[PmxStockOverviewOnLocationDefinition.Columns.QuantityUom2.NAME]);
                        }

                        Collection<string> listOfStockSerialNumbers = new Collection<string>();

                        Collection<string> listOfNewSerialNumbers = new Collection<string>();
                        Collection<string> listOfLostSerialNumbers = new Collection<string>();

                        int? luid = Convertor.ConvertToInt32Nullable( row[PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME] );
                        int? itriKey = Convertor.ConvertToInt32Nullable( row[PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME] );
                        string qualityStatusCode = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME]);

                        if ( ( currInvItemInfo.ItemInfo.HasSAPSerialNumber || currInvItemInfo.ItemInfo.HasSerialNumber ) && currInvItemInfo.ItemInfo.TrackLocationSerialNumber &&
                            listOfSerialNumbers != null && listOfSerialNumbers.Count > 0 )
                        {
                            // build list of serial number differences
                            m_sboProviderService.InvokeMethodWithDbConnection<object>( false, false, null, null,
                            delegate( PmxDbConnection conn, object[] parameters )
                            {
                                query = SboCommands.GetAllSerialNumbersInStock( itemCode, luid, itriKey, whsInfo.PmxWarehouseCode, conn );
                                using ( ISboRecordset rs = SboRecordsetHelper.RunQuery( s_log, query, conn ) )
                                {
                                    while ( !rs.EoF )
                                    {
                                        string serialNumber = rs.GetTypedValue<string>( PmxSerialNumberTable.Columns.SerialNumber.NAME );
                                        if ( !listOfStockSerialNumbers.Contains( serialNumber ) ) listOfStockSerialNumbers.Add( serialNumber );

                                        rs.MoveNext();
                                    }
                                }

                                return null;
                            } );

                            foreach ( string serialNumber in listOfStockSerialNumbers )
                            {
                                if ( !listOfSerialNumbers.Contains( serialNumber ) ) listOfLostSerialNumbers.Add( serialNumber );
                            }
                            foreach ( string serialNumber in listOfSerialNumbers )
                            {
                                if ( !listOfStockSerialNumbers.Contains( serialNumber ) ) listOfNewSerialNumbers.Add( serialNumber );
                            }

                            quantityCounted -= listOfSerialNumbers.Count;
                            if ( listOfLostSerialNumbers.Count > 0 )
                            {
                                //add as qty to delete
                                CycleCountInventoryItemInfo newItemInfo = PmxCycleCountProvider.CopyCycleCountInventoryItemInfo( currInvItemInfo );

                                newItemInfo.Difference = -listOfLostSerialNumbers.Count;

                                newItemInfo.LogisticUnitIdentKey = luid;
                                newItemInfo.QualityStatusCode = qualityStatusCode;
                                newItemInfo.CurrentStock = currentTotalStockQty;
                                newItemInfo.CurrentStockUom2 = currentTotalStockQtyUom2;
                                newItemInfo.ItemTransactionalInfoKey = itriKey;
                                newItemInfo.ListOfSerialNumbers = listOfLostSerialNumbers;

                                listOfItemsToUpdate.Add( newItemInfo );
                            }
                            if ( listOfNewSerialNumbers.Count > 0 )
                            {
                                CycleCountInventoryItemInfo newItemInfo = PmxCycleCountProvider.CopyCycleCountInventoryItemInfo( currInvItemInfo );

                                // if quantity > number of serials on stock, then book more serial numbers than quantity
                                newItemInfo.Difference = listOfNewSerialNumbers.Count - qtyOnStock + listOfStockSerialNumbers.Count;

                                newItemInfo.LogisticUnitIdentKey = luid;
                                newItemInfo.QualityStatusCode = qualityStatusCode;
                                newItemInfo.CurrentStock = currentTotalStockQty;
                                newItemInfo.CurrentStockUom2 = currentTotalStockQtyUom2;
                                newItemInfo.ItemTransactionalInfoKey = itriKey;
                                newItemInfo.ListOfSerialNumbers = listOfNewSerialNumbers;

                                listOfItemsToUpdate.Add( newItemInfo );
                            }
                        }
                        else
                        {



                            if ( quantityCounted >= 0 )
                            {
                                quantityCounted -= qtyOnStock;

                                if ( currInvItemInfo.ItemInfo.IsCatchWeightItem )
                                {
                                    quantityUom2Counted -= qtyUom2OnStock;
                                }

                                if ( quantityCounted < 0 ||
                                    ( currInvItemInfo.ItemInfo.IsCatchWeightItem &&
                                    quantityUom2Counted.Value != 0 &&
                                    quantityCounted == 0 ) )
                                {
                                    CycleCountInventoryItemInfo newItemInfo = PmxCycleCountProvider.CopyCycleCountInventoryItemInfo( currInvItemInfo );

                                    newItemInfo.Difference = quantityCounted;

                                    newItemInfo.DifferenceUom2 = quantityUom2Counted;

                                    newItemInfo.LogisticUnitIdentKey = luid;
                                    newItemInfo.QualityStatusCode = qualityStatusCode;
                                    newItemInfo.CurrentStock = currentTotalStockQty;

                                    newItemInfo.CurrentStockUom2 = currentTotalStockQtyUom2;

                                    newItemInfo.ItemTransactionalInfoKey = itriKey;

                                    listOfItemsToUpdate.Add( newItemInfo );
                                }
								else if (quantityCounted == 0)
								{
									//Always store the counted items, even if difference is 0
									CycleCountInventoryItemInfo newItemInfo = PmxCycleCountProvider.CopyCycleCountInventoryItemInfo(currInvItemInfo);

									newItemInfo.Difference = quantityCounted;

									newItemInfo.DifferenceUom2 = quantityUom2Counted;

									newItemInfo.LogisticUnitIdentKey = luid;
									newItemInfo.QualityStatusCode = qualityStatusCode;
									newItemInfo.CurrentStock = currentTotalStockQty;

									newItemInfo.CurrentStockUom2 = currentTotalStockQtyUom2;

									newItemInfo.ItemTransactionalInfoKey = itriKey;

									listOfItemsToUpdate.Add(newItemInfo);
								}
                                //else if (quantityCounted == 0 &&
                                //    (currInvItemInfo.ItemInfo.IsCatchWeightItem &&
                                //    quantityUom2Counted.Value > 0))
                                //{
                                //    //Only UOM2 has changed 

                                //    CycleCountInventoryItemInfo newItemInfo = PmxCycleCountProvider.CopyCycleCountInventoryItemInfo(currInvItemInfo);

                                //    newItemInfo.QualityStatusCode = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME]);

                                //    newItemInfo.LogisticUnitIdentKey = (rows[0].IsNull(PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME) ? (int?)null : Convert.ToInt32(rows[0][PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME]));
                                //    newItemInfo.QualityStatusCode = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME]);
                                //    newItemInfo.CurrentStock = currentTotalStockQty;

                                //    newItemInfo.CurrentStockUom2 = currentTotalStockQtyUom2;

                                //    newItemInfo.ItemTransactionalInfoKey = (rows[0].IsNull(PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME) ? (int?)null : Convert.ToInt32(rows[0][PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME]));


                                //    listOfItemsToUpdate.Add(newItemInfo);
                                //}
                            }
                            else
                            {
                                //add as qty to delete
                                CycleCountInventoryItemInfo newItemInfo = PmxCycleCountProvider.CopyCycleCountInventoryItemInfo( currInvItemInfo );

                                newItemInfo.Difference = -qtyOnStock;

                                if ( currInvItemInfo.ItemInfo.IsCatchWeightItem )
                                {
                                    newItemInfo.DifferenceUom2 = -qtyUom2OnStock;
                                }

                                newItemInfo.LogisticUnitIdentKey = luid;
                                newItemInfo.QualityStatusCode = qualityStatusCode;
                                newItemInfo.CurrentStock = currentTotalStockQty;
                                newItemInfo.CurrentStockUom2 = currentTotalStockQtyUom2;
                                newItemInfo.ItemTransactionalInfoKey = itriKey;

                                listOfItemsToUpdate.Add( newItemInfo );
                            }
                        }
                    }

                    //if there is counted quantity left, we need to add it
                    if (quantityCounted > 0 )
                    {
                        CycleCountInventoryItemInfo newItemInfo = PmxCycleCountProvider.CopyCycleCountInventoryItemInfo(currInvItemInfo);
                        
                        newItemInfo.QualityStatusCode = currentPmxOseCompany.DefaultQualityStatusCodeCycleCounting;

                        newItemInfo.Difference = quantityCounted;
                        newItemInfo.DifferenceUom2 = quantityUom2Counted;
                        newItemInfo.CurrentStock = currentTotalStockQty;
                        newItemInfo.CurrentStockUom2 = currentTotalStockQtyUom2;

                        newItemInfo.ListOfSerialNumbers = listOfSerialNumbers;

                        listOfItemsToUpdate.Add(newItemInfo);
                    }


                    // We don't need them anymore in the active stock list
                    foreach (DataRow row in rows)
                    {
                        dsActiveStocks.Tables[0].Rows.Remove(row);
                    }
                }
                else
                {
                    // Not in stock currently
                    currInvItemInfo.QualityStatusCode = currentPmxOseCompany.DefaultQualityStatusCodeCycleCounting;

                    listOfItemsToUpdate.Add(currInvItemInfo);
                }
            }

            // Check if we have remaining stock entry to remove
            if (GetNumberOfRows(dsActiveStocks) > 0)
            {
                // All those items does not existe anymore in the stock we move them to become minus stock correction
                foreach (DataRow row in dsActiveStocks.Tables[0].Rows)
                {
                    CycleCountInventoryItemInfo missingItemInfo = new CycleCountInventoryItemInfo();

                    // Add new item with negative quantity to adjust the stock
                    missingItemInfo.Difference = (-1) * Convert.ToDouble(row[PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME]);

                    double? missingQtyUom2 = Convertor.ConvertToDoubleNullable(row[PmxStockOverviewOnLocationDefinition.Columns.QuantityUom2.NAME]);

                    if (missingQtyUom2.HasValue)
                    {
                        missingItemInfo.DifferenceUom2 = -missingQtyUom2.Value;
                        missingItemInfo.CurrentStockUom2 = missingQtyUom2;
                    }


                    missingItemInfo.LocationCode = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME]);
                    missingItemInfo.ItemCode = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME]);

                    missingItemInfo.ItemTransactionalInfoKey = (row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME) ? (int?)null : Convert.ToInt32(row[PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME]));

                    missingItemInfo.CurrentStock = Convert.ToDouble(row[PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME]);

                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.ProductDescription.NAME))
                    {
                        missingItemInfo.ItemDescription = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.ProductDescription.NAME]);
                    }
                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME))
                    {
                        missingItemInfo.BatchNumber = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME]);
                    }
                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.BatchNumber2.NAME))
                    {
                        missingItemInfo.SecondBatchNumber = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.BatchNumber2.NAME]);
                    }
                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME))
                    {
                        missingItemInfo.BestBeforeDate = Convert.ToDateTime(row[PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME]);
                    }
                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME))
                    {
                        missingItemInfo.SSCC = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME]);
                    }
                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME))
                    {
                        missingItemInfo.LogisticUnitIdentKey = Convert.ToInt32(row[PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME]);
                    }
                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME))
                    {
                        missingItemInfo.QualityStatusCode = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME]);
                    }
                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.InventoryUom.NAME))
                    {
                        missingItemInfo.Uom = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.InventoryUom.NAME]);
                    }

                    if (!row.IsNull(PmxStockOverviewOnLocationDefinition.Columns.Uom2.NAME))
                    {
                        missingItemInfo.Uom2 = Convert.ToString(row[PmxStockOverviewOnLocationDefinition.Columns.Uom2.NAME]);
                    }



                    if (!cachedItemInfos.ContainsKey(missingItemInfo.ItemCode))
                    {
                        cachedItemInfos.Add(missingItemInfo.ItemCode, m_sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>(false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>(ExecuteGetItemInfo), missingItemInfo.ItemCode));
                    }

                    missingItemInfo.ItemInfo = cachedItemInfos[missingItemInfo.ItemCode];


                    listOfItemsToUpdate.Add(missingItemInfo);
                }
            }

            #endregion

        Step_PreviewDataForStock:

            #region PREVIEW THE LIST OF COUNTED ITEMS TO UPDATE

            //cleanup list when needed
            if (autoHandleBatchNumbers)
            {
                Dictionary<string, double> listOfQuantities = new Dictionary<string, double>();
                foreach (CycleCountInventoryItemInfo item in listOfItemsToUpdate)
                {
                    // Create a unique key
                    string key2 = string.Format("{0}|{1}|{2}",
                        item.ItemCode,
                        (item.BestBeforeDate.HasValue ? item.BestBeforeDate.Value.ToString("s") : string.Empty),
                        item.SSCC);

                    if (!listOfQuantities.ContainsKey(key2))
                    {
                        listOfQuantities.Add(key2, 0);
                    }

                    listOfQuantities[key2] += item.Difference;

                }


                for (int iLoop = 0; iLoop < listOfItemsToUpdate.Count; iLoop++)
                {
                    CycleCountInventoryItemInfo item = listOfItemsToUpdate[iLoop];
                    // Create a unique key
                    string key2 = string.Format("{0}|{1}|{2}",
                        item.ItemCode,
                        (item.BestBeforeDate.HasValue ? item.BestBeforeDate.Value.ToString("s") : string.Empty),
                        item.SSCC);

                    //all items in list with qty == 0 do not need to be taken in account.
                    if (listOfQuantities.ContainsKey(key2) &&
                        listOfQuantities[key2] == 0)
                    {
                        //remove
                        listOfItemsToUpdate.Remove(item);
                        iLoop--;
                    }
                }

            }


            if ((duringOtherOperation && showDifferenceScreenDuringOtherOperation) ||
                (!duringOtherOperation && showDifferenceScreenDuringCycleCount))
            {

                // Generate the overview dataset
                int? updatedItem = 1;
                DataSet dsOverviewItems = new DataSet();

                dsOverviewItems.Tables.Add(AlternateItemDataSet.NAME);
                foreach (ColumnDefinition colmn in AlternateItemDataSet.Columns.CYCLE_COUNT)
                {
                    dsOverviewItems.Tables[AlternateItemDataSet.NAME].Columns.Add(colmn.Name, colmn.Types[0]);
                }
                foreach (CycleCountInventoryItemInfo item in listOfItemsToUpdate)
                {
					if (!(item.Difference == 0 &&
						(item.DifferenceUom2 ?? 0) == 0))
					{
						DataRow dr = dsOverviewItems.Tables[AlternateItemDataSet.NAME].Rows.Add();

						dr[AlternateItemDataSet.Columns.BATCHNUMBER.Name] = item.BatchNumber;
						dr[AlternateItemDataSet.Columns.BATCHNUMBER2.Name] = item.SecondBatchNumber;
						if (item.BestBeforeDate.HasValue)
						{
							dr[AlternateItemDataSet.Columns.BESTBEFOREDATE.Name] = item.BestBeforeDate.Value;
						}
						dr[AlternateItemDataSet.Columns.ITEM_DESCRIPTION.Name] = item.ItemDescription;
						dr[AlternateItemDataSet.Columns.ITEMCODE.Name] = item.ItemCode;
						dr[AlternateItemDataSet.Columns.QUANTITY.Name] = item.Difference;
						dr[AlternateItemDataSet.Columns.SSCC.Name] = item.SSCC;
						if (item.CurrentStock > 0)
						{
							dr[AlternateItemDataSet.Columns.INTERNAL_KEY.Name] = updatedItem;
						}
						else
						{
							dr[AlternateItemDataSet.Columns.INTERNAL_KEY.Name] = System.DBNull.Value;
						}
						dr[AlternateItemDataSet.Columns.STORAGE_LOCATION.Name] = item.LocationCode;
						dr[AlternateItemDataSet.Columns.UOM.Name] = item.Uom;

						if (item.ItemInfo.IsCatchWeightItem)
						{
							dr[AlternateItemDataSet.Columns.UOM2.Name] = item.Uom2;
							dr[AlternateItemDataSet.Columns.QUANTITY_UOM2.Name] = item.DifferenceUom2;
						}
					}
                }


                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.CycleCounting.IShowCountedItemsScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_TITLE_PREVIEW_COUNTED_ITEMS",
                    "ItemsForCycleCountingDS", dsOverviewItems));
                msg = WaitForMessage();

                //clear data
                initialErrorKey = null;

                if (msg.Name.EndsWith(".ForwardRequested"))
                {
                    goto Step_UpdateStock;
                }
                else if (msg.Name.EndsWith(".BackRequested"))
                {
                    //ask user if he wants to continue scanning, or start over scanning
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "TitleKey", "MSG_CC_TITLE_CONTINUE_COUNTING",
                            "MessageKey", "MSG_CC_QUESTION_CONTINUE_COUNTING"));
                    msg = WaitForMessage();

                    if (msg.Name.ToLower().EndsWith(".no"))
                    {
                        indexItemsToProduce.Clear();
                        listOfItemsToCount.Clear();

                        if (cycleCountOptionAllSSCCs && !detailedCountAfterFullLUID)
                        {
                            goto Step_EnterNumberOfFullSSCC;
                        }
                    }

                    if (isItemCounting)
                    {
                        goto Step_InitBeforeItemDetails;
                    }
                    goto Step_ScanSSCC;
                }
            }

            goto Step_UpdateStock;

            #endregion

        Step_UpdateStock:

            #region UPDATE STOCK

            //Now we can update the system
            bool doRetry = false;

            do
            {
                // Reset loop flag
                doRetry = false;
                try
                {
                    object[] callParameters = new object[] { listOfItemsToUpdate, selectedLocationCode, currentOtherOperationType, duringOtherOperation, deviceID };

                    m_sboProviderService.InvokeMethodWithDbConnection<object>(true, false, null, null, new DelegateWithPmxDbConnection<object>(ExecuteCycleCounting), callParameters);
                }
                catch (Exception ex)
                {
                    s_log.Error("Error during update cycle count", ex);
                    if (!(ex is ProdumexException))
                    {
                        // Inform the user with the error
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "MessageKey", ExceptionHelper.Format(ExceptionHelper.Content.InnerExceptions, ex, DefaultCultureInfo.Get()),
                                "NoTranslationOfMessageKey", true,
                                "IsError", true,
                                "ShowButton", true));
                        WaitForMessage();
                    }
                    else
                    {
                        // Inform the user with the error
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "PmxError", ((ProdumexException)ex).Error,
                                "ShowButton", true));
                        WaitForMessage();

                    }

                    //ask user if he wants to add another item to the list
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "TitleKey", "MSG_TITLE_RETRY_CYCLE_COUNTING_UPDATE",
                            "MessageKey", "MSG_QUESTION_AN_ERROR_OCCURED_CYCLE_COUNT_WANT_RETRY"));
                    msg = WaitForMessage();

                    if (msg.Name.ToLower().EndsWith(".yes"))
                    {
                        doRetry = true;
                    }
                }
            } while (doRetry);

            //clear list
            indexItemsToProduce.Clear();
            listOfItemsToCount.Clear();

            if (duringOtherOperation)
            {
                // Inform the user
                session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "MessageKey", "MSG_CC_ITEMS_COUNTED",
                        "NoTranslationOfMessageKey", false,
                        "ShowButton", true));
                WaitForMessage();
                return;
            }


            goto Step_IdentifyLocation;


            #endregion

        Step_SkipCount:

            #region SKIP COUNT

            if (allowToSkipDuringOtherOperations &&
                duringOtherOperation)
            {
                if (!enterReasonFreeTextGoBack)
                {
                    //inform user he will skip
                    session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "TitleKey", "MSG_CC_TITLE_SKIP_COUNTING",
                            "MessageKey", "MSG_CC_QUESTION_SKIP_COUNTING"));
                    msg = WaitForMessage();
                    enterReasonFreeTextGoBack = false;
                }
                if (msg.Name.EndsWith(".Yes"))//|| !enterReasonFreeTextGoBack )
                {

                    if (enterReasonWhenSkippingCount)
                    {
                        //get all reasons for cycle counting
                        query = BuildQuery.GetReasons();
                        DataSet dsReasons = m_sboProviderService.RunView(false, null, null, query);

                        reasonsCodesRequiresFreeText = new Dictionary<string, bool>();
                        foreach (DataRow row in dsReasons.Tables[0].Rows)
                        {
                            reasonsCodesRequiresFreeText.Add(
                                row[ReasonDataSet.Columns.REASON_CODE.Name].ToString(),
                                (SboBooleanConvertor.ObjectToBooleanOrNull(row[ReasonDataSet.Columns.REASON_REQUIRES_FREE_TEXT.Name]).HasValue ? (SboBooleanConvertor.ObjectToBooleanOrNull(row[PmxReasonTable.Columns.RequiresFreeText.NAME])).Value : false)
                                );
                        }


                        // Show screen with list
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectReasonScreen),
                          this.DefaultCultureInfo, BuildParamCollection(
                          "InitialErrorKey", initialErrorKey,
                          "TitleKey", "MSG_INFO_ENTER_REASON_SKIPPING_COUNT",
                          "MessageKey", "MSG_INFO_ENTER_REASON_SKIPPING_COUNT",
                          "MessageParams", new string[] { itemCode },
                          "ReasonDS", dsReasons));
                        msg = WaitForMessage();
                        initialErrorKey = null;

                        if (msg.Name != "Produmex.Foundation.SlimScreen.Interfaces.ISelectReasonScreenReply.ReasonSelected")
                        {
                            //go back
                            enterReasonFreeTextGoBack = true;
                            goto Step_SelectCountingOption;
                        }
                        reasonCode = ExtractParameter<string>(msg.Parameters, "reasonCode");

                        DataRow[] rows = dsReasons.Tables[0].Select(String.Format("{0} = '{1}'", ReasonDataSet.Columns.REASON_CODE.Name, reasonCode));
                        if (rows.Length > 0)
                        {
                            reasonName = rows[0][ReasonDataSet.Columns.REASON_NAME.Name] as string;
                        }

                        #region ENTER REASON FREE TEXT

                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterStringValueScreen),
                            DefaultCultureInfo.Get(), BuildParamCollection(
                                "InitialErrorKey", initialErrorKey,
                                "TitleKey", "MSG_TITLE_ENTER_REASON",
                               "Information", "MSG_ENTER_FREE_REASON_DEFAULT",
                        "Parameters", new object[] { reasonName },
                                "AllowToGoBack", true,
                                "ForceDataEntry", true,
                                "AllowMultiLine", true,
                                "MinimumNumberOfCharacters", Definitions.MIMIMUM_NUMBER_OF_CHARACTERS_FOR_REASON
                                ));
                        msg = WaitForMessage();

                        initialErrorKey = null;

                        if (msg.Name.EndsWith(".StringEntered"))
                        {
                            reasonFreeText = ExtractParameter<string>(msg.Parameters, "stringValue");
                        }
                        else
                        {
                            //go back
                            enterReasonFreeTextGoBack = true;
                            goto Step_SkipCount;
                        }
                        enterReasonFreeTextGoBack = false;

                        #endregion
                    }

                    //Skip the count
                    try
                    {
                        m_sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null, new DelegateWithPmxDbConnection<object>(ExecuteSkipCount), selectedLocationCode, currentOtherOperationType, new ReasonInfo(reasonCode, reasonFreeText));
                    }
                    catch (Exception ex)
                    {
                        if (!(ex is ProdumexException))
                        {
                            // Inform the user with the error
                            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                                DefaultCultureInfo.Get(), BuildParamCollection(
                                    "MessageKey", ExceptionHelper.Format(ExceptionHelper.Content.InnerExceptions, ex, DefaultCultureInfo.Get()),
                                    "NoTranslationOfMessageKey", true,
                                    "IsError", true,
                                    "ShowButton", true));
                            WaitForMessage();
                        }
                        else
                        {
                            // Inform the user with the error
                            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                                DefaultCultureInfo.Get(), BuildParamCollection(
                                    "PmxError", ((ProdumexException)ex).Error,
                                    "ShowButton", true));
                            WaitForMessage();

                        }
                    }

                    return;

                }

                //not skipping count
                goto Step_SelectCountingOption;
            }

            //inform user he cannot skip the counting
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "MessageKey", "MSG_CC_CANNOT_SKIP_COUNT",
                    "NoTranslationOfMessageKey", false,
                    "ShowButton", true));
            WaitForMessage();

            goto Step_SelectCountingOption;


            #endregion

        Step_EnterNumberOfFullSSCC:

            #region ENTER NUMBER OF FULL SSCC

            //ask for quantity
            session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityScreen),
                DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_BUTTON_TITLE_ENTER_NUMBER_OF_FULL_SSCC",
                    "BarcodeController", barcodeController,
                    "InitialQuantity", 0,
                    "NumberOfDigitsAfterDecimal", 0,
                    "MaximumQuantity", -1,
                    "UOM", ""
                   ));
            msg = WaitForMessage();

            //clear data
            initialErrorKey = null;

            if (msg.Name.EndsWith(".QuantityEntered"))
            {
                numberOfFullLUID = Convert.ToInt32(ExtractParameter<double>(msg.Parameters, "quantity"));
                goto Step_CheckFullSSCC;
            }

            //go back
            goto Step_SelectCountingOption;


            #endregion

        Step_CheckFullSSCC:

            #region CHECK FULL SSCC

            query = BuildQuery.GetNumberOfFullLUIDs(selectedLocationCode);
            dsFullLUID = m_sboProviderService.RunView(false, null, null, query);

            if (this.GetNumberOfRows(dsFullLUID) != numberOfFullLUID)
            {
                initialErrorKey = "MSG_ERROR_CYCLE_COUNT_INCORRECT_NUMBER_OF_FULL_LUID";
                detailedCountAfterFullLUID = true;
                goto Step_ScanSSCC;
            }
            //Number of SSCC does correspond, so now we count partial SSCC's
            detailedCountAfterFullLUID = false;
            goto Step_ScanSSCC;

            #endregion



        }

        #endregion

        #region HELPERS


        /// <summary>
        /// Checks if there is a quantity the on barcode.
        /// </summary>
        /// <param name="barcode">The barcode.</param>
        /// <returns>
        /// True, if there is a quantity on the barcode, false if not
        /// </returns>
        public bool IsQuantityOnBarcode(BarcodeContainer barcode)
        {
            if (barcode != null &&
            barcode.GS1DataObject != null &&
                barcode.GS1DataObject.Count != null)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        private static string GetPackTypeName(string packagingTypeCode, Collection<PmxItemPackagingTypeInfo> listOfPackagingTypes)
        {
            if (listOfPackagingTypes != null)
            {
                foreach (PmxItemPackagingTypeInfo packType in listOfPackagingTypes)
                {
                    if (packType.PackagingTypeCode == packagingTypeCode)
                    {
                        return packType.PackagingTypeName;
                    }
                }
            }

            return null;
        }

        private static Collection<string> GetPackBarcode(string packagingTypeCode, Collection<PmxItemPackagingTypeInfo> listOfPackagingTypes)
        {
            if (listOfPackagingTypes != null)
            {
                foreach (PmxItemPackagingTypeInfo packType in listOfPackagingTypes)
                {
                    if (packType.PackagingTypeCode == packagingTypeCode)
                    {
                        return packType.Barcodes;
                    }
                }
            }

            return null;
        }

        /// <summary>
        /// Sets the item transactional packaging type info list.
        /// </summary>
        /// <param name="itemInfo">The item info.</param>
        /// <returns></returns>
        private Collection<ItemTransactionalPackagingTypeInfo> SetItemTransactionalPackagingTypeInfoList(PmxItemInfo itemInfo)
        {
            //get the packaging types qty from item
            Collection<ItemTransactionalPackagingTypeInfo> listOfTransactionalPackagingTypeInfos = new Collection<ItemTransactionalPackagingTypeInfo>();

            foreach (PmxItemPackagingTypeInfo packInfo in itemInfo.ListOfPackagingTypes)
            {
                ItemTransactionalPackagingTypeInfo newPackInfo = new ItemTransactionalPackagingTypeInfo();

                newPackInfo.PackagingTypeCode = packInfo.PackagingTypeCode;
                newPackInfo.Quantity = packInfo.Quantity;
                newPackInfo.ItemCode = itemInfo.ItemCode;

                listOfTransactionalPackagingTypeInfos.Add(newPackInfo);

            }

            return listOfTransactionalPackagingTypeInfos;
        }

        /// <summary>
        /// Gets the transactional packaging info.
        /// </summary>
        /// <param name="countedList">The counted list.</param>
        /// <param name="batchNumber">The batch number.</param>
        /// <param name="secondBatchNumber">The second batch number.</param>
        /// <param name="bestBeforeDate">The best before date.</param>
        /// <param name="itemCode">The item code.</param>
        /// <returns></returns>
        private static Collection<ItemTransactionalPackagingTypeInfo> GetTransactionalPackagingInfo(Dictionary<string, CycleCountInventoryItemInfo> countedList, string batchNumber, string secondBatchNumber, DateTime? bestBeforeDate, string itemCode)
        {
            //does it exist in the just received items?
            foreach (CycleCountInventoryItemInfo count in countedList.Values)
            {
                if (batchNumber == count.BatchNumber &&
                    secondBatchNumber == count.SecondBatchNumber &&
                    bestBeforeDate == count.BestBeforeDate &&
                    itemCode == count.ItemCode)
                {
                    //we found the packagingData
                    return count.ListOfPackagingTypes;
                }
            }
            return null;
        }

        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows(DataSet ds)
        {
            if (ds != null &&
                ds.Tables.Count > 0)
            {
                return ds.Tables[0].Rows.Count;
            }

            return 0;
        }


        /// <summary>
        /// Executes does location need to be counted.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static bool ExecuteDoesLocationNeedToBeCounted(PmxDbConnection conn, object[] parameters)
        {
            PmxCycleCountProvider ccProv = new PmxCycleCountProvider(conn);
            return ccProv.DoesLocationNeedToBeCounted((string)parameters[0], (PmxOtherOperationForCycleCountType)parameters[1]);

        }

        /// <summary>
        /// Executes get parameters.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static Dictionary<string, PmxParameterValue> ExecuteGetParametersCycleCountController(PmxDbConnection conn, object[] parameters)
        {
            PmxCycleCountProvider ccProv = new PmxCycleCountProvider(conn);
            return ccProv.GetParametersCycleCountController();

        }


        /// <summary>
        /// Executes skip count.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static object ExecuteSkipCount(PmxDbConnection conn, object[] parameters)
        {
            PmxCycleCountProvider ccProv = new PmxCycleCountProvider(conn);
            ccProv.SkipCountDuringOtherOperation((string)parameters[0], (PmxOtherOperationForCycleCountType)parameters[1], (ReasonInfo)parameters[2]);

            return null;

        }

        /// <summary>
        /// Executes the lock location.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static object ExecuteLockLocation(PmxDbConnection conn, object[] parameters)
        {
            PmxCycleCountProvider ccProv = new PmxCycleCountProvider(conn);
            ccProv.LockLocation((string)parameters[0]);
            return null;

        }


        /// <summary>
        /// Executes the lock location.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static object ExecuteRemoveRegistration(PmxDbConnection conn, object[] parameters)
        {
            PmxCycleCountRegistrationProvider ccProv = new PmxCycleCountRegistrationProvider(conn);
            ccProv.RemoveRegistrations((string)parameters[0]);
            return null;

        }



        /// <summary>
        /// 
        /// </summary>
        /// <param name="conn"></param>
        /// <param name="parameters"></param>
        /// <returns></returns>
        private static object ExecuteCycleCounting(PmxDbConnection conn, object[] parameters)
        {
            bool duringOtherOperation = (bool)parameters[3];
            Collection<CycleCountInventoryItemInfo> listOfItemsToUpdate = (Collection<CycleCountInventoryItemInfo>)parameters[0];
            PmxCycleCountProvider prov = new PmxCycleCountProvider(conn);
            if (duringOtherOperation)
            {
                //PmxOtherOperationForCycleCountTypeConvertor convertor = new PmxOtherOperationForCycleCountTypeConvertor();
                prov.PerformCountDuringOtherOperation(listOfItemsToUpdate, (string)parameters[1], (PmxOtherOperationForCycleCountType)parameters[2], (string)parameters[4]);
            }
            else
            {
                prov.PerformCountDuringCycleCount(listOfItemsToUpdate, (string)parameters[1], (string)parameters[4]);
            }

            return null;
        }



        /// <summary>
        /// Executes the can item be stored on storage location.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static bool ExecuteCanItemBeStoredOnStorageLocation(PmxDbConnection conn, object[] parameters)
        {
            PmxOseStorageLocationProvider prov = new PmxOseStorageLocationProvider(conn);
            return prov.CanItemBeStoredOnStorageLocation((string)parameters[0], (string)parameters[1], new PmxStorageLocationCanItemBeStoredInfo());
        }

        /// <summary>
        /// Executes the get item info.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static PmxItemInfo ExecuteGetItemInfo(PmxDbConnection conn, object[] parameters)
        {
            PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider(conn);
            return prov.GetCachedItemInfo((string)parameters[0]);
        }

        /// <summary>
        /// Executes the is SSCC valid.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        //private static bool ExecuteIsSSCCValid(PmxDbConnection conn, object[] parameters)
        //{
        //    PmxSSCCProvider ssccProv = new PmxSSCCProvider(conn);
        //    return ssccProv.IsValidChecksumSSCC((string)parameters[0]);
        //}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="ds"></param>
        /// <param name="locationCode"></param>
        /// <returns></returns>
        private bool ValidateLocation(DataSet ds, string locationCode)
        {
            if (!string.IsNullOrEmpty(locationCode) &&
                locationCode.IndexOf("->") < 0 && locationCode.IndexOf("<-") < 0 && // Reject the string if it's the default one "--> Bar code <--"
                ds != null &&
                ds.Tables.Count > 0)
            {
                return ds.Tables[0].Select(string.Format("{0} = '{1}' ", LocationDataSet.Columns.CODE.Name, locationCode)).Length == 1;
            }

            return false;
        }


        /// <summary>
        /// Executes is SSCC monolot pallet
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static bool ExecuteIsSSCCMonolotPallet(PmxDbConnection conn, object[] parameters)
        {
            PmxInventoryProvider invProv = new PmxInventoryProvider(conn);
            return invProv.IsMonoLotPallet((string)parameters[0]);
        }

        /// <summary>
        /// Executes the get PMX warehouse code.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static PmxOseWarehouseInfo ExecuteGetPmxWarehouseCode(PmxDbConnection conn, object[] parameters)
        {
            PmxOseProvider oseProv = new PmxOseProvider(conn);
            return oseProv.GetPmxWarehouseInfo((string)parameters[0]);
        }

        /// <summary>
        /// Executes the is master log unit.
        /// </summary>
        /// <param name="conn">The connection.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static bool ExecuteIsMasterLogUnit(PmxDbConnection conn, object[] parameters)
        {
            PmxLogisticUnitIDProvider luidProv = new PmxLogisticUnitIDProvider(conn);
            return luidProv.CheckIsSSCCMasterLogisticUnit((string)parameters[0]);
        }


        #endregion

    }

    #region BUILD QUERY

    /// <summary>
    /// Static class grouping our native queries
    /// </summary>
    internal static class BuildQuery
    {

        /// <summary>
        /// Gets the reasons.
        /// </summary>
        /// <returns></returns>
        public static string GetReasons()
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT  ");

            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxReasonTable.NAME, PmxReasonTable.Columns.Code.NAME, ReasonDataSet.Columns.REASON_CODE.Name);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxReasonTable.NAME, PmxReasonTable.Columns.Name.NAME, ReasonDataSet.Columns.REASON_NAME.Name);
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxReasonTable.NAME, PmxReasonTable.Columns.RequiresFreeText.NAME, ReasonDataSet.Columns.REASON_REQUIRES_FREE_TEXT.Name);

            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxReasonTable.NAME));

            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxReasonTable.Columns.UseForDirectCycleCount.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

            strBuilder.AppendFormat(
          " ORDER BY CASE WHEN {0} IS NULL THEN 1 ELSE 0 END, {0} ",
           SqlCommandHelper.EscapeTableColumnName(PmxReasonTable.NAME, PmxReasonTable.Columns.SequenceNumber.NAME));

            return strBuilder.ToString();
        }

        public static string GetNumberOfFullLUIDs(string locationCode)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.AppendFormat("SELECT DISTINCT {0}",
                SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME));

            strBuilder.AppendFormat(", {0}",
                SqlCommandHelper.EscapeTableColumnNameWithAlias(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME));


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME);

            strBuilder.Append(" WHERE ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));

            strBuilder.Append(" AND ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.IsFullPallet.NAME);
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));



            return strBuilder.ToString();
        }

        /// <summary>
        /// Gets the existing ITRI.
        /// </summary>
        /// <param name="itemCode">The item code.</param>
        /// <param name="batchNumber">The batch number.</param>
        /// <param name="batchNumber2">The batch number2.</param>
        /// <param name="bestBeforeDate">The best before date.</param>
        /// <returns></returns>
        public static string GetExistingITRI(string itemCode, string batchNumber, string batchNumber2, DateTime? bestBeforeDate)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.PackagingTypeCode.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.Quantity.NAME));


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));

            strBuilder.Append(" ON ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.ItemTransactionalInfoKey.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));



            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.ItemCode.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));

            if (!string.IsNullOrEmpty(batchNumber))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(batchNumber, CultureInfo.InvariantCulture));
            }

            if (!string.IsNullOrEmpty(batchNumber2))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(batchNumber2, CultureInfo.InvariantCulture));
            }

            if (bestBeforeDate.HasValue)
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(bestBeforeDate.Value, CultureInfo.InvariantCulture));
            }

            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalPackagingTypeTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalPackagingTypeTable.Columns.Quantity.NAME));


            return strBuilder.ToString();
        }

        /// <summary>
        /// Gets the existing ITRI.
        /// </summary>
        /// <param name="itemCode">The item code.</param>
        /// <param name="locationCode">The location code.</param>
        /// <returns></returns>
        public static string GetExistingYoungestBatch(string itemCode, string locationCode)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME));


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

            strBuilder.Append(" ON ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));



            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.ItemCode.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));


            strBuilder.Append(" AND ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));


            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));
            strBuilder.Append(" DESC ");


            return strBuilder.ToString();
        }


        /// <summary>
        /// Gets all the active location.
        /// </summary>
        /// <param name="warehouseCode">The warehouse code.</param>
        /// <param name="userCode">The user code.</param>
        /// <returns>
        /// The sql statement to get all the active location
        /// </returns>
        public static string GetAllLocationToCount(string warehouseCode, string userCode, bool cycleCountWithTask, string locationCode, string zoneCode, string deviceID)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME, LocationDataSet.Columns.DESCRIPTION.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, LocationDataSet.Columns.WAREHOUSECODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);

            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);

            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);


            strBuilder.Append("\r\n INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.WarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.SboWarehouseCode.NAME);

            strBuilder.Append("\r\n AND ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.IsManagedByProdumex.NAME);
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxUserTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.InternalKey.NAME);

            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

            if (cycleCountWithTask)
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.NeedsToBeCounted.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));
            }

            strBuilder.Append(" AND ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.AllowCountDuringCycleCount.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


            if (!string.IsNullOrEmpty(locationCode))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Code.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));

            }

            if (!string.IsNullOrEmpty(zoneCode))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxZoneCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(zoneCode, CultureInfo.InvariantCulture));

            }


            strBuilder.Append(" AND (");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);
            strBuilder.Append(" IS NULL ");
            strBuilder.Append(" OR ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.UserCode.NAME);
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(userCode, CultureInfo.InvariantCulture));
            strBuilder.Append(") ");





            if (!String.IsNullOrEmpty(warehouseCode) || !String.IsNullOrEmpty(deviceID))
            {
                strBuilder.Append(" AND ( ");
                if (!String.IsNullOrEmpty(warehouseCode))
                {
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));
                }
                if (!String.IsNullOrEmpty(deviceID))
                {
                    if (!String.IsNullOrEmpty(warehouseCode)) strBuilder.Append(" OR ");

                    strBuilder.AppendFormat("{0} IN ( SELECT {1} FROM {2} WHERE {3} = {4} )",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.PmxWarehouseCode.NAME),
                        SqlCommandHelper.EscapeTableName(PmxThinClientWarehouseTable.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.ParentCode.NAME),
                        SqlCommandHelper.FormatAndEscapeColumnValue(deviceID, CultureInfo.InvariantCulture));
                }
                strBuilder.Append(" )");
            }


            strBuilder.Append(" ORDER BY ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);
            strBuilder.Append(" DESC, ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

            return strBuilder.ToString();
        }


        /// <summary>
        /// Gets the registrations.
        /// </summary>
        /// <param name="locationCode">The location code.</param>
        /// <returns></returns>
        public static string GetRegistrations(string locationCode)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxCycleCountRegistrationTable.NAME, PmxCycleCountRegistrationTable.Columns.InternalKey.NAME, PmxCycleCountRegistrationTable.Columns.InternalKey.NAME);


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxCycleCountRegistrationTable.NAME));

            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxCycleCountRegistrationTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxCycleCountRegistrationTable.Columns.StorLocCode.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));


            return strBuilder.ToString();
        }


        /// <summary>
        /// Gets all zones to count.
        /// </summary>
        /// <param name="warehouseCode">The warehouse code.</param>
        /// <param name="userCode">The user code.</param>
        /// <param name="deviceID">The device ID.</param>
        /// <returns></returns>
        public static string GetAllZonesToCount(string warehouseCode, string userCode, string deviceID)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT DISTINCT ");

            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME, LocationDataSet.Columns.CODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseZoneTable.NAME, PmxOseZoneTable.Columns.Name.NAME, LocationDataSet.Columns.DESCRIPTION.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, LocationDataSet.Columns.WAREHOUSECODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);

            strBuilder.AppendFormat( ", MIN( {0} ) AS {1}",
            SqlCommandHelper.EscapeTableColumnName(PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME), 
                SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME ));

            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);


            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);


            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseZoneTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseZoneTable.NAME, PmxOseZoneTable.Columns.Code.NAME);
            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxUserTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.InternalKey.NAME);

            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

            strBuilder.Append(" AND ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.NeedsToBeCounted.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

            strBuilder.Append(" AND ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.AllowCountDuringCycleCount.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));




            strBuilder.Append(" AND (");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME);
            strBuilder.Append(" IS NULL ");
            strBuilder.Append(" OR ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxUserTable.NAME, PmxUserTable.Columns.UserCode.NAME);
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(userCode, CultureInfo.InvariantCulture));
            strBuilder.Append(") ");




            if (!String.IsNullOrEmpty(warehouseCode) || !String.IsNullOrEmpty(deviceID))
            {
                strBuilder.Append(" AND ( ");
                if (!String.IsNullOrEmpty(warehouseCode))
                {
                    SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
                    strBuilder.Append(" = ");
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));
                }
                if (!String.IsNullOrEmpty(deviceID))
                {
                    if (!String.IsNullOrEmpty(warehouseCode)) strBuilder.Append(" OR ");

                    strBuilder.AppendFormat("{0} IN ( SELECT {1} FROM {2} WHERE {3} = {4} )",
                        SqlCommandHelper.EscapeTableColumnName(PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.PmxWarehouseCode.NAME),
                        SqlCommandHelper.EscapeTableName(PmxThinClientWarehouseTable.NAME),
                        SqlCommandHelper.EscapeTableColumnName(PmxThinClientWarehouseTable.NAME, PmxThinClientWarehouseTable.Columns.ParentCode.NAME),
                        SqlCommandHelper.FormatAndEscapeColumnValue(deviceID, CultureInfo.InvariantCulture));
                }
                strBuilder.Append(" )");
            }

            strBuilder.Append( " GROUP BY " );
            strBuilder.Append( SqlCommandHelper.EscapeTableColumnName( PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxZoneCode.NAME ) );
            strBuilder.Append( ", " );
            strBuilder.Append( SqlCommandHelper.EscapeTableColumnName( PmxOseZoneTable.NAME, PmxOseZoneTable.Columns.Name.NAME ) );
            strBuilder.Append( ", " );
            strBuilder.Append( SqlCommandHelper.EscapeTableColumnName( PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME ) );
            strBuilder.Append( ", " );
            strBuilder.Append( SqlCommandHelper.EscapeTableColumnName( PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME ) );

            strBuilder.Append(" ORDER BY ");
            strBuilder.AppendFormat(" MIN( {0} )", 
            SqlCommandHelper.EscapeTableColumnName( PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.LockedBy.NAME ));
            strBuilder.Append( " DESC, " );
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseZoneTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseZoneTable.Columns.Name.NAME));

            return strBuilder.ToString();
        }

        /// <summary>
        /// Gets all the active location.
        /// </summary>
        /// <param name="warehouseCode">The warehouse code.</param>
        /// <returns>
        /// The sql statement to get all the active location
        /// </returns>
        public static string GetAllLocation(string warehouseCode)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT ");

            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME, LocationDataSet.Columns.CODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Name.NAME, LocationDataSet.Columns.DESCRIPTION.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME, LocationDataSet.Columns.WAREHOUSECODE.Name);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Name.NAME, LocationDataSet.Columns.WAREHOUSENAME.Name);


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseStorageLocationGeneralTable.NAME, PmxOseStorageLocationGeneralTable.Columns.Code.NAME);


            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);


            strBuilder.Append("\r\n INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.WarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.SboWarehouseCode.NAME);

            strBuilder.Append("\r\n AND ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxWarehouseTable.NAME, PmxWarehouseTable.Columns.IsManagedByProdumex.NAME);
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));


            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.IsActive.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

            if (!string.IsNullOrEmpty(warehouseCode))
            {
                strBuilder.Append(" AND ");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(warehouseCode, CultureInfo.InvariantCulture));
            }

            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxOseStorageLocationGeneralTable.Columns.Name.NAME));

            return strBuilder.ToString();
        }

        /// <summary>
        /// Gets the name of the products from stock order by.
        /// </summary>
        /// <param name="gtin">The gtin.</param>
        /// <param name="itemCode">The item code.</param>
        /// <param name="locationCode">The location code.</param>
        /// <param name="sscc">The SSCC.</param>
        /// <param name="forceSpecificSSCC">if set to <c>true</c> [force specific SSCC].</param>
        /// <param name="luid">The luid.</param>
        /// <param name="isLogisticCarrier">The is logistic carrier.</param>
        /// <param name="batchNumber">The batch number.</param>
        /// <param name="secondBatchNumber">The second batch number.</param>
        /// <param name="bestBeforeDate">The best before date.</param>
        /// <param name="forceSpecificITRI">if set to <c>true</c> [force specific ITRI].</param>
        /// <param name="packagingUnit">The packaging unit.</param>
        /// <param name="dbTool">The db tool.</param>
        /// <returns></returns>
        public static string GetProductsFromStockOrderByName(string gtin, string itemCode, string locationCode, string sscc, bool forceSpecificSSCC, int? luid, bool? isLogisticCarrier, string batchNumber, string secondBatchNumber, DateTime? bestBeforeDate, bool forceSpecificITRI, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit packagingUnit, DbTool dbTool)
        {
            return GetProductsFromStockOrderByName(gtin, itemCode, locationCode, sscc, forceSpecificSSCC, luid, isLogisticCarrier, batchNumber, secondBatchNumber, bestBeforeDate, forceSpecificITRI, packagingUnit, null, dbTool);
        }

        /// <summary>
        /// Gets the name of the products from stock order by.
        /// </summary>
        /// <param name="gtin">The gtin.</param>
        /// <param name="itemCode">The item code.</param>
        /// <param name="locationCode">The location code.</param>
        /// <param name="sscc">The SSCC.</param>
        /// <param name="forceSpecificSSCC">if set to <c>true</c> [force specific SSCC].</param>
        /// <param name="luid">The luid.</param>
        /// <param name="isLogisticCarrier">The is logistic carrier.</param>
        /// <param name="batchNumber">The batch number.</param>
        /// <param name="secondBatchNumber">The second batch number.</param>
        /// <param name="bestBeforeDate">The best before date.</param>
        /// <param name="forceSpecificITRI">if set to <c>true</c> [force specific ITRI].</param>
        /// <param name="packagingUnit">The packaging unit.</param>
        /// <param name="onlyFullLUID">The only full LUID.</param>
        /// <returns></returns>
        public static string GetProductsFromStockOrderByName( string gtin, string itemCode, string locationCode, string sscc, bool forceSpecificSSCC, int? luid, bool? isLogisticCarrier, string batchNumber, string secondBatchNumber, DateTime? bestBeforeDate, bool forceSpecificITRI, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit packagingUnit, bool? onlyFullLUID, DbTool dbTool )
        {
            DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();
            strBuilder.Append("SELECT ");

            SqlCommandHelper.AddTableColumnNameWithAs( strBuilder, PmxItemTable.VIEW_NAME, SboItemTable.Columns.ItemCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.ProductCode.NAME );

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs( strBuilder, PmxItemTable.VIEW_NAME, SboItemTable.Columns.ItemName.NAME, PmxStockOverviewOnLocationDefinition.Columns.ProductDescription.NAME );

            strBuilder.Append(", ");
            Produmex.Sbo.Logex.Data.SboCommands.AddBarcodeUsingPackagingUnit(strBuilder, packagingUnit, PmxStockOverviewOnLocationDefinition.Columns.GTIN.NAME);

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs( strBuilder, PmxItemTable.VIEW_NAME, SboItemTable.Columns.InventoryUom.NAME, PmxStockOverviewOnLocationDefinition.Columns.InventoryUom.NAME );
            
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs( strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.UOM2.NAME, PmxStockOverviewOnLocationDefinition.Columns.Uom2.NAME );

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME, PmxStockOverviewOnLocationDefinition.Columns.BatchNumber.NAME));
            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME, PmxStockOverviewOnLocationDefinition.Columns.BatchNumber2.NAME));
            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME, PmxStockOverviewOnLocationDefinition.Columns.BestBeforeDate.NAME));
            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QualityStatusCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.QualityStatusCode.NAME));
            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.SSCC.NAME, PmxStockOverviewOnLocationDefinition.Columns.SSCC.NAME));
            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.LogUnitIdentKey.NAME));
            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.InternalKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.InternalKey.NAME));
            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME, PmxStockOverviewOnLocationDefinition.Columns.DefaultLocationCode.NAME));
            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME, PmxStockOverviewOnLocationDefinition.Columns.ItemTransactionalInfoKey.NAME));
            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs( strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.Quantity.NAME, PmxStockOverviewOnLocationDefinition.Columns.Quantity.NAME );


            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.QuantityUom2.NAME, PmxStockOverviewOnLocationDefinition.Columns.QuantityUom2.NAME));


            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));

            //inner join Product - inventory
            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(" ON ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.Columns.ItemCode.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(SboItemTable.Columns.ItemCode.NAME));
            //left join for transaction info
            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTransactionalInfoTable.NAME));
            strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.ItemTransactionalInfoKey.NAME));
            strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxItemTransactionalInfoTable.NAME, PmxItemTransactionalInfoTable.Columns.InternalKey.NAME));

            //left join for luid
            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxLogisticUnitIDTable.NAME));
            strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));
            strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME));


            string operand = " WHERE ";
            if (!string.IsNullOrEmpty(gtin))
            {
                strBuilder.Append(operand);
                Produmex.Sbo.Logex.Data.SboCommands.AddWhereClauseSearchForBarcode(strBuilder, gtin);
                operand = " AND ";
            }

            if (!string.IsNullOrEmpty(itemCode))
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboItemTable.Columns.ItemCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
                operand = " AND ";
            }

            if (!string.IsNullOrEmpty(sscc))
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));
                operand = " AND ";
            }
            else if (forceSpecificSSCC)
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
                strBuilder.Append(" IS NULL ");
                operand = " AND ";

            }

            if (!string.IsNullOrEmpty(batchNumber))
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(batchNumber, CultureInfo.InvariantCulture));
                operand = " AND ";
            }
            else if (forceSpecificITRI)
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber1.NAME));
                strBuilder.Append(" IS NULL ");
                operand = " AND ";

            }
            if (!string.IsNullOrEmpty(secondBatchNumber))
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(secondBatchNumber, CultureInfo.InvariantCulture));
                operand = " AND ";
            }
            else if (forceSpecificITRI)
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BatchNumber2.NAME));
                strBuilder.Append(" IS NULL ");
                operand = " AND ";

            }
            if (bestBeforeDate.HasValue)
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(bestBeforeDate.Value, CultureInfo.InvariantCulture));
                operand = " AND ";
            }
            else if (forceSpecificITRI)
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTransactionalInfoTable.Columns.BestBeforeDate.NAME));
                strBuilder.Append(" IS NULL ");
                operand = " AND ";

            }

            if (!string.IsNullOrEmpty(locationCode))
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationCode, CultureInfo.InvariantCulture));
                operand = " AND ";
            }

            if (luid.HasValue)
            {
                strBuilder.AppendFormat(" {0} {1}.{2}  = {3} ", operand, SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME), SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME), SqlCommandHelper.FormatAndEscapeColumnValue(luid.Value, CultureInfo.InvariantCulture));
                operand = " AND ";
            }

            if (isLogisticCarrier.HasValue)
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));
                strBuilder.Append(" = ");
                if (isLogisticCarrier.Value)
                {
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));
                }
                else
                {
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));
                }
                operand = " AND ";
            }

            if (onlyFullLUID.HasValue)
            {
                strBuilder.Append(operand);

                strBuilder.AppendFormat(" " + strBuilder.IFNULL + "({0}, 'N') = {1} ", SqlCommandHelper.EscapeTableColumnName(PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.IsFullPallet.NAME),
                    SqlCommandHelper.FormatAndEscapeColumnValue(onlyFullLUID.Value ? SboBooleanColumnValues.Y.VALUE : SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));

                operand = " AND ";
            }

            //strBuilder.Append(operand);
            //strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            //strBuilder.Append(".");
            //strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboItemTable.Columns.InventoryItem.NAME));
            //strBuilder.Append(" = ");
            //strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboItemTable.Columns.ItemName.NAME));
            return strBuilder.ToString();
        }


        /// <summary>
        /// Gets the SSCC on other location.
        /// </summary>
        /// <param name="sscc">The SSCC.</param>
        /// <param name="locationToExclude">The location to exclude.</param>
        /// <returns></returns>
        public static string GetSSCCOnOtherLocation(string sscc, string locationToExclude)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("SELECT DISTINCT ");

            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME, PmxInventoryTotalTable.Columns.LogUnitIdentKey.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.SboWarehouseCode.NAME, PmxOseWarehouseTable.Columns.SboWarehouseCode.NAME));

            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxInventoryTotalTable.NAME));

            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseGeneralTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.Code.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxInventoryTotalTable.NAME, PmxInventoryTotalTable.Columns.StorLocCode.NAME);

            strBuilder.Append(" INNER JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxOseWarehouseTable.NAME));
            strBuilder.Append(" ON ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseGeneralTable.NAME, PmxOseGeneralTable.Columns.PmxWarehouseCode.NAME);
            strBuilder.Append(" = ");
            SqlCommandHelper.AddTableColumnName(strBuilder, PmxOseWarehouseTable.NAME, PmxOseWarehouseTable.Columns.Code.NAME);



            strBuilder.Append(" WHERE ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.SSCC.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(sscc, CultureInfo.InvariantCulture));

            strBuilder.Append(" AND ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxInventoryTotalTable.Columns.StorLocCode.NAME));
            strBuilder.Append(" <> ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(locationToExclude, CultureInfo.InvariantCulture));

            return strBuilder.ToString();
        }


        /// <summary>
        /// Gets the name of the products from catalog order by.
        /// </summary>
        /// <param name="gtin">The gtin.</param>
        /// <param name="itemCode">The item code.</param>
        /// <param name="packagingUnit">The packaging unit.</param>
        /// <returns></returns>
        public static string GetProductsFromCatalogOrderByName( string gtin, string itemCode, bool? isLogisticCarrier, Produmex.Sbo.Logex.Data.SboCommands.PackagingUnit packagingUnit, bool filterOutFrozenItems, DbTool dbTool )
        {
            DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();
            strBuilder.Append("SELECT DISTINCT");

            SqlCommandHelper.AddTableColumnNameWithAs( strBuilder, PmxItemTable.VIEW_NAME, SboItemTable.Columns.ItemCode.NAME, ProductDataSet.Columns.PRODUCT_CODE.Name );

            strBuilder.Append(", ");
            SqlCommandHelper.AddTableColumnNameWithAs( strBuilder, PmxItemTable.VIEW_NAME, PmxItemTable.Columns.CustomItemDescr.NAME, ProductDataSet.Columns.PRODUCT_DESCRIPTION.Name );

            //strBuilder.Append(", ");
            //strBuilder.Append(SboRecordsetHelper.GetSelectPartsColumnAndIsColumnNull(PmxItemTable.NAME, PmxItemTable.Columns.DefaultStorageLocationOrZoneCode.NAME, ProductDataSet.Columns.DEFAULT_LOCATION_CODE.Name));

            strBuilder.Append(", ");
            Produmex.Sbo.Logex.Data.SboCommands.AddBarcodeUsingPackagingUnit(strBuilder, packagingUnit, ProductDataSet.Columns.GTIN.Name);

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.HasBestBeforeDate.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboItemTable.Columns.ManBtchNum.NAME));

            strBuilder.Append(", ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticUnit.NAME));

            strBuilder.Append(", ", strBuilder.AsIdentifier(PmxItemTable.VIEW_NAME, SboItemTable.Columns.InventoryUom.NAME));

            strBuilder.Append(" FROM ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemTable.VIEW_NAME));

            strBuilder.Append(" LEFT JOIN ");
            strBuilder.Append(SqlCommandHelper.EscapeTableName(PmxItemPackagingTypeTable.NAME));
            strBuilder.Append(" ON ", strBuilder.AsIdentifier(PmxItemPackagingTypeTable.NAME, PmxItemPackagingTypeTable.Columns.ItemCode.NAME));
            strBuilder.Append(" = ", strBuilder.AsIdentifier(PmxItemTable.VIEW_NAME, SboItemTable.Columns.ItemCode.NAME));


            string operand = " WHERE ";
            if (!string.IsNullOrEmpty(gtin))
            {
                strBuilder.Append(operand);
                Produmex.Sbo.Logex.Data.SboCommands.AddWhereClauseSearchForBarcode(strBuilder, gtin);
                operand = " AND ";
            }

            if (!string.IsNullOrEmpty(itemCode))
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboItemTable.Columns.ItemCode.NAME));
                strBuilder.Append(" = ");
                strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(itemCode, CultureInfo.InvariantCulture));
                operand = " AND ";
            }

            if (isLogisticCarrier.HasValue)
            {
                strBuilder.Append(operand);
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
                strBuilder.Append(".");
                strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.IsLogisticCarrier.NAME));
                strBuilder.Append(" = ");
                if (isLogisticCarrier.Value)
                {
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));
                }
                else
                {
                    strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.N.VALUE, CultureInfo.InvariantCulture));
                }
                operand = " AND ";
            }

            strBuilder.Append(operand);
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(SboItemTable.Columns.InventoryItem.NAME));
            strBuilder.Append(" = ");
            strBuilder.Append(SqlCommandHelper.FormatAndEscapeColumnValue(SboBooleanColumnValues.Y.VALUE, CultureInfo.InvariantCulture));

            if ( filterOutFrozenItems )
            {
                Logex.Data.SboCommands.GetFrozenItemFilterSQLWherePart( strBuilder, " AND " );
            }

            strBuilder.Append(" ORDER BY ");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.VIEW_NAME));
            strBuilder.Append(".");
            strBuilder.Append(SqlCommandHelper.EscapeColumnName(PmxItemTable.Columns.CustomItemDescr.NAME));
            return strBuilder.ToString();
        }

    }

    #endregion

}
