//css_ref System.Data;
//css_ref System.Transactions;
//css_ref System.Xml;
//css_ref Interop.SAPbobsCOM.dll;
//css_ref log4net.dll;
//css_ref Produmex.Foundation.dll;
//css_ref Produmex.Foundation.Data.dll;
//css_ref Produmex.Foundation.Data.Sbo.dll;
//css_ref Produmex.Foundation.Sbo.dll;
//css_ref Produmex.Sbo.Logex.Data.dll;
//css_ref Produmex.Sbo.Logex.Weg.Data.dll;

using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Reflection;
using System.Transactions;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.Attributes;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Convertors;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Reflection;
using Produmex.Foundation.Resources;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Weg.Data.Generators.BarcodeController;
using Produmex.Sbo.Logex.WEG.Data.BusinessObjects.Definitions;
using Produmex.Sbo.Logex.WEG.Data.Generators.WegController;
using Produmex.Sbo.Logex.Weg.Data.Generators.PicklistController;


namespace AddUpdateScript
{
    class Program
    {
		static string CONNECTION_STRING = "Server=localhost;CompanyDB=SBODemoUS;ExtraDB=PMX_SBODemoUS;UseTrusted=False;DbUserName=sa;DbPassword=pwd;UserName=manager;Password=pwd;Pooling=True;MinPoolSize=2;MaxPoolSize=10;ServerType=MSSQL2008;DBCultureInfo=en-US;LicenseServer=localhost:30000";

        /// Used for logging
        /// </summary>
        private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);

        static void Main(string[] args)
        {
            try
            {
                Produmex.Foundation.Diagnostics.LogProvider.SetConsoleAppender("WARN");
                Execute();
            }
            catch (Exception ex)
            {
                s_log.Error("", ex);
            }
            if (Debugger.IsAttached)
            {
                Console.WriteLine("Press <Enter>");
                Console.ReadLine();
            }
        }

        private static readonly Assembly s_wegDataAssembly = typeof( Produmex.Sbo.Logex.Weg.Data.SboCommands ).Assembly;
        private static string LOCATION_SCRIPTS = "Produmex.Sbo.Logex.Weg.Data.Scripts.";

        static void Execute()
        {
            //SboConnectionString connectionStringObjectExtraDb = SboConnectionString.ParseStringToObject( CONNECTION_STRING );
            //connectionStringObjectExtraDb.CompanyDB = connectionStringObjectExtraDb.ExtraDB;

            using ( TransactionScope scope = PmxDbConnection.GetNewTransactionScope() )
            {
                using ( SboConnection conn = new SboConnection( CONNECTION_STRING ) )
                {
                    conn.Open();

                    DbTool dbTool = conn.DbTool;

                    PmxDbVersionUpdaterProvider updateProv = new PmxDbVersionUpdaterProvider( conn );

                    updateProv.AddUpdateUserDefinedTable(typeof(PmxWegBinDeliveryAddress));
                    updateProv.AddUpdateUserDefinedObject(typeof(PmxWegBinDeliveryAddress));
                    scope.Complete();
                }
            }

			using (SboConnection conn = new SboConnection(CONNECTION_STRING))
			{
				conn.Open();
				conn.DbTool.CreateUpdateTableNotInTransaction(typeof(PmxWegGlossaryTable), DbTool.TableParts.All);
				conn.DbTool.CreateUpdateTableNotInTransaction(typeof(PmxWegGlossaryItemsTable), DbTool.TableParts.All);
				conn.DbTool.CreateUpdateTableNotInTransaction(typeof(PmxWegGlossaryBusinessPartnersTable), DbTool.TableParts.All);
			}

            using ( TransactionScope scope = PmxDbConnection.GetNewTransactionScope() )
            {
                using ( SboConnection conn = new SboConnection( CONNECTION_STRING ) )
                {
                    conn.Open();
                    // * UDF's *
					SboUserFieldMDProvider udfProv = new SboUserFieldMDProvider(conn);
					SboColumnDefinitionAttribute maxPalletQtyColumnDef = new SboColumnDefinitionAttribute(
					   PmxItemWegTable.Columns.MaxPalletQty.NAME,
					   PmxItemWegTable.Columns.MaxPalletQty.DESCR,
					   PmxItemWegTable.Columns.MaxPalletQty.TYPE);
					maxPalletQtyColumnDef.IsMandatory = true;
					maxPalletQtyColumnDef.CanBeNull = false;
					maxPalletQtyColumnDef.DefaultValue = "0";
					maxPalletQtyColumnDef.FieldType = SboFieldType.Numeric;
					maxPalletQtyColumnDef.FieldSubType = SboFieldSubType.Quantity;
					udfProv.AddUpdateUserfield("OITM", maxPalletQtyColumnDef);

					SboColumnDefinitionAttribute capturedProdTimeColumnDef = new SboColumnDefinitionAttribute(
					   PmxProductionOrderWegTable.Columns.GT_ModTime.NAME,
					   PmxProductionOrderWegTable.Columns.GT_ModTime.DESCR,
					   PmxProductionOrderWegTable.Columns.GT_ModTime.TYPE,
					   PmxProductionOrderWegTable.Columns.GT_ModTime.SIZE,
					   PmxProductionOrderWegTable.Columns.GT_ModTime.SUB_TYPE);
					capturedProdTimeColumnDef.IsMandatory = true;
					capturedProdTimeColumnDef.CanBeNull = false;
					capturedProdTimeColumnDef.DefaultValue = "0";
					capturedProdTimeColumnDef.FieldType = SboFieldType.Numeric;
					capturedProdTimeColumnDef.FieldSubType = SboFieldSubType.Time;
					udfProv.AddUpdateUserfield("OWOR", capturedProdTimeColumnDef);
                    // * UDF's *

                    scope.Complete();
                }
            }

            //Console.WriteLine( "Extra DB ..." );

            //using ( TransactionScope scope = PmxDbConnection.GetNewTransactionScope() )
            //{
            //    using ( PmxDbConnection conn = PmxDbConnectionMgr.GetDirectConnection( connectionStringObjectExtraDb ) )
            //    {
            //        conn.Open();

            //        if ( conn.DbTool.DbServerType != DbServerType.HANA )
            //        {
            //            conn.DbTool.CreateUpdateView( "PMX_W_OPENGLOSSARIES", PreprocessSqlScript( ResourceHelper.ReadResourceContentAsString( s_wegDataAssembly, LOCATION_SCRIPTS + "StoredProcedures.MSSQL.PMX_W_OPENGLOSSARIES.sql" ), conn ) );
            //        }

            //        scope.Complete();
            //    }
            //}

            Console.WriteLine( "Extensions ..." );

            using ( TransactionScope scope = PmxDbConnection.GetNewTransactionScope() )
            {
                using ( PmxDbConnection conn = PmxDbConnectionMgr.GetDirectConnection( SboConnectionString.ParseStringToObject( CONNECTION_STRING ) ) )
                {
                    conn.Open();

                    // bar code controller
                    AddUpdateExtension(
                         WegBarcodeController.IDs.ExtCode,
                         WegBarcodeController.IDs.Description,
                         typeof( WegBarcodeController ),
                         Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IBARCODECONTROLLER,
                         conn
                         );

                    // custom picklist controller
                    AddUpdateExtension(
	                    WegIberiaPicklistController.IDs.ExtCode,
	                    WegIberiaPicklistController.IDs.Description,
	                    typeof(WegIberiaPicklistController),
	                    Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IPICKLISTCONTROLLER,
	                    conn
                    );

					DbQueryBuilder qb = conn.DbTool.GetQueryBuilder();

                    qb = qb.Select.
                        EscTableColumnName(PmxPropertyTable.NAME, PmxPropertyTable.Columns.ExtensionCode.NAME).CRLF.
                        From.CRLF.
                            EscTableName(PmxPropertyTable.NAME).
                        CRLF.Where.CRLF.
                        EscColumnName(PmxPropertyTable.Columns.Code.NAME).
                            Eq.
                                String_(Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IPICKLISTCONTROLLER).
                            And.
                                EscColumnName(PmxPropertyTable.Columns.ExtensionCode.NAME).
                            Eq.
                                String_(WegIberiaPicklistController.IDs.ExtCode);
                      
                   


                    string query = qb.ToString();

                    using (ISboRecordset rs = SboRecordsetHelper.RunQuery(s_log, query, conn))
                    {
                        int numberOfRecords = rs.RecordCount;
                        if (numberOfRecords > 0)
                        {
                            #region PICK LIST CONTROLLER

                            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CAN_PICK_FULL_LUID_FROM_BULK_LOCATION,
                            "Can the user pick full pallet from bulk location? (Y/N)",
                            WegIberiaPicklistController.IDs.ExtCode,
                            Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                            "True", conn);

                            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MUST_FIRST_PICK_FULL_LUID_FROM_BULK_LOCATION,
                                "Must the user first pick full pallet from bulk location? (Y/N)",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "True", conn);


                            AddUpdateExtensionParameter(
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_FORCE_PICK_FULL_LUID,
                                "Force the user to pick full pallet? (Y/N)",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "True", conn);

                            AddUpdateExtensionParameter(
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ONLY_ITEMS_UNDER_DOCK,
                                "Only pick items on location on same or lower level as dock? (Y/N)",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "False", conn);

                            AddUpdateExtensionParameter(
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_COPY_BATCH_FOR_ALTERNATE_ITEMS,
                                "Copy batch number when selecting alternate item? (Y/N)",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "False", conn);

                            AddUpdateExtensionParameter(
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MAKE_READY_BEFORE_PRINT,
                                "Make picklist ready before print? (Y/N)",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "True",
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MAKE_READY_BEFORE_PRINT, conn);

                            AddUpdateExtensionParameter(
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CUSTOM_WAVE_DESCR_JOIN_SQL,
                                "JOIN-sql for custom wave description for scanner",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
                                null, conn);


                            AddUpdateExtensionParameter(
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CUSTOM_WAVE_DESCR_FIELDS,
                                "Custom wave description fields for scanner",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_CONVERTOR,
                                null, conn);

                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamCopyNonInventoryItemsToResInv,
                                "Copy non-inventory items to reserve invoice?",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "False",
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_COPY_NON_INVENTORY_ITEMS_TO_RES_INV, conn);



                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamPickItemsOrderBy,
                                "Pick items order by",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR,
                                PmxPickListItemOrderByCodes.FULL_LOCATION_NO_PICK,
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, conn);




                            //add to valid value list
                            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, PmxPickListItemOrderByCodes.FULL_LOCATION_NO_PICK, "Order by Full LUID, sequence, no location", conn);
                            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, PmxPickListItemOrderByCodes.FULL_PICKEDITEM_LOCATION, "Order by Full LUID, picked item, locationcode", conn);
                            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PICK_ITEMS_ORDER_BY, PmxPickListItemOrderByCodes.SEQUENCE_LOCATION_FULLLUID, "Order by Sequence, location code, full LUID", conn);

                            //adhoc related
                            AddUpdateExtensionParameter(
                                   WegIberiaPicklistController.IDs.ExtParamAdHocAlternateItem,
                                   "Ad hoc alternate item? (Y/N)",
                                   WegIberiaPicklistController.IDs.ExtCode,
                                   Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                   "False",
                                   PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AD_HOC_ALTERNATE_ITEM,
                                   (int)WegIberiaPicklistController.IDs.ExtensionParameterType.Default, conn);

                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamAllowAllGoodsPickedConfirm,
                                "Allow confirmation that ALL goods were picked",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "True",
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_ALL_GOODS_PICKED_CONFIRM,
                                (int)WegIberiaPicklistController.IDs.ExtensionParameterType.AdHoc, conn);

                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamAutoMoveSSCCOnCustomerCollect,
                                "Auto move SSCC on a customer-collected related move",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "False",
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_MOVE_SSCC_ON_CUSTOMER_COLLECT,
                                1, conn);

                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamEnterReasonWhenSkippingFirstLocationAdHocPicking,
                                "Reason requirements when skipping first location (Ad hoc picking)",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR,
                                PmxPickListRequiresReasonCodes.REQUIRES_NO_REASON,
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ENTER_REASON_SKIP_FIRST_LOC_ADHOC_PICKING,
                                (int)WegIberiaPicklistController.IDs.ExtensionParameterType.AdHoc, conn);


                            //add to valid value list
                            AddUpdateParameterValidValue(
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ENTER_REASON_SKIP_FIRST_LOC_ADHOC_PICKING,
                                PmxPickListRequiresReasonCodes.REQUIRES_NO_REASON,
                                "No reason is necessary.", conn);

                            AddUpdateParameterValidValue(
                                 PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ENTER_REASON_SKIP_FIRST_LOC_ADHOC_PICKING,
                                 PmxPickListRequiresReasonCodes.REQUIRES_REASON_FREE_TEXT,
                                 "Requires user-entered reasontext", conn);

                            AddUpdateParameterValidValue(
                                 PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ENTER_REASON_SKIP_FIRST_LOC_ADHOC_PICKING,
                                 PmxPickListRequiresReasonCodes.REQUIRES_SELECTED_REASON,
                                 "Requires selected reason from list", conn);

                            AddUpdateExtensionParameter(
                               WegIberiaPicklistController.IDs.ExtParamAllowMultipleCustomersOnSSCC,
                               "Allow multiple customers on SSCC?",
                               WegIberiaPicklistController.IDs.ExtCode,
                               Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                               "False",
                               PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_MULTIPLE_CUSTOMERS_ON_SSCC, conn);


                            AddUpdateExtensionParameter(
                               WegIberiaPicklistController.IDs.ExtParamAutoFillInQuantityForPackingTypes,
                               "Auto fill quantity for packaging types?",
                               WegIberiaPicklistController.IDs.ExtCode,
                               Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                               "False",
                               PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_FILL_QTY_PACK_TYPES, conn);



                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamWaveOrderBy,
                                "Wave order by",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR,
                                PmxWaveOrderByCodes.PRIORITY_DUE_KEY,
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_WAVE_ORDER_BY, conn);

                            //add to valid value list
                            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_WAVE_ORDER_BY, PmxWaveOrderByCodes.PRIORITY_DUE_KEY, "Order by priority, due date, wave key", conn);
                            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_WAVE_ORDER_BY, PmxWaveOrderByCodes.DUE_PRIORITY_KEY, "Order by due date, priority, wave key", conn);


                            AddUpdateExtensionParameter(
                              WegIberiaPicklistController.IDs.ExtParamAutoSelectWave,
                              "Auto select the wave?",
                              WegIberiaPicklistController.IDs.ExtCode,
                              Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                              "False",
                              PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_SELECT_WAVE, conn);

                            AddUpdateExtensionParameter(
                             WegIberiaPicklistController.IDs.ExtParamAutoSelectItri,
                               "Auto select batch/BBD on picking?",
                             WegIberiaPicklistController.IDs.ExtCode,
                             Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                             "false",
                             PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTO_SELECT_ITRI, conn);

                            AddUpdateExtensionParameter(
                             WegIberiaPicklistController.IDs.ExtParamAllowToIdentifySSCCToPickOn,
                               "Allow to identify the SSCC to pick on?",
                             WegIberiaPicklistController.IDs.ExtCode,
                             Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                             "false",
                             PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_TO_IDENTIFY_SSCC_TO_PICK_ON, conn);

                            AddUpdateExtensionParameter(
                             WegIberiaPicklistController.IDs.ExtParamAllowToSelectItemToPick,
                               "Allow to select the item to pick?",
                             WegIberiaPicklistController.IDs.ExtCode,
                             Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                             "false",
                             PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_TO_SELECT_ITEM_TO_PICK, conn);


                            AddUpdateExtensionParameter(
                            WegIberiaPicklistController.IDs.ExtParamConsolidateItemsToPick,
                              "Consolidate items to pick?",
                            WegIberiaPicklistController.IDs.ExtCode,
                            Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                            "false",
                            PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CONSOLIDATE_ITEMS_TO_PICK, conn);


                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamDisableSelectionOfItems,
                                "Disable selection of items? (Y/N)",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "False",
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_DISABLE_SELECTION_OF_ITEMS, conn);


                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamRoutePickingPickListOrderBy,
                                "Route picking picklist order by",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_LIST_CONVERTOR,
                                PmxRoutePickingPickListOrderByCodes.PRIORITY_DUEDATE_DOCENTRY,
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ROUTEPICKING_PICKLIST_ORDER_BY, conn);
                            AddUpdateParameterValidValues(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ROUTEPICKING_PICKLIST_ORDER_BY, typeof(PmxRoutePickingPickListOrderByCodes), conn);

                            AddUpdateExtensionParameter(
                                   WegIberiaPicklistController.IDs.ExtParamAllowCycleCountOfOriginalPickLocationOnAlternatePicking,
                                   "Allow cycle count on alternate picking? (Y/N)",
                                   WegIberiaPicklistController.IDs.ExtCode,
                                   Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                   "False",
                                   PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_CYCLE_COUNT_OF_ORIGINAL_PICK_LOCATION_ON_ALTERNATE_PICKING,
                                   (int)WegIberiaPicklistController.IDs.ExtensionParameterType.Default, conn);


                            AddUpdateExtensionParameter(
                                    WegIberiaPicklistController.IDs.ExtParamLockWaveByZoneUserForZonePicking,
                                    "Lock wave by zone/user (Zone picking)",
                                    WegIberiaPicklistController.IDs.ExtCode,
                                    Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                    "False",
                                    PmxExtensionParameterCodes.PICKLIST_CONTROLLER_LOCK_WAVE_BY_ZONE_USER_FOR_ZONE_PICKING,
                                    (int)WegIberiaPicklistController.IDs.ExtensionParameterType.ZonePicking, conn);

                            AddUpdateExtensionParameter(
                                   WegIberiaPicklistController.IDs.ExtParamOnlyShowCompletelyUnlockedWavesOnZonePicking,
                                   "Only show completely unlocked waves in case of zone picking?",
                                   WegIberiaPicklistController.IDs.ExtCode,
                                   Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                   "False",
                                   PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ONLY_SHOW_COMPLETELY_UNLOCKED_WAVES_FOR_ZONE_PICKING,
                                   (int)WegIberiaPicklistController.IDs.ExtensionParameterType.ZonePicking, conn);

                            AddUpdateExtensionParameter(
                                   WegIberiaPicklistController.IDs.ExtParamMsgItemIsPickedTimeInterval,
                                   "Time to show 'item is picked' message?",
                                   WegIberiaPicklistController.IDs.ExtCode,
                                   Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_INT32_CONVERTOR,
                                   "0",
                                   PmxExtensionParameterCodes.PICKLIST_CONTROLLER_MSG_ITEM_IS_PICKED_TIME_INTERVAL,
                                   (int)WegIberiaPicklistController.IDs.ExtensionParameterType.Default, conn);

                            AddUpdateExtensionParameter(
                                    WegIberiaPicklistController.IDs.ExtParamPackingMsgPickPackRemarksTimeInterval,
                                    "Time to show pick/pack remarks on packing?",
                                    WegIberiaPicklistController.IDs.ExtCode,
                                    Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_INT32_CONVERTOR,
                                    "-1",
                                    PmxExtensionParameterCodes.PICKLIST_CONTROLLER_PACKING_MSG_PICK_PACK_REMARKS_TIME_INTERVAL,
                                    (int)WegIberiaPicklistController.IDs.ExtensionParameterType.Packing, conn);


                            AddUpdateExtensionParameter(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CAN_PICK_BULK_QTY_FROM_BULK_LOCATION,
                                "Can the user pick bulk quantity from bulk location? (Y/N)",
                                WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "False", conn);

                            AddUpdateExtensionParameter(
                                  WegIberiaPicklistController.IDs.ExtParamPickFromBulkForAdhocPicking,
                                  "Allow ad hoc picking from bulk locations?",
                                  WegIberiaPicklistController.IDs.ExtCode,
                                Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                  "False",
                                  PmxExtensionParameterCodes.PICKLIST_CONTROLLER_ALLOW_ADHOC_PICKING_FROM_BULK,
                                  (int)WegIberiaPicklistController.IDs.ExtensionParameterType.AdHoc, conn);


                            AddUpdateExtensionParameter(
                                    WegIberiaPicklistController.IDs.ExtParamChooseDockAdhocPicking,
                                    "Choose dock on ad hoc picking?",
                                    WegIberiaPicklistController.IDs.ExtCode,
                                  Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                    "False",
                                    PmxExtensionParameterCodes.PICKLIST_CONTROLLER_CHOOSE_DOCK_ADHOC_PICKING,
                                    (int)WegIberiaPicklistController.IDs.ExtensionParameterType.AdHoc, conn);

                            AddUpdateExtensionParameter(
                                    WegIberiaPicklistController.IDs.ExtParamKeepPickingSameItemForAdhocPicking,
                                    "Ad hoc picking: Keep picking same item? (Y/N)",
                                 WegIberiaPicklistController.IDs.ExtCode,
                                  Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                    "False",
                                    PmxExtensionParameterCodes.PICKLIST_CONTROLLER_KEEP_PICKING_SAME_ITEM_ADHOC_PICKING,
                                    (int)WegIberiaPicklistController.IDs.ExtensionParameterType.AdHoc, conn);

                            AddUpdateExtensionParameter(
                                WegIberiaPicklistController.IDs.ExtParamKeepPickingSameLocationForPicking,
                                "Picking: Keep picking same location? (Y/N)",
                                 WegIberiaPicklistController.IDs.ExtCode,
                                  Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                "False",
                                PmxExtensionParameterCodes.PICKLIST_CONTROLLER_KEEP_PICKING_SAME_LOCATION_PICKING,
                                (int)WegIberiaPicklistController.IDs.ExtensionParameterType.Default, conn);

                            AddUpdateExtensionParameter(
                                    WegIberiaPicklistController.IDs.ExtParamAutoFillInitialQuantityAdHocPicking,
                                    "Ad hoc: Auto fill pick quantity? (Y/N)",
                                     WegIberiaPicklistController.IDs.ExtCode,
                                      Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                    "False",
                                    PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AD_HOC_AUTO_FILL_INITIAL_QUANTITY,
                                    (int)WegIberiaPicklistController.IDs.ExtensionParameterType.AdHoc, conn);

                            AddUpdateExtensionParameter(
                                    WegIberiaPicklistController.IDs.ExtParamShowLockedQuantityForLineAlternatePicking,
                                    "Alternate: Show locked quantity for current line? (Y/N)",
                                     WegIberiaPicklistController.IDs.ExtCode,
                                      Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                    "False",
                                    PmxExtensionParameterCodes.PICKLIST_CONTROLLER_SHOW_LOCKED_STOCK_FOR_LINE_ALTERNATE_PICKING,
                                    (int)WegIberiaPicklistController.IDs.ExtensionParameterType.Default, conn);

                            AddUpdateExtensionParameter(
                                   WegIberiaPicklistController.IDs.ExtParamAutomaticSelectionOfMoveableLocation,
                                   "Auto selection of moveable location during picking? (Y/N)",
                                   WegIberiaPicklistController.IDs.ExtCode,
                                   Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                                   "False",
                                   PmxExtensionParameterCodes.PICKLIST_CONTROLLER_AUTOMATIC_SELECTION_OF_MOVEABLE_LOCATION,
                                   (int)WegIberiaPicklistController.IDs.ExtensionParameterType.Default, conn);


                            AddUpdateExtensionParameter(
                              WegIberiaPicklistController.IDs.ExtParamStockOrderBy,
                              "Stock order by",
                              WegIberiaPicklistController.IDs.ExtCode,
                              Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_STRING_VALID_VALUE_CONVERTOR,
                              PmxPickListStockOrderByCodes.DEFAULT,
                              PmxExtensionParameterCodes.PICKLIST_CONTROLLER_STOCK_ORDER_BY,
                              (int)WegIberiaPicklistController.IDs.ExtensionParameterType.Default, conn);

                            //add to valid value list
                            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_STOCK_ORDER_BY, PmxPickListStockOrderByCodes.DEFAULT, "Default Order by", conn);
                            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_STOCK_ORDER_BY, PmxPickListStockOrderByCodes.BIGGEST_PALLET_FIRST, "Order by Highest quantity, oldest LUID", conn);
                            AddUpdateParameterValidValue(PmxExtensionParameterCodes.PICKLIST_CONTROLLER_STOCK_ORDER_BY, PmxPickListStockOrderByCodes.LOWEST_QUANTITY_FIRST, "Order by lowest quantity", conn);





                            #endregion
                        }


                    }


                    // WEG controller
                    AddUpdateExtensionType( PmxWegExtensionTypeCodes.IWEGCONTROLLER,
                    "IWEGController - WEG controller",
                    typeof( IWegController ), conn );

                    AddUpdateExtension( PmxWegExtensionCodes.WEGCONTROLLER, "WEG controller",
                        typeof( WegController ),
                        PmxWegExtensionTypeCodes.IWEGCONTROLLER, conn );


                    AddUpdateProperty( PmxWegPropertyCodes.WEGCONTROLLER, "WEG controller", PmxWegExtensionTypeCodes.IWEGCONTROLLER,
                        PmxWegExtensionCodes.WEGCONTROLLER, conn );

                    //parameters
                    AddUpdateExtensionParameter(
                        WegController.IDs.ExtParamUpdateInventoryTransferRequestsForFullPalletRefill,
                        "Update inventory transfer requests for full pallet refill? (Y/N)",
                        WegController.IDs.ExtCode,
                        Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                        "False",
                        PmxWegExtensionParameterCodes.UPDATE_INVENTORY_TRANSFER_REQUESTS_FOR_FULL_PALLET_REFILL, conn );

                    //parameters
                    AddUpdateExtensionParameter(
                        WegController.IDs.ExtParamContainerReceptionSplitMixedPallets,
                        "Container reception: split mixed pallets? (Y/N)",
                        WegController.IDs.ExtCode,
                        Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                        "True",
                        PmxWegExtensionParameterCodes.CONTAINER_RECEPTION_SPLIT_MIXED_PALLETS, conn );

                    //parameters
                    AddUpdateExtensionParameter(
                        WegController.IDs.ExtParamRecommendPalletToFillInPutAway,
                        "Recommend pallet to fill in during put away? (Y/N)",
                        WegController.IDs.ExtCode,
                        Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                        "False",
                        PmxWegExtensionParameterCodes.RECOMMEND_PALLET_TO_FILL_IN_PUT_AWAY, conn );

                    //parameters
                    AddUpdateExtensionParameter(
                        WegController.IDs.ExtParamCaptureProductionTime,
                        "Capture production time? (Y/N)",
                        WegController.IDs.ExtCode,
                        Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                        "False",
                        PmxWegExtensionParameterCodes.CAPTURE_PRODUCTION_TIME, conn );

                    //parameters
                    AddUpdateExtensionParameter(
                        WegController.IDs.ExtParamCreatePutAwayOrdersForContainerReception,
                        "Create put away orders for container reception",
                        WegController.IDs.ExtCode,
                        Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
                        "False",
                        PmxWegExtensionParameterCodes.CREATE_PUTAWAY_ORDERS_FOR_CONTAINER_RECEPTION, conn);

					//parameters
					AddUpdateExtensionParameter(
						WegController.IDs.ExtParamCaptureProductionOperator,
						"Capture production operator? (Y/N)",
						WegController.IDs.ExtCode,
						Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.PmxExtensionCodes.SYSTEM_BOOL_CONVERTOR,
						"False",
						PmxWegExtensionParameterCodes.CAPTURE_PRODUCTION_OPERATOR, conn);


                    // EDI interfaces
                    AddUpdateExtension( PmxWegExtensionCodes.WEG_BENELUX_SALES_ORDER_INTERFACE, "SBO sales order im-/export for WEG Benelux",
                        typeof( Produmex.Sbo.Logex.Weg.Data.Extensions.Interfacing.SboSalesOrderInterface ),
                        Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.PmxExtensionTypeCodes.IINTERFACING_SBOSALESORDER, conn );

                    scope.Complete();
                }
            }

            Console.WriteLine( "Done ..." );
        }


        /// <summary>
        /// Add/update <see cref="PmxExtensionType"/>
        /// </summary>
        /// <param name="code">The code of the extension type.</param>
        /// <param name="name">The name of the extension type.</param>
        /// <param name="interfaceType">The interface type of the extension type.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionType( string code, string name, Type interfaceType, PmxDbConnection conn )
        {
            PmxExtensionTypeProvider prov = new PmxExtensionTypeProvider( conn );
            PmxExtensionType exType = null;
            try
            {
                bool newBO = false;
                exType = prov.GetBO( code );
                if ( exType == null )
                {
                    newBO = true;
                    exType = prov.GetNewBO();
                    exType.Code = code;
                }
                exType.Name = name;
                exType.InterfaceType = ReflectionHelper.GetTypeAndAssemblyName( interfaceType );
                if ( newBO )
                {
                    prov.AddBO( exType );
                }
                else
                {
                    prov.UpdateBO( exType, false, false );
                }
            }
            finally
            {
                if ( exType != null ) exType.Dispose();
            }
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtension"/>
        /// </summary>
        /// <param name="code">The code of the extension.</param>
        /// <param name="name">The name of the extension.</param>
        /// <param name="type">The type of the extension.</param>
        /// <param name="extensionTypeCode">The extension type code.</param>
        /// <param name="conn">The DB connection</param>
        private static void AddUpdateExtension( string code, string name, Type type, string extensionTypeCode, PmxDbConnection conn )
        {
            PmxExtensionProvider prov = new PmxExtensionProvider( conn );
            PmxExtension extension = null;
            try
            {
                bool newBO = false;
                extension = prov.GetBO( code );
                if ( extension == null )
                {
                    newBO = true;
                    extension = prov.GetNewBO();
                    extension.Code = code;
                }
                extension.Name = name;
                extension.ExtensionTypeCode = extensionTypeCode;
                extension.Type = ReflectionHelper.GetTypeAndAssemblyName( type );
                if ( newBO )
                {
                    prov.AddBO( extension );
                }
                else
                {
                    prov.UpdateBO( extension, false, false );
                }
            }
            finally
            {
                if ( extension != null ) extension.Dispose();
            }
        }

        /// <summary>
        /// Add/Update <see cref="PmxProperty"/>
        /// </summary>
        /// <param name="code">The code of the property.</param>
        /// <param name="name">The name of the property.</param>
        /// <param name="extensionTypeCode">The extension type code.</param>
        /// <param name="conn">The DB connection</param>
        private static void AddUpdateProperty( string code, string name, string extensionTypeCode, PmxDbConnection conn )
        {
            AddUpdateProperty( code, name, extensionTypeCode, null, conn );
        }


        /// <summary>
        /// Add/Update <see cref="PmxProperty"/>
        /// </summary>
        /// <param name="code">The code of the property.</param>
        /// <param name="name">The name of the property.</param>
        /// <param name="extensionTypeCode">The extension type code.</param>
        /// <param name="defaultNewExtensionCode">The default new extension code.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateProperty( string code, string name, string extensionTypeCode, string defaultNewExtensionCode, PmxDbConnection conn )
        {
            PmxPropertyProvider prov = new PmxPropertyProvider( conn );
            PmxProperty property = null;
            try
            {
                bool newBO = false;
                property = prov.GetBO( code );
                if ( property == null )
                {
                    newBO = true;
                    property = prov.GetNewBO();
                    property.Code = code;
                }
                property.Name = name;
                property.ExtensionTypeCode = extensionTypeCode;

                if ( newBO )
                {
                    if ( !string.IsNullOrEmpty( defaultNewExtensionCode ) )
                    {
                        //only set when defaulExtansionCode is set, and the property is new
                        property.ExtensionCode = defaultNewExtensionCode;
                    }
                    prov.AddBO( property );
                }
                else
                {
                    prov.UpdateBO( property, false, false );
                }
            }
            finally
            {
                if ( property != null ) property.Dispose();
            }
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionParameter( string code, string name, string extensionCode, string convertorCode, string defaultValue, PmxDbConnection conn )
        {
            AddUpdateExtensionParameter( code, name, extensionCode, convertorCode, defaultValue, code, conn );
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="generalParameterCode">The general parameter code.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionParameter( string code, string name, string extensionCode, string convertorCode, string defaultValue, string generalParameterCode, PmxDbConnection conn )
        {
            AddUpdateExtensionParameter( code, name, extensionCode, convertorCode, defaultValue, generalParameterCode, 0, conn );
        }

        /// <summary>
        /// Add/Update <see cref="PmxExtensionParameter"/>
        /// </summary>
        /// <param name="code">The code of the extension parameter.</param>
        /// <param name="name">The name of the extension parameter.</param>
        /// <param name="extensionCode">The extension code.</param>
        /// <param name="convertorCode">The convertor code.</param>
        /// <param name="defaultValue">The default value.</param>
        /// <param name="generalParameterCode">The general parameter code.</param>
        /// <param name="sequence">The sequence.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateExtensionParameter( string code, string name, string extensionCode, string convertorCode, string defaultValue, string generalParameterCode, int sequence, PmxDbConnection conn )
        {
            PmxExtensionParameterProvider prov = new PmxExtensionParameterProvider( conn );
            PmxExtensionParameter extParam = null;
            try
            {
                bool newBO = false;
                extParam = prov.GetBO( code );
                if ( extParam == null )
                {
                    newBO = true;
                    extParam = prov.GetNewBO();
                    extParam.Code = code;
                }
                extParam.Name = name;
                extParam.ExtensionCode = extensionCode;
                extParam.ConvertorCode = convertorCode;
                extParam.GeneralParameterCode = generalParameterCode;
                extParam.DefaultValue = defaultValue;
                extParam.Sequence = sequence;
                if ( newBO )
                {
                    prov.AddBO( extParam );
                }
                else
                {
                    prov.UpdateBO( extParam, false, false );
                }
            }
            finally
            {
                if ( extParam != null ) extParam.Dispose();
            }
        }

        /// <summary>
        /// Add <see cref="PmxParameterValidValues"/>
        /// </summary>
        /// <param name="parameterCode">The parameter code.</param>
        /// <param name="parameterValidValue">The parameter valid value.</param>
        /// <param name="parameterValidValueDescription">The parameter valid value description.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateParameterValidValue( string parameterCode, string parameterValidValue, string parameterValidValueDescription, PmxDbConnection conn )
        {
            PmxParameterValidValuesProvider prov = new PmxParameterValidValuesProvider( conn );
            PmxParameterValidValues validValue = null;
            try
            {
                bool newBO = false;
                validValue = prov.GetParameterValidValue( parameterCode, parameterValidValue );
                if ( validValue == null )
                {
                    newBO = true;
                    validValue = prov.GetNewBO();
                    validValue.ParameterCode = parameterCode;
                    validValue.ParameterValidValue = parameterValidValue;
                }
                validValue.ParameterValidValueDescription = parameterValidValueDescription;
                if ( newBO )
                {
                    prov.AddBO( validValue );
                }
                else
                {
                    prov.UpdateBO( validValue, false, false );
                }
            }
            finally
            {
                if ( validValue != null ) validValue.Dispose();
            }

        }

        /// <summary>
        /// Adds/updates parameter valid values.
        /// </summary>
        /// <param name="parameterCode">The parameter code.</param>
        /// <param name="staticClassType">Type of the static class.</param>
        /// <param name="conn">The DB connection</param>
        public static void AddUpdateParameterValidValues( string parameterCode, Type staticClassType, PmxDbConnection conn )
        {
            FieldInfo[] fis = staticClassType.GetFields();
            foreach ( FieldInfo fi in fis )
            {
                foreach ( DescriptionAttribute attr in fi.GetCustomAttributes( typeof( DescriptionAttribute ), false ) )
                {
                    AddUpdateParameterValidValue( parameterCode, (string)fi.GetValue( null ), attr.Description, conn );
                }
            }
        }

        /// <summary>
        /// Preprocesses the SQL script.
        /// </summary>
        /// <param name="query">The query.</param>
        /// <returns></returns>
        private static string PreprocessSqlScript( string query, PmxDbConnection conn )
        {
            string serverType;
            switch ( conn.ConnectionStringObject.ServerType )
            {
                case SboServerType.HANA:
                    serverType = "HANA";
					query = query.Replace("{DB-SCHEMA}", "\"" + conn.ConnectionStringObject.CompanyDBSchema.SchemaName + "\"");                            
                    break;
                default:
                    serverType = "MSSQL";
                    break;
            }

            int mssqlBlockBegin = query.IndexOf( "--<?DB:" );
            while ( mssqlBlockBegin >= 0 )
            {
                int mssqlBlockEnd = query.IndexOf( "--?>", mssqlBlockBegin );
                if ( mssqlBlockEnd < 0 )
                {
                    break;
                }

                if ( query.Substring( mssqlBlockBegin + "--<?DB:".Length, serverType.Length ) == serverType )
                {
                    query = query.Substring( 0, mssqlBlockBegin )
                          + query.Substring( mssqlBlockBegin + "--<?DB:".Length + serverType.Length, mssqlBlockEnd - mssqlBlockBegin - "--<?DB:".Length - serverType.Length )
                          + query.Substring( mssqlBlockEnd + "--?>".Length );
                    mssqlBlockEnd -= "--<?DB:".Length + serverType.Length + "--?>".Length;
                }
                else
                {
                    query = query.Substring( 0, mssqlBlockBegin ) + query.Substring( mssqlBlockEnd + "--?>".Length );
                    mssqlBlockEnd = mssqlBlockBegin;
                }
                mssqlBlockBegin = query.IndexOf( "--<?DB:", mssqlBlockEnd );
            }

            if ( conn.ConnectionStringObject.ServerType == SboServerType.HANA )
            {
                int tokenPos = query.IndexOf( "ISNULL(", StringComparison.OrdinalIgnoreCase );
                while ( tokenPos >= 0 )
                {
                    int endPos = tokenPos + "ISNULL(".Length;
                    query = query.Substring( 0, tokenPos ) + "IFNULL(" + query.Substring( endPos );
                    tokenPos = query.IndexOf( "ISNULL(", endPos, StringComparison.OrdinalIgnoreCase );
                }

                tokenPos = query.IndexOf( "@" );
                while ( tokenPos >= 0 )
                {
                    if ( query[tokenPos - 1] != '"' && Char.IsLetter( query[tokenPos + 1] ) )
                    {
                        query = query.Substring( 0, tokenPos ) + "p_" + query.Substring( tokenPos + 1 );
                    }
                    tokenPos = query.IndexOf( "@", tokenPos + 2 );
                }
            }

            return query;
        }
    }
}
