DROP PROCEDURE "PMX_SP_GetOpenSalesOrdersWithStockStatusInTmp";
CREATE PROCEDURE "PMX_SP_GetOpenSalesOrdersWithStockStatusInTmp"()
LANGUAGE SQLSCRIPT AS
BEGIN

    DECLARE CURSOR cur FOR 
    SELECT DISTINCT tbl."ObjType", tbl."DocEntry", tbl."ItemCardCodes", tbl."ZoneTypes"
     FROM TMP_GOSOWSS_1 tbl
     LEFT  JOIN RDR1 ON tbl."ObjType" = '17' AND tbl."DocEntry" = RDR1."DocEntry"
     LEFT  JOIN INV1 ON tbl."ObjType" = '13' AND tbl."DocEntry" = INV1."DocEntry"
     INNER JOIN OITM ON OITM."ItemCode" = RDR1."ItemCode" OR OITM."ItemCode" = INV1."ItemCode"
     LEFT  JOIN ( 
        PMX_ITZT
        INNER JOIN PMX_ZOTY ON PMX_ZOTY."Code" = PMX_ITZT."ZoneTypeCode"
     ) ON PMX_ITZT."ItemCode" = OITM."ItemCode"
     ORDER BY tbl."ObjType", tbl."DocEntry", tbl."ItemCardCodes", tbl."ZoneTypes";

    DECLARE v_ObjType       NVARCHAR(20);
    DECLARE v_DocEntry      INT;
    DECLARE v_ItemCardCodes NVARCHAR(4000);
    DECLARE v_ZoneTypes     NVARCHAR(4000);

    DECLARE v_curObjType      NVARCHAR(20);
    DECLARE v_curDocEntry     INT;
    DECLARE v_curItemCardCode NVARCHAR(15);
    DECLARE v_curZoneType     NVARCHAR(100);


	DELETE FROM TMP_GOSOWSS_1;


    -- * OINV * (only reserve invoices)
	INSERT INTO TMP_GOSOWSS_1
	SELECT OINV."ObjType", OINV."DocEntry", OINV."DocNum", OINV."DocDueDate", OINV."CardCode", OINV."CardName", 
		OINV."Address2" AS "ShipToAddress", OINV."ShipToCode", OSHP."TrnspName" AS "ShippingType", NULL AS "ItemCardCodes", OINV."NumAtCard", NULL AS "ZoneTypes", 
		tmp."PmxWhsCode", tmp."StockStatus", tmp."BlockingItemCode",
	    SUM(INV1."Quantity") AS "TotalQuantity",
		COUNT(DISTINCT INV1."ItemCode") AS "UniqueItems",
		SUM(PMX_OITM_MEASUREMENTS."SVolume" * OLGT."SizeInMM" * OLGT."SizeInMM" * OLGT."SizeInMM" * 1E-9 * INV1."Quantity") AS "TotalVolume",
		SUM(PMX_OITM_MEASUREMENTS."SWeight1" * OWGT."WightInMG" * 1E-6 * INV1."Quantity") AS "TotalWeight",
		SUM(INV1."LineTotal") AS "TotalPrice",
	    SUM(INV1."OpenQty") AS "OpenQuantity",
		SUM(PMX_OITM_MEASUREMENTS."SVolume" * OLGT."SizeInMM" * OLGT."SizeInMM" * OLGT."SizeInMM" * 1E-9 * INV1."OpenQty") AS "OpenVolume",
		SUM(PMX_OITM_MEASUREMENTS."SWeight1" * OWGT."WightInMG" * 1E-6 * INV1."OpenQty") AS "OpenWeight",
		SUM(INV1."LineTotal" * INV1."OpenQty" / INV1."Quantity") AS "OpenQuantity"
	FROM         OINV 
	INNER JOIN INV1 ON INV1."DocEntry" = OINV."DocEntry"
	INNER JOIN "OITM" ON "OITM"."ItemCode" = "INV1"."ItemCode"
	INNER JOIN PMX_OSWH ON PMX_OSWH."SboWhsCode" = INV1."WhsCode"
	INNER JOIN	(
		SELECT     inv."DocEntry", inv."PmxWhsCode", 
			-- StockStatus : 1) NOK: not enough stock and no partial allowed
			--               0) OK : enough stock or partial allowed
			--              -1) NOK: no stock at all
			MAX( CASE 
				WHEN IFNULL(inv_Quantity, 0) - IFNULL(locked."Quantity", 0) < inv."OpenQty" AND (inv."PartSupply" = 'N') THEN 1
				WHEN IFNULL(inv_Quantity, 0) - IFNULL(locked."Quantity", 0) > 0 THEN 0 
				ELSE - 1 END ) AS "StockStatus", 
			-- BlockingItemCode : the first itemcode (alpha sorted) with insufficient stock
			MIN( CASE 
				WHEN IFNULL(inv_Quantity, 0) - IFNULL(locked."Quantity", 0) < inv."OpenQty" AND (inv."PartSupply" = 'N') THEN inv."ItemCode" 
				WHEN IFNULL(inv_Quantity, 0) - IFNULL(locked."Quantity", 0) > 0 THEN NULL 
				ELSE inv."ItemCode" END ) AS "BlockingItemCode"
		FROM (        
			-- Get all open order lines with open quantity ("OpenQty") and get shippable inventory quantity (inv_Quantity)
			SELECT  OINV_a."DocEntry", OINV_a."PartSupply", INV1_a."ItemCode", MIN(INV1_a."BackOrdr") AS "BackOrdr", 
					SUM(INV1_a."OpenQty" - IFNULL(PMX_DOLL."LockedQuantity", 0)) / IFNULL(NULLIF (COUNT(DISTINCT PMX_INVT."InternalKey"), 0), 1) AS "OpenQty",
					SUM(PMX_INVT."Quantity") / COUNT(DISTINCT INV1_a."LineNum") AS inv_Quantity,
					PMX_OSWH."Code" AS "PmxWhsCode"
			FROM       OINV AS OINV_a
			INNER JOIN OCRD ON OCRD."CardCode" = OINV_a."CardCode"
			INNER JOIN INV1 AS INV1_a ON INV1_a."DocEntry" = OINV_a."DocEntry"
			INNER JOIN OITM ON OITM."ItemCode" = INV1_a."ItemCode"
			INNER JOIN PMX_OSWH ON INV1_a."WhsCode" = PMX_OSWH."SboWhsCode"
			LEFT JOIN (
			    SELECT PMX_INVT.*,  PMX_OSEL."PmxWhsCode" FROM PMX_INVT 
				INNER JOIN PMX_OSEL ON PMX_OSEL."Code" = PMX_INVT."StorLocCode"
				WHERE PMX_INVT."QualityStatusCode" IN ( SELECT "Code" FROM PMX_QYST WHERE "CanBeShipped" = 'Y' )
				  AND PMX_INVT."StorLocCode" NOT IN ( SELECT "Code" FROM PMX_DISALLOWED_LOCATIONS_FOR_PICKING WHERE "Code" IS NOT NULL )
			) PMX_INVT ON PMX_INVT."ItemCode" = INV1_a."ItemCode"
			          AND PMX_OSWH."Code" = PMX_INVT."PmxWhsCode"

			LEFT JOIN  PMX_DOLL ON INV1_a."ObjType" = PMX_DOLL."ObjType" AND INV1_a."DocEntry" = PMX_DOLL."DocEntry" AND INV1_a."LineNum" = PMX_DOLL."LineNum"
			WHERE    OINV_a."InvntSttus" = 'O' AND OINV_a."Confirmed" = 'Y' AND INV1_a."InvntSttus" = 'O' AND INV1_a."BaseType" = '17' AND OITM."InvntItem" = 'Y'
			AND NOT ( OCRD."validFor"  = 'Y' AND ( ( OCRD."validFrom"  IS NOT NULL AND CURRENT_TIMESTAMP <  OCRD."validFrom"  ) OR  ( OCRD."validTo"  IS NOT NULL AND CURRENT_TIMESTAMP >= ADD_DAYS( OCRD."validTo" , 1 ) ) ) )
			AND NOT ( OCRD."frozenFor" = 'Y' AND (   OCRD."frozenFrom" IS NULL     OR  CURRENT_TIMESTAMP >= OCRD."frozenFrom" ) AND ( OCRD."frozenTo" IS NULL     OR  CURRENT_TIMESTAMP <  ADD_DAYS( OCRD."frozenTo", 1 ) ) )
			GROUP BY OINV_a."DocEntry", OINV_a."PartSupply", INV1_a."ItemCode", PMX_OSWH."Code"
		) AS inv 
		LEFT JOIN (
			-- Get all already locked item quantities
			SELECT DISTINCT INV1_b."DocEntry", INV1_b."ItemCode", locked_b."PmxWhsCode", SUM(locked_b."Quantity") AS "Quantity"
			FROM       OINV AS OINV_b
			INNER JOIN INV1 AS INV1_b ON INV1_b."DocEntry" = OINV_b."DocEntry"
			LEFT JOIN (
				SELECT   "ItemCode", "CardCode", "PmxWhsCode", SUM("Quantity") AS "Quantity"
				FROM	PMX_INLD
				GROUP BY "ItemCode", "CardCode", "PmxWhsCode"
			) AS locked_b ON locked_b."ItemCode" = INV1_b."ItemCode" AND ( locked_b."CardCode" <> OINV_b."CardCode" OR locked_b."CardCode" IS NULL )
			WHERE OINV_b."InvntSttus" = 'O' AND OINV_b."Confirmed" = 'Y' AND INV1_b."InvntSttus" = 'O' AND INV1_b."BaseType" = '17'
			GROUP BY INV1_b."DocEntry", INV1_b."ItemCode", locked_b."PmxWhsCode", INV1_b."LineNum"
		) AS locked ON locked."DocEntry" = inv."DocEntry" AND locked."ItemCode" = inv."ItemCode" AND locked."PmxWhsCode" = inv."PmxWhsCode"
		WHERE inv."OpenQty" > 0
		GROUP BY inv."DocEntry", inv."PmxWhsCode"
	) AS tmp ON tmp."DocEntry" = OINV."DocEntry" 
	AND PMX_OSWH."Code" = tmp."PmxWhsCode"
	LEFT JOIN OSHP ON OINV."TrnspCode" = OSHP."TrnspCode"
	LEFT JOIN PMX_OITM_MEASUREMENTS ON PMX_OITM_MEASUREMENTS."ItemCode" = OITM."ItemCode" AND INV1."UomEntry" = PMX_OITM_MEASUREMENTS."UomEntry"
	LEFT JOIN OLGT ON OLGT."UnitCode" = PMX_OITM_MEASUREMENTS."SVolUnit"
	LEFT JOIN OWGT ON OWGT."UnitCode" = PMX_OITM_MEASUREMENTS."SWght1Unit"
	WHERE OINV."isIns" = 'Y'
	GROUP BY  OINV."ObjType", OINV."DocEntry", OINV."DocNum",OINV."DocDueDate", OINV."CardCode", OINV."CardName", OINV."Address2", OINV."ShipToCode", OSHP."TrnspName", OINV."NumAtCard", tmp."PmxWhsCode", tmp."StockStatus", tmp."BlockingItemCode";

	INSERT INTO TMP_GOSOWSS_1
	SELECT ORDR."ObjType", ORDR."DocEntry", ORDR."DocNum", ORDR."DocDueDate", ORDR."CardCode", ORDR."CardName", 
		ORDR."Address2" AS ShipToAddress, ORDR."ShipToCode", OSHP."TrnspName" AS ShippingType, NULL AS ItemCardCode, ORDR."NumAtCard", NULL AS ZoneTypes, 
		"tblOrdersPerWhs"."PmxWhsCode",
		CASE WHEN SUM( CASE "Whs_StockStatus" WHEN 0 THEN 1 ELSE NULL END ) OVER ( PARTITION BY ORDR."ObjType", ORDR."DocEntry" ) > 0 AND ORDR."PartSupply" = 'Y' THEN 0
		     WHEN MIN( "Whs_StockStatus" ) OVER ( PARTITION BY ORDR."ObjType", ORDR."DocEntry" ) < 0 THEN -1
		  	 WHEN MAX( "Whs_StockStatus" ) OVER ( PARTITION BY ORDR."ObjType", ORDR."DocEntry" ) > 0 THEN  1
			 ELSE 0 END AS "StockStatus", 
		MIN("Whs_BlockingItemCode") OVER ( PARTITION BY ORDR."ObjType", ORDR."DocEntry" ) AS "BlockingItemCode",
		SUM(RDR1."Quantity") AS "TotalQuantity",
		COUNT(DISTINCT RDR1."ItemCode") AS "UniqueItems",
		SUM(PMX_OITM_MEASUREMENTS."SVolume" * OLGT."SizeInMM" * OLGT."SizeInMM" * OLGT."SizeInMM" * 1E-9 * RDR1."Quantity") AS "TotalVolume",
		SUM(PMX_OITM_MEASUREMENTS."SWeight1" * OWGT."WightInMG" * 1E-6 * RDR1."Quantity" ) AS "TotalWeight",
		SUM(RDR1."LineTotal") AS "TotalPrice",
		SUM(RDR1."OpenQty") AS "OpenQuantity",
		SUM(PMX_OITM_MEASUREMENTS."SVolume" * OLGT."SizeInMM" * OLGT."SizeInMM" * OLGT."SizeInMM" * 1E-9 * RDR1."OpenQty") AS "OpenVolume",
		SUM(PMX_OITM_MEASUREMENTS."SWeight1" * OWGT."WightInMG" * 1E-6 * RDR1."OpenQty" ) AS "OpenWeight",
		SUM(RDR1."LineTotal" * RDR1."OpenQty" / RDR1."Quantity") AS "OpenPrice"
	FROM       ORDR 
	INNER JOIN RDR1 ON RDR1."DocEntry" = ORDR."DocEntry"
	INNER JOIN PMX_OSWH ON PMX_OSWH."SboWhsCode" = RDR1."WhsCode"
	INNER JOIN (
		SELECT     inv."DocEntry", inv."PmxWhsCode", 
			-- StockStatus : 1) NOK: not enough stock and no partial allowed
			--               0) OK : enough stock or partial allowed
			--              -1) NOK: no stock at all
			MAX( CASE 
				WHEN IFNULL(inv_Quantity, 0) - IFNULL(locked."Quantity", 0) < inv."OpenQty" AND (inv."PartSupply" = 'N') THEN 1
				WHEN IFNULL(inv_Quantity, 0) - IFNULL(locked."Quantity", 0) > 0 THEN 0 
				ELSE -1 END ) AS "Whs_StockStatus", 
			-- BlockingItemCode : the first itemcode (alpha sorted) with insufficient stock
			MIN( CASE 
				WHEN IFNULL(inv_Quantity, 0) - IFNULL(locked."Quantity", 0) < inv."OpenQty" AND (inv."PartSupply" = 'N') THEN inv."ItemCode" 
				WHEN IFNULL(inv_Quantity, 0) - IFNULL(locked."Quantity", 0) > 0 THEN NULL 
				ELSE inv."ItemCode" END ) AS "Whs_BlockingItemCode"
		FROM (        
			-- Get all open order lines with open quantity ("OpenQty") and get shippable inventory quantity (inv_Quantity)
			SELECT  ORDR_a."DocEntry", ORDR_a."PartSupply", RDR1_a."ItemCode", MIN(RDR1_a."BackOrdr") AS "BackOrdr", 
					SUM(RDR1_a."OpenQty" - IFNULL(PMX_DOLL."LockedQuantity", 0)) / IFNULL(NULLIF (COUNT(DISTINCT PMX_INVT."InternalKey"), 0), 1) AS "OpenQty",
					SUM(PMX_INVT."Quantity") / COUNT(DISTINCT RDR1_a."LineNum") AS inv_Quantity,
					PMX_OSWH."Code" AS "PmxWhsCode"
			FROM       ORDR AS ORDR_a
			INNER JOIN OCRD ON OCRD."CardCode" = ORDR_a."CardCode"
			INNER JOIN RDR1 AS RDR1_a ON RDR1_a."DocEntry" = ORDR_a."DocEntry"
			INNER JOIN OITM ON OITM."ItemCode" = RDR1_a."ItemCode" 
			INNER JOIN PMX_OSWH ON RDR1_a."WhsCode" = PMX_OSWH."SboWhsCode"
			LEFT  JOIN (
			    SELECT PMX_INVT.*,  PMX_OSEL."PmxWhsCode" FROM PMX_INVT 
				INNER JOIN PMX_OSEL ON PMX_OSEL."Code" = PMX_INVT."StorLocCode"
				WHERE PMX_INVT."QualityStatusCode" IN ( SELECT "Code" FROM PMX_QYST WHERE "CanBeShipped" = 'Y' )
				  AND PMX_INVT."StorLocCode" NOT IN ( SELECT "Code" FROM PMX_DISALLOWED_LOCATIONS_FOR_PICKING WHERE "Code" IS NOT NULL )
			) PMX_INVT ON PMX_INVT."ItemCode" = RDR1_a."ItemCode"
			          AND PMX_OSWH."Code" = PMX_INVT."PmxWhsCode"
			LEFT  JOIN PMX_DOLL ON RDR1_a."ObjType" = PMX_DOLL."ObjType"
			                   AND RDR1_a."DocEntry" = PMX_DOLL."DocEntry" 
                               AND RDR1_a."LineNum" = PMX_DOLL."LineNum"
			WHERE    ORDR_a."DocStatus" = 'O' AND ORDR_a."Confirmed" = 'Y' AND RDR1_a."LineStatus" = 'O' AND OITM."InvntItem" = 'Y'
			AND NOT ( OCRD."validFor"  = 'Y' AND ( ( OCRD."validFrom"  IS NOT NULL AND CURRENT_TIMESTAMP <  OCRD."validFrom"  ) OR  ( OCRD."validTo"  IS NOT NULL AND CURRENT_TIMESTAMP >= ADD_DAYS( OCRD."validTo" , 1 ) ) ) )
			AND NOT ( OCRD."frozenFor" = 'Y' AND (   OCRD."frozenFrom" IS NULL     OR  CURRENT_TIMESTAMP >= OCRD."frozenFrom" ) AND ( OCRD."frozenTo" IS NULL     OR  CURRENT_TIMESTAMP <  ADD_DAYS( OCRD."frozenTo", 1 ) ) )
			GROUP BY ORDR_a."DocEntry", ORDR_a."PartSupply", RDR1_a."ItemCode", PMX_OSWH."Code"
		) AS inv 
		LEFT JOIN (
			-- Get all already locked item quantities
			SELECT DISTINCT RDR1_b."DocEntry", RDR1_b."ItemCode", locked_b."PmxWhsCode", SUM(locked_b."Quantity") AS "Quantity"
			FROM       ORDR AS ORDR_b
			INNER JOIN RDR1 AS RDR1_b ON RDR1_b."DocEntry" = ORDR_b."DocEntry"
			LEFT JOIN (
				SELECT   "ItemCode", "CardCode", "PmxWhsCode", SUM("Quantity") AS "Quantity"
				FROM	PMX_INLD
				GROUP BY "ItemCode", "CardCode", "PmxWhsCode"
			) AS locked_b ON locked_b."ItemCode" = RDR1_b."ItemCode" AND ( locked_b."CardCode" <> ORDR_b."CardCode" OR locked_b."CardCode" IS NULL )
			WHERE ORDR_b."DocStatus" = 'O' AND ORDR_b."Confirmed" = 'Y' AND RDR1_b."LineStatus" = 'O'
			GROUP BY RDR1_b."DocEntry", RDR1_b."ItemCode", locked_b."PmxWhsCode", RDR1_b."ItemCode"
		) AS locked ON locked."DocEntry" = inv."DocEntry" AND locked."ItemCode" = inv."ItemCode" AND locked."PmxWhsCode" = inv."PmxWhsCode"
		WHERE inv."OpenQty" > 0
		GROUP BY inv."DocEntry", inv."PmxWhsCode"
	) AS "tblOrdersPerWhs"
		ON "tblOrdersPerWhs"."DocEntry" = ORDR."DocEntry" AND "tblOrdersPerWhs"."PmxWhsCode" = PMX_OSWH."Code"
	INNER JOIN OITM ON OITM."ItemCode" = RDR1."ItemCode"
	LEFT JOIN OSHP ON ORDR."TrnspCode" = OSHP."TrnspCode"
	LEFT JOIN PMX_OITM_MEASUREMENTS ON PMX_OITM_MEASUREMENTS."ItemCode" = OITM."ItemCode" AND RDR1."UomEntry" = PMX_OITM_MEASUREMENTS."UomEntry"
	LEFT JOIN OLGT ON OLGT."UnitCode" = PMX_OITM_MEASUREMENTS."SVolUnit"
	LEFT JOIN OWGT ON OWGT."UnitCode" = PMX_OITM_MEASUREMENTS."SWght1Unit"
	GROUP BY ORDR."ObjType", ORDR."DocEntry", ORDR."DocNum",ORDR."DocDueDate", ORDR."CardCode",ORDR."CardName", ORDR."Address2", ORDR."ShipToCode", OSHP."TrnspName", ORDR."NumAtCard", "tblOrdersPerWhs"."PmxWhsCode", "tblOrdersPerWhs"."Whs_StockStatus", ORDR."PartSupply", "tblOrdersPerWhs"."Whs_BlockingItemCode";

    -- * Update ItemCardCode and ZoneTypes *
    OPEN cur;
    FETCH cur INTO v_curObjType, v_curDocEntry, v_curItemCardCode, v_curZoneType;
	WHILE NOT cur::NOTFOUND  DO

       IF v_curObjType = v_ObjType AND v_curDocEntry = v_DocEntry THEN
          IF LOCATE( v_ItemCardCodes, ' | ' || IFNULL( v_curItemCardCode, '-' ) || ' | ' ) = 0 THEN v_ItemCardCodes := v_ItemCardCodes || IFNULL( v_curItemCardCode, '-' ) || ' | '; END IF;
          IF LOCATE( v_ZoneTypes    , ' | ' || IFNULL( v_curZoneType    , '-' ) || ' | ' ) = 0 THEN v_ZoneTypes     := v_ZoneTypes     || IFNULL( v_curZoneType    , '-' ) || ' | '; END IF;
       ELSE 
          -- Begin WEG customization for multiple shipping dates in documents
          IF NOT v_DocEntry IS NULL THEN
             UPDATE TMP_GOSOWSS_1 SET "ZoneTypes" = SUBSTRING( v_ZoneTypes, 4, LENGTH( v_ZoneTypes ) - 5 ) 
             WHERE "ObjType" = v_ObjType AND "DocEntry" = v_DocEntry;
          END IF;
          
          UPDATE TMP_GOSOWSS_1 SET "ItemCardCodes" = CASE WHEN (SELECT COUNT(DISTINCT RDR1."ShipDate") FROM RDR1 WHERE RDR1."DocEntry" = v_curDocEntry) > 1 THEN 'Y' ELSE NULL END
          WHERE "ObjType" = v_curObjType AND "DocEntry" = v_curDocEntry;
          -- End WEG customization for multiple shipping dates in documents

          v_ObjType       := v_curObjType;
          v_DocEntry      := v_curDocEntry;
          v_ItemCardCodes := ' | ' || IFNULL( v_curItemCardCode, '-' ) || ' | ';
          v_ZoneTypes     := ' | ' || IFNULL( v_curZoneType    , '-' ) || ' | ';
       END IF;
       
       FETCH cur INTO v_curObjType, v_curDocEntry, v_curItemCardCode, v_curZoneType;
	END WHILE;
    CLOSE cur;

    --IF NOT v_DocEntry IS NULL THEN
    --   UPDATE TMP_GOSOWSS_1 SET "ItemCardCodes" = SUBSTRING( v_ItemCardCodes, 4, LENGTH( v_ItemCardCodes ) - 5 ), "ZoneTypes" = SUBSTRING( v_ZoneTypes, 4, LENGTH( v_ZoneTypes ) - 5 ) 
    --   WHERE "ObjType" = v_ObjType AND "DocEntry" = v_DocEntry;
    --END IF;
    
    --Adjust length of the calculated values, to avoid problems in SAP
    UPDATE TMP_GOSOWSS_1 SET "ItemCardCodes" = CAST("ItemCardCodes" AS nvarchar(254)), "ZoneTypes" = CAST("ZoneTypes" AS nvarchar(254));


END
