-- =============================================
-- Author:        Produmex
-- Description:    Goods Receipt Label
-- =============================================
CREATE PROCEDURE "PMX_SP_GoodsReceiptLabelWeg" (
    IN p_luid int,
    IN p_sscc nvarchar(18),
    IN p_ItemCode nvarchar(20),
    IN p_Quantity numeric(19,6),
    IN p_BestBeforeDate datetime,
    IN p_BatchNumber nvarchar(32),
    IN p_purchaseDocObjType nvarchar(20),
    IN p_purchaseDocEntry int,
    IN p_cardCode nvarchar(15),
    IN p_packagingTypeText nclob,
    IN p_quantityByPackagingTypeText nclob,
    IN p_locationCode nvarchar(50),
    IN p_batchNumber2 nvarchar(32),
    IN p_quantityUom2 numeric (19,6),
    IN p_internalLuid int
) LANGUAGE SQLSCRIPT
AS
BEGIN

    --Declare return variables
    DECLARE v_returnSSCC nvarchar(18);
    DECLARE v_returnGTIN nvarchar (16); 
    DECLARE v_returnLogisticCarrierCode nvarchar(20);
    DECLARE v_returnItemCode nvarchar(20); 
    DECLARE v_returnProductDescription nvarchar(100); 
    DECLARE v_returnQuantity numeric(19,6); 
    DECLARE v_returnIsLogisticCarrier nvarchar(1); 
    DECLARE v_returnBatchNumber nvarchar(32); 
    DECLARE v_returnBestBeforeDate datetime;
    DECLARE v_returnSSCCBarcode nvarchar (100);
    DECLARE v_returnSSCCBarcodeDigit nvarchar (100);
    DECLARE v_returnGTINBarcode nvarchar (200);
    DECLARE v_returnGTINBarcodeDigit nvarchar (200);
    DECLARE v_returnBarcodeType nvarchar (1);
    DECLARE v_returnGTINLabel nvarchar (20);
    DECLARE v_returnPackagingTypeText nclob;
    DECLARE v_returnQuantityByPackagingTypeText nclob;
    DECLARE v_returnBatchNumber2 nvarchar(32); 
    DECLARE v_returnLocationCode nvarchar(50); 

    --Getting the PO info
    --Declare variables for the cursor
    DECLARE v_PurchaseDocNum int;
    DECLARE v_SupplierName nvarchar(100); 
    DECLARE v_SupplierAddress nvarchar(254);  
    DECLARE v_ReceptionDate datetime;

    --Declare variables for product
    DECLARE v_GTIN nvarchar(16); 
    DECLARE v_LogisticCarrierCode nvarchar (20);  
    DECLARE v_ProductDescription nvarchar(100); 
    DECLARE v_IsLogisticCarrier nvarchar(1); 
    DECLARE v_BarcodeType nvarchar(1);
    DECLARE v_TempPackagingTypeText nclob;
    DECLARE v_TempQuantityByPackagingTypeText nclob;
    
    DECLARE v_WeightDecimals int;
	DECLARE v_WeightAI nvarchar(3);
	DECLARE v_TempWeightDecimals int;
	DECLARE v_TempWeightAI nvarchar (3); 
	DECLARE v_TempQuantityUom2 numeric(19,6); 

	--Other variables
	DECLARE v_cnt int;
    DECLARE v_quantityUom2 numeric (19,6); 
    DECLARE v_itriKey int;
    
	v_quantityUom2 := p_quantityUom2;

	--Empty temporary table
	DELETE FROM "WUK_4004_PMX"."TMP_TN_ProductsOnSSCC";

    IF p_luid > 0 THEN
    
        DECLARE CURSOR productsCursor FOR
        SELECT SSCC, GTIN, LogisticCarrierCode, ItemCode, ProductDescription, Quantity , IsLogisticCarrier, BatchNumber,
            BestBeforeDate, BarcodeType, PackagingTypesText, QuantityByPackagingTypeText, BatchNumber2, LocationCode, ItriKey, 
            QuantityUom2, Uom2Decimals,	Uom2AI
        FROM "WUK_4004_PMX"."TMP_TN_ProductsOnSSCC" ORDER BY IsLogisticCarrier, ItemCode;
        
        DECLARE v_packagingTypesText nvarchar(4000);
        DECLARE v_quantityByPackagingTypeText nvarchar(4000);
    
        -- Insert the products into an in memory table
        INSERT INTO "WUK_4004_PMX"."TMP_TN_ProductsOnSSCC"
        SELECT SSCC, Barcode, "LogisticCarrierCode", "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."ItemCode",
            IFNULL( ProductDescription, "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."ItemCode" ) AS ProductDescription,
            "Quantity",
            IsLogisticCarrier,
            "BatchNumber",
            "BestBeforeDate",
            IFNULL(U_PMX_BCTY,'G') AS BarcodeType,
            NULL,  -- PackagingTypesText
            NULL,  -- QuantityByPackagingTypeText
            "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."InternalBatchNumber",
            "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."StorLocCode",
            "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."ItemTransactionalInfoKey",
            "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."QuantityUom2", 
            U_PMX_UM2D, 
            U_PMX_U2MT||'0'    
        FROM "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL
        INNER JOIN OITM ON OITM."ItemCode" = "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."ItemCode"
        WHERE "LogUnitIdentKey" = p_luid
        ORDER BY IsLogisticCarrier, "ItemCode";

        --Loop through all lines
                
        FOR curRow AS productsCursor DO

			v_itriKey := IFNULL(curRow.ItriKey, -1);
        
            "WUK_4004_PMX"."PMX_SP_GetPackagingTypesText"( curRow.ItemCode, v_itriKey, curRow.Quantity, 'B', v_packagingTypesText );
            "WUK_4004_PMX"."PMX_SP_GetQuantityByPackagingTypesText"( curRow.ItemCode, v_itriKey, v_quantityByPackagingTypeText );

            IF v_returnItemCode IS NULL THEN
                 v_returnSSCC := curRow.SSCC;
                 v_returnGTIN := curRow.GTIN;
                 v_returnLogisticCarrierCode := curRow.LogisticCarrierCode;
                 v_returnItemCode := curRow.ItemCode;
                 v_returnProductDescription := curRow.ProductDescription;
                 v_returnQuantity := curRow.Quantity;
                 v_returnIsLogisticCarrier := curRow.IsLogisticCarrier;
                 v_returnBatchNumber := curRow.BatchNumber;
                 v_returnBestBeforeDate := curRow.BestBeforeDate;
                 v_returnBarcodeType := curRow.BarcodeType;
                 v_returnPackagingTypeText := v_TempPackagingTypeText;
                 v_returnQuantityByPackagingTypeText := v_TempQuantityByPackagingTypeText;
                 v_returnLocationCode := curRow.locationCode;
                 v_tempWeightAI := curRow.Uom2AI;
				 v_tempWeightDecimals := curRow.Uom2Decimals;
				 v_quantityUom2 := curRow.QuantityUom2;
            END IF;
            
            --Only when the previous product is the same as product, 
            --or if the current product is a logistic carrier and the Quantity of the logistic carrier is 1, we can keep the product description, count and gtin.
            --In all other cases, we need to remove the product and count
            IF v_returnItemCode = curRow.ItemCode OR ( curRow.ItemCode = v_LogisticCarrierCode AND curRow.Quantity = 1 ) THEN

                --Only when the current product is a logistic carrier and 
                --the Quantity of the logistic carrier is 1, we can keep the product batch and best before date.
                --In all other cases, we need to remove the product
                IF curRow.ItemCode <> v_LogisticCarrierCode OR curRow.Quantity <> 1 THEN
                    IF curRow.BatchNumber <> v_returnBatchNumber THEN
                        v_returnBatchNumber := NULL;
                    END IF;
                    IF curRow.BestBeforeDate <> v_returnBestBeforeDate THEN
                        v_returnBestBeforeDate := NULL;
                    END IF;
                END IF;
                
                IF v_returnQuantity IS NOT NULL THEN
                    --if we can add Quantity, we check if the product is the logistic carrier.
                    --if so, we add the new Quantity, but we deduct 1 from the Quantity because we don't count the logistic carrier
                    IF curRow.ItemCode = v_LogisticCarrierCode THEN
                        v_returnQuantity := v_returnQuantity + curRow.Quantity - 1;
                    ELSE 
                        v_returnQuantity := v_returnQuantity + curRow.Quantity;
                        v_quantityUom2 := v_quantityUom2 + v_tempQuantityUom2;
                    END IF;
                END IF;
            ELSE
                v_returnItemCode := NULL;
                v_returnGTIN := NULL;
                v_returnProductDescription := NULL;
                v_returnQuantity := NULL;
                v_returnBatchNumber := NULL;
                v_returnBestBeforeDate := NULL;
                v_returnBarcodeType := NULL;
                v_returnPackagingTypeText := NULL;
                v_returnQuantityByPackagingTypeText := NULL;
                v_returnBatchNumber2 := NULL;
                v_returnLocationCode := NULL;
                v_tempWeightAI := NULL;
				v_tempWeightDecimals := NULL;
				v_quantityUom2 := NULL;
            END IF;

        END FOR;

		IF v_returnBestBeforeDate IS NULL THEN v_returnBestBeforeDate := '1899-12-31'; END IF;
		IF v_returnQuantity IS NULL THEN v_returnQuantity := -1; END IF;
		IF v_quantityUom2 IS NULL THEN v_quantityUom2 := -1; END IF;
		IF v_tempWeightDecimals IS NULL THEN v_tempWeightDecimals := -1; END IF;

        --Set the barcodes
		SELECT barcode     INTO v_returnSSCCBarcode      FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1Barcode"      ( :v_returnSSCC, NULL, NULL, NULL, '1899-12-31', NULL, -1, -1, -1, NULL, 'Ê' );
		SELECT barcodeText INTO v_returnSSCCBarcodeDigit FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1BarcodeDigit" ( :v_returnSSCC, NULL, NULL, NULL, '1899-12-31', NULL, -1, -1, -1, NULL );
		SELECT barcode     INTO v_returnGTINBarcode      FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1Barcode"      ( NULL, :v_returnGTIN, :v_returnIsLogisticCarrier, :v_returnBarcodeType, :v_returnBestBeforeDate, :v_returnBatchNumber, :v_returnQuantity, :v_quantityUom2, :v_tempWeightDecimals, :v_tempWeightAI, 'Ê' );
		SELECT barcodeText INTO v_returnGTINBarcodeDigit FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1BarcodeDigit" ( NULL, :v_returnGTIN, :v_returnIsLogisticCarrier, :v_returnBarcodeType, :v_returnBestBeforeDate, :v_returnBatchNumber, :v_returnQuantity, :v_quantityUom2, :v_tempWeightDecimals, :v_tempWeightAI );

        IF v_returnIsLogisticCarrier = 'Y' THEN
            v_returnGTINLabel := 'GTIN';
        ELSE 
            v_returnGTINLabel := 'CONTENT';
        END IF;

		SELECT COUNT(1) INTO v_cnt
			FROM "WUK_4004_PMX".PMX_DELIVERY_INFO_LABEL
			WHERE "LogUnitIdentKey" = p_luid;
		IF v_cnt > 0 THEN
			SELECT TOP 1 PurchaseDocObjType,   PurchaseDocNum,   SupplierName,   SupplierAddress,   ReceptionDate
			INTO       p_PurchaseDocObjType, v_PurchaseDocNum, v_SupplierName, v_SupplierAddress, v_ReceptionDate
			FROM "WUK_4004_PMX".PMX_DELIVERY_INFO_LABEL
			WHERE "LogUnitIdentKey" = p_luid
			ORDER BY PurchaseDocNum DESC;
		END IF;

    ELSE

         v_returnSSCC := p_SSCC;
         v_returnItemCode := p_ItemCode;
         v_returnQuantity := p_Quantity;
         v_returnBatchNumber := p_BatchNumber;
         v_returnBestBeforeDate := p_BestBeforeDate;
         v_returnPackagingTypeText := p_PackagingTypeText;
         v_returnQuantityByPackagingTypeText := p_quantityByPackagingTypeText;
         v_returnBatchNumber2 := p_BatchNumber2;
         v_returnLocationCode := p_LocationCode;

         v_ReceptionDate := CURRENT_DATE;

        --Purchase info
        IF p_purchaseDocObjType = '22' THEN

			SELECT COUNT(1) INTO v_cnt
				FROM OPOR
				WHERE "DocEntry" = p_purchaseDocEntry;
			IF v_cnt > 0 THEN
		            SELECT TOP 1 "DocNum", "CardName", "Address"
		            INTO   v_PurchaseDocNum, v_SupplierName, v_SupplierAddress
		            FROM OPOR
		            WHERE "DocEntry" = p_purchaseDocEntry
		            ORDER BY "DocNum" DESC;
			END IF;

        ELSEIF p_purchaseDocObjType = '18' THEN

			SELECT COUNT(1) INTO v_cnt
				FROM OPCH
				WHERE "DocEntry" = p_purchaseDocEntry;
			IF v_cnt > 0 THEN
	            SELECT TOP 1 "DocNum", "CardName", "Address"
	            INTO   v_PurchaseDocNum, v_SupplierName, v_SupplierAddress
	            FROM OPCH
	            WHERE "DocEntry" = p_purchaseDocEntry
	            ORDER BY "DocNum" DESC;
			END IF;

        ELSE
        
			SELECT COUNT(1) INTO v_cnt
				FROM OCRD
				WHERE OCRD."CardCode" = p_cardCode;
			IF v_cnt > 0 THEN
	            SELECT TOP 1 "CardName"
	            INTO   v_SupplierName
	            FROM OCRD
	            WHERE OCRD."CardCode" = p_cardCode;
			END IF;
            
        END IF;

		SELECT COUNT(1) INTO v_cnt
			FROM OITM
			WHERE OITM."ItemCode" = p_ItemCode;
		IF v_cnt > 0 THEN
	        SELECT OITM.U_PMX_LOUN, IFNULL(U_PMX_BCTY,'G'), "CodeBars", "ItemName", "U_PMX_UM2D", "U_PMX_U2MT"||'0'
	        INTO   v_returnIsLogisticCarrier, v_returnBarcodeType, v_returnGTIN, v_returnProductDescription, v_tempWeightDecimals, v_tempWeightAI
	        FROM OITM
	        WHERE OITM."ItemCode" = p_ItemCode;
		END IF;

        IF v_returnIsLogisticCarrier = 'Y' THEN
            v_returnGTINLabel := 'GTIN';
        ELSE
            v_returnGTINLabel := 'CONTENT';
        END IF;

		IF v_returnBestBeforeDate IS NULL THEN v_returnBestBeforeDate := '1899-12-31'; END IF;
		IF v_returnQuantity IS NULL THEN v_returnQuantity := -1; END IF;
		IF v_quantityUom2 IS NULL THEN v_quantityUom2 := -1; END IF;
		IF v_tempWeightDecimals IS NULL THEN v_tempWeightDecimals := -1; END IF;

        --Set the barcodes
		SELECT barcode     INTO v_returnSSCCBarcode      FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1Barcode"      ( :v_returnSSCC, NULL, NULL, NULL, '1899-12-31', NULL, -1, -1, -1, NULL, 'Ê' );
		SELECT barcodeText INTO v_returnSSCCBarcodeDigit FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1BarcodeDigit" ( :v_returnSSCC, NULL, NULL, NULL, '1899-12-31', NULL, -1, -1, -1, NULL );
		SELECT barcode     INTO v_returnGTINBarcode      FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1Barcode"      ( NULL, :v_returnGTIN, :v_returnIsLogisticCarrier, :v_returnBarcodeType, :v_returnBestBeforeDate, :v_returnBatchNumber, :v_returnQuantity, :v_quantityUom2, :v_tempWeightDecimals, :v_tempWeightAI, 'Ê' );
		SELECT barcodeText INTO v_returnGTINBarcodeDigit FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1BarcodeDigit" ( NULL, :v_returnGTIN, :v_returnIsLogisticCarrier, :v_returnBarcodeType, :v_returnBestBeforeDate, :v_returnBatchNumber, :v_returnQuantity, :v_quantityUom2, :v_tempWeightDecimals, :v_tempWeightAI );

    END IF;

	-- Convert non-null values to null when necessary
	v_returnBatchNumber := NULLIF(v_returnBatchNumber, '');
	v_returnBatchNumber2 := NULLIF(v_returnBatchNumber2, '');
	IF YEAR(TO_DATE(v_returnBestBeforeDate)) < 1900 THEN v_returnBestBeforeDate := NULL; END IF;
	v_returnQuantity := NULLIF(v_returnQuantity, -1);

    --Return the values
    SELECT    v_returnSSCC AS SSCC,     
            IFNULL(v_returnGTIN,'N/A') AS GTIN,
            IFNULL(v_returnProductDescription,'N/A') AS ProductDescription, 
            IFNULL(CAST(CAST(v_returnQuantity AS REAL) AS nvarchar),'N/A') Quantity,
            IFNULL(v_returnBatchNumber,'N/A') AS BatchNumber, 
            IFNULL( TO_NVARCHAR(v_returnBestBeforeDate, 'DD/MM/YYYY'),'N/A')  AS BestBeforeDate,
            v_returnSSCCBarcode AS SSCCBarcode,
            v_returnSSCCBarcodeDigit AS SSCCBarcodeDigit,
            v_returnGTINBarcode AS GTINBarcode,
            v_returnGTINBarcodeDigit AS GTINBarcodeDigit,
            p_PurchaseDocObjType AS PurchaseDocObjType,
            IFNULL( CAST( v_PurchaseDocNum AS nvarchar ), 'N/A') AS PurchaseDocNum,
            IFNULL(v_SupplierName,'N/A') AS SupplierName,
            IFNULL(v_SupplierAddress,'N/A') AS SupplierAddress,
            IFNULL( TO_NVARCHAR(v_ReceptionDate, 'DD/MM/YYYY'), 'N/A') AS ReceptionDate,
            v_returnGTINLabel AS GTINLabel,
            v_returnPackagingTypeText AS PackagingTypeText,
            v_returnQuantityByPackagingTypeText AS QuantityByPackagingTypeText,
            v_returnBatchNumber2 AS BatchNumber2, 
            v_returnLocationCode AS LocationCode
    FROM dummy;

END;