CREATE PROCEDURE "PMX_SP_ItemLabelWeg" (
	p_itemCode nvarchar(20),
	p_batchNumber nvarchar(32),
	p_batchNumber2 nvarchar(32),
	p_serialNumber nvarchar(32),
	p_bestBeforeDate datetime,
	p_docType nvarchar(20),
	p_docEntry int,
	p_lineNum int,
	p_quantity numeric(19,6),
	p_uom nvarchar(20),
	p_weight numeric(19,6),
	p_weightUom nvarchar(20),
	p_packagingTypeCode nvarchar(20)
)
LANGUAGE SQLSCRIPT AS
BEGIN
	DECLARE p_batchNumber nvarchar(32);
	DECLARE p_batchNumber2 nvarchar(32);
	DECLARE p_uom nvarchar(20);

	--Declare return variables
	DECLARE v_returnItemCode nvarchar(20); 
	DECLARE v_returnProductDescription nvarchar(100); 
	DECLARE v_returnBatchNumber nvarchar(32); 
	DECLARE v_returnBatchNumber2 nvarchar(32); 
	DECLARE v_returnBestBeforeDate datetime;
	DECLARE v_returnGTIN nvarchar (16); 
	DECLARE v_returnGTINBarcode nvarchar (200);
	DECLARE v_returnGTINBarcodeDigit nvarchar (200);
	DECLARE v_returnGTINLabel nvarchar (20);
 	DECLARE v_returnBarcodeType nvarchar (1);
 	DECLARE v_returnIsLogisticCarrier nvarchar (1);
	DECLARE v_returnQuantity numeric(19,6);
	DECLARE v_returnUom nvarchar (20);
	DECLARE v_returnWeightUom nvarchar (20);
	DECLARE v_returnWeight numeric(19,6);

	DECLARE v_weightDecimals int;

	
	
	DECLARE v_returnManufacturingDate datetime;
	DECLARE v_returnCountryOfOrigin nvarchar (20);
	
	DECLARE v_returnVoicePickCode nvarchar (255);
	DECLARE v_returnCompanyName nvarchar (200);
	
	DECLARE v_weightAI nvarchar(3) ;

	-- WEG custom variables
	DECLARE v_cardCode nvarchar(15);
	DECLARE v_cardName nvarchar(100);
	DECLARE v_salesOrderDocNum int;
	DECLARE v_prodOrderDocNum int;
	DECLARE v_productionDate datetime;
	DECLARE v_dataMatrixCode nvarchar(4000);
	DECLARE v_prodOrderDocNumStr nvarchar(100);
	DECLARE v_productionDateStr nvarchar(20);

	
	DECLARE v_refDate datetime;
	v_refDate := CURRENT_TIMESTAMP;
	
BEGIN
    DECLARE v_error int;
    DECLARE EXIT HANDLER FOR SQL_ERROR_CODE 1299
    BEGIN
        v_error := 1299;
    END;

	SELECT PMX_ITRI."ManufacturingDate", PMX_ITRI."CountryOfOrigin" INTO v_returnManufacturingDate, v_returnCountryOfOrigin 
	FROM PMX_ITRI
	WHERE PMX_ITRI."ItemCode" = p_itemCode
	AND IFNULL(PMX_ITRI."BestBeforeDate", v_refDate) = IFNULL(p_bestBeforeDate, v_refDate)
	AND IFNULL(PMX_ITRI."BatchNumber", '') = IFNULL(p_batchNumber, '')
	AND IFNULL(PMX_ITRI."InternalBatchNumber", '') = IFNULL(p_batchNumber2, '');
END;	

BEGIN
	DECLARE CURSOR productsCursor FOR	SELECT "CodeBars", "ItemName", U_PMX_BCTY,  U_PMX_LOCA, U_PMX_UM2D, U_PMX_U2MT||'0'
										FROM OITM
										WHERE "ItemCode" = :p_itemCode;
	OPEN productsCursor;
	FETCH productsCursor INTO v_returnGTIN, v_returnProductDescription, v_returnBarcodeType, v_returnIsLogisticCarrier, v_weightDecimals, v_weightAI;
	IF v_returnProductDescription IS NOT NULL THEN
		v_returnItemCode := p_itemCode;
		v_returnBatchNumber := p_batchNumber;
		v_returnBatchNumber2 := p_batchNumber2;
		v_returnBestBeforeDate := p_bestBeforeDate;
		v_returnQuantity := p_quantity;
		v_returnUom := p_uom;
		v_returnWeightUom := p_weightUom;
		v_returnUom := p_uom;

	END IF;
	CLOSE productsCursor;
END;
	IF v_returnBestBeforeDate IS NULL THEN v_returnBestBeforeDate := '1899-12-31'; END IF;
	IF v_weightDecimals IS NULL THEN v_weightDecimals := 0; END IF;
	IF v_weightAI IS NULL THEN v_weightAI := 0; END IF;

	--Set the barcodes
	SELECT barcode     INTO v_returnGTINBarcode      FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1Barcode"      ( NULL, :v_returnGTIN, :v_returnIsLogisticCarrier, :v_returnBarcodeType, :v_returnBestBeforeDate, :v_returnBatchNumber, -1, :p_weight, :v_weightDecimals, :v_weightAI, 'Ê' );
	SELECT barcodeText INTO v_returnGTINBarcodeDigit FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1BarcodeDigit" ( NULL, :v_returnGTIN, :v_returnIsLogisticCarrier, :v_returnBarcodeType, :v_returnBestBeforeDate, :v_returnBatchNumber, -1, :p_weight, :v_weightDecimals, :v_weightAI );

    --IF v_returnIsLogisticCarrier = 'Y' THEN
        v_returnGTINLabel := 'GTIN';
    --ELSE 
    --    v_returnGTINLabel := 'CONTENT';
    --END IF;

	IF v_returnQuantity = 0 THEN v_returnUom := ''; END IF;
	
	--SELECT result INTO v_returnVoicePickCode  FROM "WUK_4004_PMX"."PMX_FN_CalculateVoicePickCode"( :v_returnGTIN, :v_returnBatchNumber, :v_returnBestBeforeDate );
	
	SELECT "CompnyName" INTO v_returnCompanyName FROM OADM;
	
	-- Convert non-null values to null when necessary
	v_returnBatchNumber := NULLIF(v_returnBatchNumber, '');
	v_returnBatchNumber2 := NULLIF(v_returnBatchNumber2, '');
	IF YEAR(TO_DATE(v_returnBestBeforeDate)) < 1900 THEN v_returnBestBeforeDate := NULL; END IF;
	v_returnQuantity := NULLIF(v_returnQuantity, -1);

	-- Set WEG custom variables
	IF (p_docType = '202') THEN
		SELECT OCRD."CardCode", OCRD."CardName", OWOR."OriginNum", OWOR."DocNum", OWOR."DueDate"
		INTO v_cardCode, v_cardName, v_salesOrderDocNum, v_prodOrderDocNum, v_productionDate
			FROM OWOR
			LEFT JOIN OCRD ON OCRD."CardCode" = OWOR."CardCode"
			WHERE OWOR."DocEntry" = p_docEntry;
	ELSE
		v_cardCode := NULL;
		v_cardName := NULL;
		v_salesOrderDocNum := NULL;
		v_prodOrderDocNum := NULL;
		v_productionDate := NULL;
	END IF;
	
	v_prodOrderDocNumStr := LTRIM(RTRIM(CAST(v_prodOrderDocNum AS NVARCHAR(30))));
	v_productionDateStr := TO_NVARCHAR(v_productionDate, 'YYYYMMDD');
	
	v_dataMatrixCode := '01' || IFNULL(v_returnGTIN, '')
		|| ' 21' || IFNULL(p_serialNumber, '')
		|| ' 10'
		|| ' 91' || IFNULL(v_prodOrderDocNumStr, '')
		|| ' 11' || IFNULL(v_productionDateStr, '')
		|| ' 240' || IFNULL(p_itemCode, '');

	--Return the values
	SELECT	IFNULL(v_returnGTIN,'N/A') AS GTIN,
			IFNULL(v_returnItemCode,'N/A') AS ProductCode, 
			IFNULL(v_returnProductDescription,'N/A') AS ProductDescription, 
			IFNULL(v_returnBatchNumber,'N/A') AS BatchNumber, 
			IFNULL(v_returnBatchNumber2,'N/A') AS BatchNumber2, 
			IFNULL(TO_NVARCHAR(v_returnBestBeforeDate, 'DD/MM/YYYY'),'N/A')  AS BestBeforeDate,
			v_returnQuantity AS Quantity,
			IFNULL( v_returnUom, '') AS Uom,
			v_returnGTINBarcode AS GTINBarcode,
			v_returnGTINBarcodeDigit AS GTINBarcodeDigit,
			v_returnGTINLabel AS GTINLabel,
			v_returnManufacturingDate AS ManufacturingDate,
			v_returnCountryOfOrigin AS CountryOfOrigin,
			v_returnCompanyName AS CompanyName,			
			LEFT(v_returnVoicePickCode, 2) as VoicePickCode1,
			RIGHT(v_returnVoicePickCode, 2) as VoicePickCode2,
			v_returnWeight AS Weight,
			IFNULL( v_returnWeightUom, '') AS WeightUom,
			IFNULL( p_packagingTypeCode, '') AS PackagingTypeCode,
			p_serialNumber as SerialNumber,
			v_cardCode as CardCode,
			v_cardName as CardName,
			v_salesOrderDocNum as SalesOrderDocNum,
			v_prodOrderDocNum as ProdOrderDocNum,
			v_productionDate as ProductionDate,
			v_dataMatrixCode as DataMatrixCode
	FROM dummy;
	
END