CREATE PROCEDURE "PMX_SP_PickListDocumentWeg"
(
	p_pickListDocEntry int
	
) LANGUAGE SQLSCRIPT
AS
BEGIN

	declare v_glossarySeparator nvarchar(4000);
	declare v_lineNum int;
	declare v_text nvarchar(4000);
	declare v_headerGlossaries nvarchar(4000);
	declare v_cnt int;

	-- cursor variables	
	DECLARE CURSOR curs FOR
	SELECT distinct PMX_PLLI."LineNum", "WUK_4004_PMX".PMX_W_OPENGLOSSARIES."Text"
			FROM PMX_PLHE
			JOIN PMX_PLLI ON PMX_PLHE."DocEntry" = PMX_PLLI."DocEntry"
			JOIN "WUK_4004_PMX".PMX_W_OPENGLOSSARIES ON "WUK_4004_PMX".PMX_W_OPENGLOSSARIES."ItemCode" = PMX_PLLI."ItemCode"
			AND ("WUK_4004_PMX".PMX_W_OPENGLOSSARIES."CardCode" IS NULL OR "WUK_4004_PMX".PMX_W_OPENGLOSSARIES."CardCode" = PMX_PLHE."CardCode")
			WHERE PMX_PLHE."DocEntry" = :p_pickListDocEntry
			AND PMX_PLLI."LineStatus" NOT IN ('C', 'F');
		
	DECLARE CURSOR curs2 FOR
	SELECT distinct "WUK_4004_PMX".PMX_W_OPENGLOSSARIES."Text"
			FROM PMX_PLHE
			JOIN "WUK_4004_PMX".PMX_W_OPENGLOSSARIES ON "WUK_4004_PMX".PMX_W_OPENGLOSSARIES."CardCode" = PMX_PLHE."CardCode"
				AND "WUK_4004_PMX".PMX_W_OPENGLOSSARIES."ItemCode" IS NULL
			WHERE PMX_PLHE."DocEntry" = :p_pickListDocEntry;
			
	declare v_numAtCardList nvarchar(4000);
	declare v_carrierList nvarchar(4000);

	v_glossarySeparator := '\r\n';
	
	--CREATE TABLE "WUK_4004_PMX"."TMP_LinesGlossaries" (LineNum int, Text nvarchar(max))
	DELETE FROM "WUK_4004_PMX"."TMP_LinesGlossaries";
	
	v_headerGlossaries := '';


	OPEN curs;
	FETCH curs INTO v_lineNum, v_text;
	WHILE v_lineNum IS NOT NULL DO
		SELECT COUNT(1) INTO v_cnt FROM "WUK_4004_PMX"."TMP_LinesGlossaries" WHERE LineNum = v_lineNum;
		IF (v_cnt > 0) THEN
			UPDATE "WUK_4004_PMX"."TMP_LinesGlossaries" SET Text = Text || v_glossarySeparator || v_text WHERE LineNum = v_lineNum;
		ELSE
			INSERT INTO "WUK_4004_PMX"."TMP_LinesGlossaries" (LineNum, Text) VALUES (v_lineNum, v_text);
		END IF;
		FETCH curs INTO v_lineNum, v_text;
	END WHILE;
	CLOSE curs;

	OPEN curs2;
	FETCH curs2 INTO v_text;
	WHILE NOT curs2::NOTFOUND DO 
		IF (LENGTH(v_headerGlossaries) > 0) THEN
			v_headerGlossaries := v_headerGlossaries || v_glossarySeparator;
		END IF;
		v_headerGlossaries := v_headerGlossaries || v_text;
		FETCH curs2 INTO v_text;
	END WHILE;
	CLOSE curs2;

	--SELECT * FROM "WUK_4004_PMX"."TMP_LinesGlossaries"
	--SELECT v_headerGlossaries



	/* Select v_numAtCardList = substring(
        (
            Select distinct ', ' || IFNULL(ORDR.NumAtCard, IFNULL(CAST(OWTQ."DocNum" as nvarchar(20)), ORDR2.NumAtCard))  AS [text()]
            From PMX_PLLI
			LEFT JOIN   PMX_PLPL ON PMX_PLPL."DocEntry" = PMX_PLLI."BaseEntry" and PMX_PLPL."LineNum" = PMX_PLLI."BaseLine" and 'PMX_PLPH' = PMX_PLLI."BaseType"
			LEFT JOIN	ORDR ON PMX_PLPL."BaseEntry" = ORDR."DocEntry" and PMX_PLPL."BaseType" = '17'
			LEFT JOIN	OWTQ ON PMX_PLPL."BaseEntry" = OWTQ."DocEntry" and PMX_PLPL."BaseType" = '1250000001'
			LEFT JOIN	OWOR ON PMX_PLPL."BaseEntry" = OWOR."DocEntry" and PMX_PLPL."BaseType" = '202'
			LEFT JOIN	ORDR ORDR2 ON OWOR."OriginAbs" = ORDR2."DocEntry"
			WHERE PMX_PLLI."DocEntry" = p_pickListDocEntry
			AND   PMX_PLLI."LineStatus" NOT IN ('C', 'F')
			and IFNULL(IFNULL(ORDR.NumAtCard, IFNULL(CAST(OWTQ."DocNum" as nvarchar(20)), ORDR2.NumAtCard)), '') <> ''
            For XML PATH ('')
        ), 3, 1000) 

	Select v_carrierList = substring(
        (
            Select distinct ', ' || IFNULL(ORDR."U_GT_Carrier", OWTQ."U_GT_Carrier")  AS [text()]
            From PMX_PLLI
			LEFT JOIN   PMX_PLPL ON PMX_PLPL."DocEntry" = PMX_PLLI."BaseEntry" and PMX_PLPL."LineNum" = PMX_PLLI."BaseLine" and 'PMX_PLPH' = PMX_PLLI."BaseType"
			LEFT JOIN	ORDR ON PMX_PLPL."BaseEntry" = ORDR."DocEntry" and PMX_PLPL."BaseType" = '17'
			LEFT JOIN	OWTQ ON PMX_PLPL."BaseEntry" = OWTQ."DocEntry" and PMX_PLPL."BaseType" = '1250000001'
			WHERE PMX_PLLI."DocEntry" = p_pickListDocEntry
			AND   PMX_PLLI."LineStatus" NOT IN ('C', 'F')
			AND IFNULL(IFNULL(ORDR."U_GT_Carrier", OWTQ."U_GT_Carrier"), '') <> ''
            For XML PATH ('')
        ), 3, 1000) */

    SELECT      PMX_PLHE."DocEntry", PMX_PLHE."WaveKey", PMX_PLHE."CardCode", PMX_PLHE."CardName", ORDR."ShipToCode", PMX_PLHE."ShipToAddress", PMX_OSEL_1."Name" AS "Dock", 
                PMX_PLHE."DueDate", PMX_PLHE."Priority", IFNULL(OWTQ."PickRmrk",'') || ' ' || cast(PMX_PLHE."PickPackRemarks" as nvarchar(4000)) as "PickPackRemarks",
				PickListLines."ItemCode", PickListLines."Dscription", 
                PickListLines."Quantity", PickListLines."Uom", PickListLines."QualityStatusCode",
                PMX_LUID."SSCC", PMX_OSSL."Name" AS "PickLocation", IFNULL(PMX_OSSL."Sequence", 999999999) AS "Sequence", OSCN."Substitute" as "CatalogNo",
                v_headerGlossaries as "HeaderGlossaries", "WUK_4004_PMX"."TMP_LinesGlossaries".Text as "LineGlossaries", "Weights"."WeightInKG", v_numAtCardList as "NumAtCard",
                v_carrierList as "Carrier", OHEM."officeExt", CASE WHEN OWOR."DocEntry" IS NULL THEN NULL ELSE 'ATELIER' END as "Subtitle"
    FROM        (
		SELECT PMX_PLLI."DocEntry", PMX_PLLI."LineStatus", PMX_PLLI."ItemCode", PMX_PLLI."Dscription", PMX_PLLI."StorLocCode", PMX_PLLI."LogUnitIdentKey",
        PMX_PLLI."Uom", PMX_PLLI."QualityStatusCode", PMX_PLLI."BaseEntry", PMX_PLLI."BaseType",
		SUM(PMX_PLLI."Quantity") as "Quantity", MIN(PMX_PLLI."LineNum") as "LineNum", MIN(PMX_PLLI."BaseLine") as "BaseLine"
		FROM PMX_PLLI
		WHERE PMX_PLLI."DocEntry" = p_pickListDocEntry
		GROUP BY PMX_PLLI."DocEntry", PMX_PLLI."LineStatus", PMX_PLLI."ItemCode", PMX_PLLI."Dscription", PMX_PLLI."StorLocCode", PMX_PLLI."LogUnitIdentKey",
        PMX_PLLI."Uom", PMX_PLLI."QualityStatusCode", PMX_PLLI."BaseEntry", PMX_PLLI."BaseType"
		) AS PickListLines
	INNER JOIN PMX_PLHE ON PMX_PLHE."DocEntry" = PickListLines."DocEntry"
    INNER JOIN  PMX_OSEL AS PMX_OSEL_1 ON PMX_PLHE."DestStorLocCode" = PMX_OSEL_1."Code"
    LEFT JOIN   PMX_OSSL ON PickListLines."StorLocCode" = PMX_OSSL."Code"
    LEFT JOIN   PMX_LUID ON PickListLines."LogUnitIdentKey" = PMX_LUID."InternalKey"
    LEFT JOIN   OSCN ON OSCN."CardCode" = PMX_PLHE."CardCode" and OSCN."ItemCode" = PickListLines."ItemCode"
    LEFT JOIN  PMX_PLPL ON PMX_PLPL."DocEntry" = PickListLines."BaseEntry" and PMX_PLPL."LineNum" = PickListLines."BaseLine" and 'PMX_PLPH' = PickListLines."BaseType"
    LEFT JOIN	ORDR ON PMX_PLPL."BaseEntry" = ORDR."DocEntry" and PMX_PLPL."BaseType" = '17'
    LEFT JOIN	OWTQ ON PMX_PLPL."BaseEntry" = OWTQ."DocEntry" and PMX_PLPL."BaseType" = '1250000001'
    --LEFT JOIN   WTQ1 ON PMX_PLPL."BaseEntry" = WTQ1."DocEntry" and PMX_PLPL."BaseLine" = WTQ1."LineNum" and PMX_PLPL."BaseType" = '1250000001'
    LEFT JOIN	OWOR ON PMX_PLPL."BaseEntry" = OWOR."DocEntry" and PMX_PLPL."BaseType" = '202'
    LEFT JOIN   "WUK_4004_PMX"."TMP_LinesGlossaries" ON "WUK_4004_PMX"."TMP_LinesGlossaries".LineNum = PickListLines."LineNum"
    LEFT JOIN   OHEM on OHEM."empID" = ORDR."OwnerCode"
    LEFT JOIN   (SELECT PLHE2."DocEntry" as "DocEntry", SUM(PLLI2."Quantity" * OITM."SWeight1" * OWGT."WightInMG") / 1000000 as "WeightInKG"
		FROM PMX_PLHE PLHE2
		INNER JOIN PMX_PLLI PLLI2 ON PLHE2."DocEntry" = PLLI2."DocEntry"
		INNER JOIN OITM ON PLLI2."ItemCode" = OITM."ItemCode"
		INNER JOIN OWGT ON OITM."SWght1Unit" = OWGT."UnitCode"
		GROUP BY PLHE2."DocEntry") AS "Weights" ON "Weights"."DocEntry" = PMX_PLHE."DocEntry"
    WHERE PickListLines."DocEntry" = p_pickListDocEntry
    AND   PickListLines."LineStatus" NOT IN ('C', 'F')
    ORDER BY "Sequence", PMX_OSSL."Code";
    
	--DROP TABLE "WUK_4004_PMX"."TMP_LinesGlossaries"
	
END