CREATE PROCEDURE "PMX_SP_ShippingLabelWeg"(
	-- Parameters for the stored procedure
	p_luid int
	)
LANGUAGE SQLSCRIPT
AS
BEGIN

	--Declare return variables
	DECLARE v_returnSSCC nvarchar(18);
	DECLARE v_returnGTIN  nvarchar (16) ;
	DECLARE v_returnLogisticCarrierCode  nvarchar (20) ; 
	DECLARE v_returnItemCode  nvarchar(20) ;
	DECLARE v_returnProductDescription  nvarchar(100) ;
	DECLARE v_returnQuantity  numeric(19,6) ;
	DECLARE v_returnIsLogisticUnit  nvarchar(1) ;
	DECLARE v_returnIsLogisticCarrier  nvarchar(1) ;
	DECLARE v_returnBatchNumber  nvarchar(32) ;
	DECLARE v_returnBestBeforeDate  datetime;
	DECLARE v_returnSSCCBarcode  nvarchar (100);
	DECLARE v_returnSSCCBarcodeDigit  nvarchar (100);
	DECLARE v_returnGTINBarcode  nvarchar (200);
	DECLARE v_returnGTINBarcodeDigit  nvarchar (200);
 	DECLARE v_returnBarcodeType  nvarchar (1);
	DECLARE v_returnGTINLabel  nvarchar (20);
	DECLARE v_returnPackagingTypeText  nvarchar (4000);
	DECLARE v_returnQuantityByPackagingTypeText  nvarchar (4000);
	DECLARE v_returnBatchNumber2  nvarchar(32) ;
	DECLARE v_returnLocationCode  nvarchar(50) ;


	--Getting the PO info
	--Declare variables for the cursor
	DECLARE v_PurchaseDocNum  int;
	DECLARE v_SupplierName  nvarchar (100) ;
	DECLARE v_SupplierAddress  nvarchar (254)  ;
	DECLARE v_ReceptionDate  datetime ;


	--Declare variables for product
	DECLARE v_GTIN  nvarchar (16) ;
	DECLARE v_LogisticCarrierCode  nvarchar (20)  ;
	DECLARE v_ProductDescription  nvarchar(100) ;
	DECLARE v_IsLogisticCarrier  nvarchar(1) ;
	DECLARE v_BarcodeType  nvarchar (1);
	DECLARE v_TempPackagingTypeText  nvarchar (4000);
	DECLARE v_TempQuantityByPackagingTypeText  nvarchar (4000);


	DECLARE v_weightDecimals  INT;
	DECLARE v_weightAI  nvarchar(3) ;
	DECLARE v_tempWeightDecimals  INT;
	DECLARE v_tempWeightAI  nvarchar(3) ;
	DECLARE v_tempQuantityUom2  numeric(19,6) ;

	DECLARE v_sscc nvarchar (18);
	DECLARE v_itemCode nvarchar (20);
	DECLARE v_quantity numeric (19,6);
	DECLARE v_bestBeforeDate datetime;
	DECLARE v_batchNumber nvarchar (32);
	DECLARE v_purchaseDocObjType nvarchar(20);
	DECLARE v_purchaseDocEntry int;
	DECLARE v_cardCode nvarchar (15);
	DECLARE v_packagingTypeText nvarchar(4000);
	DECLARE v_quantityByPackagingTypeText nvarchar(4000);
	DECLARE v_locationCode nvarchar (50);
	DECLARE v_batchNumber2 nvarchar (32);
	DECLARE v_quantityUom2 numeric (19,6);
	DECLARE v_internalLuid int;

	DECLARE v_cnt int;
    DECLARE v_itriKey int;

		DECLARE CURSOR productsCursor FOR SELECT SSCC, GTIN, LogisticCarrierCode, ItemCode, ProductDescription, Quantity , IsLogisticCarrier, 
			BatchNumber, BestBeforeDate, BarcodeType, PackagingTypesText, QuantityByPackagingTypeText, BatchNumber2, LocationCode, 
			0, Uom2Decimals, Uom2AI
			FROM "WUK_4004_PMX"."TMP_TN_ProductsOnSSCC";

DELETE FROM "WUK_4004_PMX"."TMP_TN_ProductsOnSSCC";
DELETE FROM "WUK_4004_PMX"."TMP_TN_GOODSRECEIPTLABELPRODUCTSTABLE";
DELETE FROM "WUK_4004_PMX"."TMP_TN_SHIPPINGLABELCONTENTS";

		-- Insert the products into an in memory table
		INSERT into "WUK_4004_PMX"."TMP_TN_ProductsOnSSCC"
			SELECT SSCC, Barcode, "LogisticCarrierCode", "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."ItemCode", IFNULL(ProductDescription, 
			"WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."ItemCode") AS ProductDescription, "Quantity" , IsLogisticCarrier, "BatchNumber", "BestBeforeDate",
			IFNULL(U_PMX_BCTY,'G') AS BarcodeType, '',
			'',
			"WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."InternalBatchNumber", "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."StorLocCode", -1,
			"WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."QuantityUom2", U_PMX_UM2D, U_PMX_U2MT || '0'		
			FROM "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL INNER JOIN OITM ON OITM."ItemCode" = "WUK_4004_PMX".PMX_SSCC_GOODSRECEIPT_LABEL."ItemCode"
			WHERE "LogUnitIdentKey" = :p_luid
			ORDER BY IsLogisticCarrier, "ItemCode";

		--Loop tru all the lines
		OPEN productsCursor;
		FETCH  productsCursor INTO v_SSCC, v_GTIN, v_LogisticCarrierCode, v_ItemCode, v_ProductDescription, v_Quantity , v_IsLogisticCarrier, 
		v_BatchNumber, v_BestBeforeDate, v_BarcodeType, v_TempPackagingTypeText, v_TempQuantityByPackagingTypeText, v_batchNumber2, v_locationCode, 
		v_tempQuantityUom2, v_tempWeightDecimals, v_tempWeightAI;
		WHILE v_ItemCode IS NOT NULL DO
			v_returnSSCC := v_SSCC;
			v_returnGTIN := v_GTIN;
			v_returnLogisticCarrierCode := v_LogisticCarrierCode;
			v_returnItemCode := v_ItemCode;
			v_returnProductDescription := v_ProductDescription;
			v_returnQuantity := v_Quantity;
			v_returnIsLogisticUnit := v_IsLogisticCarrier;
			v_returnBatchNumber := v_BatchNumber;
			v_returnBestBeforeDate := v_BestBeforeDate;
			v_returnBarcodeType := v_BarcodeType;
			v_returnPackagingTypeText := v_TempPackagingTypeText;
			v_returnQuantityByPackagingTypeText := v_TempQuantityByPackagingTypeText;
			v_returnLocationCode := v_locationCode;
			v_weightAI := v_tempWeightAI;
			v_weightDecimals := v_tempWeightDecimals;
			v_quantityUom2 := v_tempQuantityUom2;
			
		IF v_returnBestBeforeDate IS NULL THEN v_returnBestBeforeDate := '1899-12-31'; END IF;
		IF v_returnQuantity IS NULL THEN v_returnQuantity := -1; END IF;
		IF v_quantityUom2 IS NULL THEN v_quantityUom2 := -1; END IF;
		IF v_tempWeightDecimals IS NULL THEN v_tempWeightDecimals := -1; END IF;

        --Set the barcodes
		SELECT barcode     INTO v_returnSSCCBarcode      FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1Barcode"      ( :v_returnSSCC, NULL, NULL, NULL, '1899-12-31', NULL, -1, -1, -1, NULL, 'Ê' );
		SELECT barcodeText INTO v_returnSSCCBarcodeDigit FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1BarcodeDigit" ( :v_returnSSCC, NULL, NULL, NULL, '1899-12-31', NULL, -1, -1, -1, NULL );
		SELECT barcode     INTO v_returnGTINBarcode      FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1Barcode"      ( NULL, :v_returnGTIN, :v_returnIsLogisticCarrier, :v_returnBarcodeType, :v_returnBestBeforeDate, :v_returnBatchNumber, :v_returnQuantity, :v_quantityUom2, :v_tempWeightDecimals, :v_tempWeightAI, 'Ê' );
		SELECT barcodeText INTO v_returnGTINBarcodeDigit FROM "WUK_4004_PMX"."PMX_FN_GenerateGS1BarcodeDigit" ( NULL, :v_returnGTIN, :v_returnIsLogisticCarrier, :v_returnBarcodeType, :v_returnBestBeforeDate, :v_returnBatchNumber, :v_returnQuantity, :v_quantityUom2, :v_tempWeightDecimals, :v_tempWeightAI );

        IF v_returnIsLogisticCarrier = 'Y' THEN
            v_returnGTINLabel := 'GTIN';
        ELSE 
            v_returnGTINLabel := 'CONTENT';
        END IF;


		/*SELECT COUNT(1) INTO v_cnt
			FROM "WUK_4004_PMX".PMX_DELIVERY_INFO_LABEL
			WHERE "LogUnitIdentKey" = p_luid;
		IF v_cnt > 0 THEN
			SELECT TOP 1 PurchaseDocObjType,   PurchaseDocNum,   SupplierName,   SupplierAddress,   ReceptionDate
			INTO       v_PurchaseDocObjType, v_PurchaseDocNum, v_SupplierName, v_SupplierAddress, v_ReceptionDate
			FROM "WUK_4004_PMX".PMX_DELIVERY_INFO_LABEL
			WHERE "LogUnitIdentKey" = p_luid
			ORDER BY PurchaseDocNum DESC;
		END IF;*/

			INSERT INTO "WUK_4004_PMX"."TMP_TN_SHIPPINGLABELCONTENTS" 
			--Return the values
			SELECT	v_returnSSCC, 	
					IFNULL(v_returnGTIN,'N/A') ,
					IFNULL(v_returnProductDescription,'N/A') , 
					IFNULL(CAST (CAST(v_returnQuantity AS real) AS nvarchar),'N/A') ,
					IFNULL(v_returnBatchNumber,'N/A') , 
					IFNULL( TO_NVARCHAR(v_returnBestBeforeDate, 'DD/MM/YYYY'),'N/A')  ,
					v_returnSSCCBarcode ,
					v_returnSSCCBarcodeDigit ,
					v_returnGTINBarcode ,
					v_returnGTINBarcodeDigit ,
					v_PurchaseDocObjType ,
					IFNULL( CAST( v_PurchaseDocNum AS nvarchar),'N/A') ,
					IFNULL(v_SupplierName,'N/A') ,
					IFNULL(v_SupplierAddress,'N/A') ,
					IFNULL( TO_NVARCHAR(v_ReceptionDate, 'DD/MM/YYYY'),'N/A') ,
					v_returnGTINLabel ,
					v_returnPackagingTypeText ,
					v_returnQuantityByPackagingTypeText ,
					v_returnBatchNumber2 , 
					v_returnLocationCode ,
					v_itemCode FROM DUMMY;

			FETCH productsCursor INTO v_SSCC, v_GTIN, v_LogisticCarrierCode, v_ItemCode, v_ProductDescription, v_Quantity , v_IsLogisticCarrier, 
			v_BatchNumber, v_BestBeforeDate, v_BarcodeType, v_TempPackagingTypeText, v_TempQuantityByPackagingTypeText, v_batchNumber2, v_locationCode, 
			v_tempQuantityUom2, v_tempWeightDecimals, v_tempWeightAI;
		END WHILE;

		CLOSE productsCursor ;

		SELECT list.*, IFNULL(ordr."CardCode", OWTQ."CardCode") as "CardCode", IFNULL(ordr."CardName", OWTQ."CardName") as "CardName", ORDR."DocNum" as "DocNum", ORDR."NumAtCard" as "NumAtCard",
			'' as "Carrier", ORDR."DocDueDate" as "SODueDate", "QryGroup62" as "PrintSODueDate",
			shippingSSCC."WaveKey", shippingSSCC.PickListDocEntry, ORDR."ShipToCode", ORDR."Address2" as "ShippingAddress", shippingSSCC."Quantity" as "MoveQuantity"
		FROM "WUK_4004_PMX"."TMP_TN_SHIPPINGLABELCONTENTS" as list
		join (SELECT     PMX_LUID.SSCC, PMX_PLHE."ShipToAddress", IFNULL(ORDR."CardName", OINV."CardName") AS ShipTo, ordr."DocEntry" as SODocEntry, owtq."DocEntry" as TRDocEntry, OITM."ItemName" AS ProductDescription, 
                      PMX_MVLI."Quantity", OITM."CodeBars" AS Barcode, PMX_ITRI."BatchNumber", PMX_ITRI."BestBeforeDate", PMX_PLHE."DueDate" AS DepartureDate, 
                      PMX_LUID."InternalKey" AS LUID, PMX_LUID."LogisticCarrierCode", PMX_MVLI."ItemCode", IFNULL(OITM.U_PMX_LOCA, 'N') AS IsLogisticCarrier, 
                      PMX_MVLI."QuantityUom2", PMX_PLHE."WaveKey", PMX_PLHE."DocEntry" as PickListDocEntry
			FROM      PMX_LPLM INNER JOIN
                      PMX_PLLI INNER JOIN
                      PMX_PLHE ON PMX_PLLI."DocEntry" = PMX_PLHE."DocEntry" ON PMX_LPLM."PickListDocEntry" = PMX_PLHE."DocEntry" AND 
                      PMX_LPLM."PickListLineNum" = PMX_PLLI."LineNum" AND PMX_PLLI."LineStatus" = 'O' INNER JOIN
                      OITM INNER JOIN
                      PMX_LUID INNER JOIN
                      PMX_MVLI ON PMX_LUID."InternalKey" = PMX_MVLI."DestLogUnitIdentKey" ON OITM."ItemCode" = PMX_MVLI."ItemCode" ON 
                      PMX_LPLM."MoveDocEntry" = PMX_MVLI."DocEntry" AND PMX_LPLM."MoveLineNum" = PMX_MVLI."LineNum" INNER JOIN
                      PMX_PLPL ON PMX_PLPL."DocEntry" = PMX_PLLI."BaseEntry" AND PMX_PLPL."LineNum" = PMX_PLLI."BaseLine" AND 
                      PMX_PLLI."BaseType" = 'PMX_PLPH' LEFT JOIN
                      OINV ON PMX_PLPL."BaseType" = OINV."ObjType" AND PMX_PLPL."BaseEntry" = OINV."DocEntry" LEFT JOIN
                      ORDR ON ORDR."DocEntry" = PMX_PLPL."BaseEntry" AND ORDR."ObjType" = PMX_PLPL."BaseType" LEFT JOIN
					  OWTQ on OWTQ."DocEntry" = PMX_PLPL."BaseEntry" and OWTQ."ObjType" = PMX_PLPL."BaseType" LEFT JOIN
                      PMX_ITRI ON PMX_MVLI."ItemTransactionalInfoKey" = PMX_ITRI."InternalKey") as shippingSSCC on list.sscc = shippingSSCC.sscc and list.itemcode = shippingSSCC."ItemCode"
		left join ordr on ORDR."DocEntry" = shippingSSCC.SODocEntry
		left join owtq on owtq."DocEntry" = shippingSSCC.TRDocEntry
		left join ocrd on OCRD."CardCode" = ORDR."CardCode";

END