﻿using System.Globalization;
using System.Reflection;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Sbo.Logex.Data.DataObjects;
using System.Collections.Generic;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Foundation.Messages;
using System.Data;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.Data;
using Produmex.Foundation.Data.Sbo.Generators.BarcodeController;
using Produmex.Foundation.Data.Sbo;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Foundation;
using System.Transactions;
using System;
using Produmex.Foundation.Barcode;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Sbo.Logex.Weg.Data.Providers;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Sbo.Logex.WEG.Data.BusinessObjects.Definitions.Tables;
using System.Collections.ObjectModel;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_AfterQuantityProducedHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_AfterQuantityProducedHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger( MethodInfo.GetCurrentMethod().DeclaringType );
        ISboProviderService sboProviderService;

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<Collection<string>> ListOfSerialNumbers;
        public ReadOnlyBinder<List<InventoryItemInfo>> ProducedItems; // filled in by ProductionReceipt flow
        public ReadOnlyBinder<List<int>> CreatedLUIDs; // filled in by Production flow
        public ReadOnlyBinder<int?> ProdOrderDocEntry;

        // Output parameters * do not change *
        // <none>

        // Sub-flows
        // <none>

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_AfterQuantityProducedHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_AfterQuantityProducedHookScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base( parent, factory )
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter( "Session" ) as Session;
            sboProviderService = GetScopeParameter( "<WwfService>ISboService" ) as ISboProviderService;

            string initialErrorKey = null;
            string deviceID = session.DeviceInstanceId;
            object[] initialErrorParams = null;
            bool initialErrorKeyIsError = true;
            Message msg = null;
            IBarcodeController barcodeController = null;
            ProdumexError pmxError = null;
            bool serialNumbersInUppercase = false;
            PmxItemInfo ItemInfo;
            string itemCode = null;
            bool askReprint = false;
            string productionLineCode = null;
			bool rescanSerialNumbers = false;

            DataSet dsSerialNumber = GetNewSerialNumberDataSet();

            barcodeController = this.ExecuteMethodWithDbConnection<IBarcodeController>( out pmxError, false, false,
            delegate( PmxDbConnection conn, object[] parameters )
            {
                PmxBarcodeProvider bcProv = new PmxBarcodeProvider( conn );
                PmxSerialNumberProvider senuProv = new PmxSerialNumberProvider( conn );

                serialNumbersInUppercase = senuProv.AllwaysEnterInUppercase();

                return bcProv.GetBarcodeController();


            } );

            //itemCode = "ITEM01";
            //productionLineCode = "ProdL3"; //U_PMX_PLCD

            string query = BuildQuery.GetProductionCodes( ProdOrderDocEntry, sboProviderService.GetDbTool() );
            DataSet dsProduction = sboProviderService.RunView( false, null, null, query );

            if ( this.GetNumberOfRows( dsProduction ) > 0 )
            {
                itemCode = Convert.ToString( dsProduction.Tables[ 0 ].Rows[ 0 ][ ProductionOrderDataSet.Columns.ITEMCODE.Name ] );
                productionLineCode = Convert.ToString( dsProduction.Tables[ 0 ].Rows[ 0 ][ PmxProductionOrderTable.Columns.ProductionLineCode.NAME ] );
            }

            ItemInfo = sboProviderService.InvokeMethodWithDbConnection<PmxItemInfo>( false, false, null, null, new DelegateWithPmxDbConnection<PmxItemInfo>( ExecuteGetItemInfo ), itemCode );


        Step_EnterSerialNumber:
            #region ENTER_SERIAL_NUMBER

            // automatically fill in serial numbers to print if they were already captured during production
            Collection<string> listOfSerialNumbers = null;
            if ( ListOfSerialNumbers != null ) listOfSerialNumbers = ListOfSerialNumbers.Get();

            if ( ( listOfSerialNumbers == null || listOfSerialNumbers.Count == 0 )
					&& ( ItemInfo.HasSAPSerialNumber || ItemInfo.HasSerialNumber ) )
            {
                listOfSerialNumbers = new Collection<string>();
                List<int> createdLuids = new List<int>();
                if ( CreatedLUIDs != null && CreatedLUIDs.Get().Count > 0 )
                {
                    foreach ( int createdLUID in CreatedLUIDs.Get() )
                    {
                        if ( !createdLuids.Contains( createdLUID ) ) createdLuids.Add( createdLUID );
                    }
                }
                else if ( ProducedItems != null && ProducedItems.Get().Count > 0 )
                {
                    foreach ( InventoryItemInfo invItemInfo in ProducedItems.Get() )
                    {
                        if ( invItemInfo.LogisticUnitIdentKey.HasValue )
                        {
                            if ( !createdLuids.Contains( invItemInfo.LogisticUnitIdentKey.Value ) ) createdLuids.Add( invItemInfo.LogisticUnitIdentKey.Value );
                        }
                    }
                }

                try
                {
                    sboProviderService.InvokeMethodWithDbConnection<object>( false, false, null, null,
                    delegate( PmxDbConnection conn, object[] parameters2 )
                    {
                        foreach ( int createdLUID in createdLuids )
                        {
                            PmxSerialNumberProvider senuProv = new PmxSerialNumberProvider();
                            query = Produmex.Sbo.Logex.Data.SboCommands.GetQueryGetSerialNumberKey( itemCode, new Collection<SerialNumberInfo>(), null,false, null, createdLUID, conn.DbTool);
                            using ( ISboRecordset rs = SboRecordsetHelper.RunQuery( s_log, query, conn ) )
                            {
                                while ( !rs.EoF )
                                {
                                    string serialNumber = rs.GetTypedValue<string>( PmxSerialNumberTable.Columns.SerialNumber.NAME );
                                    listOfSerialNumbers.Add( serialNumber );
                                    rs.MoveNext();
                                }
                            }

                        }
                        return null;
                    } );
                }
                catch ( Exception ex )
                {
                    s_log.Error( ex.ToString() );
                    session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen ),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "InitialErrorKey", initialErrorKey,
                            "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                            "MessageAddendum", ex.Message,
                            "PmxError", Produmex.Sbo.Logex.Data.ProdumexErrors.UnexpectedError( s_log, ex ),
                            "ShowButton", true ) );

                    msg = WaitForMessage();
                }
            }

            if ( !rescanSerialNumbers && listOfSerialNumbers != null && listOfSerialNumbers.Count > 0 )
            {
                // serial numbers were provided during production
                foreach ( string serialNumber in listOfSerialNumbers )
                {
                    DataRow[] foundRows = dsSerialNumber.Tables[0].Select( string.Format( "{0} = '{1}'", SerialNumberDataSet.Columns.SERIALNUMBER.Name, serialNumber ) );
                    if ( foundRows.Length <= 0 )
                    {
                        DataRow rowToAdd = dsSerialNumber.Tables[0].NewRow();
                        rowToAdd[SerialNumberDataSet.Columns.SERIALNUMBER.Name] = serialNumber;
                        dsSerialNumber.Tables[0].Rows.InsertAt( rowToAdd, 0 );
                    }
                }
            }
            else
            {
                // no serial numbers were provided during production - capture them now
                session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IIdentifyMultipleSerialNumberScreen ),
                     DefaultCultureInfo.Get(), BuildParamCollection(
                         "InitialErrorKey", initialErrorKey,
                         "InitialErrorParams", initialErrorParams,
                         "InitialErrorKeyIsError", initialErrorKeyIsError,
                         "TitleKey", "MSG_TITLE_IDENTIFY_SERIAL_NUMBER",
                         "SerialNumberDS", dsSerialNumber,
                         "ItemDescription", ItemInfo.CustomItemDescription,
                         "ItemCode", ItemInfo.ItemCode,
                         "ItemBarcode", ItemInfo.CodeBars,
                    //"UOM", uomForSerial,
                    //"BatchNumber", BatchNumber.Get(),
                    //"BestBeforeDate", BestBeforeDate.Get(),
                    //"SSCC", SSCC.Get(),
                    //"DocNum", DocNum.Get(),
                    //"StillToQuantity", stillToQuantityForSerial,
                    //"MessageKeyStillQuantity", MessageKeyStillQuantity.Get(),
                    //"UseSerialNumberRange", useRange,
                    //"ShowListButton", (currentListOfSerialNumbersToUse != null && currentListOfSerialNumbersToUse.Count > 0),
                         "UseUppercase", serialNumbersInUppercase//,
                    //"MessageKeyBatchnumber", MessageKeyBatchnumber == null ? null : MessageKeyBatchnumber.Get()

                                 ) );
                msg = WaitForMessage();

                initialErrorKey = null;
                initialErrorKeyIsError = true;
                initialErrorParams = null;

                if ( msg.Name.EndsWith( ".BackRequested" ) )
                {
                    //Go back
                    //BackRequested.Set( true );
                    return;
                }

                if ( msg.Name.EndsWith( ".SerialNumberScanned" ) )
                {
                    string serialNumber = ExtractParameter<string>( msg.Parameters, "serialNumber" );

                    //parse through controller
                    if ( barcodeController != null )
                    {
                        BarcodeContainer bc;
                        try
                        {
                            bc = barcodeController.GetSerialNumber( serialNumber, null );
                        }
                        catch ( Exception ex )
                        {
                            s_log.Error( "Barcode GetSerialNumber() ", ex );
                            initialErrorKey = "MSG_ERROR_INCORRECT_BARCODE";
                            initialErrorKeyIsError = true;
                            goto Step_EnterSerialNumber;
                        }
                        if ( !string.IsNullOrEmpty( bc.SerialNumber ) )
                        {
                            serialNumber = bc.SerialNumber;

                            //check if correct data was scanned
                            if ( !string.IsNullOrEmpty( bc.ItemCode ) &&
                                bc.ItemCode != ItemInfo.ItemCode )
                            {
                                //incorrect item
                                initialErrorParams = new object[3] { serialNumber, ItemInfo.ItemCode, bc.ItemCode };
                                initialErrorKey = "MSG_ERROR_SERIAL_NUMBER_NOT_MATCHES_NEEDED_ITEM";
                                goto Step_EnterSerialNumber;
                            }

                        }
                    }
                    DataRow[] foundRows = dsSerialNumber.Tables[0].Select( string.Format( "{0} = '{1}'", SerialNumberDataSet.Columns.SERIALNUMBER.Name, serialNumber ) );
                    if ( foundRows.Length > 0 )
                    {
                        initialErrorKey = "MSG_ERROR_SERIAL_NUMBER_ALREADY_SCANNED";
                    }
                    else
                    {
                        DataRow rowToAdd = dsSerialNumber.Tables[0].NewRow();
                        rowToAdd[SerialNumberDataSet.Columns.SERIALNUMBER.Name] = serialNumber;
                        dsSerialNumber.Tables[0].Rows.InsertAt( rowToAdd, 0 );
                    }
                    goto Step_EnterSerialNumber;
                }

                if ( msg.Name.EndsWith( ".DeleteSerialNumber" ) )
                {
                    string serialNumberToDelete = ExtractParameter<string>( msg.Parameters, "serialNumber" );

                    DataRow[] rows = dsSerialNumber.Tables[0].Select( string.Format( "{0} = '{1}'", SerialNumberDataSet.Columns.SERIALNUMBER.Name, serialNumberToDelete ) );
                    foreach ( DataRow row in rows )
                    {
                        dsSerialNumber.Tables[0].Rows.Remove( row );
                    }
                    dsSerialNumber.AcceptChanges();
                    goto Step_EnterSerialNumber;
                }

                if ( msg.Name.EndsWith( ".StopRequested" ) )
                {
                    goto Step_PrintLabels;
                }
            }
            #endregion

        Step_PrintLabels:
            #region PRINT_LABELS

            sboProviderService.InvokeMethodWithDbConnection<object>( false, false, null, null,
            delegate( PmxDbConnection conn, object[] parameters2 )
            {
                PmxPrintReportProvider prov = new PmxPrintReportProvider( conn );

                for ( int i = 0; i < dsSerialNumber.Tables[0].Rows.Count; i++ )
                {
                    string serialNumber = dsSerialNumber.Tables[0].Rows[i][SerialNumberDataSet.Columns.SERIALNUMBER.Name].ToString();
                    prov.PrintItemLabel( itemCode, null, null, null, new List<string> { serialNumber}, SboObjectTypes.ProductionOrder, ProdOrderDocEntry, null, 1, 1, ItemInfo.InventoryUom, deviceID, null, null, null, null );
                }
                return null;
            } );

            try
            {
				Collection<string> serialNumbers = new Collection<string>();
				for (int i = 0; i < dsSerialNumber.Tables[0].Rows.Count; i++)
				{
					serialNumbers.Add(dsSerialNumber.Tables[0].Rows[i][SerialNumberDataSet.Columns.SERIALNUMBER.Name].ToString());
				}

				sboProviderService.InvokeMethodWithDbConnection<object>(true, false, null, null,
                  delegate( PmxDbConnection conn, object[] parameters )
                  {
					  PmxWegGeneralProvider prov = new PmxWegGeneralProvider(conn);
					  prov.AddUpdateSerialNumbersUDO(this.ProdOrderDocEntry.Get().Value, 0, itemCode, serialNumbers);

                      return null;
                  } );
            }
            catch ( Exception ex )
            {
                s_log.Error( ex.ToString() );
                session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IShowMessageScreen ),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                        "InitialErrorKey", initialErrorKey,
                        "MessageKey", KnownMessageKeys.MSG_ERROR_INTERNAL_ERROR,
                        "MessageAddendum", ex.Message,
                        "PmxError", Produmex.Sbo.Logex.Data.ProdumexErrors.UnexpectedError( s_log, ex ),
                        "ShowButton", true ) );
                msg = WaitForMessage();

				session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IDecisionScreen),
					DefaultCultureInfo.Get(), BuildParamCollection(
						"TitleKey", "MSG_TITLE_ERROR_TRY_AGAIN",
						"MessageKey", "MSG_QUESTION_ERROR_SERIAL_NUMBER_LABELS_PRINTING_TRY_AGAIN"));
				msg = WaitForMessage();
				if (msg.Name.EndsWith(".Yes"))
				{
					goto Step_PrintLabels;
				}
			}


            #endregion

        Step_DocumentsPrinted:
            #region DOCUMENTS_PRINTED
            string[] buttonKeys = new string[ 3 ] { "MSG_BUTTON_DO_NOT_REPRINT", "MSG_BUTTON_REPRINT_ALL", "MSG_BUTTON_REENTER_SERIAL_NUMBERS" };

            //ToolBarButtons toolBarButtons = ToolBarButtons.Back;

            session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.ISelectButtonScreen ),
                    DefaultCultureInfo.Get(), BuildParamCollection(
                    "InitialErrorKey", initialErrorKey,
                    "TitleKey", "MSG_TITLE_REPRINT_LABEL",
                    "AllowedButtons", buttonKeys//,
                //"EnabledToolBarButtons", toolBarButtons
                    ) );
            msg = WaitForMessage();
            initialErrorKey = null;

            if ( msg.Name.EndsWith( ".ButtonClicked" ) )
            {
                string filterButtonKey = ExtractParameter<string>( msg.Parameters, "buttonKey" );

                if ( filterButtonKey == "MSG_BUTTON_REPRINT_ALL" )
                {
                    goto Step_PrintLabels;
                }

                if ( filterButtonKey == "MSG_BUTTON_REENTER_SERIAL_NUMBERS" )
                {
					rescanSerialNumbers = true;
					goto Step_EnterSerialNumber;
                }

                if ( filterButtonKey == "MSG_BUTTON_DO_NOT_REPRINT" )
                {
                    //do nothing
                    //return;
                }
            }


            #endregion

        }

        #endregion

        #region HELPERS

        /// <summary>
        /// Gets the new Serial number data set.
        /// </summary>
        /// <returns></returns>
        private DataSet GetNewSerialNumberDataSet()
        {
            DataSet ds = new DataSet();
            ds.Tables.Add( SerialNumberDataSet.NAME );

            foreach ( ColumnDefinition colDef in SerialNumberDataSet.Columns.ALL )
            {
                ds.Tables[ 0 ].Columns.Add( colDef.Name, colDef.Types[ 0 ] );
            }

            return ds;

        }

        /// <summary>
        /// Executes the get item info.
        /// </summary>
        /// <param name="conn">The conn.</param>
        /// <param name="parameters">The parameters.</param>
        /// <returns></returns>
        private static PmxItemInfo ExecuteGetItemInfo( PmxDbConnection conn, object[] parameters )
        {
            PmxItemAllConnectionsProvider prov = new PmxItemAllConnectionsProvider( conn );
            return prov.GetCachedItemInfo( (string)parameters[ 0 ] );
        }

        private T ExecuteMethodWithDbConnection<T>( out ProdumexError pmxError, bool useSboConnection, bool useUserNameOfConnectionString, DelegateWithPmxDbConnection<T> methodDelegate, params object[] parameters )
        {
            T result = default( T );
            pmxError = null;

            try
            {
                result = sboProviderService.InvokeMethodWithDbConnection<T>( useSboConnection, useUserNameOfConnectionString, null, null,
                    methodDelegate, parameters );
            }
            catch ( TargetInvocationException ex )
            {
                MethodInfo methodInfo = methodDelegate.Method;
                if ( ex.InnerException is ProdumexException )
                {
                    s_log.Warn( "Execute -- The invoked method threw a produmex exception: ", ex.InnerException );
                    pmxError = ((ProdumexException)ex.InnerException).Error;
                }
                else if ( ex.InnerException == null )
                {
                    s_log.Warn( "Execute -- The invoked method threw an exception: ", ex );
                    pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod( s_log, methodInfo, ex.Message );
                }
                else
                {
                    s_log.Warn( "Execute -- The invoked method threw a TargetInvocationException with inner exception: ", ex.InnerException );
                    pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod( s_log, methodInfo, ex.InnerException.Message );
                }
            }
            catch ( TransactionAbortedException ex )
            {
                MethodInfo methodInfo = methodDelegate.Method;
                pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod( s_log, methodInfo, ex.InnerException == null ? ex.Message : ex.InnerException.Message );
            }
            catch ( ProdumexException ex )
            {
                if ( ex.Error != null )
                {
                    pmxError = ex.Error;
                }
                else
                {
                    MethodInfo methodInfo = methodDelegate.Method;
                    pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod( s_log, methodInfo, ex.Message );
                }
            }
            catch ( Exception ex )
            {
                s_log.Error( "", ex );
                MethodInfo methodInfo = methodDelegate.Method;
                pmxError = Produmex.Foundation.Wwf.Sbo.ProdumexErrors.ExceptionInvokingSboMethod( s_log, methodInfo, ex.Message );
            }

            return result;
        }

        /// <summary>
        /// Gets the number of rows.
        /// </summary>
        /// <param name="ds">The ds.</param>
        /// <returns></returns>
        private int GetNumberOfRows( DataSet ds )
        {
            if ( ds != null && ds.Tables.Count > 0 )
            {
                return ds.Tables[ 0 ].Rows.Count;
            }
            return 0;
        }


        #endregion

        #region QUERY

        private class BuildQuery
        {
            public static string GetProductionCodes( int? prdDocEntry, DbTool dbTool )
            {
                /*select ItemCode, U_PMX_PLCD from OWOR where DocEntry = 50*/
                DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();

                strBuilder.AppendFormat( "SELECT {0}, {1} FROM {2}  ",
                    SqlCommandHelper.EscapeTableColumnName( PmxProductionOrderTable.NAME, PmxProductionOrderTable.Columns.ItemCode.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxProductionOrderTable.NAME, PmxProductionOrderTable.Columns.ProductionLineCode.NAME ),
                    SqlCommandHelper.EscapeTableName( PmxProductionOrderTable.NAME ) );

                strBuilder.AppendFormat( " WHERE {0} = {1} ",
                    SqlCommandHelper.EscapeTableColumnName( PmxProductionOrderTable.NAME, PmxProductionOrderTable.Columns.DocEntry.NAME ),
                    SqlCommandHelper.FormatAndEscapeColumnValue( prdDocEntry.Value, CultureInfo.InvariantCulture ) );

                return strBuilder.ToString();
            }
        }

        #endregion
    }
}
