﻿using System.Globalization;
using System.Reflection;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Sbo.Logex.Data.Providers;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using System.Collections.Generic;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects.Definitions;
using System.Text;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using System.Data;
using System;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.SlimScreen.Interfaces;
using Produmex.Sbo.Logex.Weg.Data.Providers;
using Produmex.Foundation.Messages;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_BeforeProductionOrderClosedHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_BeforeProductionOrderClosedHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger( MethodInfo.GetCurrentMethod().DeclaringType );

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<int?> ProductionOrderDocEntry;

        // Output parameters * do not change *
        public ReadWriteBinder<bool> BackRequested;

        // Sub-flows
        // <none>

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_BeforeProductionOrderClosedHookScript"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_BeforeProductionOrderClosedHookScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base( parent, factory )
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter( "Session" ) as Session;
            ISboProviderService sboProviderService = GetScopeParameter( "<WwfService>ISboService" ) as ISboProviderService;
            int capturedTime = 0;
            string operatorName = null;

            Message msg = null;
            string initialErrorKey = null;

            bool captureProductionTime = false;
			bool captureProductionOperator = false;

            sboProviderService.InvokeMethodWithDbConnection<object>( true, false, null, null,
              delegate( PmxDbConnection conn, object[] parameters )
              {
                  PmxWegGeneralProvider wegProv = new PmxWegGeneralProvider( (SboConnection)conn );
                  Dictionary<string, PmxParameterValue> plcParams = wegProv.GetParametersWegController();

                  captureProductionTime = PmxParameterValueProvider.GetParameterValue<bool>( plcParams, PmxWegExtensionParameterCodes.CAPTURE_PRODUCTION_TIME, false );
				  captureProductionOperator = PmxParameterValueProvider.GetParameterValue<bool>(plcParams, PmxWegExtensionParameterCodes.CAPTURE_PRODUCTION_OPERATOR, false);

                  return null;
              } );

		Step_EnterTime:
            if ( captureProductionTime ) 
            {
                if ( ProductionOrderDocEntry.Get().HasValue )
                {
                    session.ShowScreen( typeof( Produmex.Foundation.SlimScreen.Interfaces.IEnterQuantityScreen ),
                        DefaultCultureInfo.Get(), BuildParamCollection(
                            "InitialErrorKey", initialErrorKey,
                            "TitleKey", "MSG_TITLE_WEG_ENTER_CAPTURED_PRODUCTION_TIME",
                            "InitialQuantity", 0,
                            "NumberOfDigitsAfterDecimal", 0,
                            "MaximumQuantity", -1
                           ) );

                    initialErrorKey = null;
                    msg = WaitForMessage();

                    if ( msg.Name.EndsWith( ".QuantityEntered" ) )
                    {
                        capturedTime = Convert.ToInt32( ExtractParameter<double>( msg.Parameters, "quantity" ) );

						sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
                        delegate(PmxDbConnection conn, object[] parameters)
					   {
						   PmxWegProductionProvider prodProv = new PmxWegProductionProvider(conn);
						   prodProv.UpdateProductionTime(ProductionOrderDocEntry.Get().Value, capturedTime);
						   return null;
					   });
                    }
                }
            }

		Step_EnterOperator:
			if (captureProductionOperator)
			{
				if (ProductionOrderDocEntry.Get().HasValue)
				{
					session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.IEnterStringValueScreen),
					   DefaultCultureInfo.Get(), BuildParamCollection(
						   "InitialErrorKey", initialErrorKey,
						   "TitleKey", "MSG_TITLE_WEG_ENTER_OPERATOR",
						   "AllowToGoBack", true,
						   "ForceDataEntry", true
						  ));

					initialErrorKey = null;
					msg = WaitForMessage();

					if (msg.Name.EndsWith(".StringEntered"))
					{
						operatorName = ExtractParameter<string>(msg.Parameters, "stringValue");

						sboProviderService.InvokeMethodWithDbConnection<object>(false, false, null, null,
					   delegate(PmxDbConnection conn, object[] parameters)
					   {
						   PmxWegProductionProvider prodProv = new PmxWegProductionProvider(conn);
						   prodProv.UpdateProductionOperator(ProductionOrderDocEntry.Get().Value, operatorName);
						   return null;
					   });
					}
					else if (msg.Name.EndsWith(".BackRequested") && captureProductionTime)
					{
						//goBack = true;
						goto Step_EnterTime;
					}
					else { }
				}
			}

        }

        #endregion

    }
}
