﻿using System.Globalization;
using System.Reflection;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Foundation.Diagnostics;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using System.Collections.ObjectModel;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using System.Text;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects.Definitions.Tables;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions.Tables;
using Produmex.Foundation.Data.Sbo.BusinessObjects.Definitions.Tables;
using System.Data;
using Produmex.Foundation.Data.Sbo.Providers;
using Produmex.Foundation.Data.Sbo.BusinessObjects;
using System;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_EnterSerialNumbersForFullPalletPickingHookScript
{
    /// <summary>
    /// This is a hook script, meant to be customized on a "per project" basis
    /// </summary>
    public class WorkflowScript_EnterSerialNumbersForFullPalletPickingHookScript : WorkflowInstanceScriptBase
    {
        private static readonly ILog s_log = LogProvider.GetLogger( MethodInfo.GetCurrentMethod().DeclaringType );

        // Input parameters * do not change *
        public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
        public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
        public ReadOnlyBinder<Collection<string>> ListOfSerialNumbers;
        public ReadOnlyBinder<int?> ItriKey;
        public ReadOnlyBinder<int?> Luid;

        // Output parameters * do not change *
        public ReadWriteBinder<bool> SerialNumbersSelected;
        public ReadWriteBinder<bool> BackRequested;

        // Sub-flows
        // <none>

        public const string U_PMX_SSCC = "U_PMX_SSCC";

        /// <summary>
        /// Initializes a new instance of the <see cref="WorkflowScript_EnterSerialNumbersForFullPalletPicking"/> class.
        /// </summary>
        /// <param name="parent">The parent.</param>
        /// <param name="factory">The factory.</param>
        public WorkflowScript_EnterSerialNumbersForFullPalletPickingHookScript( WorkflowInstanceBase parent, WorkflowInstanceFactory factory )
            : base( parent, factory )
        {
        }

        #region WorkflowInstanceScriptBase Members

        protected override void Execute()
        {
            // Parameters in scope
            Session session = GetScopeParameter("Session") as Session;
            ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

            string serialNumber = null;
            SerialNumbersSelected.Set( false );

            if ( Luid.Get().HasValue )
            {
                string query = BuildQuery.GetSerialNumbers( Luid.Get().Value );
                DataSet dsSerialNumbers = sboProviderService.RunView(false, null, null, query);

                foreach (DataRow row in dsSerialNumbers.Tables[0].Rows)
                {
                    serialNumber = Convert.ToString(row[PmxWegSerialBatchTable.Columns.U_SerialNo.NAME ]);
                    //ListOfSerialNumbers.Get().Add( serialNumber );
                }

                if ( ListOfSerialNumbers != null && ListOfSerialNumbers.Get() != null && ListOfSerialNumbers.Get().Count > 0 )
                {
                    SerialNumbersSelected.Set( true );
                }
            }
        }

        #endregion

        #region QUERY

		/// <summary>
		/// Static class grouping our native queries
		/// </summary>
        private class BuildQuery
        {
            public static string GetSerialNumbers( int luid )
            {
                /*select "@SERBAT".U_SerialNo from "@SERBAT" 
                join "@SHIPMENTLINES" on "@SHIPMENTLINES".DocEntry = "@SERBAT".U_DocEntry and "@SHIPMENTLINES".LineId = "@SERBAT".U_LineId
                join PMX_LUID on PMX_LUID.SSCC = "@SHIPMENTLINES".U_HU
                where PMX_LUID.InternalKey = {}*/

                StringBuilder strBuilder = new StringBuilder();
                strBuilder.AppendFormat( " SELECT {0} FROM {1} ",
                    SqlCommandHelper.EscapeTableColumnName(PmxWegSerialBatchTable.NAME,PmxWegSerialBatchTable.Columns.U_SerialNo.NAME),
                    SqlCommandHelper.EscapeTableName(PmxWegSerialBatchTable.NAME));
                strBuilder.AppendFormat( "\r\n INNER JOIN {0} ON {1} = {2} AND {3} = {4} ",
                    SqlCommandHelper.EscapeTableName( PmxWegShipmentLinesTable.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxWegShipmentLinesTable.NAME, PmxWegShipmentLinesTable.Columns.DocEntry.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxWegSerialBatchTable.NAME, PmxWegSerialBatchTable.Columns.DocEntry.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxWegShipmentLinesTable.NAME, PmxWegShipmentLinesTable.Columns.LineId.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxWegSerialBatchTable.NAME, PmxWegSerialBatchTable.Columns.U_LineId.NAME ) );
                strBuilder.AppendFormat( " \r\n INNER JOIN {0} ON {1} = {2} ",
                    SqlCommandHelper.EscapeTableName( PmxLogisticUnitIDTable.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.SSCC.NAME ),
                    SqlCommandHelper.EscapeTableColumnName( PmxWegShipmentLinesTable.NAME, PmxWegShipmentLinesTable.Columns.U_HU.NAME ) );
                strBuilder.AppendFormat( " \r\n WHERE {0} = {1} ",
                    SqlCommandHelper.EscapeTableColumnName( PmxLogisticUnitIDTable.NAME, PmxLogisticUnitIDTable.Columns.InternalKey.NAME ),
                    luid );

                return strBuilder.ToString();
            }

        }
        #endregion
    }
}
