﻿using System;
using System.Collections.Generic;
using System.Text;
using Produmex.Foundation.Workflows;
using Produmex.Foundation.Diagnostics;
using System.Reflection;
using Produmex.Foundation.Workflows.Parameters;
using Produmex.Foundation.SlimScreen;
using Produmex.Foundation.Wwf.Sbo.LocalServices;
using Produmex.Foundation.Messages;
using Produmex.Foundation.Data.DbClient;
using Produmex.Foundation.Data.SqlClient;
using Produmex.Sbo.Logex.Weg.Data.BusinessObjects.Definitions.Tables;
using System.Data;
using Produmex.Sbo.Logex.Weg.Data.Providers;
using System.Globalization;
using Produmex.Foundation.Data.Sbo.DataObjects;
using Produmex.Sbo.Logex.Data.BusinessObjects;
using Produmex.Foundation.Data.Sbo;
using Produmex.Foundation.SlimScreen.Interfaces.Definitions.KnownDataSets;
using Produmex.Foundation.Data.Sbo.Utilities;
using Produmex.Sbo.Logex.Data.BusinessObjects.Definitions;

// PmxWorkflowExecutionTypes.HOOK_FLOW
namespace WorkflowScript_SalesDeliveryCreatedHookScript.WEG
{

	/// <summary>
	/// 
	/// </summary>
	/// <seealso cref="Produmex.Foundation.Workflows.WorkflowInstanceScriptBase" />
	public class WorkflowScript_SalesDeliveryCreatedHookScript : WorkflowInstanceScriptBase
	{
		private static readonly ILog s_log = LogProvider.GetLogger(MethodInfo.GetCurrentMethod().DeclaringType);
		public const string U_GT_CALT = "@GT_CALT";

		// Input parameters * do not change *
		public ReadOnlyBinder<CultureInfo> DefaultCultureInfo;
		public ReadOnlyBinder<PmxOseCompany> PmxOseCompany;
		public ReadOnlyBinder<DocumentRef[]> DocumentRefs;

		// Output parameters
		// <none>

		// Sub-flows
		// <none>

		/// <summary>
		/// Initializes a new instance of the <see cref="WorkflowScript_SalesDeliveryCreatedHookScript"/> class.
		/// </summary>
		/// <param name="parent">The parent.</param>
		/// <param name="factory">The factory.</param>
		public WorkflowScript_SalesDeliveryCreatedHookScript(WorkflowInstanceBase parent, WorkflowInstanceFactory factory)
			: base(parent, factory)
		{
		}

		#region WorkflowInstanceScriptBase Members

		protected override void Execute()
		{
			// Parameters in scope
			Session session = GetScopeParameter("Session") as Session;
			ISboProviderService sboProviderService = GetScopeParameter("<WwfService>ISboService") as ISboProviderService;

			Message msg = null;
			DataSet dsCarriers = null;
			string carrier = null;
			string query = null;
			string initialErrorKey = null;

			query = BuildQuery.GetAllCarriers(sboProviderService.GetDbTool());
			dsCarriers = sboProviderService.RunView(false, null, null, query);

			foreach (DocumentRef docRef in DocumentRefs.Get())
			{
                //Only do it for sales delivery!
                if (docRef.DocType == SboObjectTypes.SalesDelivery)
                {
                Step_SelectCarrier:
                    if (dsCarriers.Tables[0].Rows.Count > 0)
                    {
                        session.ShowScreen(typeof(Produmex.Foundation.SlimScreen.Interfaces.ISelectCustomerScreen),
                            this.DefaultCultureInfo, BuildParamCollection(
                            "InitialErrorKey", initialErrorKey,
                            "TitleKey", "MSG_TITLE_SELECT_CUSTOMER_PALLET",
                            "CustomerDS", dsCarriers
                            ));
                        msg = WaitForMessage();
                        initialErrorKey = null;

                        if (msg.Name == "Produmex.Foundation.SlimScreen.Interfaces.ISelectCustomerScreenReply.CustomerSelected")
                        {
                            carrier = ExtractParameter<string>(msg.Parameters, "customerCode");

                            sboProviderService.InvokeMethodWithDbConnection<object>(true, false, null, null,
                            delegate (PmxDbConnection conn, object[] parameters)
                            {
                                PmxWegGeneralProvider prodProv = new PmxWegGeneralProvider(conn);
                                prodProv.InsertSelectedCarrier(docRef.DocEntry, carrier);

                                return null;
                            });
                        }
                        else if (msg.Name.EndsWith(".BackRequested"))
                        {
                            //Back is not supported
                            goto Step_SelectCarrier;
                        }
                        else
                        { }
                    }
                }
			}
		}

		#endregion

		#region BuildQuery

		private class BuildQuery
		{
			public static string GetAllCarriers(DbTool dbTool)
			{
				DbQueryBuilder strBuilder = dbTool.GetQueryBuilder();

				strBuilder.AppendFormat("SELECT {0}, {1} FROM {2}  ",
					SqlCommandHelper.EscapeTableColumnNameWithAlias(U_GT_CALT, "Code", CustomerDataSet.Columns.CUSTOMER_CODE.Name),
					SqlCommandHelper.EscapeTableColumnNameWithAlias(U_GT_CALT, "Name", CustomerDataSet.Columns.CUSTOMER_NAME.Name),
					SqlCommandHelper.EscapeTableName(U_GT_CALT));

				return strBuilder.ToString();
			}
		}

		#endregion
	}
}
